# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `mdl` gem.
# Please instead update this file by running `bin/tapioca gem mdl`.

# source://mdl-0.11.0/lib/mdl/kramdown_parser.rb:6
module Kramdown
  class << self
    # Return the data directory for kramdown.
    #
    # source://kramdown-2.4.0/lib/kramdown/document.rb:49
    def data_dir; end
  end
end

# This module contains all available parsers. A parser takes an input string and converts the
# string to an element tree.
#
# New parsers should be derived from the Base class which provides common functionality - see its
# API documentation for how to create a custom converter class.
#
# source://mdl-0.11.0/lib/mdl/kramdown_parser.rb:7
module Kramdown::Parser; end

# modified parser class - see comment above
#
# source://mdl-0.11.0/lib/mdl/kramdown_parser.rb:9
class Kramdown::Parser::MarkdownLint < ::Kramdown::Parser::Kramdown
  # @return [MarkdownLint] a new instance of MarkdownLint
  #
  # source://mdl-0.11.0/lib/mdl/kramdown_parser.rb:10
  def initialize(source, options); end
end

# Regular kramdown parser, but with GFM style fenced code blocks
#
# source://mdl-0.11.0/lib/mdl/kramdown_parser.rb:18
Kramdown::Parser::MarkdownLint::FENCED_CODEBLOCK_MATCH = T.let(T.unsafe(nil), Regexp)

# The kramdown version.
#
# source://kramdown-2.4.0/lib/kramdown/version.rb:13
Kramdown::VERSION = T.let(T.unsafe(nil), String)

# Primary MDL container
#
# source://mdl-0.11.0/lib/mdl/cli.rb:4
module MarkdownLint
  class << self
    # source://mdl-0.11.0/lib/mdl.rb:14
    def run(argv = T.unsafe(nil)); end
  end
end

# Our Mixlib::CLI class
#
# source://mdl-0.11.0/lib/mdl/cli.rb:6
class MarkdownLint::CLI
  include ::Mixlib::CLI
  extend ::Mixlib::CLI::ClassMethods
  extend ::Mixlib::CLI::InheritMethods

  # source://mdl-0.11.0/lib/mdl/cli.rb:110
  def run(argv = T.unsafe(nil)); end

  class << self
    # source://mdl-0.11.0/lib/mdl/cli.rb:164
    def probe_config_file(path); end

    # source://mdl-0.11.0/lib/mdl/cli.rb:147
    def toggle_list(parts, to_sym = T.unsafe(nil)); end
  end
end

# source://mdl-0.11.0/lib/mdl/cli.rb:9
MarkdownLint::CLI::CONFIG_FILE = T.let(T.unsafe(nil), String)

# our Mixlib::Config class
#
# source://mdl-0.11.0/lib/mdl/config.rb:5
module MarkdownLint::Config
  extend ::Mixlib::Config

  class << self
    # source://mixlib-config-3.0.27/lib/mixlib/config.rb:34
    def config_context_hashes; end

    # source://mixlib-config-3.0.27/lib/mixlib/config.rb:34
    def config_context_hashes=(_arg0); end

    # source://mixlib-config-3.0.27/lib/mixlib/config.rb:33
    def config_context_lists; end

    # source://mixlib-config-3.0.27/lib/mixlib/config.rb:33
    def config_context_lists=(_arg0); end

    # source://mixlib-config-3.0.27/lib/mixlib/config.rb:32
    def config_contexts; end

    # source://mixlib-config-3.0.27/lib/mixlib/config.rb:32
    def config_contexts=(_arg0); end

    # source://mixlib-config-3.0.27/lib/mixlib/config.rb:35
    def config_parent; end

    # source://mixlib-config-3.0.27/lib/mixlib/config.rb:35
    def config_parent=(_arg0); end

    # source://mixlib-config-3.0.27/lib/mixlib/config.rb:31
    def configurables; end

    # source://mixlib-config-3.0.27/lib/mixlib/config.rb:31
    def configurables=(_arg0); end

    # source://mixlib-config-3.0.27/lib/mixlib/config.rb:30
    def configuration; end

    # source://mixlib-config-3.0.27/lib/mixlib/config.rb:30
    def configuration=(_arg0); end

    # source://mixlib-config-3.0.27/lib/mixlib/config.rb:667
    def style(*args, &block); end

    # source://mixlib-config-3.0.27/lib/mixlib/config.rb:663
    def style=(value); end
  end
end

# Representation of the markdown document passed to rule checks
#
# source://mdl-0.11.0/lib/mdl/doc.rb:7
class MarkdownLint::Doc
  # Create a new document given a string containing the markdown source
  #
  # @return [Doc] a new instance of Doc
  #
  # source://mdl-0.11.0/lib/mdl/doc.rb:29
  def initialize(text, ignore_front_matter = T.unsafe(nil)); end

  # Returns the actual source line for a given element. You can pass in an
  # element object or an options hash here. This is useful if you need to
  # examine the source line directly for your rule to make use of
  # information that isn't present in the parsed document.
  #
  # source://mdl-0.11.0/lib/mdl/doc.rb:133
  def element_line(element); end

  # Returns the line number a given element is located on in the source
  # file. You can pass in either an element object or an options hash here.
  #
  # source://mdl-0.11.0/lib/mdl/doc.rb:122
  def element_linenumber(element); end

  # Returns a list of line numbers for all elements passed in. You can pass
  # in a list of element objects or a list of options hashes here.
  #
  # source://mdl-0.11.0/lib/mdl/doc.rb:141
  def element_linenumbers(elements); end

  # Returns the actual source lines for a list of elements. You can pass in
  # a list of elements objects or a list of options hashes here.
  #
  # source://mdl-0.11.0/lib/mdl/doc.rb:149
  def element_lines(elements); end

  # A list of raw markdown source lines. Note that the list is 0-indexed,
  # while line numbers in the parsed source are 1-indexed, so you need to
  # subtract 1 from a line number to get the correct line. The element_line*
  # methods take care of this for you.
  #
  # source://mdl-0.11.0/lib/mdl/doc.rb:14
  def elements; end

  # Extracts the text from an element whose children consist of text
  # elements and other things
  #
  # source://mdl-0.11.0/lib/mdl/doc.rb:243
  def extract_text(element, prefix = T.unsafe(nil), restore_whitespace = T.unsafe(nil)); end

  # Find all elements of a given type, returning their options hash. The
  # options hash has most of the useful data about an element and often you
  # can just use this in your rules.
  #
  #   # Returns [ { :location => 1, :element_level => 2 }, ... ]
  #   elements = find_type(:li)
  #
  # If +nested+ is set to false, this returns only top level elements of a
  # given type.
  #
  # source://mdl-0.11.0/lib/mdl/doc.rb:65
  def find_type(type, nested = T.unsafe(nil)); end

  # Find all elements of a given type, returning a list of the element
  # objects themselves.
  #
  # Instead of a single type, a list of types can be provided instead to
  # find all types.
  #
  # If +nested+ is set to false, this returns only top level elements of a
  # given type.
  #
  # source://mdl-0.11.0/lib/mdl/doc.rb:79
  def find_type_elements(type, nested = T.unsafe(nil), elements = T.unsafe(nil)); end

  # A variation on find_type_elements that allows you to skip drilling down
  # into children of specific element types.
  #
  # Instead of a single type, a list of types can be provided instead to
  # find all types.
  #
  # Unlike find_type_elements, this method will always search for nested
  # elements, and skip the element types given to nested_except.
  #
  # source://mdl-0.11.0/lib/mdl/doc.rb:101
  def find_type_elements_except(type, nested_except = T.unsafe(nil), elements = T.unsafe(nil)); end

  # Returns the header 'style' - :atx (hashes at the beginning), :atx_closed
  # (atx header style, but with hashes at the end of the line also), :setext
  # (underlined). You can pass in the element object or an options hash
  # here.
  #
  # source://mdl-0.11.0/lib/mdl/doc.rb:159
  def header_style(header); end

  # Returns how much a given line is indented. Hard tabs are treated as an
  # indent of 8 spaces. You need to pass in the raw string here.
  #
  # source://mdl-0.11.0/lib/mdl/doc.rb:204
  def indent_for(line); end

  # A list of raw markdown source lines. Note that the list is 0-indexed,
  # while line numbers in the parsed source are 1-indexed, so you need to
  # subtract 1 from a line number to get the correct line. The element_line*
  # methods take care of this for you.
  #
  # source://mdl-0.11.0/lib/mdl/doc.rb:14
  def lines; end

  # Returns the list style for a list: :asterisk, :plus, :dash, :ordered or
  # :ordered_paren depending on which symbol is used to denote the list
  # item. You can pass in either the element itself or an options hash here.
  #
  # source://mdl-0.11.0/lib/mdl/doc.rb:181
  def list_style(item); end

  # Returns line numbers for lines that match the given regular expression
  #
  # source://mdl-0.11.0/lib/mdl/doc.rb:211
  def matching_lines(regex); end

  # Returns line numbers for lines that match the given regular expression.
  # Only considers text inside of 'text' elements (i.e. regular markdown
  # text and not code/links or other elements).
  #
  # source://mdl-0.11.0/lib/mdl/doc.rb:222
  def matching_text_element_lines(regex, exclude_nested = T.unsafe(nil)); end

  # A list of raw markdown source lines. Note that the list is 0-indexed,
  # while line numbers in the parsed source are 1-indexed, so you need to
  # subtract 1 from a line number to get the correct line. The element_line*
  # methods take care of this for you.
  #
  # source://mdl-0.11.0/lib/mdl/doc.rb:14
  def offset; end

  # A list of raw markdown source lines. Note that the list is 0-indexed,
  # while line numbers in the parsed source are 1-indexed, so you need to
  # subtract 1 from a line number to get the correct line. The element_line*
  # methods take care of this for you.
  #
  # source://mdl-0.11.0/lib/mdl/doc.rb:14
  def parsed; end

  private

  # Adds a 'level' and 'parent' option to all elements to show how nested they
  # are
  #
  # source://mdl-0.11.0/lib/mdl/doc.rb:275
  def add_annotations(elements, level = T.unsafe(nil), parent = T.unsafe(nil)); end

  class << self
    # Alternate 'constructor' passing in a filename
    #
    # source://mdl-0.11.0/lib/mdl/doc.rb:46
    def new_from_file(filename, ignore_front_matter = T.unsafe(nil)); end
  end
end

# defines a single rule
#
# source://mdl-0.11.0/lib/mdl/ruleset.rb:3
class MarkdownLint::Rule
  # @return [Rule] a new instance of Rule
  #
  # source://mdl-0.11.0/lib/mdl/ruleset.rb:6
  def initialize(id, description, block); end

  # source://mdl-0.11.0/lib/mdl/ruleset.rb:25
  def aliases(*aliases); end

  # source://mdl-0.11.0/lib/mdl/ruleset.rb:15
  def check(&block); end

  # Returns the value of attribute description.
  #
  # source://mdl-0.11.0/lib/mdl/ruleset.rb:4
  def description; end

  # Sets the attribute description
  #
  # @param value the value to set the attribute description to.
  #
  # source://mdl-0.11.0/lib/mdl/ruleset.rb:4
  def description=(_arg0); end

  # Returns the value of attribute id.
  #
  # source://mdl-0.11.0/lib/mdl/ruleset.rb:4
  def id; end

  # Sets the attribute id
  #
  # @param value the value to set the attribute id to.
  #
  # source://mdl-0.11.0/lib/mdl/ruleset.rb:4
  def id=(_arg0); end

  # source://mdl-0.11.0/lib/mdl/ruleset.rb:30
  def params(params = T.unsafe(nil)); end

  # source://mdl-0.11.0/lib/mdl/ruleset.rb:20
  def tags(*tags); end
end

# defines a ruleset
#
# source://mdl-0.11.0/lib/mdl/ruleset.rb:37
class MarkdownLint::RuleSet
  # @return [RuleSet] a new instance of RuleSet
  #
  # source://mdl-0.11.0/lib/mdl/ruleset.rb:40
  def initialize; end

  # source://mdl-0.11.0/lib/mdl/ruleset.rb:48
  def load(rules_file); end

  # source://mdl-0.11.0/lib/mdl/ruleset.rb:53
  def load_default; end

  # source://mdl-0.11.0/lib/mdl/ruleset.rb:44
  def rule(id, description, &block); end

  # Returns the value of attribute rules.
  #
  # source://mdl-0.11.0/lib/mdl/ruleset.rb:38
  def rules; end
end

# defines a style
#
# source://mdl-0.11.0/lib/mdl/style.rb:5
class MarkdownLint::Style
  # @return [Style] a new instance of Style
  #
  # source://mdl-0.11.0/lib/mdl/style.rb:8
  def initialize(all_rules); end

  # source://mdl-0.11.0/lib/mdl/style.rb:24
  def all; end

  # source://mdl-0.11.0/lib/mdl/style.rb:41
  def exclude_rule(id); end

  # source://mdl-0.11.0/lib/mdl/style.rb:50
  def exclude_tag(tag); end

  # source://mdl-0.11.0/lib/mdl/style.rb:28
  def rule(id, params = T.unsafe(nil)); end

  # Returns the value of attribute rules.
  #
  # source://mdl-0.11.0/lib/mdl/style.rb:6
  def rules; end

  # source://mdl-0.11.0/lib/mdl/style.rb:46
  def tag(tag); end

  class << self
    # source://mdl-0.11.0/lib/mdl/style.rb:54
    def load(style_file, rules); end
  end
end

# source://mdl-0.11.0/lib/mdl/version.rb:2
MarkdownLint::VERSION = T.let(T.unsafe(nil), String)
