# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `html-pipeline` gem.
# Please instead update this file by running `bin/tapioca gem html-pipeline`.

# source://html-pipeline-2.14.2/lib/html/pipeline.rb:6
module HTML; end

# GitHub HTML processing filters and utilities. This module includes a small
# framework for defining DOM based content filters and applying them to user
# provided content.
#
# See HTML::Pipeline::Filter for information on building filters.
#
# Construct a Pipeline for running multiple HTML filters.  A pipeline is created once
# with one to many filters, and it then can be `call`ed many times over the course
# of its lifetime with input.
#
# filters         - Array of Filter objects. Each must respond to call(doc,
#                   context) and return the modified DocumentFragment or a
#                   String containing HTML markup. Filters are performed in the
#                   order provided.
# default_context - The default context hash. Values specified here will be merged
#                   into values from the each individual pipeline run.  Can NOT be
#                   nil.  Default: empty Hash.
# result_class    - The default Class of the result object for individual
#                   calls.  Default: Hash.  Protip:  Pass in a Struct to get
#                   some semblance of type safety.
#
# source://html-pipeline-2.14.2/lib/html/pipeline.rb:27
class HTML::Pipeline
  # @raise [ArgumentError]
  # @return [Pipeline] a new instance of Pipeline
  #
  # source://html-pipeline-2.14.2/lib/html/pipeline.rb:90
  def initialize(filters, default_context = T.unsafe(nil), result_class = T.unsafe(nil)); end

  # Apply all filters in the pipeline to the given HTML.
  #
  # html    - A String containing HTML or a DocumentFragment object.
  # context - The context hash passed to each filter. See the Filter _docs
  #           for more info on possible values. This object MUST NOT be modified
  #           in place by filters.  Use the Result for passing state back.
  # result  - The result Hash passed to each filter for modification.  This
  #           is where Filters store extracted information from the content.
  #
  # Returns the result Hash after being filtered by this Pipeline.  Contains an
  # :output key with the DocumentFragment or String HTML markup based on the
  # output of the last filter in the pipeline.
  #
  # source://html-pipeline-2.14.2/lib/html/pipeline.rb:110
  def call(html, context = T.unsafe(nil), result = T.unsafe(nil)); end

  # Internal: Default payload for instrumentation.
  #
  # Accepts a Hash of additional payload data to be merged.
  #
  # Returns a Hash.
  #
  # source://html-pipeline-2.14.2/lib/html/pipeline.rb:183
  def default_payload(payload = T.unsafe(nil)); end

  # Public: Returns an Array of Filter objects for this Pipeline.
  #
  # source://html-pipeline-2.14.2/lib/html/pipeline.rb:72
  def filters; end

  # Internal: if the `instrumentation_service` object is set, instruments the
  # block, otherwise the block is ran without instrumentation.
  #
  # Returns the result of the provided block.
  #
  # source://html-pipeline-2.14.2/lib/html/pipeline.rb:170
  def instrument(event, payload = T.unsafe(nil)); end

  # source://html-pipeline-2.14.2/lib/html/pipeline.rb:80
  def instrumentation_name; end

  # Public: String name for this Pipeline. Defaults to Class name.
  #
  # source://html-pipeline-2.14.2/lib/html/pipeline.rb:79
  def instrumentation_name=(_arg0); end

  # Public: Instrumentation service for the pipeline.
  # Set an ActiveSupport::Notifications compatible object to enable.
  #
  # source://html-pipeline-2.14.2/lib/html/pipeline.rb:76
  def instrumentation_service; end

  # Public: Instrumentation service for the pipeline.
  # Set an ActiveSupport::Notifications compatible object to enable.
  #
  # source://html-pipeline-2.14.2/lib/html/pipeline.rb:76
  def instrumentation_service=(_arg0); end

  # Internal: Applies a specific filter to the supplied doc.
  #
  # The filter is instrumented.
  #
  # Returns the result of the filter.
  #
  # source://html-pipeline-2.14.2/lib/html/pipeline.rb:130
  def perform_filter(filter, doc, context, result); end

  # Public: setup instrumentation for this pipeline.
  #
  # Returns nothing.
  #
  # source://html-pipeline-2.14.2/lib/html/pipeline.rb:160
  def setup_instrumentation(name = T.unsafe(nil), service = T.unsafe(nil)); end

  # Like call but guarantee the value returned is a DocumentFragment.
  # Pipelines may return a DocumentFragment or a String. Callers that need a
  # DocumentFragment should use this method.
  #
  # source://html-pipeline-2.14.2/lib/html/pipeline.rb:141
  def to_document(input, context = T.unsafe(nil), result = T.unsafe(nil)); end

  # Like call but guarantee the value returned is a string of HTML markup.
  #
  # source://html-pipeline-2.14.2/lib/html/pipeline.rb:147
  def to_html(input, context = T.unsafe(nil), result = T.unsafe(nil)); end

  class << self
    # Public: Default instrumentation service for new pipeline objects.
    #
    # source://html-pipeline-2.14.2/lib/html/pipeline.rb:87
    def default_instrumentation_service; end

    # Public: Default instrumentation service for new pipeline objects.
    #
    # source://html-pipeline-2.14.2/lib/html/pipeline.rb:87
    def default_instrumentation_service=(_arg0); end

    # Parse a String into a DocumentFragment object. When a DocumentFragment is
    # provided, return it verbatim.
    #
    # source://html-pipeline-2.14.2/lib/html/pipeline.rb:62
    def parse(document_or_html); end

    # source://html-pipeline-2.14.2/lib/html/pipeline.rb:50
    def require_dependency(name, requirer); end
  end
end

# source://html-pipeline-2.14.2/lib/html/pipeline/absolute_source_filter.rb:20
class HTML::Pipeline::AbsoluteSourceFilter < ::HTML::Pipeline::Filter
  # HTML Filter for replacing relative and root relative image URLs with
  # fully qualified URLs
  #
  # This is useful if an image is root relative but should really be going
  # through a cdn, or if the content for the page assumes the host is known
  # i.e. scraped webpages and some RSS feeds.
  #
  # Context options:
  #   :image_base_url - Base URL for image host for root relative src.
  #   :image_subpage_url - For relative src.
  #
  # This filter does not write additional information to the context.
  # This filter would need to be run before CamoFilter.
  #
  # source://html-pipeline-2.14.2/lib/html/pipeline/absolute_source_filter.rb:21
  def call; end

  # Private: the base url you want to use
  #
  # source://html-pipeline-2.14.2/lib/html/pipeline/absolute_source_filter.rb:42
  def image_base_url; end

  # Private: the relative url you want to use
  #
  # source://html-pipeline-2.14.2/lib/html/pipeline/absolute_source_filter.rb:47
  def image_subpage_url; end
end

# Public: Runs a String of content through an HTML processing pipeline,
# providing easy access to a generated DocumentFragment.
#
# source://html-pipeline-2.14.2/lib/html/pipeline/body_content.rb:7
class HTML::Pipeline::BodyContent
  # Public: Initialize a BodyContent.
  #
  # body     - A String body.
  # context  - A Hash of context options for the filters.
  # pipeline - A HTML::Pipeline object with one or more Filters.
  #
  # @return [BodyContent] a new instance of BodyContent
  #
  # source://html-pipeline-2.14.2/lib/html/pipeline/body_content.rb:15
  def initialize(body, context, pipeline); end

  # Public: Parses the output into a DocumentFragment.
  #
  # Returns a DocumentFragment.
  #
  # source://html-pipeline-2.14.2/lib/html/pipeline/body_content.rb:39
  def document; end

  # Public: Gets the updated body from the Pipeline result.
  #
  # Returns a String or DocumentFragment.
  #
  # source://html-pipeline-2.14.2/lib/html/pipeline/body_content.rb:32
  def output; end

  # Public: Gets the memoized result of the body content as it passed through
  # the Pipeline.
  #
  # Returns a Hash, or something similar as defined by @pipeline.result_class.
  #
  # source://html-pipeline-2.14.2/lib/html/pipeline/body_content.rb:25
  def result; end
end

# HTML Filter for replacing http image URLs with camo versions. See:
#
# https://github.com/atmos/camo
#
# All images provided in user content should be run through this
# filter so that http image sources do not cause mixed-content warnings
# in browser clients.
#
# Context options:
#   :asset_proxy (required) - Base URL for constructed asset proxy URLs.
#   :asset_proxy_secret_key (required) - The shared secret used to encode URLs.
#   :asset_proxy_allowlist - Array of host Strings or Regexps to skip
#                            src rewriting.
#
# This filter does not write additional information to the context.
#
# source://html-pipeline-2.14.2/lib/html/pipeline/camo_filter.rb:25
class HTML::Pipeline::CamoFilter < ::HTML::Pipeline::Filter
  # @return [Boolean]
  #
  # source://html-pipeline-2.14.2/lib/html/pipeline/camo_filter.rb:92
  def asset_host_allowed?(host); end

  # @return [Boolean]
  #
  # source://html-pipeline-2.14.2/lib/html/pipeline/camo_filter.rb:87
  def asset_host_whitelisted?(host); end

  # source://html-pipeline-2.14.2/lib/html/pipeline/camo_filter.rb:83
  def asset_proxy_allowlist; end

  # Private: Return true if asset proxy filter should be enabled
  #
  # @return [Boolean]
  #
  # source://html-pipeline-2.14.2/lib/html/pipeline/camo_filter.rb:65
  def asset_proxy_enabled?; end

  # Private: the host to use for generated asset proxied URLs.
  #
  # source://html-pipeline-2.14.2/lib/html/pipeline/camo_filter.rb:70
  def asset_proxy_host; end

  # source://html-pipeline-2.14.2/lib/html/pipeline/camo_filter.rb:74
  def asset_proxy_secret_key; end

  # The camouflaged URL for a given image URL.
  #
  # source://html-pipeline-2.14.2/lib/html/pipeline/camo_filter.rb:55
  def asset_proxy_url(url); end

  # source://html-pipeline-2.14.2/lib/html/pipeline/camo_filter.rb:78
  def asset_proxy_whitelist; end

  # Private: calculate the HMAC digest for a image source URL.
  #
  # source://html-pipeline-2.14.2/lib/html/pipeline/camo_filter.rb:60
  def asset_url_hash(url); end

  # Hijacks images in the markup provided, replacing them with URLs that
  # go through the github asset proxy.
  #
  # source://html-pipeline-2.14.2/lib/html/pipeline/camo_filter.rb:26
  def call; end

  # Private: helper to hexencode a string. Each byte ends up encoded into
  # two characters, zero padded value in the range [0-9a-f].
  #
  # source://html-pipeline-2.14.2/lib/html/pipeline/camo_filter.rb:100
  def hexencode(str); end

  # Implementation of validate hook.
  # Errors should raise exceptions or use an existing validator.
  #
  # source://html-pipeline-2.14.2/lib/html/pipeline/camo_filter.rb:50
  def validate; end
end

# Our DOM implementation.
#
# source://html-pipeline-2.14.2/lib/html/pipeline.rb:58
HTML::Pipeline::DocumentFragment = Nokogiri::HTML4::DocumentFragment

# Base class for user content HTML filters. Each filter takes an
# HTML string or Nokogiri::HTML::DocumentFragment, performs
# modifications and/or writes information to the result hash. Filters must
# return a DocumentFragment (typically the same instance provided to the call
# method) or a String with HTML markup.
#
# Example filter that replaces all images with trollface:
#
#   class FuuuFilter < HTML::Pipeline::Filter
#     def call
#       doc.search('img').each do |img|
#         img['src'] = "http://paradoxdgn.com/junk/avatars/trollface.jpg"
#       end
#     end
#   end
#
# The context Hash passes options to filters and should not be changed in
# place.  A Result Hash allows filters to make extracted information
# available to the caller and is mutable.
#
# Common context options:
#   :base_url   - The site's base URL
#   :repository - A Repository providing context for the HTML being processed
#
# Each filter may define additional options and output values. See the class
# _docs for more info.
#
# source://html-pipeline-2.14.2/lib/html/pipeline/filter.rb:31
class HTML::Pipeline::Filter
  # @return [Filter] a new instance of Filter
  #
  # source://html-pipeline-2.14.2/lib/html/pipeline/filter.rb:34
  def initialize(doc, context = T.unsafe(nil), result = T.unsafe(nil)); end

  # The site's base URL provided in the context hash, or '/' when no
  # base URL was specified.
  #
  # source://html-pipeline-2.14.2/lib/html/pipeline/filter.rb:100
  def base_url; end

  # The main filter entry point. The doc attribute is guaranteed to be a
  # Nokogiri::HTML::DocumentFragment when invoked. Subclasses should modify
  # this document in place or extract information and add it to the context
  # hash.
  #
  # @raise [NotImplementedError]
  #
  # source://html-pipeline-2.14.2/lib/html/pipeline/filter.rb:76
  def call; end

  # Public: Returns a simple Hash used to pass extra information into filters
  # and also to allow filters to make extracted information available to the
  # caller.
  #
  # source://html-pipeline-2.14.2/lib/html/pipeline/filter.rb:50
  def context; end

  # The User object provided in the context hash, or nil when no user
  # was specified
  #
  # source://html-pipeline-2.14.2/lib/html/pipeline/filter.rb:94
  def current_user; end

  # The Nokogiri::HTML::DocumentFragment to be manipulated. If the filter was
  # provided a String, parse into a DocumentFragment the first time this
  # method is called.
  #
  # source://html-pipeline-2.14.2/lib/html/pipeline/filter.rb:60
  def doc; end

  # Helper method for filter subclasses used to determine if any of a node's
  # ancestors have one of the tag names specified.
  #
  # node - The Node object to check.
  # tags - An array of tag name strings to check. These should be downcase.
  #
  # Returns true when the node has a matching ancestor.
  #
  # @return [Boolean]
  #
  # source://html-pipeline-2.14.2/lib/html/pipeline/filter.rb:118
  def has_ancestor?(node, tags); end

  # The String representation of the document. If a DocumentFragment was
  # provided to the Filter, it is serialized into a String when this method is
  # called.
  #
  # @raise [InvalidDocumentException]
  #
  # source://html-pipeline-2.14.2/lib/html/pipeline/filter.rb:67
  def html; end

  # Validator for required context. This will check that anything passed in
  # contexts exists in @contexts
  #
  # If any errors are found an ArgumentError will be raised with a
  # message listing all the missing contexts and the filters that
  # require them.
  #
  # source://html-pipeline-2.14.2/lib/html/pipeline/filter.rb:155
  def needs(*keys); end

  # Ensure the passed argument is a DocumentFragment. When a string is
  # provided, it is parsed and returned; otherwise, the DocumentFragment is
  # returned unmodified.
  #
  # source://html-pipeline-2.14.2/lib/html/pipeline/filter.rb:107
  def parse_html(html); end

  # The Repository object provided in the context hash, or nil when no
  # :repository was specified.
  #
  # It's assumed that the repository context has already been checked
  # for permissions
  #
  # source://html-pipeline-2.14.2/lib/html/pipeline/filter.rb:88
  def repository; end

  # Public: Returns a Hash used to allow filters to pass back information
  # to callers of the various Pipelines.  This can be used for
  # #mentioned_users, for example.
  #
  # source://html-pipeline-2.14.2/lib/html/pipeline/filter.rb:55
  def result; end

  # Make sure the context has everything we need. Noop: Subclasses can override.
  #
  # source://html-pipeline-2.14.2/lib/html/pipeline/filter.rb:81
  def validate; end

  class << self
    # Perform a filter on doc with the given context.
    #
    # Returns a HTML::Pipeline::DocumentFragment or a String containing HTML
    # markup.
    #
    # source://html-pipeline-2.14.2/lib/html/pipeline/filter.rb:128
    def call(doc, context = T.unsafe(nil), result = T.unsafe(nil)); end

    # Like call but guarantees that a DocumentFragment is returned, even when
    # the last filter returns a String.
    #
    # source://html-pipeline-2.14.2/lib/html/pipeline/filter.rb:134
    def to_document(input, context = T.unsafe(nil)); end

    # Like call but guarantees that a string of HTML markup is returned.
    #
    # source://html-pipeline-2.14.2/lib/html/pipeline/filter.rb:140
    def to_html(input, context = T.unsafe(nil)); end
  end
end

# source://html-pipeline-2.14.2/lib/html/pipeline/filter.rb:32
class HTML::Pipeline::Filter::InvalidDocumentException < ::StandardError; end

# HTML Filter for replacing http references to :http_url with https versions.
# Subdomain references are not rewritten.
#
# Context options:
#   :http_url - The HTTP url to force HTTPS. Falls back to :base_url
#
# source://html-pipeline-2.14.2/lib/html/pipeline/https_filter.rb:10
class HTML::Pipeline::HttpsFilter < ::HTML::Pipeline::Filter
  # source://html-pipeline-2.14.2/lib/html/pipeline/https_filter.rb:11
  def call; end

  # HTTP url to replace. Falls back to :base_url
  #
  # source://html-pipeline-2.14.2/lib/html/pipeline/https_filter.rb:19
  def http_url; end

  # Raise error if :http_url undefined
  #
  # source://html-pipeline-2.14.2/lib/html/pipeline/https_filter.rb:24
  def validate; end
end

# HTML Filter that converts image's url into <img> tag.
# For example, it will convert
#   http://example.com/test.jpg
# into
#   <img src="http://example.com/test.jpg" alt=""/>.
#
# source://html-pipeline-2.14.2/lib/html/pipeline/image_filter.rb:11
class HTML::Pipeline::ImageFilter < ::HTML::Pipeline::TextFilter
  # source://html-pipeline-2.14.2/lib/html/pipeline/image_filter.rb:12
  def call; end
end

# This filter rewrites image tags with a max-width inline style and also wraps
# the image in an <a> tag that causes the full size image to be opened in a
# new tab.
#
# The max-width inline styles are especially useful in HTML email which
# don't use a global stylesheets.
#
# source://html-pipeline-2.14.2/lib/html/pipeline/image_max_width_filter.rb:11
class HTML::Pipeline::ImageMaxWidthFilter < ::HTML::Pipeline::Filter
  # source://html-pipeline-2.14.2/lib/html/pipeline/image_max_width_filter.rb:12
  def call; end

  # source://html-pipeline-2.14.2/lib/html/pipeline/image_max_width_filter.rb:30
  def link_image(element); end
end

# HTML Filter that converts Markdown text into HTML and converts into a
# DocumentFragment. This is different from most filters in that it can take a
# non-HTML as input. It must be used as the first filter in a pipeline.
#
# Context options:
#   :gfm      => false    Disable GFM line-end processing
#   :commonmarker_extensions => [ :table, :strikethrough,
#      :tagfilter, :autolink ] Commonmarker extensions to include
#
# This filter does not write any additional information to the context hash.
#
# source://html-pipeline-2.14.2/lib/html/pipeline/markdown_filter.rb:17
class HTML::Pipeline::MarkdownFilter < ::HTML::Pipeline::TextFilter
  # @return [MarkdownFilter] a new instance of MarkdownFilter
  #
  # source://html-pipeline-2.14.2/lib/html/pipeline/markdown_filter.rb:20
  def initialize(text, context = T.unsafe(nil), result = T.unsafe(nil)); end

  # Convert Markdown to HTML using the best available implementation
  # and convert into a DocumentFragment.
  #
  # source://html-pipeline-2.14.2/lib/html/pipeline/markdown_filter.rb:27
  def call; end
end

# source://html-pipeline-2.14.2/lib/html/pipeline/markdown_filter.rb:18
HTML::Pipeline::MarkdownFilter::DEFAULT_COMMONMARKER_EXTENSIONS = T.let(T.unsafe(nil), Array)

# HTML filter that replaces @user mentions with links. Mentions within <pre>,
# <code>, and <a> elements are ignored. Mentions that reference users that do
# not exist are ignored.
#
# Context options:
#   :base_url - Used to construct links to user profile pages for each
#               mention.
#   :info_url - Used to link to "more info" when someone mentions @mention
#               or @mentioned.
#   :username_pattern - Used to provide a custom regular expression to
#                       identify usernames
#
# source://html-pipeline-2.14.2/lib/html/pipeline/@mention_filter.rb:33
class HTML::Pipeline::MentionFilter < ::HTML::Pipeline::Filter
  # source://html-pipeline-2.14.2/lib/html/pipeline/@mention_filter.rb:72
  def call; end

  # The URL to provide when someone @mentions a "mention" name, such
  # as @mention or @mentioned, that will give them more info on mentions.
  #
  # source://html-pipeline-2.14.2/lib/html/pipeline/@mention_filter.rb:88
  def info_url; end

  # source://html-pipeline-2.14.2/lib/html/pipeline/@mention_filter.rb:121
  def link_to_mention_info(text, info_url = T.unsafe(nil)); end

  # source://html-pipeline-2.14.2/lib/html/pipeline/@mention_filter.rb:128
  def link_to_mentioned_user(login); end

  # Replace user @mentions in text with links to the mentioned user's
  # profile page.
  #
  # text      - String text to replace @mention usernames in.
  # base_url  - The base URL used to construct user profile URLs.
  # info_url  - The "more info" URL used to link to more info on @mentions.
  #             If nil we don't link @mention or @mentioned.
  # username_pattern  - Regular expression used to identify usernames in
  #                     text
  #
  # Returns a string with @mentions replaced with links. All links have a
  # 'user-mention' class name attached for styling.
  #
  # source://html-pipeline-2.14.2/lib/html/pipeline/@mention_filter.rb:108
  def mention_link_filter(text, _base_url = T.unsafe(nil), info_url = T.unsafe(nil), username_pattern = T.unsafe(nil)); end

  # source://html-pipeline-2.14.2/lib/html/pipeline/@mention_filter.rb:92
  def username_pattern; end

  class << self
    # Public: Find user @mentions in text.  See
    # MentionFilter#mention_link_filter.
    #
    #   MentionFilter.mentioned_logins_in(text) do |match, login, is_mentioned|
    #     "<a href=...>#{login}</a>"
    #   end
    #
    # text - String text to search.
    #
    # Yields the String match, the String login name, and a Boolean determining
    # if the match = "@mention[ed]".  The yield's return replaces the match in
    # the original text.
    #
    # Returns a String replaced with the return of the block.
    #
    # source://html-pipeline-2.14.2/lib/html/pipeline/@mention_filter.rb:34
    def mentioned_logins_in(text, username_pattern = T.unsafe(nil)); end
  end
end

# Don't look for mentions in text nodes that are children of these elements
#
# source://html-pipeline-2.14.2/lib/html/pipeline/@mention_filter.rb:70
HTML::Pipeline::MentionFilter::IGNORE_PARENTS = T.let(T.unsafe(nil), Set)

# List of username logins that, when mentioned, link to the blog post
# about @mentions instead of triggering a real mention.
#
# source://html-pipeline-2.14.2/lib/html/pipeline/@mention_filter.rb:62
HTML::Pipeline::MentionFilter::MentionLogins = T.let(T.unsafe(nil), Array)

# Hash that contains all of the mention patterns used by the pipeline
#
# source://html-pipeline-2.14.2/lib/html/pipeline/@mention_filter.rb:42
HTML::Pipeline::MentionFilter::MentionPatterns = T.let(T.unsafe(nil), Hash)

# Default pattern used to extract usernames from text. The value can be
# overriden by providing the username_pattern variable in the context.
#
# source://html-pipeline-2.14.2/lib/html/pipeline/@mention_filter.rb:58
HTML::Pipeline::MentionFilter::UsernamePattern = T.let(T.unsafe(nil), Regexp)

# source://html-pipeline-2.14.2/lib/html/pipeline.rb:49
class HTML::Pipeline::MissingDependencyError < ::RuntimeError; end

# HTML Filter that syntax highlights text inside code blocks.
#
# Context options:
#
#   :highlight => String represents the language to pick lexer. Defaults to empty string.
#   :scope => String represents the class attribute adds to pre element after.
#             Defaults to "highlight highlight-css" if highlights a css code block.
#
# This filter does not write any additional information to the context hash.
#
# source://html-pipeline-2.14.2/lib/html/pipeline/syntax_highlight_filter.rb:16
class HTML::Pipeline::SyntaxHighlightFilter < ::HTML::Pipeline::Filter
  # @return [SyntaxHighlightFilter] a new instance of SyntaxHighlightFilter
  #
  # source://html-pipeline-2.14.2/lib/html/pipeline/syntax_highlight_filter.rb:17
  def initialize(*args); end

  # source://html-pipeline-2.14.2/lib/html/pipeline/syntax_highlight_filter.rb:22
  def call; end

  # source://html-pipeline-2.14.2/lib/html/pipeline/syntax_highlight_filter.rb:39
  def highlight_with_timeout_handling(text, lexer); end

  # source://html-pipeline-2.14.2/lib/html/pipeline/syntax_highlight_filter.rb:45
  def lexer_for(lang); end
end

# HTML filter that replaces @org/team mentions with links. Mentions within
# <pre>, <code>, <a>, <style>, and <script> elements are ignored.
#
# Context options:
#   :base_url - Used to construct links to team profile pages for each
#               mention.
#   :team_pattern - Used to provide a custom regular expression to
#                       identify team names
#
# source://html-pipeline-2.14.2/lib/html/pipeline/@team_mention_filter.rb:29
class HTML::Pipeline::TeamMentionFilter < ::HTML::Pipeline::Filter
  # source://html-pipeline-2.14.2/lib/html/pipeline/@team_mention_filter.rb:52
  def call; end

  # source://html-pipeline-2.14.2/lib/html/pipeline/@team_mention_filter.rb:87
  def link_to_mentioned_team(org, team); end

  # Replace @org/team mentions in text with links to the mentioned team's
  # page.
  #
  # text      - String text to replace @mention team names in.
  # base_url  - The base URL used to construct team page URLs.
  # team_pattern  - Regular expression used to identify teams in text
  #
  # Returns a string with @team mentions replaced with links. All links have a
  # 'team-mention' class name attached for styling.
  #
  # source://html-pipeline-2.14.2/lib/html/pipeline/@team_mention_filter.rb:79
  def mention_link_filter(text, _base_url = T.unsafe(nil), team_pattern = T.unsafe(nil)); end

  # source://html-pipeline-2.14.2/lib/html/pipeline/@team_mention_filter.rb:66
  def team_pattern; end

  class << self
    # Public: Find @org/team mentions in text.  See
    # TeamMentionFilter#team_mention_link_filter.
    #
    #   TeamMentionFilter.mentioned_teams_in(text) do |match, org, team|
    #     "<a href=...>#{team}</a>"
    #   end
    #
    # text - String text to search.
    #
    # Yields the String match, org name, and team name.  The yield's
    # return replaces the match in the original text.
    #
    # Returns a String replaced with the return of the block.
    #
    # source://html-pipeline-2.14.2/lib/html/pipeline/@team_mention_filter.rb:30
    def mentioned_teams_in(text, team_pattern = T.unsafe(nil)); end
  end
end

# Don't look for mentions in text nodes that are children of these elements
#
# source://html-pipeline-2.14.2/lib/html/pipeline/@team_mention_filter.rb:50
HTML::Pipeline::TeamMentionFilter::IGNORE_PARENTS = T.let(T.unsafe(nil), Set)

# Default pattern used to extract team names from text. The value can be
# overridden by providing the team_pattern variable in the context. To
# properly link the mention, should be in the format of /@(1)\/(2)/.
#
# source://html-pipeline-2.14.2/lib/html/pipeline/@team_mention_filter.rb:41
HTML::Pipeline::TeamMentionFilter::TeamPattern = T.let(T.unsafe(nil), Regexp)

# source://html-pipeline-2.14.2/lib/html/pipeline/text_filter.rb:5
class HTML::Pipeline::TextFilter < ::HTML::Pipeline::Filter
  # @raise [TypeError]
  # @return [TextFilter] a new instance of TextFilter
  #
  # source://html-pipeline-2.14.2/lib/html/pipeline/text_filter.rb:8
  def initialize(text, context = T.unsafe(nil), result = T.unsafe(nil)); end

  # Returns the value of attribute text.
  #
  # source://html-pipeline-2.14.2/lib/html/pipeline/text_filter.rb:6
  def text; end
end

# source://html-pipeline-2.14.2/lib/html/pipeline/version.rb:5
HTML::Pipeline::VERSION = T.let(T.unsafe(nil), String)
