# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `faraday` gem.
# Please instead update this file by running `bin/tapioca gem faraday`.

# conn.get '/'
module Faraday
  class << self
    # @overload default_adapter
    # @overload default_adapter=
    def default_adapter; end

    # Documented elsewhere, see default_adapter reader
    def default_adapter=(adapter); end

    # Option for the default_adapter
    #   @return [Hash] default_adapter options
    def default_adapter_options; end

    # Option for the default_adapter
    #   @return [Hash] default_adapter options
    def default_adapter_options=(_arg0); end

    # @overload default_connection
    # @overload default_connection=
    def default_connection; end

    # Documented below, see default_connection
    def default_connection=(_arg0); end

    # Gets the default connection options used when calling {Faraday#new}.
    #
    # @return [Faraday::ConnectionOptions]
    def default_connection_options; end

    # Sets the default options used when calling {Faraday#new}.
    #
    # @param options [Hash, Faraday::ConnectionOptions]
    def default_connection_options=(options); end

    # Tells Faraday to ignore the environment proxy (http_proxy).
    # Defaults to `false`.
    #
    # @return [Boolean]
    def ignore_env_proxy; end

    # Tells Faraday to ignore the environment proxy (http_proxy).
    # Defaults to `false`.
    #
    # @return [Boolean]
    def ignore_env_proxy=(_arg0); end

    # Gets or sets the path that the Faraday libs are loaded from.
    #
    # @return [String]
    def lib_path; end

    # Gets or sets the path that the Faraday libs are loaded from.
    #
    # @return [String]
    def lib_path=(_arg0); end

    # Initializes a new {Connection}.
    #
    # @example With an URL argument
    #   Faraday.new 'http://faraday.com'
    #   # => Faraday::Connection to http://faraday.com
    # @example With everything in an options hash
    #   Faraday.new url: 'http://faraday.com',
    #   params: { page: 1 }
    #   # => Faraday::Connection to http://faraday.com?page=1
    # @example With an URL argument and an options hash
    #   Faraday.new 'http://faraday.com', params: { page: 1 }
    #   # => Faraday::Connection to http://faraday.com?page=1
    # @option options
    # @option options
    # @option options
    # @option options
    # @option options
    # @option options
    # @param url [String, Hash] The optional String base URL to use as a prefix
    #   for all requests.  Can also be the options Hash. Any of these
    #   values will be set on every request made, unless overridden
    #   for a specific request.
    # @param options [Hash]
    # @return [Faraday::Connection]
    def new(url = T.unsafe(nil), options = T.unsafe(nil), &block); end

    # @return [Boolean]
    def respond_to_missing?(symbol, include_private = T.unsafe(nil)); end

    # The root path that Faraday is being loaded from.
    #
    # This is the root from where the libraries are auto-loaded.
    #
    # @return [String]
    def root_path; end

    # The root path that Faraday is being loaded from.
    #
    # This is the root from where the libraries are auto-loaded.
    #
    # @return [String]
    def root_path=(_arg0); end

    private

    # Internal: Proxies method calls on the Faraday constant to
    # .default_connection.
    def method_missing(name, *args, &block); end
  end
end

# Base class for all Faraday adapters. Adapters are
# responsible for fulfilling a Faraday request.
class Faraday::Adapter
  extend ::Faraday::MiddlewareRegistry
  extend ::Faraday::Adapter::Parallelism

  # @return [Adapter] a new instance of Adapter
  def initialize(_app = T.unsafe(nil), opts = T.unsafe(nil), &block); end

  def call(env); end

  # Close any persistent connections. The adapter should still be usable
  # after calling close.
  def close; end

  # Yields or returns an adapter's configured connection. Depends on
  # #build_connection being defined on this adapter.
  #
  # @param env [Faraday::Env, Hash] The env object for a faraday request.
  # @return The return value of the given block, or the HTTP connection object
  #   if no block is given.
  # @yield [conn]
  def connection(env); end

  private

  # Fetches either a read, write, or open timeout setting. Defaults to the
  # :timeout value if a more specific one is not given.
  #
  # @param type [Symbol] Describes which timeout setting to get: :read,
  #   :write, or :open.
  # @param options [Hash] Hash containing Symbol keys like :timeout,
  #   :read_timeout, :write_timeout, :open_timeout, or
  #   :timeout
  # @return [Integer, nil] Timeout duration in seconds, or nil if no timeout
  #   has been set.
  def request_timeout(type, options); end

  def save_response(env, status, body, headers = T.unsafe(nil), reason_phrase = T.unsafe(nil), finished: T.unsafe(nil)); end
end

Faraday::Adapter::CONTENT_LENGTH = T.let(T.unsafe(nil), String)

# This module marks an Adapter as supporting parallel requests.
module Faraday::Adapter::Parallelism
  def inherited(subclass); end

  # Sets the attribute supports_parallel
  #
  # @param value the value to set the attribute supports_parallel to.
  def supports_parallel=(_arg0); end

  # @return [Boolean]
  def supports_parallel?; end
end

Faraday::Adapter::TIMEOUT_KEYS = T.let(T.unsafe(nil), Hash)

# @example
#   test = Faraday::Connection.new do
#   use Faraday::Adapter::Test do |stub|
#   # Define matcher to match the request
#   stub.get '/resource.json' do
#   # return static content
#   [200, {'Content-Type' => 'application/json'}, 'hi world']
#   end
#
#   # response with content generated based on request
#   stub.get '/showget' do |env|
#   [200, {'Content-Type' => 'text/plain'}, env[:method].to_s]
#   end
#
#   # A regular expression can be used as matching filter
#   stub.get /\A\/items\/(\d+)\z/ do |env, meta|
#   # in case regular expression is used, an instance of MatchData
#   # can be received
#   [200,
#   {'Content-Type' => 'text/plain'},
#   "showing item: #{meta[:match_data][1]}"
#   ]
#   end
#
#   # Test the request body is the same as the stubbed body
#   stub.post('/bar', 'name=YK&word=call') { [200, {}, ''] }
#
#   # You can pass a proc as a stubbed body and check the request body in your way.
#   # In this case, the proc should return true or false.
#   stub.post('/foo', ->(request_body) do
#   JSON.parse(request_body).slice('name') == { 'name' => 'YK' } }) { [200, {}, '']
#   end
#
#   # You can set strict_mode to exactly match the stubbed requests.
#   stub.strict_mode = true
#   end
#   end
#
#   resp = test.get '/resource.json'
#   resp.body # => 'hi world'
#
#   resp = test.get '/showget'
#   resp.body # => 'get'
#
#   resp = test.get '/items/1'
#   resp.body # => 'showing item: 1'
#
#   resp = test.get '/items/2'
#   resp.body # => 'showing item: 2'
#
#   resp = test.post '/bar', 'name=YK&word=call'
#   resp.status # => 200
#
#   resp = test.post '/foo', JSON.dump(name: 'YK', created_at: Time.now)
#   resp.status # => 200
class Faraday::Adapter::Test < ::Faraday::Adapter
  # @return [Test] a new instance of Test
  def initialize(app, stubs = T.unsafe(nil), &block); end

  # @param env [Faraday::Env]
  def call(env); end

  # @yield [stubs]
  def configure; end

  # Returns the value of attribute stubs.
  def stubs; end

  # Sets the attribute stubs
  #
  # @param value the value to set the attribute stubs to.
  def stubs=(_arg0); end
end

# Stub request
class Faraday::Adapter::Test::Stub < ::Struct
  # @return [Boolean]
  def body_match?(request_body); end

  # @return [Boolean]
  def headers_match?(request_headers); end

  # @param env [Faraday::Env]
  # @return [Boolean]
  def matches?(env); end

  # @param env [Faraday::Env]
  # @return [Boolean]
  def params_match?(env); end

  # @return [Boolean]
  def path_match?(request_path, meta); end

  def to_s; end
end

# A stack of Stubs
class Faraday::Adapter::Test::Stubs
  # @return [Stubs] a new instance of Stubs
  # @yield [_self]
  # @yieldparam _self [Faraday::Adapter::Test::Stubs] the object that the method was called on
  def initialize(strict_mode: T.unsafe(nil)); end

  def delete(path, headers = T.unsafe(nil), &block); end

  # @return [Boolean]
  def empty?; end

  def get(path, headers = T.unsafe(nil), &block); end
  def head(path, headers = T.unsafe(nil), &block); end

  # @param env [Faraday::Env]
  def match(env); end

  def options(path, headers = T.unsafe(nil), &block); end
  def patch(path, body = T.unsafe(nil), headers = T.unsafe(nil), &block); end
  def post(path, body = T.unsafe(nil), headers = T.unsafe(nil), &block); end
  def put(path, body = T.unsafe(nil), headers = T.unsafe(nil), &block); end

  # Set strict_mode. If the value is true, this adapter tries to find matched requests strictly,
  # which means that all of a path, parameters, and headers must be the same as an actual request.
  def strict_mode=(value); end

  # Raises an error if any of the stubbed calls have not been made.
  def verify_stubbed_calls; end

  protected

  # @param stack [Hash]
  # @param env [Faraday::Env]
  # @return [Boolean]
  def matches?(stack, env); end

  def new_stub(request_method, path, headers = T.unsafe(nil), body = T.unsafe(nil), &block); end
end

class Faraday::Adapter::Test::Stubs::NotFound < ::StandardError; end

# AdapterRegistry registers adapter class names so they can be looked up by a
# String or Symbol name.
class Faraday::AdapterRegistry
  # @return [AdapterRegistry] a new instance of AdapterRegistry
  def initialize; end

  def get(name); end
  def set(klass, name = T.unsafe(nil)); end
end

# Raised by Faraday::Response::RaiseError in case of a 400 response.
class Faraday::BadRequestError < ::Faraday::ClientError; end

Faraday::CONTENT_TYPE = T.let(T.unsafe(nil), String)

# Faraday client error class. Represents 4xx status responses.
class Faraday::ClientError < ::Faraday::Error; end

Faraday::CompositeReadIO = Faraday::Multipart::CompositeReadIO

# Raised by Faraday::Response::RaiseError in case of a 409 response.
class Faraday::ConflictError < ::Faraday::ClientError; end

# Connection objects manage the default properties and the middleware
# stack for fulfilling an HTTP request.
#
# @example
#
#   conn = Faraday::Connection.new 'http://httpbingo.org'
#
#   # GET http://httpbingo.org/nigiri
#   conn.get 'nigiri'
#   # => #<Faraday::Response>
class Faraday::Connection
  extend ::Forwardable

  # Initializes a new Faraday::Connection.
  #
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @param url [URI, String] URI or String base URL to use as a prefix for all
  #   requests (optional).
  # @param options [Hash, Faraday::ConnectionOptions]
  # @return [Connection] a new instance of Connection
  # @yield [self] after all setup has been done
  def initialize(url = T.unsafe(nil), options = T.unsafe(nil)); end

  def adapter(*args, **_arg1, &block); end
  def app(*args, **_arg1, &block); end

  # Build an absolute URL based on url_prefix.
  #
  #          of the resulting url (default: nil).
  #
  # @param url [String, URI]
  # @param params [Faraday::Utils::ParamsHash] A Faraday::Utils::ParamsHash to
  #   replace the query values
  # @return [URI]
  def build_exclusive_url(url = T.unsafe(nil), params = T.unsafe(nil), params_encoder = T.unsafe(nil)); end

  # Creates and configures the request object.
  #
  # @param method [Symbol]
  # @return [Faraday::Request]
  # @yield [Faraday::Request] if block given
  def build_request(method); end

  # Takes a relative url for a request and combines it with the defaults
  # set on the connection instance.
  #
  # @example
  #   conn = Faraday::Connection.new { ... }
  #   conn.url_prefix = "https://httpbingo.org/api?token=abc"
  #   conn.scheme      # => https
  #   conn.path_prefix # => "/api"
  #
  #   conn.build_url("nigiri?page=2")
  #   # => https://httpbingo.org/api/nigiri?token=abc&page=2
  #
  #   conn.build_url("nigiri", page: 2)
  #   # => https://httpbingo.org/api/nigiri?token=abc&page=2
  # @param url [String]
  # @param extra_params [Hash]
  def build_url(url = T.unsafe(nil), extra_params = T.unsafe(nil)); end

  # @return [Faraday::RackBuilder] Builder for this Connection.
  def builder; end

  # Closes the underlying resources and/or connections. In the case of
  # persistent connections, this closes all currently open connections
  # but does not prevent new connections from being made.
  def close; end

  # Check if the adapter is parallel-capable.
  #
  # @api private
  # @return [Object, nil] a parallel manager or nil if yielded
  # @yield if the adapter isn't parallel-capable, or if no adapter is set yet.
  def default_parallel_manager; end

  # Sets the default parallel manager for this connection.
  def default_parallel_manager=(_arg0); end

  def delete(url = T.unsafe(nil), params = T.unsafe(nil), headers = T.unsafe(nil)); end

  # Creates a duplicate of this Faraday::Connection.
  #
  # @api private
  # @return [Faraday::Connection]
  def dup; end

  def find_default_proxy; end
  def get(url = T.unsafe(nil), params = T.unsafe(nil), headers = T.unsafe(nil)); end
  def head(url = T.unsafe(nil), params = T.unsafe(nil), headers = T.unsafe(nil)); end

  # @return [Hash] unencoded HTTP header key/value pairs.
  def headers; end

  # Sets the Hash of unencoded HTTP header key/value pairs.
  #
  # @param hash [Hash]
  def headers=(hash); end

  def host(*args, **_arg1, &block); end
  def host=(*args, **_arg1, &block); end

  # Sets up the parallel manager to make a set of requests.
  #
  # @param manager [Object] The parallel manager that this Connection's
  #   Adapter uses.
  # @return [void]
  # @yield a block to execute multiple requests.
  def in_parallel(manager = T.unsafe(nil)); end

  # Determine if this Faraday::Connection can make parallel requests.
  #
  # @return [Boolean]
  def in_parallel?; end

  def initialize_proxy(url, options); end

  # @example
  #   conn.options '/items/1'
  # @overload options
  # @overload options
  # @return [Faraday::Response]
  # @yield [Faraday::Request] for further request customizations
  def options(*args); end

  # @return [Object] the parallel manager for this Connection.
  def parallel_manager; end

  # @return [Hash] URI query unencoded key/value pairs.
  def params; end

  # Sets the Hash of URI query unencoded key/value pairs.
  #
  # @param hash [Hash]
  def params=(hash); end

  def patch(url = T.unsafe(nil), body = T.unsafe(nil), headers = T.unsafe(nil), &block); end
  def path_prefix(*args, **_arg1, &block); end

  # Sets the path prefix and ensures that it always has a leading
  # slash.
  #
  # @param value [String]
  # @return [String] the new path prefix
  def path_prefix=(value); end

  def port(*args, **_arg1, &block); end
  def port=(*args, **_arg1, &block); end
  def post(url = T.unsafe(nil), body = T.unsafe(nil), headers = T.unsafe(nil), &block); end

  # @return [Hash] proxy options.
  def proxy; end

  # Sets the Hash proxy options.
  #
  # @param new_value [Object]
  def proxy=(new_value); end

  def proxy_for_request(url); end
  def proxy_from_env(url); end
  def put(url = T.unsafe(nil), body = T.unsafe(nil), headers = T.unsafe(nil), &block); end
  def request(*args, **_arg1, &block); end
  def response(*args, **_arg1, &block); end

  # Builds and runs the Faraday::Request.
  #
  # @param method [Symbol] HTTP method.
  # @param url [String, URI] String or URI to access.
  # @param body [Object] The request body that will eventually be converted to
  #   a string.
  # @param headers [Hash] unencoded HTTP header key/value pairs.
  # @return [Faraday::Response]
  def run_request(method, url, body, headers); end

  def scheme(*args, **_arg1, &block); end
  def scheme=(*args, **_arg1, &block); end
  def set_basic_auth(user, password); end

  # @return [Hash] SSL options.
  def ssl; end

  # @return [Boolean]
  def support_parallel?(adapter); end

  def trace(url = T.unsafe(nil), params = T.unsafe(nil), headers = T.unsafe(nil)); end

  # @return [String] a URI with the prefix used for all requests from this
  #   Connection. This includes a default host name, scheme, port, and path.
  def url_prefix; end

  # Parses the given URL with URI and stores the individual
  # components in this connection. These components serve as defaults for
  # requests made by this connection.
  #
  # @example
  #
  #   conn = Faraday::Connection.new { ... }
  #   conn.url_prefix = "https://httpbingo.org/api"
  #   conn.scheme      # => https
  #   conn.path_prefix # => "/api"
  #
  #   conn.get("nigiri?page=2") # accesses https://httpbingo.org/api/nigiri
  # @param url [String, URI]
  # @param encoder [Object]
  def url_prefix=(url, encoder = T.unsafe(nil)); end

  def use(*args, **_arg1, &block); end

  # Yields username and password extracted from a URI if they both exist.
  #
  # @api private
  # @param uri [URI]
  # @return [void]
  # @yield [username, password] any username and password
  # @yieldparam username [String] any username from URI
  # @yieldparam password [String] any password from URI
  def with_uri_credentials(uri); end
end

# A Set of allowed HTTP verbs.
Faraday::Connection::METHODS = T.let(T.unsafe(nil), Set)

Faraday::Connection::USER_AGENT = T.let(T.unsafe(nil), String)

# A unified error for failed connections.
class Faraday::ConnectionFailed < ::Faraday::Error; end

# ConnectionOptions contains the configurable properties for a Faraday
# connection object.
class Faraday::ConnectionOptions < ::Faraday::Options
  def builder_class; end
  def new_builder(block); end
  def request; end
  def ssl; end
end

# Sub-module for decoding query-string into parameters.
module Faraday::DecodeMethods
  # @param query [nil, String]
  # @raise [TypeError] if the nesting is incorrect
  # @return [Array<Array, String>] the decoded params
  def decode(query); end

  protected

  def add_to_context(is_array, context, value, subkey); end
  def decode_pair(key, value, context); end

  # Internal: convert a nested hash with purely numeric keys into an array.
  # FIXME: this is not compatible with Rack::Utils.parse_nested_query
  def dehash(hash, depth); end

  def match_context(context, subkey); end
  def new_context(subkey, is_array, context); end
  def prepare_context(context, subkey, is_array, last_subkey); end
end

Faraday::DecodeMethods::SUBKEYS_REGEX = T.let(T.unsafe(nil), Regexp)

# Sub-module for encoding parameters into query-string.
module Faraday::EncodeMethods
  # @param params [nil, Array, #to_hash] parameters to be encoded
  # @raise [TypeError] if params can not be converted to a Hash
  # @return [String] the encoded params
  def encode(params); end

  protected

  def encode_array(parent, value); end
  def encode_hash(parent, value); end
  def encode_pair(parent, value); end
end

class Faraday::Env < ::Faraday::Options
  extend ::Forwardable

  # @param key [Object]
  def [](key); end

  # @param key [Object]
  # @param value [Object]
  def []=(key, value); end

  # string.
  #
  # @return [String] The request body that will eventually be converted to a
  def body; end

  # string.
  #
  # @return [String] The request body that will eventually be converted to a
  def body=(value); end

  # Sets content length to zero and the body to the empty string.
  def clear_body; end

  def current_body; end

  # @private
  def custom_members; end

  # @return [Boolean]
  def in_member_set?(key); end

  def inspect; end

  # set of {MethodsWithBodies}.
  #
  # @return [Boolean] true if there's no body yet, and the method is in the
  def needs_body?; end

  # @return [Boolean] true if there is a parallel_manager
  def parallel?; end

  def params_encoder(*args, **_arg1, &block); end

  # {StatusesWithoutBody}.
  #
  # @return [Boolean] true if the status isn't in the set of
  def parse_body?; end

  def stream_response(&block); end

  # @return [Boolean]
  def stream_response?; end

  # @return [Boolean] true if status is in the set of {SuccessfulStatuses}.
  def success?; end

  class << self
    # Build a new Env from given value. Respects and updates `custom_members`.
    #
    # @param value [Object] a value fitting Option.from(v).
    # @return [Env] from given value
    def from(value); end

    # @private
    def member_set; end
  end
end

Faraday::Env::ContentLength = T.let(T.unsafe(nil), String)

# A Set of HTTP verbs that typically send a body.  If no body is set for
# these requests, the Content-Length header is set to 0.
Faraday::Env::MethodsWithBodies = T.let(T.unsafe(nil), Set)

Faraday::Env::StatusesWithoutBody = T.let(T.unsafe(nil), Set)
Faraday::Env::SuccessfulStatuses = T.let(T.unsafe(nil), Range)

# Faraday error base class.
class Faraday::Error < ::StandardError
  # @return [Error] a new instance of Error
  def initialize(exc = T.unsafe(nil), response = T.unsafe(nil)); end

  def backtrace; end
  def inspect; end

  # Returns the value of attribute response.
  def response; end

  def response_body; end
  def response_headers; end
  def response_status; end

  # Returns the value of attribute wrapped_exception.
  def wrapped_exception; end

  protected

  # Pulls out potential parent exception and response hash.
  def exc_msg_and_response(exc, response = T.unsafe(nil)); end

  # Pulls out potential parent exception and response hash, storing them in
  # instance variables.
  # exc      - Either an Exception, a string message, or a response hash.
  # response - Hash
  #              :status  - Optional integer HTTP response status
  #              :headers - String key/value hash of HTTP response header
  #                         values.
  #              :body    - Optional string HTTP response body.
  #              :request - Hash
  #                           :method   - Symbol with the request HTTP method.
  #                           :url      - URI object with the url requested.
  #                           :url_path - String with the url path requested.
  #                           :params   - String key/value hash of query params
  #                                     present in the request.
  #                           :headers  - String key/value hash of HTTP request
  #                                     header values.
  #                           :body     - String HTTP request body.
  #
  # If a subclass has to call this, then it should pass a string message
  # to `super`. See NilStatusError.
  def exc_msg_and_response!(exc, response = T.unsafe(nil)); end
end

Faraday::FilePart = Multipart::Post::UploadIO

# FlatParamsEncoder manages URI params as a flat hash. Any Array values repeat
# the parameter multiple times.
module Faraday::FlatParamsEncoder
  class << self
    # Decode converts the given URI querystring into a hash.
    #
    # @example
    #
    #   decode('a=one&a=two&a=three&b=true&c=C')
    #   # => {"a"=>["one", "two", "three"], "b"=>"true", "c"=>"C"}
    # @param query [String] query arguments to parse.
    # @return [Hash] parsed keys and value strings from the querystring.
    def decode(query); end

    # Encode converts the given param into a URI querystring. Keys and values
    # will converted to strings and appropriately escaped for the URI.
    #
    # @example
    #
    #   encode({a: %w[one two three], b: true, c: "C"})
    #   # => 'a=one&a=two&a=three&b=true&c=C'
    # @param params [Hash] query arguments to convert.
    # @return [String] the URI querystring (without the leading '?')
    def encode(params); end

    def escape(*args, **_arg1, &block); end

    # Returns the value of attribute sort_params.
    def sort_params; end

    # Sets the attribute sort_params
    #
    # @param value the value to set the attribute sort_params to.
    def sort_params=(_arg0); end

    def unescape(*args, **_arg1, &block); end
  end
end

# Raised by Faraday::Response::RaiseError in case of a 403 response.
class Faraday::ForbiddenError < ::Faraday::ClientError; end

module Faraday::Logging; end

# Serves as an integration point to customize logging
class Faraday::Logging::Formatter
  extend ::Forwardable

  # @return [Formatter] a new instance of Formatter
  def initialize(logger:, options:); end

  def debug(*args, **_arg1, &block); end
  def error(*args, **_arg1, &block); end
  def fatal(*args, **_arg1, &block); end
  def filter(filter_word, filter_replacement); end
  def info(*args, **_arg1, &block); end
  def request(env); end
  def response(env); end
  def warn(*args, **_arg1, &block); end

  private

  def apply_filters(output); end
  def dump_body(body); end
  def dump_headers(headers); end
  def log_body(type, body); end

  # @return [Boolean]
  def log_body?(type); end

  def log_headers(type, headers); end

  # @return [Boolean]
  def log_headers?(type); end

  def log_level; end
  def pretty_inspect(body); end
end

Faraday::Logging::Formatter::DEFAULT_OPTIONS = T.let(T.unsafe(nil), Hash)
Faraday::METHODS_WITH_BODY = T.let(T.unsafe(nil), Array)
Faraday::METHODS_WITH_QUERY = T.let(T.unsafe(nil), Array)

# Middleware is the basic base class of any Faraday middleware.
class Faraday::Middleware
  extend ::Faraday::MiddlewareRegistry

  # @return [Middleware] a new instance of Middleware
  def initialize(app = T.unsafe(nil), options = T.unsafe(nil)); end

  # Returns the value of attribute app.
  def app; end

  def call(env); end
  def close; end

  # Returns the value of attribute options.
  def options; end
end

# Adds the ability for other modules to register and lookup
# middleware classes.
module Faraday::MiddlewareRegistry
  # Lookup middleware class with a registered Symbol shortcut.
  #
  # @example
  #
  #   module Faraday
  #   class Whatever < Middleware
  #   register_middleware(foo: Whatever)
  #   end
  #   end
  #
  #   Faraday::Middleware.lookup_middleware(:foo)
  #   # => Faraday::Whatever
  # @param key [Symbol] key for the registered middleware.
  # @raise [Faraday::Error] if given key is not registered
  # @return [Class] a middleware Class.
  def lookup_middleware(key); end

  # Register middleware class(es) on the current module.
  #
  # @example Lookup by a constant
  #
  #   module Faraday
  #   class Whatever < Middleware
  #   # Middleware looked up by :foo returns Faraday::Whatever::Foo.
  #   register_middleware(foo: Whatever)
  #   end
  #   end
  # @param mappings [Hash] Middleware mappings from a lookup symbol to a middleware class.
  # @return [void]
  def register_middleware(**mappings); end

  def registered_middleware; end

  # Unregister a previously registered middleware class.
  #
  # @param key [Symbol] key for the registered middleware.
  def unregister_middleware(key); end

  private

  def load_middleware(key); end
  def middleware_mutex(&block); end
end

# This is the default encoder for Faraday requests.
# Using this encoder, parameters will be encoded respecting their structure,
# so you can send objects such as Arrays or Hashes as parameters
# for your requests.
module Faraday::NestedParamsEncoder
  extend ::Faraday::EncodeMethods
  extend ::Faraday::DecodeMethods

  class << self
    # Returns the value of attribute array_indices.
    def array_indices; end

    # Sets the attribute array_indices
    #
    # @param value the value to set the attribute array_indices to.
    def array_indices=(_arg0); end

    def escape(*args, **_arg1, &block); end

    # Returns the value of attribute sort_params.
    def sort_params; end

    # Sets the attribute sort_params
    #
    # @param value the value to set the attribute sort_params to.
    def sort_params=(_arg0); end

    def unescape(*args, **_arg1, &block); end
  end
end

# Raised by Faraday::Response::RaiseError in case of a nil status in response.
class Faraday::NilStatusError < ::Faraday::ServerError
  # @return [NilStatusError] a new instance of NilStatusError
  def initialize(exc, response = T.unsafe(nil)); end
end

# Subclasses Struct with some special helpers for converting from a Hash to
# a Struct.
class Faraday::Options < ::Struct
  def [](key); end

  # Public
  def clear; end

  # Public
  def deep_dup; end

  # Public
  def delete(key); end

  # Public
  def each; end

  # Public
  def each_key(&block); end

  # Public
  def each_value(&block); end

  # Public
  #
  # @return [Boolean]
  def empty?; end

  # Public
  def fetch(key, *args); end

  # Public
  #
  # @return [Boolean]
  def has_key?(key); end

  # Public
  #
  # @return [Boolean]
  def has_value?(value); end

  # Internal
  def inspect; end

  # Public
  #
  # @return [Boolean]
  def key?(key); end

  # Public
  def keys; end

  # Public
  def merge(other); end

  # Public
  def merge!(other); end

  def symbolized_key_set; end

  # Public
  def to_hash; end

  # Public
  def update(obj); end

  # Public
  #
  # @return [Boolean]
  def value?(value); end

  # Public
  def values_at(*keys); end

  class << self
    # Internal
    def attribute_options; end

    def fetch_error_class; end

    # Public
    def from(value); end

    # @private
    def inherited(subclass); end

    def memoized(key, &block); end
    def memoized_attributes; end

    # Internal
    def options(mapping); end

    # Internal
    def options_for(key); end
  end
end

Faraday::ParamPart = Faraday::Multipart::ParamPart

# Raised by middlewares that parse the response, like the JSON response middleware.
class Faraday::ParsingError < ::Faraday::Error; end

Faraday::Parts = Multipart::Post::Parts

# Raised by Faraday::Response::RaiseError in case of a 407 response.
class Faraday::ProxyAuthError < ::Faraday::ClientError; end

# ProxyOptions contains the configurable properties for the proxy
# configuration used when making an HTTP request.
class Faraday::ProxyOptions < ::Faraday::Options
  extend ::Forwardable

  def host(*args, **_arg1, &block); end
  def host=(*args, **_arg1, &block); end
  def password; end
  def path(*args, **_arg1, &block); end
  def path=(*args, **_arg1, &block); end
  def port(*args, **_arg1, &block); end
  def port=(*args, **_arg1, &block); end
  def scheme(*args, **_arg1, &block); end
  def scheme=(*args, **_arg1, &block); end
  def user; end

  class << self
    def from(value); end
  end
end

# A Builder that processes requests into responses by passing through an inner
# middleware stack (heavily inspired by Rack).
#
# @example
#   Faraday::Connection.new(url: 'http://httpbingo.org') do |builder|
#   builder.request  :url_encoded  # Faraday::Request::UrlEncoded
#   builder.adapter  :net_http     # Faraday::Adapter::NetHttp
#   end
class Faraday::RackBuilder
  # @return [RackBuilder] a new instance of RackBuilder
  def initialize(&block); end

  def ==(other); end
  def [](idx); end
  def adapter(klass = T.unsafe(nil), *args, **_arg2, &block); end

  # The "rack app" wrapped in middleware. All requests are sent here.
  #
  # The builder is responsible for creating the app object. After this,
  # the builder gets locked to ensure no further modifications are made
  # to the middleware stack.
  #
  # Returns an object that responds to `call` and returns a Response.
  def app; end

  def build; end

  # ENV Keys
  # :http_method - a symbolized request HTTP method (:get, :post)
  # :body   - the request body that will eventually be converted to a string.
  # :url    - URI instance for the current request.
  # :status           - HTTP response status code
  # :request_headers  - hash of HTTP Headers to be sent to the server
  # :response_headers - Hash of HTTP headers from the server
  # :parallel_manager - sent if the connection is in parallel mode
  # :request - Hash of options for configuring the request.
  #   :timeout      - open/read timeout Integer in seconds
  #   :open_timeout - read timeout Integer in seconds
  #   :proxy        - Hash of proxy options
  #     :uri        - Proxy Server URI
  #     :user       - Proxy server username
  #     :password   - Proxy server password
  # :ssl - Hash of options for configuring SSL requests.
  def build_env(connection, request); end

  # Processes a Request into a Response by passing it through this Builder's
  # middleware stack.
  #
  # @param connection [Faraday::Connection]
  # @param request [Faraday::Request]
  # @return [Faraday::Response]
  def build_response(connection, request); end

  def delete(handler); end

  # Returns the value of attribute handlers.
  def handlers; end

  # Sets the attribute handlers
  #
  # @param value the value to set the attribute handlers to.
  def handlers=(_arg0); end

  # methods to push onto the various positions in the stack:
  def insert(index, *args, **_arg2, &block); end

  def insert_after(index, *args, **_arg2, &block); end

  # methods to push onto the various positions in the stack:
  def insert_before(index, *args, **_arg2, &block); end

  # Locks the middleware stack to ensure no further modifications are made.
  def lock!; end

  # @return [Boolean]
  def locked?; end

  def request(key, *args, **_arg2, &block); end
  def response(key, *args, **_arg2, &block); end
  def swap(index, *args, **_arg2, &block); end
  def to_app; end
  def use(klass, *args, **_arg2, &block); end

  private

  # @return [Boolean]
  def adapter_set?; end

  def assert_index(index); end

  # @raise [MISSING_ADAPTER_ERROR]
  def ensure_adapter!; end

  def initialize_dup(original); end

  # @return [Boolean]
  def is_adapter?(klass); end

  def raise_if_adapter(klass); end

  # @raise [StackLocked]
  def raise_if_locked; end

  def use_symbol(mod, key, *args, **_arg3, &block); end
end

# borrowed from ActiveSupport::Dependencies::Reference &
# ActionDispatch::MiddlewareStack::Middleware
class Faraday::RackBuilder::Handler
  def initialize(klass, *args, **_arg2, &block); end

  def ==(other); end
  def build(app = T.unsafe(nil)); end
  def inspect; end
  def klass; end

  # Returns the value of attribute name.
  def name; end
end

Faraday::RackBuilder::Handler::REGISTRY = T.let(T.unsafe(nil), Faraday::AdapterRegistry)
Faraday::RackBuilder::LOCK_ERR = T.let(T.unsafe(nil), String)
Faraday::RackBuilder::MISSING_ADAPTER_ERROR = T.let(T.unsafe(nil), String)

# Used to detect missing arguments
Faraday::RackBuilder::NO_ARGUMENT = T.let(T.unsafe(nil), Object)

# Error raised when trying to modify the stack after calling `lock!`
class Faraday::RackBuilder::StackLocked < ::RuntimeError; end

# Used to setup URLs, params, headers, and the request body in a sane manner.
#
#
# @example
#   @connection.post do |req|
#   req.url 'http://localhost', 'a' => '1' # 'http://localhost?a=1'
#   req.headers['b'] = '2' # Header
#   req.params['c']  = '3' # GET Param
#   req['b']         = '2' # also Header
#   req.body = 'abc'
#   end
class Faraday::Request < ::Struct
  extend ::Faraday::MiddlewareRegistry

  # @param key [Object] key to look up in headers
  # @return [Object] value of the given header name
  def [](key); end

  # @param key [Object] key of header to write
  # @param value [Object] value of header
  def []=(key, value); end

  # Replace request headers, preserving the existing hash type.
  #
  # @param hash [Hash] new headers
  def headers=(hash); end

  # Marshal serialization support.
  #
  # @return [Hash] the hash ready to be serialized in Marshal.
  def marshal_dump; end

  # Marshal serialization support.
  # Restores the instance variables according to the +serialised+.
  #
  # @param serialised [Hash] the serialised object.
  def marshal_load(serialised); end

  # Replace params, preserving the existing hash type.
  #
  # @param hash [Hash] new params
  def params=(hash); end

  # @return [Env] the Env for this Request
  def to_env(connection); end

  # Update path and params.
  #
  # @param path [URI, String]
  # @param params [Hash, nil]
  # @return [void]
  def url(path, params = T.unsafe(nil)); end

  class << self
    # @param request_method [String]
    # @return [Request]
    # @yield [request] for block customization, if block given
    # @yieldparam request [Request]
    def create(request_method); end
  end
end

# Request middleware for the Authorization HTTP header
class Faraday::Request::Authorization < ::Faraday::Middleware
  # @param app [#call]
  # @param type [String, Symbol] Type of Authorization
  # @param params [Array<String, Proc, #call>] parameters to build the Authorization header.
  #   If the type is `:basic`, then these can be a login and password pair.
  #   Otherwise, a single value is expected that will be appended after the type.
  #   This value can be a proc or an object responding to `.call`, in which case
  #   it will be invoked on each request.
  # @return [Authorization] a new instance of Authorization
  def initialize(app, type, *params); end

  # @param env [Faraday::Env]
  def on_request(env); end

  private

  # @param type [String, Symbol]
  # @param params [Array]
  # @return [String] a header value
  def header_from(type, *params); end
end

Faraday::Request::Authorization::KEY = T.let(T.unsafe(nil), String)

# Middleware for instrumenting Requests.
class Faraday::Request::Instrumentation < ::Faraday::Middleware
  # Instruments requests using Active Support.
  #
  # Measures time spent only for synchronous requests.
  #
  # @example Using ActiveSupport::Notifications to measure time spent
  #   for Faraday requests.
  #   ActiveSupport::Notifications
  #   .subscribe('request.faraday') do |name, starts, ends, _, env|
  #   url = env[:url]
  #   http_method = env[:method].to_s.upcase
  #   duration = ends - starts
  #   $stderr.puts '[%s] %s %s (%.3f s)' %
  #   [url.host, http_method, url.request_uri, duration]
  #   end
  # @option options
  # @option options
  # @param app [#call]
  # @param options [nil, Hash] Options hash
  # @return [Instrumentation] a new instance of Instrumentation
  def initialize(app, options = T.unsafe(nil)); end

  # @param env [Faraday::Env]
  def call(env); end
end

# Options class used in Request::Instrumentation class.
class Faraday::Request::Instrumentation::Options < ::Faraday::Options
  # @return [Class]
  def instrumenter; end

  # @return [String]
  def name; end
end

# Request middleware that encodes the body as JSON.
#
# Processes only requests with matching Content-type or those without a type.
# If a request doesn't have a type but has a body, it sets the Content-type
# to JSON MIME-type.
#
# Doesn't try to encode bodies that already are in string form.
class Faraday::Request::Json < ::Faraday::Middleware
  def on_request(env); end

  private

  # @return [Boolean]
  def body?(env); end

  def encode(data); end

  # @yield []
  def match_content_type(env); end

  # @return [Boolean]
  def process_request?(env); end

  def request_type(env); end
end

Faraday::Request::Json::MIME_TYPE = T.let(T.unsafe(nil), String)
Faraday::Request::Json::MIME_TYPE_REGEX = T.let(T.unsafe(nil), Regexp)

# Middleware for supporting urlencoded requests.
class Faraday::Request::UrlEncoded < ::Faraday::Middleware
  # Encodes as "application/x-www-form-urlencoded" if not already encoded or
  # of another type.
  #
  # @param env [Faraday::Env]
  def call(env); end

  # @param env [Faraday::Env]
  # @yield [request_body] Body of the request
  def match_content_type(env); end

  # @param env [Faraday::Env]
  # @return [Boolean] True if the request has a body and its Content-Type is
  #   urlencoded.
  def process_request?(env); end

  # @param env [Faraday::Env]
  # @return [String]
  def request_type(env); end

  class << self
    # Returns the value of attribute mime_type.
    def mime_type; end

    # Sets the attribute mime_type
    #
    # @param value the value to set the attribute mime_type to.
    def mime_type=(_arg0); end
  end
end

Faraday::Request::UrlEncoded::CONTENT_TYPE = T.let(T.unsafe(nil), String)

# RequestOptions contains the configurable properties for a Faraday request.
class Faraday::RequestOptions < ::Faraday::Options
  def []=(key, value); end

  # @return [Boolean]
  def stream_response?; end
end

# Raised by Faraday::Response::RaiseError in case of a 404 response.
class Faraday::ResourceNotFound < ::Faraday::ClientError; end

# Response represents an HTTP response from making an HTTP request.
class Faraday::Response
  extend ::Forwardable
  extend ::Faraday::MiddlewareRegistry

  # @return [Response] a new instance of Response
  def initialize(env = T.unsafe(nil)); end

  def [](*args, **_arg1, &block); end

  # Expand the env with more properties, without overriding existing ones.
  # Useful for applying request params after restoring a marshalled Response.
  def apply_request(request_env); end

  def body; end

  # Returns the value of attribute env.
  def env; end

  def finish(env); end

  # @return [Boolean]
  def finished?; end

  def headers; end

  # because @on_complete_callbacks cannot be marshalled
  def marshal_dump; end

  def marshal_load(env); end
  def on_complete(&block); end
  def reason_phrase; end
  def status; end

  # @return [Boolean]
  def success?; end

  def to_hash; end
end

# Parse response bodies as JSON.
class Faraday::Response::Json < ::Faraday::Middleware
  # @return [Json] a new instance of Json
  def initialize(app = T.unsafe(nil), parser_options: T.unsafe(nil), content_type: T.unsafe(nil), preserve_raw: T.unsafe(nil)); end

  def on_complete(env); end

  private

  def parse(body); end

  # @return [Boolean]
  def parse_response?(env); end

  def process_response(env); end

  # @return [Boolean]
  def process_response_type?(env); end

  def response_type(env); end
end

# Logger is a middleware that logs internal events in the HTTP request
# lifecycle to a given Logger object. By default, this logs to STDOUT. See
# Faraday::Logging::Formatter to see specifically what is logged.
class Faraday::Response::Logger < ::Faraday::Middleware
  # @return [Logger] a new instance of Logger
  # @yield [@formatter]
  def initialize(app, logger = T.unsafe(nil), options = T.unsafe(nil)); end

  def call(env); end
  def on_complete(env); end
end

# RaiseError is a Faraday middleware that raises exceptions on common HTTP
# client or server error responses.
class Faraday::Response::RaiseError < ::Faraday::Middleware
  def on_complete(env); end
  def query_params(env); end
  def response_values(env); end
end

Faraday::Response::RaiseError::ClientErrorStatuses = T.let(T.unsafe(nil), Range)
Faraday::Response::RaiseError::ServerErrorStatuses = T.let(T.unsafe(nil), Range)

# A unified client error for SSL errors.
class Faraday::SSLError < ::Faraday::Error; end

# SSL-related options.
class Faraday::SSLOptions < ::Faraday::Options
  # @return [Boolean] true if should not verify
  def disable?; end

  # @return [Boolean] true if should verify
  def verify?; end

  # @return [Boolean] true if should verify_hostname
  def verify_hostname?; end
end

# Faraday server error class. Represents 5xx status responses.
class Faraday::ServerError < ::Faraday::Error; end

# A unified client error for timeouts.
class Faraday::TimeoutError < ::Faraday::ServerError
  # @return [TimeoutError] a new instance of TimeoutError
  def initialize(exc = T.unsafe(nil), response = T.unsafe(nil)); end
end

# Raised by Faraday::Response::RaiseError in case of a 401 response.
class Faraday::UnauthorizedError < ::Faraday::ClientError; end

# Raised by Faraday::Response::RaiseError in case of a 422 response.
class Faraday::UnprocessableEntityError < ::Faraday::ClientError; end

Faraday::UploadIO = Multipart::Post::UploadIO

# Utils contains various static helper methods.
module Faraday::Utils
  private

  # Normalize URI() behavior across Ruby versions
  #
  # url - A String or URI.
  #
  # Returns a parsed URI.
  def URI(url); end

  def basic_header_from(login, pass); end
  def build_nested_query(params); end
  def build_query(params); end

  # Recursive hash merge
  def deep_merge(source, hash); end

  # Recursive hash update
  def deep_merge!(target, hash); end

  def default_params_encoder; end
  def default_space_encoding; end
  def default_uri_parser; end
  def default_uri_parser=(parser); end
  def escape(str); end

  # Receives a String or URI and returns just
  # the path with the query string sorted.
  def normalize_path(url); end

  def parse_nested_query(query); end

  # Adapted from Rack
  def parse_query(query); end

  def sort_query_params(query); end
  def unescape(str); end

  class << self
    # Normalize URI() behavior across Ruby versions
    #
    # url - A String or URI.
    #
    # Returns a parsed URI.
    def URI(url); end

    def basic_header_from(login, pass); end
    def build_nested_query(params); end
    def build_query(params); end

    # Recursive hash merge
    def deep_merge(source, hash); end

    # Recursive hash update
    def deep_merge!(target, hash); end

    def default_params_encoder; end

    # Sets the attribute default_params_encoder
    #
    # @param value the value to set the attribute default_params_encoder to.
    def default_params_encoder=(_arg0); end

    def default_space_encoding; end

    # Sets the attribute default_space_encoding
    #
    # @param value the value to set the attribute default_space_encoding to.
    def default_space_encoding=(_arg0); end

    def default_uri_parser; end
    def default_uri_parser=(parser); end
    def escape(str); end

    # Receives a String or URI and returns just
    # the path with the query string sorted.
    def normalize_path(url); end

    def parse_nested_query(query); end

    # Adapted from Rack
    def parse_query(query); end

    def sort_query_params(query); end
    def unescape(str); end
  end
end

Faraday::Utils::DEFAULT_SEP = T.let(T.unsafe(nil), Regexp)
Faraday::Utils::ESCAPE_RE = T.let(T.unsafe(nil), Regexp)

# A case-insensitive Hash that preserves the original case of a header
# when set.
#
# Adapted from Rack::Utils::HeaderHash
class Faraday::Utils::Headers < ::Hash
  # @return [Headers] a new instance of Headers
  def initialize(hash = T.unsafe(nil)); end

  def [](key); end
  def []=(key, val); end
  def delete(key); end
  def fetch(key, *args, &block); end

  # @return [Boolean]
  def has_key?(key); end

  # @return [Boolean]
  def include?(key); end

  def initialize_names; end

  # @return [Boolean]
  def key?(key); end

  # @return [Boolean]
  def member?(key); end

  def merge(other); end
  def merge!(other); end
  def parse(header_string); end
  def replace(other); end
  def to_hash; end
  def update(other); end

  protected

  # Returns the value of attribute names.
  def names; end

  private

  # Join multiple values with a comma.
  def add_parsed(key, value); end

  # on dup/clone, we need to duplicate @names hash
  def initialize_copy(other); end

  class << self
    def allocate; end
    def from(value); end
  end
end

# symbol -> string mapper + cache
Faraday::Utils::Headers::KeyMap = T.let(T.unsafe(nil), Hash)

# A hash with stringified keys.
class Faraday::Utils::ParamsHash < ::Hash
  def [](key); end
  def []=(key, value); end
  def delete(key); end

  # @return [Boolean]
  def has_key?(key); end

  # @return [Boolean]
  def include?(key); end

  # @return [Boolean]
  def key?(key); end

  # @return [Boolean]
  def member?(key); end

  def merge(params); end
  def merge!(params); end
  def merge_query(query, encoder = T.unsafe(nil)); end
  def replace(other); end
  def to_query(encoder = T.unsafe(nil)); end
  def update(params); end

  private

  def convert_key(key); end
end

Faraday::VERSION = T.let(T.unsafe(nil), String)
