# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `faraday-follow_redirects` gem.
# Please instead update this file by running `bin/tapioca gem faraday-follow_redirects`.

# conn.get '/'
module Faraday
  class << self
    # @overload default_adapter
    # @overload default_adapter=
    def default_adapter; end

    # Documented elsewhere, see default_adapter reader
    def default_adapter=(adapter); end

    # Option for the default_adapter
    #   @return [Hash] default_adapter options
    def default_adapter_options; end

    # Option for the default_adapter
    #   @return [Hash] default_adapter options
    def default_adapter_options=(_arg0); end

    # @overload default_connection
    # @overload default_connection=
    def default_connection; end

    # Documented below, see default_connection
    def default_connection=(_arg0); end

    # Gets the default connection options used when calling {Faraday#new}.
    #
    # @return [Faraday::ConnectionOptions]
    def default_connection_options; end

    # Sets the default options used when calling {Faraday#new}.
    #
    # @param options [Hash, Faraday::ConnectionOptions]
    def default_connection_options=(options); end

    # Tells Faraday to ignore the environment proxy (http_proxy).
    # Defaults to `false`.
    #
    # @return [Boolean]
    def ignore_env_proxy; end

    # Tells Faraday to ignore the environment proxy (http_proxy).
    # Defaults to `false`.
    #
    # @return [Boolean]
    def ignore_env_proxy=(_arg0); end

    # Gets or sets the path that the Faraday libs are loaded from.
    #
    # @return [String]
    def lib_path; end

    # Gets or sets the path that the Faraday libs are loaded from.
    #
    # @return [String]
    def lib_path=(_arg0); end

    # Initializes a new {Connection}.
    #
    # @example With an URL argument
    #   Faraday.new 'http://faraday.com'
    #   # => Faraday::Connection to http://faraday.com
    # @example With everything in an options hash
    #   Faraday.new url: 'http://faraday.com',
    #   params: { page: 1 }
    #   # => Faraday::Connection to http://faraday.com?page=1
    # @example With an URL argument and an options hash
    #   Faraday.new 'http://faraday.com', params: { page: 1 }
    #   # => Faraday::Connection to http://faraday.com?page=1
    # @option options
    # @option options
    # @option options
    # @option options
    # @option options
    # @option options
    # @param url [String, Hash] The optional String base URL to use as a prefix
    #   for all requests.  Can also be the options Hash. Any of these
    #   values will be set on every request made, unless overridden
    #   for a specific request.
    # @param options [Hash]
    # @return [Faraday::Connection]
    def new(url = T.unsafe(nil), options = T.unsafe(nil), &block); end

    # @return [Boolean]
    def respond_to_missing?(symbol, include_private = T.unsafe(nil)); end

    # The root path that Faraday is being loaded from.
    #
    # This is the root from where the libraries are auto-loaded.
    #
    # @return [String]
    def root_path; end

    # The root path that Faraday is being loaded from.
    #
    # This is the root from where the libraries are auto-loaded.
    #
    # @return [String]
    def root_path=(_arg0); end

    private

    # Internal: Proxies method calls on the Faraday constant to
    # .default_connection.
    def method_missing(name, *args, &block); end
  end
end

Faraday::CONTENT_TYPE = T.let(T.unsafe(nil), String)
Faraday::CompositeReadIO = Faraday::Multipart::CompositeReadIO
Faraday::FilePart = Multipart::Post::UploadIO

# Main Faraday::FollowRedirects module.
module Faraday::FollowRedirects; end

# Public: Follow HTTP 301, 302, 303, 307, and 308 redirects.
#
# For HTTP 301, 302, and 303, the original GET, POST, PUT, DELETE, or PATCH
# request gets converted into a GET. With `:standards_compliant => true`,
# however, the HTTP method after 301/302 remains unchanged. This allows you
# to opt into HTTP/1.1 compliance and act unlike the major web browsers.
#
# This middleware currently only works with synchronous requests; i.e. it
# doesn't support parallelism.
#
# If you wish to persist cookies across redirects, you could use
# the faraday-cookie_jar gem:
#
#   Faraday.new(:url => url) do |faraday|
#     faraday.use FaradayMiddleware::FollowRedirects
#     faraday.use :cookie_jar
#     faraday.adapter Faraday.default_adapter
#   end
class Faraday::FollowRedirects::Middleware < ::Faraday::Middleware
  # Public: Initialize the middleware.
  #
  # options - An options Hash (default: {}):
  #     :limit                      - A Numeric redirect limit (default: 3)
  #     :standards_compliant        - A Boolean indicating whether to respect
  #                                  the HTTP spec when following 301/302
  #                                  (default: false)
  #     :callback                   - A callable used on redirects
  #                                  with the old and new envs
  #     :cookies                    - An Array of Strings (e.g.
  #                                  ['cookie1', 'cookie2']) to choose
  #                                  cookies to be kept, or :all to keep
  #                                  all cookies (default: []).
  #     :clear_authorization_header - A Boolean indicating whether the request
  #                                  Authorization header should be cleared on
  #                                  redirects (default: true)
  #
  # @return [Middleware] a new instance of Middleware
  def initialize(app, options = T.unsafe(nil)); end

  def call(env); end

  private

  def callback; end
  def clear_authorization_header(env, from_url, to_url); end

  # @return [Boolean]
  def convert_to_get?(response); end

  def follow_limit; end

  # @return [Boolean]
  def follow_redirect?(env, response); end

  def perform_with_redirection(env, follows); end

  # @return [Boolean]
  def redirect_to_same_host?(from_url, to_url); end

  # Internal: escapes unsafe characters from an URL which might be a path
  # component only or a fully qualified URI so that it can be joined onto an
  # URI:HTTP using the `+` operator. Doesn't escape "%" characters so to not
  # risk double-escaping.
  def safe_escape(uri); end

  # @return [Boolean]
  def standards_compliant?; end

  def update_env(env, request_body, response); end
end

# HTTP methods for which 30x redirects can be followed
Faraday::FollowRedirects::Middleware::ALLOWED_METHODS = T.let(T.unsafe(nil), Set)

Faraday::FollowRedirects::Middleware::AUTH_HEADER = T.let(T.unsafe(nil), String)

# Keys in env hash which will get cleared between requests
Faraday::FollowRedirects::Middleware::ENV_TO_CLEAR = T.let(T.unsafe(nil), Set)

# Default value for max redirects followed
Faraday::FollowRedirects::Middleware::FOLLOW_LIMIT = T.let(T.unsafe(nil), Integer)

# HTTP redirect status codes that this middleware implements
Faraday::FollowRedirects::Middleware::REDIRECT_CODES = T.let(T.unsafe(nil), Set)

# Regex that matches characters that need to be escaped in URLs, sans
# the "%" character which we assume already represents an escaped sequence.
Faraday::FollowRedirects::Middleware::URI_UNSAFE = T.let(T.unsafe(nil), Regexp)

# Exception thrown when the maximum amount of requests is
# exceeded.
class Faraday::FollowRedirects::RedirectLimitReached < ::Faraday::ClientError
  # @return [RedirectLimitReached] a new instance of RedirectLimitReached
  def initialize(response); end

  # Returns the value of attribute response.
  def response; end
end

Faraday::FollowRedirects::VERSION = T.let(T.unsafe(nil), String)
Faraday::METHODS_WITH_BODY = T.let(T.unsafe(nil), Array)
Faraday::METHODS_WITH_QUERY = T.let(T.unsafe(nil), Array)
Faraday::ParamPart = Faraday::Multipart::ParamPart
Faraday::Parts = Multipart::Post::Parts
Faraday::UploadIO = Multipart::Post::UploadIO
Faraday::VERSION = T.let(T.unsafe(nil), String)
