# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `coderay` gem.
# Please instead update this file by running `bin/tapioca gem coderay`.

# = CodeRay Library
#
# CodeRay is a Ruby library for syntax highlighting.
#
# I try to make CodeRay easy to use and intuitive, but at the same time fully
# featured, complete, fast and efficient.
#
# See README.
#
# It consists mainly of
# * the main engine: CodeRay (Scanners::Scanner, Tokens, Encoders::Encoder)
# * the plugin system: PluginHost, Plugin
# * the scanners in CodeRay::Scanners
# * the encoders in CodeRay::Encoders
# * the styles in CodeRay::Styles
#
# Here's a fancy graphic to light up this gray docu:
#
# http://cycnus.de/raindark/coderay/scheme.png
#
# == Documentation
#
# See CodeRay, Encoders, Scanners, Tokens.
#
# == Usage
#
# Remember you need RubyGems to use CodeRay, unless you have it in your load
# path. Run Ruby with -rubygems option if required.
#
# === Highlight Ruby code in a string as html
#
#   require 'coderay'
#   print CodeRay.scan('puts "Hello, world!"', :ruby).html
#
#   # prints something like this:
#   puts <span class="s">&quot;Hello, world!&quot;</span>
#
#
# === Highlight C code from a file in a html div
#
#   require 'coderay'
#   print CodeRay.scan(File.read('ruby.h'), :c).div
#   print CodeRay.scan_file('ruby.h').html.div
#
# You can include this div in your page. The used CSS styles can be printed with
#
#   % coderay_stylesheet
#
# === Highlight without typing too much
#
# If you are one of the hasty (or lazy, or extremely curious) people, just run this file:
#
#   % ruby -rubygems /path/to/coderay/coderay.rb > example.html
#
# and look at the file it created in your browser.
#
# = CodeRay Module
#
# The CodeRay module provides convenience methods for the engine.
#
# * The +lang+ and +format+ arguments select Scanner and Encoder to use. These are
#   simply lower-case symbols, like <tt>:python</tt> or <tt>:html</tt>.
# * All methods take an optional hash as last parameter, +options+, that is send to
#   the Encoder / Scanner.
# * Input and language are always sorted in this order: +code+, +lang+.
#   (This is in alphabetical order, if you need a mnemonic ;)
#
# You should be able to highlight everything you want just using these methods;
# so there is no need to dive into CodeRay's deep class hierarchy.
#
# The examples in the demo directory demonstrate common cases using this interface.
#
# = Basic Access Ways
#
# Read this to get a general view what CodeRay provides.
#
# == Scanning
#
# Scanning means analysing an input string, splitting it up into Tokens.
# Each Token knows about what type it is: string, comment, class name, etc.
#
# Each +lang+ (language) has its own Scanner; for example, <tt>:ruby</tt> code is
# handled by CodeRay::Scanners::Ruby.
#
# CodeRay.scan:: Scan a string in a given language into Tokens.
#                This is the most common method to use.
# CodeRay.scan_file:: Scan a file and guess the language using FileType.
#
# The Tokens object you get from these methods can encode itself; see Tokens.
#
# == Encoding
#
# Encoding means compiling Tokens into an output. This can be colored HTML or
# LaTeX, a textual statistic or just the number of non-whitespace tokens.
#
# Each Encoder provides output in a specific +format+, so you select Encoders via
# formats like <tt>:html</tt> or <tt>:statistic</tt>.
#
# CodeRay.encode:: Scan and encode a string in a given language.
# CodeRay.encode_tokens:: Encode the given tokens.
# CodeRay.encode_file:: Scan a file, guess the language using FileType and encode it.
#
# == All-in-One Encoding
#
# CodeRay.encode:: Highlight a string with a given input and output format.
#
# == Instanciating
#
# You can use an Encoder instance to highlight multiple inputs. This way, the setup
# for this Encoder must only be done once.
#
# CodeRay.encoder:: Create an Encoder instance with format and options.
# CodeRay.scanner:: Create an Scanner instance for lang, with '' as default code.
#
# To make use of CodeRay.scanner, use CodeRay::Scanner::code=.
#
# The scanning methods provide more flexibility; we recommend to use these.
#
# == Reusing Scanners and Encoders
#
# If you want to re-use scanners and encoders (because that is faster), see
# CodeRay::Duo for the most convenient (and recommended) interface.
#
# source://coderay-1.1.3/lib/coderay.rb:126
module CodeRay
  class << self
    # Assuming the path is a subpath of lib/coderay/
    #
    # source://coderay-1.1.3/lib/coderay.rb:133
    def coderay_path(*path); end

    # Encode a string.
    #
    # This scans +code+ with the the Scanner for +lang+ and then
    # encodes it with the Encoder for +format+.
    # +options+ will be passed to the Encoder.
    #
    # See CodeRay::Encoder.encode.
    #
    # source://coderay-1.1.3/lib/coderay.rb:196
    def encode(code, lang, format, options = T.unsafe(nil)); end

    # Encodes +filename+ (a path to a code file) with the Scanner for +lang+.
    #
    # See CodeRay.scan_file.
    # Notice that the second argument is the output +format+, not the input language.
    #
    # Example:
    #  require 'coderay'
    #  page = CodeRay.encode_file 'some_c_code.c', :html
    #
    # source://coderay-1.1.3/lib/coderay.rb:221
    def encode_file(filename, format, options = T.unsafe(nil)); end

    # Encode pre-scanned Tokens.
    # Use this together with CodeRay.scan:
    #
    #  require 'coderay'
    #
    #  # Highlight a short Ruby code example in a HTML span
    #  tokens = CodeRay.scan '1 + 2', :ruby
    #  puts CodeRay.encode_tokens(tokens, :span)
    #
    # source://coderay-1.1.3/lib/coderay.rb:209
    def encode_tokens(tokens, format, options = T.unsafe(nil)); end

    # Finds the Encoder class for +format+ and creates an instance, passing
    # +options+ to it.
    #
    # Example:
    #  require 'coderay'
    #
    #  stats = CodeRay.encoder(:statistic)
    #  stats.encode("puts 17 + 4\n", :ruby)
    #
    #  puts '%d out of %d tokens have the kind :integer.' % [
    #    stats.type_stats[:integer].count,
    #    stats.real_token_count
    #  ]
    #  #-> 2 out of 4 tokens have the kind :integer.
    #
    # source://coderay-1.1.3/lib/coderay.rb:260
    def encoder(format, options = T.unsafe(nil)); end

    # Extract the options for the scanner from the +options+ hash.
    #
    # Returns an empty Hash if <tt>:scanner_options</tt> is not set.
    #
    # This is used if a method like CodeRay.encode has to provide options
    # for Encoder _and_ scanner.
    #
    # source://coderay-1.1.3/lib/coderay.rb:278
    def get_scanner_options(options); end

    # Highlight a string into a HTML <div>.
    #
    # CSS styles use classes, so you have to include a stylesheet
    # in your output.
    #
    # See encode.
    #
    # source://coderay-1.1.3/lib/coderay.rb:232
    def highlight(code, lang, options = T.unsafe(nil), format = T.unsafe(nil)); end

    # Highlight a file into a HTML <div>.
    #
    # CSS styles use classes, so you have to include a stylesheet
    # in your output.
    #
    # See encode.
    #
    # source://coderay-1.1.3/lib/coderay.rb:242
    def highlight_file(filename, options = T.unsafe(nil), format = T.unsafe(nil)); end

    # Scans the given +code+ (a String) with the Scanner for +lang+.
    #
    # This is a simple way to use CodeRay. Example:
    #  require 'coderay'
    #  page = CodeRay.scan("puts 'Hello, world!'", :ruby).html
    #
    # See also demo/demo_simple.
    #
    # source://coderay-1.1.3/lib/coderay.rb:168
    def scan(code, lang, options = T.unsafe(nil), &block); end

    # Scans +filename+ (a path to a code file) with the Scanner for +lang+.
    #
    # If +lang+ is :auto or omitted, the CodeRay::FileType module is used to
    # determine it. If it cannot find out what type it is, it uses
    # CodeRay::Scanners::Text.
    #
    # Calls CodeRay.scan.
    #
    # Example:
    #  require 'coderay'
    #  page = CodeRay.scan_file('some_c_code.c').html
    #
    # source://coderay-1.1.3/lib/coderay.rb:183
    def scan_file(filename, lang = T.unsafe(nil), options = T.unsafe(nil), &block); end

    # Finds the Scanner class for +lang+ and creates an instance, passing
    # +options+ to it.
    #
    # See Scanner.new.
    #
    # source://coderay-1.1.3/lib/coderay.rb:268
    def scanner(lang, options = T.unsafe(nil), &block); end
  end
end

# source://coderay-1.1.3/lib/coderay.rb:130
CodeRay::CODERAY_PATH = T.let(T.unsafe(nil), String)

# = Duo
#
# A Duo is a convenient way to use CodeRay. You just create a Duo,
# giving it a lang (language of the input code) and a format (desired
# output format), and call Duo#highlight with the code.
#
# Duo makes it easy to re-use both scanner and encoder for a repetitive
# task. It also provides a very easy interface syntax:
#
#   require 'coderay'
#   CodeRay::Duo[:python, :div].highlight 'import this'
#
# Until you want to do uncommon things with CodeRay, I recommend to use
# this method, since it takes care of everything.
#
# source://coderay-1.1.3/lib/coderay/duo.rb:17
class CodeRay::Duo
  # Create a new Duo, holding a lang and a format to highlight code.
  #
  # simple:
  #   CodeRay::Duo[:ruby, :html].highlight 'bla 42'
  #
  # with options:
  #   CodeRay::Duo[:ruby, :html, :hint => :debug].highlight '????::??'
  #
  # alternative syntax without options:
  #   CodeRay::Duo[:ruby => :statistic].encode 'class << self; end'
  #
  # alternative syntax with options:
  #   CodeRay::Duo[{ :ruby => :statistic }, :do => :something].encode 'abc'
  #
  # The options are forwarded to scanner and encoder
  # (see CodeRay.get_scanner_options).
  #
  # @return [Duo] a new instance of Duo
  #
  # source://coderay-1.1.3/lib/coderay/duo.rb:37
  def initialize(lang = T.unsafe(nil), format = T.unsafe(nil), options = T.unsafe(nil)); end

  # Tokenize and highlight the code using +scanner+ and +encoder+.
  # Allows to use Duo like a proc object:
  #
  #  CodeRay::Duo[:python => :yaml].call(code)
  #
  # or, in Ruby 1.9 and later:
  #
  #  CodeRay::Duo[:python => :yaml].(code)
  #
  # source://coderay-1.1.3/lib/coderay/duo.rb:64
  def call(code, options = T.unsafe(nil)); end

  # Tokenize and highlight the code using +scanner+ and +encoder+.
  #
  # source://coderay-1.1.3/lib/coderay/duo.rb:64
  def encode(code, options = T.unsafe(nil)); end

  # The encoder of the duo. Only created once.
  #
  # source://coderay-1.1.3/lib/coderay/duo.rb:59
  def encoder; end

  # Returns the value of attribute format.
  #
  # source://coderay-1.1.3/lib/coderay/duo.rb:19
  def format; end

  # Sets the attribute format
  #
  # @param value the value to set the attribute format to.
  #
  # source://coderay-1.1.3/lib/coderay/duo.rb:19
  def format=(_arg0); end

  # Tokenize and highlight the code using +scanner+ and +encoder+.
  #
  # source://coderay-1.1.3/lib/coderay/duo.rb:64
  def highlight(code, options = T.unsafe(nil)); end

  # Returns the value of attribute lang.
  #
  # source://coderay-1.1.3/lib/coderay/duo.rb:19
  def lang; end

  # Sets the attribute lang
  #
  # @param value the value to set the attribute lang to.
  #
  # source://coderay-1.1.3/lib/coderay/duo.rb:19
  def lang=(_arg0); end

  # Returns the value of attribute options.
  #
  # source://coderay-1.1.3/lib/coderay/duo.rb:19
  def options; end

  # Sets the attribute options
  #
  # @param value the value to set the attribute options to.
  #
  # source://coderay-1.1.3/lib/coderay/duo.rb:19
  def options=(_arg0); end

  # The scanner of the duo. Only created once.
  #
  # source://coderay-1.1.3/lib/coderay/duo.rb:54
  def scanner; end

  class << self
    # To allow calls like Duo[:ruby, :html].highlight.
    def [](*_arg0); end
  end
end

# This module holds the Encoder class and its subclasses.
# For example, the HTML encoder is named CodeRay::Encoders::HTML
# can be found in coderay/encoders/html.
#
# Encoders also provides methods and constants for the register
# mechanism and the [] method that returns the Encoder class
# belonging to the given format.
#
# source://coderay-1.1.3/lib/coderay/encoders.rb:10
module CodeRay::Encoders
  extend ::CodeRay::PluginHost
end

# A simple Filter that removes all tokens of the :comment kind.
#
# Alias: +remove_comments+
#
# Usage:
#  CodeRay.scan('print # foo', :ruby).comment_filter.text
#  #-> "print "
#
# See also: TokenKindFilter, LinesOfCode
#
# source://coderay-1.1.3/lib/coderay/encoders/comment_filter.rb:15
class CodeRay::Encoders::CommentFilter < ::CodeRay::Encoders::TokenKindFilter; end

# source://coderay-1.1.3/lib/coderay/encoders/comment_filter.rb:19
CodeRay::Encoders::CommentFilter::DEFAULT_OPTIONS = T.let(T.unsafe(nil), Hash)

# Returns the number of tokens.
#
# Text and block tokens are counted.
#
# source://coderay-1.1.3/lib/coderay/encoders/count.rb:7
class CodeRay::Encoders::Count < ::CodeRay::Encoders::Encoder
  # source://coderay-1.1.3/lib/coderay/encoders/count.rb:29
  def begin_group(kind); end

  # source://coderay-1.1.3/lib/coderay/encoders/count.rb:29
  def begin_line(kind); end

  # source://coderay-1.1.3/lib/coderay/encoders/count.rb:29
  def end_group(kind); end

  # source://coderay-1.1.3/lib/coderay/encoders/count.rb:29
  def end_line(kind); end

  # source://coderay-1.1.3/lib/coderay/encoders/count.rb:25
  def text_token(text, kind); end

  protected

  # source://coderay-1.1.3/lib/coderay/encoders/count.rb:19
  def finish(options); end

  # source://coderay-1.1.3/lib/coderay/encoders/count.rb:13
  def setup(options); end
end

# = Debug Encoder
#
# Fast encoder producing simple debug output.
#
# It is readable and diff-able and is used for testing.
#
# You cannot fully restore the tokens information from the
# output, because consecutive :space tokens are merged.
#
# See also: Scanners::Debug
#
# source://coderay-1.1.3/lib/coderay/encoders/debug.rb:14
class CodeRay::Encoders::Debug < ::CodeRay::Encoders::Encoder
  # source://coderay-1.1.3/lib/coderay/encoders/debug.rb:30
  def begin_group(kind); end

  # source://coderay-1.1.3/lib/coderay/encoders/debug.rb:38
  def begin_line(kind); end

  # source://coderay-1.1.3/lib/coderay/encoders/debug.rb:34
  def end_group(kind); end

  # source://coderay-1.1.3/lib/coderay/encoders/debug.rb:42
  def end_line(kind); end

  # source://coderay-1.1.3/lib/coderay/encoders/debug.rb:20
  def text_token(text, kind); end
end

# source://coderay-1.1.3/lib/coderay/encoders/debug.rb:18
CodeRay::Encoders::Debug::FILE_EXTENSION = T.let(T.unsafe(nil), String)

# = Debug Lint Encoder
#
# Debug encoder with additional checks for:
#
# - empty tokens
# - incorrect nesting
#
# It will raise an InvalidTokenStream exception when any of the above occurs.
#
# See also: Encoders::Debug
#
# source://coderay-1.1.3/lib/coderay/encoders/debug_lint.rb:16
class CodeRay::Encoders::DebugLint < ::CodeRay::Encoders::Debug
  # source://coderay-1.1.3/lib/coderay/encoders/debug_lint.rb:26
  def begin_group(kind); end

  # source://coderay-1.1.3/lib/coderay/encoders/debug_lint.rb:37
  def begin_line(kind); end

  # @raise [Lint::IncorrectTokenGroupNesting]
  #
  # source://coderay-1.1.3/lib/coderay/encoders/debug_lint.rb:31
  def end_group(kind); end

  # @raise [Lint::IncorrectTokenGroupNesting]
  #
  # source://coderay-1.1.3/lib/coderay/encoders/debug_lint.rb:42
  def end_line(kind); end

  # @raise [Lint::EmptyToken]
  #
  # source://coderay-1.1.3/lib/coderay/encoders/debug_lint.rb:20
  def text_token(text, kind); end

  protected

  # source://coderay-1.1.3/lib/coderay/encoders/debug_lint.rb:55
  def finish(options); end

  # source://coderay-1.1.3/lib/coderay/encoders/debug_lint.rb:50
  def setup(options); end
end

# Wraps HTML output into a DIV element, using inline styles by default.
#
# See Encoders::HTML for available options.
#
# source://coderay-1.1.3/lib/coderay/encoders/div.rb:9
class CodeRay::Encoders::Div < ::CodeRay::Encoders::HTML; end

# source://coderay-1.1.3/lib/coderay/encoders/div.rb:15
CodeRay::Encoders::Div::DEFAULT_OPTIONS = T.let(T.unsafe(nil), Hash)

# source://coderay-1.1.3/lib/coderay/encoders/div.rb:11
CodeRay::Encoders::Div::FILE_EXTENSION = T.let(T.unsafe(nil), String)

# = Encoder
#
# The Encoder base class. Together with Scanner and
# Tokens, it forms the highlighting triad.
#
# Encoder instances take a Tokens object and do something with it.
#
# The most common Encoder is surely the HTML encoder
# (CodeRay::Encoders::HTML). It highlights the code in a colorful
# html page.
# If you want the highlighted code in a div or a span instead,
# use its subclasses Div and Span.
#
# source://coderay-1.1.3/lib/coderay/encoders/encoder.rb:16
class CodeRay::Encoders::Encoder
  extend ::CodeRay::Plugin

  # Creates a new Encoder.
  # +options+ is saved and used for all encode operations, as long
  # as you don't overwrite it there by passing additional options.
  #
  # Encoder objects provide three encode methods:
  # - encode simply takes a +code+ string and a +lang+
  # - encode_tokens expects a +tokens+ object instead
  #
  # Each method has an optional +options+ parameter. These are
  # added to the options you passed at creation.
  #
  # @return [Encoder] a new instance of Encoder
  #
  # source://coderay-1.1.3/lib/coderay/encoders/encoder.rb:55
  def initialize(options = T.unsafe(nil)); end

  # source://coderay-1.1.3/lib/coderay/encoders/encoder.rb:87
  def <<(token); end

  # Starts a token group with the given +kind+.
  #
  # source://coderay-1.1.3/lib/coderay/encoders/encoder.rb:123
  def begin_group(kind); end

  # Starts a new line token group with the given +kind+.
  #
  # source://coderay-1.1.3/lib/coderay/encoders/encoder.rb:131
  def begin_line(kind); end

  # Encode the given +code+ using the Scanner for +lang+.
  #
  # source://coderay-1.1.3/lib/coderay/encoders/encoder.rb:70
  def encode(code, lang, options = T.unsafe(nil)); end

  # Encode a Tokens object.
  #
  # source://coderay-1.1.3/lib/coderay/encoders/encoder.rb:61
  def encode_tokens(tokens, options = T.unsafe(nil)); end

  # Ends a token group with the given +kind+.
  #
  # source://coderay-1.1.3/lib/coderay/encoders/encoder.rb:127
  def end_group(kind); end

  # Ends a new line token group with the given +kind+.
  #
  # source://coderay-1.1.3/lib/coderay/encoders/encoder.rb:135
  def end_line(kind); end

  # The default file extension for this encoder.
  #
  # source://coderay-1.1.3/lib/coderay/encoders/encoder.rb:83
  def file_extension; end

  # Encode the given +code+ using the Scanner for +lang+.
  # You can use highlight instead of encode, if that seems
  # more clear to you.
  #
  # source://coderay-1.1.3/lib/coderay/encoders/encoder.rb:70
  def highlight(code, lang, options = T.unsafe(nil)); end

  # The options you gave the Encoder at creating.
  #
  # source://coderay-1.1.3/lib/coderay/encoders/encoder.rb:43
  def options; end

  # The options you gave the Encoder at creating.
  #
  # source://coderay-1.1.3/lib/coderay/encoders/encoder.rb:43
  def options=(_arg0); end

  # The options you gave the Encoder at creating.
  #
  # source://coderay-1.1.3/lib/coderay/encoders/encoder.rb:43
  def scanner; end

  # The options you gave the Encoder at creating.
  #
  # source://coderay-1.1.3/lib/coderay/encoders/encoder.rb:43
  def scanner=(_arg0); end

  # Called for each text token ([text, kind]), where text is a String.
  #
  # source://coderay-1.1.3/lib/coderay/encoders/encoder.rb:118
  def text_token(text, kind); end

  # Called with +content+ and +kind+ of the currently scanned token.
  # For simple scanners, it's enougth to implement this method.
  #
  # By default, it calls text_token, begin_group, end_group, begin_line,
  # or end_line, depending on the +content+.
  #
  # source://coderay-1.1.3/lib/coderay/encoders/encoder.rb:100
  def token(content, kind); end

  # Do the encoding.
  #
  # The already created +tokens+ object must be used; it must be a
  # Tokens object.
  #
  # source://coderay-1.1.3/lib/coderay/encoders/encoder.rb:168
  def tokens(tokens, options = T.unsafe(nil)); end

  protected

  # Do the encoding.
  #
  # The already created +tokens+ object must be used; it must be a
  # Tokens object.
  #
  # source://coderay-1.1.3/lib/coderay/encoders/encoder.rb:168
  def compile(tokens, options = T.unsafe(nil)); end

  # Called with merged options after encoding starts.
  # The return value is the result of encoding, typically @out.
  #
  # source://coderay-1.1.3/lib/coderay/encoders/encoder.rb:160
  def finish(options); end

  # source://coderay-1.1.3/lib/coderay/encoders/encoder.rb:148
  def get_output(options); end

  # Append data.to_s to the output. Returns the argument.
  #
  # source://coderay-1.1.3/lib/coderay/encoders/encoder.rb:153
  def output(data); end

  # Called with merged options before encoding starts.
  # Sets @out to an empty string.
  #
  # See the HTML Encoder for an example of option caching.
  #
  # source://coderay-1.1.3/lib/coderay/encoders/encoder.rb:144
  def setup(options); end

  class << self
    # If FILE_EXTENSION isn't defined, this method returns the
    # downcase class name instead.
    #
    # source://coderay-1.1.3/lib/coderay/encoders/encoder.rb:24
    def const_missing(sym); end

    # The default file extension for output file of this encoder class.
    #
    # source://coderay-1.1.3/lib/coderay/encoders/encoder.rb:33
    def file_extension; end
  end
end

# Subclasses are to store their default options in this constant.
#
# source://coderay-1.1.3/lib/coderay/encoders/encoder.rb:40
CodeRay::Encoders::Encoder::DEFAULT_OPTIONS = T.let(T.unsafe(nil), Hash)

# source://coderay-1.1.3/lib/coderay/helpers/plugin.rb:41
CodeRay::Encoders::Encoder::PLUGIN_HOST = CodeRay::Encoders

# A Filter encoder has another Tokens instance as output.
# It can be subclass to select, remove, or modify tokens in the stream.
#
# Subclasses of Filter are called "Filters" and can be chained.
#
# == Options
#
# === :tokens
#
# The Tokens object which will receive the output.
#
# Default: Tokens.new
#
# See also: TokenKindFilter
#
# source://coderay-1.1.3/lib/coderay/encoders/filter.rb:18
class CodeRay::Encoders::Filter < ::CodeRay::Encoders::Encoder
  # source://coderay-1.1.3/lib/coderay/encoders/filter.rb:39
  def begin_group(kind); end

  # source://coderay-1.1.3/lib/coderay/encoders/filter.rb:43
  def begin_line(kind); end

  # source://coderay-1.1.3/lib/coderay/encoders/filter.rb:47
  def end_group(kind); end

  # source://coderay-1.1.3/lib/coderay/encoders/filter.rb:51
  def end_line(kind); end

  # source://coderay-1.1.3/lib/coderay/encoders/filter.rb:35
  def text_token(text, kind); end

  protected

  # source://coderay-1.1.3/lib/coderay/encoders/filter.rb:29
  def finish(options); end

  # source://coderay-1.1.3/lib/coderay/encoders/filter.rb:23
  def setup(options); end
end

# = HTML Encoder
#
# This is CodeRay's most important highlighter:
# It provides save, fast XHTML generation and CSS support.
#
# == Usage
#
#  require 'coderay'
#  puts CodeRay.scan('Some /code/', :ruby).html  #-> a HTML page
#  puts CodeRay.scan('Some /code/', :ruby).html(:wrap => :span)
#  #-> <span class="CodeRay"><span class="co">Some</span> /code/</span>
#  puts CodeRay.scan('Some /code/', :ruby).span  #-> the same
#
#  puts CodeRay.scan('Some code', :ruby).html(
#    :wrap => nil,
#    :line_numbers => :inline,
#    :css => :style
#  )
#
# == Options
#
# === :tab_width
# Convert \t characters to +n+ spaces (a number or false.)
# false will keep tab characters untouched.
#
# Default: 8
#
# === :css
# How to include the styles; can be :class or :style.
#
# Default: :class
#
# === :wrap
# Wrap in :page, :div, :span or nil.
#
# You can also use Encoders::Div and Encoders::Span.
#
# Default: nil
#
# === :title
#
# The title of the HTML page (works only when :wrap is set to :page.)
#
# Default: 'CodeRay output'
#
# === :break_lines
#
# Split multiline blocks at line breaks.
# Forced to true if :line_numbers option is set to :inline.
#
# Default: false
#
# === :line_numbers
# Include line numbers in :table, :inline, or nil (no line numbers)
#
# Default: nil
#
# === :line_number_anchors
# Adds anchors and links to the line numbers. Can be false (off), true (on),
# or a prefix string that will be prepended to the anchor name.
#
# The prefix must consist only of letters, digits, and underscores.
#
# Default: true, default prefix name: "line"
#
# === :line_number_start
# Where to start with line number counting.
#
# Default: 1
#
# === :bold_every
# Make every +n+-th number appear bold.
#
# Default: 10
#
# === :highlight_lines
#
# Highlights certain line numbers.
# Can be any Enumerable, typically just an Array or Range, of numbers.
#
# Bolding is deactivated when :highlight_lines is set. It only makes sense
# in combination with :line_numbers.
#
# Default: nil
#
# === :hint
# Include some information into the output using the title attribute.
# Can be :info (show token kind on mouse-over), :info_long (with full path)
# or :debug (via inspect).
#
# Default: false
#
# source://coderay-1.1.3/lib/coderay/encoders/html.rb:97
class CodeRay::Encoders::HTML < ::CodeRay::Encoders::Encoder
  # token groups, eg. strings
  #
  # source://coderay-1.1.3/lib/coderay/encoders/html.rb:235
  def begin_group(kind); end

  # whole lines to be highlighted, eg. a deleted line in a diff
  #
  # source://coderay-1.1.3/lib/coderay/encoders/html.rb:247
  def begin_line(kind); end

  # Returns the value of attribute css.
  #
  # source://coderay-1.1.3/lib/coderay/encoders/html.rb:126
  def css; end

  # source://coderay-1.1.3/lib/coderay/encoders/html.rb:241
  def end_group(kind); end

  # source://coderay-1.1.3/lib/coderay/encoders/html.rb:261
  def end_line(kind); end

  # source://coderay-1.1.3/lib/coderay/encoders/html.rb:221
  def text_token(text, kind); end

  protected

  # source://coderay-1.1.3/lib/coderay/encoders/html.rb:316
  def break_lines(text, style); end

  # source://coderay-1.1.3/lib/coderay/encoders/html.rb:310
  def check_group_nesting(name, kind); end

  # source://coderay-1.1.3/lib/coderay/encoders/html.rb:268
  def check_options!(options); end

  # source://coderay-1.1.3/lib/coderay/encoders/html.rb:324
  def close_span; end

  # source://coderay-1.1.3/lib/coderay/encoders/html.rb:280
  def css_class_for_kinds(kinds); end

  # source://coderay-1.1.3/lib/coderay/encoders/html.rb:195
  def finish(options); end

  # source://coderay-1.1.3/lib/coderay/encoders/html.rb:289
  def make_span_for_kinds(method, hint); end

  # source://coderay-1.1.3/lib/coderay/encoders/html.rb:172
  def setup(options); end

  # source://coderay-1.1.3/lib/coderay/encoders/html.rb:284
  def style_for_kinds(kinds); end

  class << self
    # source://coderay-1.1.3/lib/coderay/encoders/html.rb:130
    def make_html_escape_hash; end

    # Generate a hint about the given +kinds+ in a +hint+ style.
    #
    # +hint+ may be :info, :info_long or :debug.
    #
    # source://coderay-1.1.3/lib/coderay/encoders/html.rb:157
    def token_path_to_hint(hint, kinds); end
  end
end

# source://coderay-1.1.3/lib/coderay/encoders/html/css.rb:5
class CodeRay::Encoders::HTML::CSS
  # @return [CSS] a new instance of CSS
  #
  # source://coderay-1.1.3/lib/coderay/encoders/html/css.rb:13
  def initialize(style = T.unsafe(nil)); end

  # source://coderay-1.1.3/lib/coderay/encoders/html/css.rb:23
  def get_style_for_css_classes(css_classes); end

  # Returns the value of attribute stylesheet.
  #
  # source://coderay-1.1.3/lib/coderay/encoders/html/css.rb:7
  def stylesheet; end

  private

  # source://coderay-1.1.3/lib/coderay/encoders/html/css.rb:49
  def parse(stylesheet); end

  class << self
    # source://coderay-1.1.3/lib/coderay/encoders/html/css.rb:9
    def load_stylesheet(style = T.unsafe(nil)); end
  end
end

# source://coderay-1.1.3/lib/coderay/encoders/html/css.rb:36
CodeRay::Encoders::HTML::CSS::CSS_CLASS_PATTERN = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/encoders/html.rb:103
CodeRay::Encoders::HTML::DEFAULT_OPTIONS = T.let(T.unsafe(nil), Hash)

# source://coderay-1.1.3/lib/coderay/encoders/html.rb:101
CodeRay::Encoders::HTML::FILE_EXTENSION = T.let(T.unsafe(nil), String)

# source://coderay-1.1.3/lib/coderay/encoders/html.rb:143
CodeRay::Encoders::HTML::HTML_ESCAPE = T.let(T.unsafe(nil), Hash)

# source://coderay-1.1.3/lib/coderay/encoders/html.rb:144
CodeRay::Encoders::HTML::HTML_ESCAPE_PATTERN = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/encoders/html/numbering.rb:6
module CodeRay::Encoders::HTML::Numbering
  class << self
    # source://coderay-1.1.3/lib/coderay/encoders/html/numbering.rb:8
    def number!(output, mode = T.unsafe(nil), options = T.unsafe(nil)); end
  end
end

# This module is included in the output String of the HTML Encoder.
#
# It provides methods like wrap, div, page etc.
#
# Remember to use #clone instead of #dup to keep the modules the object was
# extended with.
#
# TODO: Rewrite this without monkey patching.
#
# source://coderay-1.1.3/lib/coderay/encoders/html/output.rb:14
module CodeRay::Encoders::HTML::Output
  # source://coderay-1.1.3/lib/coderay/encoders/html/output.rb:57
  def apply_title!(title); end

  # Returns the value of attribute css.
  #
  # source://coderay-1.1.3/lib/coderay/encoders/html/output.rb:16
  def css; end

  # Sets the attribute css
  #
  # @param value the value to set the attribute css to.
  #
  # source://coderay-1.1.3/lib/coderay/encoders/html/output.rb:16
  def css=(_arg0); end

  # source://coderay-1.1.3/lib/coderay/encoders/html/output.rb:86
  def stylesheet(in_tag = T.unsafe(nil)); end

  # source://coderay-1.1.3/lib/coderay/encoders/html/output.rb:62
  def wrap!(element, *args); end

  # source://coderay-1.1.3/lib/coderay/encoders/html/output.rb:52
  def wrap_in!(template); end

  # source://coderay-1.1.3/lib/coderay/encoders/html/output.rb:47
  def wrapped_in; end

  # Sets the attribute wrapped_in
  #
  # @param value the value to set the attribute wrapped_in to.
  #
  # source://coderay-1.1.3/lib/coderay/encoders/html/output.rb:50
  def wrapped_in=(_arg0); end

  # @return [Boolean]
  #
  # source://coderay-1.1.3/lib/coderay/encoders/html/output.rb:43
  def wrapped_in?(element); end

  class << self
    # Raises an exception if an object that doesn't respond to to_str is extended by Output,
    # to prevent users from misuse. Use Module#remove_method to disable.
    #
    # source://coderay-1.1.3/lib/coderay/encoders/html/output.rb:22
    def extended(o); end

    # source://coderay-1.1.3/lib/coderay/encoders/html/output.rb:26
    def make_stylesheet(css, in_tag = T.unsafe(nil)); end

    # source://coderay-1.1.3/lib/coderay/encoders/html/output.rb:36
    def page_template_for_css(css); end
  end
end

# source://coderay-1.1.3/lib/coderay/encoders/html/output.rb:117
CodeRay::Encoders::HTML::Output::DIV = T.let(T.unsafe(nil), CodeRay::Encoders::HTML::Output::Template)

# source://coderay-1.1.3/lib/coderay/encoders/html/output.rb:130
CodeRay::Encoders::HTML::Output::PAGE = T.let(T.unsafe(nil), CodeRay::Encoders::HTML::Output::Template)

# source://coderay-1.1.3/lib/coderay/encoders/html/output.rb:115
CodeRay::Encoders::HTML::Output::SPAN = T.let(T.unsafe(nil), CodeRay::Encoders::HTML::Output::Template)

# source://coderay-1.1.3/lib/coderay/encoders/html/output.rb:123
CodeRay::Encoders::HTML::Output::TABLE = T.let(T.unsafe(nil), CodeRay::Encoders::HTML::Output::Template)

# -- don't include the templates in docu
#
# source://coderay-1.1.3/lib/coderay/encoders/html/output.rb:92
class CodeRay::Encoders::HTML::Output::Template < ::String
  # source://coderay-1.1.3/lib/coderay/encoders/html/output.rb:104
  def apply(target, replacement); end

  class << self
    # source://coderay-1.1.3/lib/coderay/encoders/html/output.rb:94
    def wrap!(str, template, target); end
  end
end

# source://coderay-1.1.3/lib/coderay/encoders/html.rb:146
CodeRay::Encoders::HTML::TOKEN_KIND_TO_INFO = T.let(T.unsafe(nil), Hash)

# source://coderay-1.1.3/lib/coderay/encoders/html.rb:150
CodeRay::Encoders::HTML::TRANSPARENT_TOKEN_KINDS = T.let(T.unsafe(nil), Set)

# A simple JSON Encoder.
#
# Example:
#  CodeRay.scan('puts "Hello world!"', :ruby).json
# yields
#  [
#    {"type"=>"text", "text"=>"puts", "kind"=>"ident"},
#    {"type"=>"text", "text"=>" ", "kind"=>"space"},
#    {"type"=>"block", "action"=>"open", "kind"=>"string"},
#    {"type"=>"text", "text"=>"\"", "kind"=>"delimiter"},
#    {"type"=>"text", "text"=>"Hello world!", "kind"=>"content"},
#    {"type"=>"text", "text"=>"\"", "kind"=>"delimiter"},
#    {"type"=>"block", "action"=>"close", "kind"=>"string"},
#  ]
#
# source://coderay-1.1.3/lib/coderay/encoders/json.rb:18
class CodeRay::Encoders::JSON < ::CodeRay::Encoders::Encoder
  # source://coderay-1.1.3/lib/coderay/encoders/json.rb:64
  def begin_group(kind); end

  # source://coderay-1.1.3/lib/coderay/encoders/json.rb:72
  def begin_line(kind); end

  # source://coderay-1.1.3/lib/coderay/encoders/json.rb:68
  def end_group(kind); end

  # source://coderay-1.1.3/lib/coderay/encoders/json.rb:76
  def end_line(kind); end

  # source://coderay-1.1.3/lib/coderay/encoders/json.rb:60
  def text_token(text, kind); end

  protected

  # source://coderay-1.1.3/lib/coderay/encoders/json.rb:49
  def append(data); end

  # source://coderay-1.1.3/lib/coderay/encoders/json.rb:45
  def finish(options); end

  # source://coderay-1.1.3/lib/coderay/encoders/json.rb:38
  def setup(options); end
end

# source://coderay-1.1.3/lib/coderay/encoders/json.rb:35
CodeRay::Encoders::JSON::FILE_EXTENSION = T.let(T.unsafe(nil), String)

# Counts the LoC (Lines of Code). Returns an Integer >= 0.
#
# Alias: +loc+
#
# Everything that is not comment, markup, doctype/shebang, or an empty line,
# is considered to be code.
#
# For example,
# * HTML files not containing JavaScript have 0 LoC
# * in a Java class without comments, LoC is the number of non-empty lines
#
# A Scanner class should define the token kinds that are not code in the
# KINDS_NOT_LOC constant, which defaults to [:comment, :doctype].
#
# source://coderay-1.1.3/lib/coderay/encoders/lines_of_code.rb:17
class CodeRay::Encoders::LinesOfCode < ::CodeRay::Encoders::TokenKindFilter
  protected

  # source://coderay-1.1.3/lib/coderay/encoders/lines_of_code.rb:38
  def finish(options); end

  # source://coderay-1.1.3/lib/coderay/encoders/lines_of_code.rb:25
  def setup(options); end
end

# source://coderay-1.1.3/lib/coderay/encoders/lines_of_code.rb:21
CodeRay::Encoders::LinesOfCode::NON_EMPTY_LINE = T.let(T.unsafe(nil), Regexp)

# = Lint Encoder
#
# Checks for:
#
# - empty tokens
# - incorrect nesting
#
# It will raise an InvalidTokenStream exception when any of the above occurs.
#
# See also: Encoders::DebugLint
#
# source://coderay-1.1.3/lib/coderay/encoders/lint.rb:14
class CodeRay::Encoders::Lint < ::CodeRay::Encoders::Debug
  # source://coderay-1.1.3/lib/coderay/encoders/lint.rb:28
  def begin_group(kind); end

  # source://coderay-1.1.3/lib/coderay/encoders/lint.rb:37
  def begin_line(kind); end

  # @raise [IncorrectTokenGroupNesting]
  #
  # source://coderay-1.1.3/lib/coderay/encoders/lint.rb:32
  def end_group(kind); end

  # @raise [IncorrectTokenGroupNesting]
  #
  # source://coderay-1.1.3/lib/coderay/encoders/lint.rb:41
  def end_line(kind); end

  # @raise [EmptyToken]
  #
  # source://coderay-1.1.3/lib/coderay/encoders/lint.rb:23
  def text_token(text, kind); end

  protected

  # source://coderay-1.1.3/lib/coderay/encoders/lint.rb:52
  def finish(options); end

  # source://coderay-1.1.3/lib/coderay/encoders/lint.rb:48
  def setup(options); end
end

# source://coderay-1.1.3/lib/coderay/encoders/lint.rb:19
class CodeRay::Encoders::Lint::EmptyToken < ::CodeRay::Encoders::Lint::InvalidTokenStream; end

# source://coderay-1.1.3/lib/coderay/encoders/lint.rb:21
class CodeRay::Encoders::Lint::IncorrectTokenGroupNesting < ::CodeRay::Encoders::Lint::InvalidTokenStream; end

# source://coderay-1.1.3/lib/coderay/encoders/lint.rb:18
class CodeRay::Encoders::Lint::InvalidTokenStream < ::StandardError; end

# source://coderay-1.1.3/lib/coderay/encoders/lint.rb:20
class CodeRay::Encoders::Lint::UnknownTokenKind < ::CodeRay::Encoders::Lint::InvalidTokenStream; end

# = Null Encoder
#
# Does nothing and returns an empty string.
#
# source://coderay-1.1.3/lib/coderay/encoders/null.rb:7
class CodeRay::Encoders::Null < ::CodeRay::Encoders::Encoder
  # source://coderay-1.1.3/lib/coderay/encoders/null.rb:11
  def text_token(text, kind); end
end

# Wraps the output into a HTML page, using CSS classes and
# line numbers in the table format by default.
#
# See Encoders::HTML for available options.
#
# source://coderay-1.1.3/lib/coderay/encoders/page.rb:10
class CodeRay::Encoders::Page < ::CodeRay::Encoders::HTML; end

# source://coderay-1.1.3/lib/coderay/encoders/page.rb:16
CodeRay::Encoders::Page::DEFAULT_OPTIONS = T.let(T.unsafe(nil), Hash)

# source://coderay-1.1.3/lib/coderay/encoders/page.rb:12
CodeRay::Encoders::Page::FILE_EXTENSION = T.let(T.unsafe(nil), String)

# Wraps HTML output into a SPAN element, using inline styles by default.
#
# See Encoders::HTML for available options.
#
# source://coderay-1.1.3/lib/coderay/encoders/span.rb:9
class CodeRay::Encoders::Span < ::CodeRay::Encoders::HTML; end

# source://coderay-1.1.3/lib/coderay/encoders/span.rb:15
CodeRay::Encoders::Span::DEFAULT_OPTIONS = T.let(T.unsafe(nil), Hash)

# source://coderay-1.1.3/lib/coderay/encoders/span.rb:11
CodeRay::Encoders::Span::FILE_EXTENSION = T.let(T.unsafe(nil), String)

# Makes a statistic for the given tokens.
#
# Alias: +stats+
#
# source://coderay-1.1.3/lib/coderay/encoders/statistic.rb:7
class CodeRay::Encoders::Statistic < ::CodeRay::Encoders::Encoder
  # source://coderay-1.1.3/lib/coderay/encoders/statistic.rb:70
  def begin_group(kind); end

  # source://coderay-1.1.3/lib/coderay/encoders/statistic.rb:78
  def begin_line(kind); end

  # source://coderay-1.1.3/lib/coderay/encoders/statistic.rb:86
  def block_token(action, kind); end

  # source://coderay-1.1.3/lib/coderay/encoders/statistic.rb:74
  def end_group(kind); end

  # source://coderay-1.1.3/lib/coderay/encoders/statistic.rb:82
  def end_line(kind); end

  # source://coderay-1.1.3/lib/coderay/encoders/statistic.rb:11
  def real_token_count; end

  # source://coderay-1.1.3/lib/coderay/encoders/statistic.rb:62
  def text_token(text, kind); end

  # source://coderay-1.1.3/lib/coderay/encoders/statistic.rb:11
  def type_stats; end

  protected

  # source://coderay-1.1.3/lib/coderay/encoders/statistic.rb:42
  def finish(options); end

  # source://coderay-1.1.3/lib/coderay/encoders/statistic.rb:17
  def setup(options); end
end

# source://coderay-1.1.3/lib/coderay/encoders/statistic.rb:24
CodeRay::Encoders::Statistic::STATS = T.let(T.unsafe(nil), String)

# source://coderay-1.1.3/lib/coderay/encoders/statistic.rb:38
CodeRay::Encoders::Statistic::TOKEN_TYPES_ROW = T.let(T.unsafe(nil), String)

# source://coderay-1.1.3/lib/coderay/encoders/statistic.rb:13
class CodeRay::Encoders::Statistic::TypeStats < ::Struct
  # Returns the value of attribute count
  #
  # @return [Object] the current value of count
  def count; end

  # Sets the attribute count
  #
  # @param value [Object] the value to set the attribute count to.
  # @return [Object] the newly set value
  def count=(_); end

  # Returns the value of attribute size
  #
  # @return [Object] the current value of size
  def size; end

  # Sets the attribute size
  #
  # @param value [Object] the value to set the attribute size to.
  # @return [Object] the newly set value
  def size=(_); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

# source://coderay-1.1.3/lib/coderay/encoders/terminal.rb:17
class CodeRay::Encoders::Terminal < ::CodeRay::Encoders::Encoder
  # source://coderay-1.1.3/lib/coderay/encoders/terminal.rb:156
  def begin_group(kind); end

  # source://coderay-1.1.3/lib/coderay/encoders/terminal.rb:156
  def begin_line(kind); end

  # source://coderay-1.1.3/lib/coderay/encoders/terminal.rb:162
  def end_group(kind); end

  # source://coderay-1.1.3/lib/coderay/encoders/terminal.rb:172
  def end_line(kind); end

  # source://coderay-1.1.3/lib/coderay/encoders/terminal.rb:141
  def text_token(text, kind); end

  protected

  # source://coderay-1.1.3/lib/coderay/encoders/terminal.rb:133
  def setup(options); end

  private

  # source://coderay-1.1.3/lib/coderay/encoders/terminal.rb:179
  def open_token(kind); end
end

# source://coderay-1.1.3/lib/coderay/encoders/terminal.rb:21
CodeRay::Encoders::Terminal::TOKEN_COLORS = T.let(T.unsafe(nil), Hash)

# Concats the tokens into a single string, resulting in the original
# code string if no tokens were removed.
#
# Alias: +plain+, +plaintext+
#
# == Options
#
# === :separator
# A separator string to join the tokens.
#
# Default: empty String
#
# source://coderay-1.1.3/lib/coderay/encoders/text.rb:15
class CodeRay::Encoders::Text < ::CodeRay::Encoders::Encoder
  # source://coderay-1.1.3/lib/coderay/encoders/text.rb:25
  def text_token(text, kind); end

  protected

  # source://coderay-1.1.3/lib/coderay/encoders/text.rb:36
  def setup(options); end
end

# source://coderay-1.1.3/lib/coderay/encoders/text.rb:21
CodeRay::Encoders::Text::DEFAULT_OPTIONS = T.let(T.unsafe(nil), Hash)

# source://coderay-1.1.3/lib/coderay/encoders/text.rb:19
CodeRay::Encoders::Text::FILE_EXTENSION = T.let(T.unsafe(nil), String)

# A Filter that selects tokens based on their token kind.
#
# == Options
#
# === :exclude
#
# One or many symbols (in an Array) which shall be excluded.
#
# Default: []
#
# === :include
#
# One or many symbols (in an array) which shall be included.
#
# Default: :all, which means all tokens are included.
#
# Exclusion wins over inclusion.
#
# See also: CommentFilter
#
# source://coderay-1.1.3/lib/coderay/encoders/token_kind_filter.rb:25
class CodeRay::Encoders::TokenKindFilter < ::CodeRay::Encoders::Filter
  # Add the token group to the output stream if +kind+ matches the
  # conditions.
  #
  # If it does not, all tokens inside the group are excluded from the
  # stream, even if their kinds match.
  #
  # source://coderay-1.1.3/lib/coderay/encoders/token_kind_filter.rb:66
  def begin_group(kind); end

  # See +begin_group+.
  #
  # source://coderay-1.1.3/lib/coderay/encoders/token_kind_filter.rb:77
  def begin_line(kind); end

  # Take care of re-enabling the delegation of tokens to the output stream
  # if an exluded group has ended.
  #
  # source://coderay-1.1.3/lib/coderay/encoders/token_kind_filter.rb:89
  def end_group(kind); end

  # See +end_group+.
  #
  # source://coderay-1.1.3/lib/coderay/encoders/token_kind_filter.rb:99
  def end_line(kind); end

  # Add the token to the output stream if +kind+ matches the conditions.
  #
  # source://coderay-1.1.3/lib/coderay/encoders/token_kind_filter.rb:57
  def text_token(text, kind); end

  protected

  # @return [Boolean]
  #
  # source://coderay-1.1.3/lib/coderay/encoders/token_kind_filter.rb:49
  def include_group?(kind); end

  # @return [Boolean]
  #
  # source://coderay-1.1.3/lib/coderay/encoders/token_kind_filter.rb:45
  def include_text_token?(text, kind); end

  # source://coderay-1.1.3/lib/coderay/encoders/token_kind_filter.rb:35
  def setup(options); end
end

# source://coderay-1.1.3/lib/coderay/encoders/token_kind_filter.rb:29
CodeRay::Encoders::TokenKindFilter::DEFAULT_OPTIONS = T.let(T.unsafe(nil), Hash)

# = XML Encoder
#
# Uses REXML. Very slow.
#
# source://coderay-1.1.3/lib/coderay/encoders/xml.rb:7
class CodeRay::Encoders::XML < ::CodeRay::Encoders::Encoder
  # source://coderay-1.1.3/lib/coderay/encoders/xml.rb:58
  def begin_group(kind); end

  # source://coderay-1.1.3/lib/coderay/encoders/xml.rb:62
  def end_group(kind); end

  # source://coderay-1.1.3/lib/coderay/encoders/xml.rb:38
  def text_token(text, kind); end

  protected

  # source://coderay-1.1.3/lib/coderay/encoders/xml.rb:31
  def finish(options); end

  # source://coderay-1.1.3/lib/coderay/encoders/xml.rb:22
  def setup(options); end
end

# source://coderay-1.1.3/lib/coderay/encoders/xml.rb:15
CodeRay::Encoders::XML::DEFAULT_OPTIONS = T.let(T.unsafe(nil), Hash)

# source://coderay-1.1.3/lib/coderay/encoders/xml.rb:11
CodeRay::Encoders::XML::FILE_EXTENSION = T.let(T.unsafe(nil), String)

# = YAML Encoder
#
# Slow.
#
# source://coderay-1.1.3/lib/coderay/encoders/yaml.rb:9
class CodeRay::Encoders::YAML < ::CodeRay::Encoders::Encoder
  # source://coderay-1.1.3/lib/coderay/encoders/yaml.rb:31
  def begin_group(kind); end

  # source://coderay-1.1.3/lib/coderay/encoders/yaml.rb:39
  def begin_line(kind); end

  # source://coderay-1.1.3/lib/coderay/encoders/yaml.rb:35
  def end_group(kind); end

  # source://coderay-1.1.3/lib/coderay/encoders/yaml.rb:43
  def end_line(kind); end

  # source://coderay-1.1.3/lib/coderay/encoders/yaml.rb:27
  def text_token(text, kind); end

  protected

  # source://coderay-1.1.3/lib/coderay/encoders/yaml.rb:22
  def finish(options); end

  # source://coderay-1.1.3/lib/coderay/encoders/yaml.rb:16
  def setup(options); end
end

# source://coderay-1.1.3/lib/coderay/encoders/yaml.rb:13
CodeRay::Encoders::YAML::FILE_EXTENSION = T.let(T.unsafe(nil), String)

# = FileType
#
# A simple filetype recognizer.
#
# == Usage
#
#  # determine the type of the given
#  lang = FileType[file_name]
#
#  # return :text if the file type is unknown
#  lang = FileType.fetch file_name, :text
#
#  # try the shebang line, too
#  lang = FileType.fetch file_name, :text, true
#
# source://coderay-1.1.3/lib/coderay/helpers/file_type.rb:17
module CodeRay::FileType
  class << self
    # Try to determine the file type of the file.
    #
    # +filename+ is a relative or absolute path to a file.
    #
    # The file itself is only accessed when +read_shebang+ is set to true.
    # That means you can get filetypes from files that don't exist.
    #
    # source://coderay-1.1.3/lib/coderay/helpers/file_type.rb:29
    def [](filename, read_shebang = T.unsafe(nil)); end

    # This works like Hash#fetch.
    #
    # If the filetype cannot be found, the +default+ value
    # is returned.
    #
    # source://coderay-1.1.3/lib/coderay/helpers/file_type.rb:50
    def fetch(filename, default = T.unsafe(nil), read_shebang = T.unsafe(nil)); end

    protected

    # source://coderay-1.1.3/lib/coderay/helpers/file_type.rb:66
    def type_from_shebang(filename); end
  end
end

# source://coderay-1.1.3/lib/coderay/helpers/file_type.rb:79
CodeRay::FileType::TypeFromExt = T.let(T.unsafe(nil), Hash)

# source://coderay-1.1.3/lib/coderay/helpers/file_type.rb:139
CodeRay::FileType::TypeFromName = T.let(T.unsafe(nil), Hash)

# source://coderay-1.1.3/lib/coderay/helpers/file_type.rb:137
CodeRay::FileType::TypeFromShebang = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/helpers/file_type.rb:19
class CodeRay::FileType::UnknownFileType < ::Exception; end

# = Plugin
#
#  Plugins have to include this module.
#
#  IMPORTANT: Use extend for this module.
#
#  See CodeRay::PluginHost for examples.
#
# source://coderay-1.1.3/lib/coderay/helpers/plugin.rb:10
module CodeRay::Plugin
  # source://coderay-1.1.3/lib/coderay/helpers/plugin.rb:46
  def aliases; end

  # The PluginHost for this Plugin class.
  #
  # source://coderay-1.1.3/lib/coderay/helpers/plugin.rb:39
  def plugin_host(host = T.unsafe(nil)); end

  # Returns the value of attribute plugin_id.
  #
  # source://coderay-1.1.3/lib/coderay/helpers/plugin.rb:12
  def plugin_id; end

  # Register this class for the given +id+.
  #
  # Example:
  #   class MyPlugin < PluginHost::BaseClass
  #     register_for :my_id
  #     ...
  #   end
  #
  # See PluginHost.register.
  #
  # source://coderay-1.1.3/lib/coderay/helpers/plugin.rb:23
  def register_for(id); end

  # Returns the title of the plugin, or sets it to the
  # optional argument +title+.
  #
  # source://coderay-1.1.3/lib/coderay/helpers/plugin.rb:30
  def title(title = T.unsafe(nil)); end
end

# = PluginHost
#
# A simple subclass/subfolder plugin system.
#
# Example:
#  class Generators
#    extend PluginHost
#    plugin_path 'app/generators'
#  end
#
#  class Generator
#    extend Plugin
#    PLUGIN_HOST = Generators
#  end
#
#  class FancyGenerator < Generator
#    register_for :fancy
#  end
#
#  Generators[:fancy]  #-> FancyGenerator
#  # or
#  CodeRay.require_plugin 'Generators/fancy'
#  # or
#  Generators::Fancy
#
# source://coderay-1.1.3/lib/coderay/helpers/plugin_host.rb:27
module CodeRay::PluginHost
  # Returns the Plugin for +id+.
  #
  # Example:
  #  yaml_plugin = MyPluginHost[:yaml]
  #
  # source://coderay-1.1.3/lib/coderay/helpers/plugin_host.rb:49
  def [](id, *args, &blk); end

  # Returns an array of all Plugins.
  #
  # Note: This loads all plugins using load_all.
  #
  # source://coderay-1.1.3/lib/coderay/helpers/plugin_host.rb:151
  def all_plugins; end

  # Tries to +load+ the missing plugin by translating +const+ to the
  # underscore form (eg. LinesOfCode becomes lines_of_code).
  #
  # source://coderay-1.1.3/lib/coderay/helpers/plugin_host.rb:61
  def const_missing(const); end

  # Define the default plugin to use when no plugin is found
  # for a given id, or return the default plugin.
  #
  # See also map.
  #
  #  class MyColorHost < PluginHost
  #    map :navy => :dark_blue
  #    default :gray
  #  end
  #
  #  MyColorHost.default  # loads and returns the Gray plugin
  #
  # source://coderay-1.1.3/lib/coderay/helpers/plugin_host.rb:114
  def default(id = T.unsafe(nil)); end

  # Returns an array of all .rb files in the plugin path.
  #
  # The extension .rb is not included.
  #
  # source://coderay-1.1.3/lib/coderay/helpers/plugin_host.rb:140
  def list; end

  # Returns the Plugin for +id+.
  #
  # Example:
  #  yaml_plugin = MyPluginHost[:yaml]
  #
  # source://coderay-1.1.3/lib/coderay/helpers/plugin_host.rb:49
  def load(id, *args, &blk); end

  # Loads all plugins using list and load.
  #
  # source://coderay-1.1.3/lib/coderay/helpers/plugin_host.rb:39
  def load_all; end

  # Loads the map file (see map).
  #
  # This is done automatically when plugin_path is called.
  #
  # source://coderay-1.1.3/lib/coderay/helpers/plugin_host.rb:159
  def load_plugin_map; end

  # Map a plugin_id to another.
  #
  # Usage: Put this in a file plugin_path/_map.rb.
  #
  #  class MyColorHost < PluginHost
  #    map :navy => :dark_blue,
  #      :maroon => :brown,
  #      :luna => :moon
  #  end
  #
  # source://coderay-1.1.3/lib/coderay/helpers/plugin_host.rb:95
  def map(hash); end

  # A Hash of plugion_id => Plugin pairs.
  #
  # source://coderay-1.1.3/lib/coderay/helpers/plugin_host.rb:133
  def plugin_hash; end

  # The path where the plugins can be found.
  #
  # source://coderay-1.1.3/lib/coderay/helpers/plugin_host.rb:79
  def plugin_path(*args); end

  # Every plugin must register itself for +id+ by calling register_for,
  # which calls this method.
  #
  # See Plugin#register_for.
  #
  # source://coderay-1.1.3/lib/coderay/helpers/plugin_host.rb:128
  def register(plugin, id); end

  protected

  # Return a plugin hash that automatically loads plugins.
  #
  # source://coderay-1.1.3/lib/coderay/helpers/plugin_host.rb:172
  def make_plugin_hash; end

  # Returns the expected path to the plugin file for the given id.
  #
  # source://coderay-1.1.3/lib/coderay/helpers/plugin_host.rb:196
  def path_to(plugin_id); end

  # Converts +id+ to a valid plugin ID String, or returns +nil+.
  #
  # Raises +ArgumentError+ for all other objects, or if the
  # given String includes non-alphanumeric characters (\W).
  #
  # source://coderay-1.1.3/lib/coderay/helpers/plugin_host.rb:204
  def validate_id(id); end

  class << self
    # Adds the module/class to the PLUGIN_HOSTS list.
    #
    # source://coderay-1.1.3/lib/coderay/helpers/plugin_host.rb:72
    def extended(mod); end
  end
end

# source://coderay-1.1.3/lib/coderay/helpers/plugin_host.rb:33
class CodeRay::PluginHost::HostNotFound < ::LoadError; end

# source://coderay-1.1.3/lib/coderay/helpers/plugin_host.rb:35
CodeRay::PluginHost::PLUGIN_HOSTS = T.let(T.unsafe(nil), Array)

# dummy hash
#
# source://coderay-1.1.3/lib/coderay/helpers/plugin_host.rb:36
CodeRay::PluginHost::PLUGIN_HOSTS_BY_ID = T.let(T.unsafe(nil), Hash)

# Raised if Encoders::[] fails because:
# * a file could not be found
# * the requested Plugin is not registered
#
# source://coderay-1.1.3/lib/coderay/helpers/plugin_host.rb:32
class CodeRay::PluginHost::PluginNotFound < ::LoadError; end

# = Scanners
#
# This module holds the Scanner class and its subclasses.
# For example, the Ruby scanner is named CodeRay::Scanners::Ruby
# can be found in coderay/scanners/ruby.
#
# Scanner also provides methods and constants for the register
# mechanism and the [] method that returns the Scanner class
# belonging to the given lang.
#
# See PluginHost.
#
# source://coderay-1.1.3/lib/coderay/scanners.rb:18
module CodeRay::Scanners
  extend ::CodeRay::PluginHost
end

# Scanner for C.
#
# source://coderay-1.1.3/lib/coderay/scanners/c.rb:5
class CodeRay::Scanners::C < ::CodeRay::Scanners::Scanner
  protected

  # source://coderay-1.1.3/lib/coderay/scanners/c.rb:44
  def scan_tokens(encoder, options); end
end

# source://coderay-1.1.3/lib/coderay/scanners/c.rb:27
CodeRay::Scanners::C::DIRECTIVES = T.let(T.unsafe(nil), Array)

# source://coderay-1.1.3/lib/coderay/scanners/c.rb:39
CodeRay::Scanners::C::ESCAPE = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/c.rb:33
CodeRay::Scanners::C::IDENT_KIND = T.let(T.unsafe(nil), CodeRay::WordList)

# source://coderay-1.1.3/lib/coderay/scanners/c.rb:10
CodeRay::Scanners::C::KEYWORDS = T.let(T.unsafe(nil), Array)

# source://coderay-1.1.3/lib/coderay/scanners/c.rb:23
CodeRay::Scanners::C::PREDEFINED_CONSTANTS = T.let(T.unsafe(nil), Array)

# source://coderay-1.1.3/lib/coderay/scanners/c.rb:17
CodeRay::Scanners::C::PREDEFINED_TYPES = T.let(T.unsafe(nil), Array)

# source://coderay-1.1.3/lib/coderay/scanners/c.rb:40
CodeRay::Scanners::C::UNICODE_ESCAPE = T.let(T.unsafe(nil), Regexp)

# Scanner for C++.
#
# Aliases: +cplusplus+, c++
CodeRay::Scanners::CPlusPlus = CodeRay::Scanners::Text

# source://coderay-1.1.3/lib/coderay/scanners/css.rb:4
class CodeRay::Scanners::CSS < ::CodeRay::Scanners::Scanner
  protected

  # source://coderay-1.1.3/lib/coderay/scanners/css.rb:55
  def scan_tokens(encoder, options); end

  # source://coderay-1.1.3/lib/coderay/scanners/css.rb:50
  def setup; end
end

# source://coderay-1.1.3/lib/coderay/scanners/css.rb:8
CodeRay::Scanners::CSS::KINDS_NOT_LOC = T.let(T.unsafe(nil), Array)

# source://coderay-1.1.3/lib/coderay/scanners/css.rb:16
module CodeRay::Scanners::CSS::RE; end

# source://coderay-1.1.3/lib/coderay/scanners/css.rb:31
CodeRay::Scanners::CSS::RE::AtKeyword = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/css.rb:45
CodeRay::Scanners::CSS::RE::AttributeSelector = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/css.rb:43
CodeRay::Scanners::CSS::RE::Class = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/css.rb:38
CodeRay::Scanners::CSS::RE::Dimension = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/css.rb:19
CodeRay::Scanners::CSS::RE::Escape = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/css.rb:40
CodeRay::Scanners::CSS::RE::Function = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/css.rb:17
CodeRay::Scanners::CSS::RE::Hex = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/css.rb:26
CodeRay::Scanners::CSS::RE::HexColor = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/css.rb:42
CodeRay::Scanners::CSS::RE::Id = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/css.rb:30
CodeRay::Scanners::CSS::RE::Ident = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/css.rb:20
CodeRay::Scanners::CSS::RE::NMChar = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/css.rb:21
CodeRay::Scanners::CSS::RE::NMStart = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/css.rb:29
CodeRay::Scanners::CSS::RE::Name = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/css.rb:28
CodeRay::Scanners::CSS::RE::Num = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/css.rb:32
CodeRay::Scanners::CSS::RE::Percentage = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/css.rb:44
CodeRay::Scanners::CSS::RE::PseudoClass = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/css.rb:24
CodeRay::Scanners::CSS::RE::String = T.let(T.unsafe(nil), Regexp)

# TODO: buggy regexp
#
# source://coderay-1.1.3/lib/coderay/scanners/css.rb:22
CodeRay::Scanners::CSS::RE::String1 = T.let(T.unsafe(nil), Regexp)

# TODO: buggy regexp
#
# source://coderay-1.1.3/lib/coderay/scanners/css.rb:23
CodeRay::Scanners::CSS::RE::String2 = T.let(T.unsafe(nil), Regexp)

# differs from standard because it allows uppercase hex too
#
# source://coderay-1.1.3/lib/coderay/scanners/css.rb:18
CodeRay::Scanners::CSS::RE::Unicode = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/css.rb:36
CodeRay::Scanners::CSS::RE::Unit = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/clojure.rb:6
class CodeRay::Scanners::Clojure < ::CodeRay::Scanners::Scanner
  protected

  # source://coderay-1.1.3/lib/coderay/scanners/clojure.rb:145
  def scan_tokens(encoder, options); end
end

# source://coderay-1.1.3/lib/coderay/scanners/clojure.rb:95
CodeRay::Scanners::Clojure::BASIC_IDENTIFIER = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/clojure.rb:133
CodeRay::Scanners::Clojure::COMPLEX10 = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/clojure.rb:134
CodeRay::Scanners::Clojure::COMPLEX16 = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/clojure.rb:136
CodeRay::Scanners::Clojure::COMPLEX2 = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/clojure.rb:135
CodeRay::Scanners::Clojure::COMPLEX8 = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/clojure.rb:16
CodeRay::Scanners::Clojure::CORE_FORMS = T.let(T.unsafe(nil), Array)

# source://coderay-1.1.3/lib/coderay/scanners/clojure.rb:120
CodeRay::Scanners::Clojure::DECIMAL = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/clojure.rb:98
CodeRay::Scanners::Clojure::DIGIT = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/clojure.rb:99
CodeRay::Scanners::Clojure::DIGIT10 = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/clojure.rb:100
CodeRay::Scanners::Clojure::DIGIT16 = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/clojure.rb:102
CodeRay::Scanners::Clojure::DIGIT2 = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/clojure.rb:101
CodeRay::Scanners::Clojure::DIGIT8 = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/clojure.rb:107
CodeRay::Scanners::Clojure::EXACTNESS = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/clojure.rb:110
CodeRay::Scanners::Clojure::EXP = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/clojure.rb:109
CodeRay::Scanners::Clojure::EXP_MARK = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/clojure.rb:96
CodeRay::Scanners::Clojure::IDENTIFIER = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/clojure.rb:85
CodeRay::Scanners::Clojure::IDENT_KIND = T.let(T.unsafe(nil), CodeRay::WordList)

# source://coderay-1.1.3/lib/coderay/scanners/clojure.rb:129
CodeRay::Scanners::Clojure::IMAG10 = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/clojure.rb:130
CodeRay::Scanners::Clojure::IMAG16 = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/clojure.rb:132
CodeRay::Scanners::Clojure::IMAG2 = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/clojure.rb:131
CodeRay::Scanners::Clojure::IMAG8 = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/clojure.rb:90
CodeRay::Scanners::Clojure::KEYWORD_NEXT_TOKEN_KIND = T.let(T.unsafe(nil), CodeRay::WordList)

# source://coderay-1.1.3/lib/coderay/scanners/clojure.rb:141
CodeRay::Scanners::Clojure::NUM = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/clojure.rb:137
CodeRay::Scanners::Clojure::NUM10 = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/clojure.rb:138
CodeRay::Scanners::Clojure::NUM16 = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/clojure.rb:140
CodeRay::Scanners::Clojure::NUM2 = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/clojure.rb:139
CodeRay::Scanners::Clojure::NUM8 = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/clojure.rb:78
CodeRay::Scanners::Clojure::PREDEFINED_CONSTANTS = T.let(T.unsafe(nil), Array)

# source://coderay-1.1.3/lib/coderay/scanners/clojure.rb:112
CodeRay::Scanners::Clojure::PREFIX10 = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/clojure.rb:113
CodeRay::Scanners::Clojure::PREFIX16 = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/clojure.rb:115
CodeRay::Scanners::Clojure::PREFIX2 = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/clojure.rb:114
CodeRay::Scanners::Clojure::PREFIX8 = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/clojure.rb:106
CodeRay::Scanners::Clojure::RADIX10 = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/clojure.rb:103
CodeRay::Scanners::Clojure::RADIX16 = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/clojure.rb:105
CodeRay::Scanners::Clojure::RADIX2 = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/clojure.rb:104
CodeRay::Scanners::Clojure::RADIX8 = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/clojure.rb:125
CodeRay::Scanners::Clojure::REAL10 = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/clojure.rb:126
CodeRay::Scanners::Clojure::REAL16 = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/clojure.rb:128
CodeRay::Scanners::Clojure::REAL2 = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/clojure.rb:127
CodeRay::Scanners::Clojure::REAL8 = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/clojure.rb:108
CodeRay::Scanners::Clojure::SIGN = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/clojure.rb:11
CodeRay::Scanners::Clojure::SPECIAL_FORMS = T.let(T.unsafe(nil), Array)

# source://coderay-1.1.3/lib/coderay/scanners/clojure.rb:111
CodeRay::Scanners::Clojure::SUFFIX = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/clojure.rb:97
CodeRay::Scanners::Clojure::SYMBOL = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/clojure.rb:116
CodeRay::Scanners::Clojure::UINT10 = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/clojure.rb:117
CodeRay::Scanners::Clojure::UINT16 = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/clojure.rb:119
CodeRay::Scanners::Clojure::UINT2 = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/clojure.rb:118
CodeRay::Scanners::Clojure::UINT8 = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/clojure.rb:121
CodeRay::Scanners::Clojure::UREAL10 = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/clojure.rb:122
CodeRay::Scanners::Clojure::UREAL16 = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/clojure.rb:124
CodeRay::Scanners::Clojure::UREAL2 = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/clojure.rb:123
CodeRay::Scanners::Clojure::UREAL8 = T.let(T.unsafe(nil), Regexp)

# = Debug Scanner
#
# Interprets the output of the Encoders::Debug encoder (basically the inverse function).
#
# source://coderay-1.1.3/lib/coderay/scanners/debug.rb:9
class CodeRay::Scanners::Debug < ::CodeRay::Scanners::Scanner
  protected

  # source://coderay-1.1.3/lib/coderay/scanners/debug.rb:21
  def scan_tokens(encoder, options); end

  # source://coderay-1.1.3/lib/coderay/scanners/debug.rb:16
  def setup; end
end

# Scanner for the Delphi language (Object Pascal).
#
# Alias: +pascal+
#
# source://coderay-1.1.3/lib/coderay/scanners/delphi.rb:7
class CodeRay::Scanners::Delphi < ::CodeRay::Scanners::Scanner
  protected

  # source://coderay-1.1.3/lib/coderay/scanners/delphi.rb:45
  def scan_tokens(encoder, options); end
end

# source://coderay-1.1.3/lib/coderay/scanners/delphi.rb:25
CodeRay::Scanners::Delphi::DIRECTIVES = T.let(T.unsafe(nil), Array)

# source://coderay-1.1.3/lib/coderay/scanners/delphi.rb:36
CodeRay::Scanners::Delphi::IDENT_KIND = T.let(T.unsafe(nil), CodeRay::WordList::CaseIgnoring)

# source://coderay-1.1.3/lib/coderay/scanners/delphi.rb:12
CodeRay::Scanners::Delphi::KEYWORDS = T.let(T.unsafe(nil), Array)

# source://coderay-1.1.3/lib/coderay/scanners/delphi.rb:40
CodeRay::Scanners::Delphi::NAME_FOLLOWS = T.let(T.unsafe(nil), CodeRay::WordList::CaseIgnoring)

# Scanner for output of the diff command.
#
# Alias: +patch+
#
# source://coderay-1.1.3/lib/coderay/scanners/diff.rb:7
class CodeRay::Scanners::Diff < ::CodeRay::Scanners::Scanner
  protected

  # source://coderay-1.1.3/lib/coderay/scanners/diff.rb:19
  def scan_tokens(encoder, options); end

  private

  # source://coderay-1.1.3/lib/coderay/scanners/diff.rb:204
  def diff(a, b); end
end

# source://coderay-1.1.3/lib/coderay/scanners/diff.rb:12
CodeRay::Scanners::Diff::DEFAULT_OPTIONS = T.let(T.unsafe(nil), Hash)

# Scanner for HTML ERB templates.
#
# source://coderay-1.1.3/lib/coderay/scanners/erb.rb:8
class CodeRay::Scanners::ERB < ::CodeRay::Scanners::Scanner
  protected

  # source://coderay-1.1.3/lib/coderay/scanners/erb.rb:38
  def reset_instance; end

  # source://coderay-1.1.3/lib/coderay/scanners/erb.rb:43
  def scan_tokens(encoder, options); end

  # source://coderay-1.1.3/lib/coderay/scanners/erb.rb:33
  def setup; end
end

# source://coderay-1.1.3/lib/coderay/scanners/erb.rb:15
CodeRay::Scanners::ERB::ERB_RUBY_BLOCK = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/erb.rb:13
CodeRay::Scanners::ERB::KINDS_NOT_LOC = T.let(T.unsafe(nil), Array)

# source://coderay-1.1.3/lib/coderay/scanners/erb.rb:27
CodeRay::Scanners::ERB::START_OF_ERB = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/go.rb:4
class CodeRay::Scanners::Go < ::CodeRay::Scanners::Scanner
  protected

  # source://coderay-1.1.3/lib/coderay/scanners/go.rb:50
  def scan_tokens(encoder, options); end
end

# source://coderay-1.1.3/lib/coderay/scanners/go.rb:45
CodeRay::Scanners::Go::ESCAPE = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/go.rb:39
CodeRay::Scanners::Go::IDENT_KIND = T.let(T.unsafe(nil), CodeRay::WordList)

# http://golang.org/ref/spec#Keywords
#
# source://coderay-1.1.3/lib/coderay/scanners/go.rb:10
CodeRay::Scanners::Go::KEYWORDS = T.let(T.unsafe(nil), Array)

# source://coderay-1.1.3/lib/coderay/scanners/go.rb:29
CodeRay::Scanners::Go::PREDEFINED_CONSTANTS = T.let(T.unsafe(nil), Array)

# source://coderay-1.1.3/lib/coderay/scanners/go.rb:34
CodeRay::Scanners::Go::PREDEFINED_FUNCTIONS = T.let(T.unsafe(nil), Array)

# http://golang.org/ref/spec#Types
#
# source://coderay-1.1.3/lib/coderay/scanners/go.rb:19
CodeRay::Scanners::Go::PREDEFINED_TYPES = T.let(T.unsafe(nil), Array)

# source://coderay-1.1.3/lib/coderay/scanners/go.rb:46
CodeRay::Scanners::Go::UNICODE_ESCAPE = T.let(T.unsafe(nil), Regexp)

# Scanner for Groovy.
#
# source://coderay-1.1.3/lib/coderay/scanners/groovy.rb:7
class CodeRay::Scanners::Groovy < ::CodeRay::Scanners::Java
  protected

  # source://coderay-1.1.3/lib/coderay/scanners/groovy.rb:43
  def scan_tokens(encoder, options); end

  # source://coderay-1.1.3/lib/coderay/scanners/groovy.rb:39
  def setup; end
end

# source://coderay-1.1.3/lib/coderay/scanners/groovy.rb:24
CodeRay::Scanners::Groovy::ESCAPE = T.let(T.unsafe(nil), Regexp)

# TODO: check list of keywords
#
# source://coderay-1.1.3/lib/coderay/scanners/groovy.rb:12
CodeRay::Scanners::Groovy::GROOVY_KEYWORDS = T.let(T.unsafe(nil), Array)

# source://coderay-1.1.3/lib/coderay/scanners/groovy.rb:18
CodeRay::Scanners::Groovy::GROOVY_MAGIC_VARIABLES = T.let(T.unsafe(nil), Array)

# source://coderay-1.1.3/lib/coderay/scanners/groovy.rb:20
CodeRay::Scanners::Groovy::IDENT_KIND = T.let(T.unsafe(nil), CodeRay::WordList)

# source://coderay-1.1.3/lib/coderay/scanners/groovy.rb:15
CodeRay::Scanners::Groovy::KEYWORDS_EXPECTING_VALUE = T.let(T.unsafe(nil), CodeRay::WordList)

# source://coderay-1.1.3/lib/coderay/scanners/groovy.rb:26
CodeRay::Scanners::Groovy::REGEXP_ESCAPE = T.let(T.unsafe(nil), Regexp)

# TODO: interpretation inside ', ", /
#
# source://coderay-1.1.3/lib/coderay/scanners/groovy.rb:29
CodeRay::Scanners::Groovy::STRING_CONTENT_PATTERN = T.let(T.unsafe(nil), Hash)

# source://coderay-1.1.3/lib/coderay/scanners/groovy.rb:25
CodeRay::Scanners::Groovy::UNICODE_ESCAPE = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/haml.rb:8
class CodeRay::Scanners::HAML < ::CodeRay::Scanners::Scanner
  protected

  # source://coderay-1.1.3/lib/coderay/scanners/haml.rb:24
  def scan_tokens(encoder, options); end

  # source://coderay-1.1.3/lib/coderay/scanners/haml.rb:17
  def setup; end
end

# source://coderay-1.1.3/lib/coderay/scanners/haml.rb:13
CodeRay::Scanners::HAML::KINDS_NOT_LOC = T.let(T.unsafe(nil), Array)

# HTML Scanner
#
# Alias: +xhtml+
#
# See also: Scanners::XML
#
# source://coderay-1.1.3/lib/coderay/scanners/html.rb:9
class CodeRay::Scanners::HTML < ::CodeRay::Scanners::Scanner
  # source://coderay-1.1.3/lib/coderay/scanners/html.rb:62
  def reset; end

  protected

  # source://coderay-1.1.3/lib/coderay/scanners/html.rb:83
  def scan_css(encoder, code, state = T.unsafe(nil)); end

  # source://coderay-1.1.3/lib/coderay/scanners/html.rb:76
  def scan_java_script(encoder, code); end

  # source://coderay-1.1.3/lib/coderay/scanners/html.rb:90
  def scan_tokens(encoder, options); end

  # source://coderay-1.1.3/lib/coderay/scanners/html.rb:70
  def setup; end
end

# source://coderay-1.1.3/lib/coderay/scanners/html.rb:39
CodeRay::Scanners::HTML::ATTR_NAME = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/html.rb:42
CodeRay::Scanners::HTML::ENTITY = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/html.rb:20
CodeRay::Scanners::HTML::EVENT_ATTRIBUTES = T.let(T.unsafe(nil), Array)

# source://coderay-1.1.3/lib/coderay/scanners/html.rb:41
CodeRay::Scanners::HTML::HEX = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/html.rb:35
CodeRay::Scanners::HTML::IN_ATTRIBUTE = T.let(T.unsafe(nil), CodeRay::WordList::CaseIgnoring)

# source://coderay-1.1.3/lib/coderay/scanners/html.rb:13
CodeRay::Scanners::HTML::KINDS_NOT_LOC = T.let(T.unsafe(nil), Array)

# source://coderay-1.1.3/lib/coderay/scanners/html.rb:57
CodeRay::Scanners::HTML::PLAIN_STRING_CONTENT = T.let(T.unsafe(nil), Hash)

# source://coderay-1.1.3/lib/coderay/scanners/html.rb:40
CodeRay::Scanners::HTML::TAG_END = T.let(T.unsafe(nil), Regexp)

# Scanner for JSON (JavaScript Object Notation).
#
# source://coderay-1.1.3/lib/coderay/scanners/json.rb:5
class CodeRay::Scanners::JSON < ::CodeRay::Scanners::Scanner
  protected

  # See http://json.org/ for a definition of the JSON lexic/grammar.
  #
  # source://coderay-1.1.3/lib/coderay/scanners/json.rb:26
  def scan_tokens(encoder, options); end

  # source://coderay-1.1.3/lib/coderay/scanners/json.rb:21
  def setup; end
end

# source://coderay-1.1.3/lib/coderay/scanners/json.rb:15
CodeRay::Scanners::JSON::ESCAPE = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/json.rb:17
CodeRay::Scanners::JSON::KEY = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/json.rb:10
CodeRay::Scanners::JSON::KINDS_NOT_LOC = T.let(T.unsafe(nil), Array)

# source://coderay-1.1.3/lib/coderay/scanners/json.rb:16
CodeRay::Scanners::JSON::UNICODE_ESCAPE = T.let(T.unsafe(nil), Regexp)

# Scanner for Java.
#
# source://coderay-1.1.3/lib/coderay/scanners/java.rb:5
class CodeRay::Scanners::Java < ::CodeRay::Scanners::Scanner
  protected

  # source://coderay-1.1.3/lib/coderay/scanners/java.rb:51
  def scan_tokens(encoder, options); end
end

# source://coderay-1.1.3/lib/coderay/scanners/java/builtin_types.rb:4
module CodeRay::Scanners::Java::BuiltinTypes; end

# source://coderay-1.1.3/lib/coderay/scanners/java/builtin_types.rb:7
CodeRay::Scanners::Java::BuiltinTypes::List = T.let(T.unsafe(nil), Array)

# source://coderay-1.1.3/lib/coderay/scanners/java.rb:19
CodeRay::Scanners::Java::CONSTANTS = T.let(T.unsafe(nil), Array)

# source://coderay-1.1.3/lib/coderay/scanners/java.rb:25
CodeRay::Scanners::Java::DIRECTIVES = T.let(T.unsafe(nil), Array)

# source://coderay-1.1.3/lib/coderay/scanners/java.rb:40
CodeRay::Scanners::Java::ESCAPE = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/java.rb:47
CodeRay::Scanners::Java::IDENT = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/java.rb:30
CodeRay::Scanners::Java::IDENT_KIND = T.let(T.unsafe(nil), CodeRay::WordList)

# http://java.sun.com/docs/books/tutorial/java/nutsandbolts/_keywords.html
#
# source://coderay-1.1.3/lib/coderay/scanners/java.rb:12
CodeRay::Scanners::Java::KEYWORDS = T.let(T.unsafe(nil), Array)

# source://coderay-1.1.3/lib/coderay/scanners/java.rb:20
CodeRay::Scanners::Java::MAGIC_VARIABLES = T.let(T.unsafe(nil), Array)

# source://coderay-1.1.3/lib/coderay/scanners/java.rb:18
CodeRay::Scanners::Java::RESERVED = T.let(T.unsafe(nil), Array)

# source://coderay-1.1.3/lib/coderay/scanners/java.rb:42
CodeRay::Scanners::Java::STRING_CONTENT_PATTERN = T.let(T.unsafe(nil), Hash)

# source://coderay-1.1.3/lib/coderay/scanners/java.rb:21
CodeRay::Scanners::Java::TYPES = T.let(T.unsafe(nil), Array)

# source://coderay-1.1.3/lib/coderay/scanners/java.rb:41
CodeRay::Scanners::Java::UNICODE_ESCAPE = T.let(T.unsafe(nil), Regexp)

# Scanner for JavaScript.
#
# Aliases: +ecmascript+, +ecma_script+, +javascript+
#
# source://coderay-1.1.3/lib/coderay/scanners/java_script.rb:7
class CodeRay::Scanners::JavaScript < ::CodeRay::Scanners::Scanner
  protected

  # source://coderay-1.1.3/lib/coderay/scanners/java_script.rb:224
  def reset_instance; end

  # source://coderay-1.1.3/lib/coderay/scanners/java_script.rb:61
  def scan_tokens(encoder, options); end

  # source://coderay-1.1.3/lib/coderay/scanners/java_script.rb:57
  def setup; end

  # source://coderay-1.1.3/lib/coderay/scanners/java_script.rb:229
  def xml_scanner; end
end

# source://coderay-1.1.3/lib/coderay/scanners/java_script.rb:42
CodeRay::Scanners::JavaScript::ESCAPE = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/java_script.rb:36
CodeRay::Scanners::JavaScript::IDENT_KIND = T.let(T.unsafe(nil), CodeRay::WordList)

# The actual JavaScript keywords.
#
# source://coderay-1.1.3/lib/coderay/scanners/java_script.rb:13
CodeRay::Scanners::JavaScript::KEYWORDS = T.let(T.unsafe(nil), Array)

# source://coderay-1.1.3/lib/coderay/scanners/java_script.rb:24
CodeRay::Scanners::JavaScript::KEYWORDS_EXPECTING_VALUE = T.let(T.unsafe(nil), CodeRay::WordList)

# source://coderay-1.1.3/lib/coderay/scanners/java_script.rb:50
CodeRay::Scanners::JavaScript::KEY_CHECK_PATTERN = T.let(T.unsafe(nil), Hash)

# source://coderay-1.1.3/lib/coderay/scanners/java_script.rb:22
CodeRay::Scanners::JavaScript::MAGIC_VARIABLES = T.let(T.unsafe(nil), Array)

# source://coderay-1.1.3/lib/coderay/scanners/java_script.rb:18
CodeRay::Scanners::JavaScript::PREDEFINED_CONSTANTS = T.let(T.unsafe(nil), Array)

# source://coderay-1.1.3/lib/coderay/scanners/java_script.rb:44
CodeRay::Scanners::JavaScript::REGEXP_ESCAPE = T.let(T.unsafe(nil), Regexp)

# Reserved for future use.
#
# source://coderay-1.1.3/lib/coderay/scanners/java_script.rb:29
CodeRay::Scanners::JavaScript::RESERVED_WORDS = T.let(T.unsafe(nil), Array)

# source://coderay-1.1.3/lib/coderay/scanners/java_script.rb:45
CodeRay::Scanners::JavaScript::STRING_CONTENT_PATTERN = T.let(T.unsafe(nil), Hash)

# source://coderay-1.1.3/lib/coderay/scanners/java_script.rb:43
CodeRay::Scanners::JavaScript::UNICODE_ESCAPE = T.let(T.unsafe(nil), Regexp)

# Scanner for the Lua[http://lua.org] programming lanuage.
#
# The language’s complete syntax is defined in
# {the Lua manual}[http://www.lua.org/manual/5.2/manual.html],
# which is what this scanner tries to conform to.
#
# source://coderay-1.1.3/lib/coderay/scanners/lua.rb:11
class CodeRay::Scanners::Lua < ::CodeRay::Scanners::Scanner
  protected

  # CodeRay entry hook. Starts parsing.
  #
  # source://coderay-1.1.3/lib/coderay/scanners/lua.rb:60
  def scan_tokens(encoder, options); end

  # Scanner initialization.
  #
  # source://coderay-1.1.3/lib/coderay/scanners/lua.rb:54
  def setup; end
end

# Automatic token kind selection for normal words.
#
# source://coderay-1.1.3/lib/coderay/scanners/lua.rb:46
CodeRay::Scanners::Lua::IDENT_KIND = T.let(T.unsafe(nil), CodeRay::WordList)

# Keywords used in Lua.
#
# source://coderay-1.1.3/lib/coderay/scanners/lua.rb:18
CodeRay::Scanners::Lua::KEYWORDS = T.let(T.unsafe(nil), Array)

# Constants set by the Lua core.
#
# source://coderay-1.1.3/lib/coderay/scanners/lua.rb:25
CodeRay::Scanners::Lua::PREDEFINED_CONSTANTS = T.let(T.unsafe(nil), Array)

# The expressions contained in this array are parts of Lua’s `basic'
# library. Although it’s not entirely necessary to load that library,
# it is highly recommended and one would have to provide own implementations
# of some of these expressions if one does not do so. They however aren’t
# keywords, neither are they constants, but nearly predefined, so they
# get tagged as `predefined' rather than anything else.
#
# This list excludes values of form `_UPPERCASE' because the Lua manual
# requires such identifiers to be reserved by Lua anyway and they are
# highlighted directly accordingly, without the need for specific
# identifiers to be listed here.
#
# source://coderay-1.1.3/lib/coderay/scanners/lua.rb:38
CodeRay::Scanners::Lua::PREDEFINED_EXPRESSIONS = T.let(T.unsafe(nil), Array)

# Scanner for PHP.
#
# Original by Stefan Walk.
#
# source://coderay-1.1.3/lib/coderay/scanners/php.rb:10
class CodeRay::Scanners::PHP < ::CodeRay::Scanners::Scanner
  protected

  # source://coderay-1.1.3/lib/coderay/scanners/php.rb:23
  def reset_instance; end

  # source://coderay-1.1.3/lib/coderay/scanners/php.rb:234
  def scan_tokens(encoder, options); end

  # source://coderay-1.1.3/lib/coderay/scanners/php.rb:19
  def setup; end
end

# source://coderay-1.1.3/lib/coderay/scanners/php.rb:15
CodeRay::Scanners::PHP::KINDS_NOT_LOC = T.let(T.unsafe(nil), Array)

# source://coderay-1.1.3/lib/coderay/scanners/php.rb:197
module CodeRay::Scanners::PHP::RE; end

# source://coderay-1.1.3/lib/coderay/scanners/php.rb:211
CodeRay::Scanners::PHP::RE::HTML_INDICATOR = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/php.rb:213
CodeRay::Scanners::PHP::RE::IDENTIFIER = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/php.rb:216
CodeRay::Scanners::PHP::RE::OPERATOR = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/php.rb:206
CodeRay::Scanners::PHP::RE::PHP_END = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/php.rb:199
CodeRay::Scanners::PHP::RE::PHP_START = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/php.rb:214
CodeRay::Scanners::PHP::RE::VARIABLE = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/php.rb:28
module CodeRay::Scanners::PHP::Words; end

# according to http://php.net/quickref.php on 2009-04-21;
# all functions with _ excluded (module functions) and selected additional functions
#
# source://coderay-1.1.3/lib/coderay/scanners/php.rb:50
CodeRay::Scanners::PHP::Words::BUILTIN_FUNCTIONS = T.let(T.unsafe(nil), Array)

# source://coderay-1.1.3/lib/coderay/scanners/php.rb:46
CodeRay::Scanners::PHP::Words::CLASSES = T.let(T.unsafe(nil), Array)

# source://coderay-1.1.3/lib/coderay/scanners/php.rb:145
CodeRay::Scanners::PHP::Words::CONSTANTS = T.let(T.unsafe(nil), Array)

# TODO: more built-in PHP functions?
#
# source://coderay-1.1.3/lib/coderay/scanners/php.rb:140
CodeRay::Scanners::PHP::Words::EXCEPTIONS = T.let(T.unsafe(nil), Array)

# source://coderay-1.1.3/lib/coderay/scanners/php.rb:184
CodeRay::Scanners::PHP::Words::IDENT_KIND = T.let(T.unsafe(nil), CodeRay::WordList::CaseIgnoring)

# according to http://www.php.net/manual/en/reserved.keywords.php
#
# source://coderay-1.1.3/lib/coderay/scanners/php.rb:31
CodeRay::Scanners::PHP::Words::KEYWORDS = T.let(T.unsafe(nil), Array)

# source://coderay-1.1.3/lib/coderay/scanners/php.rb:41
CodeRay::Scanners::PHP::Words::LANGUAGE_CONSTRUCTS = T.let(T.unsafe(nil), Array)

# source://coderay-1.1.3/lib/coderay/scanners/php.rb:178
CodeRay::Scanners::PHP::Words::PREDEFINED = T.let(T.unsafe(nil), Array)

# source://coderay-1.1.3/lib/coderay/scanners/php.rb:39
CodeRay::Scanners::PHP::Words::TYPES = T.let(T.unsafe(nil), Array)

# source://coderay-1.1.3/lib/coderay/scanners/php.rb:193
CodeRay::Scanners::PHP::Words::VARIABLE_KIND = T.let(T.unsafe(nil), CodeRay::WordList)

# Scanner for Python. Supports Python 3.
#
# Based on pygments' PythonLexer, see
# http://dev.pocoo.org/projects/pygments/browser/pygments/lexers/agile.py.
#
# source://coderay-1.1.3/lib/coderay/scanners/python.rb:8
class CodeRay::Scanners::Python < ::CodeRay::Scanners::Scanner
  protected

  # source://coderay-1.1.3/lib/coderay/scanners/python.rb:103
  def scan_tokens(encoder, options); end
end

# source://coderay-1.1.3/lib/coderay/scanners/python.rb:86
CodeRay::Scanners::Python::DEF_NEW_STATE = T.let(T.unsafe(nil), CodeRay::WordList)

# source://coderay-1.1.3/lib/coderay/scanners/python.rb:91
CodeRay::Scanners::Python::DESCRIPTOR = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/python.rb:97
CodeRay::Scanners::Python::DOCSTRING_COMING = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/python.rb:65
CodeRay::Scanners::Python::ESCAPE = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/python.rb:57
CodeRay::Scanners::Python::IDENT_KIND = T.let(T.unsafe(nil), CodeRay::WordList)

# source://coderay-1.1.3/lib/coderay/scanners/python.rb:13
CodeRay::Scanners::Python::KEYWORDS = T.let(T.unsafe(nil), Array)

# source://coderay-1.1.3/lib/coderay/scanners/python.rb:64
CodeRay::Scanners::Python::NAME = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/python.rb:21
CodeRay::Scanners::Python::OLD_KEYWORDS = T.let(T.unsafe(nil), Array)

# source://coderay-1.1.3/lib/coderay/scanners/python.rb:68
CodeRay::Scanners::Python::OPERATOR = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/python.rb:37
CodeRay::Scanners::Python::PREDEFINED_EXCEPTIONS = T.let(T.unsafe(nil), Array)

# source://coderay-1.1.3/lib/coderay/scanners/python.rb:25
CodeRay::Scanners::Python::PREDEFINED_METHODS_AND_TYPES = T.let(T.unsafe(nil), Array)

# source://coderay-1.1.3/lib/coderay/scanners/python.rb:52
CodeRay::Scanners::Python::PREDEFINED_VARIABLES_AND_CONSTANTS = T.let(T.unsafe(nil), Array)

# source://coderay-1.1.3/lib/coderay/scanners/python.rb:82
CodeRay::Scanners::Python::STRING_CONTENT_REGEXP = T.let(T.unsafe(nil), Hash)

# source://coderay-1.1.3/lib/coderay/scanners/python.rb:78
CodeRay::Scanners::Python::STRING_DELIMITER_REGEXP = T.let(T.unsafe(nil), Hash)

# source://coderay-1.1.3/lib/coderay/scanners/python.rb:66
CodeRay::Scanners::Python::UNICODE_ESCAPE = T.let(T.unsafe(nil), Regexp)

# = Raydebug Scanner
#
# Highlights the output of the Encoders::Debug encoder.
#
# source://coderay-1.1.3/lib/coderay/scanners/raydebug.rb:9
class CodeRay::Scanners::Raydebug < ::CodeRay::Scanners::Scanner
  protected

  # source://coderay-1.1.3/lib/coderay/scanners/raydebug.rb:22
  def scan_tokens(encoder, options); end

  # source://coderay-1.1.3/lib/coderay/scanners/raydebug.rb:17
  def setup; end
end

# This scanner is really complex, since Ruby _is_ a complex language!
#
# It tries to highlight 100% of all common code,
# and 90% of strange codes.
#
# It is optimized for HTML highlighting, and is not very useful for
# parsing or pretty printing.
#
# source://coderay-1.1.3/lib/coderay/scanners/ruby.rb:11
class CodeRay::Scanners::Ruby < ::CodeRay::Scanners::Scanner
  # source://coderay-1.1.3/lib/coderay/scanners/ruby.rb:19
  def interpreted_string_state; end

  protected

  # source://coderay-1.1.3/lib/coderay/scanners/ruby.rb:29
  def scan_tokens(encoder, options); end

  # source://coderay-1.1.3/lib/coderay/scanners/ruby.rb:25
  def setup; end
end

# source://coderay-1.1.3/lib/coderay/scanners/ruby/patterns.rb:5
module CodeRay::Scanners::Ruby::Patterns; end

# source://coderay-1.1.3/lib/coderay/scanners/ruby/patterns.rb:72
CodeRay::Scanners::Ruby::Patterns::BINARY = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/ruby/patterns.rb:106
CodeRay::Scanners::Ruby::Patterns::CHARACTER = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/ruby/patterns.rb:55
CodeRay::Scanners::Ruby::Patterns::CLASS_VARIABLE = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/ruby/patterns.rb:96
CodeRay::Scanners::Ruby::Patterns::CONTROL_META_ESCAPE = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/ruby/patterns.rb:132
CodeRay::Scanners::Ruby::Patterns::DATA = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/ruby/patterns.rb:69
CodeRay::Scanners::Ruby::Patterns::DECIMAL = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/ruby/patterns.rb:102
CodeRay::Scanners::Ruby::Patterns::ESCAPE = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/ruby/patterns.rb:74
CodeRay::Scanners::Ruby::Patterns::EXPONENT = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/ruby/patterns.rb:168
CodeRay::Scanners::Ruby::Patterns::FANCY_STRING_INTERPRETED = T.let(T.unsafe(nil), Hash)

# source://coderay-1.1.3/lib/coderay/scanners/ruby/patterns.rb:161
CodeRay::Scanners::Ruby::Patterns::FANCY_STRING_KIND = T.let(T.unsafe(nil), Hash)

# source://coderay-1.1.3/lib/coderay/scanners/ruby/patterns.rb:160
CodeRay::Scanners::Ruby::Patterns::FANCY_STRING_START = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/ruby/patterns.rb:76
CodeRay::Scanners::Ruby::Patterns::FLOAT_OR_INT = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/ruby/patterns.rb:75
CodeRay::Scanners::Ruby::Patterns::FLOAT_SUFFIX = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/ruby/patterns.rb:57
CodeRay::Scanners::Ruby::Patterns::GLOBAL_VARIABLE = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/ruby/patterns.rb:116
CodeRay::Scanners::Ruby::Patterns::HEREDOC_OPEN = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/ruby/patterns.rb:71
CodeRay::Scanners::Ruby::Patterns::HEXADECIMAL = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/ruby/patterns.rb:38
CodeRay::Scanners::Ruby::Patterns::IDENT = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/ruby/patterns.rb:28
CodeRay::Scanners::Ruby::Patterns::IDENT_KIND = T.let(T.unsafe(nil), CodeRay::WordList)

# source://coderay-1.1.3/lib/coderay/scanners/ruby/patterns.rb:54
CodeRay::Scanners::Ruby::Patterns::INSTANCE_VARIABLE = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/ruby/patterns.rb:7
CodeRay::Scanners::Ruby::Patterns::KEYWORDS = T.let(T.unsafe(nil), Array)

# source://coderay-1.1.3/lib/coderay/scanners/ruby/patterns.rb:151
CodeRay::Scanners::Ruby::Patterns::KEYWORDS_EXPECTING_VALUE = T.let(T.unsafe(nil), CodeRay::WordList)

# source://coderay-1.1.3/lib/coderay/scanners/ruby/patterns.rb:32
CodeRay::Scanners::Ruby::Patterns::KEYWORD_NEW_STATE = T.let(T.unsafe(nil), CodeRay::WordList)

# source://coderay-1.1.3/lib/coderay/scanners/ruby/patterns.rb:53
CodeRay::Scanners::Ruby::Patterns::METHOD_AFTER_DOT = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/ruby/patterns.rb:40
CodeRay::Scanners::Ruby::Patterns::METHOD_NAME = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/ruby/patterns.rb:52
CodeRay::Scanners::Ruby::Patterns::METHOD_NAME_EX = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/ruby/patterns.rb:41
CodeRay::Scanners::Ruby::Patterns::METHOD_NAME_OPERATOR = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/ruby/patterns.rb:87
CodeRay::Scanners::Ruby::Patterns::METHOD_NAME_OR_SYMBOL = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/ruby/patterns.rb:51
CodeRay::Scanners::Ruby::Patterns::METHOD_SUFFIX = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/ruby/patterns.rb:77
CodeRay::Scanners::Ruby::Patterns::NUMERIC = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/ruby/patterns.rb:56
CodeRay::Scanners::Ruby::Patterns::OBJECT_VARIABLE = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/ruby/patterns.rb:70
CodeRay::Scanners::Ruby::Patterns::OCTAL = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/ruby/patterns.rb:17
CodeRay::Scanners::Ruby::Patterns::PREDEFINED_CONSTANTS = T.let(T.unsafe(nil), Array)

# source://coderay-1.1.3/lib/coderay/scanners/ruby/patterns.rb:58
CodeRay::Scanners::Ruby::Patterns::PREFIX_VARIABLE = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/ruby/patterns.rb:61
CodeRay::Scanners::Ruby::Patterns::QUOTE_TO_TYPE = T.let(T.unsafe(nil), Hash)

# source://coderay-1.1.3/lib/coderay/scanners/ruby/patterns.rb:67
CodeRay::Scanners::Ruby::Patterns::REGEXP_MODIFIERS = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/ruby/patterns.rb:126
CodeRay::Scanners::Ruby::Patterns::RUBYDOC = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/ruby/patterns.rb:138
CodeRay::Scanners::Ruby::Patterns::RUBYDOC_OR_DATA = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/ruby/patterns.rb:89
CodeRay::Scanners::Ruby::Patterns::SIMPLE_ESCAPE = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/ruby/patterns.rb:79
CodeRay::Scanners::Ruby::Patterns::SYMBOL = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/ruby/patterns.rb:142
CodeRay::Scanners::Ruby::Patterns::VALUE_FOLLOWS = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/ruby/patterns.rb:59
CodeRay::Scanners::Ruby::Patterns::VARIABLE = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/ruby/string_state.rb:8
class CodeRay::Scanners::Ruby::StringState < ::Struct
  # @return [StringState] a new instance of StringState
  #
  # source://coderay-1.1.3/lib/coderay/scanners/ruby/string_state.rb:48
  def initialize(kind, interpreted, delim, heredoc = T.unsafe(nil)); end

  # source://coderay-1.1.3/lib/coderay/scanners/ruby/string_state.rb:63
  def heredoc_pattern(delim, interpreted, indented); end

  class << self
    # source://coderay-1.1.3/lib/coderay/scanners/ruby/string_state.rb:40
    def simple_key_pattern(delim); end
  end
end

# source://coderay-1.1.3/lib/coderay/scanners/ruby/string_state.rb:10
CodeRay::Scanners::Ruby::StringState::CLOSING_PAREN = T.let(T.unsafe(nil), Hash)

# source://coderay-1.1.3/lib/coderay/scanners/ruby/string_state.rb:17
CodeRay::Scanners::Ruby::StringState::STRING_PATTERN = T.let(T.unsafe(nil), Hash)

# by Josh Goebel
#
# source://coderay-1.1.3/lib/coderay/scanners/sql.rb:5
class CodeRay::Scanners::SQL < ::CodeRay::Scanners::Scanner
  # source://coderay-1.1.3/lib/coderay/scanners/sql.rb:66
  def scan_tokens(encoder, options); end
end

# source://coderay-1.1.3/lib/coderay/scanners/sql.rb:23
CodeRay::Scanners::SQL::COMMANDS = T.let(T.unsafe(nil), Array)

# source://coderay-1.1.3/lib/coderay/scanners/sql.rb:38
CodeRay::Scanners::SQL::DIRECTIVES = T.let(T.unsafe(nil), Array)

# source://coderay-1.1.3/lib/coderay/scanners/sql.rb:55
CodeRay::Scanners::SQL::ESCAPE = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/sql.rb:46
CodeRay::Scanners::SQL::IDENT_KIND = T.let(T.unsafe(nil), CodeRay::WordList::CaseIgnoring)

# source://coderay-1.1.3/lib/coderay/scanners/sql.rb:9
CodeRay::Scanners::SQL::KEYWORDS = T.let(T.unsafe(nil), Array)

# source://coderay-1.1.3/lib/coderay/scanners/sql.rb:18
CodeRay::Scanners::SQL::OBJECTS = T.let(T.unsafe(nil), Array)

# source://coderay-1.1.3/lib/coderay/scanners/sql.rb:44
CodeRay::Scanners::SQL::PREDEFINED_CONSTANTS = T.let(T.unsafe(nil), Array)

# source://coderay-1.1.3/lib/coderay/scanners/sql.rb:36
CodeRay::Scanners::SQL::PREDEFINED_FUNCTIONS = T.let(T.unsafe(nil), Array)

# source://coderay-1.1.3/lib/coderay/scanners/sql.rb:28
CodeRay::Scanners::SQL::PREDEFINED_TYPES = T.let(T.unsafe(nil), Array)

# source://coderay-1.1.3/lib/coderay/scanners/sql.rb:60
CodeRay::Scanners::SQL::STRING_CONTENT_PATTERN = T.let(T.unsafe(nil), Hash)

# source://coderay-1.1.3/lib/coderay/scanners/sql.rb:58
CodeRay::Scanners::SQL::STRING_PREFIXES = T.let(T.unsafe(nil), Regexp)

# source://coderay-1.1.3/lib/coderay/scanners/sql.rb:56
CodeRay::Scanners::SQL::UNICODE_ESCAPE = T.let(T.unsafe(nil), Regexp)

# A scanner for Sass.
#
# source://coderay-1.1.3/lib/coderay/scanners/sass.rb:5
class CodeRay::Scanners::Sass < ::CodeRay::Scanners::CSS
  protected

  # source://coderay-1.1.3/lib/coderay/scanners/sass.rb:16
  def scan_tokens(encoder, options); end

  # source://coderay-1.1.3/lib/coderay/scanners/sass.rb:12
  def setup; end
end

# = Scanner
#
# The base class for all Scanners.
#
# It is a subclass of Ruby's great +StringScanner+, which
# makes it easy to access the scanning methods inside.
#
# It is also +Enumerable+, so you can use it like an Array of
# Tokens:
#
#   require 'coderay'
#
#   c_scanner = CodeRay::Scanners[:c].new "if (*p == '{') nest++;"
#
#   for text, kind in c_scanner
#     puts text if kind == :operator
#   end
#
#   # prints: (*==)++;
#
# OK, this is a very simple example :)
# You can also use +map+, +any?+, +find+ and even +sort_by+,
# if you want.
#
# source://coderay-1.1.3/lib/coderay/scanners/scanner.rb:29
class CodeRay::Scanners::Scanner < ::StringScanner
  include ::Enumerable
  extend ::CodeRay::Plugin

  # Create a new Scanner.
  #
  # * +code+ is the input String and is handled by the superclass
  #   StringScanner.
  # * +options+ is a Hash with Symbols as keys.
  #   It is merged with the default options of the class (you can
  #   overwrite default options here.)
  #
  # Else, a Tokens object is used.
  #
  # @return [Scanner] a new instance of Scanner
  #
  # source://coderay-1.1.3/lib/coderay/scanners/scanner.rb:125
  def initialize(code = T.unsafe(nil), options = T.unsafe(nil)); end

  # The string in binary encoding.
  #
  # To be used with #pos, which is the index of the byte the scanner
  # will scan next.
  #
  # source://coderay-1.1.3/lib/coderay/scanners/scanner.rb:218
  def binary_string; end

  # The current column position of the scanner, starting with 1.
  # See also: #line.
  #
  # source://coderay-1.1.3/lib/coderay/scanners/scanner.rb:209
  def column(pos = T.unsafe(nil)); end

  # Traverse the tokens.
  #
  # source://coderay-1.1.3/lib/coderay/scanners/scanner.rb:192
  def each(&block); end

  # the default file extension for this scanner
  #
  # source://coderay-1.1.3/lib/coderay/scanners/scanner.rb:160
  def file_extension; end

  # the Plugin ID for this scanner
  #
  # source://coderay-1.1.3/lib/coderay/scanners/scanner.rb:155
  def lang; end

  # The current line position of the scanner, starting with 1.
  # See also: #column.
  #
  # Beware, this is implemented inefficiently. It should be used
  # for debugging only.
  #
  # source://coderay-1.1.3/lib/coderay/scanners/scanner.rb:202
  def line(pos = T.unsafe(nil)); end

  # Sets back the scanner. Subclasses should redefine the reset_instance
  # method instead of this one.
  #
  # source://coderay-1.1.3/lib/coderay/scanners/scanner.rb:142
  def reset; end

  # Returns the value of attribute state.
  #
  # source://coderay-1.1.3/lib/coderay/scanners/scanner.rb:44
  def state; end

  # Sets the attribute state
  #
  # @param value the value to set the attribute state to.
  #
  # source://coderay-1.1.3/lib/coderay/scanners/scanner.rb:44
  def state=(_arg0); end

  # Set a new string to be scanned.
  #
  # source://coderay-1.1.3/lib/coderay/scanners/scanner.rb:148
  def string=(code); end

  # Scan the code and returns all tokens in a Tokens object.
  #
  # source://coderay-1.1.3/lib/coderay/scanners/scanner.rb:165
  def tokenize(source = T.unsafe(nil), options = T.unsafe(nil)); end

  # Cache the result of tokenize.
  #
  # source://coderay-1.1.3/lib/coderay/scanners/scanner.rb:187
  def tokens; end

  protected

  # Scanner error with additional status information
  #
  # @raise [ScanError]
  #
  # source://coderay-1.1.3/lib/coderay/scanners/scanner.rb:314
  def raise_inspect(message, tokens, state = T.unsafe(nil), ambit = T.unsafe(nil), backtrace = T.unsafe(nil)); end

  # source://coderay-1.1.3/lib/coderay/scanners/scanner.rb:289
  def raise_inspect_arguments(message, tokens, state, ambit); end

  # Resets the scanner.
  #
  # source://coderay-1.1.3/lib/coderay/scanners/scanner.rb:265
  def reset_instance; end

  # Shorthand for scan_until(/\z/).
  # This method also avoids a JRuby 1.9 mode bug.
  #
  # source://coderay-1.1.3/lib/coderay/scanners/scanner.rb:328
  def scan_rest; end

  # This is the central method, and commonly the only one a
  # subclass implements.
  #
  # Subclasses must implement this method; it must return +tokens+
  # and must only use Tokens#<< for storing scanned tokens!
  #
  # @raise [NotImplementedError]
  #
  # source://coderay-1.1.3/lib/coderay/scanners/scanner.rb:260
  def scan_tokens(tokens, options); end

  # source://coderay-1.1.3/lib/coderay/scanners/scanner.rb:305
  def scanner_state_info(state); end

  # source://coderay-1.1.3/lib/coderay/scanners/scanner.rb:239
  def set_string_from_source(source); end

  # source://coderay-1.1.3/lib/coderay/scanners/scanner.rb:250
  def set_tokens_from_options(options); end

  # Can be implemented by subclasses to do some initialization
  # that has to be done once per instance.
  #
  # Use reset for initialization that has to be done once per
  # scan.
  #
  # source://coderay-1.1.3/lib/coderay/scanners/scanner.rb:236
  def setup; end

  # source://coderay-1.1.3/lib/coderay/scanners/scanner.rb:322
  def tokens_last(tokens, n); end

  # source://coderay-1.1.3/lib/coderay/scanners/scanner.rb:318
  def tokens_size(tokens); end

  class << self
    # The encoding used internally by this scanner.
    #
    # source://coderay-1.1.3/lib/coderay/scanners/scanner.rb:71
    def encoding(name = T.unsafe(nil)); end

    # The typical filename suffix for this scanner's language.
    #
    # source://coderay-1.1.3/lib/coderay/scanners/scanner.rb:66
    def file_extension(extension = T.unsafe(nil)); end

    # The lang of this Scanner class, which is equal to its Plugin ID.
    #
    # source://coderay-1.1.3/lib/coderay/scanners/scanner.rb:76
    def lang; end

    # Normalizes the given code into a string with UNIX newlines, in the
    # scanner's internal encoding, with invalid and undefined charachters
    # replaced by placeholders. Always returns a new object.
    #
    # source://coderay-1.1.3/lib/coderay/scanners/scanner.rb:51
    def normalize(code); end

    protected

    # source://coderay-1.1.3/lib/coderay/scanners/scanner.rb:82
    def encode_with_encoding(code, target_encoding); end

    # source://coderay-1.1.3/lib/coderay/scanners/scanner.rb:100
    def guess_encoding(s); end

    # source://coderay-1.1.3/lib/coderay/scanners/scanner.rb:96
    def to_unix(code); end
  end
end

# The default options for all scanner classes.
#
# Define @default_options for subclasses.
#
# source://coderay-1.1.3/lib/coderay/scanners/scanner.rb:40
CodeRay::Scanners::Scanner::DEFAULT_OPTIONS = T.let(T.unsafe(nil), Hash)

# source://coderay-1.1.3/lib/coderay/scanners/scanner.rb:42
CodeRay::Scanners::Scanner::KINDS_NOT_LOC = T.let(T.unsafe(nil), Array)

# source://coderay-1.1.3/lib/coderay/helpers/plugin.rb:41
CodeRay::Scanners::Scanner::PLUGIN_HOST = CodeRay::Scanners

# source://coderay-1.1.3/lib/coderay/scanners/scanner.rb:299
CodeRay::Scanners::Scanner::SCANNER_STATE_INFO = T.let(T.unsafe(nil), String)

# source://coderay-1.1.3/lib/coderay/scanners/scanner.rb:271
CodeRay::Scanners::Scanner::SCAN_ERROR_MESSAGE = T.let(T.unsafe(nil), String)

# Raised if a Scanner fails while scanning
#
# source://coderay-1.1.3/lib/coderay/scanners/scanner.rb:35
class CodeRay::Scanners::Scanner::ScanError < ::StandardError; end

# source://coderay-1.1.3/lib/coderay/scanners/taskpaper.rb:4
class CodeRay::Scanners::Taskpaper < ::CodeRay::Scanners::Scanner
  protected

  # source://coderay-1.1.3/lib/coderay/scanners/taskpaper.rb:11
  def scan_tokens(encoder, options); end
end

# Scanner for plain text.
#
# Yields just one token of the kind :plain.
#
# Alias: +plaintext+, +plain+
#
# source://coderay-1.1.3/lib/coderay/scanners/text.rb:9
class CodeRay::Scanners::Text < ::CodeRay::Scanners::Scanner
  protected

  # source://coderay-1.1.3/lib/coderay/scanners/text.rb:18
  def scan_tokens(encoder, options); end
end

# source://coderay-1.1.3/lib/coderay/scanners/text.rb:14
CodeRay::Scanners::Text::KINDS_NOT_LOC = T.let(T.unsafe(nil), Array)

# Scanner for XML.
#
# Currently this is the same scanner as Scanners::HTML.
#
# source://coderay-1.1.3/lib/coderay/scanners/xml.rb:9
class CodeRay::Scanners::XML < ::CodeRay::Scanners::HTML; end

# Scanner for YAML.
#
# Based on the YAML scanner from Syntax by Jamis Buck.
#
# source://coderay-1.1.3/lib/coderay/scanners/yaml.rb:7
class CodeRay::Scanners::YAML < ::CodeRay::Scanners::Scanner
  protected

  # source://coderay-1.1.3/lib/coderay/scanners/yaml.rb:16
  def scan_tokens(encoder, options); end
end

# source://coderay-1.1.3/lib/coderay/scanners/yaml.rb:12
CodeRay::Scanners::YAML::KINDS_NOT_LOC = T.let(T.unsafe(nil), Symbol)

# This module holds the Style class and its subclasses.
#
# See Plugin.
#
# source://coderay-1.1.3/lib/coderay/styles.rb:6
module CodeRay::Styles
  extend ::CodeRay::PluginHost
end

# A colorful theme using CSS 3 colors (with alpha channel).
#
# source://coderay-1.1.3/lib/coderay/styles/alpha.rb:5
class CodeRay::Styles::Alpha < ::CodeRay::Styles::Style; end

# source://coderay-1.1.3/lib/coderay/styles/alpha.rb:14
CodeRay::Styles::Alpha::CSS_MAIN_STYLES = T.let(T.unsafe(nil), String)

# source://coderay-1.1.3/lib/coderay/styles/alpha.rb:53
CodeRay::Styles::Alpha::TOKEN_COLORS = T.let(T.unsafe(nil), String)

# Base class for styles.
#
# Styles are used by Encoders::HTML to colorize tokens.
#
# source://coderay-1.1.3/lib/coderay/styles/style.rb:8
class CodeRay::Styles::Style
  extend ::CodeRay::Plugin
end

# source://coderay-1.1.3/lib/coderay/styles/style.rb:12
CodeRay::Styles::Style::DEFAULT_OPTIONS = T.let(T.unsafe(nil), Hash)

# source://coderay-1.1.3/lib/coderay/helpers/plugin.rb:41
CodeRay::Styles::Style::PLUGIN_HOST = CodeRay::Styles

# A Hash of all known token kinds and their associated CSS classes.
#
# source://coderay-1.1.3/lib/coderay/token_kinds.rb:4
CodeRay::TokenKinds = T.let(T.unsafe(nil), Hash)

# The Tokens class represents a list of tokens returned from
# a Scanner. It's actually just an Array with a few helper methods.
#
# A token itself is not a special object, just two elements in an Array:
# * the _token_ _text_ (the original source of the token in a String) or
#   a _token_ _action_ (begin_group, end_group, begin_line, end_line)
# * the _token_ _kind_ (a Symbol representing the type of the token)
#
# It looks like this:
#
#   ..., '# It looks like this', :comment, ...
#   ..., '3.1415926', :float, ...
#   ..., '$^', :error, ...
#
# Some scanners also yield sub-tokens, represented by special
# token actions, for example :begin_group and :end_group.
#
# The Ruby scanner, for example, splits "a string" into:
#
#  [
#   :begin_group, :string,
#   '"',          :delimiter,
#   'a string',   :content,
#   '"',          :delimiter,
#   :end_group,   :string
#  ]
#
# Tokens can be used to save the output of a Scanners in a simple
# Ruby object that can be send to an Encoder later:
#
#   tokens = CodeRay.scan('price = 2.59', :ruby).tokens
#   tokens.encode(:html)
#   tokens.html
#   CodeRay.encoder(:html).encode_tokens(tokens)
#
# Tokens gives you the power to handle pre-scanned code very easily:
# You can serialize it to a JSON string and store it in a database, pass it
# around to encode it more than once, send it to other algorithms...
#
# source://coderay-1.1.3/lib/coderay/tokens.rb:43
class CodeRay::Tokens < ::Array
  # source://coderay-1.1.3/lib/coderay/tokens.rb:156
  def begin_group(kind); end

  # source://coderay-1.1.3/lib/coderay/tokens.rb:158
  def begin_line(kind); end

  # Return the actual number of tokens.
  #
  # source://coderay-1.1.3/lib/coderay/tokens.rb:151
  def count; end

  # Encode the tokens using encoder.
  #
  # encoder can be
  # * a plugin name like :html oder 'statistic'
  # * an Encoder object
  #
  # options are passed to the encoder.
  #
  # source://coderay-1.1.3/lib/coderay/tokens.rb:56
  def encode(encoder, options = T.unsafe(nil)); end

  # source://coderay-1.1.3/lib/coderay/tokens.rb:157
  def end_group(kind); end

  # source://coderay-1.1.3/lib/coderay/tokens.rb:159
  def end_line(kind); end

  # Redirects unknown methods to encoder calls.
  #
  # For example, if you call +tokens.html+, the HTML encoder
  # is used to highlight the tokens.
  #
  # source://coderay-1.1.3/lib/coderay/tokens.rb:70
  def method_missing(meth, options = T.unsafe(nil)); end

  # The Scanner instance that created the tokens.
  #
  # source://coderay-1.1.3/lib/coderay/tokens.rb:47
  def scanner; end

  # The Scanner instance that created the tokens.
  #
  # source://coderay-1.1.3/lib/coderay/tokens.rb:47
  def scanner=(_arg0); end

  # Split the tokens into parts of the given +sizes+.
  #
  # The result will be an Array of Tokens objects. The parts have
  # the text size specified by the parameter. In addition, each
  # part closes all opened tokens. This is useful to insert tokens
  # betweem them.
  #
  # This method is used by @Scanner#tokenize@ when called with an Array
  # of source strings. The Diff encoder uses it for inline highlighting.
  #
  # source://coderay-1.1.3/lib/coderay/tokens.rb:85
  def split_into_parts(*sizes); end

  def text_token(*_arg0); end

  # Turn tokens into a string by concatenating them.
  #
  # source://coderay-1.1.3/lib/coderay/tokens.rb:62
  def to_s; end

  def tokens(*_arg0); end
end

# The result of a scan operation is a TokensProxy, but should act like Tokens.
#
# This proxy makes it possible to use the classic CodeRay.scan.encode API
# while still providing the benefits of direct streaming.
#
# source://coderay-1.1.3/lib/coderay/tokens_proxy.rb:7
class CodeRay::TokensProxy
  # Create a new TokensProxy with the arguments of CodeRay.scan.
  #
  # @return [TokensProxy] a new instance of TokensProxy
  #
  # source://coderay-1.1.3/lib/coderay/tokens_proxy.rb:12
  def initialize(input, lang, options = T.unsafe(nil), block = T.unsafe(nil)); end

  # Returns the value of attribute block.
  #
  # source://coderay-1.1.3/lib/coderay/tokens_proxy.rb:9
  def block; end

  # Sets the attribute block
  #
  # @param value the value to set the attribute block to.
  #
  # source://coderay-1.1.3/lib/coderay/tokens_proxy.rb:9
  def block=(_arg0); end

  # Overwrite Struct#each.
  #
  # source://coderay-1.1.3/lib/coderay/tokens_proxy.rb:48
  def each(*args, &blk); end

  # Call CodeRay.encode if +encoder+ is a Symbol;
  # otherwise, convert the receiver to tokens and call encoder.encode_tokens.
  #
  # source://coderay-1.1.3/lib/coderay/tokens_proxy.rb:21
  def encode(encoder, options = T.unsafe(nil)); end

  # Returns the value of attribute input.
  #
  # source://coderay-1.1.3/lib/coderay/tokens_proxy.rb:9
  def input; end

  # Sets the attribute input
  #
  # @param value the value to set the attribute input to.
  #
  # source://coderay-1.1.3/lib/coderay/tokens_proxy.rb:9
  def input=(_arg0); end

  # Returns the value of attribute lang.
  #
  # source://coderay-1.1.3/lib/coderay/tokens_proxy.rb:9
  def lang; end

  # Sets the attribute lang
  #
  # @param value the value to set the attribute lang to.
  #
  # source://coderay-1.1.3/lib/coderay/tokens_proxy.rb:9
  def lang=(_arg0); end

  # Tries to call encode;
  # delegates to tokens otherwise.
  #
  # source://coderay-1.1.3/lib/coderay/tokens_proxy.rb:31
  def method_missing(method, *args, &blk); end

  # Returns the value of attribute options.
  #
  # source://coderay-1.1.3/lib/coderay/tokens_proxy.rb:9
  def options; end

  # Sets the attribute options
  #
  # @param value the value to set the attribute options to.
  #
  # source://coderay-1.1.3/lib/coderay/tokens_proxy.rb:9
  def options=(_arg0); end

  # A (cached) scanner instance to use for the scan task.
  #
  # source://coderay-1.1.3/lib/coderay/tokens_proxy.rb:43
  def scanner; end

  # The (cached) result of the tokenized input; a Tokens instance.
  #
  # source://coderay-1.1.3/lib/coderay/tokens_proxy.rb:38
  def tokens; end
end

# source://coderay-1.1.3/lib/coderay/version.rb:2
CodeRay::VERSION = T.let(T.unsafe(nil), String)

# = WordList
#
# <b>A Hash subclass designed for mapping word lists to token types.</b>
#
# A WordList is a Hash with some additional features.
# It is intended to be used for keyword recognition.
#
# WordList is optimized to be used in Scanners,
# typically to decide whether a given ident is a special token.
#
# For case insensitive words use WordList::CaseIgnoring.
#
# Example:
#
#  # define word arrays
#  RESERVED_WORDS = %w[
#    asm break case continue default do else
#  ]
#
#  PREDEFINED_TYPES = %w[
#    int long short char void
#  ]
#
#  # make a WordList
#  IDENT_KIND = WordList.new(:ident).
#    add(RESERVED_WORDS, :reserved).
#    add(PREDEFINED_TYPES, :predefined_type)
#
#  ...
#
#  def scan_tokens tokens, options
#    ...
#
#    elsif scan(/[A-Za-z_][A-Za-z_0-9]*/)
#      # use it
#      kind = IDENT_KIND[match]
#      ...
#
# source://coderay-1.1.3/lib/coderay/helpers/word_list.rb:40
class CodeRay::WordList < ::Hash
  # Create a new WordList with +default+ as default value.
  #
  # @return [WordList] a new instance of WordList
  #
  # source://coderay-1.1.3/lib/coderay/helpers/word_list.rb:43
  def initialize(default = T.unsafe(nil)); end

  # Add words to the list and associate them with +value+.
  #
  # Returns +self+, so you can concat add calls.
  #
  # source://coderay-1.1.3/lib/coderay/helpers/word_list.rb:50
  def add(words, value = T.unsafe(nil)); end
end

# A CaseIgnoring WordList is like a WordList, only that
# keys are compared case-insensitively (normalizing keys using +downcase+).
#
# source://coderay-1.1.3/lib/coderay/helpers/word_list.rb:60
class CodeRay::WordList::CaseIgnoring < ::CodeRay::WordList
  # source://coderay-1.1.3/lib/coderay/helpers/word_list.rb:62
  def [](key); end

  # source://coderay-1.1.3/lib/coderay/helpers/word_list.rb:66
  def []=(key, value); end
end
