# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `CFPropertyList` gem.
# Please instead update this file by running `bin/tapioca gem CFPropertyList`.

# source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFPropertyList.rb:416
class Array
  include ::Enumerable

  # convert an array to plist format
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFPropertyList.rb:418
  def to_plist(options = T.unsafe(nil)); end
end

# Exception thrown when format errors occur
#
# source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFPlistError.rb:19
class CFFormatError < ::CFPlistError; end

# general plist error. All exceptions thrown are derived from this class.
#
# source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFPlistError.rb:15
class CFPlistError < ::StandardError; end

# source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFPropertyList.rb:45
module CFPropertyList
  private

  # Create CFType hierarchy by guessing the correct CFType, e.g.
  #
  #  x = {
  #    'a' => ['b','c','d']
  #  }
  #  cftypes = CFPropertyList.guess(x)
  #
  # pass optional options hash. Only possible value actually:
  # +convert_unknown_to_string+::   Convert unknown objects to string calling to_str()
  # +converter_method+::    Convert unknown objects to known objects calling +method_name+
  #
  #  cftypes = CFPropertyList.guess(x,:convert_unknown_to_string => true,:converter_method => :to_hash, :converter_with_opts => true)
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFPropertyList.rb:115
  def guess(object, options = T.unsafe(nil)); end

  # Converts a CFType hiercharchy to native Ruby types
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFPropertyList.rb:171
  def native_types(object, keys_as_symbols = T.unsafe(nil)); end

  class << self
    # Create CFType hierarchy by guessing the correct CFType, e.g.
    #
    #  x = {
    #    'a' => ['b','c','d']
    #  }
    #  cftypes = CFPropertyList.guess(x)
    #
    # pass optional options hash. Only possible value actually:
    # +convert_unknown_to_string+::   Convert unknown objects to string calling to_str()
    # +converter_method+::    Convert unknown objects to known objects calling +method_name+
    #
    #  cftypes = CFPropertyList.guess(x,:convert_unknown_to_string => true,:converter_method => :to_hash, :converter_with_opts => true)
    #
    # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFPropertyList.rb:115
    def guess(object, options = T.unsafe(nil)); end

    # Converts a CFType hiercharchy to native Ruby types
    #
    # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFPropertyList.rb:171
    def native_types(object, keys_as_symbols = T.unsafe(nil)); end

    # Returns the value of attribute xml_parser_interface.
    #
    # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFPropertyList.rb:47
    def xml_parser_interface; end

    # Sets the attribute xml_parser_interface
    #
    # @param value the value to set the attribute xml_parser_interface to.
    #
    # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFPropertyList.rb:47
    def xml_parser_interface=(_arg0); end
  end
end

# Binary PList parser class
#
# source://CFPropertyList-3.0.5/lib/cfpropertylist/rbBinaryCFPropertyList.rb:7
class CFPropertyList::Binary
  # Convert array to binary format and add it to the object table
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbBinaryCFPropertyList.rb:561
  def array_to_binary(val); end

  # Convert a bool value to binary and add it to the object table
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbBinaryCFPropertyList.rb:544
  def bool_to_binary(val); end

  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbBinaryCFPropertyList.rb:418
  def count_object_refs(object); end

  # Convert data value to binary format and add it to the object table
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbBinaryCFPropertyList.rb:552
  def data_to_binary(val); end

  # Convert date value (apple format) to binary and adds it to the object table
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbBinaryCFPropertyList.rb:533
  def date_to_binary(val); end

  # Convert dictionary to binary format and add it to the object table
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbBinaryCFPropertyList.rb:576
  def dict_to_binary(val); end

  # Codes an integer to binary format
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbBinaryCFPropertyList.rb:471
  def int_to_binary(value); end

  # Read a binary plist file
  #
  # @raise [CFFormatError]
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbBinaryCFPropertyList.rb:9
  def load(opts); end

  # Converts a numeric value to binary and adds it to the object table
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbBinaryCFPropertyList.rb:494
  def num_to_binary(value); end

  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbBinaryCFPropertyList.rb:107
  def object_ref_size(object_refs); end

  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbBinaryCFPropertyList.rb:203
  def read_fd(fd, length); end

  # Codes a real value to binary format
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbBinaryCFPropertyList.rb:489
  def real_to_binary(val); end

  # Uniques and transforms a string value to binary format and adds it to the object table
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbBinaryCFPropertyList.rb:450
  def string_to_binary(val); end

  # Convert CFPropertyList to binary format; since we have to count our objects we simply unique CFDictionary and CFArray
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbBinaryCFPropertyList.rb:61
  def to_str(opts = T.unsafe(nil)); end

  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbBinaryCFPropertyList.rb:506
  def uid_to_binary(value); end

  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbBinaryCFPropertyList.rb:256
  def unpack_with_size(nbytes, buff); end

  protected

  # Read an binary array value, including contained objects
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbBinaryCFPropertyList.rb:267
  def read_binary_array(fname, fd, length); end

  # Read a binary data value
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbBinaryCFPropertyList.rb:198
  def read_binary_data(fname, fd, length); end

  # read a binary date value
  #
  # @raise [CFFormatError]
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbBinaryCFPropertyList.rb:175
  def read_binary_date(fname, fd, length); end

  # Read a dictionary value, including contained objects
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbBinaryCFPropertyList.rb:287
  def read_binary_dict(fname, fd, length); end

  # read a binary int value
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbBinaryCFPropertyList.rb:125
  def read_binary_int(fname, fd, length); end

  # read a „null” type (i.e. null byte, marker byte, bool value)
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbBinaryCFPropertyList.rb:112
  def read_binary_null_type(length); end

  # Read an object type byte, decode it and delegate to the correct
  # reader function
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbBinaryCFPropertyList.rb:313
  def read_binary_object(fname, fd); end

  # Read an object type byte at position $pos, decode it and delegate to the correct reader function
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbBinaryCFPropertyList.rb:354
  def read_binary_object_at(fname, fd, pos); end

  # read a binary real value
  #
  # @raise [CFFormatError]
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbBinaryCFPropertyList.rb:151
  def read_binary_real(fname, fd, length); end

  # Read a binary string value
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbBinaryCFPropertyList.rb:208
  def read_binary_string(fname, fd, length); end

  # Read a unicode string value, coded as UTF-16BE
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbBinaryCFPropertyList.rb:245
  def read_binary_unicode_string(fname, fd, length); end

  class << self
    # @return [Boolean]
    #
    # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbBinaryCFPropertyList.rb:441
    def ascii_string?(str); end

    # calculate how many bytes are needed to save +count+
    #
    # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbBinaryCFPropertyList.rb:387
    def bytes_needed(count); end

    # Convert the given string from one charset to another
    #
    # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbBinaryCFPropertyList.rb:216
    def charset_convert(str, from, to = T.unsafe(nil)); end

    # Count characters considering character set
    #
    # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbBinaryCFPropertyList.rb:222
    def charset_strlen(str, charset = T.unsafe(nil)); end

    # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbBinaryCFPropertyList.rb:374
    def pack_int_array_with_size(nbytes, array); end

    # pack an +int+ of +nbytes+ with size
    #
    # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbBinaryCFPropertyList.rb:362
    def pack_it_with_size(nbytes, int); end

    # Create a type byte for binary format as defined by apple
    #
    # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbBinaryCFPropertyList.rb:399
    def type_bytes(type, length); end
  end
end

# Blob is intended to distinguish between a Ruby String instance that should
# be converted to a CFString type and a Ruby String instance that should be
# converted to a CFData type
#
# source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFTypes.rb:17
class CFPropertyList::Blob < ::String; end

# This class contains an array of values
#
# source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFTypes.rb:272
class CFPropertyList::CFArray < ::CFPropertyList::CFType
  # create a new array CFType
  #
  # @return [CFArray] a new instance of CFArray
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFTypes.rb:273
  def initialize(val = T.unsafe(nil)); end

  # convert to binary
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFTypes.rb:287
  def to_binary(bplist); end

  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFTypes.rb:291
  def to_plain(plist); end

  # convert to XML
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFTypes.rb:278
  def to_xml(parser); end
end

# This class contains a boolean value
#
# source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFTypes.rb:212
class CFPropertyList::CFBoolean < ::CFPropertyList::CFType
  # convert to binary
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFTypes.rb:218
  def to_binary(bplist); end

  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFTypes.rb:222
  def to_plain(plist); end

  # convert to XML
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFTypes.rb:213
  def to_xml(parser); end
end

# This class contains binary data values
#
# source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFTypes.rb:229
class CFPropertyList::CFData < ::CFPropertyList::CFType
  # set value to defined state, either base64 encoded or raw
  #
  # @return [CFData] a new instance of CFData
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFTypes.rb:235
  def initialize(value = T.unsafe(nil), format = T.unsafe(nil)); end

  # get base64 decoded value
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFTypes.rb:249
  def decoded_value; end

  # get base64 encoded value
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFTypes.rb:244
  def encoded_value; end

  # convert to binary
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFTypes.rb:261
  def to_binary(bplist); end

  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFTypes.rb:265
  def to_plain(plist); end

  # convert to XML
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFTypes.rb:254
  def to_xml(parser); end
end

# Base64 encoded data
#
# source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFTypes.rb:230
CFPropertyList::CFData::DATA_BASE64 = T.let(T.unsafe(nil), Integer)

# Raw data
#
# source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFTypes.rb:232
CFPropertyList::CFData::DATA_RAW = T.let(T.unsafe(nil), Integer)

# This class holds Time values. While Apple uses seconds since 2001,
# the rest of the world uses seconds since 1970. So if you access value
# directly, you get the Time class. If you access via get_value you either
# geht the timestamp or the Apple timestamp
#
# source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFTypes.rb:143
class CFPropertyList::CFDate < ::CFPropertyList::CFType
  # set value to defined state
  #
  # @return [CFDate] a new instance of CFDate
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFTypes.rb:163
  def initialize(value = T.unsafe(nil), format = T.unsafe(nil)); end

  # get timestamp, either UNIX or Apple timestamp
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFTypes.rb:185
  def get_value(format = T.unsafe(nil)); end

  # set value with timestamp, either Apple or UNIX
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFTypes.rb:176
  def set_value(value, format = T.unsafe(nil)); end

  # convert to binary
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFTypes.rb:201
  def to_binary(bplist); end

  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFTypes.rb:205
  def to_plain(plist); end

  # convert to XML
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFTypes.rb:194
  def to_xml(parser); end

  class << self
    # create a XML date strimg from a time object
    #
    # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFTypes.rb:149
    def date_string(val); end

    # parse a XML date string
    #
    # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFTypes.rb:155
    def parse_date(val); end
  end
end

# source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFTypes.rb:146
CFPropertyList::CFDate::DATE_DIFF_APPLE_UNIX = T.let(T.unsafe(nil), Integer)

# source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFTypes.rb:144
CFPropertyList::CFDate::TIMESTAMP_APPLE = T.let(T.unsafe(nil), Integer)

# source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFTypes.rb:145
CFPropertyList::CFDate::TIMESTAMP_UNIX = T.let(T.unsafe(nil), Integer)

# this class contains a hash of values
#
# source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFTypes.rb:299
class CFPropertyList::CFDictionary < ::CFPropertyList::CFType
  # Create new CFDictonary type.
  #
  # @return [CFDictionary] a new instance of CFDictionary
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFTypes.rb:300
  def initialize(value = T.unsafe(nil)); end

  # convert to binary
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFTypes.rb:316
  def to_binary(bplist); end

  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFTypes.rb:320
  def to_plain(plist); end

  # convert to XML
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFTypes.rb:305
  def to_xml(parser); end
end

# This class holds integer/fixnum values
#
# source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFTypes.rb:103
class CFPropertyList::CFInteger < ::CFPropertyList::CFType
  # convert to binary
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFTypes.rb:111
  def to_binary(bplist); end

  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFTypes.rb:115
  def to_plain(plist); end

  # convert to XML
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFTypes.rb:104
  def to_xml(parser); end
end

# This class holds float values
#
# source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFTypes.rb:122
class CFPropertyList::CFReal < ::CFPropertyList::CFType
  # convert to binary
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFTypes.rb:130
  def to_binary(bplist); end

  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFTypes.rb:134
  def to_plain(plist); end

  # convert to XML
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFTypes.rb:123
  def to_xml(parser); end
end

# This class holds string values, both, UTF-8 and UTF-16BE
# It will convert the value to UTF-16BE if necessary (i.e. if non-ascii char contained)
#
# source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFTypes.rb:50
class CFPropertyList::CFString < ::CFPropertyList::CFType
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFTypes.rb:70
  def quoted; end

  # convert to binary
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFTypes.rb:58
  def to_binary(bplist); end

  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFTypes.rb:62
  def to_plain(plist); end

  # convert to XML
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFTypes.rb:51
  def to_xml(parser); end
end

# This class defines the base class for all CFType classes
#
# source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFTypes.rb:29
class CFPropertyList::CFType
  # @return [CFType] a new instance of CFType
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFTypes.rb:33
  def initialize(value = T.unsafe(nil)); end

  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFTypes.rb:40
  def to_binary(bplist); end

  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFTypes.rb:43
  def to_plain(plist); end

  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFTypes.rb:37
  def to_xml(parser); end

  # value of the type
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFTypes.rb:31
  def value; end

  # value of the type
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFTypes.rb:31
  def value=(_arg0); end
end

# source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFTypes.rb:333
class CFPropertyList::CFUid < ::CFPropertyList::CFType
  # convert to binary
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFTypes.rb:339
  def to_binary(bplist); end

  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFTypes.rb:343
  def to_plain(plist); end

  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFTypes.rb:334
  def to_xml(parser); end
end

# Class representing a CFPropertyList. Instantiate with #new
#
# source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFPropertyList.rb:201
class CFPropertyList::List
  # initialize a new CFPropertyList, arguments are:
  #
  # :file:: Parse a file
  # :format:: Format is one of FORMAT_BINARY or FORMAT_XML. Defaults to FORMAT_AUTO
  # :data:: Parse a string
  #
  # All arguments are optional
  #
  # @return [List] a new instance of List
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFPropertyList.rb:232
  def initialize(opts = T.unsafe(nil)); end

  # Path of PropertyList
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFPropertyList.rb:217
  def filename; end

  # Path of PropertyList
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFPropertyList.rb:217
  def filename=(_arg0); end

  # the original format of the PropertyList
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFPropertyList.rb:219
  def format; end

  # the original format of the PropertyList
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFPropertyList.rb:219
  def format=(_arg0); end

  # default value for XML generation; if true generate formatted XML
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFPropertyList.rb:223
  def formatted; end

  # default value for XML generation; if true generate formatted XML
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFPropertyList.rb:223
  def formatted=(_arg0); end

  # Read a plist file
  # file = nil:: The filename of the file to read. If nil, use +filename+ instance variable
  # format = nil:: The format of the plist file. Auto-detect if nil
  #
  # @raise [IOError]
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFPropertyList.rb:328
  def load(file = T.unsafe(nil), format = T.unsafe(nil)); end

  # read a binary plist file
  # filename = nil:: The filename to read from; if nil, read from the file defined by instance variable +filename+
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFPropertyList.rb:260
  def load_binary(filename = T.unsafe(nil)); end

  # load a plist from a binary string
  # str:: The string containing the plist
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFPropertyList.rb:278
  def load_binary_str(str = T.unsafe(nil)); end

  # read a plain plist file
  # filename = nil:: The filename to read from; if nil, read from the file defined by instance variable +filename+
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFPropertyList.rb:266
  def load_plain(filename = T.unsafe(nil)); end

  # load a plist from a plain string
  # str:: The string containing the plist
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFPropertyList.rb:284
  def load_plain_str(str = T.unsafe(nil)); end

  # load a plist from a string
  # str = nil:: The string containing the plist
  # format = nil:: The format of the plist
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFPropertyList.rb:291
  def load_str(str = T.unsafe(nil), format = T.unsafe(nil)); end

  # Load an XML PropertyList
  # filename = nil:: The filename to read from; if nil, read from the file defined by instance variable +filename+
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFPropertyList.rb:254
  def load_xml(filename = T.unsafe(nil)); end

  # load a plist from a XML string
  # str:: The string containing the plist
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFPropertyList.rb:272
  def load_xml_str(str = T.unsafe(nil)); end

  # Serialize CFPropertyList object to specified format and write it to file
  # file = nil:: The filename of the file to write to. Uses +filename+ instance variable if nil
  # format = nil:: The format to save in. Uses +format+ instance variable if nil
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFPropertyList.rb:370
  def save(file = T.unsafe(nil), format = T.unsafe(nil), opts = T.unsafe(nil)); end

  # convert plist to string
  # format = List::FORMAT_BINARY:: The format to save the plist
  # opts={}:: Pass parser options
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFPropertyList.rb:400
  def to_str(format = T.unsafe(nil), opts = T.unsafe(nil)); end

  # the root value in the plist file
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFPropertyList.rb:221
  def value; end

  # the root value in the plist file
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFPropertyList.rb:221
  def value=(_arg0); end

  class << self
    # returns a list of registered parsers
    #
    # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFPropertyList.rb:243
    def parsers; end

    # set a list of parsers
    #
    # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFPropertyList.rb:248
    def parsers=(val); end
  end
end

# Format constant for automatic format recognizing
#
# source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFPropertyList.rb:212
CFPropertyList::List::FORMAT_AUTO = T.let(T.unsafe(nil), Integer)

# Format constant for binary format
#
# source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFPropertyList.rb:203
CFPropertyList::List::FORMAT_BINARY = T.let(T.unsafe(nil), Integer)

# Format constant for the old plain format
#
# source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFPropertyList.rb:209
CFPropertyList::List::FORMAT_PLAIN = T.let(T.unsafe(nil), Integer)

# Format constant for XML format
#
# source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFPropertyList.rb:206
CFPropertyList::List::FORMAT_XML = T.let(T.unsafe(nil), Integer)

# XML parser
#
# source://CFPropertyList-3.0.5/lib/cfpropertylist/rbNokogiriParser.rb:7
class CFPropertyList::NokogiriXMLParser < ::CFPropertyList::ParserInterface
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbNokogiriParser.rb:68
  def append_node(parent, child); end

  # read a XML file
  # opts::
  # * :file - The filename of the file to load
  # * :data - The data to parse
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbNokogiriParser.rb:13
  def load(opts); end

  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbNokogiriParser.rb:60
  def new_node(name); end

  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbNokogiriParser.rb:64
  def new_text(val); end

  # serialize CFPropertyList object to XML
  # opts = {}:: Specify options: :formatted - Use indention and line breaks
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbNokogiriParser.rb:31
  def to_str(opts = T.unsafe(nil)); end

  protected

  # get the value of a DOM node
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbNokogiriParser.rb:75
  def get_value(n); end

  # import the XML values
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbNokogiriParser.rb:87
  def import_xml(node); end
end

# source://CFPropertyList-3.0.5/lib/cfpropertylist/rbNokogiriParser.rb:8
CFPropertyList::NokogiriXMLParser::PARSER_OPTIONS = T.let(T.unsafe(nil), Integer)

# interface class for PList parsers
#
# source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFPropertyList.rb:51
class CFPropertyList::ParserInterface
  # load a plist
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFPropertyList.rb:53
  def load(opts = T.unsafe(nil)); end

  # convert a plist to string
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFPropertyList.rb:58
  def to_str(opts = T.unsafe(nil)); end
end

# XML parser
#
# source://CFPropertyList-3.0.5/lib/cfpropertylist/rbPlainCFPropertyList.rb:11
class CFPropertyList::PlainParser < ::CFPropertyList::XMLParserInterface
  # read a XML file
  # opts::
  # * :file - The filename of the file to load
  # * :data - The data to parse
  #
  # @raise [CFFormatError]
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbPlainCFPropertyList.rb:12
  def load(opts); end

  # serialize CFPropertyList object to XML
  # opts = {}:: Specify options: :formatted - Use indention and line breaks
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbPlainCFPropertyList.rb:37
  def to_str(opts = T.unsafe(nil)); end

  protected

  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbPlainCFPropertyList.rb:106
  def escape_char; end

  # import the XML values
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbPlainCFPropertyList.rb:178
  def import_plain; end

  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbPlainCFPropertyList.rb:80
  def read_array; end

  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbPlainCFPropertyList.rb:170
  def read_binary; end

  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbPlainCFPropertyList.rb:46
  def read_dict; end

  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbPlainCFPropertyList.rb:131
  def read_quoted; end

  # @raise [CFFormatError]
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbPlainCFPropertyList.rb:150
  def read_unquoted; end

  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbPlainCFPropertyList.rb:42
  def skip_whitespaces; end
end

# source://CFPropertyList-3.0.5/lib/cfpropertylist/rbPlainCFPropertyList.rb:33
CFPropertyList::PlainParser::SPACES_AND_COMMENTS = T.let(T.unsafe(nil), Regexp)

# UidFixnum is intended to distinguish between a Ruby Integer
# instance that should be converted to a CFInteger/CFReal type and a
# Ruby Integer instance that should be converted to a CFUid type.
#
# source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFTypes.rb:24
class CFPropertyList::UidFixnum < ::Integer; end

# source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFPropertyList.rb:63
class CFPropertyList::XMLParserInterface < ::CFPropertyList::ParserInterface
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFPropertyList.rb:70
  def append_node(parent, child); end

  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFPropertyList.rb:64
  def new_node(name); end

  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFPropertyList.rb:67
  def new_text(val); end
end

# Exception thrown when type errors occur
#
# source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFPlistError.rb:23
class CFTypeError < ::CFPlistError; end

# source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFPropertyList.rb:427
class Enumerator
  include ::Enumerable

  # convert an array to plist format
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFPropertyList.rb:429
  def to_plist(options = T.unsafe(nil)); end
end

class Enumerator::ArithmeticSequence < ::Enumerator
  def ==(_arg0); end
  def ===(_arg0); end
  def begin; end
  def each; end
  def end; end
  def eql?(_arg0); end
  def exclude_end?; end
  def first(*_arg0); end
  def hash; end
  def inspect; end
  def last(*_arg0); end
  def size; end
  def step; end
end

class Enumerator::Chain < ::Enumerator
  def initialize(*_arg0); end

  def each(*_arg0); end
  def inspect; end
  def rewind; end
  def size; end

  private

  def initialize_copy(_arg0); end
end

class Enumerator::Generator
  include ::Enumerable
end

class Enumerator::Producer
  def each; end
end

# source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFPropertyList.rb:438
class Hash
  include ::Enumerable

  # convert a hash to plist format
  #
  # source://CFPropertyList-3.0.5/lib/cfpropertylist/rbCFPropertyList.rb:440
  def to_plist(options = T.unsafe(nil)); end
end
