# Dumping iBoot from the Kernel

This information only applies to iBoot64 on iOS 8 or lower.

In order to dump iBoot, you need:

1. Kernel read/write (eg `task_for_pid` 0)
1. `gPhysBase` and `gVirtBase`
1. A pointer to the kernel pmap's level1 translation table entries.

Once those are obtained, just add a mapping for `gPhysBase` to the level1 table (code for this is
available upon request; drop me a pm on freenode), mapping 1GB of physical memory at a given virtual address.
Additionally, make sure to clear the read only bit and set the EL0-accessible bit.

At this point, it's simple matter of memmem to figure out where iBoot is hiding in phys. Given a
`gPhysBase` map at `0xffffffc3c0000000`, this code should do the trick.

```c
int main(int argc, char **argv, char **envp) {
    char* base = (char*) 0xffffffc3c0000000;
    char* sig = (char*) "FFiBoot for ";
    char* iboot = (char*) memmem(base, (1<<30), sig+2, strlen(sig)-2);
    while (*(iboot-1) == 'F' && *(iboot-2) == 'F') {
        iboot ++;
        /* should fix size up here but too lazy lol */
        iboot = (char*) memmem(iboot, (1<<30), sig+2, strlen(sig)-2);
        assert(iboot);
    }
    iboot = (char*) (((uintptr_t)iboot) & (~0xFFF));
    printf("found iboot at %p\n", iboot);
    return 0;
}
````
