# Figlet Fonts
___

	 ███████████  ███           ████            █████   
	░░███░░░░░░█ ░░░           ░░███           ░░███    
	 ░███   █ ░  ████   ███████ ░███   ██████  ███████  
	 ░███████   ░░███  ███░░███ ░███  ███░░███░░░███░   
	 ░███░░░█    ░███ ░███ ░███ ░███ ░███████   ░███    
	 ░███  ░     ░███ ░███ ░███ ░███ ░███░░░    ░███ ███
	 █████       █████░░███████ █████░░██████   ░░█████ 
	░░░░░       ░░░░░  ░░░░░███░░░░░  ░░░░░░     ░░░░░  
	                   ███ ░███                         
	                  ░░██████                          
	                   ░░░░░░                           

	 ███████████                      █████           
	░░███░░░░░░█                     ░░███            
	 ░███   █ ░   ██████  ████████   ███████    █████ 
	 ░███████    ███░░███░░███░░███ ░░░███░    ███░░  
	 ░███░░░█   ░███ ░███ ░███ ░███   ░███    ░░█████ 
	 ░███  ░    ░███ ░███ ░███ ░███   ░███ ███ ░░░░███
	 █████      ░░██████  ████ █████  ░░█████  ██████ 
	░░░░░        ░░░░░░  ░░░░ ░░░░░    ░░░░░  ░░░░░░  
___

Collection of well known **FigLet** fonts gathered from different source.

## Install
___

Install **Figlet** firstly. For Debian/Ubuntu:

```sh
sudo apt-get install figlet
```

Clone repo and run `make` to install all fonts to **Figlet default install folder** (`/usr/share/figlet`):

```sh
git clone https://github.com/hIMEI29A/FigletFonts.git

cd FigletFonts

make
```

### Options
___

* To generate **HTML** listing run `make htmlgen`
* To generate **PLAIN** listing run `make plaingen`

## Fonts in the Gallery
___

**1943____**

	 ## ##           #### ### # #     ####          
	##   ##          #### ### # #     ####          
	####             #### ### # #     ####          
	 #####     ## ## #### ### # #        # ##  #### 
	    ### #  ## ## #### ### # #  #  ###   ## ##   
	##   ## ####  ## #### ### # # ### #### ### #### 
	 ## ##   ##   ## #### ### # # ### ####  ## ##   
	         ##   ## #### ### # #  # # ###  ## ##   


**1Row**

	_\~ /\ |\/| |^ |_ [- 
                     


**3D-ASCII**

	 ________  ________  _____ ______   ________  ___       _______      
	|\   ____\|\   __  \|\   _ \  _   \|\   __  \|\  \     |\  ___ \     
	\ \  \___|\ \  \|\  \ \  \\\__\ \  \ \  \|\  \ \  \    \ \   __/|    
	 \ \_____  \ \   __  \ \  \\|__| \  \ \   ____\ \  \    \ \  \_|/__  
	  \|____|\  \ \  \ \  \ \  \    \ \  \ \  \___|\ \  \____\ \  \_|\ \ 
	    ____\_\  \ \__\ \__\ \__\    \ \__\ \__\    \ \_______\ \_______\
	   |\_________\|__|\|__|\|__|     \|__|\|__|     \|_______|\|_______|
	   \|_________|                                                      
                                                                     
                                                                     


**3d_diagonal**

                                                                      
                                                                      
	  .--.--.                         ____              ,--,              
	 /  /    '.                     ,'  , `.,-.----.  ,--.'|              
	|  :  /`. /                  ,-+-,.' _ |\    /  \ |  | :              
	;  |  |--`                ,-+-. ;   , |||   :    |:  : '              
	|  :  ;_      ,--.--.    ,--.'|'   |  |||   | .\ :|  ' |      ,---.   
	 \  \    `.  /       \  |   |  ,', |  |,.   : |: |'  | |     /     \  
	  `----.   \.--.  .-. | |   | /  | |--' |   |  \ :|  | :    /    /  | 
	  __ \  \  | \__\/: . . |   : |  | ,    |   : .  |'  : |__ .    ' / | 
	 /  /`--'  / ," .--.; | |   : |  |/     :     |`-'|  | '.'|'   ;   /| 
	'--'.     / /  /  ,.  | |   | |`-'      :   : :   ;  :    ;'   |  / | 
	  `--'---' ;  :   .'   \|   ;/          |   | :   |  ,   / |   :    | 
	           |  ,     .-./'---'           `---'.|    ---`-'   \   \  /  
	            `--`---'                      `---`              `----'   
                                                                      


**3-d**

	  ********                                **        
	 **//////                        ******  /**        
	/**         ******   ********** /**///** /**  ***** 
	/********* //////** //**//**//**/**  /** /** **///**
	////////**  *******  /** /** /**/******  /**/*******
	       /** **////**  /** /** /**/**///   /**/**//// 
	 ******** //******** *** /** /**/**      ***//******
	////////   //////// ///  //  // //      ///  ////// 


**3d**
	
	  ████████                                ██        
	 ██░░░░░░                        ██████  ░██        
	░██         ██████   ██████████ ░██░░░██ ░██  █████ 
	░█████████ ░░░░░░██ ░░██░░██░░██░██  ░██ ░██ ██░░░██
	░░░░░░░░██  ███████  ░██ ░██ ░██░██████  ░██░███████
	       ░██ ██░░░░██  ░██ ░██ ░██░██░░░   ░██░██░░░░ 
	 ████████ ░░████████ ███ ░██ ░██░██      ███░░██████
	░░░░░░░░   ░░░░░░░░ ░░░  ░░  ░░ ░░      ░░░  ░░░░░░ 


**3x5**

                        
	 ##              #      
	#    ## ### ###  #  ### 
	 #  # # ### # #  #  ##  
	  # ### # # ###  ## ### 
	##          #           


**4max**

	.dP"Y8    db    8b    d8 88""Yb 88     888888 
	`Ybo."   dPYb   88b  d88 88__dP 88     88__   
	o.`Y8b  dP__Yb  88YbdP88 88"""  88  .o 88""   
	8bodP' dP""""Yb 88 YY 88 88     88ood8 888888 


**4x4_offr**

	  ####     #  ##  ######## ##                
	 ##  ##   ### ### ######## ##       ######## 
	 ##      ##### ###      ## ##       ######## 
	  ####  ####### ###     ## ##                
	     ## #######  ###    ## ##                
	 ##  ##   ###     ###   ## ##                
	  ####   #####     ###  ## ########          
                    ##  ## ########          


**5lineoblique**

                                                      
                                                      
	    //   ) )                                          
	   ((         ___      _   __      ___     //  ___    
	     \\     //   ) ) // ) )  ) ) //   ) ) // //___) ) 
	       ) ) //   / / // / /  / / //___/ / // //        
	((___ / / ((___( ( // / /  / / //       // ((____     


**5x7**

	 ##                     ##          
	#  #                     #          
	 #     ###  # #   ###    #     ##   
	  #   #  #  ####  #  #   #    # ##  
	#  #  # ##  #  #  #  #   #    ##    
	 ##    # #  #  #  ###   ###    ##   
                  #                 


**5x8**

	 ####   #     # #        #       #  
	 ####        # ##        #       #  
	 #  #        # ##         ##     #  
	 #  #         # #   ##           #  
	 #  #  ####        #  #        ###  
	          #         ###             
	         #            #     #       
	        #           ##      #       


**64f1____**

	 #####   #       # ##  # #  #  ##   #       #      
	###     #  ## #  #   # #    #  #   ##   #   #      
	 #####  #  ####  # #  ## #  # ##   ## ##   #    ## 
	    ### #   #     # ####  ### ##   ## ### #  ### # 
	    ### #   # # ## #       #       ##     #  ### # 
	#######  #####   # # # #     # ##  # #### #  ### # 
	####### # #      #  ##   ##   #  ##  #      ####   
	###### ###  ###  # #  ##  #  #  # #     # #   #    


**6x10**

                                          
	  ###                         ##          
	 #   #                         #          
	 #       ###   ## #   # ##     #     ###  
	  ###       #  # # #  ##  #    #    #   # 
	     #   ####  # # #  ##  #    #    ##### 
	 #   #  #   #  # # #  # ##     #    #     
	  ###    ####  #   #  #       ###    ###  
	                      #                   
	                      #                   


**6x9**

                                          
	  ##                          ##          
	 #  #                          #          
	  #      ###   ## #   ###      #     ##   
	   #    #  #   # # #  #  #     #    # ##  
	 #  #   #  #   # # #  #  #     #    ##    
	  ##     ####  #   #  ###     ###    ###  
	                      #                   
	                      #                   


**abraxas**

	  ▀▀▀▀▀▀    ▀▀▀▀▀▀▀▀   ▀▀▀  ▀▀▀  ▀▀▀▀▀▀▀▀▀  ▀▀▀        ▀▀▀▀▀▀▀▀▀  
	▀▀▀▀       ▀▀▀    ▀▀▀ ▀▀▀ ▀▀ ▀▀▀ ▀▀▀    ▀▀▀ ▀▀▀        ▀▀▀    ▀▀▀ 
	  ▀▀▀▀▀▀   ▀▀▀▀▀▀▀▀▀▀ ▀▀▀ ▀▀ ▀▀▀ ▀▀▀▀▀▀▀▀▀  ▀▀▀        ▀▀▀▀▀      
	      ▀▀▀▀ ▀▀▀    ▀▀▀ ▀▀▀ ▀▀ ▀▀▀ ▀▀▀        ▀▀▀    ▀▀▀ ▀▀▀    ▀▀▀ 
	  ▀▀▀▀▀▀   ▀▀▀    ▀▀▀ ▀▀▀    ▀▀▀ ▀▀▀        ▀▀▀▀▀▀▀▀▀▀ ▀▀▀▀▀▀▀▀▀  
                                                                  


**acrobatic**

	    o__ __o                                               o               
	   /v     v\                                             <|>              
	  />       <\                                            / \              
	 _\o____           o__ __o/  \o__ __o__ __o   \o_ __o    \o/    o__  __o  
	      \_\__o__    /v     |    |     |     |>   |    v\    |    /v      |> 
	            \    />     / \  / \   / \   / \  / \    <\  / \  />      //  
	  \         /    \      \o/  \o/   \o/   \o/  \o/     /  \o/  \o    o/    
	   o       o      o      |    |     |     |    |     o    |    v\  /v __o 
	   <\__ __/>      <\__  / \  / \   / \   / \  / \ __/>   / \    <\/> __/> 
	                                              \o/                         
	                                               |                          
	                                              / \                         


**advenger**

	 #####  ######## ##### #  ###   ## ###### # ######   
	##   ## ######## #####  # #   ##   ###### # #######  
	##      ######## ######     ##     ##### ## #######  
	 #####  ######## #######  ##       ##### ## ######## 
	     ## ######## ########          #####  # ######## 
	##   ## ####   # ########          ####   #  ####### 
	 #####  ###  #   ######## ##    ## #### #    ####### 
	        ### #      ###### ######## ###  #     ###### 


**alligator2**

	 ::::::::     :::    ::::    :::: ::::::::: :::       :::::::::: 
	:+:    :+:  :+: :+:  +:+:+: :+:+:+:+:    :+::+:       :+:        
	+:+        +:+   +:+ +:+ +:+:+ +:++:+    +:++:+       +:+        
	+#++:++#+++#++:++#++:+#+  +:+  +#++#++:++#+ +#+       +#++:++#   
	       +#++#+     +#++#+       +#++#+       +#+       +#+        
	#+#    #+##+#     #+##+#       #+##+#       #+#       #+#        
	 ######## ###     ######       ######       #################### 


**alligator3**

	 ::::::::     :::    ::::    :::: ::::::::: :::       :::::::::: 
	:+:    :+:  :+: :+:  +:+:+: :+:+:+:+:    :+::+:       :+:        
	+:+        +:+   +:+ +:+ +:+:+ +:++:+    +:++:+       +:+        
	+#++:++#+++#++:++#++:+#+  +:+  +#++#++:++#+ +#+       +#++:++#   
	       +#++#+     +#++#+       +#++#+       +#+       +#+        
	#+#    #+##+#     #+##+#       #+##+#       #+#       #+#        
	 ######## ###     ######       ######       #################### 


**alligator**

	      ::::::::     :::      :::   :::  ::::::::: :::       :::::::::: 
	    :+:    :+:  :+: :+:   :+:+: :+:+: :+:    :+::+:       :+:         
	   +:+        +:+   +:+ +:+ +:+:+ +:++:+    +:++:+       +:+          
	  +#++:++#+++#++:++#++:+#+  +:+  +#++#++:++#+ +#+       +#++:++#      
	        +#++#+     +#++#+       +#++#+       +#+       +#+            
	#+#    #+##+#     #+##+#       #+##+#       #+#       #+#             
	######## ###     ######       ######       ####################       


**alphabet**

	 SSS                 l     
	S                    l     
	 SSS   aa mmmm  ppp  l eee 
	    S a a m m m p  p l e e 
	SSSS  aaa m m m ppp  l ee  
	                p          
	                p          

**amc3line**

	.-. .-. .  . .-. .   .-. 
	`-. |-| |\/| |-' |   |-  
	`-' ` ' '  ` '   `-' `-' 


**amc3liv1**
	
	.: S;:. .:;S;:. .:;S;:. .::.         :.         
	S  S  S S  S     )      S  S          S S  S  S 
	`:;S :' `:;S;:' `:;S;:' `:;S;:' `:;S;:' `:;S;:' 
                                                

**amcaaa01**
	
	  sSSs   .S_SSSs     .S_SsS_S.    .S_sSSs    S.        sSSs  
	 d%%SP  .SS~SSSSS   .SS~S*S~SS.  .SS~YS%%b   SS.      d%%SP  
	d%S'    S%S   SSSS  S%S `Y' S%S  S%S   `S%b  S%S     d%S'    
	S%|     S%S    S%S  S%S     S%S  S%S    S%S  S%S     S%S     
	S&S     S%S SSSS%S  S%S     S%S  S%S    d*S  S&S     S&S     
	Y&Ss    S&S  SSS%S  S&S     S&S  S&S   .S*S  S&S     S&S_Ss  
	`S&&S   S&S    S&S  S&S     S&S  S&S_sdSSS   S&S     S&S~SP  
	  `S*S  S&S    S&S  S&S     S&S  S&S~YSSY    S&S     S&S     
	   l*S  S*S    S&S  S*S     S*S  S*S         S*b     S*b     
	  .S*P  S*S    S*S  S*S     S*S  S*S         S*S.    S*S.    
	sSS*S   S*S    S*S  S*S     S*S  S*S          SSSbs   SSSbs  
	YSS'    SSS    S*S  SSS     S*S  S*S           YSSP    YSSP  
	               SP           SP   SP                          
	               Y            Y    Y                           
                                                             


**AMC_AAA01**

	  sSSs   .S_SSSs     .S_SsS_S.    .S_sSSs    S.        sSSs  
	 d%%SP  .SS~SSSSS   .SS~S*S~SS.  .SS~YS%%b   SS.      d%%SP  
	d%S'    S%S   SSSS  S%S `Y' S%S  S%S   `S%b  S%S     d%S'    
	S%|     S%S    S%S  S%S     S%S  S%S    S%S  S%S     S%S     
	S&S     S%S SSSS%S  S%S     S%S  S%S    d*S  S&S     S&S     
	Y&Ss    S&S  SSS%S  S&S     S&S  S&S   .S*S  S&S     S&S_Ss  
	`S&&S   S&S    S&S  S&S     S&S  S&S_sdSSS   S&S     S&S~SP  
	  `S*S  S&S    S&S  S&S     S&S  S&S~YSSY    S&S     S&S     
	   l*S  S*S    S&S  S*S     S*S  S*S         S*b     S*b     
	  .S*P  S*S    S*S  S*S     S*S  S*S         S*S.    S*S.    
	sSS*S   S*S    S*S  S*S     S*S  S*S          SSSbs   SSSbs  
	YSS'    SSS    S*S  SSS     S*S  S*S           YSSP    YSSP  
	               SP           SP   SP                          
	               Y            Y    Y                           
                                                             


**amcneko**

	.sSSSSs.                                                                      
	SSSSSSSSSs. .sSSSSs.    .sSSSsSS SSsSSSSS .sSSSSs.    SSSSS       .sSSSSs.    
	S SSS SSSS' S SSSSSSSs. S SSS  SSS  SSSSS S SSSSSSSs. S SSS       S SSSSSSSs. 
	S  SS       S  SS SSSSS S  SS   S   SSSSS S  SS SSSSS S  SS       S  SS SSSS' 
	`SSSSsSSSa. S..SSsSSSSS S..SS       SSSSS S..SS SSSSS S..SS       S..SS       
	.sSSS SSSSS S:::S SSSSS S:::S       SSSSS S:::SsSSSSS S:::S       S:::SSSS    
	S;;;S SSSSS S;;;S SSSSS S;;;S       SSSSS S;;;S       S;;;S       S;;;S       
	S%%%S SSSSS S%%%S SSSSS S%%%S       SSSSS S%%%S       S%%%S SSSSS S%%%S SSSSS 
	SSSSSsSSSSS SSSSS SSSSS SSSSS       SSSSS SSSSS       SSSSSsSS;:' SSSSSsSS;:' 
                                                                              


**amcrazo2**

	   . .       . .       . .    .       . .       .         . .    
	.+'|=|`+. .+'|=|`+. .+'|=|`+.=|`+. .+'|=|`+. .+'|      .+'|=|`+. 
	|  | `+.| |  | |  | |  | `+ | `+ | |  | |  | |  |      |  | `+.| 
	|  | .    |  |=|  | |  |  | |  | | |  |=`++' |  |      |  |=|`.  
	`+.|=|`+. |  | |  | |  |  | |  | | |  |      |  |      |  | `.|  
	.    |  | |  | |  | |  |  | |  | | |  |      |  |    . |  |    . 
	|`+. |  | |  | |  | |  |  | |  | | |  |      |  | .+'| |  | .+'| 
	`+.|=|.+' `+.| |..| `+.|  |.|  |+' `+.|      `+.|=|.+' `+.|=|.+' 
                                                                 


**amcrazor**

	 ___   ___                                 __                     ___ 
	|   |=|_.'   .'|=|`.     .'|\/|`.     .'|=|  |    .'|        .'|=|_.' 
	`.  |      .'  | |  `. .'  |  |  `. .'  | |  |  .'  |      .'  |  ___ 
	  `.|=|`.  |   |=|   | |   |  |   | |   |=|.'   |   |      |   |=|_.' 
	 ___  |  `.|   | |   | |   |  |   | |   |       |   |  ___ |   |  ___ 
	 `._|=|___||___| |___| |___|  |___| |___|       |___|=|_.' |___|=|_.' 
                                                                      


**amcslash**

	.s5SSSs.                                                    
	      SS. .s5SSSs.  .s5ssSs.  .s5SSSs.  .s        .s5SSSs.  
	sS    `:;       SS.    SS SS.       SS.                 SS. 
	SS        sS    S%S sS SS S%S sS    S%S sS        sS    `:; 
	`:;;;;.   SSSs. S%S SS :; S%S SS .sS::' SS        SSSs.     
	      ;;. SS    S%S SS    S%S SS        SS        SS        
	      `:; SS    `:; SS    `:; SS        SS        SS        
	.,;   ;,. SS    ;,. SS    ;,. SS        SS    ;,. SS    ;,. 
	`:;;;;;:' :;    ;:' :;    ;:' `:        `:;;;;;:' `:;;;;;:' 
                                                            


**amcslder**

	                                                                             ____        
	            ..''''       .'.             .'. .`.       |`````````, |        |            
	         .''           .''```.         .'   `   `.     |'''''''''  |        |______      
	      ..'            .'       `.     .'           `.   |           |        |            
	....''             .'           `. .'               `. |           |_______ |___________ 
                                                                                         


**amcthin**

	.-..-. .-..-..-. .-.-. .-.-. .-..--.   .-.     .-..--. 
	| | ~  | | ~ | | | |~.-.~| | | | ~~.-. | |     | | ~~  
	 \|    | |.-.| | | |  ~  | | | |.--.~  | |     | | _   
	   |\  | | ~ | | | |     | | | | ~~    | |     | |`-'  
	 _ | | | |   | | | |     | | | |       | | __  | | __  
	`-'`-' `-'   `-' `-'     `-' `-'       `-'`--' `-'`--' 
                                                       


**amctubes**

	  sss. d s.   d s   sb d ss.  d      d sss   
	d      S  ~O  S  S S S S    b S      S       
	Y      S   `b S   S  S S    P S      S       
	  ss.  S sSSO S      S S sS'  S      S sSSs  
	     b S    O S      S S      S      S       
	     P S    O S      S S      S      S       
	` ss'  P    P P      P P      P sSSs P sSSss 
                                             


**amcun1**

	,'',,'',                                                   
	;  ;',,'                                                   
	;  ;     ,'',,''', ,'',,'',,'', ,'',,'', ,'',     ,'',,'', 
	',,','', ;  ;',  ; ;  ;', ;', ; ;  ;;  ; ;  ;     ;  ;',,' 
	    ;  ; ;  ;,'  ; ;  ; ; ; ; ; ;  ;',,' ;  ;     ;  ;',,' 
	,'',;  ; ;  ;',  ; ;  ; ; ; ; ; ;  ;     ;  ;,'', ;  ; ,,  
	',,'',,' ',,' ',,' ',,' ',' ',' ',,'     ',,'',,' ',,'',,' 
                                                           


**AMC_Untitled**
	
	,'',,'',                                                   
	;  ;',,'                                                   
	;  ;     ,'',,''', ,'',,'',,'', ,'',,'', ,'',     ,'',,'', 
	',,','', ;  ;',  ; ;  ;', ;', ; ;  ;;  ; ;  ;     ;  ;',,' 
	    ;  ; ;  ;,'  ; ;  ; ; ; ; ; ;  ;',,' ;  ;     ;  ;',,' 
	,'',;  ; ;  ;',  ; ;  ; ; ; ; ; ;  ;     ;  ;,'', ;  ; ,,  
	',,'',,' ',,' ',,' ',,' ',' ',' ',,'     ',,'',,' ',,'',,' 
                                                           


**ansi_new_roman**

	 ____,____,__, _,____,__,  ____, 
	(-(__(-/_|(-|\/|(-|__|-|  (-|_,  
	 ____)/  |,_| _|,_|   _|__,_|__, 
	(   (     (     (    (    (      


**ANSI_Shadow**

	███████╗ █████╗ ███╗   ███╗██████╗ ██╗     ███████╗
	██╔════╝██╔══██╗████╗ ████║██╔══██╗██║     ██╔════╝
	███████╗███████║██╔████╔██║██████╔╝██║     █████╗  
	╚════██║██╔══██║██║╚██╔╝██║██╔═══╝ ██║     ██╔══╝  
	███████║██║  ██║██║ ╚═╝ ██║██║     ███████╗███████╗
	╚══════╝╚═╝  ╚═╝╚═╝     ╚═╝╚═╝     ╚══════╝╚══════╝
                                                   


**aquaplan**

	  ####       # #  #    #####   
	 ##  ##          ##   #######  
	 ##           # ###   ######## 
	  ####         ####   ######## 
	     ##       ####    #######  
	 ##  ##      ### ##   ######## 
	  ####      ### ##    ##### #  
	           ##  ####    # ### # 


**arrows**

	  >=>>=>                                       >=>           
	>=>    >=>                                     >=>           
	 >=>          >=> >=>  >===>>=>>==>  >=> >=>   >=>   >==>    
	   >=>      >=>   >=>   >=>  >>  >=> >>   >=>  >=> >>   >=>  
	      >=>  >=>    >=>   >=>  >>  >=> >>   >=>  >=> >>===>>=> 
	>=>    >=>  >=>   >=>   >=>  >>  >=> >=> >=>   >=> >>        
	  >=>>=>     >==>>>==> >==>  >>  >=> >=>      >==>  >====>   
	                                     >=>                     


**asc_____**

	 #######                                          
	 #     #                                          
	 #        ####### #     # ####### #       ####### 
	 #######  #     # ##   ## #     # #       #       
	      ##  ####### # # # # ####### #       ####    
	 #    ##  #     # #  #  # #       #       #       
	 #######  #     # #     # #       ####### ####### 
                                                  


**ascii___**

	           ##   ##   ## ###### ####    ####### 
	          ####  ### ###  ##  ## ##      ##   # 
	  #####  ##  ## #######  ##  ## ##      ## #   
	 ##      ##  ## #######  #####  ##      ####   
	  #####  ###### ## # ##  ##     ##   #  ## #   
	      ## ##  ## ##   ##  ##     ##  ##  ##   # 
	 ######  ##  ## ##   ## ####   ####### ####### 
                                               


**ascii_new_roman**

	 ____,____,__, _,____,__,  ____, 
	(-(__(-/_|(-|\/|(-|__|-|  (-|_,  
	 ____)/  |,_| _|,_|   _|__,_|__, 
	(   (     (     (    (    (      


**assalt_m**

	 #######          ## ## ## ##     #     ##   
	 ##      ###     ##  ## ##  ##   ##     ###  
	 #######   ###   ##  ## ##  ##   ##      ##  
	      ## #   ## ##   ## ##   ## ###   ## #   
	 ###  ##  ## ## ##   ## ##   ## ### ## ##    
	 ###  ##    ##   ##  ## ##  ## ####     #### 
	 #######   ##    ##  ## ##  ## #####     ##  
	          ##      ## ## ## ## ## ###      ## 


**asslt__m**

	 #######          ## ## ## ##     #     ##   
	 ##      ###     ##  ## ##  ##   ##     ###  
	 #######   ###   ##  ## #   ##   ##      ##  
	      ## #   ## ##   ## ##   ## ###   ## #   
	 ###  ##  ## ## ##   ## ##   ## ### ## ##    
	 ###  ##    ##   ##  ## ##  ## ####     #### 
	 #######   ##    ##  ## ##  ## #####     ##  
	          ##      ## ## ## ## ## ###      ## 


**atc_____**

	#        #  ## # ###  # # # # ###  # # ## #          
	#   #    #  #### # #  #   # # ##   ###  # #          
	#   #### #  ## # # # # ## #    #     #  ###          
	#         #    #   # #    # #### # ###  # #          
	#####            # # ##    ##### #   ## # #          
	#   #                 #   # # ###  ###  # #          
	#                # #  #   ##     #     #             
	######## #  ##   ###  # # # ###  # # # ##            


**atc_gran**

	#         ##       # #  # ####            #   ##   # 
	#   #     ## ##  ###  ##  ##   # # # #  #   #  ##  # 
	#   ####  ## #     # #### # # #  #  #    ##          
	#         # #  # ## #              # # # ##          
	#####                  #  ####      ####  # ##  #    
	#   #            ###  ##  ### ####  # ##    ## #     
	#                  ##     # # #  #   ### ## #####    
	######## ####     ##      ########   ###### # #  # # 


**avatar**

	 ____  ____  _      ____  _     _____
	/ ___\/  _ \/ \__/|/  __\/ \   /  __/
	|    \| / \|| |\/|||  \/|| |   |  \  
	\___ || |-||| |  |||  __/| |_/\|  /_ 
	\____/\_/ \|\_/  \|\_/   \____/\____\
                                     


**a_zooloo**

	 ######     #### ###### ## ## ######  ### ##   
	######      #### ###### ## ## ######  ### ##   
	##          #### ###   ### ### ###### ### ###  
	#####   ######## ###   ### ### ###### ### ###  
	 #####  ######## ####  ### ### ##     #######  
	    ###          ####  ### ### ##     #######  
	 ######           ###  ####### ###### ######   
	######            ###  ####### ###### ######   


**B1FF**

	5/-\/\/\P|_3


**banner3-D**

	:'######:::::'###::::'##::::'##:'########::'##:::::::'########:
	'##... ##:::'## ##::: ###::'###: ##.... ##: ##::::::: ##.....::
	 ##:::..:::'##:. ##:: ####'####: ##:::: ##: ##::::::: ##:::::::
	. ######::'##:::. ##: ## ### ##: ########:: ##::::::: ######:::
	:..... ##: #########: ##. #: ##: ##.....::: ##::::::: ##...::::
	'##::: ##: ##.... ##: ##:.:: ##: ##:::::::: ##::::::: ##:::::::
	. ######:: ##:::: ##: ##:::: ##: ##:::::::: ########: ########:
	:......:::..:::::..::..:::::..::..:::::::::........::........::
	

**banner3**

	 ######     ###    ##     ## ########  ##       ######## 
	##    ##   ## ##   ###   ### ##     ## ##       ##       
	##        ##   ##  #### #### ##     ## ##       ##       
	 ######  ##     ## ## ### ## ########  ##       ######   
	      ## ######### ##     ## ##        ##       ##       
	##    ## ##     ## ##     ## ##        ##       ##       
	 ######  ##     ## ##     ## ##        ######## ######## 


**Banner3**

	 ######     ###    ##     ## ########  ##       ######## 
	##    ##   ## ##   ###   ### ##     ## ##       ##       
	##        ##   ##  #### #### ##     ## ##       ##       
	 ######  ##     ## ## ### ## ########  ##       ######   
	      ## ######### ##     ## ##        ##       ##       
	##    ## ##     ## ##     ## ##        ##       ##       
	 ######  ##     ## ##     ## ##        ######## ######## 


**banner4**

	..######.....###....##.....##.########..##.......########
	.##....##...##.##...###...###.##.....##.##.......##......
	.##........##...##..####.####.##.....##.##.......##......
	..######..##.....##.##.###.##.########..##.......######..
	.......##.#########.##.....##.##........##.......##......
	.##....##.##.....##.##.....##.##........##.......##......
	..######..##.....##.##.....##.##........########.########


**banner**

	 #####                                     
	#     #   ##   #    # #####  #      ###### 
	#        #  #  ##  ## #    # #      #      
	 #####  #    # # ## # #    # #      #####  
	      # ###### #    # #####  #      #      
	#     # #    # #    # #      #      #      
	 #####  #    # #    # #      ###### ###### 
                                           


**barbwire**

	  ><< <<                                  ><<          
	><<    ><<                                ><<          
	 ><<         ><<    ><<< ><< ><< >< ><<   ><<   ><<    
	   ><<     ><<  ><<  ><<  ><  ><<><  ><<  ><< ><   ><< 
	      ><< ><<   ><<  ><<  ><  ><<><   ><< ><<><<<<< ><<
	><<    ><<><<   ><<  ><<  ><  ><<><< ><<  ><<><        
	  ><< <<    ><< ><<<><<<  ><  ><<><<     ><<<  ><<<<   
	                                 ><<                   


**basic**

	.d8888.  .d8b.  .88b  d88. d8888b. db      d88888b 
	88'  YP d8' `8b 88'YbdP`88 88  `8D 88      88'     
	`8bo.   88ooo88 88  88  88 88oodD' 88      88ooooo 
	  `Y8b. 88~~~88 88  88  88 88~~~   88      88~~~~~ 
	db   8D 88   88 88  88  88 88      88booo. 88.     
	`8888Y' YP   YP YP  YP  YP 88      Y88888P Y88888P 
  

**battlesh**

	 ###### ##### ##               # ###### ####### 
	####### ##### ##               # # # #  # ##### 
	##   ## ##### ##               # # ###  # ###   
	 ###    ###                      #  # # # # #   
	   ###  ##### ##                 #  # # # # ### 
	##   ## ##### ##   ###### ###### # #  # # ##### 
	####### ##### ## ## # # #  # # ##  #### # ###   
	######  ##### ## ######## ######## #### #####   


**baz__bil**

	 ####  ########       #  ########         ######## 
	##   # ### # ##       #  ### ####         ######## 
	##     # # # #      # ## ### ####         ######## 
	 ####  # #  ##    # #### ########         ######## 
	    ## #  ## #    # #### ########     # # ######   
	    ## # # # #  # ###### #######    # ####  ####   
	#   ## ### # ## # ###### ######## # ##### ######## 
	 ####  ######## # ###### #######  # ##### ####     


**bear**

	   _     _      _     _      _     _      _     _      _     _      _     _   
	  (c).-.(c)    (c).-.(c)    (c).-.(c)    (c).-.(c)    (c).-.(c)    (c).-.(c)  
	   / ._. \      / ._. \      / ._. \      / ._. \      / ._. \      / ._. \   
	 __\( Y )/__  __\( Y )/__  __\( Y )/__  __\( Y )/__  __\( Y )/__  __\( Y )/__ 
	(_.-/'-'\-._)(_.-/'-'\-._)(_.-/'-'\-._)(_.-/'-'\-._)(_.-/'-'\-._)(_.-/'-'\-._)
	   || S ||      || A ||      || M ||      || P ||      || L ||      || E ||   
	 _.' `-' '._  _.' `-' '._  _.' `-' '._  _.' `-' '._  _.' `-' '._  _.' `-' '._ 
	(.-./`-`\.-.)(.-./`-'\.-.)(.-./`-'\.-.)(.-./`-'\.-.)(.-./`-'\.-.)(.-./`-'\.-.)
	 `-'     `-'  `-'     `-'  `-'     `-'  `-'     `-'  `-'     `-'  `-'     `-' 


**beer_pub**

	 #####  ######## # #  ##  # # #  # # # #  # ######## 
	###  ## ### # #  # #  ##  # # #  # # # #  # ### #  # 
	###     ### # #  # #  ##  # # #  # # # #  # ### #  # 
	 #####  ### ###  # #  ##  # # #  # # # #  # ### #  # 
	     ## ###  ##  ######## ######## ######## ### #  # 
	###  ## ### # #  ####     ##    ##     #### ### #  # 
	 #####  ### # #  ####     ##    ##     #### ## # # # 
	        ### # #  ######## ######## ########          


**bell**

	   _____                          .         
	  (        ___  , _ , _   \,___,  |     ___ 
	   `--.   /   ` |' `|' `. |    \  |   .'   `
	      |  |    | |   |   | |    |  |   |----'
	 \___.'  `.__/| /   '   / |`---' /\__ `.___,
	                          \                 


**benjamin**

	_\"/-\|\/||'|_[-


**bigchief**

	_________________________________________
	      __                                 
	    /    )                        /      
	----\--------__---_--_------__---/----__-
	     \     /   ) / /  )   /   ) /   /___)
	_(____/___(___(_/_/__/___/___/_/___(___ _
	                        /                
	                       /                 


**bigfig**

	 __       _       
	(_  _ __ |_) |  _ 
	__)(_|||||   | (/_
	

**big**

	  _____                       _      
	 / ____|                     | |     
	| (___   __ _ _ __ ___  _ __ | | ___ 
	 \___ \ / _` | '_ ` _ \| '_ \| |/ _ \
	 ____) | (_| | | | | | | |_) | |  __/
	|_____/ \__,_|_| |_| |_| .__/|_|\___|
	                       | |           
	                       |_|           


**Big_Money-ne**

	  /$$$$$$                                    /$$          
	 /$$__  $$                                  | $$          
	| $$  \__/  /$$$$$$  /$$$$$$/$$$$   /$$$$$$ | $$  /$$$$$$ 
	|  $$$$$$  |____  $$| $$_  $$_  $$ /$$__  $$| $$ /$$__  $$
	 \____  $$  /$$$$$$$| $$ \ $$ \ $$| $$  \ $$| $$| $$$$$$$$
	 /$$  \ $$ /$$__  $$| $$ | $$ | $$| $$  | $$| $$| $$_____/
	|  $$$$$$/|  $$$$$$$| $$ | $$ | $$| $$$$$$$/| $$|  $$$$$$$
	 \______/  \_______/|__/ |__/ |__/| $$____/ |__/ \_______/
	                                  | $$                    
	                                  | $$                    
	                                  |__/                    


**Big_Money-nw**

	 $$$$$$\                                    $$\           
	$$  __$$\                                   $$ |          
	$$ /  \__| $$$$$$\  $$$$$$\$$$$\   $$$$$$\  $$ | $$$$$$\  
	\$$$$$$\   \____$$\ $$  _$$  _$$\ $$  __$$\ $$ |$$  __$$\ 
	 \____$$\  $$$$$$$ |$$ / $$ / $$ |$$ /  $$ |$$ |$$$$$$$$ |
	$$\   $$ |$$  __$$ |$$ | $$ | $$ |$$ |  $$ |$$ |$$   ____|
	\$$$$$$  |\$$$$$$$ |$$ | $$ | $$ |$$$$$$$  |$$ |\$$$$$$$\ 
	 \______/  \_______|\__| \__| \__|$$  ____/ \__| \_______|
	                                  $$ |                    
	                                  $$ |                    
	                                  \__|                    


**Big_Money-se**

	  ______                                     __           
	 /      \                                   |  \          
	|  $$$$$$\  ______   ______ ____    ______  | $$  ______  
	| $$___\$$ |      \ |      \    \  /      \ | $$ /      \ 
	 \$$    \   \$$$$$$\| $$$$$$\$$$$\|  $$$$$$\| $$|  $$$$$$\
	 _\$$$$$$\ /      $$| $$ | $$ | $$| $$  | $$| $$| $$    $$
	|  \__| $$|  $$$$$$$| $$ | $$ | $$| $$__/ $$| $$| $$$$$$$$
	 \$$    $$ \$$    $$| $$ | $$ | $$| $$    $$| $$ \$$     \
	  \$$$$$$   \$$$$$$$ \$$  \$$  \$$| $$$$$$$  \$$  \$$$$$$$
	                                  | $$                    
	                                  | $$                    
	                                   \$$                    


**Big_Money-sw**

	  ______                                     __           
	 /      \                                   /  |          
	/$$$$$$  |  ______   _____  ____    ______  $$ |  ______  
	$$ \__$$/  /      \ /     \/    \  /      \ $$ | /      \ 
	$$      \  $$$$$$  |$$$$$$ $$$$  |/$$$$$$  |$$ |/$$$$$$  |
	 $$$$$$  | /    $$ |$$ | $$ | $$ |$$ |  $$ |$$ |$$    $$ |
	/  \__$$ |/$$$$$$$ |$$ | $$ | $$ |$$ |__$$ |$$ |$$$$$$$$/ 
	$$    $$/ $$    $$ |$$ | $$ | $$ |$$    $$/ $$ |$$       |
	 $$$$$$/   $$$$$$$/ $$/  $$/  $$/ $$$$$$$/  $$/  $$$$$$$/ 
	                                  $$ |                    
	                                  $$ |                    
	                                  $$/                     


**binary**

	01010011 01100001 01101101 01110000 01101100 01100101 


**block**

	                                                            
	  _|_|_|                                      _|            
	_|          _|_|_|  _|_|_|  _|_|    _|_|_|    _|    _|_|    
	  _|_|    _|    _|  _|    _|    _|  _|    _|  _|  _|_|_|_|  
	      _|  _|    _|  _|    _|    _|  _|    _|  _|  _|        
	_|_|_|      _|_|_|  _|    _|    _|  _|_|_|    _|    _|_|_|  
	                                    _|                      
	                                    _|                      


**blocks**

	 .----------------.  .----------------.  .----------------.  .----------------.  .----------------.  .----------------. 
	| .--------------. || .--------------. || .--------------. || .--------------. || .--------------. || .--------------. |
	| |    _______   | || |      __      | || | ____    ____ | || |   ______     | || |   _____      | || |  _________   | |
	| |   /  ___  |  | || |     /  \     | || ||_   \  /   _|| || |  |_   __ \   | || |  |_   _|     | || | |_   ___  |  | |
	| |  |  (__ \_|  | || |    / /\ \    | || |  |   \/   |  | || |    | |__) |  | || |    | |       | || |   | |_  \_|  | |
	| |   '.___`-.   | || |   / ____ \   | || |  | |\  /| |  | || |    |  ___/   | || |    | |   _   | || |   |  _|  _   | |
	| |  |`\____) |  | || | _/ /    \ \_ | || | _| |_\/_| |_ | || |   _| |_      | || |   _| |__/ |  | || |  _| |___/ |  | |
	| |  |_______.'  | || ||____|  |____|| || ||_____||_____|| || |  |_____|     | || |  |________|  | || | |_________|  | |
	| |              | || |              | || |              | || |              | || |              | || |              | |
	| '--------------' || '--------------' || '--------------' || '--------------' || '--------------' || '--------------' |
	 '----------------'  '----------------'  '----------------'  '----------------'  '----------------'  '----------------' 


**Bloody**
	
	  ██████  ▄▄▄       ███▄ ▄███▓ ██▓███   ██▓    ▓█████ 
	▒██    ▒ ▒████▄    ▓██▒▀█▀ ██▒▓██░  ██▒▓██▒    ▓█   ▀ 
	░ ▓██▄   ▒██  ▀█▄  ▓██    ▓██░▓██░ ██▓▒▒██░    ▒███   
	  ▒   ██▒░██▄▄▄▄██ ▒██    ▒██ ▒██▄█▓▒ ▒▒██░    ▒▓█  ▄ 
	▒██████▒▒ ▓█   ▓██▒▒██▒   ░██▒▒██▒ ░  ░░██████▒░▒████▒
	▒ ▒▓▒ ▒ ░ ▒▒   ▓▒█░░ ▒░   ░  ░▒▓▒░ ░  ░░ ▒░▓  ░░░ ▒░ ░
	░ ░▒  ░ ░  ▒   ▒▒ ░░  ░      ░░▒ ░     ░ ░ ▒  ░ ░ ░  ░
	░  ░  ░    ░   ▒   ░      ░   ░░         ░ ░      ░   
	      ░        ░  ░       ░                ░  ░   ░  ░
                                                      


**b_m__200**

	#######             # # #                  
	     ## # # # #   # #           #          
	     ## # # #               #   #          
	#######           # ### ##                 
	    ### # ### ##  # #                      
	    ###  ## # #                            
	#######           # # # #                  
	            #  #  #  ##                    


**bolger**

	,d88~~\                                   888           
	8888      /~~~8e  888-~88e-~88e 888-~88e  888  e88~~8e  
	`Y88b         88b 888  888  888 888  888b 888 d888  88b 
	 `Y88b,  e88~-888 888  888  888 888  8888 888 8888__888 
	   8888 C888  888 888  888  888 888  888P 888 Y888    , 
	\__88P'  "88_-888 888  888  888 888-_88"  888  "88___/  
	                                888                     


**braced**

	 .----.  .--.  .-.  .-..-.-. .-.   .----. 
	{ {__-` / {} \ }  \/  {| } }}} |   } |__} 
	.-._} }/  /\  \| {  } || |-' } '--.} '__} 
	`----' `-'  `-'`-'  `-'`-'   `----'`----' 
                                          


**bright**

	..####....####...##...##..#####...##......######.
	.##......##..##..###.###..##..##..##......##.....
	..####...######..##.#.##..#####...##......####...
	.....##..##..##..##...##..##......##......##.....
	..####...##..##..##...##..##......######..######.
	.................................................


**briteb**

                                   
                                   
	 ###                      ##       
	#  #                       #       
	###  ###  ########  ####   #   ##  
	  ## ###   #  #  #   #  #  #  #### 
	#  # # #   #  #  #   #  #  #  #    
	###  ## # #########  ###  ###  ### 
	                     #             
	                    ###            


**britebi**

                                   
                                   
	  ###                      ##      
	 #  #                       #      
	 ##     ### ## # ##  #####  #  ### 
	  ##   #  #  #### #   ## # #  #  # 
	#  #  #  #  #  #  #   # ## #  #### 
	####  ##### #  # ### ####  ## ###  
	                     #             
	                     #             


**brite**

                               
                               
	###                    ##      
	# #                     #      
	##  ###  ######  #####  #   ## 
	 ##  ##   # # #   #  #  #  ### 
	# # # #   # # #   #  #  #  #   
	### ## # #######  ###  ###  ## 
	                  #            
	                 ###           
                               


**britei**

                                
                                
	 ###                    ##      
	 # #                     #      
	 #    ### #### ## #####  #  ##  
	  #  #  #  #### #  ## #  # # #  
	#  # # ## ## #  #  #  # #  #### 
	###  #### #  # ##  ###  ## ###  
	                  #             
	                  #             
                                


**broadway**

                                              .         .                                                        
	   d888888o.           .8.                   ,8.       ,8.          8 888888888o   8 8888         8 8888888888   
	 .`8888:' `88.        .888.                 ,888.     ,888.         8 8888    `88. 8 8888         8 8888         
	 8.`8888.   Y8       :88888.               .`8888.   .`8888.        8 8888     `88 8 8888         8 8888         
	 `8.`8888.          . `88888.             ,8.`8888. ,8.`8888.       8 8888     ,88 8 8888         8 8888         
	  `8.`8888.        .8. `88888.           ,8'8.`8888,8^8.`8888.      8 8888.   ,88' 8 8888         8 888888888888 
	   `8.`8888.      .8`8. `88888.         ,8' `8.`8888' `8.`8888.     8 888888888P'  8 8888         8 8888         
	    `8.`8888.    .8' `8. `88888.       ,8'   `8.`88'   `8.`8888.    8 8888         8 8888         8 8888         
	8b   `8.`8888.  .8'   `8. `88888.     ,8'     `8.`'     `8.`8888.   8 8888         8 8888         8 8888         
	`8b.  ;8.`8888 .888888888. `88888.   ,8'       `8        `8.`8888.  8 8888         8 8888         8 8888         
	 `Y8888P ,88P'.8'       `8. `88888. ,8'         `         `8.`8888. 8 8888         8 888888888888 8 888888888888 


**broadway_kb**

	 __    __    _      ___   _     ____ 
	( (`  / /\  | |\/| | |_) | |   | |_  
	_)_) /_/--\ |_|  | |_|   |_|__ |_|__ 


**bubble_b**
	
	  ####  ####       ##     ######   ##   ####     
	 ##  ## ## ###   ######   ###### ###### ####     
	 ###    ## # ### ## ###     #### ###### ####     
	  ####  #### ### ## ###     #### ###### ####     
	    ### ######## ## ###       ## ###### ##       
	 ##  ##   ###### ## ###       ## ###### ##       
	  ####      #### ######          ######          
	            #### ## ###          ###### ##       


**bubble__**

	           #    ### ### ######  ###     ####### 
	  ####    ###   ####### ### ### ###     ####    
	 ### ##   ###   ####### ##   ## ###     ###     
	  ###    #####  #  #  # ### ### ###     #####   
	   ###   ## ##  #  #  # ######  ###     ###     
	 ## ### ### ### #  #  # ##      ######  ####    
	  ####  ### ### #  #  # ##      ####### ####### 
                                                


**bubble**

	  _   _   _   _   _   _  
	 / \ / \ / \ / \ / \ / \ 
	( S | a | m | p | l | e )
	 \_/ \_/ \_/ \_/ \_/ \_/ 


**bulbhead**

	 ___    __    __  __  ____  __    ____ 
	/ __)  /__\  (  \/  )(  _ \(  )  ( ___)
	\__ \ /(__)\  )    (  )___/ )(__  )__) 
	(___/(__)(__)(_/\/\_)(__)  (____)(____)
	

**c1______**

	 #####     #  ##  ######## ##                
	##   ##   ### ### ######## ##       ######## 
	##       ##### ###      ## ##       ######## 
	 #####  ####### ###     ## ##                
	     ## #######  ###    ## ##                
	##   ##   ###     ###   ## ##                
	 #####   #####     ###  ## ########          
	                    ##  ## ########          


**c2______**

                     
	 #####               
	#######              
	                     
	######               
	     ##              
	#######              
	 #####               


**calgphy2**

                                                                      
	      #######                                        ###              
	    /       ###                                       ###             
	   /         ##                                        ##             
	   ##        #                                         ##             
	    ###                                                ##             
	   ## ###           /###   ### /### /###       /###    ##      /##    
	    ### ###        / ###  / ##/ ###/ /##  /   / ###  / ##     / ###   
	      ### ###     /   ###/   ##  ###/ ###/   /   ###/  ##    /   ###  
	        ### /##  ##    ##    ##   ##   ##   ##    ##   ##   ##    ### 
	          #/ /## ##    ##    ##   ##   ##   ##    ##   ##   ########  
	           #/ ## ##    ##    ##   ##   ##   ##    ##   ##   #######   
	            # /  ##    ##    ##   ##   ##   ##    ##   ##   ##        
	  /##        /   ##    /#    ##   ##   ##   ##    ##   ##   ####    / 
	 /  ########/     ####/ ##   ###  ###  ###  #######    ### / ######/  
	/     #####        ###   ##   ###  ###  ### ######      ##/   #####   
	|                                           ##                        
	 \)                                         ##                        
	                                            ##                        
	                                             ##                       


**caligraphy**

                                                                          
	      *******                                           ***               
	    *       ***                                          ***              
	   *         **                                           **              
	   **        *                                            **              
	    ***                                         ****      **              
	   ** ***           ****    *** **** ****      * ***  *   **       ***    
	    *** ***        * ***  *  *** **** ***  *  *   ****    **      * ***   
	      *** ***     *   ****    **  **** ****  **    **     **     *   ***  
	        *** ***  **    **     **   **   **   **    **     **    **    *** 
	          ** *** **    **     **   **   **   **    **     **    ********  
	           ** ** **    **     **   **   **   **    **     **    *******   
	            * *  **    **     **   **   **   **    **     **    **        
	  ***        *   **    **     **   **   **   *******      **    ****    * 
	 *  *********     ***** **    ***  ***  ***  ******       *** *  *******  
	*     *****        ***   **    ***  ***  *** **            ***    *****   
	*                                            **                           
	 **                                          **                           
	                                              **                          
                                                                          
                                                                          


**Calvin_S**

	╔═╗┌─┐┌┬┐┌─┐┬  ┌─┐
	╚═╗├─┤│││├─┘│  ├┤ 
	╚═╝┴ ┴┴ ┴┴  ┴─┘└─┘


**cards**

	.------..------..------..------..------..------.
	|S.--. ||A.--. ||M.--. ||P.--. ||L.--. ||E.--. |
	| :/\: || (\/) || (\/) || :/\: || :/\: || (\/) |
	| :\/: || :\/: || :\/: || (__) || (__) || :\/: |
	| '--'S|| '--'A|| '--'M|| '--'P|| '--'L|| '--'E|
	`------'`------'`------'`------'`------'`------'


**c_ascii_**

	           ##   ##   ## ###### ####    ####### 
	          ####  ### ###  ##  ## ##      ##   # 
	  #####  ##  ## #######  ##  ## ##      ## #   
	 ##      ##  ## #######  #####  ##      ####   
	  #####  ###### ## # ##  ##     ##   #  ## #   
	      ## ##  ## ##   ##  ##     ##  ##  ##   # 
	 ######  ##  ## ##   ## ####   ####### ####### 
                                               


**catwalk**

	  _// //                                  _//          
	_//    _//                                _//          
	 _//         _//    _/// _// _// _/ _//   _//   _//    
	   _//     _//  _//  _//  _/  _//_/  _//  _// _/   _// 
	      _// _//   _//  _//  _/  _//_/   _// _//_///// _//
	_//    _//_//   _//  _//  _/  _//_// _//  _//_/        
	  _// //    _// _///_///  _/  _//_//     _///  _////   
	                                 _//                   


**caus_in_**
	
	#######              #### ########             
	#######  ##                                    
	### # # ####                          #######  
	#######  ##                                ##  
	# # ###    ###                             ##  
	####### #  ###                        #### ##  
	####### #  ###                          ## ##  
	# # # #    #####                   #### ## ##  


**c_consen**

	        ###    #  ##  ###    ###  ####   
	        ###    #  ### ###    #  # #### # 
	  #####  #  #  ###    ###    #  # # # ## 
	 ##     ####   ###    ###    ###  ###    
	  ####  #### # ###    # ##   ###  ###    
	     ## #####  ###    # ## # ###  ###    
	 #####    # ## ###    ###    ###   ### # 
	        ###    # #    ###    #      #### 


**char1___**

	           #  ##  ######## ##                
	  ####    ### ### ######## ##       ######## 
	 ##      ##### ###      ## ##       ######## 
	  ####  ####### ###     ## ##                
	     ## #######  ###    ## ##                
	     ##   ###     ###   ## ##                
	  ####   #####     ###  ## ########          
	                    ##  ## ########          


**char2___**

	#######     ##  ##   ## ######  ##       ######  
	##   ##   ##### ### ### ####### ##      #######  
	##        ## ## #######      ## ##      ##       
	#######  ##  ## ####### ######  ##      #######  
	    ###  ###### ## # ## ##      ##      ##       
	##  ### ##   ## ##   ## ##      ####### #######  
	####### ##   ## ##   ## ##       ######  ######  
                                                 


**char3___**

	  #####    ##   #    # #####  #      ######  
	 ##   ##  #  #  ##  ## #    # #      #       
	 ##      #    # # ## # #    # #      #       
	  #####  ###### # ## # #####  #      ####    
	      ## #    # #    # #      #      #       
	 ##   ## #    # #    # #      #      #       
	  #####  #    # #    # #      ###### ######  
                                             


**char4___**

	   ###   ##    #  #####              
	  ##### #####  #  ##  ##             
	 ##     #####                        
	  ####   ##    #   ## #  #           
	     ## #      #  #   ##             
	##   ## # ##                         
	 #####   ##    #   ##    #           
	        #      #  #   ##             


**charact1**

                                            
	        ###### ##  ## ###### ###    ######  
	 ###### ###### ###### ##  ## ###    ######  
	 ##     ##  ## ###### ##  ## ###    ##      
	 ###### ###### ##  ## ###### ###    ####    
	     ## ##  ## ##  ## ###    ###    ##      
	 ###### ##  ## ##  ## ###    ###### ######  
                                            


**charact2**

                                           
	         ####  ##  ## #####  ##     #####  
	        ##  ## ###### ##  ## ##    ##      
	  ##### ##  ## ###### ##  ## ##    ####    
	 ####   ###### ##  ## #####  ##    ##      
	   #### ##  ## ##  ## ##     ##    ##      
	 #####  ##  ## ##  ## ##     ###### #####  
                                           


**charact3**

                                              
	         ###### ##  ##  #####   ###    ###### 
	        ###  ## ######  ##  ## ###    ###  ## 
	  ##### ##  ## ####### ##  ### ##     ####    
	  ##   ####### ##  ##  ###### ###     ##      
	    ## ##  ## ##  ##  ##      ##  ## ###  ##  
	###### ##  ## ##  ##  ##     ####### #######  
                                              


**charact4**

                                            
	         ####  ##  ## ######  ##    ######  
	         ####  ###### ##  ##  ##    ##      
	 ###### ##  ## ###### ##  ##  ##    ####    
	 ###    ###### ## ### ###### ###    ###     
	   #### ##  ## ## ### ###    ###    ###     
	 ###### ##  ## ## ### ###    ###### ######  
	                                            


**charact5**

                                              
	        #####  ##  ## ###### #####   #######  
	        #####  ######  ###### ###     ###     
	  ##### ## ##  ######  ##  ## ###     #####   
	 ####   #####  ######  #####  ###     ###     
	   #### ## ##  ##  ##  ###    ### ##  ###     
	 ##### ### ### ##  ## #####  ####### #######  
                                              


**charact6**

                                            
	          ##   ##  ## #####  ##     ######  
	  #####  ####  ###### ##  ## ##     ##      
	 ##     ##  ## ###### ##  ## ##     ####    
	  ####  ###### ##  ## #####  ##     ##      
	     ## ##  ## ##  ## ##     ##     ##      
	 #####  ##  ## ##  ## ##     ###### ######  
                                            


**characte**

                                            
	        ###### ##  ## ###### ##     ######  
	        ##  ## ###### ##  ## ##     ##      
	 ###### ##  ## ###### ##  ## ##     ####    
	 ###    ###### ##  ## ###### ##     ##      
	   #### ##  ## ##  ## ##     ##     ##      
	 ###### ##  ## ##  ## ##     ###### ######  
                                            


**charset_**

	  ###### ###### ##   ## #####  ##     ######  
	 ####    ###### ### ### ###### ##     ######  
	 ####    ##  ## ####### ##  ## ##     ##      
	  ###### ###### ####### ###### ##     ####    
	         ###### ## # ## #####  ##     ##      
	 ####    ##  ## ##   ## ##     ###### ######  
	  ###### ##  ## ##   ## ##     ###### ######  
                                              


**chartr**

                          
                          
	 ###                #     
	#  #                #     
	##    #  ##### ###  #  #  
	  ##  ## # # # #  # # ### 
	#  # # # # # # #  # # #   
	###   ## # # # ###  #  ## 
	               #          
	               ##         


**chartri**

                               
                               
	  ##                    #      
	 # #                    #      
	 ##    ## ######   #### #   #  
	   #  # # ## # #    # # #  ### 
	#  # # #  #  # #   # ## # ##   
	 ##   # # # #  ##  ##   #  ### 
	                   #           
	                  ##           


**Chiseled**

	   ,-,--.   ,---.             ___      _ __                 ,----.  
	 ,-.'-  _\.--.'  \     .-._ .'=.'\  .-`.' ,`.   _.-.     ,-.--` , \ 
	/==/_ ,_.'\==\-/\ \   /==/ \|==|  |/==/, -   \.-,.'|    |==|-  _.-` 
	\==\  \   /==/-|_\ |  |==|,|  / - |==| _ .=. |==|, |    |==|   `.-. 
	 \==\ -\  \==\,   - \ |==|  \/  , |==| , '=',|==|- |   /==/_ ,    / 
	 _\==\ ,\ /==/ -   ,| |==|- ,   _ |==|-  '..'|==|, |   |==|    .-'  
	/==/\/ _ /==/-  /\ - \|==| _ /\   |==|,  |   |==|- `-._|==|_  ,`-._ 
	\==\ - , |==\ _.\=\.-'/==/  / / , /==/ - |   /==/ - , ,/==/ ,     / 
	 `--`---' `--`        `--`./  `--``--`---'   `--`-----'`--`-----``  


**chunky**

	 _______                        __        
	|     __|.---.-.--------.-----.|  |.-----.
	|__     ||  _  |        |  _  ||  ||  -__|
	|_______||___._|__|__|__|   __||__||_____|
	                        |__|              


**clb6x10**

	                             ###          
	  ###                         ##          
	 ## ##                        ##          
	 ##      ####  ## #   ####    ##     ###  
	  ###   ## ##  #####  ## ##   ##    ## ## 
	    ##  ## ##  #####  ## ##   ##    ##### 
	 ## ##  ## ##  #####  ## ##   ##    ##    
	  ###    ## #  ## ##  ####   ####    ###  
	                      ##                  
	                      ##                  


**clb8x10**

	                                      ###             
	  #####                                ##             
	 ##   ##                               ##             
	 ##        ######  ### ##   ######     ##      #####  
	  #####   ##   ##  ## # ##  ##   ##    ##     ##   ## 
	      ##  ##   ##  ## # ##  ##   ##    ##     ####### 
	 ##   ##  ##  ###  ## # ##  ##   ##    ##     ##      
	  #####    ### ##  ##   ##  ######    ####     #####  
	                            ##                        
	                            ##                        


**clb8x8**

	  #####                               ###             
	 ##   ##                               ##             
	 ##        ######  ### ##   ######     ##      #####  
	  #####   ##   ##  ## # ##  ##   ##    ##     ##   ## 
	      ##  ##   ##  ## # ##  ##   ##    ##     ####### 
	 ##   ##  ##  ###  ## # ##  ##   ##    ##     ##      
	  #####    ### ##  ##   ##  ######    ####     #####  
	                            ##                        


**cli8x8**

	   ####                                ###            
	  ##  ##                                ##            
	  ##        #####   ## ##     ####     ##       ####  
	   ##     ##   ##  #######   ##  ##    ##     ##   ## 
	    ##   ##    ##  ## # ##  ##   ##   ##     ######## 
	##  ##   ##  ###  ##   ##   ##  ##    ##     ##       
	 ####     ### ##  ##   ##  #####     ####     ####    
	                           ##                         


**clr4x6**

	 ##                  #        
	#     #   ###  ##    #    ##  
	 #   # #  ###  # #   #   ###  
	  #  # #  ###  ##    #   #    
	##    ##  # #  #     #    ##  
	               #              


**clr5x10**

                                    
	  ##                     ##         
	 #  #                     #         
	 #      ### ## #   ###    #     ##  
	  ##   #  # # # #  #  #   #    #  # 
	    #  #  # # # #  #  #   #    #### 
	 #  #  # ## # # #  #  #   #    #    
	  ##    # # #   #  ###   ###    ##  
	                   #                
	                   #                


**clr5x6**

	  ###                    ##         
	 #      ###  #  #  ###    #     ##  
	  ##   #  #  ####  #  #   #    #### 
	    #  # ##  #  #  #  #   #    #    
	 ###    # #  #  #  ###   ###    ##  
	                   #                


**clr5x8**

	  ##                     ##         
	 #  #                     #         
	 #      ### ## #   ###    #     ##  
	  ##   #  # # # #  #  #   #    #  # 
	    #  #  # # # #  #  #   #    #### 
	 #  #  # ## # # #  #  #   #    #    
	  ##    # # #   #  ###   ###    ##  
	                   #                


**clr6x10**

	                              ##          
	  ###                          #          
	 #   #                         #          
	 #       ####  ## #   ####     #     ###  
	  ###   #   #  # # #  #   #    #    #   # 
	     #  #   #  # # #  #   #    #    ##### 
	 #   #  #  ##  # # #  #   #    #    #     
	  ###    ## #  #   #  ####    ###    ###  
	                      #                   
	                      #                   


**clr6x6**

	  ####                        ##          
	 #       ####  ## #   ####     #     ###  
	  ###   #   #  # # #  #   #    #    ##### 
	     #  #  ##  # # #  #   #    #    #     
	 ####    ## #  #   #  ####    ###    ###  
	                      #                   


**clr6x8**

	  ###                         ##          
	 #   #                         #          
	 #       ####  ## #   ####     #     ###  
	  ###   #   #  # # #  #   #    #    #   # 
	     #  #   #  # # #  #   #    #    ##### 
	 #   #  #  ##  # # #  #   #    #    #     
	  ###    ## #  #   #  ####    ###    ###  
	                      #                   


**clr7x10**

	                                  ##            
	  ####                             #            
	 #    #                            #            
	 #        #####  ## #    #####     #      ####  
	  ####   #    #  # # #   #    #    #     #    # 
	      #  #    #  # # #   #    #    #     ###### 
	 #    #  #   ##  # # #   #    #    #     #      
	  ####    ### #  #   #   #####    ###     ####  
	                         #                      
	                         #                      


**clr7x8**

	  ####                            ##            
	 #    #                            #            
	 #        #####  ## #    #####     #      ####  
	  ####   #    #  # # #   #    #    #     #    # 
	      #  #    #  # # #   #    #    #     ###### 
	 #    #  #   ##  # # #   #    #    #     #      
	  ####    ### #  #   #   #####    ###     ####  
	                         #                      


**clr8x10**

	                                       ##             
	  #####                                 #             
	 #     #                                #             
	 #         ######  ### ##   ######      #      #####  
	  #####   #     #  #  #  #  #     #     #     #     # 
	       #  #     #  #  #  #  #     #     #     ####### 
	 #     #  #    ##  #  #  #  #     #     #     #       
	  #####    #### #  #     #  ######     ###     #####  
	                            #                         
	                            #                         


**clr8x8**

	  #####                                ##             
	 #     #                                #             
	 #         ######  ### ##   ######      #      #####  
	  #####   #     #  #  #  #  #     #     #     #     # 
	       #  #     #  #  #  #  #     #     #     ####### 
	 #     #  #    ##  #  #  #  #     #     #     #       
	  #####    #### #  #     #  ######     ###     #####  
	                            #                         


**coil_cop**

	 #####               
	##   ##              
	##                   
	 #####               
	     ##              
	##   ##              
	 #####               
                     


**coinstak**

	  O)) O)                                  O))          
	O))    O))                                O))          
	 O))         O))    O))) O)) O)) O) O))   O))   O))    
	   O))     O))  O))  O))  O)  O))O)  O))  O)) O)   O)) 
	      O)) O))   O))  O))  O)  O))O)   O)) O))O))))) O))
	O))    O))O))   O))  O))  O)  O))O)) O))  O))O)        
	  O)) O)    O)) O)))O)))  O)  O))O))     O)))  O))))   
	                                 O))                   


**cola**

	          .-.                        .;     
	  .;;;.`-'                          .;'     
	 ;;  (_).-.    . ,';.,';. `..:.    .;  .-.  
	 `;;;. ;   :   ;;  ;;  ;;  ;;  :  :: .;.-'  
	 _   `:`:::'-'';  ;;  ';   ;;_.`_;;_.-`:::' 
	(_.;;;'      _;        `-'.;'               


**colossal**

	 .d8888b.                              888         
	d88P  Y88b                             888         
	Y88b.                                  888         
	 "Y888b.   8888b. 88888b.d88b. 88888b. 888 .d88b.  
	    "Y88b.    "88b888 "888 "88b888 "88b888d8P  Y8b 
	      "888.d888888888  888  888888  88888888888888 
	Y88b  d88P888  888888  888  888888 d88P888Y8b.     
	 "Y8888P" "Y888888888  888  88888888P" 888 "Y8888  
	                               888                 
	                               888                 
	                               888                 


**computer**

	#######    #  ##  ######## ##                
	##   ##   ### ### ######## ##       ######## 
	##       ##### ###      ## ##       ######## 
	####### ####### ###     ## ##                
	    ### #######  ###    ## ##                
	##  ###   ###     ###   ## ##                
	#######  #####     ###  ## ########          
	                    ##  ## ########          


**com_sen_**

	          ###   ##   ## ###### ####    #######  
	         ## ##  ### ###  ##  ## ##      ##      
	  ##### ##   ## #######  ##  ## ##      ##      
	 ##     ####### ## # ##  #####  ##      ####    
	  ####  ##   ## ##   ##  ##     ##      ##      
	     ## ##   ## ##   ##  ##     ##      ##      
	 #####  ##   ## ##   ## ####   ####### #######  
                                                


**contessa**

	 __.           .   
	(__  _.._ _ ._ | _ 
	.__)(_][ | )[_)|(/,
	            |      


**contrast**

	..%%%%....%%%%...%%...%%..%%%%%...%%......%%%%%%.
	.%%......%%..%%..%%%.%%%..%%..%%..%%......%%.....
	..%%%%...%%%%%%..%%.%.%%..%%%%%...%%......%%%%...
	.....%%..%%..%%..%%...%%..%%......%%......%%.....
	..%%%%...%%..%%..%%...%%..%%......%%%%%%..%%%%%%.
	.................................................


**convoy__**

	 ###### ## ###      #  #  # #  #     #  #  
	 ###   ### ##       #  # # #  # #      # # 
	 ###    ## ###     #     #  #        #  ## 
	 ######     #                   #    #  ## 
	      # ## ####              #  #          
	      #   ###               #  #       ##  
	 ###### ## ####                       #  # 
	                            #  ##    #  #  


**cosmic**

	 .::::::.   :::.     .        :::::::::::. :::    .,::::::  
	;;;`    `   ;;`;;    ;;,.    ;;;`;;;```.;;;;;;    ;;;;''''  
	'[==/[[[[, ,[[ '[[,  [[[[, ,[[[[,`]]nnn]]' [[[     [[cccc   
	  '''    $c$$$cc$$$c $$$$$$$$"$$$ $$$""    $$'     $$""""   
	 88b    dP 888   888,888 Y88" 888o888o    o88oo,.__888oo,__ 
	  "YMmMY"  YMM   ""` MMM  M'  "MMMYMMMb   """"YUMMM""""YUMMM


**cosmike**

	 .::::::.   :::.     .        :::::::::::. :::    .,::::::  
	;;;`    `   ;;`;;    ;;,.    ;;;`;;;```.;;;;;;    ;;;;''''  
	'[==/[[[[, ,[[ '[[,  [[[[, ,[[[[,`]]nnn]]' [[[     [[cccc   
	  '''    $c$$$cc$$$c $$$$$$$$"$$$ $$$""    $$'     $$""""   
	 88b    dP 888   888,888 Y88" 888o888o    o88oo,.__888oo,__ 
	  "YMmMY"  YMM   ""` MMM  M'  "MMMYMMMb   """"YUMMM""""YUMMM


**courb**
                                                         
	                     ##       
	 ###                  #       
	## # ###  ####  ###   #   ### 
	 ##   ### # # #  # #  #  #### 
	# ## # ## # # #  # #  #  ##   
	###  ## # # # #  ##  ###  ### 
	                ###           


**courbi**
                                    
	                          ##        
	 ####                      #        
	 ## #  ###  #####   ###    #   ###  
	  ##    ### # # ##  # ##   #  ##### 
	## #  ## #  # # #   # #   ##  ##    
	####  ####  # # #   ##   ####  ###  
	                   ###              


**cour**
                                                                                    
	                    ##      
	 ##                  #      
	#   ##   # #   ###   #   ## 
	 ##  ##  ## #   # #  #  ### 
	# # # #  ## #   # #  #  #   
	##   # # ## ##  ##  ###  ## 
	                #           
	               ###          


**couri**
                                                                                                  
	                         ##      
	  ###                     #      
	 #  #  ##   #  #  ###     #  ### 
	  #     ##  ####   # #   #  #### 
	#  #  ###  # # #  #  #   #  #    
	###   # #  #   #  ###  ####  ##  
	                 ##              


**Crawford2**

	  _____  ____  ___ ___  ____  _        ___ 
	 / ___/ /    ||   |   ||    \| |      /  _]
	(   \_ |  o  || _   _ ||  o  ) |     /  [_ 
	 \__  ||     ||  \_/  ||   _/| |___ |    _]
	 /  \ ||  _  ||   |   ||  |  |     ||   [_ 
	 \    ||  |  ||   |   ||  |  |     ||     |
	  \___||__|__||___|___||__|  |_____||_____|
                                           


**crawford**

	  _____  ____  ___ ___  ____  _        ___ 
	 / ___/ /    T|   T   T|    \| T      /  _]
	(   \_ Y  o  || _   _ ||  o  ) |     /  [_ 
	 \__  T|     ||  \_/  ||   _/| l___ Y    _]
	 /  \ ||  _  ||   |   ||  |  |     T|   [_ 
	 \    ||  |  ||   |   ||  |  |     ||     T
	  \___jl__j__jl___j___jl__j  l_____jl_____j
                                           


**Crawford**

	  _____  ____  ___ ___  ____  _        ___ 
	 / ___/ /    T|   T   T|    \| T      /  _]
	(   \_ Y  o  || _   _ ||  o  ) |     /  [_ 
	 \__  T|     ||  \_/  ||   _/| l___ Y    _]
	 /  \ ||  _  ||   |   ||  |  |     T|   [_ 
	 \    ||  |  ||   |   ||  |  |     ||     T
	  \___jl__j__jl___j___jl__j  l_____jl_____j
                                           


**crazy**
                                                                                                                                                .---.                     
	                     __  __   ___  _________   _...._      |   |      __.....__      
	                    |  |/  `.'   `.\        |.'      '-.   |   |  .-''         '.    
	                    |   .-.  .-.   '\        .'```'.    '. |   | /     .-''"'-.  `.  
	               __   |  |  |  |  |  | \      |       \     \|   |/     /________\   \ 
	       _    .:--.'. |  |  |  |  |  |  |     |        |    ||   ||                  | 
	     .' |  / |   \ ||  |  |  |  |  |  |      \      /    . |   |\    .-------------' 
	    .   | /`" __ | ||  |  |  |  |  |  |     |\`'-.-'   .'  |   | \    '-.____...---. 
	  .'.'| |// .'.''| ||__|  |__|  |__|  |     | '-....-'`    |   |  `.             .'  
	.'.'.-'  / / /   | |_                .'     '.             '---'    `''-...... -'    
	.'   \_.'  \ \._,\ '/              '-----------'                                     
	            `--'  `"                                                                 


**cricket**
	
	 _______                      __       
	|   _   .---.-.--------.-----|  .-----.
	|   1___|  _  |        |  _  |  |  -__|
	|____   |___._|__|__|__|   __|__|_____|
	|:  1   |              |__|            
	|::.. . |                              
	`-------'                              
                                       


**cursive**

	  ()                      _  
	  /\                     //  
	 /  )  __.  ______  _   // _ 
	/__/__(_/|_/ / / <_/_)_</_</_
	                  /          
	                 '           


**cyberlarge**

	 _______ _______ _______  _____         _______
	 |______ |_____| |  |  | |_____] |      |______
	 ______| |     | |  |  | |       |_____ |______
                                               


**cybermedium**

	____ ____ _  _ ___  _    ____ 
	[__  |__| |\/| |__] |    |___ 
	___] |  | |  | |    |___ |___ 
                              


**cybersmall**

	 ____ ____ _  _ ___  _    ____
	 ==== |--| |\/| |--' |___ |===


**cygnet**

                    
	.-.            .    
	`-..-. .-.-..-.| .-,
	`-'`-`-' ' '|-''-`'-
	            '       


**DANC4**

	 |_O_|#  \O/   \O/    \O  |_O    \O/  
	  _|      Y_    Y  .___|   _|>    Y   
	_|  \    /  |  / \     | _|  \   / \  
	    |_ ./   |__| |_    |_    |_./   \,


**dancingfont**

	  ____       _      __  __    ____      _     U _____ u 
	 / __"| uU  /"\  uU|' \/ '|uU|  _"\ u  |"|    \| ___"|/ 
	<\___ \/  \/ _ \/ \| |\/| |/\| |_) |/U | | u   |  _|"   
	 u___) |  / ___ \  | |  | |  |  __/   \| |/__  | |___   
	 |____/>>/_/   \_\ |_|  |_|  |_|       |_____| |_____|  
	  )(  (__)\\    >><<,-,,-.   ||>>_     //  \\  <<   >>  
	 (__)    (__)  (__)(./  \.) (__)__)   (_")("_)(__) (__) 


**Dancing_Font**

	  ____       _      __  __    ____      _     U _____ u 
	 / __"| uU  /"\  uU|' \/ '|uU|  _"\ u  |"|    \| ___"|/ 
	<\___ \/  \/ _ \/ \| |\/| |/\| |_) |/U | | u   |  _|"   
	 u___) |  / ___ \  | |  | |  |  __/   \| |/__  | |___   
	 |____/>>/_/   \_\ |_|  |_|  |_|       |_____| |_____|  
	  )(  (__)\\    >><<,-,,-.   ||>>_     //  \\  <<   >>  
	 (__)    (__)  (__)(./  \.) (__)__)   (_")("_)(__) (__) 


**dcs_bfmo**

	        # # # #  ## #  # # # #    # # # # # #### # 
	 #####  #  # # # #### ## # # #    # # # #  # # ##  
	###     #  # # # #### ## # # #             # ## #  
	 #####  #  # # # #### ## #  ##             ##      
	    ### #  # ### ####### #  ##                     
	####### #  # ### ####### #  # #                    
	####### #  ##### #### ## #  # # #                  
	######  # ####   ## # ## #  # # #                  


**d_dragon**

	 ####### ######## ######## ######## ## ##### ######## 
	 ##      ######## ######## ######## ######## ######## 
	 ####### ######## ######## ######## ######## ######## 
	      ## ######## ######## ######## ######## ######## 
	 ###  ## ######## ######## ######## ######## ######## 
	 ###  ## ######## ######## ######## ######## ######## 
	 ####### ######## ######## ### #### ######## ######## 
	         ######## ######## # #####  ######## ######## 


**decimal**

	83 97 109 112 108 101 


**deep_str**

	  ## ### ########       ## ###  ##       
	 ####  # ########        #  ##  ###      
	 #####   ########            #   ####    
	  #####      ####                 ####   
	   #####                          ###### 
	 #  ####                           ##### 
	 ### ##                        #    #### 
	                               ##   #### 


**defleppard**

                                                                           
                                                                           
	          .                                                              ,;
	         ;W                                 t                   i      f#i 
	        f#E         ..           ..       : ED.                LE    .E#t  
	      .E#f         ;W,          ,W,     .Et E#K:              L#E   i#W,   
	     iWW;         j##,         t##,    ,W#t E##W;            G#W.  L#D.    
	    L##Lffi      G###,        L###,   j###t E#E##t          D#K. :K#Wfff;  
	   tLLG##L     :E####,      .E#j##,  G#fE#t E#ti##f        E#K.  i##WLLLLt 
	     ,W#i     ;W#DG##,     ;WW; ##,:K#i E#t E#t ;##D.    .E#E.    .E#L     
	    j#E.     j###DW##,    j#E.  ##f#W,  E#t E#ELLE##K:  .K#E        f#E:   
	  .D#j      G##i,,G##,  .D#L    ###K:   E#t E#L;;;;;;, .K#D          ,WW;  
	 ,WK,     :K#K:   L##, :K#t     ##D.    E#t E#t       .W#G            .D#; 
	 EG.     ;##D.    L##, ...      #G      ..  E#t      :W##########Wt     tt 
	 ,       ,,,      .,,           j                    :,,,,,,,,,,,,,.       
                                                                           


**delta_corps_priest**

	   ▄████████    ▄████████   ▄▄▄▄███▄▄▄▄      ▄███████▄  ▄█          ▄████████ 
	  ███    ███   ███    ███ ▄██▀▀▀███▀▀▀██▄   ███    ███ ███         ███    ███ 
	  ███    █▀    ███    ███ ███   ███   ███   ███    ███ ███         ███    █▀  
	  ███          ███    ███ ███   ███   ███   ███    ███ ███        ▄███▄▄▄     
	▀███████████ ▀███████████ ███   ███   ███ ▀█████████▀  ███       ▀▀███▀▀▀     
	         ███   ███    ███ ███   ███   ███   ███        ███         ███    █▄  
	   ▄█    ███   ███    ███ ███   ███   ███   ███        ███▌    ▄   ███    ███ 
	 ▄████████▀    ███    █▀   ▀█   ███   █▀   ▄████▀      █████▄▄██   ██████████ 
	                                                       ▀                      
	

**demo_1__**

	  # ###                                          
	 ##  ##    #### ##   ##  ###### ##       ######  
	 ##       ## ## ### ### ##   ## ##      ##       
	  ####    ## ## ####### ##  ##  ##      ##       
	     ##  ##  ## ## # ## ## ##    #      ####     
	 ##  ##  ##  ## ##   ## ####    ##      ##       
	 ## ##  ##   ## ##   ## ##      ##      ##       
	        ## #### ##   ## ##      ####### #######  


**demo_2__**

	  #####                                         
	 ### ##    ##   ##    #  # ###  #       # ####  
	 ###      # #   ###  ##  #   ## #       #   ##  
	  ####   ## #     ###    #   ## #       #       
	    ###  #  ##  #  #  # ## ### ##      ## ##    
	 ## ### ## #### #     # ##     ##      ##       
	 #####  ##   ## ##   ## ##     ##   ## ##  ###  
	        ##   ## ##   ## ##     ## #### ## ###   
	

**demo_m__**

	   #####    ##   ##  ##  #####  ##    ##### 
	  ##       ###   ##  ##  ##  ## ##    ##    
	  ##      ## ##  ######  ##  ## ##    ##    
	 ######  ##  ## ## # ## ###### ##    ####   
	     ## ####### ##   ## #      ##    ##     
	    ##  ##   ## ##   ## ##     ##    ##     
	######  ##   ## ##   ## ##     ##### #####  
                                            


**devilish**

	 ######        ##  ######## ##              # 
	#####        # ### ######## ##           #    
	##      #       ###      ## ##          ###   
	 #####  ##     # ###     ## ##        ### ##  
	    ###  ##  ###  ###    ## ##       ##    ## 
	###  ##   ####     ###   ## ##       #      # 
	######     ##       ###  ## ########    #     
	         #           ##  ## ########          


**diamond**

	  /\\ \\                                  /\\          
	/\\    /\\                                /\\          
	 /\\         /\\    /\\\ /\\ /\\ /\ /\\   /\\   /\\    
	   /\\     /\\  /\\  /\\  /\  /\\/\  /\\  /\\ /\   /\\ 
	      /\\ /\\   /\\  /\\  /\  /\\/\   /\\ /\\/\\\\\ /\\
	/\\    /\\/\\   /\\  /\\  /\  /\\/\\ /\\  /\\/\        
	  /\\ \\    /\\ /\\\/\\\  /\  /\\/\\     /\\\  /\\\\   
	                                 /\\                   


**dietcola**

	         .-.                        .      
	   .--.-'                          /       
	  (  (_).-.  .  .-. .-.     .-.   /   .-.  
	   `-. (  |   )/   )   )    /  ) /  ./.-'_ 
	 _    ) `-'-''/   /   (    /`-'_/_.-(__.'  
	(_.--'                 `-'/                


**digital**

	+-+-+-+-+-+-+
	|S|a|m|p|l|e|
	+-+-+-+-+-+-+


**doh**

                                                                                                                                                                                                                          
	   SSSSSSSSSSSSSSS                                                               lllllll                     
	 SS:::::::::::::::S                                                              l:::::l                     
	S:::::SSSSSS::::::S                                                              l:::::l                     
	S:::::S     SSSSSSS                                                              l:::::l                     
	S:::::S              aaaaaaaaaaaaa      mmmmmmm    mmmmmmm   ppppp   ppppppppp    l::::l     eeeeeeeeeeee    
	S:::::S              a::::::::::::a   mm:::::::m  m:::::::mm p::::ppp:::::::::p   l::::l   ee::::::::::::ee  
	 S::::SSSS           aaaaaaaaa:::::a m::::::::::mm::::::::::mp:::::::::::::::::p  l::::l  e::::::eeeee:::::ee
	  SS::::::SSSSS               a::::a m::::::::::::::::::::::mpp::::::ppppp::::::p l::::l e::::::e     e:::::e
	    SSS::::::::SS      aaaaaaa:::::a m:::::mmm::::::mmm:::::m p:::::p     p:::::p l::::l e:::::::eeeee::::::e
	       SSSSSS::::S   aa::::::::::::a m::::m   m::::m   m::::m p:::::p     p:::::p l::::l e:::::::::::::::::e 
	            S:::::S a::::aaaa::::::a m::::m   m::::m   m::::m p:::::p     p:::::p l::::l e::::::eeeeeeeeeee  
	            S:::::Sa::::a    a:::::a m::::m   m::::m   m::::m p:::::p    p::::::p l::::l e:::::::e           
	SSSSSSS     S:::::Sa::::a    a:::::a m::::m   m::::m   m::::m p:::::ppppp:::::::pl::::::le::::::::e          
	S::::::SSSSSS:::::Sa:::::aaaa::::::a m::::m   m::::m   m::::m p::::::::::::::::p l::::::l e::::::::eeeeeeee  
	S:::::::::::::::SS  a::::::::::aa:::am::::m   m::::m   m::::m p::::::::::::::pp  l::::::l  ee:::::::::::::e  
	 SSSSSSSSSSSSSSS     aaaaaaaaaa  aaaammmmmm   mmmmmm   mmmmmm p::::::pppppppp    llllllll    eeeeeeeeeeeeee  
	                                                              p:::::p                                        
	                                                              p:::::p                                        
	                                                             p:::::::p                                       
	                                                             p:::::::p                                       
	                                                             p:::::::p                                       
	                                                             ppppppppp                                       
                                                                                                             


**doom**

	 _____                       _      
	/  ___|                     | |     
	\ `--.  __ _ _ __ ___  _ __ | | ___ 
	 `--. \/ _` | '_ ` _ \| '_ \| |/ _ \
	/\__/ / (_| | | | | | | |_) | |  __/
	\____/ \__,_|_| |_| |_| .__/|_|\___|
	                      | |           
	                      |_|           


**DOS_Rebel**

	  █████████                                      ████          
	 ███░░░░░███                                    ░░███          
	░███    ░░░   ██████   █████████████   ████████  ░███   ██████ 
	░░█████████  ░░░░░███ ░░███░░███░░███ ░░███░░███ ░███  ███░░███
	 ░░░░░░░░███  ███████  ░███ ░███ ░███  ░███ ░███ ░███ ░███████ 
	 ███    ░███ ███░░███  ░███ ░███ ░███  ░███ ░███ ░███ ░███░░░  
	░░█████████ ░░████████ █████░███ █████ ░███████  █████░░██████ 
	 ░░░░░░░░░   ░░░░░░░░ ░░░░░ ░░░ ░░░░░  ░███░░░  ░░░░░  ░░░░░░  
	                                       ░███                    
	                                       █████                   
	                                      ░░░░░                    


**dotmatrix**

	   _  _  _  _                                                _  _                     
	 _(_)(_)(_)(_)_                                             (_)(_)                    
	(_)          (_)   _  _  _        _  _   _  _   _  _  _  _     (_)    _  _  _  _      
	(_)_  _  _  _     (_)(_)(_) _    (_)(_)_(_)(_) (_)(_)(_)(_)_   (_)   (_)(_)(_)(_)_    
	  (_)(_)(_)(_)_    _  _  _ (_)  (_)   (_)   (_)(_)        (_)  (_)  (_) _  _  _ (_)   
	 _           (_) _(_)(_)(_)(_)  (_)   (_)   (_)(_)        (_)  (_)  (_)(_)(_)(_)(_)   
	(_)_  _  _  _(_)(_)_  _  _ (_)_ (_)   (_)   (_)(_) _  _  _(_)_ (_) _(_)_  _  _  _     
	  (_)(_)(_)(_)    (_)(_)(_)  (_)(_)   (_)   (_)(_)(_)(_)(_) (_)(_)(_) (_)(_)(_)(_)    
	                                               (_)                                    
	                                               (_)                                    


**double**

	 __  ___ ___  _______ __    ____
	(( \// \\||\\//|||| \\||   ||   
	 \\ ||=|||| \/ ||||_//||   ||== 
	\_))|| ||||    ||||   ||__|||___
                                


**doubleshorts**

	  __  ___  ___  __ _____ __    _____ 
	 ((  ||=|| || \/ | ||_// ||    ||==  
	\_)) || || ||    | ||    ||__| ||___ 


**drpepper**

	 ___                   _      
	/ __> ___ ._ _ _  ___ | | ___ 
	\__ \<_> || ' ' || . \| |/ ._>
	<___/<___||_|_|_||  _/|_|\___.
	                 |_|          
	

**druid___**

	        ######       #### ##  ###   ####           
	 ####   ## #####          ##     #                 
	## # #   #######    ##     ## ####     ##          
	## #     # ###   ##  ##    ## ####    ##  #        
	 #####   # ###   ##   ##      ###    ##   ###      
	   # ## ## ###   ##    ##     ##    ##    #        
	#  # ## # ####   ##         ####                   
	 #####  ##                  ####                   


**dwhistled**

	S mpl 
	 X   X
	 X   X
	 .   X
	 .   X
	 .   X
	 .   .
	      
	Sample
      


**ebbs_1__**

                                            
	          ##   ##  ## #####  ##     ######  
	  #####  ####  ###### ##  ## ##     ##      
	 ##     ##  ## ###### ##  ## ##     ####    
	  ####  ###### ##  ## #####  ##     ##      
	     ## ##  ## ##  ## ##     ##     ##      
	 #####  ##  ## ##  ## ##     ###### ######  
                                            


**ebbs_2__**

	          ###   ##   ## ###### ####    #######  
	         ## ##  ### ###  ##  ## ##      ##      
	  ##### ##   ## #######  ##  ## ##      ##      
	 ##     ####### ## # ##  #####  ##      ####    
	  ####  ##   ## ##   ##  ##     ##      ##      
	     ## ##   ## ##   ##  ##     ##      ##      
	 #####  ##   ## ##   ## ####   ####### #######  
                                                


**eca_____**

                                                 
	           ###   ##   ## ######  ####    ####### 
	  ######  #####  # # ### ### ### ####    ####    
	 # #     ### ### ####### ### ### ####    ######  
	  #####  ### ### ####### ######  ####    ####    
	     ### ####### ### ### ###     ####    ####    
	 ######  ### ### ### ### ###     # ##### ####### 
                                                 


**e__fist_**

	   ####  ##   ## #####  ##     ######  
	  ##  ## ### ### ##  ## ##     ##      
	  ##  ## ####### ##  ## ##     ##      
	  ###### ## # ## #####  ##     #####   
	  ##  ## ## # ## ##     ##     ##      
	  ##  ## ##   ## ##     ##     ##      
	  ##  ## ##   ## ##     ###### ######  
                                       


**eftichess**

	         #########         #########         #########         ###########################
	  [`'`'] ##\`.'/##  ':v:`  ##/\:/\##  |:+:|  ##':v:`##  \`.'/  ##[`'`']####(_)#####|:+:|##
	   |::|  ##(o:o)##  (o:0)  #/(o:o)\#  (o:o)  ##(o:0)##  (o:o)  ###|::|#####| |#####(o:o)##
	   |::|  ###\:/:\#   (:)   ###(:)###   (:)   ###(:)###   \:/:\ ###|::|#####|_|######(:)###
	         ####"####         #########         #########    "    ###########################


**Efti_Chess**

	         #########         #########         #########         ###########################
	  [`'`'] ##\`.'/##  ':v:`  ##/\:/\##  |:+:|  ##':v:`##  \`.'/  ##[`'`']####(_)#####|:+:|##
	   |::|  ##(o:o)##  (o:0)  #/(o:o)\#  (o:o)  ##(o:0)##  (o:o)  ###|::|#####| |#####(o:o)##
	   |::|  ###\:/:\#   (:)   ###(:)###   (:)   ###(:)###   \:/:\ ###|::|#####|_|######(:)###
	         ####"####         #########         #########    "    ###########################
	

**eftifont**

	 __                 
	/ _|_    _ _  _ ||_ 
	\_ Yo\ |/ \ \/o\|/o\
	|__|_,]L_n_n||_/L\( 
	             L|     


**Efti_Italic**

	    ___                    
	  ,' _/ _   _     _   /7 __
	 _\ `.,'o| / \'\ /o| //,'o/
	/___,'|_,7/_nn_//_,'// |_( 
	               //          


**eftipiti**

       
	((ample
	''     


**eftirobot**

	 ___                     _      
	/  _)                   ( )     
	\_"-.  ___  __  __  ___ | | ___ 
	 __) )( o )( _`'_ )( o \( )( o_)
	/___/ /_^_\/_\`'/_\/ __//_\ \(  
	                   |_|          


**eftiwall**
	
	                 |                ___     #                 #   _     _         |"|      
	     >X<         |.===.          /_\ `*   #=ooO=========Ooo=# o' \,=./ `o      _|_|_     
	    (o o)        {}o o{}        (o o)     #  \\  (o o)  //  #    (o o)         (o o)     
	ooO--(_)--Ooo-ooO--(_)--Ooo-ooO--(_)--Ooo---------(_)--------ooO--(_)--Ooo-ooO--(_)--Ooo-
	

**eftiwater**

	___                 _    
	))_  ___  _  _  __  )) __
	_(( ((_( ((`1( ((_)(( (('
	                ))       


**Electronic**

	 ▄▄▄▄▄▄▄▄▄▄▄  ▄▄▄▄▄▄▄▄▄▄▄  ▄▄       ▄▄  ▄▄▄▄▄▄▄▄▄▄▄  ▄            ▄▄▄▄▄▄▄▄▄▄▄ 
	▐░░░░░░░░░░░▌▐░░░░░░░░░░░▌▐░░▌     ▐░░▌▐░░░░░░░░░░░▌▐░▌          ▐░░░░░░░░░░░▌
	▐░█▀▀▀▀▀▀▀▀▀ ▐░█▀▀▀▀▀▀▀█░▌▐░▌░▌   ▐░▐░▌▐░█▀▀▀▀▀▀▀█░▌▐░▌          ▐░█▀▀▀▀▀▀▀▀▀ 
	▐░▌          ▐░▌       ▐░▌▐░▌▐░▌ ▐░▌▐░▌▐░▌       ▐░▌▐░▌          ▐░▌          
	▐░█▄▄▄▄▄▄▄▄▄ ▐░█▄▄▄▄▄▄▄█░▌▐░▌ ▐░▐░▌ ▐░▌▐░█▄▄▄▄▄▄▄█░▌▐░▌          ▐░█▄▄▄▄▄▄▄▄▄ 
	▐░░░░░░░░░░░▌▐░░░░░░░░░░░▌▐░▌  ▐░▌  ▐░▌▐░░░░░░░░░░░▌▐░▌          ▐░░░░░░░░░░░▌
	 ▀▀▀▀▀▀▀▀▀█░▌▐░█▀▀▀▀▀▀▀█░▌▐░▌   ▀   ▐░▌▐░█▀▀▀▀▀▀▀▀▀ ▐░▌          ▐░█▀▀▀▀▀▀▀▀▀ 
	          ▐░▌▐░▌       ▐░▌▐░▌       ▐░▌▐░▌          ▐░▌          ▐░▌          
	 ▄▄▄▄▄▄▄▄▄█░▌▐░▌       ▐░▌▐░▌       ▐░▌▐░▌          ▐░█▄▄▄▄▄▄▄▄▄ ▐░█▄▄▄▄▄▄▄▄▄ 
	▐░░░░░░░░░░░▌▐░▌       ▐░▌▐░▌       ▐░▌▐░▌          ▐░░░░░░░░░░░▌▐░░░░░░░░░░░▌
	 ▀▀▀▀▀▀▀▀▀▀▀  ▀         ▀  ▀         ▀  ▀            ▀▀▀▀▀▀▀▀▀▀▀  ▀▀▀▀▀▀▀▀▀▀▀ 
                                                                              


**Elite**

	.▄▄ ·  ▄▄▄· • ▌ ▄ ·.  ▄▄▄·▄▄▌  ▄▄▄ .
	▐█ ▀. ▐█ ▀█ ·██ ▐███▪▐█ ▄███•  ▀▄.▀·
	▄▀▀▀█▄▄█▀▀█ ▐█ ▌▐▌▐█· ██▀·██▪  ▐▀▀▪▄
	▐█▄▪▐█▐█ ▪▐▌██ ██▌▐█▌▐█▪·•▐█▌▐▌▐█▄▄▌
	 ▀▀▀▀  ▀  ▀ ▀▀  █▪▀▀▀.▀   .▀▀▀  ▀▀▀ 


**epic**

	 _______  _______  _______  _______  _        _______ 
	(  ____ \(  ___  )(       )(  ____ )( \      (  ____ \
	| (    \/| (   ) || () () || (    )|| (      | (    \/
	| (_____ | (___) || || || || (____)|| |      | (__    
	(_____  )|  ___  || |(_)| ||  _____)| |      |  __)   
	      ) || (   ) || |   | || (      | |      | (      
	/\____) || )   ( || )   ( || )      | (____/\| (____/\
	\_______)|/     \||/     \||/       (_______/(_______/
                                                      


**etcrvs__**

	          # #  #  # #  # #  #  #   #   ###   #  #  # 
	  ###### ##    ##  #  ## #    ## # # # ##   # # # #  
	 ##      ######## #   ##    ## #   ##  ## # #   ###  
	  ####     #      # #  #     #     #   ###   ##  #   
	     ##  ##  ##   ###  # # ####### # #   ## #   ##   
	 #####   #  #  ## ##   ##   #  ##      ## #  #  #    
	          ##  ##   ##  # # # # #  #  ##   # #    ##  
	               #   #  #        #   #   ## # # # #  # 


**f15_____**

	######## ######## ######## ######## ######## ######## 
	##    ## #######  ###   ## ###      ###   ## ##       
	#  ##  # #####    ###    # ###   ## ###   ## ##   ### 
	#    ### ####   # ###      ###   ## ###   ## ##       
	####   # ###   ## ###   #  ###      ###   ## ##   ### 
	#  ##  # ###      ###   ## ###   ## ###   ## ##   ### 
	##    ## ###   ## ###   ## ###   ## ###      ##       
	######## ######## ######## ######## ######## ######## 


**faces_of**

	                # # ########          ##       
	  #####        # #  ########  #       ##       
	 ##  ###      # #         ##  ##      ##       
	 ##          # #          ##  ###     ##       
	 #######    # #           ##  ## #    ##       
	      ##   # #            ##  ##  #   ##       
	 ###  ##  # #             ##  ##   #  ##       
	  ###### # #              ##  ##    # ######## 


**fairligh**

	 #####  ####  #  #    ##      ##  #      
	###  ##  ##  #        #### #      ### #  
	##    #      ##   #  #  ##   #### #      
	 #####   ##  ###  # #          ##   #  # 
	     ##    # ###       ###  # #     ###  
	##  ### #  # ## ###   ####   ####  # #   
	 ##### #  #  #      #          #     # # 
	        ##   #       # #      # #  #  #  


**fair_mea**

	###### # #     #   # # # ######## #   #   #   # # 
	## ### #       #       # ######## #   #   #   # # 
	## # # #     # #       # #######      #   #   # # 
	###### # # # # #   # # # # ######   # #   #   # # 
	 # ### # # # # #   # # # ### ###    # # # #     # 
	## ### # # #           # ### ###      # # #       
	###### #   #     #     # ### ###  #   # # # #     
	 # # # #   #   # # # # #          # # # # # # # # 


**fantasy_**

	  ### #    #  ##  ######## ##                
	 ##  #    ### ### ######## ##       ######## 
	 ##      ##### ###      ## ##       ######## 
	  ####  ####### ###     ## ##                
	    ### #######  ###    ## ##                
	 #   ##   ###     ###   ## ##                
	 ## ###  #####     ###  ## ########          
	# ####              ##  ## ########          


**fbr12___**

	    ###         #       #   ## ###  
	   ####      ## #  ## #     ## ###  
	  ##  #  #  ### #  # #   #  ## ###  
	 ##                        ######## 
	#######      ## #  # # ##  # # ###  
	     ##  ### #             # # ###  
	#######  ###           ## # ## ###  
	          ##  ###  # #### # ## ###  


**fbr1____**

	  ####    # # # ##   # # ## #   #     #  # # # # #  
	 ## ### # # # #      # #      # # #   ## # # # # #  
	  ##    # # ##  # #### # # #### # ##    #  # # # #  
	#   ##  # ## #        #       ##       # # # # # #  
	####### # ## #      #  #     #  # # #### # # # # #  
	####### # ## #  #   ## # #   ## #        # # # # #  
	######  # ## #  ##  #    ## # #       #  #  # # # # 
	        # ## #       # #      # # #   ## #  # # # # 


**fbr2____**

	            #### ###  ## ####### ####     ######  
	           ##### ### ### ## #  ## ###     ###  ## 
	  #####   ## ### ####### # ##  ## ###     ###     
	 ###     ##  ### ## # ##  ######  ###     #####   
	  ####  ######## ## # ##  ###     ###     ###     
	 #  ### ##   ### ##   ##  ###     ###   # ###  ## 
	 #####  ##   ### ##   ##  ###     ####### ######  
	 #       ###      ##                              


**fbr_stri**

	  #####    #     #   ##     ## #     # #    ## #  # 
	 ###### # #  ## #  ####      ###      ##       ##   
	 ##     #   ##  #   #  #  #    #   #  ##   # #  ### 
	 ##    ### #        #    # # ## #  #  ####    # #   
	  ####    #     # # #  #  ## ###   #    #  ## #  ## 
	     ##  #           ###      ### ## ### # # #  #   
	 #####  ## ## # #  ##  # #     #   #   #    ## ##   
	       # # #    #  #   #      ##       #   # #   #  


**fbr_tilt**

	    ###  # # # #        #       #   ## ###  
	   ####  # # # #     ## #  ## #     ## ###  
	  ##  # ######## #  ### #  # #   #  ## ###  
	 ##     # # # #                     ## ###  
	####### # # # #      ## #  # # ##   ## ###  
	     ##  # # # # ### #              ## ###  
	#######  # # # # ###           ## # ## ###  
	         # # # #  ##  ###  # #### # ## ###  


**fender**

	.|'''|                             '||`        
	||                                  ||         
	`|'''|,  '''|.  '||),,(|,  '||''|,  ||  .|''|, 
	 .   || .|''||   || || ||   ||  ||  ||  ||..|| 
	 |...|' `|..||. .||    ||.  ||..|' .||. `|...  
	                            ||                 
	                           .||                 


**filter**

	88888888  ,8b.     d88b_o8b 8888PPPp, 888        ,d8PPPP 
	88ooooPp  88'8o    d88 8'8b 8888    8 888        d88ooo  
	       d8 88PPY8.  d88   8b 8888PPPP' 888      ,88'      
	8888888P  8b   `Y' Y88   8P 888P      888PPPPP 88bdPPP   
	                              _  _                       


**finalass**

	 #####     #  ##  ######## ##                
	##   ##   ### ### ######## ##       ######## 
	##       ##### ###      ## ##       ######## 
	 #####  ####### ###     ## ##                
	     ## #######  ###    ## ##                
	##   ##   ###     ###   ## ##                
	 #####   #####     ###  ## ########          
	                    ##  ## ########          


**fire_font-k**

	 (                                  
	 )\ )                      (        
	(()/(    )     )           )\   (   
	 /(_))( /(    (     `  )  ((_) ))\  
	(_))  )(_))   )\  ' /(/(   _  /((_) 
	/ __|((_)_  _((_)) ((_)_\ | |(_))   
	\__ \/ _` || '  \()| '_ \)| |/ -_)  
	|___/\__,_||_|_|_| | .__/ |_|\___|  
	                   |_|              
	

**fire_font-s**

	 (                             
	 )\ )                  (       
	(()/(   )    )         )\  (   
	 /(_)| /(   (    `  ) ((_)))\  
	(_)) )(_))  )\  '/(/(  _ /((_) 
	/ __((_)_ _((_))((_)_\| (_))   
	\__ Y _` | '  \() '_ \) / -_)  
	|___|__,_|_|_|_|| .__/|_\___|  
	                |_|            


**fireing_**

	        ####  #####  #####  #      ######   
	       #    # #    #      # #               
	 ##### #    # # #  #      # #               
	#      # #### # #  # #####  #      ######   
	 ####  #    # # #  # #      #      #        
	     # #    # # #  # #      #      #        
	#####  #    # # #  # #      ###### ######   
                                            


**flipped**

	 _ __  ___   ____  ____        ____ 
	| |  \|_  \ |_   ||_   | ____ |    |
	| || | _|> | _< <   || ||  __|||_| |
	\__|_||___/ |____|  \__/|_|   |_||_|


**flowerpower**
	
	   .-'''-.    ____    ,---.    ,---..-------.   .---.       .-''-.   
	  / _     \ .'  __ `. |    \  /    |\  _(`)_ \  | ,_|     .'_ _   \  
	 (`' )/`--'/   '  \  \|  ,  \/  ,  || (_ o._)|,-./  )    / ( ` )   ' 
	(_ o _).   |___|  /  ||  |\_   /|  ||  (_,_) /\  '_ '`) . (_ o _)  | 
	 (_,_). '.    _.-`   ||  _( )_/ |  ||   '-.-'  > (_)  ) |  (_,_)___| 
	.---.  \  :.'   _    || (_ o _) |  ||   |     (  .  .-' '  \   .---. 
	\    `-'  ||  _( )_  ||  (_,_)  |  ||   |      `-'`-'|___\  `-'    / 
	 \       / \ (_ o _) /|  |      |  |/   )       |        \\       /  
	  `-...-'   '.(_,_).' '--'      '--'`---'       `--------` `'-..-'   
                                                                     


**flyn_sh**

	#### ## #######      #### ##    #  #        # ##  ## 
	#######  #  ####     #### ## # ##   ###     ######   
	  ###   ####  ##     #  # # ## ### ###      ##  # ## 
	   ##    # ## ##   ###### # # #### ######    ### #   
	  ###    #  ####    #   # ### #### #### #   ######   
	  ##    ## ##### ### #### ######## ##### ## ###      
	  ###   ## #####   ###### ######## ####      ###     
	  ###   # ### ## #######  ######## # ##  ## #        


**fourtops**

	/~~\                 |   
	`--./~~||/~\ /~\ |~~\|/~/
	\__/\__||   |   ||__/|\/_
	                 |       


**fp1_____**

	 #######    #  ##  ######## ##                
	      ##   ### ### ######## ##       ######## 
	  ##      ##### ###      ## ##       ######## 
	  ###### ####### ###     ## ##                
	      ## #######  ###    ## ##                
	  ##  ##   ###     ###   ## ##                
	  ######  #####     ###  ## ########          
	                     ##  ## ########          


**fp2_____**

	 #####     #  ##  ######## ##                
	##   ##   ### ### ######## ##       ######## 
	##       ##### ###      ## ##       ######## 
	 #####  ####### ###     ## ##                
	     ## #######  ###    ## ##                
	##   ##   ###     ###   ## ##                
	 #####   #####     ###  ## ########          
	                    ##  ## ########          


**fraktur**

	       ...                                                             ..            
	   .x888888hx    :                                               x .d88"             
	  d88888888888hxx                 ..    .     :     .d``          5888R              
	 8" ... `"*8888%`        u      .888: x888  x888.   @8Ne.   .u    '888R        .u    
	!  "   ` .xnxx.       us888u.  ~`8888~'888X`?888f`  %8888:u@88N    888R     ud8888.  
	X X   .H8888888%:  .@88 "8888"   X888  888X '888>    `888I  888.   888R   :888'8888. 
	X 'hn8888888*"   > 9888  9888    X888  888X '888>     888I  888I   888R   d888 '88%" 
	X: `*88888%`     ! 9888  9888    X888  888X '888>     888I  888I   888R   8888.+"    
	'8h.. ``     ..x8> 9888  9888    X888  888X '888>   uW888L  888'   888R   8888L      
	 `88888888888888f  9888  9888   "*88%""*88" '888!` '*88888Nu88P   .888B . '8888c. .+ 
	  '%8888888888*"   "888*""888"    `~    "    `"`   ~ '88888F`     ^*888%   "88888%   
	     ^"****""`      ^Y"   ^Y'                         888 ^         "%       "YP'    
	                                                      *8E                            
	                                                      '8>                            
	                                                       "                             


**funface**

	  oo_         \\\    /// ))    W  W          
	 /  _)-<  /)  ((O)  (O))(o0)-.(O)(O)   wWw   
	 \__ `. (o)(O) | \  / |  | (_)) ||     (O)_  
	    `. | //\\  ||\\//||  | .-'  | \   .' __) 
	    _| ||(__)| || \/ ||  |(     |  `.(  _)   
	 ,-'   |/,-. | ||    ||   \)   (.-.__)`.__)  
	(_..--'-'   ''(_/    \_)  (     `-'          
	

**funfaces**
	
	  oo_         \\\    /// ))    W  W    wWw   
	 /  _)-<  /)  ((O)  (O))(o0)-.(O)(O)   (O)_  
	 \__ `. (o)(O) | \  / |  | (_)) ||     / __) 
	    `. | //\\  ||\\//||  | .-'  | \   / (    
	    _| ||(__)| || \/ ||  |(     |  `.(  _)   
	 ,-'   |/,-. | ||    ||   \)   (.-.__)\ \_   
	(_..--'-'   ''(_/    \_)  (     `-'    \__)  


**funky_dr**

	               ##        ##          
	               ##        ##          
	 ######        ## ###### ##  ######  
	##             ##     ## ##  ##  ##  
	 #####  ###    ##     ## ##  ##  ##  
	     ##   ###  ## ###### ##  ##  ##  
	######      ## ##        ##  ######  
	        #   ## ##        ## #        


**future_1**

	 #####     #  ##  ######## ##                
	##   ##   ### ### ######## ##       ######## 
	##       ##### ###      ## ##       ######## 
	 #####  ####### ###     ## ##                
	     ## #######  ###    ## ##                
	##   ##   ###     ###   ## ##                
	 #####   #####     ###  ## ########          
	                    ##  ## ########          


**future_2**

	 ######      #   ###  ##                    ##      
	#######   ## # # #    ##                 #  ##      
	##        # ###  ### ####   ###   ####  ## ###  ### 
	 #####  #  #   #      ## # ##   # #  ##  #  ## ##   
	     ## # # #### #    ## # ##   # #  ##  #  ## #### 
	####### ## #     #    ## # ##   # #  ##  #  ## ##   
	######    #      #    ## # ##   # #  ##  #  ## ##   
	        ###            ##  ##     ####   # ##   ### 


**future_3**

	 #######    #  ##  ######## ##                
	      ##   ### ### ######## ##       ######## 
	  ##      ##### ###      ## ##       ######## 
	  ###### ####### ###     ## ##                
	      ## #######  ###    ## ##                
	  ##  ##   ###     ###   ## ##                
	  ######  #####     ###  ## ########          
	                     ##  ## ########          


**future_4**

	  ##      # # # #          #  # #      #       
	 ## #     ##  ##           #  ## # #   ##      
	 ##      #  ##  # #        # #  ##  # # #      
	  ####    ##  ##  #        #  ##  ##   ##      
	      ## #  ##  # # #    # # #  ##  # # #      
	 ###  ##  ##  ##   #     # #  ##  ##   ##      
	  #####  # # # #  # #    # # #  ##  # # #      
	         #         ##    # #  ##  ##   ##      


**future_5**

	   ####                    #  # #     
	 ###   #        #  ##    # ## # #     
	 ##            # ####     ##    #     
	  ###### ######## ###    ##  ####     
	      ##         ####    #            
	 ##  ##         ##### #   #           
	  ####          #####  #              
	                #####  #              


**future_6**

	  #### # # # #     # # # # 
	 ### ##   ## #     ####### 
	 ##       ## #     ####### 
	  ####    ####    ######## 
	     ##   ####    ######## 
	### ###   ## #     ####### 
	 #####    ## #     ####### 
	       # # # #     # # # # 


**future_7**

	 ####      #  ##  ######## ##                
	##  ##    ### ### ######## ##       ######## 
	##       ##### ###      ## ##       ######## 
	 #####  # ##### ###     ## ##                
	     ## #######  ###    ## ##                
	##   ##   ###     ###   ## ##                
	 #####   #####     ###  ## ########          
	                    ##  ## ########          


**future_8**

	            #  ##  ######## ##                
	           ### ### ######## ##       ######## 
	 #######  ##### ###      ## ##       ######## 
	         ####### ###     ## ##                
	 ####### #######  ###    ## ##                
	      ##   ###     ###   ## ##                
	 #######  #####     ###  ## ########          
	                     ##  ## ########          


**fuzzy**

	 .--.                       .-.        
	: .--'                      : :        
	`. `.  .--.  ,-.,-.,-..---. : :   .--. 
	 _`, :' .; ; : ,. ,. :: .; `: :_ ' '_.'
	`.__.'`.__,_;:_;:_;:_;: ._.'`.__;`.__.'
	                      : :              
	                      :_;              


**gauntlet**

	             ###      ##  ####                   
	  ####     ##### #### ##  #### ######## ####  ## 
	 ##  ##   ####   #### ##  #### ######## #### ### 
	    ##   ####    #### ##  ####  ####    ####   # 
	     ##  ####    ###  ##  ####  ####    ####   # 
	 ##  ## ####     ###  ##  ###   ####    ####   # 
	 ###### ####     ##   ##  ##    ####  # ####   # 
	  ####  ########      #   #     ####  # ####   # 


**gb16fs**

	                                                      
	  ## #                               ####             
	 #  ##                                  #             
	#    #                                  #             
	#                                       #             
	#          ####    ## ##   #####        #      ###    
	 ##       #    #  #  #  #   #   #       #     #   #   
	   ##          #  #  #  #   #    #      #    #     #  
	     #     #####  #  #  #   #    #      #    #######  
	#     #   #    #  #  #  #   #    #      #    #        
	#     #  #     #  #  #  #   #    #      #    #        
	#     #  #     #  #  #  #   #   #       #    #     #  
	##   #   #    ##  #  #  #   ####        #     #    #  
	# ###     #### ## ## ## ##  #       ########   ####   
	                            #                         
	                           ####                       


**gb16st**

                                                      
	  ## #                               ####             
	 #  ##                                  #             
	#    #                                  #             
	#                                       #             
	#          ####    ## ##   #####        #      ###    
	 ##       #    #  #  #  #   #   #       #     #   #   
	   ##          #  #  #  #   #    #      #    #     #  
	     #     #####  #  #  #   #    #      #    #######  
	#     #   #    #  #  #  #   #    #      #    #        
	#     #  #     #  #  #  #   #    #      #    #        
	#     #  #     #  #  #  #   #   #       #    #     #  
	##   #   #    ##  #  #  #   ####        #     #    #  
	# ###     #### ## ## ## ##  #       ########   ####   
	                            #                         
	                           ####                       


**georgi16**

                                                          
                                                          
	  ____                                       ___          
	 6MMMMb\                                     `MM          
	6M'    `                                      MM          
	MM          ___    ___  __    __   __ ____    MM   ____   
	YM.       6MMMMb   `MM 6MMb  6MMb  `M6MMMMb   MM  6MMMMb  
	 YMMMMb  8M'  `Mb   MM69 `MM69 `Mb  MM'  `Mb  MM 6M'  `Mb 
	     `Mb     ,oMM   MM'   MM'   MM  MM    MM  MM MM    MM 
	      MM ,6MM9'MM   MM    MM    MM  MM    MM  MM MMMMMMMM 
	      MM MM'   MM   MM    MM    MM  MM    MM  MM MM       
	L    ,M9 MM.  ,MM   MM    MM    MM  MM.  ,M9  MM YM    d9 
	MYMMMM9  `YMMM9'Yb._MM_  _MM_  _MM_ MMYMMM9  _MM_ YMMMM9  
	                                    MM                    
	                                    MM                    
	                                   _MM_                   


**Georgia11**

	                                                           
	                                               ,,          
	 .M"""bgd                                    `7MM          
	,MI    "Y                                      MM          
	`MMb.      ,6"Yb.  `7MMpMMMb.pMMMb. `7MMpdMAo. MM  .gP"Ya  
	  `YMMNq. 8)   MM    MM    MM    MM   MM   `Wb MM ,M'   Yb 
	.     `MM  ,pm9MM    MM    MM    MM   MM    M8 MM 8M"""""" 
	Mb     dM 8M   MM    MM    MM    MM   MM   ,AP MM YM.    , 
	P"Ybmmd"  `Moo9^Yo..JMML  JMML  JMML. MMbmmd'.JMML.`Mbmmd' 
	                                      MM                   
	                                    .JMML.                 


**ghost_bo**

	 ######              
	#######              
	##                   
	 #####               
	     ##              
	#######              
	######               
                     


**ghost**

	  .-')     ('-.     _   .-')      _ (`-.              ('-.   
	 ( OO ).  ( OO ).-.( '.( OO )_   ( (OO  )           _(  OO)  
	(_)---\_) / . --. / ,--.   ,--.)_.`     \ ,--.     (,------. 
	/    _ |  | \-.  \  |   `.'   |(__...--'' |  |.-')  |  .---' 
	\  :` `..-'-'  |  | |         | |  /  | | |  | OO ) |  |     
	 '..`''.)\| |_.'  | |  |'.'|  | |  |_.' | |  |`-' |(|  '--.  
	.-._)   \ |  .-.  | |  |   |  | |  .___.'(|  '---.' |  .--'  
	\       / |  | |  | |  |   |  | |  |      |      |  |  `---. 
	 `-----'  `--' `--' `--'   `--' `--'      `------'  `------' 


**ghoulish**

	  )\.--.     /`-.    )\   )\     /`-.   .')       )\.---.  
	 (   ._.'  ,' _  \  (  ',/ /   ,' _  \ ( /       (   ,-._( 
	  `-.`.   (  '-' (   )    (   (  '-' (  ))        \  '-,   
	 ,_ (  \   )   _  ) (  \(\ \   ) ,._.'  )'._.-.    ) ,-`   
	(  '.)  ) (  ,' ) \  `.) /  ) (  '     (       )  (  ``-.  
	 '._,_.'   )/    )/      '.(   )/       )/,__.'    )..-.(  
                                                           


**glenyn**

	___  ___  _    ____ __   ____ 
	| _\ |  \ |\/\ | . \| |  | __\
	[__ \| . \|   \| __/| |__|  ]_
	|___/|/\_/|/v\/|/   |___/|___/


**goofy**

	_       ______  _____          _     ___     ____        __
	 )  ____)    /  \    |        | |    \  \   |    \    ___) 
	(  (___     /    \   |  |\/|  | |     )  |  |     |  (__   
	 \___  \   /  ()  \  |  |  |  | |  __/   |  |     |   __)  
	 ____)  ) |   __   | |  |  |  | | |      |  |__   |  (___  
	(      (__|  (__)  |_|  |__|  |_| |_____/      )_/       )_


**gothic__**

	          ##### ##  ### ## ###   ### #   ### ##  
	       # ## ## #######   ##  ## ##  #   ##  ##   
	  ##### ##  ## #  #  #   #   ##  ##      ##      
	##      ###### #  #  #   ##  ##  ##      ####    
	 #####  ##  ## #  #  #   ## ##   ##      ##      
	     ## ##  ## ## #  #   ##     ###  ## ###  ##  
	 ##### ##    ## #  # ## ## ##   # ####  # ####   
	#              #                                 


**gothic**

	          ##### ##  ### ## ###   ### #   ### ##  
	       # ## ## #######   ##  ## ##  #   ##  ##   
	  ##### ##  ## #  #  #   #   ##  ##      ##      
	##      ###### #  #  #   ##  ##  ##      ####    
	 #####  ##  ## #  #  #   ## ##   ##      ##      
	     ## ##  ## ## #  #   ##     ###  ## ###  ##  
	 ##### ##    ## #  # ## ## ##   # ####  # ####   
	#              #                                 


**graceful**

	 ____   __   _  _  ____  __    ____ 
	/ ___) / _\ ( \/ )(  _ \(  )  (  __)
	\___ \/    \/ \/ \ ) __// (_/\ ) _) 
	(____/\_/\_/\_)(_/(__)  \____/(____)


**gradient**

	.eeeeee..eeeeee..eee......eee.eeeeeee..eee....eeeeee.
	@@@@@@@:@@@@@@@@:@@@@::::@@@@:@@@@@@@@:@@@::::@@@@@@:
	%%%-----%%%--%%%-%%%%%--%%%%%-%%%--%%%-%%%----%%%----
	&&&&&&++&&&&&&&&+&&&&&&&&&&&&+&&&&&&&&+&&&++++&&&&&++
	*||||||*||||||||*|||*||||*|||*|||||||**|||****|||||**
	====!!!=!!!==!!!=!!!==!!==!!!=!!!======!!!====!!!====
	:::::::#:::##:::#:::######:::#:::######::::::#::::::#
	......@@...@@...@...@@@@@@...@...@@@@@@......@......@
                                                     


**graffiti**

	  _________                     .__          
	 /   _____/____    _____ ______ |  |   ____  
	 \_____  \\__  \  /     \\____ \|  | _/ __ \ 
	 /        \/ __ \|  Y Y  \  |_> >  |_\  ___/ 
	/_______  (____  /__|_|  /   __/|____/\___  >
	        \/     \/      \/|__|             \/ 


**grand_pr**

	  ##   ### ### ##  ####  # ##             ## ##### 
	##  ## ### ### ######   #####  #              #    
	##     ### ### ### # #  #### ##         #          
	  ##   ### ### # #    # ##### ## ## # # #          
	    ## ### ###  # ## #  #   # #  ##  ####          
	##  ## ### ###   #      #   #### ######## ######   
	  ##   ### ###          ##   #   ### ##   ######## 
	      #   #       #         #  # ######## ######## 


**greek**

                                   
	______                  __         
	\  ___)                 \ \        
	 \ \   __  ___   _ ______\ \   ___ 
	  > > /  \/ / | | (  __  )> \ / __)
	 / /_( ()  <| |_| || || |/ ^ \> _) 
	/_____)__/\_\ ._,_||_||_/_/ \_\___)
	            | |                    
	            |_|                    


**green_be**

	  # ### # # # # #   #    ## # # #            #### 
	 ##  ## # # # #  ##   #  ## # # #        ####  #  
	 ##     # # # #    ## #  ## # # #        #   #    
	  ####  # # # #  #   ##  ## # # #          #   #  
	     ## # # # #    #   # ## # # #     #### #   #  
	 ##  ## # # # #  # #     ## # # # ####   #    #   
	 ## ##  # # # #  # # # # ## # # #   #   ## #   #  
	        # # # #  # # # # ## # # #   ####   #   #  


**hades___**

	 ######          ###### #     # # ####     #### #   
	#####               #     # # # #     ####    #     
	##        # #        #### # #     ########     #### 
	 #####           ########       # ####     ###### # 
	    ###           ###     # # # #     ####  ###     
	###  ## ########       ## #       ###### #       ## 
	######           ########          # #     ######## 
	              ## ##         # #       #### ##       


**hanglg16**

                                                      
	  ## #                               ####             
	 #  ##                                  #             
	#    #                                  #             
	#                                       #             
	#          ####    ## ##   #####        #      ###    
	 ##       #    #  #  #  #   #   #       #     #   #   
	   ##          #  #  #  #   #    #      #    #     #  
	     #     #####  #  #  #   #    #      #    #######  
	#     #   #    #  #  #  #   #    #      #    #        
	#     #  #     #  #  #  #   #    #      #    #        
	#     #  #     #  #  #  #   #   #       #    #     #  
	##   #   #    ##  #  #  #   ####        #     #    #  
	# ###     #### ## ## ## ##  #       ########   ####   
	                            #                         
	                           ####                       


**hanglm16**

	                                                      
	  ## #                               ####             
	 #  ##                                  #             
	#    #                                  #             
	#                                       #             
	#          ####    ## ##   #####        #      ###    
	 ##       #    #  #  #  #   #   #       #     #   #   
	   ##          #  #  #  #   #    #      #    #     #  
	     #     #####  #  #  #   #    #      #    #######  
	#     #   #    #  #  #  #   #    #      #    #        
	#     #  #     #  #  #  #   #    #      #    #        
	#     #  #     #  #  #  #   #   #       #    #     #  
	##   #   #    ##  #  #  #   ####        #     #    #  
	# ###     #### ## ## ## ##  #       ########   ####   
	                            #                         
	                           ####                       


**heart_left**

	 .-.-. .-.-. .-.-. .-.-. .-.-. .-.-. 
	( S .'( a .'( m .'( p .'( l .'( e .' 
	 `.(   `.(   `.(   `.(   `.(   `.(   
	                                     


**heart_right**

	.-.-. .-.-. .-.-. .-.-. .-.-. .-.-.  
	'. S )'. a )'. m )'. p )'. l )'. e ) 
	  ).'   ).'   ).'   ).'   ).'   ).'  
                                     


**heavy_me**

	 #####   #######  #### #####            #  # # 
	##   ## #               # #             ####   
	###                               ###          
	  ###    ####                #                 
	    ###                 ####           ######  
	##   ##                           ###          
	 #####   ## #                                  
	                        ## #          ######## 


**helvb**
                                                             
	                        #      
	 ####                   #      
	##    ###   ### #  ###  #  ##  
	####    ##  ## # # ## # # ## # 
	  ### ####  ## # # ## # # #### 
	## ## # ##  ## # # ## # # ##   
	 ###  ## ## ## # # ###  #  ##  
	                   ##          
                               


**helvbi**

                                                                                                               
	  ###                        #       
	 ## ##  ###   ### #    ###   #   ##  
	 ###      ##  ######   # ##  #  ## # 
	  ###   ####  # # ##  ## ##  # ##### 
	## ##  ## #  ## # #   ####  #  ##    
	 ###   ##### ## # #   ###   #   ###  
	                     ##              
                                     


**helv**
                                                      
	                     #     
	 ###                 #     
	#    ##   ####  ###  #  #  
	###    #  # # # #  # # # # 
	   # ###  # # # #  # # ### 
	   # # #  # # # #  # # #   
	###  ## # # # # ###  #  ## 
	                #          
                           


**helvi**

                                  
                                  
	                           #      
	  ###                      #      
	 #   #  ##   ## ##   ##   #    ## 
	 ###      #  # # #   # #  #   # # 
	   ##   ### # # #   #  #  #  ###  
	#   #  # #  # # #   # #  #   #    
	 ###   #### # # #   ##   #    ##  
	                   #              
	                   #              


**henry3d**

	   ___                                   __           
	  F __".   ___ _    _ _____     _ ___    LJ    ____   
	 J (___|  F __` L  J '_  _ `,  J '__ J   FJ   F __ J  
	 J\___ \ | |--| |  | |_||_| |  | |--| | J  L | _____J 
	.--___) \F L__J J  F L LJ J J  F L__J J J  L F L___--.
	J\______J\____,__LJ__L LJ J__LJ  _____/LJ__LJ\______/F
	 J______FJ____,__F|__L LJ J__||_J_____F |__| J______F 
	                              L_J                     


**heroboti**

	                  ##### # # # #### # # # ## # # # #  
	  ###             ##### # # # #### # # # ## # # # #  
	 ##               ### # # # # # ## # # # ## # # # #  
	 ######           ### # # # # # ## # # # ## # # # #  
	  ###### ##       ### # # # # # ## # # # ## # # # ## 
	      ## ####     ### # # # # # ## # # # ## # # #### 
	 ####### # ####   ### # # # # # ## # # #### # #####  
	 ######  # # #### ### # # # # # ## # # #### ##### #  


**hex**

	53 61 6D 70 6C 65 


**hieroglyphs**

	,-. ,-~~\    ,-==.           ,-.       ,-.            
	| |  (   \    (  (\         <,- \_____/  `         || 
	| '   |\. \    |\.\\   __     /  ___. \   ....     || 
	|    _]_]`\\  _]_]`\\ |__| ,_(__/ ,_(__\  `=.`''===.' 


**high_noo**

	######## #   ##   # #   #     # #           # ## ##  
	         #    # # # #   # # # # #             #      
	  #####       #   # # # # # # # #           #    # # 
	#######  #    #   #   # # # # # #           ###  ##  
	#######  #  ##### #   # #     # #    ###### #   ## # 
	  #####  # ## # # # # # # # # # #    ###### # ##     
	   ####       # # # # # # # # # #           # #####  
	#      # # # ##  ######## # ######               #   


**hills___**

	     #         # #           #       
	   # # #       # #          # ##     
	   # # ###   # # #        # ## ###   
	   # ##  # ### # #       #  ##### ## 
	   ##  ### # # # #     #  # ### ###  
	   ## # #  ### # #   #  ##  # ### ## 
	  # #  ##  # ### # # # #  # # # ###  
	  # # # #  ### ### # # # #  ### # #  


**hollywood**

	           _                                              
	         /' `\                                        /'  
	       /'   ._)                                     /'    
	      (____    ____     ,__________      ____     /' ____ 
	           ) /'    )   /'    )     )   /'    )--/' /'    )
	         /'/'    /'  /'    /'    /'  /'    /' /' /(___,/' 
	(_____,/' (___,/(__/'    /'    /(__/(___,/'  (__(________ 
	                                 /'                       
	                               /'                         
	                             /'                           


**home_pak**

	   ##                                            
	   ##      ###   ##   ## ######  ####    ####### 
	   ##     #####  ### ### ### ### ####    # ##    
	######## ### ### ####### ### ### ####    ######  
	######## ### ### ####### ######  # ##    ####    
	   ##    ####### ### ### ###     ####    ####    
	   ##    ### ### ### ### ###     ####### ####### 
	   ##                                            


**horizontalleft**

	      __    ______   _______   _______   _______   _______  
	 .-. \  \ .`  _ ._| `._   __| / ___ __| /______ \ | ._ _. | 
	/ _ \_\ | \  \_||_   _<  <__  | \_/ |         / | | \ v / | 
	|_\`.___/  `._____| /_______| `.___.`         \_| |_/   \_| 
                                                            
                                                            


**horizontalright**

	 __        ______    _______   _______   _______   _______  
	/  / .-.  |_. _  '. |__   _.' |__ ___ \ / ______\ | ._ _. | 
	| /_/ _ \  _||_/  /  __>  >_    | \_/ | | \       | \ v / | 
	\___.'/_| |_____.'  |_______\   '.___.' |_/       |_/   \_| 
                                                            
                                                            


**house_of**

	            # # # # #           # # # #  ##    ## 
	   #####    # # # # #    ####   # # # #  ######## 
	  ##        # ######## ######## # # # ##  #    ## 
	   ###      # ######## ######## # # #### ##    ## 
	     ## ##  # ########   ###### # # #### ##    ## 
	 ##  ## ## ## ########   ###### # # #### ######## 
	 #####   ###  ########     #### # # #### ##    ## 
	              ########       ## # # #### ##    ## 


**hypa_bal**

	###### # ##  ##  #  ##      # ##  # # ## # # #      
	##     ##  #       ##  # # # ## #  ## #       # ### 
	##     ### #       ## ##  ## ####    ### # # # ## # 
	######   #      #   ## #    ### # ## #      ## # #  
	    ##   #  #        #     ##         #  #    ### # 
	    ##    ### # ## # #      # ##  #   ## # ####     
	###### #  #   # # # #  # # # ## #  ## ## #     # #  
	       # ##  ## #######   ## ###     ### # ##  ###  


**hyper___**

	 ####      #  ##  ######## ##                
	##  ##    ### ### ######## ##       ######## 
	##       ##### ###      ## ##       ######## 
	 #####  ####### ###     ## ##                
	     ## #######  ###    ## ##                
	##   ##   ###     ###   ## ##                
	 #####   #####     ###  ## ########          
	                    ##  ## ########          


**ICL-1900**

	Sample
	 *   *
	  *** 
	*     
	 *    
	*     
	    * 
	  *   
	     *
      
	   *  
      
      


**impossible**

	        _            _                  _   _         _          _             _      
	       / /\         / /\               /\_\/\_\ _    /\ \       _\ \          /\ \    
	      / /  \       / /  \             / / / / //\_\ /  \ \     /\__ \        /  \ \   
	     / / /\ \__   / / /\ \           /\ \/ \ \/ / // /\ \ \   / /_ \_\      / /\ \ \  
	    / / /\ \___\ / / /\ \ \         /  \____\__/ // / /\ \_\ / / /\/_/     / / /\ \_\ 
	    \ \ \ \/___// / /  \ \ \       / /\/________// / /_/ / // / /         / /_/_ \/_/ 
	     \ \ \     / / /___/ /\ \     / / /\/_// / // / /__\/ // / /         / /____/\    
	 _    \ \ \   / / /_____/ /\ \   / / /    / / // / /_____// / / ____    / /\____\/    
	/_/\__/ / /  / /_________/\ \ \ / / /    / / // / /      / /_/_/ ___/\ / / /______    
	\ \/___/ /  / / /_       __\ \_\\/_/    / / // / /      /_______/\__\// / /_______\   
	 \_____\/   \_\___\     /____/_/        \/_/ \/_/       \_______\/    \/__________/   
                                                                                      


**inc_raw_**

	 ##### ##     # ## ###   ##     # ## ##### ##     # 
	##  ## #  ##  # #   #    #  ##  # #  ##### #  ##### 
	##     #  ##  # #        #  ##  # #  ##### #  ##### 
	 ####  #      # #  # #   #  ##  # #  ##### #    ### 
	    ## #  ##  # #  ###   #     ## #  ##### #  ##### 
	    ## #  ##  # #  ###   #  ##### #  ##### #  ##### 
	##  ## #  ##  # #  ###   #  ##### #  ##### #  ##### 
	#####  #  ## ## #  ### # #  ##### #     ## #     ## 


**invita**

	      __                  
	  (__/  )            /)   
	    /  _  ___  __   //  _ 
	 ) /  (_(_// (_/_)_(/__(/_
	(_/         .-/           
	           (_/            


**isometric1**

	      ___           ___           ___           ___           ___       ___     
	     /\  \         /\  \         /\__\         /\  \         /\__\     /\  \    
	    /::\  \       /::\  \       /::|  |       /::\  \       /:/  /    /::\  \   
	   /:/\ \  \     /:/\:\  \     /:|:|  |      /:/\:\  \     /:/  /    /:/\:\  \  
	  _\:\~\ \  \   /::\~\:\  \   /:/|:|__|__   /::\~\:\  \   /:/  /    /::\~\:\  \ 
	 /\ \:\ \ \__\ /:/\:\ \:\__\ /:/ |::::\__\ /:/\:\ \:\__\ /:/__/    /:/\:\ \:\__\
	 \:\ \:\ \/__/ \/__\:\/:/  / \/__/~~/:/  / \/__\:\/:/  / \:\  \    \:\~\:\ \/__/
	  \:\ \:\__\        \::/  /        /:/  /       \::/  /   \:\  \    \:\ \:\__\  
	   \:\/:/  /        /:/  /        /:/  /         \/__/     \:\  \    \:\ \/__/  
	    \::/  /        /:/  /        /:/  /                     \:\__\    \:\__\    
	     \/__/         \/__/         \/__/                       \/__/     \/__/    
	

**isometric2**
	
	      ___           ___           ___           ___                       ___     
	     /\__\         /\  \         /\  \         /\  \                     /\__\    
	    /:/ _/_       /::\  \       |::\  \       /::\  \                   /:/ _/_   
	   /:/ /\  \     /:/\:\  \      |:|:\  \     /:/\:\__\                 /:/ /\__\  
	  /:/ /::\  \   /:/ /::\  \   __|:|\:\  \   /:/ /:/  /  ___     ___   /:/ /:/ _/_ 
	 /:/_/:/\:\__\ /:/_/:/\:\__\ /::::|_\:\__\ /:/_/:/  /  /\  \   /\__\ /:/_/:/ /\__\
	 \:\/:/ /:/  / \:\/:/  \/__/ \:\~~\  \/__/ \:\/:/  /   \:\  \ /:/  / \:\/:/ /:/  /
	  \::/ /:/  /   \::/__/       \:\  \        \::/__/     \:\  /:/  /   \::/_/:/  / 
	   \/_/:/  /     \:\  \        \:\  \        \:\  \      \:\/:/  /     \:\/:/  /  
	     /:/  /       \:\__\        \:\__\        \:\__\      \::/  /       \::/  /   
	     \/__/         \/__/         \/__/         \/__/       \/__/         \/__/    


**isometric3**

	      ___           ___           ___           ___                       ___     
	     /  /\         /  /\         /__/\         /  /\                     /  /\    
	    /  /:/_       /  /::\       |  |::\       /  /::\                   /  /:/_   
	   /  /:/ /\     /  /:/\:\      |  |:|:\     /  /:/\:\  ___     ___    /  /:/ /\  
	  /  /:/ /::\   /  /:/~/::\   __|__|:|\:\   /  /:/~/:/ /__/\   /  /\  /  /:/ /:/_ 
	 /__/:/ /:/\:\ /__/:/ /:/\:\ /__/::::| \:\ /__/:/ /:/  \  \:\ /  /:/ /__/:/ /:/ /\
	 \  \:\/:/~/:/ \  \:\/:/__\/ \  \:\~~\__\/ \  \:\/:/    \  \:\  /:/  \  \:\/:/ /:/
	  \  \::/ /:/   \  \::/       \  \:\        \  \::/      \  \:\/:/    \  \::/ /:/ 
	   \__\/ /:/     \  \:\        \  \:\        \  \:\       \  \::/      \  \:\/:/  
	     /__/:/       \  \:\        \  \:\        \  \:\       \__\/        \  \::/   
	     \__\/         \__\/         \__\/         \__\/                     \__\/    


**isometric4**

	      ___           ___           ___                         ___       ___     
	     /  /\         /  /\         /  /\          ___          /  /\     /  /\    
	    /  /::\       /  /::\       /  /::|        /  /\        /  /:/    /  /::\   
	   /__/:/\:\     /  /:/\:\     /  /:|:|       /  /::\      /  /:/    /  /:/\:\  
	  _\_ \:\ \:\   /  /::\ \:\   /  /:/|:|__    /  /:/\:\    /  /:/    /  /::\ \:\ 
	 /__/\ \:\ \:\ /__/:/\:\_\:\ /__/:/_|::::\  /  /::\ \:\  /__/:/    /__/:/\:\ \:\
	 \  \:\ \:\_\/ \__\/  \:\/:/ \__\/  /~~/:/ /__/:/\:\_\:\ \  \:\    \  \:\ \:\_\/
	  \  \:\_\:\        \__\::/        /  /:/  \__\/  \:\/:/  \  \:\    \  \:\ \:\  
	   \  \:\/:/        /  /:/        /  /:/        \  \::/    \  \:\    \  \:\_\/  
	    \  \::/        /__/:/        /__/:/          \__\/      \  \:\    \  \:\    
	     \__\/         \__\/         \__\/                       \__\/     \__\/    



**italic**
	
	  __          
	 (  _ _    /_ 
	__)(///)/)((- 
	       /      


**italics_**
	
	             # ##   # #####  #   # ####  
	            ##  ## ##   #  # #     #     
	     #     # #  # # #   #  # #    #      
	    # #   #  #  # # #  #### #    ####    
	   #  # ###### # # #   #    #     # #    
	  #   #  #   # #   #  #     #    #       
	 # ###  #    # #   ## #   ###### #####   
                                         


**ivrit**

	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 	_                       ____  
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             	___| |_ __  _ __ ___   __ _/ ___| 
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            / 	_ \ | '_ \| '_ ` _ \ / _` \___ \ 
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           	|  __/ | |_) | | | | | | (_| |___) |
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            	\___|_| .__/|_| |_| |_|\__,_|____/ 
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  	|_|                          


**jacky**

	  _____     ____       __    __     _____    _____        _____  
	 / ____\   (    )      \ \  / /    (  __ \  (_   _)      / ___/  
	( (___     / /\ \      () \/ ()     ) )_) )   | |       ( (__    
	 \___ \   ( (__) )     / _  _ \    (  ___/    | |        ) __)   
	     ) )   )    (     / / \/ \ \    ) )       | |   __  ( (      
	 ___/ /   /  /\  \   /_/      \_\  ( (      __| |___) )  \ \___  
	/____/   /__(  )__\ (/          \) /__\     \________/    \____\ 
                                                                 


**jazmine**

                                      
	.oPYo.                       8        
	8                            8        
	`Yooo. .oPYo. ooYoYo. .oPYo. 8 .oPYo. 
	    `8 .oooo8 8' 8  8 8    8 8 8oooo8 
	     8 8    8 8  8  8 8    8 8 8.     
	`YooP' `YooP8 8  8  8 8YooP' 8 `Yooo' 
	:.....::.....:..:..:..8 ....:..:.....:
	::::::::::::::::::::::8 ::::::::::::::
	::::::::::::::::::::::..::::::::::::::
                                 

**jiskan16**

	                                                      
	  ## #                               ####             
	 #  ##                                  #             
	#    #                                  #             
	#                                       #             
	#          ####    ## ##   #####        #      ###    
	 ##       #    #  #  #  #   #   #       #     #   #   
	   ##          #  #  #  #   #    #      #    #     #  
	     #     #####  #  #  #   #    #      #    #######  
	#     #   #    #  #  #  #   #    #      #    #        
	#     #  #     #  #  #  #   #    #      #    #        
	#     #  #     #  #  #  #   #   #       #    #     #  
	##   #   #    ##  #  #  #   ####        #     #    #  
	# ###     #### ## ## ## ##  #       ########   ####   
	                            #                         
	                           ####                       


**joust___**

	# # #  #  # #####                      #### # # 
	#  ##  # ####                           # # ### 
	 # ## #                                ######## 
	 # # # #                                        
	########          ######## ######## ##          
	##                ## ## #   # # # # ##          
	                  ## ## #   # # # # ##          
	########  # # # #                       # # # # 


**JS_Block_Letters**

	  ____   ____   __  __ _____  _     ____ 
	 (_ (_` / () \ |  \/  || ()_)| |__ | ===|
	.__)__)/__/\__\|_|\/|_||_|   |____||____|


**JS_Bracket_Letters**

	 .----.  .--.  .-.   .-..----. .-.   .----.
	{ {__   / {} \ |  `.'  || {}  }| |   | {_  
	.-._} }/  /\  \| |\ /| || .--' | `--.| {__ 
	`----' `-'  `-'`-' ` `-'`-'    `----'`----'


**JS_Capital_Curves**

	 ____  ___,   _____,   ___, __    ____,
	(-(__`(-|_\_,(-| | |  (-|_)(-|   (-|_, 
	 ____) _|  )  _| | |_, _|   _|__, _|__,
	(     (      (        (    (     (     


**JS_Cursive**
	
                           _    
	  ,   __,   ,____,  ,_    //  _ 
	_/_)_(_/(__/ / / (__/_)__(/__(/_
	                   /            
	                  /             
                                


**JS_Stick_Letters**

	 __              __        ___ 
	/__`  /\   |\/| |__) |    |__  
	.__/ /~~\  |  | |    |___ |___ 
                               


**katakana**
	
	  ######   #        #########    # #                           
	           #   ###          #    # #       ######   ########## 
	########## ####             #    # #           #            #  
	     #     #        ########     # #   #      #            #   
	     #     #               #    #  #  #       #         # #    
	    #      #               #   #   # #   ##########      #     
	  ##        ####### ########  #    ##                     #    
                                                               


**kban**

	 .|'''.|                              '||          
	 ||..  '   ....   .. .. ..   ... ...   ||    ....  
	  ''|||.  '' .||   || || ||   ||'  ||  ||  .|...|| 
	.     '|| .|' ||   || || ||   ||    |  ||  ||      
	|'....|'  '|..'|' .|| || ||.  ||...'  .||.  '|...' 
	                              ||                   
	                             ''''                  


**keyboard**

                                                 
	 _______ _______ _______ _______ _______ _______ 
	|\     /|\     /|\     /|\     /|\     /|\     /|
	| +---+ | +---+ | +---+ | +---+ | +---+ | +---+ |
	| |   | | |   | | |   | | |   | | |   | | |   | |
	| |S  | | |a  | | |m  | | |p  | | |l  | | |e  | |
	| +---+ | +---+ | +---+ | +---+ | +---+ | +---+ |
	|/_____\|/_____\|/_____\|/_____\|/_____\|/_____\|
                                                 


**kgames_i**

	                 ### #  # ### # #  ### #  #          
	  ####           ### #  # ### # #  ### #  #          
	 ##              ### #  # ## # # # ### #  #          
	  ####           ### #  #  # # # # ### #  #          
	     ## ######## ### #  #          ### #  # ######## 
	     ## ######## ### # ##          ### #  # ###### # 
	  ####  # # # #  ### # #           ### #  # # # #  # 
	        # # # #  ### # #           ### #  # # # #  # 


**kik_star**

	 ####   ##### ### #  ####         ###      
	##  ##  ####  ## # #  ####         ##    # 
	##      # ##  ### #  # ###        ###    # 
	 #####   ##   ## # #  # ###   #    ##   ## 
	     ## ###  ## # #  # # ###  #   ###  ### 
	##   ##  ##  ####### #######  ##   ##  ### 
	 #####  ### ######## ######## ### ### ###  
	         ##                    ##  ##### # 


**knob**

	 _   _____  _________  _________  _________  _________  _________ 
	( ) (  _  )(____  _  )(______   )(___   _  )(  _______)(  _   _  )
	| |_| | | | ___| |_| | _____(   )    | |_| || |        | | | | | |
	(_____) (_)(_________)(_________)    (_____)(_)        (_) (_) (_)
	

**konto**
	
	/.^. IVI I..I   I.` 
	..7 I^I I I IL.. I.. 


**kontoslant**
	
	 / /1  /1/1   /  /
	../  ///   1 /. /..  


**krak_out**

	          # #   ## ### # ########    # # #    # #   
	  ##### #     # #### ###     ##    #   #    ##### # 
	 ##   #  ####   #### ###  #     #           ##### # 
	##     ######## ## ### #     ##     ######    # #   
	#######  ####    ####### ######## ##        #     # 
	      # #     # ## ### #     ##        #   ## # ### 
	#######   # #   #### ###  #     #    # # # ## # ### 
	        # # # # #### ###     ##    # # # #  #     # 


**l4me**

	54mp|3

**Larry_3D_2**

	 ____                                 ___             
	/\  _`\                              /\_ \            
	\ \,\L\_\     __      ___ ___   _____\//\ \      __   
	 \/_\__ \   /'__`\  /' __` __`\/\ '__`\\ \ \   /'__`\ 
	   /\ \L\ \/\ \L\.\_/\ \/\ \/\ \ \ \L\ \\_\ \_/\  __/ 
	   \ `\____\ \__/.\_\ \_\ \_\ \_\ \ ,__//\____\ \____\
	    \/_____/\/__/\/_/\/_/\/_/\/_/\ \ \/ \/____/\/____/
	                                  \ \_\               
	                                   \/_/               


**larry3d**

	 ____                                 ___             
	/\  _`\                              /\_ \            
	\ \,\L\_\     __      ___ ___   _____\//\ \      __   
	 \/_\__ \   /'__`\  /' __` __`\/\ '__`\\ \ \   /'__`\ 
	   /\ \L\ \/\ \L\.\_/\ \/\ \/\ \ \ \L\ \\_\ \_/\  __/ 
	   \ `\____\ \__/.\_\ \_\ \_\ \_\ \ ,__//\____\ \____\
	    \/_____/\/__/\/_/\/_/\/_/\/_/\ \ \/ \/____/\/____/
	                                  \ \_\               
	                                   \/_/               


**lazy_jon**

	 #####                  ##  ##            ###    
	##   ##                 ##  ##            ###    
	##           ###  #####  ##  ##  #####   ###     
	 #####       ### ####### ##  ## #######  ###     
	     ##     ###  ##   ## ##  ## ##   ## #######  
	##   ##     ###  ##   ## ##  ## ##      #######  
	##   ##    ###    ##             ##              
	 #####     ###     ###            ####           
	

**lcd**

	 ___               _                
	|                 | |     |         
	 -+-   -    |- -  |-      +    -    
	    | | |   | | | |       |   |/    
	 ---   --                 -    --   
                                    


**lean**

                                                               
	      _/_/_/                                      _/           
	   _/          _/_/_/  _/_/_/  _/_/    _/_/_/    _/    _/_/    
	    _/_/    _/    _/  _/    _/    _/  _/    _/  _/  _/_/_/_/   
	       _/  _/    _/  _/    _/    _/  _/    _/  _/  _/          
	_/_/_/      _/_/_/  _/    _/    _/  _/_/_/    _/    _/_/_/     
	                                   _/                          
	                                  _/                           


**letters**

	 SSSSS                              lll        
	SS        aa aa mm mm mmmm  pp pp   lll   eee  
	 SSSSS   aa aaa mmm  mm  mm ppp  pp lll ee   e 
	     SS aa  aaa mmm  mm  mm pppppp  lll eeeee  
	 SSSSS   aaa aa mmm  mm  mm pp      lll  eeeee 
	                            pp                 


**letterw3**

	 ####      #  ##  ######## ##                
	##  ##    ### ### ######## ##       ######## 
	##       ##### ###      ## ##       ######## 
	 #####  ####### ###     ## ##                
	     ## #######  ###    ## ##                
	##   ##   ###     ###   ## ##                
	 #####   #####     ###  ## ########          
	                    ##  ## ########          


**letter_w**

	 #######    #  ##  ######## ##                
	      ##   ### ### ######## ##       ######## 
	  ##       #### ###      ## ##       ######## 
	  ###### ####### ###     ## ##                
	      ## #######  ###    ## ##                
	  ##  ##   ###     ###   ## ##                
	  ######  #####     ###  ## ########          
	                     ##  ## ########          


**lexible_**

	 ####                
	 ###                 
	  ###                
	   ###               
	    ###              
	#######              
	######               
                     


**lildevil**

	 (`-').-> (`-')  _ <-. (`-')   _  (`-')          (`-')  _ 
	 ( OO)_   (OO ).-/    \(OO )_  \-.(OO )   <-.    ( OO).-/ 
	(_)--\_)  / ,---.  ,--./  ,-.) _.'    \ ,--. )  (,------. 
	/    _ /  | \ /`.\ |   `.'   |(_...--'' |  (`-') |  .---' 
	\_..`--.  '-'|_.' ||  |'.'|  ||  |_.' | |  |OO )(|  '--.  
	.-._)   \(|  .-.  ||  |   |  ||  .___.'(|  '__ | |  .--'  
	\       / |  | |  ||  |   |  ||  |      |     |' |  `---. 
	 `-----'  `--' `--'`--'   `--'`--'      `-----'  `------' 


**Lil_Devil**

	 (`-').-> (`-')  _ <-. (`-')   _  (`-')          (`-')  _ 
	 ( OO)_   (OO ).-/    \(OO )_  \-.(OO )   <-.    ( OO).-/ 
	(_)--\_)  / ,---.  ,--./  ,-.) _.'    \ ,--. )  (,------. 
	/    _ /  | \ /`.\ |   `.'   |(_...--'' |  (`-') |  .---' 
	\_..`--.  '-'|_.' ||  |'.'|  ||  |_.' | |  |OO )(|  '--.  
	.-._)   \(|  .-.  ||  |   |  ||  .___.'(|  '__ | |  .--'  
	\       / |  | |  ||  |   |  ||  |      |     |' |  `---. 
	 `-----'  `--' `--'`--'   `--'`--'      `-----'  `------' 


**lineblocks**

	 ______   ______   _________   ______   _        ______ 
	/ |      | |  | | | | | | | \ | |  | \ | |      | |     
	'------. | |__| | | | | | | | | |__|_/ | |   _  | |---- 
	 ____|_/ |_|  |_| |_| |_| |_| |_|      |_|__|_| |_|____ 
                                                        


**linux**

	.---..---..-.-.-..---..-.   .---.
	 \ \ | | || | | || |-'| |__ | |- 
	`---'`-^-'`-'-'-'`-'  `----'`---'
                                 
**lockergnome**
	
	.:::::|               :|      
	`:::::>.::\ :\/| :::\ :| :~~/ 
	,::::/ `::| :::| :::/ :| :::, 
	                 :|           


**mad_nurs**

	 #####  ##   ##  #   ## #######  #   ## ##   ##  
	##   ## ##   ## ##   ## ####### ##   ## ##   ##  
	##      ##   ## ##   ##    ##   ##   ## ##   ##  
	 #####  ##   ## ##   ##    ##   ##   ## ##   ##  
	     ## ##   ##  #   ##    ##    #   ## ##   ##  
	     ## ##   ## ##   ##    ##   ##   ## ##   ##  
	##   ## ######  ##   ##    ##   ####### ######   
	 #####   # ###  ##   ##    ##   ####### ######   


**madrid**

	/=\               |      
	 \  /=| /=\=\ |=\ |  /=\ 
	\=/ \=| | | | |=/ \= \=  
	              |          


**magic_ma**

	        #       ## # #   #### # # #######    ##### 
	 ##### ## #     ## #       ## # # #######    ###   
	#######   #     #### #     ## # #   #####  #####   
	###      ## #   #### #   ###### #   #####  ###     
	######      #   #### #       ####   ##### ####     
	#######    ## # #### #     ##  ##   ##### ##       
	  #####       # ###### #          #######          
	######       ##  # # # #   ##     # # # #          


**marquee**

	  .:: ::                                  .::          
	.::    .::                                .::          
	 .::         .::    .::: .:: .:: .: .::   .::   .::    
	   .::     .::  .::  .::  .:  .::.:  .::  .:: .:   .:: 
	      .:: .::   .::  .::  .:  .::.:   .:: .::.::::: .::
	.::    .::.::   .::  .::  .:  .::.:: .::  .::.:        
	  .:: ::    .:: .:::.:::  .:  .::.::     .:::  .::::   
	                                 .::                   


**master_o**

	   #### ######## # ### ######## #####      ### 
	  ##  # ######## # ### ######## #####      ### 
	 ##     # # # #  ##  # ######## ######     ### 
	  ####   #   #   ##### ######## ###### #  #### 
	     ##          ##### ######## ##### # ###### 
	 #  ##           ##### ######## ######    #### 
	 ####            ##### ######## #####      ### 
	                 ##### ######## #####      ### 


**maxfour**

	/~~\                 |   
	'--./~~||/~\ /~\ |~~\|/~/
	\__/\__||   |   ||__/|\/_
	                 |       


**maxiwi**

	                  █      
	███               █      
	█   ███ █████ ███ █  ███ 
	 █    █ █ █ █ █ █ █  ███ 
	  █ ███ █ █ █ █ █ █  █   
	███ ███ █ █ █ ███ ██ ███ 
	              █          
	              █          


**mayhem_d**

	  ######  # # #               
	 ##       ##  # #             
	 ##      # #####              
	  #####  ##### ##    ##       
	      ## ### ###     ##       
	      ## # ### #     ##       
	 ######  ### #  #    ####     
	         # #  ##     # ##     


**mcg_____**

	        #          # # # ##       # #      
	             #     #   #      #  ##      # 
	  #####  #  ##  #       # #  #      #      
	 ###   # #  ##      #   #  #     ##      # 
	  ##### #        ##  #      # #  #     ### 
	 #   ###   ##   #        #  #     #      # 
	  #####   #### # # #     ###     ##   #  # 
	          ##   # #  #     # #  # ##   ###  


**merlin1**

	  ________     __       ___      ___    _______   ___       _______  
	 /"       )   /""\     |"  \    /"  |  |   __ "\ |"  |     /"     "| 
	(:   \___/   /    \     \   \  //   |  (. |__) :)||  |    (: ______) 
	 \___  \    /' /\  \    /\\  \/.    |  |:  ____/ |:  |     \/    |   
	  __/  \\  //  __'  \  |: \.        |  (|  /      \  |___  // ___)_  
	 /" \   :)/   /  \\  \ |.  \    /:  | /|__/ \    ( \_|:  \(:      "| 
	(_______/(___/    \___)|___|\__/|___|(_______)    \_______)\_______) 
	                                                                     


**merlin2**

	    _        _       _              _         _           _      
	   /\\__  __/\\__  _/\\___ _____  _/\\___   _/\\_      __/\\___  
	  /    \\(_  ____)(_      v    ))(_   _ _))(_  _))    (_  ____)) 
	 _\  \_// /  _ \\  /  :   <\   \\ /  |))\\  /  \\      /  ._))   
	// \:.\  /:./_\ \\/:. |   //   ///:. ___// /:.  \\__  /:. ||___  
	\\__  /  \  _   //\___|  //\  // \_ \\     \__  ____))\  _____)) 
	   \\/    \// \//      \//  \//    \//        \//      \//       
                                                                 
                                                                 
**mig_ally**

	  ####           ########    ##### # # #### # # # #  
	 ##  ##          ########  ####### # # #### # # # #  
	 ##              ########  #####   # # #### # # # ## 
	  ####           ########  ####    # # # ## # # #### 
	     ##  # # # # ########  #####   # # # ## # # #### 
	 ##  ##  # # # # ########  ####### # # # ## # # #### 
	  ####   # # # # # ######    ##### # # # #  # # # ## 
	         # # # # # # ####          # # # #  # # # #  


**mike**

	                |  _
	 // //| ||\ |\  | |/
	            |       


**mini**

	 __                
	(_  _.._ _ ._ | _  
	__)(_|| | ||_)|(/_ 
	           |       


**miniwi**
	
	▄▖       ▜   
	▚ ▀▌▛▛▌▛▌▐ █▌
	▄▌█▌▌▌▌▙▌▐▖▙▖
	       ▌     


**mnemonic**

	Sample

**modern__**

	#######   #  ##  ######## ##                
	###  ##  ### ### ######## ##       ######## 
	 ###  # ##### ###      ## ##       ######## 
	  ###  ####### ###     ## ##                
	#  ### #######  ###    ## ##                
	##  ###  ###     ###   ## ##                
	####### #####     ###  ## ########          
	                   ##  ## ########          


**modular**

	 _______  _______  __   __  _______  ___      _______ 
	|       ||   _   ||  |_|  ||       ||   |    |       |
	|  _____||  |_|  ||       ||    _  ||   |    |    ___|
	| |_____ |       ||       ||   |_| ||   |    |   |___ 
	|_____  ||       ||       ||    ___||   |___ |    ___|
	 _____| ||   _   || ||_|| ||   |    |       ||   |___ 
	|_______||__| |__||_|   |_||___|    |_______||_______|
	

**morse2**

	... .- -- .--. .-.. . 


**morse**

	... .- -- .--. .-.. . 


**moscow**

                                    
	 ####   #   #   # ##### ##### ##### 
	#      # #  ## ## #   #  #  # #     
	#     ##### # # # #   #  #  # ####  
	#     #   # #   # #   #  #  # #     
	 #### #   # #   # #   # #   # ##### 


**muzzle**

	     __                  __ 
	|<< |  | |\ /| |<<' |   |   
	--  |><| | < | |>>| |   |<< 
	>>| |  | |   | |    |<< |__ 


**nancyj-fancy**
	
	MP""""""`MM                              dP          
	M  mmmmm..M                              88          
	M.      `YM .d8888b. 88d8b.d8b. 88d888b. 88 .d8888b. 
	MMMMMMM.  M 88'  `88 88'`88'`88 88'  `88 88 88ooood8 
	M. .MMM'  M 88.  .88 88  88  88 88.  .88 88 88.  ... 
	Mb.     .dM `88888P8 dP  dP  dP 88Y888P' dP `88888P' 
	MMMMMMMMMMM                     88                   
	                                dP                   


**nancyj**

	.d88888b                               dP          
	88.    "'                              88          
	`Y88888b. .d8888b. 88d8b.d8b. 88d888b. 88 .d8888b. 
	      `8b 88'  `88 88'`88'`88 88'  `88 88 88ooood8 
	d8'   .8P 88.  .88 88  88  88 88.  .88 88 88.  ... 
	 Y88888P  `88888P8 dP  dP  dP 88Y888P' dP `88888P' 
	                              88                   
	                              dP                   


**nancyj-improved**

	.d88888b                               dP          
	88.    "'                              88          
	`Y88888b. .d8888b. 88d8b.d8b. 88d888b. 88 .d8888b. 
	      `8b 88'  `88 88'`88'`88 88'  `88 88 88ooood8 
	d8'   .8P 88.  .88 88  88  88 88.  .88 88 88.  ... 
	 Y88888P  `88888P8 dP  dP  dP 88Y888P' dP `88888P' 
	                              88                   
	                              dP                   


**nancyj-underlined**

	.d88888b                                dP          
	88.    "'                               88          
	`Y88888b. .d8888b. 88d8b.d8b.  88d888b. 88 .d8888b. 
	      `8b 88'  `88 88'`88'`88  88'  `88 88 88ooood8 
	d8'   .8P 88.  .88 88  88  88  88.  .88 88 88.  ... 
	 Y88888P  `88888P8 dP  dP  dP  88Y888P' dP `88888P' 
	oooooooooooooooooooooooooooooo~88~oooooooooooooooooo
	                               dP                   


**new_asci**

	           ##   ##   ## ###### ####    ####### 
	          ####  ### ###  ##  ## ##      ##   # 
	  #####  ##  ## #######  ##  ## ##      ## #   
	 ##      ##  ## #######  #####  ##      ####   
	  #####  ###### ## # ##  ##     ##   #  ## #   
	      ## ##  ## ##   ##  ##     ##  ##  ##   # 
	 ######  ##  ## ##   ## ####   ####### ####### 
                                               


**nfi1____**

	####  ####                ####   ####   
	##      ####         ## ####     ####   
	##    ####         ####   ####   ####   
	##    ##           ####   ####          
	##      ######     #### ####            
	##      ####         ## ####            
	      ########            ####          
                                        


**nipples**

	  {__ __                                  {__          
	{__    {__                                {__          
	 {__         {__    {___ {__ {__ {_ {__   {__   {__    
	   {__     {__  {__  {__  {_  {__{_  {__  {__ {_   {__ 
	      {__ {__   {__  {__  {_  {__{_   {__ {__{_____ {__
	{__    {__{__   {__  {__  {_  {__{__ {__  {__{_        
	  {__ __    {__ {___{___  {_  {__{__     {___  {____   
	                                 {__                   


**notie_ca**

	### ######## # ######              ## #          
	### ######## # ####    # #####                   
	### ######## # ####   ##  #                    # 
	### ######## # ####                              
	### ######## # #         ## #  #######         # 
	### ######## ##  # ##          # #### #    ## ## 
	### ######## # ###             ######## # ##     
	 #  ######## ##  # ##          # #####  # ##     


**npn_____**

                                                   
	                                   ###             
	    #### ######## ##   ## #######  ###    ######## 
	   ###         ## ### ###       ## ###             
	   ###    ####### #######  ######  ###     ####### 
	   ###    ###  ## ## # ##  ###     ###     ###     
	#####     ###  ## ##   ##  ###     ####### ####### 
	                  ##                               


**nscript**

	      ,gg,                                                              
	     i8""8i                                              ,dPYb,         
	     `8,,8'                                              IP'`Yb         
	      `88'                                               I8  8I         
	      dP"8,                                              I8  8'         
	     dP' `8a    ,gggg,gg   ,ggg,,ggg,,ggg,   gg,gggg,    I8 dP   ,ggg,  
	    dP'   `Yb  dP"  "Y8I  ,8" "8P" "8P" "8,  I8P"  "Yb   I8dP   i8" "8i 
	_ ,dP'     I8 i8'    ,8I  I8   8I   8I   8I  I8'    ,8i  I8P    I8, ,8I 
	"888,,____,dP,d8,   ,d8b,,dP   8I   8I   Yb,,I8 _  ,d8' ,d8b,_  `YbadP' 
	a8P"Y88888P" P"Y8888P"`Y88P'   8I   8I   `Y8PI8 YY88888P8P'"Y88888P"Y888
	                                             I8                         
	                                             I8                         
	                                             I8                         
	                                             I8                         
	                                             I8                         
	                                             I8                         


**ntgreek**

                                   
	______                  __         
	\  ___)                 \ \        
	 \ \   __  ___   _ ______\ \   ___ 
	  > > /  \/ / | | (  __  )> \ / __)
	 / /_( ()  <| |_| || || |/ ^ \> _) 
	/_____)__/\_\ ._,_||_||_/_/ \_\___)
	            | |                    
	            |_|                    


**nvscript**

	      ,gg,                                                              
	     i8""8i                                              ,dPYb,         
	     `8,,8'                                              IP'`Yb         
	      `88'                                               I8  8I         
	      dP"8,                                              I8  8'         
	     dP' `8a    ,gggg,gg   ,ggg,,ggg,,ggg,   gg,gggg,    I8 dP   ,ggg,  
	    dP'   `Yb  dP"  "Y8I  ,8" "8P" "8P" "8,  I8P"  "Yb   I8dP   i8" "8i 
	_ ,dP'     I8 i8'    ,8I  I8   8I   8I   8I  I8'    ,8i  I8P    I8, ,8I 
	"888,,____,dP,d8,   ,d8b,,dP   8I   8I   Yb,,I8 _  ,d8' ,d8b,_  `YbadP' 
	a8P"Y88888P" P"Y8888P"`Y88P'   8I   8I   `Y8PI8 YY88888P8P'"Y88888P"Y888
	                                             I8                         
	                                             I8                         
	                                             I8                         
	                                             I8                         
	                                             I8                         
	                                             I8                         


**o8**

	 oooooooo8                                      o888             
	888           ooooooo   oo ooo oooo  ooooooooo   888  ooooooooo8 
	 888oooooo    ooooo888   888 888 888  888    888 888 888oooooo8  
	        888 888    888   888 888 888  888    888 888 888         
	o88oooo888   88ooo88 8o o888o888o888o 888ooo88  o888o  88oooo888 
	                                     o888                        


**octal**

	123 141 155 160 154 145 


**odel_lak**
	
	          ##   ##   ##  #####     ## ######  
	         ####  ### ### ##  ##     ##     ##  
	 #####  ##  ## ####### ##  ##     ##     ##  
	     ## ###### ## # ##  #####     ##   ####  
	  ####  ##  ## ##   ##     ##     ##     ##  
	 ##     ##  ## ##   ##     ##     ##     ##  
	  ##### ##  ## ##   ##     ## ###### ######  
	                                             


**ogre**

	 __                       _      
	/ _\ __ _ _ __ ___  _ __ | | ___ 
	\ \ / _` | '_ ` _ \| '_ \| |/ _ \
	_\ \ (_| | | | | | | |_) | |  __/
	\__/\__,_|_| |_| |_| .__/|_|\___|
	                   |_|           


**ok_beer_**

	        ####### ####### ###  ## ###    ######   
	        ###  ## ###  ## ######  ###    ###      
	 #####  ###  ## ###  ## ###     ###    ###      
	###     ###  ## ###  ## ###     ###### #######  
	 #####                                          
	    ###                                         
	###  ##                                         
	 #####                                          


**oldbanner**

	 #####                                     
	#     #   ##   #    # #####  #      ###### 
	#        #  #  ##  ## #    # #      #      
	 #####  #    # # ## # #    # #      #####  
	      # ###### #    # #####  #      #      
	#     # #    # #    # #      #      #      
	 #####  #    # #    # #      ###### ###### 


**os2**

	_ooooo______________________________ooo___________
	oo___oo__ooooo__oo_oo_oo_____ooooo___oo____ooooo__
	_oo_____oo___oo_ooo_oo__o____o___oo__oo___oo____o_
	___oo___oo___oo_oo__oo__o___oo___oo__oo___ooooooo_
	oo___oo_oo___oo_oo__oo__o___oo___oo__oo___oo______
	_ooooo___oooo_o_oo______o_o_ooooo___ooooo__ooooo__
	__________________________oooo____________________


**outrun__**

	 ####  ### ### # ### ##          # # # ##          
	###### ### ### # ### ##          # ### ##          
	###    ### ### ##### ##      # # ##### ##  # # # # 
	 ####  ### ### ### # ##    ## #  ### # #  # # # #  
	   ### # # # # # # # #     ## ## # # # #  ### # #  
	##  ##  # # # # # # # #  ## # ##  # # # # ##### ## 
	######                   ## # ##          # # # ## 
	 ####                    ## # ##          ##### ## 


**pacos_pe**

	            #   ##  #######  #   ##   
	  ####       ##      ### # #  ##      
	 ######             # #### #       #  
	 ###         #  #   ### ##       #    
	  ####      #         ######    #     
	    ###              #### ##          
	 ###### ###         ## ##             
	  ####               ###   #          


**panther_**

	 #####  # # # #        ######        # # # #  
	####### ####### ######        ###### #######  
	###     # # ### ##     ####   ##     # # ###  
	 #####  # # ### ##     ##  ## ##     # # ###  
	    ### ####### ####   ##  ## ####   # # ###  
	####### # # ### ##     ##  ## ##     # # ###  
	 #####  # # ### ##     ##  ## ##     # # ###  
	        ####### ##     ##  ## ###### # # ###  


**Patorjk-HeX**

                                                                     ______                            _____   
	            _____      _____                ___________        _____|\     \  _____               _____\    \  
	       _____\    \   /      |_             /           \      /     / |     ||\    \             /    / |    | 
	      /    / \    | /         \           /    _   _    \    |      |/     /| \\    \           /    /  /___/| 
	     |    |  /___/||     /\    \         /    //   \\    \   |      |\____/ |  \\    \         |    |__ |___|/ 
	  ____\    \ |   |||    |  |    \       /    //     \\    \  |\     \    | /    \|    | ______ |       \       
	 /    /\    \|___|/|     \/      \     /     \\_____//     \ | \     \___|/      |    |/      \|     __/ __    
	|    |/ \    \     |\      /\     \   /       \ ___ /       \|  \     \          /            ||\    \  /  \   
	|\____\ /____/|    | \_____\ \_____\ /________/|   |\________\\  \_____\        /_____/\_____/|| \____\/    |  
	| |   ||    | |    | |     | |     ||        | |   | |        |\ |     |       |      | |    ||| |    |____/|  
	 \|___||____|/      \|_____|\|_____||________|/     \|________| \|_____|       |______|/|____|/ \|____|   | |  
	                                                                                                      |___|/   


**pawn_ins**

	 ####     #  ##  ######## ##                
	######   ### ### ######## ##       ######## 
	##  ##  ##### ###      ## ##       ######## 
	 ##    ####### ###     ## ##                
	   ##  #######  ###    ## ##                
	##  ##   ###     ###   ## ##                
	######  #####     ###  ## ########          
	 ####              ##  ## ########          


**pawp**

                                            
	  _____                           __        
	 (_____)                         (__)  ____ 
	(_)___     ____   __   __   ____  (_) (____)
	  (___)_  (____) (__)_(__) (____) (_)(_)_(_)
	  ____(_)( )_( )(_) (_) (_)(_)_(_)(_)(__)__ 
	 (_____)  (__)_)(_) (_) (_)(____)(___)(____)
	                           (_)              
	                           (_)              


**peaks**
	
	  /^^ ^^                                  /^^          
	/^^    /^^                                /^^          
	 /^^         /^^    /^^^ /^^ /^^ /^ /^^   /^^   /^^    
	   /^^     /^^  /^^  /^^  /^  /^^/^  /^^  /^^ /^   /^^ 
	      /^^ /^^   /^^  /^^  /^  /^^/^   /^^ /^^/^^^^^ /^^
	/^^    /^^/^^   /^^  /^^  /^  /^^/^^ /^^  /^^/^        
	  /^^ ^^    /^^ /^^^/^^^  /^  /^^/^^     /^^^  /^^^^   
	                                 /^^                   


**peaksslant**

	     ___/\/\/\/\/\__________________________________________/\/\_______________
	    _/\/\__________/\/\/\______/\/\/\__/\/\____/\/\/\/\____/\/\______/\/\/\___ 
	   ___/\/\/\/\________/\/\____/\/\/\/\/\/\/\__/\/\__/\/\__/\/\____/\/\/\/\/\_  
	  _________/\/\__/\/\/\/\____/\/\__/\__/\/\__/\/\/\/\____/\/\____/\/\_______   
	 _/\/\/\/\/\____/\/\/\/\/\__/\/\______/\/\__/\/\________/\/\/\____/\/\/\/\_    
	___________________________________________/\/\___________________________     


**pebbles**

	.oOOOo.                         o       
	o     o                        O        
	O.                             o        
	 `OOoo.                        O        
	      `O .oOoO' `oOOoOO. .oOo. o  .oOo. 
	       o O   o   O  o  o O   o O  OooO' 
	O.    .O o   O   o  O  O o   O o  O     
	 `oooO'  `OoO'o  O  o  o oOoO' Oo `OoO' 
	                         O              
	                         o'             


**pepper**

	  _               
	 /_`_  _ _  _  /_ 
	._//_|/ / //_///_'
	          /       


**phonix__**

	 ######  # #  # #       #                # #     
	        # #  # #      ##   ##           # #      
	##      #### ####         ## #          ####     
	##                     ####                      
	 #####        # # # # # # #  #  # # # #  # #     
	     ##      # # # #       ### # # # #  # #      
	     ##      ######## #   ## # ######## ####     
	######                                           


**platoon2**

	          #####                  #  # ###  #####   
	         #######  #####  ######  ## ## ## #######  
	         ##   ## ####### ####### ######## ##       
	         ####### ##   ##      ## # ###### ######   
	 # #     ######  ##   ##   ####  #######   ######  
	 #   # # ## ##   ##   ##      ## # ######      ##  
	 # # #   ##  ##  ####### ####### ### #### #######  
	   # # #  #   #   #####  ######  ########  #####   


**platoon_**

	  ##### ######## ######## ########  #   ### ## 
	###  #  ######## ######## ########        #  # 
	 ###    ######## ###   ## #    ###        # ## 
	  ####  ######## ##     #        #         ### 
	    ### ######## #   #                     # # 
	##   ## ########                               
	 #####  ########                               
	        ########     #  #                      


**pod_____**

	####### # # # ##   # # ######    #  #### # # #   
	##   ## # # # ##   # # ####   #  #  #### # # #   
	#####   # # # ##   # # ####   #   ###### # # #   
	    ### # # # ####   # ##   # # ######## # # #   
	##  ### # # # ####   #    # # # ##       # # #   
	##  ### # # # ######    # # # # ##   #   # #  ## 
	####### # # # ########  # #     ##   #   # #  ## 
	        # # # ########     #### ##       # #  ## 


**poison**

                                                               
	 @@@@@@    @@@@@@   @@@@@@@@@@   @@@@@@@   @@@       @@@@@@@@  
	@@@@@@@   @@@@@@@@  @@@@@@@@@@@  @@@@@@@@  @@@       @@@@@@@@  
	!@@       @@!  @@@  @@! @@! @@!  @@!  @@@  @@!       @@!       
	!@!       !@!  @!@  !@! !@! !@!  !@!  @!@  !@!       !@!       
	!!@@!!    @!@!@!@!  @!! !!@ @!@  @!@@!@!   @!!       @!!!:!    
	 !!@!!!   !!!@!!!!  !@!   ! !@!  !!@!!!    !!!       !!!!!:    
	     !:!  !!:  !!!  !!:     !!:  !!:       !!:       !!:       
	    !:!   :!:  !:!  :!:     :!:  :!:        :!:      :!:       
	:::: ::   ::   :::  :::     ::    ::        :: ::::   :: ::::  
	:: : :     :   : :   :      :     :        : :: : :  : :: ::   
                                                               


**p_s_h_m_**

	#    ######## ######## ######## ######## ######## 
	 #   ##    ##   ###  # #     ## #  ##### #      # 
	 #   #      #    #   # #      # #  ##### #      # 
	 #   #  ##  #        # #  ##  # #  ##### #  ##### 
	  #  #  ##  #        # #      # #  ##### #    ### 
	  #  #      #   # #  # #     ## #  ##### #  ##### 
	  #  #  ##  #   ###  # #  ##### #      # #      # 
	   # #  ##  #   ###  # #  ##### #      # #      # 


**p_skateb**

	                  #  ##  #    ## # # #  # #   ## 
	 #####  # # # #   #  ### #  #### #      # #   ## 
	##   ## # # # #   #  ##  #   #   # ## # # #   ## 
	##                ###### #   # # # ###  # #   ## 
	 #####  ######## # ## ## #  ## # # ## # # #   ## 
	     ## ########  #####  #     # ### #  # ##     
	##   ## ########  #      # #  ## #### # ##       
	 #####  ########  #      # # #   #####           
	

**puffy**

	 ___                             _          
	(  _`\                          (_ )        
	| (_(_)   _ _   ___ ___   _ _    | |    __  
	`\__ \  /'_` )/' _ ` _ `\( '_`\  | |  /'__`\
	( )_) |( (_| || ( ) ( ) || (_) ) | | (  ___/
	`\____)`\__,_)(_) (_) (_)| ,__/'(___)`\____)
	                         | |                
	                         (_)                


**puzzle**

	     _         _         _         _         _         _    
	   _( )__    _( )__    _( )__    _( )__    _( )__    _( )__ 
	 _|     _| _|     _| _|     _| _|     _| _|     _| _|     _|
	(_ S _ (_ (_ A _ (_ (_ M _ (_ (_ P _ (_ (_ L _ (_ (_ E _ (_ 
	  |_( )__|  |_( )__|  |_( )__|  |_( )__|  |_( )__|  |_( )__|


**pyramid**
	
	  ^    ^    ^    ^    ^    ^  
	 /S\  /a\  /m\  /p\  /l\  /e\ 
	<___><___><___><___><___><___>


**r2-d2___**

	          ######  #### ### #######  ####     ######## 
	 ####### ##    ## #  ### # #     ## #  #     #      # 
	 #     # #  ##  # #   #  # #  ##  # #  #     #  ##### 
	#  ##### #      # #      # #     ## #  #     #    #   
	##    ## #  ##  # #  # # # #  ####  #  #     #  ###   
	#####  # #  ##  # #  ### # #  #     #  ##### #  ##### 
	#     ## #  ##  # #  # # # #  #     #      # #      # 
	#######  ######## #### ### ####     ######## ######## 


**rad_____**

	 ####### #     # #        #  #  # # #   
	 ##          #  #    ####   # ##   #  # 
	 #######  ##  #  # # # ## #  ####  ###  
	      ## #    #      #####  #  #    ### 
	 ###  ##  #  ##    #   ###  #  ## #  ## 
	 ###  ##   #  # ##      ## ####  #      
	 #######    #   ##     ##  # ## # # #   
	            # # #  # ####  #####   #### 


**radical_**

	  ###      ###   ##   ## ######  ##     ######  
	  ###     ## ##  ### ### ##   ## ##     ##      
	   ###   ##   ## ####### ##   ## ##     ##      
	    ###  ##   ## ####### ##   ## ##     #####   
	     ### ####### ## # ## ######  ##     ##      
	     ### ##   ## ##   ## ##      ##     ##      
	#######  ##   ## ##   ## ##      ###### ######  
                                                


**rad_phan**

	  ###### #  #   # #    ###    ####  #####  # # # ##   
	 ###  ## ## #   #   ##  ##    #  ## ##    #  #  #  #  
	 ####    #  # ##   ##      # ### ## # ### #  ### ##   
	  #####   # ##     # # #   #  ##  # #  # ##  ######   
	    #### ##  #     #   #     # ###  #     ##   # ## # 
	 ##  ###  # #   #    # # # # # ####   #### # ### #### 
	  #####  ### ## #  # # # # #    #   # ###    #  ###   
	         ## ##  # ##   #   ## #   # #    # #   # #  # 


**rainbow_**

	      # ### ### ### ###    #####  # ### ## # ### #  
	 ###### ### ### ### ###        ## # ### ## # ### #  
	##  ##  ### ### ### ###    ##     # ### ## ##### #  
	###     ### ### ### ###  ### #### # ### ##   ### #  
	 #####  ########  ###### ### ###  # ### ## ##  ###  
	    ###     ##      ##   ### ###  # ###### # ### #  
	 ##  ##   ##  ##  ##  ## ### ###  ######## # ### #  
	## ###  ### ### ### ###  ### ###  # ### ## # ### #  


**rally_s2**

	 #####   ###### ###### ###  ###   ##    ####### 
	###  ##   ##### ##  ## ###  ###   ##     ###### 
	##         ####    ##  ########   #####   ##### 
	###  ##     ###   ###  ########      ##   ##### 
	#######      ##    ##  ## ## ##    ####  ###### 
	#######       #    ##  ##    ##      ## ####### 
	 #####            #### ##    ##   ##### ######  
	                ##  ## ###  ### ##  ##  ######  


**rally_sp**

	## #### #####       ##     ##   ##      ##### 
	## #### #####      ##     ##    ##     ###### 
	## ####  ####    ###### ###### ####   ####### 
	        ###### ######  ###  ######   #######  
	#####   #######  ##    ###    ##     ######   
	##  ##   ######  ##    ###    ##     #####    
	#####    ######  ##### ###     ####  ####     
	##  ##   ######     ## ###    ##  ## ###      


**rammstein**

	    _____                                                
	 __|___  |__  ____    ____    __  _____  ____    ______  
	|   ___|    ||    \  |    \  /  ||     ||    |  |   ___| 
	 `-.`-.     ||     \ |     \/   ||    _||    |_ |   ___| 
	|______|  __||__|\__\|__/\__/|__||___|  |______||______| 
	   |_____|                                               
                                                         


**rampage_**

                                                
	 ####  ##  #### ##  ## ####  ## ####  ## ####   
	##   # ##  #### ##  ##   ##  ##       ## ####   
	##     ##  #### ##  ##   ##  ##       ## ####   
	 ####  ##  #### ######   ##  ## ##    ## ####   
	     # ##    ## ####     ##  ##          ####   
	##   # ##    ## ####     ##  ##          ####   
	 ####  ##    ## ####   ####  ## ####     ####   


**rastan__**

	   ###  # # # #                                 
	  ## ## # # # #   # # #  # #                    
	  #     # # # #   ###### #### ########          
	  ####  # # # #   ###### ####  ### ###       ## 
	     ## # # # #   ###### ####  ### ###     ## # 
	 ##  ## # # # #    ## #  # #   ### ###  ### #   
	  ####  # # # #      # #  # #  ### ### #  #     
	        # # # #               ########  # #     


**raw_recu**

	  ####  ##        ########           
	 ###### ####      ########           
	 ##     ####      ########         # 
	  ####  ####      ########         # 
	     ## ##   # #  ########           
	 ######    # # #  ########           
	  ####            ########           
	                  ########           


**rci_____**

	                # # # ##      ########          
	                # # ####      ########          
	    ####  ##    ########      ########          
	   ### # #  #   ########      ######            
	   ###  #    #  ####          ####              
	   ###        #          ##                  ## 
	#####                    ####              #### 
	                         ####              #### 


**rectangles**

                           
	 _____               _     
	|   __|___ _____ ___| |___ 
	|__   | .'|     | . | | -_|
	|_____|__,|_|_|_|  _|_|___|
	                |_|        


**red_phoenix**

	  _________                             .__             
	 /   _____/ _____      _____   ______   |  |     ____   
	 \_____  \  \__  \    /     \  \____ \  |  |   _/ __ \  
	 /        \  / __ \_ |  Y Y  \ |  |_> > |  |__ \  ___/  
	/_______  / (____  / |__|_|  / |   __/  |____/  \___  > 
	        \/       \/        \/  |__|                 \/  
                                                        


**relief2**

	\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
	\/////// \\\/////// \\/// \\/// \//////// \\/// \\\\\\\///////// \
	/// \\\\\\\/// \\/// \//// //// \/// \\/// \/// \\\\\\\/// \\\\\\\
	\/////// \\///////// \/// / /// \//////// \\/// \\\\\\\/////// \\\
	\\\\\\/// \/// \\/// \/// \\/// \/// \\\\\\\/// \\\\\\\/// \\\\\\\
	\/////// \\/// \\/// \/// \\/// \/// \\\\\\\///////// \///////// \
	\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\


**relief**

	__________________________________________________________________
	_/~~~~~~\___/~~~~~~\__/~~\__/~~\_/~~~~~~~\__/~~\_______/~~~~~~~~\_
	/~~\_______/~~\__/~~\_/~~~\/~~~\_/~~\__/~~\_/~~\_______/~~\_______
	_/~~~~~~\__/~~~~~~~~\_/~~~~~~~~\_/~~~~~~~\__/~~\_______/~~~~~~\___
	______/~~\_/~~\__/~~\_/~~\__/~~\_/~~\_______/~~\_______/~~\_______
	_/~~~~~~\__/~~\__/~~\_/~~\__/~~\_/~~\_______/~~~~~~~~\_/~~~~~~~~\_
	__________________________________________________________________


**reverse**

	=============================================
	==      ===========================  ========
	=  ====  ==========================  ========
	=  ====  ==========================  ========
	==  ========   ===  =  = ===    ===  ===   ==
	====  =====  =  ==        ==  =  ==  ==  =  =
	======  ======  ==  =  =  ==  =  ==  ==     =
	=  ====  ===    ==  =  =  ==    ===  ==  ====
	=  ====  ==  =  ==  =  =  ==  =====  ==  =  =
	==      ====    ==  =  =  ==  =====  ===   ==
	=============================================
	

**rev**

	=============================================
	==      ===========================  ========
	=  ====  ==========================  ========
	=  ====  ==========================  ========
	==  ========   ===  =  = ===    ===  ===   ==
	====  =====  =  ==        ==  =  ==  ==  =  =
	======  ======  ==  =  =  ==  =  ==  ==     =
	=  ====  ===    ==  =  =  ==    ===  ==  ====
	=  ====  ==  =  ==  =  =  ==  =====  ==  =  =
	==      ====    ==  =  =  ==  =====  ===   ==
	=============================================


**road_rai**

	            #### # # #   # # # # # # #         #  
	  ####      #### # # #   # # # #     ### #  ##  # 
	 ##         #  #     ### # ### # # # #         ## 
	  ####           # # #   # # #           # ## ### 
	     ##          # # # # # # #                #   
	     ##        # # # # #     ###         ## # # # 
	  ####        ## # # # # # # #                # # 
	                 # # # # # # # #     # # ####  ## 


**rockbox_**

	  ##                         
	 ## #                        
	 ##      #######             
	  ####        ##             
	      ## ###  ##             
	 ###  ##  ##  ##             
	  #####   ##  ##             
	          ##  ##             


**rok_____**
                    
                     
	 ######              
	##                   
	 #####               
	     ##              
	######               
                     


**roman___**

	          ###    ##    ## ###### ####    ####### 
	  #####   ###     ### ###  ##  ## ##      ##   # 
	 ##       # ##    # ## ##  ##  ## ##      ##     
	  ####   #  ##    # ## ##  #####  ##      #####  
	   #### #######   # ## ##  ##     ##   #  ##     
	 #    # #    ##   #  # ##  ##     ##  ##  ##   # 
	 #####  ##   ### ###   ## ####   ####### ####### 
                                                 


**roman**

	          ###    ##    ## ###### ####    ####### 
	  #####   ###     ### ###  ##  ## ##      ##   # 
	 ##       # ##    # ## ##  ##  ## ##      ##     
	  ####   #  ##    # ## ##  #####  ##      #####  
	   #### #######   # ## ##  ##     ##   #  ##     
	 #    # #    ##   #  # ##  ##     ##  ##  ##   # 
	 #####  ##   ### ###   ## ####   ####### ####### 
                                                 


**Roman**

	 .oooooo..o                                        oooo            
	d8P'    `Y8                                        `888            
	Y88bo.       .oooo.   ooo. .oo.  .oo.   oo.ooooo.   888   .ooooo.  
	 `"Y8888o.  `P  )88b  `888P"Y88bP"Y88b   888' `88b  888  d88' `88b 
	     `"Y88b  .oP"888   888   888   888   888   888  888  888ooo888 
	oo     .d8P d8(  888   888   888   888   888   888  888  888    .o 
	8""88888P'  `Y888""8o o888o o888o o888o  888bod8P' o888o `Y8bod8P' 
	                                         888                       
	                                        o888o                      
                                                                   

**rot13**

	Fnzcyr


**rotated**

	   _  _    __  __   ___   _  
	(_/ ) _|)  __< (_)       (|) 
                             
**rounded**
	
	  ______                   _        
	 / _____)                 | |       
	( (____  _____ ____  ____ | | _____ 
	 \____ \(____ |    \|  _ \| || ___ |
	 _____) ) ___ | | | | |_| | || ____|
	(______/\_____|_|_|_|  __/ \_)_____)
	                    |_|             


**rowancap**

	   .dMMMb  .aMMMb  dMMMMMMMMb dMMMMb  dMP     dMMMMMP 
	  dMP" VP dMP"dMP dMP"dMP"dMPdMP.dMP dMP     dMP      
	  VMMMb  dMMMMMP dMP dMP dMPdMMMMP" dMP     dMMMP     
	dP .dMP dMP dMP dMP dMP dMPdMP     dMP     dMP        
	VMMMP" dMP dMP dMP dMP dMPdMP     dMMMMMP dMMMMMP     
                                                      


**rozzo**
	
	 dP"8                              888         
	C8b Y  ,"Y88b 888 888 8e  888 88e  888  ,e e,  
	 Y8b  "8" 888 888 888 88b 888 888b 888 d88 88b 
	b Y8D ,ee 888 888 888 888 888 888P 888 888   , 
	8edP  "88 888 888 888 888 888 88"  888  "YeeP" 
	                          888                  
	                          888                  


**runic**

	  /   
	 /    
	/____ 
	    / 
	   /  
	  /   


**runyc**

	  /                       
	 /                        
	/____                     
	    / |\ |\/| |\/ |\ |\/| 
	   /  |\ |/\| |   |  |  | 
	  /   |  |  | |/\ |  |  | 


**sansb**

                                                              
	 ###                    #      
	##                      #      
	##   #### ####### ####  #  ### 
	  ##    # #  #  # #   # # #### 
	   # #### #  #  # #   # # ##   
	###  #### #  #  # ####  #  ### 
	                  #            
	                  #            


**sansbi**

                                   
                                   
	  ###                      ##      
	 #                         ##      
	 ##    ####  ### ##  ####  #   ### 
	   #  ## ##  #### #  ## #  #  ###  
	   ## # ##  ## ###   # ## ##  ## # 
	####  ## #  # ## #  ####  ##  #### 
	                    ##             
	                    ##             


**sans**

                           
                           
	###                 #      
	#                   #      
	##  ###  ##### ###  #  ##  
	 ##  ##  # # # #  # # #### 
	  # # #  # # # #  # # #    
	### ## # # # # ###  #  ### 
	               #           
	               #           
                           


**sansi**

                               
                               
	 ###                     #     
	 #                       #     
	 #    ###  ### ##  #### #   ## 
	  ## #  #  #### #  ## # #  # # 
	   # # #  ## #  #  #  # #  ### 
	###  ###  #  #  #  ###  #  ### 
	                  #            
	                  #            
                               


**santaclara**

	  __,                      _  
	 (                        //  
	  `.  __,  _ _ _    ,_   // _ 
	(___)(_/(_/ / / /__/|_)_(/_(/_
	                   /|         
	                  (/          


**sblood**

	  @@@@@@  @@@@@@  @@@@@@@@@@  @@@@@@@  @@@      @@@@@@@@
	 !@@     @@!  @@@ @@! @@! @@! @@!  @@@ @@!      @@!     
	  !@@!!  @!@!@!@! @!! !!@ @!@ @!@@!@!  @!!      @!!!:!  
	     !:! !!:  !!! !!:     !!: !!:      !!:      !!:     
	 ::.: :   :   : :  :      :    :       : ::.: : : :: :::
                                                        


**sbookb**

                                   
                                                                      
	 ####                     ###      
	##  #                      ##      
	####  ##   #### ##  ####   ##  ##  
	 ####  ##  ## ## ##  ## #  ## #### 
	#  ## ###  ## ## ##  ## #  ## ##   
	####  #### ## ## ##  ###  ###  ### 
	                     ##            
	                    ###            


**sbookbi**

                                    
                                    
	                                    
	  ###                       ##      
	 ## #                       ##      
	 ##    ###  #### #   ####   ##   ## 
	  ##    ###  ######   # ## ##   ### 
	# ##  ## #  ## # #   ## #  ##  ##   
	###    #### ## # ##  ###   ###  ### 
	                    ##              
	                    ###             


**sbook**

                               
                               
	 ###                   ##      
	#  #                    #      
	###  ##   # # ##  # #   #   ## 
	  ##  ##   # # #   # #  #  ### 
	#  # # #   # # #   # #  #  #   
	###  #### ## # ##  ##  ###  ## 
	                   #           
	                  ###          


**sbooki**

                               
                               
	                               
	  ###                   ##     
	 #                       #     
	 ##    ##  # # ##  ###   #  ## 
	  ##   ###  ### #   # # #  ### 
	#  #  # #  # # #    # # #  #   
	###    ### # # ##  ###  #   ## 
	                   #           
	                  ##           


**script__**

	       #        #    #   #  ######   #  ### #  ##### 
	      #        ##   ##  ## #   #  # #  ## # # ##  ## 
	     # #      ###  ### ### #  ##  # # ##  #  ### #   
	    #  #  ## ####  # ### # #  ##  #  ### #    ###    
	   ##  # #  ## ##  # ##  #   ##  #   ## #    ##      
	# ##  ## # ### ## #  #  #    ####    ##     ##   ### 
	 #  ###  ### #### #  #  #   ##      ###   # ##  #  # 
	         ##    ## #      # ##      ## #####  ######  


**script**

                            _      
	  ()                       | |     
	  /\  __,   _  _  _     _  | |  _  
	 /  \/  |  / |/ |/ |  |/ \_|/  |/  
	/(__/\_/|_/  |  |  |_/|__/ |__/|__/
	                     /|            
	                     \|            


**serifcap**

	 ___   __   __  __  ___  __    ___ 
	/ __) (  ) (  \/  )(  ,\(  )  (  _)
	\__ \ /__\  )    (  ) _/ )(__  ) _)
	(___/(_)(_)(_/\/\_)(_)  (____)(___)
	

**shadow**

	  ___|                        |      
	\___ \   _` | __ `__ \  __ \  |  _ \ 
	      | (   | |   |   | |   | |  __/ 
	_____/ \__,_|_|  _|  _| .__/ _|\___| 
	                       _|            


**shimrod**

	 ,-.                .     
	(   `               |     
	 `-.  ,-: ;-.-. ;-. | ,-. 
	.   ) | | | | | | | | |-' 
	 `-'  `-` ' ' ' |-' ' `-' 
	                '         


**short**

	(`  ,_   | _ 
	_)(|||||)|(/_
	       |     


**skateord**

	 #####  # # # # ##  ## ##  ## ##  ##    # # # # 
	##   ## # # # # ##  ## ##  ## ##  ##    # # # # 
	##      ##### #   ##  ## ##  ## ##  ## ###### # 
	 #####  ######    ##  ## ##  ## ##  ## #######  
	     ## ######  ##  ## ##  ## ##  ##   #######  
	##   ## ######  ##  ## ##  ## ##  ##   # # # #  
	 ##### #######    ##  ## ##  ## ##  ##  # # # # 
	       #######    ##  ## ##  ## ##  ##  # # # # 


**skateroc**

	  ####  ##### #####               #####    
	 #    # ##### #####          ###  #####    
	  # ##  ##### #####         ##### #####    
	  ###   #####  ###      # # ##### #####    
	##  ##  #####   #     # # # ##### #####    
	     ##  ###        # # # # #####  ###     
	 #######  #         # # # # #####   #      
	                      # # # #####          


**skate_ro**

	  ####  ##### #####               #####    
	 #    # ##### #####          ###  #####    
	  # ##  ##### #####         ##### #####    
	  ###   #####  ###      # # ##### #####    
	##  ##  #####   #     # # # ##### #####    
	     ##  ###        # # # # #####  ###     
	 #######  #         # # # # #####   #      
	                      # # # #####          


**sketch_s**

	         ####  ######  #####  #      ######  
	        #    # #     #      # #              
	  ##### #    # #     #      # #              
	 #      ###  # #  #  # #####  #      ######  
	  ####  #    # #  #  # #      #      #       
	      # #    # #  #  # #      #      #       
	 #####  #    # #  #  # #      #  ### ######  
                                             


**slant**

	   _____                       __   
	  / ___/____ _____ ___  ____  / /__ 
	  \__ \/ __ `/ __ `__ \/ __ \/ / _ \
	 ___/ / /_/ / / / / / / /_/ / /  __/
	/____/\__,_/_/ /_/ /_/ .___/_/\___/ 
	                    /_/             


**Slant_Relief**

	_____/\\\\\\\\\\\_____________________________________________________/\\\\\\___________________        
	 ___/\\\/////////\\\__________________________________________________\////\\\___________________       
	  __\//\\\______\///_______________________________________/\\\\\\\\\_____\/\\\___________________      
	   ___\////\\\__________/\\\\\\\\\_______/\\\\\__/\\\\\____/\\\/////\\\____\/\\\________/\\\\\\\\__     
	    ______\////\\\______\////////\\\____/\\\///\\\\\///\\\_\/\\\\\\\\\\_____\/\\\______/\\\/////\\\_    
	     _________\////\\\_____/\\\\\\\\\\__\/\\\_\//\\\__\/\\\_\/\\\//////______\/\\\_____/\\\\\\\\\\\__   
	      __/\\\______\//\\\___/\\\/////\\\__\/\\\__\/\\\__\/\\\_\/\\\____________\/\\\____\//\\///////___  
	       _\///\\\\\\\\\\\/___\//\\\\\\\\/\\_\/\\\__\/\\\__\/\\\_\/\\\__________/\\\\\\\\\__\//\\\\\\\\\\_ 
	        ___\///////////______\////////\//__\///___\///___\///__\///__________\/////////____\//////////__


**slide**

	 #HH||                 #|      
	##    ##|  ##H H| ##H| #| #H|  
	 #HH|   H| ### HH|## H|#|##HH| 
	    ||##H| ## H H|##H| #|##    
	##HH| ##HH|##   H|##   #H|#HH| 
	                  ##           


**slscript**

	  ()                      _  
	  /\                     //  
	 /  )  __.  ______  _   // _ 
	/__/__(_/|_/ / / <_/_)_</_</_
	                  /          
	                 '           


**smallcaps**

	  ___     _    _   _  ____   _      ___  
	 (  _(   )_\  ) \_/ ()  _)\ ) |    ) __( 
	 _) \   /( )\ |  _  || '__/ | (__  | _)  
	)____) )_/ \_()_( )_()_(    )____( )___( 
                                         


**small**

	 ___                  _     
	/ __| __ _ _ __  _ __| |___ 
	\__ \/ _` | '  \| '_ \ / -_)
	|___/\__,_|_|_|_| .__/_\___|
	                |_|         


**Small_Isometric1**

	    ___       ___       ___       ___       ___       ___   
	   /\  \     /\  \     /\__\     /\  \     /\__\     /\  \  
	  /::\  \   /::\  \   /::L_L_   /::\  \   /:/  /    /::\  \ 
	 /\:\:\__\ /::\:\__\ /:/L:\__\ /::\:\__\ /:/__/    /::\:\__\
	 \:\:\/__/ \/\::/  / \/_/:/  / \/\::/  / \:\  \    \:\:\/  /
	  \::/  /    /:/  /    /:/  /     \/__/   \:\__\    \:\/  / 
	   \/__/     \/__/     \/__/               \/__/     \/__/  


**Small_Keyboard**

	 ____ ____ ____ ____ ____ ____ 
	||S |||a |||m |||p |||l |||e ||
	||__|||__|||__|||__|||__|||__||
	|/__\|/__\|/__\|/__\|/__\|/__\|


**Small_Poison**

                                                        
	 @@@@@@  @@@@@@  @@@@@@@@@@  @@@@@@@  @@@      @@@@@@@@ 
	!@@     @@!  @@@ @@! @@! @@! @@!  @@@ @@!      @@!      
	 !@@!!  @!@!@!@! @!! !!@ @!@ @!@@!@!  @!!      @!!!:!   
	    !:! !!:  !!! !!:     !!: !!:      !!:      !!:      
	::.: :   :   : :  :      :    :       : ::.: : : :: ::  
                                                        


**Small_Script**

                           
	 ()  _,              |\  _ 
	 /\ / |  /|/|/|  |/\_|/ |/ 
	/(_)\/|_/ | | |_/|_/ |_/|_/
	                (|         


**Small_Shadow**

	  __|                 |      
	\__ \  _` |  ` \  _ \ |  -_) 
	____/\__,_|_|_|_|.__/_|\___| 
	                _|           


**Small_Slant**

	   ____                __   
	  / __/__ ___ _  ___  / /__ 
	 _\ \/ _ `/  ' \/ _ \/ / -_)
	/___/\_,_/_/_/_/ .__/_/\__/ 
	              /_/           


**Small_Tengwar**

	 _  .',  _ _          ,' 
	( )  |  |_)_) |~) ---  | 
	 /            |~~ (_,    


**sm______**

	######## ########           # ## #          # # # ## 
	#      #  # # # #           ## # #          # # # ## 
	  ######  # # # #           ## # #          # # # ## 
	#     ## # # # #           # # # #          # # # ## 
	#####  # # # # #           # # # #          # # # ## 
	  ###  # # # # #           # # # #          # # # ## 
	#     ## # # # #  ######## # # # # ######## # # # ## 
	######## # # # #   # # ### # # # #  # # # # # # # ## 
	

**smisome1**

	    ___       ___       ___       ___       ___       ___   
	   /\  \     /\  \     /\__\     /\  \     /\__\     /\  \  
	  /::\  \   /::\  \   /::L_L_   /::\  \   /:/  /    /::\  \ 
	 /\:\:\__\ /::\:\__\ /:/L:\__\ /::\:\__\ /:/__/    /::\:\__\
	 \:\:\/__/ \/\::/  / \/_/:/  / \/\::/  / \:\  \    \:\:\/  /
	  \::/  /    /:/  /    /:/  /     \/__/   \:\__\    \:\/  / 
	   \/__/     \/__/     \/__/               \/__/     \/__/  


**smkeyboard**

	 ____ ____ ____ ____ ____ ____ 
	||S |||a |||m |||p |||l |||e ||
	||__|||__|||__|||__|||__|||__||
	|/__\|/__\|/__\|/__\|/__\|/__\|


**smpoison**

                                                        
	 @@@@@@  @@@@@@  @@@@@@@@@@  @@@@@@@  @@@      @@@@@@@@ 
	!@@     @@!  @@@ @@! @@! @@! @@!  @@@ @@!      @@!      
	 !@@!!  @!@!@!@! @!! !!@ @!@ @!@@!@!  @!!      @!!!:!   
	    !:! !!:  !!! !!:     !!: !!:      !!:      !!:      
	::.: :   :   : :  :      :    :       : ::.: : : :: ::  
                                                        


**smscript**

                           
	 ()  _,              |\  _ 
	 /\ / |  /|/|/|  |/\_|/ |/ 
	/(_)\/|_/ | | |_/|_/ |_/|_/
	                (|         


**smshadow**

	  __|                 |      
	\__ \  _` |  ` \  _ \ |  -_) 
	____/\__,_|_|_|_|.__/_|\___| 
	                _|           


**smslant**

	   ____                __   
	  / __/__ ___ _  ___  / /__ 
	 _\ \/ _ `/  ' \/ _ \/ / -_)
	/___/\_,_/_/_/_/ .__/_/\__/ 
	              /_/           


**smtengwar**
	
	 _  .',  _ _          ,' 
	( )  |  |_)_) |~) ---  | 
	 /            |~~ (_,    


**soft**

                                             
	 ,---.                           ,--.        
	'   .-'  ,--,--.,--,--,--. ,---. |  | ,---.  
	`.  `-. ' ,-.  ||        || .-. ||  || .-. : 
	.-'    |\ '-'  ||  |  |  || '-' '|  |\   --. 
	`-----'  `--`--'`--`--`--'|  |-' `--' `----' 
	                          `--'               


**space_op**

	####   #                                          
	###  ##   #####  ##   ## ######  ##      #######  
	###    # ##   ## ### ### ##   ## ##      ##       
	#####    ####### ## # ## ######  ##      ######   
	## ###   ##   ## ##   ## ##      ##      ##       
	###    # ##   ## ##   ## ##      ####### #######  
	########                                          
	########                                          


**spc_demo**

	  ##        ##### ######## ########         ####### 
	 ## #      ###### ####         ####         ####### 
	 ##        ##     ###           ###        ##       
	  ####      ###   ##             ##        ##       
	      ##     ###  #               #        ##       
	 ###  ## #######  #               #    ### #######  
	  #####  ######   #               #   ###   ######  
	                  #               #                 


**speed**

	________                         ______     
	__  ___/_____ _______ ______________  /____ 
	_____ \_  __ `/_  __ `__ \__  __ \_  /_  _ \
	____/ // /_/ /_  / / / / /_  /_/ /  / /  __/
	/____/ \__,_/ /_/ /_/ /_/_  .___//_/  \___/ 
	                         /_/                


**spliff**

	 _____  _____  __  __  _____  ____   _____ 
	/  ___>/  _  \/  \/  \/  _  \/  _/  /   __\
	|___  ||  _  ||  \/  ||   __/|  |---|   __|
	<_____/\__|__/\__ \__/\__/   \_____/\_____/
                                           


**s-relief**

	_____/\\\\\\\\\\\_____________________________________________________/\\\\\\___________________        
	 ___/\\\/////////\\\__________________________________________________\////\\\___________________       
	  __\//\\\______\///_______________________________________/\\\\\\\\\_____\/\\\___________________      
	   ___\////\\\__________/\\\\\\\\\_______/\\\\\__/\\\\\____/\\\/////\\\____\/\\\________/\\\\\\\\__     
	    ______\////\\\______\////////\\\____/\\\///\\\\\///\\\_\/\\\\\\\\\\_____\/\\\______/\\\/////\\\_    
	     _________\////\\\_____/\\\\\\\\\\__\/\\\_\//\\\__\/\\\_\/\\\//////______\/\\\_____/\\\\\\\\\\\__   
	      __/\\\______\//\\\___/\\\/////\\\__\/\\\__\/\\\__\/\\\_\/\\\____________\/\\\____\//\\///////___  
	       _\///\\\\\\\\\\\/___\//\\\\\\\\/\\_\/\\\__\/\\\__\/\\\_\/\\\__________/\\\\\\\\\__\//\\\\\\\\\\_ 
	        ___\///////////______\////////\//__\///___\///___\///__\///__________\/////////____\//////////__


**stacey**

	___________________________________   _______
	7     77  _  77        77     77  7   7     7
	|  ___!|  _  ||  _  _  ||  -  ||  |   |  ___!
	!__   7|  7  ||  7  7  ||  ___!|  !___|  __|_
	7     ||  |  ||  |  |  ||  7   |     7|     7
	!_____!!__!__!!__!__!__!!__!   !_____!!_____!
                                             


**stampate**

	.---.               .      
	\___  ,-. ,-,-. ,-. |  ,-. 
	    \ ,-| | | | | | |  |-' 
	`---' `-^ ' ' ' |-' `' `-' 
	                |          
	                '          


**stampatello**

	.---.               .      
	\___  ,-. ,-,-. ,-. |  ,-. 
	    \ ,-| | | | | | |  |-' 
	`---' `-^ ' ' ' |-' `' `-' 
	                |          
	                '          


**standard**

	 ____                        _      
	/ ___|  __ _ _ __ ___  _ __ | | ___ 
	\___ \ / _` | '_ ` _ \| '_ \| |/ _ \
	 ___) | (_| | | | | | | |_) | |  __/
	|____/ \__,_|_| |_| |_| .__/|_|\___|
	                      |_|           


**starstrips**

	------------   ------     ********  ----------- ----        ------------
	************  ********   ---------- ****************        ************
	----         ---------- ************---      -------        ----        
	****************    ****---  --  ---****************        ************
	------------------------***  **  ***----------- ----        ------------
	       *****************---  --  ---****        ****************        
	----------------    ----***  **  ***----        ------------------------
	****************    ****---      ---****        ************************
                                                                        


**star_war**

	  ######  ####    #  # ## # # # # #  #### #  # ##  
	  ##      ####    #   # #  #   #  #    #  #    ### 
	  ##     #    ### #  ###  # #     #  #  # #    ### 
	  ###### #    ### #  #### # #  #   # ## #  ####    
	      ##  ####    #    #  #   # # # # ### #  # ##  
	      ## #  # ##  #  #  # # #  ## #     # #  # ##  
	  ###### #  # ##   #      #   # # #  ###  #    ### 
	          ####    #  #  # #  ###   #      #    ### 


**starwars**

	     _______.     ___      .___  ___. .______    __       _______ 
	    /       |    /   \     |   \/   | |   _  \  |  |     |   ____|
	   |   (----`   /  ^  \    |  \  /  | |  |_)  | |  |     |  |__   
	    \   \      /  /_\  \   |  |\/|  | |   ___/  |  |     |   __|  
	.----)   |    /  _____  \  |  |  |  | |  |      |  `----.|  |____ 
	|_______/    /__/     \__\ |__|  |__| | _|      |_______||_______|
                                                                  


**stealth_**

	 ######      #   ###  ##                    #       
	#######   ## # # #    ##                 #  ##      
	##        # ###  ### ####   ###   ####  ## ###  ### 
	 #####  #  #   # #    ##    #   # #  ##  #  ## ##   
	     ## # # #### #    ## # ##   # #  ##  #  #  #### 
	####### ## #     #    ## # ##   # #  ##  #  ## ##   
	######    #      #    ## # ##   # #  ##  #  ## ##   
	        ###      #     ##  ##     ####   # ##   ### 


**stellar**

	  `.. ..                                  `..          
	`..    `..                                `..          
	 `..         `..    `... `.. `.. `. `..   `..   `..    
	   `..     `..  `..  `..  `.  `..`.  `..  `.. `.   `.. 
	      `.. `..   `..  `..  `.  `..`.   `.. `..`..... `..
	`..    `..`..   `..  `..  `.  `..`.. `..  `..`.        
	  `.. ..    `.. `...`...  `.  `..`..     `...  `....   
	                                 `..                   


**stencil1**

	  ###### ####   # # # # ######## # ## #    ####   
	       ####     # # # #  ## # ## # ## #  ####     
	       ####     # # # #  ## # ## # ## #  ####     
	       ######## # # # #  ## # ## # ## #    ####   
	       ####     # # # #  ## # ## # ## #  ####     
	       ####      # # # # ## # ## # # # # ####     
	####   ####      # # # # ## # ## # # # # ####     
	  ####   ####    # # # # # # # # # # # #   ####   


**stencil2**

	  ###### ####   # # # # ######## # ## #    ####   
	       ####     # # # #  ## # ## # ## #  ####     
	       ####     # # # #  ## # ## # ## #  ####     
	       ######## # # # #  ## # ## # ## #    ####   
	       ####     # # # #  ## # ## # ## #  ####     
	       ####      # # # # ## # ## # # # # ####     
	####   ####      # # # # ## # ## # # # # ####     
	  ####   ####    # # # # # # # # # # # #   ####   


**stforek**

	  __   __  __ __ ___ _   ___  
	/' _/ /  \|  V  | _,\ | | __| 
	`._`.| /\ | \_/ | v_/ |_| _|  
	|___/|_||_|_| |_|_| |___|___| 


**Stick_Letters**

	 __              __        ___ 
	/__`  /\   |\/| |__) |    |__  
	.__/ /~~\  |  | |    |___ |___ 
                               


**stop**

	    _                      _       
	   | |                    | |      
	    \ \   ____ ____  ____ | | ____ 
	     \ \ / _  |    \|  _ \| |/ _  )
	 _____) | ( | | | | | | | | ( (/ / 
	(______/ \_||_|_|_|_| ||_/|_|\____)
                    |_|            


**straight**

	 __             
	(_  _  _  _ | _ 
	__)(_|||||_)|(- 
	         |      


**street_s**

	 #####    ########     #### ########          
	####### # ########   ###### ######## #####    
	###     # ######## ######   ######## #####    
	 #####  # ######## ####     ##### #  #####    
	    ### # ######## ####     ## ##### #####    
	####### #  ####### ####     ######## #####    
	 #####  # #### ##  ####     ######## #####    
	        # ## ##### ####     ######## #####    


**Stronger_Than_All**

	.________.______  ._____.___ ._______ .___    ._______
	|    ___/:      \ :         |: ____  ||   |   : .____/
	|___    \|   .   ||   \  /  ||    :  ||   |   | : _/\ 
	|       /|   :   ||   |\/   ||   |___||   |/\ |   /  \
	|__:___/ |___|   ||___| |   ||___|    |   /  \|_.: __/
	   :         |___|      |___|         |______/   :/   
                                                      
                                                      
                                                      


**subteran**

	###    #             ##  ##  ##        ## #   
	##   ###                 ##  # # ###  ### ##  
	# #  ###  ### ## # #### ##   #  ## #          
	 ##  ###  ### # ## ##   ### ##   ###          
	###  ###  #  ##        ####      # #          
	###  ###  ##   ###                   # ##     
	###  ###     #  #   # # #   # ##  ##          
	### ####            #  # #  #    ###          


**sub-zero**

	 ______     ______     __    __     ______   __         ______    
	/\  ___\   /\  __ \   /\ "-./  \   /\  == \ /\ \       /\  ___\   
	\ \___  \  \ \  __ \  \ \ \-./\ \  \ \  _-/ \ \ \____  \ \  __\   
	 \/\_____\  \ \_\ \_\  \ \_\ \ \_\  \ \_\    \ \_____\  \ \_____\ 
	  \/_____/   \/_/\/_/   \/_/  \/_/   \/_/     \/_____/   \/_____/ 
                                                                  


**super_te**

	 ####            # #### # # #### # # #### #          
	##  ##             #### # # #### # # ####            
	##       #       ###### # # #### # # ######          
	 #####  ####     ###### # # #### # # ###### ####     
	     ## #####    ###### # # #####  # ######          
	##   ## ######   ##### ## ## ##### ## #####          
	 #####  #######       ##   ## ####  ##               
	        ######## ######     ## ###   ######          


**swampland**

	 ______   ________   ___ __ __   ______   __       ______      
	/_____/\ /_______/\ /__//_//_/\ /_____/\ /_/\     /_____/\     
	\::::_\/_\::: _  \ \\::\| \| \ \\:::_ \ \\:\ \    \::::_\/_    
	 \:\/___/\\::(_)  \ \\:.      \ \\:(_) \ \\:\ \    \:\/___/\   
	  \_::._\:\\:: __  \ \\:.\-/\  \ \\: ___\/ \:\ \____\::___\/_  
	    /____\:\\:.\ \  \ \\. \  \  \ \\ \ \    \:\/___/\\:\____/\ 
	    \_____\/ \__\/\__\/ \__\/ \__\/ \_\/     \_____\/ \_____\/ 
                                                               


**swan**

                              
	                              
	 .-.                    .     
	(   )                   |     
	 `-.  .-.  .--.--. .,-. | .-. 
	(   )(   ) |  |  | |   )|(.-' 
	 `-'  `-'`-'  '  `-|`-' `-`--'
	                   |          
	                   '          


**sweet**

	                                               ___           
	                                              (   )          
	    .--.      .---.   ___ .-. .-.      .-..    | |    .--.   
	  /  _  \    / .-, \ (   )   '   \    /    \   | |   /    \  
	 . .' `. ;  (__) ; |  |  .-.  .-. ;  ' .-,  ;  | |  |  .-. ; 
	 | '   | |    .'`  |  | |  | |  | |  | |  . |  | |  |  | | | 
	 _\_`.(___)  / .'| |  | |  | |  | |  | |  | |  | |  |  |/  | 
	(   ). '.   | /  | |  | |  | |  | |  | |  | |  | |  |  ' _.' 
	 | |  `\ |  ; |  ; |  | |  | |  | |  | |  ' |  | |  |  .'.-. 
	 ; '._,' '  ' `-'  |  | |  | |  | |  | `-'  '  | |  '  `-' / 
	  '.___.'   `.__.'_. (___)(___)(___) | \__.'  (___)  `.__.'  
	                                     | |                     
	                                    (___)                    


**tanja**

	 S)ssss                             l)L          
	S)    ss                             l)          
	 S)ss    a)AAAA   m)MM MMM  p)PPPP   l)  e)EEEEE 
	     S)   a)AAA  m)  MM  MM p)   PP  l)  e)EEEE  
	S)    ss a)   A  m)  MM  MM p)   PP  l)  e)      
	 S)ssss   a)AAAA m)      MM p)PPPP  l)LL  e)EEEE 
	                            p)                   
	                            p)                   


**tav1____**

	  ##     ##   ####     ######   ###### ######   
	 ## #    #### ###### ######## ######## ######   
	 ##      ####        ####     ####              
	  ####   #### ######   ###### ####     ######   
	      ## ####   ####          ####              
	 ###  ## #### ###### ######## ######## ######   
	  #####  #### ####   ########   ###### ######   
                                                


**taxi____**

	          ##   ##   ## #####  ##     ######  
	         ####  ### ### ##  ## ##     ##      
	  ##### ##  ## ####### ##  ## ##     ##      
	 ##     ###### ## # ## #####  ##     ####    
	  ####  ##  ## ##   ## ##     ##     ##      
	     ## ##  ## ##   ## ##     ##     ##      
	 #####  ##  ## ##   ## ##     ###### ######  
                                             


**tec1____**

	          # #  #  # #  # #  #  #   #   ###   #  #  # 
	  ###### ##    ##  #  ## #    ## # # # ##   # # # #  
	 ##      ######## #   ##    ## #   ##  ## # #   ###  
	  ####     #      # #  #     #     #   ###   ##  #   
	     ##  ##  ##   ###  # # ####### # #   ## #   ##   
	 #####   #  #  ## ##   ##   #  ##      ## #  #  #    
	          ##  ##   ##  # # # # #  #  ##   # #    ##  
	               #   #  #        #   #   ## # # # #  # 


**tec_7000**

	          # #  #  # #  # #  #  #   #   ###   #  #  # 
	  ###### ##    ##  #  ## #    ## # # # ##   # # # #  
	 ##      ######## #   ##    ## #   ##  ## # #   ###  
	  ####     #      # #  #     #     #   ###   ##  #   
	     ##  ##  ##   ###  # # ####### # #   ## #   ##   
	 #####   #  #  ## ##   ##   #  ##      ## #  #  #    
	          ##  ##   ##  # # # # #  #  ##   # #    ##  
	               #   #  #        #   #   ## # # # #  # 


**tecrvs__**

	          # #  #  # #  # #  #  #   #   ###   #  #  # 
	  ###### ##    ##  #  ## #    ## # # # ##   # # # #  
	 ##      ######## #   ##    ## #   ##  ## # #   ###  
	  ####     #      # #  #     #     #   ###   ##  #   
	     ##  ##  ##   ###  # # ####### # #   ## #   ##   
	 #####   #  #  ## ##   ##   #  ##      ## #  #  #    
	          ##  ##   ##  # # # # #  #  ##   # #    ##  
	               #   #  #        #   #   ## # # # #  # 


**tengwar**

	            db                                              .dP' 
	         db    db                                         dP'    
	                                                                 
	.d888b.    'Yb    `Yb d88b d88b   `Yb.d888b   `Y8888888b.  'Yb   
	8'   `Yb    88     88P   88   8b   88'    8Y     .dP'       88   
	Yb.   88    88     88    8P   88   88     8P   ,dP          88   
	    .dP    .8P     88  .dP  .dP    88   ,dP    88     .    .8P   
	  .dP'            .888888888888b.  88888888b.  `Yb...dP          
	.dP'                               88            `"""'           
	                                  .8P                            
	

**term**

	Sample

**test1**

	 __________ _______  ___   ___ _________  ____      __________
	/_________//   O   \|   \ /   |    _o___)/   /_____/   /_____/
	`%%%%%%%%%/___/%\___\____|____|___|%%%%%'\___\_____\___\%%%%%'
	`BBBBBBBB'`BB'   `BB'`BBBBBBB' `B'        `BBBBBBBB'`BBBBBBBB'


**The_Edge**
	
	   ▄▄▄▄▄   ██   █▀▄▀█ █ ▄▄  █     ▄███▄   
	  █     ▀▄ █ █  █ █ █ █   █ █     █▀   ▀  
	▄  ▀▀▀▀▄   █▄▄█ █ ▄ █ █▀▀▀  █     ██▄▄    
	 ▀▄▄▄▄▀    █  █ █   █ █     ███▄  █▄   ▄▀ 
	              █    █   █        ▀ ▀███▀   
	             █    ▀     ▀                 
	            ▀                             


**thick**

	.d88b.                     8       
	YPwww. .d88 8d8b.d8b. 88b. 8 .d88b 
	    d8 8  8 8P Y8P Y8 8  8 8 8.dP' 
	`Y88P' `Y88 8   8   8 88P' 8 `Y88P 
	                      8            


**thin**

	                              
	,---.               |         
	`---.,---.,-.-.,---.|    ,---.
	    |,---|| | ||   ||    |---'
	`---'`---^` ' '|---'`---'`---'
	               |              

**THIS**

	 ▄▀▀▀▀▄  ▄▀▀█▄   ▄▀▀▄ ▄▀▄  ▄▀▀▄▀▀▀▄  ▄▀▀▀▀▄     ▄▀▀█▄▄▄▄ 
	█ █   ▐ ▐ ▄▀ ▀▄ █  █ ▀  █ █   █   █ █    █     ▐  ▄▀   ▐ 
	   ▀▄     █▄▄▄█ ▐  █    █ ▐  █▀▀▀▀  ▐    █       █▄▄▄▄▄  
	▀▄   █   ▄▀   █   █    █     █          █        █    ▌  
	 █▀▀▀   █   ▄▀  ▄▀   ▄▀    ▄▀         ▄▀▄▄▄▄▄▄▀ ▄▀▄▄▄▄   
	 ▐      ▐   ▐   █    █    █           █         █    ▐   
	                ▐    ▐    ▐           ▐         ▐        


**Thorned**

	 _, _    , , ,_ ,    _, 
	(_,'|\  |\/| |_)|   /_, 
	 _) |-\ | `|'| '|__'\_  
	'   '  `'  ` '    '   ` 
                        


**threepoint**

	(~ _  _ _  _ | _ 
	_)(_|| | ||_)|(/_
	          |      


**ticks**

	___/\/\/\/\/\__________________________________________/\/\_______________
	_/\/\__________/\/\/\______/\/\/\__/\/\____/\/\/\/\____/\/\______/\/\/\___
	___/\/\/\/\________/\/\____/\/\/\/\/\/\/\__/\/\__/\/\__/\/\____/\/\/\/\/\_
	_________/\/\__/\/\/\/\____/\/\__/\__/\/\__/\/\/\/\____/\/\____/\/\_______
	_/\/\/\/\/\____/\/\/\/\/\__/\/\______/\/\__/\/\________/\/\/\____/\/\/\/\_
	___________________________________________/\/\___________________________


**ticksslant**

	     ___/\/\/\/\/\__________________________________________/\/\_______________
	    _/\/\__________/\/\/\______/\/\/\__/\/\____/\/\/\/\____/\/\______/\/\/\___ 
	   ___/\/\/\/\________/\/\____/\/\/\/\/\/\/\__/\/\__/\/\__/\/\____/\/\/\/\/\_  
	  _________/\/\__/\/\/\/\____/\/\__/\__/\/\__/\/\/\/\____/\/\____/\/\_______   
	 _/\/\/\/\/\____/\/\/\/\/\__/\/\______/\/\__/\/\________/\/\/\____/\/\/\/\_    
	___________________________________________/\/\___________________________     


**tiles**

	  [.. ..                                  [..          
	[..    [..                                [..          
	 [..         [..    [... [.. [.. [. [..   [..   [..    
	   [..     [..  [..  [..  [.  [..[.  [..  [.. [.   [.. 
	      [.. [..   [..  [..  [.  [..[.   [.. [..[..... [..
	[..    [..[..   [..  [..  [.  [..[.. [..  [..[.        
	  [.. ..    [.. [...[...  [.  [..[..     [...  [....   
	                                 [..                   


**times**

                           
                           
	                     #     
	 ####                #     
	###   ##  #####  ##  #  ## 
	 ###   ## ## # # # # # ### 
	  ### ### ## # # # # # ##  
	####  ### ## # # ##  #  ## 
	                 #         
	                 #         
                           


**timesofl**

	######## ##  ####  ####  #       ##     ####       ## 
	######## ##  ####   ##   # #  ##  # #  ##### #  ### # 
	###    # ##   ###    #   # #  ##  # #  ##### #  ##### 
	##  #### # #  ###  #  #  # #     ## #  ##### #    ### 
	###  ### #     ##  ## #  # #  ##### #  ### # #  ### # 
	# ##   #  ###  ##  ####  # #  ##### #  ##  # #  ##  # 
	#     ##  ####  #   ##         ####        #        # 
	######## ######## ######## ######## ######## ######## 


**tinker-toy**

	 o-o                 o     
	|                    |     
	 o-o   oo o-O-o o-o  | o-o 
	    | | | | | | |  | | |-' 
	o--o  o-o-o o o O-o  o o-o 
	                |          
	                o          


**ti_pan__**

	  ###               #                     
	 ##  #  # # # # # #      # # # # # # # #  
	 ##              ## # #                   
	#####            # ##  #         #        
	    ##           # # # #           #      
	 #   #           ##  # #         #        
	  ###            # # # # #                
	        # # # #  # # # #             # #  
	

**t__of_ap**

	          ###   ###   ## ###### ###    #####    
	         #  ##   # # ###  ##  ## #      ## ###  
	   ###  ##  ##   #######  ##  ## ##     ##      
	  ##    #   ##   ## # ##  #####  ##     ####    
	   ###  #   ##   ##   ##  ##     ##     ##      
	     ## ##  ##   ##   ##  ##     #  ### ## ###  
	  ####   ###### ###   ## ###    #####  #####    
	                #        #      #      #        


**tomahawk**

	            #   # ###  #   #### # # ###  # ##### ## 
	  ####  #    # #  ### ##   # #          ## ##       
	 ##  ##   ##  # # ####     #   ## # #### #     #    
	 ##     #  #     ##### # ### #     ##### # ## #     
	  ####        # ##  # ## #  #   # ####  ##   #  ### 
	     ## ###  ## # #### #   ## ##  # #### # # #  # # 
	 ##  ##   ## ###    ## # # ##   # #    # #   ## ##  
	  ####  # #  # # # ###     ##  #    ##  #    # #  # 


**tombstone**

	  _,  _, _, _ __, _,  __,
	 (_  /_\ |\/| |_) |   |_ 
	 , ) | | |  | |   | , |  
	  ~  ~ ~ ~  ~ ~   ~~~ ~~~
	                         
**top_duck**

	  ##### # # ##  # ##  # ######## # # #   ######## 
	 ###  ##  # #   # ##  # ######## # # #   #######  
	 ##    #      # # ##  # ######## # # #   ##### #  
	  #### #    # # # ## #   # # # # # #      # ## #  
	     ## ##      # # ##  #### # # # #   #  # ## #  
	##  ### #   ##  # ##  # ###### # # # #    # ## #  
	 #####  #   # #  #  # # ###### # # # # # #  ## #  
	          # # # # # # # ######## # # # # #  ## #  


**train**

	   ___                     _ __     _            
	  / __|   __ _    _ __    | '_ \   | |     ___   
	  \__ \  / _` |  | '  \   | .__/   | |    / -_)  
	  |___/  \__,_|  |_|_|_|  |_|__   _|_|_   \___|  
	_|"""""|_|"""""|_|"""""|_|"""""|_|"""""|_|"""""| 
	"`-0-0-'"`-0-0-'"`-0-0-'"`-0-0-'"`-0-0-'"`-0-0-' 
	

**trashman**

	                               ###          
	 ######                         ##          
	 #  ##   ####   ####### ######  ##   ####   
	   ##   ##  ##  ## ## ## ##  ## ##  ##  ##  
	    ##  ##  ##  ## ## ## ##  ## ##  ######  
	 ##  ## ##  ##  ## ## ## #####  ##  ##      
	  ####   ### ## ## ## ## ##    ####  #####  
	                        ####                


**trek**

	  .dBBBBP dBBBBBb     dBBBBBBb dBBBBBb  dBP    dBBBP 
	  BP           BB          dBP     dB'               
	  `BBBBb   dBP BB   dBPdBPdBP  dBBBP' dBP    dBBP    
	     dBP  dBP  BB  dBPdBPdBP  dBP    dBP    dBP      
	dBBBBP'  dBBBBBBB dBPdBPdBP  dBP    dBBBBP dBBBBP    
                                                     


**triad_st**

	  ##### #  #    ##   ##         #  #####    # ##   
	 ######       # ##     #    ### #       # # #      
	 ##    ##        # # # # # # # #  # #      # # #   
	 ##          ##  # # # # # ###### #         ###  # 
	  ####  #        # ###      ## #           # #     
	     ##      ##      ###             # #  # # ## # 
	 #####    ###   #    # #  # # #  ####   #  ####    
	           # #    #  # #  ######  #    ## # #      


**ts1_____**

	  #####  ##         ### ### #####  # 
	 ##   #                     # # #    
	 ###    # # #  #         #        #  
	  ####   ##        ## ####  #### ##  
	    ###                     # #      
	 #   ## # ## # #                  #  
	 #####  # #        # # #     # ## #  
	                             ##      


**tsalagi**

	         __   -|-      ___   ___    ___   
	 |--\   |  \   |        |     |      |    
	 |_     |   \  |     (|_|_    |      |_,  
	 |      |   /  | _    | |     |  .   | '  
	 |--/   |__/    _|    `_'     `__'  _|_   
	

**tsm_____**

	   #####  ##  #   ##         #            ##  # 
	          ##      ##       ### ###        ##    
	  ##     ####     ##      ##   ##         ##    
	   ##    ####     #   #  ##               ##    
	    ##  #####     ##### ####              #     
	     ## ##### # #####   # ##              #     
	 #####  #######    #   ##  ##             #     
	                       #   ##        #          


**tsn_base**

	        ######## ### #               #  ## 
	  ##### ##      ##   #     #####     #  ## 
	 ##     ##      ##   #    ##         #  ## 
	  ####  ##      ##   #    ## ###     #  ## 
	     ## ##      ##   #    ##  ##     #  ## 
	 #####  ##      ##   #     ####   ####  ## 
	        ##      ##   #                  ## 
	        ##       ### ### ######## ####  ## 


**ttyb**

                                                           
	 ###                 ###      
	#                      #      
	##   #### ##### ####   #  ##  
	  ##    # # # # #  #   # #### 
	   # #### # # # #  #   # #    
	###  #### # # # ###    #  ### 
	                #             
	                #             


**tty**

                                                            
###                  ###      
#                      #      
##   ###  ##### ###    #  ### 
  ## ###  # # # #  #   # #### 
   # # #  # # # #  #   # #    
###  ## # # # # ###    #  ### 
                #             
                #             


**tubular**

	  O~~ ~~                                  O~~          
	O~~    O~~                                O~~          
	 O~~         O~~    O~~~ O~~ O~~ O~ O~~   O~~   O~~    
	   O~~     O~~  O~~  O~~  O~  O~~O~  O~~  O~~ O~   O~~ 
	      O~~ O~~   O~~  O~~  O~  O~~O~   O~~ O~~O~~~~~ O~~
	O~~    O~~O~~   O~~  O~~  O~  O~~O~~ O~~  O~~O~        
	  O~~ ~~    O~~ O~~~O~~~  O~  O~~O~~     O~~~  O~~~~   
	                                 O~~                   


**twin_cob**

	  ## ###                                          
	 ##    #  #####  ##   ## ######  ##      #######  
	 ###     ##   ## ### ### ##   ## ##      ##       
	  #####  ####### ## # ## ######  ##      ######   
	    #### ##   ## ##   ## ##      ##      ##       
	 #    ## ##   ## ##   ## ##      ####### #######  
	 ### ##                                           
                                                  


**twisted**

	 ______    _____    __    __    __ __     __        _____  
	/ ____/\  /\___/\  /_/\  /\_\  /_/\__/\  /\_\     /\_____\ 
	) ) __\/ / / _ \ \ ) ) \/ ( (  ) ) ) ) )( ( (    ( (_____/ 
	 \ \ \   \ \(_)/ //_/ \  / \_\/_/ /_/ /  \ \_\    \ \__\   
	 _\ \ \  / / _ \ \\ \ \\// / /\ \ \_\/   / / /__  / /__/_  
	)____) )( (_( )_) ))_) )( (_(  )_) )    ( (_____(( (_____\ 
	\____\/  \/_/ \_\/ \_\/  \/_/  \_\/      \/_____/ \/_____/ 
                                                           


**twopoint**

	(~ _ ._ _ |)| _
	_)(_|| | || |}_


**type_set**
	
	          ##   #    # #####  #      ######  
	         #  #  ##  ## #    # #      #       
	  ##### #    # # ## # #    # #      #       
	 #      ###### # ## # #####  #      ####    
	  ####  #    # #    # #      #      #       
	      # #    # #    # #      #      #       
	 #####  #    # #    # #      ###### ######  
	                                            

**ucf_fan_**

	         ####   ### ##   ####   ###     #######  
	        ### ##  ### ### ### ##  ###     ###  ##  
	 ###### ###  ## ####### ###  ## ###     ###      
	###     ###  ## #### ## ######  ###     ######   
	 #####  ####### ###  ## ###     ###     ###      
	     ## ###  ## ###  ## ###     ###  ## ###  ##  
	######  ###  ## ###  ## ###     ####### #######  
                                                 
**ugalympi**

	       ## #     #    #     # #    # #  #  ###     
	       ### ##  #  #   #    # #        ## # #  ### 
	       # # #  # #       ## #  #    ##    # #### # 
	  ####   ###   #   #      # # #  ## #  #  ## # ## 
	 ###   #  # # #   #    #    # # #   # ## # #  ### 
	  #### ##  # # #####  # #   # # #    # # #    # # 
	    ## # ####  ##  # # # ####    #    ##  #    ## 
	 ####      ##     #     ## # ## # ##   # ##   ##  


**unarmed_**

	 #####  ########  # ##    ######     #### #######  
	##   ## # # #    #### ### ###  #       ##       #  
	##      ######## ### ##   #  # #    #####  # # ##  
	 #####   # # #   #####     #   #               #   
	     ##  ####### #     #  #  # # ## ##     # ###   
	##   ##    # # # #####     #   # # ## #      #     
	 #####     ##### #     ## #  # # ## ##    ####     
	             ### ### ###   #   #     #    ##       


**univers**

	                                                                     
	 ad88888ba                                            88             
	d8"     "8b                                           88             
	Y8,                                                   88             
	`Y8aaaaa,   ,adPPYYba, 88,dPYba,,adPYba,  8b,dPPYba,  88  ,adPPYba,  
	  `"""""8b, ""     `Y8 88P'   "88"    "8a 88P'    "8a 88 a8P_____88  
	        `8b ,adPPPPP88 88      88      88 88       d8 88 8PP"""""""  
	Y8a     a8P 88,    ,88 88      88      88 88b,   ,a8" 88 "8b,   ,aa  
	 "Y88888P"  `"8bbdP"Y8 88      88      88 88`YbbdP"'  88  `"Ybbd8"'  
	                                          88                         
	                                          88                         


**usaflag**

	 :::===  :::====  :::=======  :::====  :::      :::=====
	 :::     :::  === ::: === === :::  === :::      :::     
	  =====  ======== === === === =======  ===      ======  
	     === ===  === ===     === ===      ===      ===     
	 ======  ===  === ===     === ===      ======== ========
	                                                        


**usa_____**

	         # # #  #    ## #     # # # #  # #         # 
	          ## # #   #        # # # #  ## # #  ## #  # 
	 ####### # # # #   ## #  #  # # #    ## # #          
	         # #  # #      ##   # ## #   # #             
	 #######  ## # #  #  #     # # # #   ## #  # ## #  # 
	      ##  # # # #  ## #  # # #  # #  # ## #          
	 #######  # # #        ##   ## # #   #             # 
	          ## #  # #  #     # # # #   ## #  # ## #  # 


**usa_pq__**

	         # ## ###          ########  # # ###          
	         ## ####  # ## ### ######## ######## # ## ### 
	 #######                   ######## ######## ## ####  
	         # ## ###          ## # # # #### ###          
	 ####### ## ####  # ## ###  # # # # # # # #  # ## ### 
	      ##                    # # ### # # # #  ## ####  
	 ####### # ## ###          ## ##### # ## ###          
	         ## ####  # ## ### ########          # ## ### 
	
	
**utopiab**

	                                          
	                               ###        
	 ####                           ##        
	##  #                           ##        
	###    ###   ##### ##   #####   ##   ###  
	 ###  ## ##   ## ## ##   ## ##  ##  ## ## 
	  ###  ####   ## ## ##   ## ##  ##  ##### 
	#  ## ## ##   ## ## ##   ## ##  ##  ##    
	####   ##### ### ## ###  ####  ####  #### 
	                         ##               
	                        ####              


**utopiabi**

                                            
	                                  ###       
	   ####                            ##       
	  ##  #                           ##        
	  ###     #### #########  ######  ##    ##  
	   ##    #  ##  ## ## ##   ## ##  ##   # ## 
	   ###  ## ##   ## ## ##  ### ## ##   ####  
	##  ##  ## ##  ## ## ##   ##  #  ##   ##    
	 ####   ###### ## ## ###  ####   ##   ####  
	                         ##                 
	                         ##                 


**utopia**

	                                     
	                            ##       
	 ####                        #       
	#   #                        #       
	##    ###  #### ##   ## ##   #   ##  
	 ###  #  #  #  #  #   ##  #  #  #  # 
	   ##  ###  #  #  #   #   #  #  #### 
	#   # #  #  #  #  #   #   #  #  #    
	####  #### ### ## ##  ####  ###  ### 
	                      #              
	                     ###             


**utopiai**

                                     
	                             ##      
	  ###                         #      
	 #  #                        #       
	 #      ### ## ## ## ##  ##  #    ## 
	  #    #  #  ## ## #  # # #  #   # # 
	   #  #  #   #  #  #  ##  # #   ###  
	#  #  # ##  #  #  #   #  #  #   #    
	###   ## ## #  #  ## ####   ##   ##  
	                     #               
	                     #               


**varsity**

	  ______                              __         
	.' ____ \                            [  |        
	| (___ \_| ,--.   _ .--..--.  _ .--.  | | .---.  
	 _.____`. `'_\ : [ `.-. .-. |[ '/'`\ \| |/ /__\\ 
	| \____) |// | |, | | | | | | | \__/ || || \__., 
	 \______.'\'-;__/[___||__||__]| ;.__/[___]'.__.' 
	                             [__|                


**vortron_**

	   ####                                      
	  ##  ##    ####     ##      #### # #   #### 
	 ##         ## ## #  ## ### ##    # ##    ## 
	  #####     ##### ####  ### ##      ##  #### 
	      ##    ## ##  ##   ### ## ##       ##   
	 ##   ## ## ## ##  ##        ####   ##  #### 
	  #####                                      
                                             


**war_of_w**

                      
	  ####                
	 ##                   
	  ####                
	     ##               
	##   ##               
	  #### #              
                      


**wavy**

	  __                      
	 (_ ` _   _ _   _   )  _  
	.__) (_( ) ) ) )_) (  )_) 
	              (      (_   


**weird**

	  __                       
	 /                   /     
	(___  ___  _ _  ___ (  ___ 
	    )|   )| | )|   )| |___)
	 __/ |__/||  / |__/ | |__  
	               |           


**wetletter**

	   .---.  .--.           ,---.  ,-.    ,---.   
	  ( .-._)/ /\ \ |\    /| | .-.\ | |    | .-'   
	 (_) \  / /__\ \|(\  / | | |-' )| |    | `-.   
	 _  \ \ |  __  |(_)\/  | | |--' | |    | .-'   
	( `-'  )| |  |)|| \  / | | |    | `--. |  `--. 
	 `----' |_|  (_)| |\/| | /(     |( __.'/( __.' 
	                '-'  '-'(__)    (_)   (__)     


**whimsy**

	                                           d8b        
	                                           88P        
	                                          d88         
	 .d888b, d888b8b    88bd8b,d88b ?88,.d88b,888   d8888b
	 ?8b,   d8P' ?88    88P'`?8P'?8b`?88'  ?88?88  d8b_,dP
	   `?8b 88b  ,88b  d88  d88  88P  88b  d8P 88b 88b    
	`?888P' `?88P'`88bd88' d88'  88b  888888P'  88b`?888P'
	                                  88P'                
	                                 d88                  
	                                 ?8P                  


**wow**

	((5 //-\ ][\/][ ]]P ][_ ]E 


**xbriteb**

                                      
	 ###                        ##        
	#  #                         #        
	#                            #        
	 #   ####  ########  #####   #   ###  
	  ##    #   #  #  #   #   #  #  #   # 
	   # ####   #  #  #   #   #  #  ##### 
	#  # #  #   #  #  #   #   #  #  #     
	###  ##### #########  ####  ###  #### 
	                      #               
	                     ###              


**xbritebi**

                                        
	  ####                          ##      
	 #   #                          #       
	 #                              #       
	  #      #### ### #####  #####  #    ## 
	   ##   #  ##  ###### #  ### #  #   # # 
	    #  #   #   ## ##  #  ##  #  #  ###  
	#   #  # ###  ##  #  #   #  #   #  #  # 
	####   ###### ##  #  ##  ###   ##  #### 
	                        #               
	                        #               


**xbrite**

                                     
                                     
	 ###                        ##       
	#  #                         #       
	#                            #       
	 #   ####  ########  #####   #   ##  
	  ##    #   #  #  #   #   #  #  #  # 
	   #  ###   #  #  #   #   #  #  #### 
	#  # #  #   #  #  #   #   #  #  #    
	###  ### # #########  ####  ###  ### 
	                      #              
	                     ###             


**xbritei**

                                     
                                     
	  ###                        ##      
	 #  #                         #      
	 #                           #       
	  #     ### ########  #####  #    ## 
	   #   #  #  ## ## # #### #  #   # # 
	   #  #   #  #  #  #  ##  #  #  ###  
	#  #  #  #  #  ## #   #  #  #   #  # 
	###   ##### #  #  ##  ###   ##  #### 
	                     #               
	                     #               


**xchartr**

                                
                                
	                         #      
	 ####                    #      
	#   #                    #      
	#      ##  ####### ####  #  ##  
	 ###    ## #  #  # #   # # #  # 
	    # ## # #  #  # #   # # #### 
	#   # #  # #  #  # #  ## # #    
	####   ### ## ## # ###   #  ### 
	                   #            
	                   ##           


**xchartri**

                                     
                                     
                                     
	                             ##      
	  ####                        #      
	 #   #                        #      
	 #       ### #### ##   #####  #   #  
	  ##    #  #  # ## #    #  # #   ### 
	    #  #   # #  #  #   #   # #  ##   
	#   #  #  #  #  #  #   #  #  #  #  # 
	 ###    #### #  #  ##  ###   ##  ##  
	                       #             
	                      ###            


**xcourb**

                                                                                
	                            ###         
	 ####                        ##         
	##  #  ###   #####  #####    ##    ###  
	####  ## ##   #####  ## ##   ##   ## ## 
	  ###  ####   # # #  ## ##   ##   ##### 
	#  ## ## ##   # # #  ## ##   ##   ##    
	####  ######  # # #  ####  ######  #### 
	                     ##                 
	                    ####                


**xcourbi**

                                                                                        
	                                 ###        
	  ####                            ##        
	 ##  #   ###   #####   #####     ##    ###  
	 ####      ##   # # #   ## ##    ##   ## ## 
	   ###  #####   # # #   #  ##   ##   ###### 
	##  #  ## ##   # # #   ## ##    ##   ##     
	####   ###### ## # ##  ####   #####   ####  
	                       ##                   
	                      ####                  


**xcour**

                                   
                                   
	                         ##        
	 ###                      #        
	#     ##   ## #   # ##    #    ##  
	 ##     #  # # #   #  #   #   #  # 
	   #  ###  # # #   #  #   #   ###  
	#  # #  #  # # #   #  #   #   #    
	###   ## # # # ##  ###  #####  ### 
	                   #               
	                  ###              


**xcouri**

                                       
                                       
	                              ##       
	  ###                          #       
	 #  #   ###   ## #   # ##     #    ##  
	 ##        #  # # #   #  #    #   #  # 
	   #   #####  # # #   #  #    #  ##### 
	#   # #   #  # # #   #   #   #   #     
	####   ### # # # #   ####  #####  ###  
	                     #                 
	                    ##                 


**xhelvb**

                                      
                                      
	                                      
	 ####                        ##       
	##  ##                       ##       
	###     ###   # ## ##  # ##  ##  ###  
	 ####  #  ##  ## ## ## ## ## ## ## ## 
	   ###  ####  ## ## ## ##  # ## ##### 
	#   ## ## ##  ## ## ## ##  # ## ##    
	##  ## ## ##  ## ## ## ## ## ## ## ## 
	 ####   ## ## ## ## ## ####  ##  ###  
	                       ##             
	                       ##             


**xhelvbi**

                                              
                                              
	                                              
	   ####                             ##        
	  ##  ##                            ##        
	  ##       ###   # ## ##    ####   ##    ###  
	  ###     #  ##  ## ## ##   ## ##  ##   ## ## 
	   ###     ####  ## ## ##   #  ##  ##   ##### 
	##  ##   ## ##  ## ## ##   ##  #  ##   ##     
	##  ##   ## ##  ## ## ##   ## ##  ##   ## ##  
	 ####     ## ## ## ## ##   ####   ##    ###   
	                          ##                  
	                          ##                  


**xhelv**

                                 
                                 
	                                 
	 ###                      #      
	#   #                     #      
	#     ###   ### ##  # ##  #  ##  
	 ###     #  #  #  # ##  # # #  # 
	    #  ###  #  #  # #   # # #### 
	#   # #  #  #  #  # #   # # #    
	#   # #  #  #  #  # ##  # # #  # 
	 ###   ## # #  #  # # ##  #  ##  
	                    #            
	                    #            
	

**xhelvi**

                                        
                                        
                                        
	   ###                          #       
	  #   #                         #       
	 #       ###   ### ##    ###   #    ### 
	  ###       #  #  #  #   #  #  #   #  # 
	     #   ####  #  #  #   #  #  #  ####  
	#    #  #  #  #  #  #   #   # #   #     
	#   #   #  #  #  #  #   #  #  #   #  #  
	 ###     ## # #  #  #   ###   #    ##   
	                       #                
	                       #                


**xsansb**

                                     
	                            ##       
	 ####                       ##       
	##     ###   # ## ##  # ##  ##  ###  
	###      ##  ## ## ## ## ## ## ## ## 
	 ###   ####  ## ## ## ## ## ## ## ## 
	  ### ## ##  ## ## ## ## ## ## ##### 
	   ## ## ##  ## ## ## ## ## ## ##    
	####   ## ## ## ## ## ####  ##  #### 
	                      ##             
	                      ##             
	

**xsansbi**

                                           
	                                  ##       
	  ####                            ##       
	 ##      ####  ## ## ##   ## ##  ##    ### 
	 ##     ## ##  ########   #####  ##   # ## 
	  ##   ##  ##  ## ## ##   ## ##  ##  ## ## 
	   ##  ## ##  ##  #  #   ##  ## ##   ####  
	   ##  #####  ## ## ##   ## ##  ##   ##    
	####   ## ##  ## ## ##   ####   ##    ###  
	                        ##                 
	                        ##                 


**xsans**

                               
	                        #      
	 ###                    #      
	#     ##   # #  #  # #  #  ##  
	#       #  ## ## # ## # # #  # 
	 ##   ###  #  #  # #  # # #### 
	   # #  #  #  #  # #  # # #    
	   # #  #  #  #  # #  # # #    
	###   ## # #  #  # ###  #  ### 
	                   #           
	                   #           


**xsansi**

                                      
	                              #       
	  ###                         #       
	 #      ###  # ## ##   # ##  #    ### 
	 #     #  #  ## ## #   ## #  #   #  # 
	  #   #   #  #  #  #   #  #  #  #  #  
	   #  #  #  #  #  #   #   # #   ###   
	   #  # ##  #  #  #   #  #  #   #     
	###   ## #  #  #  #   ###   #    ###  
	                     #                
	                     #                


**xsbookb**

                                          
                                                                                    
	 ### #                         ###        
	##  ##                          ##        
	##   #                          ##        
	####   ###  ## ##  ##   ## ##   ##   ###  
	  ####   ## ### ### ##  ### ##  ##  ## ## 
	#   ##  ### ##  ##  ##  ##  ##  ##  ##### 
	##  ## # ## ##  ##  ##  ##  ##  ##  ##    
	# ###  #### ##  ##  ##  #####  ####  #### 
	                        ##                
	                       ####               


**xsbookbi**

                                           
                                           
	                                           
	  ####                           ###       
	 ##  #                            ##       
	 #                               ##        
	 ###     #### ## ## ##   ## ##   ##    ### 
	  ###  ##  ##  ## ## ##   ## ##  ##   #  # 
	    #  ## ##   ## ## ##   ## ## ##   ####  
	#  ##  ## ##  ## ## ##   ##  #  ##   ##  # 
	####    ## ## ## ## ###  ####   ###   ###  
	                         ##                
	                        ####               


**xsbook**

                                     
                                     
                                     
	 ####                       ##       
	#   #                        #       
	#                            #       
	###    ##   # ## ##   # ##   #   ##  
	   ## #  #   #  #  #   #  #  #  #  # 
	    #  ###   #  #  #   #  #  #  #### 
	#   # #  #   #  #  #   #  #  #  #    
	####  ##### ### ## ##  ###  ###  ### 
	                       #             
	                      ###            


**xsbooki**

                                      
                                      
                                      
	  ####                        ##      
	 #   #                         #      
	 #                            #       
	 ##      ### ## ## ##  ## ##  #    ## 
	   ##   #  #  ## ## #   ## #  #   # # 
	    #  #  #   #  #  #   #  # #   ###  
	#   #  #  #  #  #  #   #  #  #   #  # 
	####    ## # #  #  ##  ###   ##   ##  
	                       #              
	                      ###             


**xtimes**

                                  
                                  
                                  
	 ####                     ##      
	##  #                     ##      
	###    ##   # # ##   ###  ##  ### 
	 ###  # ##  #######  ## # ## ## # 
	  ###  ###  ## # ##  ## # ## #### 
	#  ## #  #  ## # ##  ## # ## ##   
	####  ##### ## # ### ###  ##  ### 
	                     ##           
	                     ###          
                                  


**xttyb**

                                   
	                        ####       
	 ####                     ##       
	##     ###  ####  # ##    ##  ###  
	###      ## # # # ## ##   ## ## ## 
	 ###   #### # # # ## ##   ## ## ## 
	  ### ## ## # # # ## ##   ## ##### 
	   ## ## ## # # # ## ##   ## ##    
	####   ## # # # # ####    ##  #### 
	                  ##               
	                  ##               


**xtty**

                              
	                     ###      
	 ###                   #      
	#     ##  ## #  # #    #  ##  
	#       # # # # ## #   # #  # 
	 ##   ### # # # #  #   # #### 
	   # #  # # # # #  #   # #    
	   # # ## # # # #  #   # #    
	###   # # # # # ###    #  ### 
	                #             
	                #             


**yie-ar__**

	  #### # # # #     # # # # 
	 ### ##   ## #     ####### 
	 ##       ## #     ####### 
	  ####    ####    ######## 
	     ##   ####    ######## 
	### ###   ## #     ####### 
	 #####    ## #     ####### 
	       # # # #     # # # # 


**yie_ar_k**

	  #### # # # #     # # # # 
	 ### ##   ## #     ####### 
	 ##       ## #     ####### 
	  ####    ####    ######## 
	     ##   ####    ######## 
	### ###   ## #     ####### 
	 #####    ## #     ####### 
	       # # # #     # # # # 


**zig_zag_**

	 #####  ## ## #     ####                      
	####### ## ## #      # #        #             
	###  ## ## ## #      # #   # ###   #          
	 ###    ## ## #    # # # #####  #  #          
	   ###  ## ## #    # # # ###  ##   #          
	##  ### ## ## #             ## ## #  #      # 
	 #####  ## ## #               ### #  #    ##  
	        ## ## #                ## # # # ## ## 
	

**zone7___**

	 #####  #### ###          ##            ######## 
	####### ## ### #          ##            ###   ## 
	        ##  #  # ######## ##            #### # # 
	######  ###   ## ######## ####          # ###  # 
	     ## #### ###          #### ######## #  ### # 
	####### ## ### #          ##   ######## # # #### 
	 #####  ##  #  #          ##            ##   ### 
	        ###   ##          ##            ######## 


**z-pilot_**

	 ####      #   #   ########     #### ######## 
	######     # #     ########   ###### ###### # 
	##  ##     #   #   ########     #### ### #  # 
	 ##          #     ######## ######   ### #  # 
	   ##   # #     ## ########   ####   ### #  # 
	##  ##  ### ##     ######## ######   ### #  # 
	######   ##   #### ######## ####     ## # # # 
	 ####    ##     ## ######## ##        # # # # 

