#!/usr/bin/php
<?php

// usage function
function usage( $error='' )
{
	echo "Usage: php testhttp.php <host|ip> <port list>\n";

	if( $error ) {
		echo "Error: ".$error."!\n";
	}

	exit();
}

// test if a string is an IP address
function isIp( $str )
{
	return preg_match( '/^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}\z/', trim($str) );
}


// global vars
define( 'PORT_SEP', ',' );
define( 'HTTP_KO', 0 );
define( 'HTTP_OK', 1 );
define( 'HTTP_REDIR', 2 );

$t_result = [ HTTP_KO=>'KO', HTTP_OK=>'OK',  HTTP_REDIR=>'REDIR' ];

if( $_SERVER['argc']<2 || $_SERVER['argc']>3 ) {
	usage();
}

$host = $_SERVER['argv'][1];

if( $_SERVER['argc'] == 3 ) {
	$port = $_SERVER['argv'][2];
} else {
	// default port
	$port = '80,443';
}
$t_port = explode( PORT_SEP, $port );

$flag_80 = false;
$flag_443 = false;


// main loop
foreach( $t_port as $port )
{
	$info = null;
	$scheme = 'http';
	if( $port == 443 ) {
		$scheme .= 's';
	}
	$u = $scheme.'://'.$host.':'.$port;
	// var_dump( $u );

	$c = curl_init();
	curl_setopt( $c, CURLOPT_URL, $u );
	curl_setopt( $c, CURLOPT_USERAGENT, 'Googlebot/2.1 (+http://www.google.com/bot.html)' );
	// curl_setopt( $c, CURLOPT_NOBODY, true );
	// curl_setopt( $c, CURLOPT_HTTPHEADER, $t_headers );
	curl_setopt( $c, CURLOPT_CONNECTTIMEOUT, 5 );
	curl_setopt( $c, CURLOPT_SSL_VERIFYHOST, false );
	curl_setopt( $c, CURLOPT_SSL_VERIFYPEER, false );
	curl_setopt( $c, CURLOPT_RETURNTRANSFER, true );
	// curl_setopt( $c, CURLOPT_FOLLOWLOCATION, true );
	$r = curl_exec( $c );
	$t_info = curl_getinfo( $c );
	// var_dump( $r );
	// var_dump( $t_info );
	curl_close( $c );

	if( $t_info['http_code'] == 0 )
	{
		$port_is_http = HTTP_KO;
	}
	else
	{
		$t_parse = parse_url( $t_info['url'] );
		//var_dump( $t_parse );

		if( $port == 80 ) {
			$flag_80 = true;
		} elseif( $port == 80 ) {
			$flag_443 = true;
		}

		/*if( $port == 80 && $flag_443 ) {
			$port_is_http = HTTP_KO;
		} elseif( $port == 443 && $flag_80 ) {
			$port_is_http = HTTP_KO;
		} else*/if( $t_parse['host'] == $host && $t_info['primary_port'] == $port ) {
			$port_is_http = HTTP_OK;
		} else {
			$port_is_http = HTTP_REDIR;
			$info = $t_parse['host'];
		}
	}

	echo $port.':'.$t_result[$port_is_http];
	if( $info ) {
		echo ':'.$info;
	}
	echo "\n";
}


// the end
exit();

?>