#!/usr/bin/php
<?php

include( 'Utils.php' );

define( 'DEFAULT_COLOR', 'red' );

$t_colors = [
	0   => 'dark_grey',
	200 => 'light_green',
	301 => 'light_cyan',
	302 => 'light_cyan',
	307 => 'light_cyan',
];

$n_child = 0;
$loop_sleep = 100;
$t_process = [];
$t_signal_queue = [];
$_thread_test_host = 5;
$_thread_test_url = 10;

$options = '';
$options .= 'c'; // enable colors
$options .= 'd:'; // output directory
$options .= 'e:'; // status code
$options .= 'f:'; // file list
$options .= 'g'; // grab files
$options .= 'h:'; // host list
$options .= 'k'; // skip host testing
$options .= 'o'; // save output
$options .= 'r'; // follow redirection
$options .= 's'; // https
$options .= 't:'; // threads
$t_options = getopt( $options );
//var_dump($t_options);
if( !count($t_options) ) {
	usage();
}

if( isset($t_options['d']) ) {
	$_directory = $t_options['d'];
} else {
	$_directory = __DIR__;
}
$_directory = rtrim( $_directory, '/' ).'/quick-hits';
if( !is_dir($_directory) ) {
	@mkdir( $_directory, 0777, true );
	if( !is_dir($_directory) ) {
		usage( 'cannot create ouput directory' );
	}
}

if( isset($t_options['t']) ) {
	$m = preg_match( '#([0-9]+)\-([0-9]+)#', $t_options['t'], $matches );
	if( $m ) {
		$_thread_test_host = $matches[1];
		$_thread_test_url = $matches[2];
	}
}

if( isset($t_options['s']) ) {
	$_https = true;
} else {
	$_https = false;
}

if( isset($t_options['e']) ) {
	$t_status_code = explode( ',', $t_options['e'] );
} else {
	$t_status_code = null;
}

if( isset($t_options['f']) ) {
	$_file = $t_options['f'];
	if( !is_file($_file) ) {
		$t_file = [ $_file ];
	} else {
		$t_file = file( $_file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES );
	}
} else {
	usage( 'file list not found' );
}

if( isset($t_options['o']) ) {
	$_output = true;
} else {
	$_output = false;
}

if( isset($t_options['g']) ) {
	$_grab = true;
} else {
	$_grab = false;
}

if( isset($t_options['k']) ) {
	$_host_testing = false;
} else {
	$_host_testing = true;
}

if( isset($t_options['c']) ) {
	$_colors = true;
} else {
	$_colors = false;
}

if( isset($t_options['k']) ) {
	$_redirect = true;
} else {
	$_redirect = false;
}

if( isset($t_options['h']) ) {
	$_host = $t_options['h'];
	if( !is_file($_host) ) {
		$t_host = [ $_host ];
	} else {
		$t_host = file( $_host, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES );
	}
} else {
	usage( 'host list not found' );
}

echo "\n";

$f_alive = $_directory.'/alive_'.uniqid(true).'.txt';
@unlink( $f_alive );
$f_output = $_directory.'/output_'.uniqid(true).'.txt';
if( $_output ) {
	echo 'Output file: '.$f_output."\n";
}
@unlink( $f_output );
$f_url = $_directory.'/urls_'.uniqid(true).'.txt';
@unlink( $f_url );

posix_setsid();
declare( ticks=1 );
pcntl_signal( SIGCHLD, 'signal_handler' );

if( $_host_testing ) {
	$max_child = $_thread_test_host;
	$t_host_alive = test_host( $t_host );
} else {
	$t_host_alive = $t_host;
}

create_urls( $t_host_alive, $t_file, $_https );

$max_child = $_thread_test_url;
test_url();

exec( 'grep "C=200" '.$f_output.' | wc -l', $output );
$cnt = $output[0];
echo "\n".$cnt." urls found!\n";

if( $_output ) {
	echo "\nOutput file: ".$f_output."\n";
}

sleep( 1 );

if( !$_output ) {
	@unlink( $f_alive );
	@unlink( $f_output );
	@unlink( $f_url );
}

echo "\n";

exit();


function output( $txt, $color=null )
{
	global $_colors;

	if( $_colors && !is_null($color) ) {
		Utils::_print( $txt, $color );
	} else {
		echo $txt;
	}
}


function test_single( $url, $max_length )
{
	global $t_colors, $_grab, $_directory, $_redirect, $t_status_code;

	$c = curl_init();
	curl_setopt( $c, CURLOPT_URL, $url );
	curl_setopt( $c, CURLOPT_CONNECTTIMEOUT, 3 );
	// curl_setopt( $c, CURLOPT_SSL_VERIFYPEER, false );
	// curl_setopt( $c, CURLOPT_NOBODY, true );
	curl_setopt( $c, CURLOPT_USERAGENT, 'Mozilla/5.0 (X11; Linux x86_64; rv:56.0) Gecko/20100101 Firefox/56.0' );
	curl_setopt( $c, CURLOPT_RETURNTRANSFER, true );
	if( $_redirect ) {
		curl_setopt( $c, CURLOPT_FOLLOWLOCATION, true );
	}
	$datas = trim( curl_exec( $c ) );
	$t_infos = curl_getinfo( $c );
	//var_dump( $datas );
	// var_dump($t_infos);
	
	if( isset($t_colors[$t_infos['http_code']]) ) {
		$color = $t_colors[ $t_infos['http_code'] ];
	} else {
		$color = DEFAULT_COLOR;
	}

	if( is_null($t_status_code) || in_array($t_infos['http_code'],$t_status_code) ) {
		echo str_pad( $url, $max_length, ' ', STR_PAD_RIGHT );
		$txt = "C=".$t_infos['http_code']."\t\tL=".strlen($datas)."\t\tT=".$t_infos['content_type'];
		output( $txt, $color );
		echo "\n";
	}

	if( $_grab && $t_infos['http_code']==200 && $datas !== false ) {
		$t_parse = parse_url( $url );
		$d = $_directory.'/'.$t_parse['host'];
		if( !is_dir($d) ) {
			@mkdir( $d, 0777, true );
		}
		if( is_dir($d) ) {
			$f = $d.'/'.basename( $url );
			file_put_contents( $f, $datas );
		}
	}
}


function test_url()
{
	global $f_url, $f_output;
	global $n_child, $max_child, $t_process, $t_signal_queue;

	$t_url = file( $f_url, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES );
	//shuffle( $t_url );
	$cnt = count( $t_url );
	$max_length = 0;

	foreach( $t_url as $u ) {
		$l = strlen( $u );
		if( $l > $max_length ) {
			$max_length = $l;
		}
	}
	$max_length += 10;

	echo "\nTesting ".$cnt." urls...\n\n";

	for( $index=0 ; $index<$cnt ; )
	{
		if( $n_child < $max_child )
		{
			$pid = pcntl_fork();
			
			if( $pid == -1 ) {
				// fork error
			} elseif( $pid ) {
				// father
				$n_child++;
				$index++;
				$t_process[$pid] = uniqid();
		        if( isset($t_signal_queue[$pid]) ){
		        	signal_handler( SIGCHLD, $pid, $t_signal_queue[$pid] );
		        	unset( $t_signal_queue[$pid] );
		        }
			} else {
				// child process
				$u = $t_url[$index];
				ob_start();
				test_single( $u, $max_length );
				$result = ob_get_contents();
				ob_end_clean();
				echo $result;
				file_put_contents( $f_output, $result, FILE_APPEND );
				exit( 0 );
			}
		}

		usleep( 1000 );
	}
	
	while( $n_child ) {
		// surely leave the loop please :)
		sleep( 1 );
	}


}


function create_urls( $t_host_alive, $t_file, $_https )
{	
	global $f_url;

	$cnt_h = count( $t_host_alive );
	$cnt_f = count( $t_file );
	$t_url = [];

	foreach( $t_host_alive as $h ) {
		foreach( $t_file as $w ) {
			$url = 'http';
			if( $_https ) {
				$url .= 's';
			}
			$url .= '://'.$h.'/'.ltrim($w,'/');
			$t_url[] = $url;
		}
	}

	$cnt_u = count( $t_url );
	file_put_contents( $f_url, implode("\n",$t_url) );
	echo $cnt_h.' hosts * '.$cnt_f.' words = '.$cnt_u." urls generated!\n";
}


function test_host( $t_host )
{
	global $f_alive;
	global $n_child, $max_child, $t_process, $t_signal_queue;

	$cnt = count( $t_host );

	echo 'Testing '.$cnt." hosts...\n\n";

	for( $index=0 ; $index<$cnt ; )
	{
		if( $n_child < $max_child )
		{
			$pid = pcntl_fork();
			
			if( $pid == -1 ) {
				// fork error
			} elseif( $pid ) {
				// father
				$n_child++;
				$index++;
				$t_process[$pid] = uniqid();
		        if( isset($t_signal_queue[$pid]) ){
		        	signal_handler( SIGCHLD, $pid, $t_signal_queue[$pid] );
		        	unset( $t_signal_queue[$pid] );
		        }
			} else {
				// child process
				$host = $t_host[$index];
				exec( 'host '.$host, $output );
				$output = implode( "\n", $output );
				//var_dump( $output );

				echo $host.' is ';

				if( stristr($output,'has address') !== false ) {
					output( 'ALIVE', 'light_green' );
					file_put_contents( $f_alive, $host."\n", FILE_APPEND );
				} else {
					output( 'DEAD', 'red' );
				}
				echo "\n";

				exit( 0 );
			}
		}

		usleep( 1000 );
	}
	
	while( $n_child ) {
		// surely leave the loop please :)
		sleep( 1 );
	}

	$t_alive = file( $f_alive, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES );
	$t_alive = array_unique( $t_alive );
	sort( $t_alive );
	echo "\n".count($t_alive)." hosts are alive!\n";

	return $t_alive;
}


// http://stackoverflow.com/questions/16238510/pcntl-fork-results-in-defunct-parent-process
// Thousand Thanks!
function signal_handler( $signal, $pid=null, $status=null )
{
	global $t_process, $n_child, $t_signal_queue;

	// If no pid is provided, Let's wait to figure out which child process ended
	$pid = (int)$pid;
	if( !$pid ){
		$pid = pcntl_waitpid( -1, $status, WNOHANG );
	}
	
	// Get all exited children
	while( $pid > 0 )
	{
		if( $pid && isset($t_process[$pid]) ) {
			// I don't care about exit status right now.
			//  $exitCode = pcntl_wexitstatus($status);
			//  if($exitCode != 0){
			//      echo "$pid exited with status ".$exitCode."\n";
			//  }
			// Process is finished, so remove it from the list.
			$n_child--;
			unset( $t_process[$pid] );
		}
		elseif( $pid ) {
			// Job finished before the parent process could record it as launched.
			// Store it to handle when the parent process is ready
			$t_signal_queue[$pid] = $status;
		}
		
		$pid = pcntl_waitpid( -1, $status, WNOHANG );
	}
	
	return true;
}


function usage( $err=null ) {
	echo "Usage: php quick-hits.php -h <host> -f <file list> [OPTIONS]\n\n";
	echo "Options:\n";
	echo "\t-c\tenable colors\n";
	echo "\t-d\tset destination directory\n";
	echo "\t-e\tdisplay only status code separated by comma, default=all\n";
	echo "\t-f\tset file list (required)\n";
	echo "\t-g\tgrab files\n";
	echo "\t-h\tset host list (required)\n";
	echo "\t-k\tskip host testing\n";
	echo "\t-o\tsave output\n";
	echo "\t-r\tfollow redirection\n";
	echo "\t-s\tforce https\n";
	echo "\t-t\tthreads, default 5-10\n";
	echo "\nRecommended: php quick-hits.php -h <host list> -f <file list> -c -e 200 -d $(pwd) -g -o -t 8-30 -s";
	echo "\n";
	if( $err ) {
		echo 'Error: '.$err."!\n";
	}
	exit();
}
