import sys
from netaddr import *
from termcolor import colored

def usage( err=0 ):
	print( "Usage: python %s <ip>" % sys.argv[0] );
	if err:
		print( "Error: %s" % err );
	exit();


if len(sys.argv) != 2:
    usage()

try:
    ip = IPAddress( sys.argv[1] )
except AddrFormatError:
    usage( "wrong IPv4 format" )

is_cloudflare = False

with open('cloudflare-range.txt') as fp:
    t_range = fp.read().splitlines()
    for r in t_range:
        ipn = IPNetwork( r )
        if ip in list(ipn):
            is_cloudflare = True
            break

sys.stdout.write( str(ip) )

if is_cloudflare:
    sys.stdout.write( colored(" is Cloudflare!\n","red") )
else:
    sys.stdout.write( colored(" is NOT Cloudflare!\n","green") )
