#!/bin/bash

function usage() {
    echo "Usage: "$0" <domain> <wordlist> [<dns_server>]"
    if [ -n "$1" ] ; then
	    echo "Error: "$1"!"
    fi
    exit
}

if [ $# -lt 2 ] || [ $# -gt 3 ] ; then
    usage
fi

domain=$1
file=$2
dnsserver=""
n=0

if [ $# -eq 3 ] ; then
    dnsserver=$3
fi

if ! [ -f $file ] ; then
    usage "subdomain file not found"
fi

for sub in $(cat $file) ; do
    tmp=`host $sub.$domain $dnsserver | grep 'has address' | grep $domain | cut -d ' ' -f 1,4`
    if [ -n "$tmp" ] ; then
		echo $tmp
		n=$[$n+1]
    fi
done

echo
echo $n" sub domains found."
exit
