#!/bin/bash

function usage() {
    echo "Usage: "$0" <ip range> [<port>]"
    if [ -n "$1" ] ; then
		echo "Error: "$1"!"
    fi
    exit
}

if [ $# -lt 1 ] || [ $# -gt 2 ] ; then
    usage
fi

range=$1

if [ $# -eq 2 ] ; then
    port=$2
else
    port=3389,5900
fi

tport=$(echo $port | tr "," "\n")

for i in $(seq 1 253); do
    for p in $tport ; do
		nc -n -v -z -w 1 $range"."$i $p 2>&1 |grep open
    done
done

exit
