<a href="https://github.com/gtreshchev/RuntimeSpeechRecognizer/blob/main/LICENSE">![License](https://img.shields.io/badge/license-MIT-brightgreen.svg)</a>
<a href="https://georgy.dev/discord">![Discord](https://img.shields.io/discord/1055168498919284786.svg?label=Discord&logo=discord&color=7289DA&labelColor=2C2F33)</a>
<a href="https://www.unrealengine.com/">![Unreal Engine](https://img.shields.io/badge/Unreal-4.27%2B-dea309)</a>

<br/>
<p align="center">
  <a href="https://github.com/gtreshchev/RuntimeSpeechRecognizer">
    <img src="Resources/Icon128.png" alt="Logo" width="80" height="80">
  </a>

<h3 align="center">Runtime Speech Recognizer</h3>

  <p align="center">
    High-performance <a href="https://github.com/openai/whisper">OpenAI's Whisper</a> speech recognition
    <br/>
    <br/>
    <a href="https://docs.georgy.dev/runtime-speech-recognizer/overview"><strong>Explore the docs »</strong></a>
    <br/>
    <br/>
    <a href="https://unrealengine.com/marketplace/product/runtime-speech-recognizer">Marketplace</a>
    .
    <a href="https://github.com/gtreshchev/RuntimeSpeechRecognizer/releases">Releases</a>
    <br/>
    <a href="https://georgy.dev/discord">Discord support chat</a>
  </p>

## Key features

- Fast recognition speed
- English-only and multilingual models available, with multilingual supporting 100 languages
- Different model sizes available (from 75 Mb to 2.9 Gb)
- Automatic download of language models in the Editor
- Optional translation of recognized speech to English
- Customizable properties
- Easy selection of model size and language in settings
- No static libraries or external dependencies
- Cross-platform compatibility (Windows, Mac, Linux, Android, iOS, etc)

## Additional information

The implementation is based on [whisper.cpp](https://github.com/ggerganov/whisper.cpp).

## Like my work?

Consider [supporting me](https://ko-fi.com/georgydev). Hire me at [gtreshchev@gmail.com](mailto:gtreshchev@gmail.com).