const path = require("path");
const fs = require("fs");
const shell = require("shelljs");

const getAllFiles = (dirPath, arrayOfFiles = []) => {
    const files = fs.readdirSync(dirPath);

    let returnObject = [...arrayOfFiles];

    files.forEach(file => {
        if (shell.test("-d", dirPath + "/" + file)) {
            returnObject = getAllFiles(dirPath + "/" + file, returnObject);
        } else {
            returnObject.push(path.join(dirPath, file));
        }
    });

    return returnObject;
};

const getFiles = dir => {
    return new Promise((resolve, reject) => {
        if (shell.test("-d", dir)) {
            resolve(getAllFiles(dir));
        } else {
            reject(`no such directory ${dir}`);
        }
    });
};


const parseName = file => {
    const splitPath = file.split(path.sep);
    const fileName = splitPath[splitPath.length - 1];
    const group = fileName.replace(".svg", "");

    if (!fileName.startsWith("icon-")) {
        console.error(
            "The icon name must start with icon-: ",
            file
        );
        process.exit(1);
    }

    return { name: fileName, group };
};

const loadFiles = async dir => {
    const files = await getFiles(dir);

    return files.map(file => {
        const { name, group } = parseName(file);
        const content = fs.readFileSync(file, "utf-8");

        return {
            name,
            group,
            filePath: file,
            content
        };
    });
};


async function loadIcons(dir) {
    return loadFiles(dir);
}


module.exports = {
    loadIcons
};
