const { pathsToModuleNameMapper } = require("ts-jest");
const { compilerOptions } = require("./tsconfig");

module.exports = {
    roots: ["<rootDir>"],
    testMatch: [
        "**/tests/jest/*.test.ts?(x)",
        "**/tooling/eslint-plugin/tests/*.test.ts?(x)"
    ],
    transform: {
        "^.+\\.(js|jsx|ts|tsx)$": "ts-jest"
    },
    modulePaths: [compilerOptions.baseUrl],
    moduleNameMapper: {
        "\\.css$": "identity-obj-proxy",
        ...pathsToModuleNameMapper(compilerOptions.paths)
    },
    setupFilesAfterEnv: [
        "@testing-library/jest-dom/extend-expect",
        "<rootDir>/setupTests.js"
    ],
    testEnvironment: "jsdom",
    verbose: true
};

