<p align="center">
  <img width="300" src="https://github.com/gsilvamartin/netplus/assets/42881020/172bd6b3-d8e7-4081-8166-2c7c18daff8a" />
</p>

## 

Welcome to NetPlus, an expansive toolkit meticulously crafted for .NET developers. This comprehensive suite of modules is designed to enhance various facets of your application development journey. Let's embark on a journey through each module, exploring a rich tapestry of functionalities and additional examples.

## NetPlus.Algorithms

> [!NOTE]
> Explore specialized classes for sorting algorithms (Sorting), graphs (Graph), comparison (Comparison), and search (Search).

- **Comparison**
  - [Cosine Similarity](https://example.com/cosine)
  - [Jaccard Similarity](https://example.com/jaccard)
  - [JansenShannon Similarity](https://example.com/jansenshannon)
  - [Jarc Winkler Similarity](https://example.com/jarcwinkler)
  - [Levenshtein Similarity](https://example.com/levenshtein)
  - [NGram Similarity](https://example.com/ngram)

- **Graph**
  - [Breadth-First Search](https://example.com/bfs)
  - [Depth-First Search](https://example.com/dfs)

- **Search**
  - [A*](https://example.com/a-star)
  - [Binary](https://example.com/binary)
  - [Fibonacci](https://example.com/fibonacci)
  - [Interpolated](https://example.com/interpolated)
  - [Jump Search](https://example.com/jump)
  - [Ternary Search](https://example.com/ternary)

- **Sorting**
  - [Bubble Sort](https://example.com/bubble)
  - [Heap Sort](https://example.com/heap)
  - [Merge Sort](https://example.com/merge)
  - [Selection Sort](https://example.com/selection)

## NetPlus.Converters

> [!NOTE]
> NetPlus.Converters provides versatile data transformation tools, including binary-to-text, JSON serialization, and custom object-to-object conversions.

- **Date**
  - [Date Converter](https://example.com/cosine)

- **Temperature**
  - [Temperature Converter](https://example.com/cosine)
 

## NetPlus.Converters

> [!NOTE]
> Enhance testing with NetPlus.Generators, generating synthetic data for various structures, including random graphs, mock HTTP responses, and simulated user interactions.

- **Generic Generator**
  - [Data Generator]("#")

- **GUID Generator**
  - [Guid Generator]("#")

- **Password Generator**
  - [Password GeneratorGenerator]("#")
 
## NetPlus.Validations

> [!NOTE]
> Explore data integrity in NetPlus.Validations beyond email validation. Check numeric ranges, string lengths, and implement custom validation conditions for a holistic approach to ensuring data accuracy and consistency in your application.

- **Date Validator**
  - [Date Validator]("#")

- **Numeric Validator**
  - [Numeric Validator]("#")

- **String Validator**
  - [String Validator]("#")

## NetPlus.ServiceAbstractions

> [!NOTE]
> Extend your service integration capabilities in NetPlus.ServiceAbstractions. Explore abstractions for popular services like MongoDB and Redis, along with others such as Azure Storage, Elasticsearch, and more. This module ensures seamless integration and adaptability to evolving service requirements in your application.

- **MongoDB**
  - [MongoDB]("#")

- **Redis**
  - [Redis]("#")






