# NetPlus.Converter

## Overview

The `NetPlus.Converter` NuGet package offers a versatile set of static classes providing extension methods and functions for converting various units. In this documentation, we'll explore two primary modules: `DateTimeConverter` and `TemperatureConverter`.

## Installation

You can choose to install the complete `NetPlus.Converter` library or specific modules based on your project requirements.

### Install the Entire Package

Install the complete `NetPlus.Converter` library, which includes multiple modules for different conversion functionalities.

```bash
Install-Package NetPlus.Converter
```

Or, using the .NET Core CLI:

```bash
dotnet add package NetPlus.Converter
```

### Install Individual Modules

Tailor your unit conversion toolkit by selectively installing specific modules.

#### DateTimeConverter Module

```bash
Install-Package NetPlus.Converter.DateTime
```

Or using the .NET Core CLI:

```bash
dotnet add package NetPlus.Converter.DateTime
```

#### TemperatureConverter Module

```bash
Install-Package NetPlus.Converter.Temperature
```

Or using the .NET Core CLI:

```bash
dotnet add package NetPlus.Converter.Temperature
```

## What is NetPlus.Converter?

`NetPlus.Converter` is a collection of static classes providing extension methods and functions for seamless unit conversion, offering flexibility and ease of integration into your projects.
