# NetPlus.Algorithms

## Overview

The `NetPlus.Algorithms` NuGet package provides a diverse collection of algorithms encapsulated into modular components, offering functionalities for sorting, searching, comparison, and graph-related operations.

## Installation

To harness the power of these algorithms, you have the flexibility to install the entire `NetPlus.Algorithms` library or cherry-pick individual modules based on your project's needs.

### Install the Entire Package

Install the complete `NetPlus.Algorithms` library, which includes a variety of algorithms covering sorting, searching, comparison, and graph-related operations.

Run the following command in the Visual Studio terminal:

```bash
Install-Package NetPlus.Algorithms
```

Or, if you're using the .NET Core command-line interface:

```bash
dotnet add package NetPlus.Algorithms
```

### Install Individual Modules

Tailor your algorithmic toolkit by selectively installing specific modules.

### Sorting Module

```bash
Install-Package NetPlus.Algorithms.Sorting
```

Or using the .NET Core CLI:

```bash
dotnet add package NetPlus.Algorithms.Sorting
```

### Search Module

```bash
Install-Package NetPlus.Algorithms.Search
```

Or using the .NET Core CLI:

```bash
dotnet add package NetPlus.Algorithms.Search
```

### Comparison Module

```bash
Install-Package NetPlus.Algorithms.Comparison
```

Or using the .NET Core CLI:

```bash
dotnet add package NetPlus.Algorithms.Comparison
```

### Graphs Module

```bash
Install-Package NetPlus.Algorithms.Graphs
```

Or using the .NET Core CLI:

```bash
dotnet add package NetPlus.Algorithms.Graphs
```

## What is NetPlus.Algorithms?

`NetPlus.Algorithms` is an abstraction of fundamental algorithms used in computer science and software development. It simplifies the integration of powerful algorithms into your projects, promoting code reuse and maintainability.

## Module Details

### Sorting Module

The Sorting module provides various algorithms for sorting arrays in ascending order, including popular algorithms like Bubble Sort, Quick Sort, and Merge Sort.

### Search Module

The Search module equips you with diverse algorithms for searching elements in data structures, including the A* Search algorithm for finding the shortest path in a weighted graph. Other search algorithms include Binary Search and Linear Search.

### Comparison Module

The Comparison module introduces algorithms for measuring the similarity between strings. It includes the implementation of the Cosine Similarity algorithm and other string comparison utilities.

### Graphs Module

The Graphs module offers algorithms for graph-related operations, including the Breadth-First Search algorithm for traversing graphs. Other graph algorithms, such as Depth-First Search and Dijkstra's Algorithm, are also included.

## Note

Ensure that you have the appropriate package source configured in your NuGet package manager. If you're using a private repository, make sure to add the source before attempting to install the packages.

Leverage the entire `NetPlus.Algorithms` package for a robust set of algorithms or choose specific modules that align with your project requirements. These algorithms are designed to enhance the efficiency and functionality of your applications, serving as a valuable asset in various computational scenarios.
