# Security Policy

## Reporting Vulnerabilities

If you discover a security vulnerability in the project, we appreciate your responsible disclosure. Please review our [security vulnerability reporting requirements](https://github.com/gsilvamartin/netplus/CONTRIBUTING.md) for guidance on how to proceed.

## Security Dependency Updates

We are committed to keeping project dependencies up-to-date, especially those involving security fixes. We will periodically review and update dependencies. However, if you notice any known vulnerabilities in a dependency, feel free to report it.

## Security Best Practices

To maintain the security of the repository, we request that all contributors adhere to security best practices, including but not limited to:

- Using strong and unique passwords for accounts related to the project.
- Not sharing access credentials.
- Maintaining access permissions to the repository as needed.
- Avoiding the inclusion of sensitive information, such as API keys, passwords, or access tokens, directly in the code. Use environment variables when necessary.

## Contact

If you have any security-related concerns, please contact us at [gsilvamartin@gmail.com].

We appreciate the collaboration of the entire community in maintaining the security of this project.
