<p align="center"><img width="350" alt="logo" src="https://github.com/gsilvamartin/netplus/assets/42881020/c00b7700-b2a3-4949-a720-6d9b2c44ab1a"></p>


##
![GitHub Release](https://img.shields.io/github/v/release/gsilvamartin/netplus) ![GitHub repo size](https://img.shields.io/github/repo-size/gsilvamartin/netplus?color=green) ![GitHub Actions Workflow Status](https://img.shields.io/github/actions/workflow/status/gsilvamartin/netplus/dotnet-test.yml)


Welcome to NetPlus, an expansive toolkit meticulously crafted for .NET developers. This comprehensive suite of modules is designed to enhance various facets of your application development journey. Let's embark on a journey through each module, exploring a rich tapestry of functionalities and additional examples.

## 1. NetPlus.Algorithms 🧠

Dive into the `NetPlus.Algorithms` namespace, a treasure trove of algorithmic solutions providing a robust foundation for computational tasks. Beyond essentials like Breadth-First Search (BFS) and A*, uncover additional gems like Depth-First Search (DFS), Dijkstra's algorithm, and QuickSort. These algorithms ensure versatility and adaptability in addressing complex computational challenges.

## 2. NetPlus.Converters 🔄

In `NetPlus.Converters`, elevate your data transformation capabilities with an extended repertoire of converters. Beyond fundamental date-to-string conversions, explore utilities for binary-to-text conversion, JSON serialization, and custom object-to-object conversions. These utilities provide a flexible and robust foundation for managing diverse data types, ensuring seamless interoperability.

## 3. NetPlus.Generators 🛠️

Unleash the power of synthetic data generation within `NetPlus.Generators`. Beyond creating fictitious data for common data structures, explore utilities for generating random graphs, mock HTTP responses, and simulating user interactions. These functionalities amplify your testing capabilities, allowing for a more comprehensive evaluation of your application's robustness.

## 4. NetPlus.Validations ✔️

Dive deeper into data integrity and validation within `NetPlus.Validations`. Beyond email validation, explore utilities for checking numeric ranges, string lengths, and implementing custom validation conditions. These extensions provide a holistic approach to ensuring data accuracy and consistency throughout your application.

## 5. NetPlus.ServiceAbstractions 🌐

Extend your service integration capabilities in `NetPlus.ServiceAbstractions`. Beyond Redis and MongoDB, explore abstractions for popular services such as Azure Storage, Elasticsearch, and more. This module facilitates seamless integration and ensures your application remains adaptable to evolving service requirements.

## Getting Started 🚀

To seamlessly integrate NetPlus into your project, add the corresponding NuGet package for the desired module. The comprehensive documentation accompanying each module provides detailed insights into functionalities, ensuring a smooth onboarding experience for developers.

We eagerly invite contributions, issue reports, and suggestions from the dynamic .NET community to continually refine and expand NetPlus. Thank you for choosing NetPlus to augment your development journey!
