# Contributing to NetDevExtensions 🌟

We appreciate your interest in contributing to NetDevExtensions! Your contributions help make this project better for everyone. Here's how you can get started:

## Reporting Issues 🐞

If you encounter any bugs, issues, or unexpected behavior, please [open an issue](https://github.com/gsilvamartin/net-dev-extensions/issues) on our GitHub repository. Provide detailed information about the problem, including steps to reproduce it, expected behavior, and your environment.

## Feature Requests 💡

Have an idea for a new feature or enhancement? We'd love to hear it! [Open a feature request](https://github.com/gsilvamartin/net-dev-extensions/feature-requests) on GitHub, outlining the functionality you're proposing and any relevant details. We encourage discussion to refine and shape the feature before implementation.

## Pull Requests 🛠️

Contributions via pull requests are highly encouraged. Before submitting a pull request, please ensure you follow these steps:

1. **Fork the Repository:** Start by forking the main repository to your GitHub account.

2. **Create a Branch:** Create a new branch for your contribution. This helps keep the main codebase clean.

3. **Code Changes:** Make your desired changes or additions to the code. Ensure your code adheres to the project's coding standards.

4. **Testing:** If applicable, add or update tests to validate your changes.

5. **Documentation:** Update relevant documentation if your changes impact user-facing features or APIs.

6. **Pull Request:** Submit a pull request from your branch to the main repository's corresponding branch. Clearly describe your changes and provide context for the pull request.

## Code of Conduct 🤝

Please adhere to our [Code of Conduct](https://github.com/seu-usuario/seu-repositorio/code-of-conduct) throughout your contribution process. It ensures a positive and inclusive environment for everyone involved.

## Getting Started 🚀

To get started with contributing to NetDevExtensions:

1. Fork the repository to your GitHub account.
2. Clone your forked repository to your local machine.
3. Create a branch for your changes.
4. Make your contributions and commit your changes.
5. Push your branch to your GitHub repository.
6. Open a pull request to the main repository.

Thank you for contributing to NetDevExtensions! Your involvement helps make this project even better for the entire community. If you have any questions or need assistance, feel free to reach out. Happy coding! 🎉
