import os

from griptape.drivers import GriptapeCloudStructureRunDriver
from griptape.structures import Agent
from griptape.tools import StructureRunTool

base_url = os.environ["GT_CLOUD_BASE_URL"]
api_key = os.environ["GT_CLOUD_API_KEY"]
structure_id = os.environ["GT_CLOUD_STRUCTURE_ID"]

structure_run_tool = StructureRunTool(
    description="RAG Expert Agent - Structure to invoke with natural language queries about the topic of Retrieval Augmented Generation",
    structure_run_driver=GriptapeCloudStructureRunDriver(
        base_url=base_url,
        api_key=api_key,
        structure_id=structure_id,
    ),
)

# Set up an agent using the StructureRunTool tool
agent = Agent(tools=[structure_run_tool])

# Task: Ask the Griptape Cloud Hosted Structure about modular RAG
agent.run("what is modular RAG?")
