

[The Search: How Google and Its Rivals Rewrote the Rules of Business and Transformed Our Culture](https://www.goodreads.com/book/show/10146.The_Search) a book by John Battelle, gives more of internal working of search as an organization. Presently google has more than 200 products(highly competitive)
lets take some time to get to know about products and services of google and teams behind them.

wiki gives answers to most of our general questions, so lets start from there..

* [Timeline of Mountain View, California](https://en.wikipedia.org/wiki/Timeline_of_Mountain_View,_California)
* [History of Google](https://en.wikipedia.org/wiki/History_of_Google)
* [Timeline of Google Search](https://en.wikipedia.org/wiki/Timeline_of_Google_Search)
* [List of Google products](https://en.wikipedia.org/wiki/List_of_Google_products)
* [google services](https://en.wikipedia.org/wiki/Category:Google_services)
* [List of mergers and acquisitions by Alphabet](https://en.wikipedia.org/wiki/List_of_mergers_and_acquisitions_by_Alphabet)
* [Criticism of Google](https://en.wikipedia.org/wiki/Criticism_of_Google)
* [Google Acquisition Tracker - CB Insights data](https://www.cbinsights.com/research-google-acquisitions)

---------------

![google](https://upload.wikimedia.org/wikipedia/commons/2/2a/Google_timeline.svg)

----------------



![Google-biggest](https://s3.amazonaws.com/cbi-research-portal-uploads/2017/10/12094806/Google-biggest-acquisitions-cbi.jpg) 




-------------------

<h2><span class="mw-headline" id="Conferences">Conferences</span></h2>
<table class="wikitable">
<tr>
<th style="background:#000080; color:#ffffff" colspan="6">I/O</th>
</tr>
<tr>
<th style="width: 10px; background:#808080; color:#000000">Year</th>
<th style="width: 20px; background:#808080; color:#000000">Date</th>
<th style="width: 20px; background:#808080; color:#000000">Location</th>
<th style="width: 150px; background:#4885ed; color:#ffffff">Announcements</th>
<th style="width: 20px; background:#db3236; color:#ffffff">Hardware</th>
<th style="width: 200px; background:#f4c20d; color:#000000">Information</th>
</tr>
<tr>
<td>2008</td>
<td>May 28–29</td>
<td rowspan="8"><a href="https://en.wikipedia.org/wiki/Moscone_Center" title="Moscone Center">Moscone Center</a></td>
<td><a href="https://en.wikipedia.org/wiki/Android_(operating_system)" title="Android (operating system)">Android</a>
<p><a href="https://en.wikipedia.org/wiki/Google_App_Engine" title="Google App Engine">App Engine</a></p>
<p><a href="https://en.wikipedia.org/wiki/Bionic_(software)" title="Bionic (software)">Bionic</a></p>
<p><a href="https://en.wikipedia.org/wiki/Google_Maps" title="Google Maps">Maps API</a></p>
<p><a href="https://en.wikipedia.org/wiki/OpenSocial" title="OpenSocial">OpenSocial</a></p>
<p><a href="https://en.wikipedia.org/wiki/Google_Web_Toolkit" title="Google Web Toolkit">Web Toolkit</a></p>
</td>
<td>None</td>
<td>Speakers were:
<ul>
<li><a href="https://en.wikipedia.org/wiki/Marissa_Mayer" title="Marissa Mayer">Marissa Mayer</a></li>
<li>David Glazer</li>
<li>Alex Martelli</li>
<li>Steve Souders</li>
<li>Dion Almaer</li>
<li>Mark Lucovsky</li>
<li><a href="https://en.wikipedia.org/wiki/Guido_van_Rossum" title="Guido van Rossum">Guido van Rossum</a></li>
<li><a href="https://en.wikipedia.org/wiki/Jeff_Dean_(computer_scientist)" title="Jeff Dean (computer scientist)">Jeff Dean</a></li>
<li>Chris DiBona</li>
<li>Josh Bloch</li>
<li>Raffaello D'Andrea</li>
<li>Geoff Stearns</li>
</ul>
<p><sup id="cite_ref-3" class="reference"><a href="#cite_note-3">[3]</a></sup></p>
</td>
</tr>
<tr>
<td>2009</td>
<td>May 27–28</td>
<td><a href="https://en.wikipedia.org/wiki/Google_APIs" title="Google APIs">AJAX APIs</a>
<p><a href="https://en.wikipedia.org/wiki/Android_(operating_system)" title="Android (operating system)">Android</a></p>
<p><a href="https://en.wikipedia.org/wiki/Google_App_Engine" title="Google App Engine">App Engine</a></p>
<p><a href="https://en.wikipedia.org/wiki/Google_Chrome" title="Google Chrome">Chrome</a></p>
<p><a href="https://en.wikipedia.org/wiki/OpenSocial" title="OpenSocial">OpenSocial</a></p>
<p><a href="https://en.wikipedia.org/wiki/Apache_Wave" title="Apache Wave">Wave</a></p>
<p><a href="https://en.wikipedia.org/wiki/Google_Web_Toolkit" title="Google Web Toolkit">Web Toolkit</a></p>
</td>
<td><a href="https://en.wikipedia.org/wiki/HTC_Magic" title="HTC Magic">HTC Magic</a></td>
<td>Speakers were:
<ul>
<li>Aaron Boodman</li>
<li>Adam Feldman</li>
<li>Adam Schuck</li>
<li>Alex Moffat</li>
<li>Alon Levi</li>
<li>Andrew Bowers</li>
<li>Andrew Hatton</li>
<li>Anil Sabharwal</li>
<li>Arne Roonman-Kurrik</li>
<li>Ben Collins-Sussman</li>
<li>Jacob Lee</li>
<li>Jeff Fisher</li>
<li>Jeff Ragusa</li>
<li>Jeff Sharkey</li>
<li>Jeffrey Sambells</li>
<li>Jerome Mouton</li>
<li>Jesse Kocher</li>
</ul>
<p><sup id="cite_ref-4" class="reference"><a href="#cite_note-4">[4]</a></sup></p>
</td>
</tr>
<tr>
<td>2010</td>
<td>May 19–20</td>
<td><a href="https://en.wikipedia.org/wiki/Google_APIs" title="Google APIs">APIs</a>
<p><a href="https://en.wikipedia.org/wiki/Android_(operating_system)" title="Android (operating system)">Android</a></p>
<p><a href="https://en.wikipedia.org/wiki/Google_App_Engine" title="Google App Engine">App Engine</a></p>
<p><a href="https://en.wikipedia.org/wiki/Google_Chrome" title="Google Chrome">Chrome</a></p>
<p><a href="https://en.wikipedia.org/wiki/Google_for_Work" title="Google for Work">Enterprise</a></p>
<p>Geo</p>
<p><a href="https://en.wikipedia.org/wiki/OpenSocial" title="OpenSocial">OpenSocial</a></p>
<p>Social Web</p>
<p><a href="https://en.wikipedia.org/wiki/Google_TV" title="Google TV">TV</a></p>
<p><a href="https://en.wikipedia.org/wiki/Apache_Wave" title="Apache Wave">Wave</a></p>
</td>
<td><a href="https://en.wikipedia.org/wiki/HTC_Evo_4G" title="HTC Evo 4G">HTC Evo 4G</a>
<p><a href="https://en.wikipedia.org/wiki/Motorola_Droid" title="Motorola Droid">Motorola Droid</a></p>
<p><a href="https://en.wikipedia.org/wiki/Nexus_One" title="Nexus One">Nexus One</a></p>
</td>
<td>Speakers were:
<ul>
<li>Aaron Koblin</li>
<li>Adam Graff</li>
<li>Adam Nash</li>
<li>Adam Powell</li>
<li>Adam Schuck</li>
<li>Alan Green</li>
<li>Albert Cheng</li>
<li>Albert Wenger</li>
<li>Alex Russell</li>
<li>Alfred Fuller</li>
<li>Amit Agarwal</li>
<li>Amit Kulkarni</li>
<li>Amit Manjhi</li>
<li>Amit Weinstein</li>
<li>Andres Sandholm</li>
<li>Angus Logan</li>
<li>Arne Roonmann-Kurrik</li>
<li>Bart Locanthi</li>
<li>Ben Appleton</li>
<li>Ben Chang</li>
<li>Ben Collins-Sussman</li>
</ul>
<p><sup id="cite_ref-5" class="reference"><a href="#cite_note-5">[5]</a></sup></p>
</td>
</tr>
<tr>
<td>2011</td>
<td>May 10–11</td>
<td><a href="https://en.wikipedia.org/wiki/Android_(operating_system)" title="Android (operating system)">Android</a>
<ul>
<li><a href="https://en.wikipedia.org/wiki/Google_Play_Music" title="Google Play Music">Google Play Music</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Play_Movies_%26_TV" title="Google Play Movies &amp; TV">Google Play Movies</a></li>
<li><a href="https://en.wikipedia.org/wiki/Android_Honeycomb" title="Android Honeycomb">Honeycomb</a> <small>(3.1)</small></li>
<li><a href="https://en.wikipedia.org/wiki/Android_Ice_Cream_Sandwich" title="Android Ice Cream Sandwich">Ice Cream Sandwich</a></li>
</ul>
<p><a href="https://en.wikipedia.org/wiki/Google_Chrome" title="Google Chrome">Chrome</a> and <a href="https://en.wikipedia.org/wiki/Chrome_OS" title="Chrome OS">Chrome OS</a></p>
<ul>
<li><a href="https://en.wikipedia.org/wiki/Chromebook" title="Chromebook">Chromebooks</a> from <a href="https://en.wikipedia.org/wiki/Acer_Inc." title="Acer Inc.">Acer</a> and <a href="https://en.wikipedia.org/wiki/Samsung" title="Samsung">Samsung</a></li>
<li><a href="https://en.wikipedia.org/wiki/Angry_Birds_(video_game)" title="Angry Birds (video game)">Angry Birds</a> for Chrome</li>
<li>In-app purchases for <a href="https://en.wikipedia.org/wiki/Chrome_Web_Store" title="Chrome Web Store">Chrome Web Store</a></li>
</ul>
</td>
<td><a href="https://en.wikipedia.org/wiki/Samsung_Galaxy_Tab_10.1" title="Samsung Galaxy Tab 10.1">Samsung Galaxy Tab 10.1</a>
<p><a href="https://en.wikipedia.org/wiki/Chromebook" title="Chromebook">Series 5 Chromebook</a></p>
<p><a href="https://en.wikipedia.org/wiki/Verizon_Communications" title="Verizon Communications">Verizon</a> <a href="https://en.wikipedia.org/wiki/MiFi" title="MiFi">MiFi</a></p>
</td>
<td>The afterparty hosted <a href="https://en.wikipedia.org/wiki/Jane%27s_Addiction" title="Jane's Addiction">Jane's Addiction</a>.
<p><sup id="cite_ref-6" class="reference"><a href="#cite_note-6">[6]</a></sup><sup id="cite_ref-7" class="reference"><a href="#cite_note-7">[7]</a></sup><sup id="cite_ref-8" class="reference"><a href="#cite_note-8">[8]</a></sup><sup id="cite_ref-9" class="reference"><a href="#cite_note-9">[9]</a></sup></p>
</td>
</tr>
<tr>
<td>2012</td>
<td>June 27–29</td>
<td><a href="https://en.wikipedia.org/wiki/Android_(operating_system)" title="Android (operating system)">Android</a>
<ul>
<li><a href="https://en.wikipedia.org/wiki/Three-dimensional_space_(mathematics)" class="mw-redirect" title="Three-dimensional space (mathematics)">3D</a> imagery for <a href="https://en.wikipedia.org/wiki/Google_Earth" title="Google Earth">Earth</a></li>
<li>400 million users announcement</li>
<li><a href="https://en.wikipedia.org/wiki/Google_Analytics" title="Google Analytics">Analytics</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Now" title="Google Now">Google Now</a></li>
<li><a href="https://en.wikipedia.org/wiki/Android_Jelly_Bean" title="Android Jelly Bean">Jelly Bean</a></li>
<li>In-app purchases for <a href="https://en.wikipedia.org/wiki/Google_Wallet" title="Google Wallet">Wallet</a></li>
<li>Project Butter</li>
</ul>
<p><a href="https://en.wikipedia.org/wiki/Google_Chrome" title="Google Chrome">Chrome</a></p>
<ul>
<li>310 million users announcement</li>
<li>Chrome for Android is stable</li>
<li><a href="https://en.wikipedia.org/wiki/IOS" title="IOS">iOS</a> app</li>
</ul>
<p><a href="https://en.wikipedia.org/wiki/Google_Compute_Engine" title="Google Compute Engine">Compute Engine</a></p>
<p><a href="https://en.wikipedia.org/wiki/Google_Docs,_Sheets,_Slides_and_Forms" class="mw-redirect" title="Google Docs, Sheets, Slides and Forms">Docs</a></p>
<ul>
<li>Offline editing</li>
</ul>
<p><a href="https://en.wikipedia.org/wiki/Google_Drive" title="Google Drive">Drive</a></p>
<ul>
<li>App for <a href="https://en.wikipedia.org/wiki/IOS" title="IOS">iOS</a></li>
<li>SDK (v.2)</li>
</ul>
<p><a href="https://en.wikipedia.org/wiki/Google_Glass" title="Google Glass">Glass</a></p>
<p><a href="https://en.wikipedia.org/wiki/Gmail" title="Gmail">Gmail</a></p>
<ul>
<li>425 million users announcement</li>
</ul>
<p><a href="https://en.wikipedia.org/wiki/Google%2B" title="Google+">Google+</a></p>
<ul>
<li><a href="https://en.wikipedia.org/wiki/Google_Hangouts" title="Google Hangouts">Hangouts</a> app and metrics</li>
<li>Platform for Mobile with SDKs and APIs</li>
</ul>
<p><a href="https://en.wikipedia.org/wiki/Google_Maps" title="Google Maps">Maps</a></p>
<ul>
<li>Offline for Android</li>
<li>Enhanced maps in API</li>
<li>Transit data in API</li>
</ul>
<p><a href="https://en.wikipedia.org/wiki/Google_Nexus" title="Google Nexus">Nexus</a></p>
<ul>
<li><a href="https://en.wikipedia.org/wiki/Nexus_7_(2012)" title="Nexus 7 (2012)">7</a></li>
<li><a href="https://en.wikipedia.org/wiki/Nexus_Q" title="Nexus Q">Q</a></li>
</ul>
<p><a href="https://en.wikipedia.org/wiki/YouTube" title="YouTube">YouTube</a></p>
<ul>
<li>Updated 720p HD API</li>
<li>Heat maps and symbols in API</li>
<li>Updated Android app</li>
</ul>
</td>
<td><a href="https://en.wikipedia.org/wiki/Galaxy_Nexus" title="Galaxy Nexus">Galaxy Nexus</a>
<p><a href="https://en.wikipedia.org/wiki/Nexus_7_(2012)" title="Nexus 7 (2012)">Nexus 7</a></p>
<p><a href="https://en.wikipedia.org/wiki/Nexus_Q" title="Nexus Q">Nexus Q</a></p>
<p><a href="https://en.wikipedia.org/wiki/Chromebox" title="Chromebox">Chromebox</a></p>
</td>
<td>Extended the I/O conference from the usual two-day schedule to three days. There was no keynote on the final day.
<p>The afterparty hosted <a href="https://en.wikipedia.org/wiki/Paul_Oakenfold" title="Paul Oakenfold">Paul Oakenfold</a> and <a href="https://en.wikipedia.org/wiki/Train_(band)" title="Train (band)">Train</a>. <sup id="cite_ref-10" class="reference"><a href="#cite_note-10">[10]</a></sup><sup id="cite_ref-google1_11-0" class="reference"><a href="#cite_note-google1-11">[11]</a></sup><sup id="cite_ref-12" class="reference"><a href="#cite_note-12">[12]</a></sup></p>
</td>
</tr>
<tr>
<td>2013</td>
<td>May 15–17</td>
<td><a href="https://en.wikipedia.org/wiki/Android_(operating_system)" title="Android (operating system)">Android</a>
<ul>
<li>900 million users announcement</li>
<li>Updated <a href="https://en.wikipedia.org/wiki/Google_Search" title="Google Search">Search</a></li>
<li><a href="https://en.wikipedia.org/wiki/Android_Studio" title="Android Studio">Studio</a></li>
</ul>
<p><a href="https://en.wikipedia.org/wiki/Google_App_Engine" title="Google App Engine">App Engine</a></p>
<ul>
<li><a href="https://en.wikipedia.org/wiki/PHP" title="PHP">PHP</a> support</li>
</ul>
<p><a href="https://en.wikipedia.org/wiki/Google%2B" title="Google+">Google+</a></p>
<ul>
<li>Redesign with photo and sharing emphasis</li>
</ul>
<p><a href="https://en.wikipedia.org/wiki/Google_Hangouts" title="Google Hangouts">Hangouts</a></p>
<ul>
<li>Updated <a href="https://en.wikipedia.org/wiki/Instant_messaging" title="Instant messaging">IM</a> platform</li>
</ul>
<p><a href="https://en.wikipedia.org/wiki/Google_Maps" title="Google Maps">Maps</a></p>
<ul>
<li>Redesign on web and Android</li>
</ul>
<p><a href="https://en.wikipedia.org/wiki/Google_Play" title="Google Play">Play</a></p>
<ul>
<li><a href="https://en.wikipedia.org/wiki/Google_Play_Games" title="Google Play Games">Games</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Play_Music" title="Google Play Music">Music</a> All Access</li>
<li>Play for Education</li>
<li><a href="https://en.wikipedia.org/wiki/Samsung_Galaxy_S4" title="Samsung Galaxy S4">Samsung Galaxy S4</a> to be sold</li>
<li>Updated <a href="https://en.wikipedia.org/wiki/Google_Play_Services" title="Google Play Services">Google Play Services</a></li>
</ul>
<p><a href="https://en.wikipedia.org/wiki/Google_TV" title="Google TV">TV</a></p>
<ul>
<li>Update to <a href="https://en.wikipedia.org/wiki/Android_Jelly_Bean" title="Android Jelly Bean">Jelly Bean</a></li>
</ul>
</td>
<td><a href="https://en.wikipedia.org/wiki/Chromebook_Pixel" title="Chromebook Pixel">Chromebook Pixel</a></td>
<td>The amount of time for all the $900 (or $300 for school students and faculty) tickets to sell out was 49 minutes, even when registrants had both Google+ and Wallet accounts by requirement.
<p>There were a fleet of <a href="https://en.wikipedia.org/wiki/Unmanned_aerial_vehicle" title="Unmanned aerial vehicle">remote-controlled blimps</a>streaming a <a rel="nofollow" class="external text" href="https://www.youtube.com/watch?v=zhmk22GHaE8">bird's-eye</a> view of I/O.</p>
<p>The afterparty hosted <a href="https://en.wikipedia.org/wiki/Billy_Idol" title="Billy Idol">Billy Idol</a>. <sup id="cite_ref-13" class="reference"><a href="#cite_note-13">[13]</a></sup><sup id="cite_ref-google1_11-1" class="reference"><a href="#cite_note-google1-11">[11]</a></sup><sup id="cite_ref-14" class="reference"><a href="#cite_note-14">[14]</a></sup></p>
</td>
</tr>
<tr>
<td>2014</td>
<td>June 25–26</td>
<td><a href="https://en.wikipedia.org/wiki/Android_(operating_system)" title="Android (operating system)">Android</a>
<ul>
<li><a href="https://en.wikipedia.org/wiki/Android_Auto" title="Android Auto">Auto</a></li>
<li><a href="https://en.wikipedia.org/wiki/Android_Lollipop" title="Android Lollipop">Lollipop</a></li>
<li><a href="https://en.wikipedia.org/wiki/Material_Design" title="Material Design">Material Design</a></li>
<li><a href="https://en.wikipedia.org/wiki/Android_One" title="Android One">One</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Docs,_Sheets,_Slides_and_Forms" class="mw-redirect" title="Google Docs, Sheets, Slides and Forms">Slides</a></li>
<li><a href="https://en.wikipedia.org/wiki/Android_TV" title="Android TV">TV</a></li>
<li><a href="https://en.wikipedia.org/wiki/Android_Wear" title="Android Wear">Wear</a></li>
</ul>
<p><a href="https://en.wikipedia.org/wiki/Chromebook" title="Chromebook">Chromebook</a></p>
<ul>
<li>Improvements</li>
</ul>
<p><a href="https://en.wikipedia.org/wiki/Google_Fit" title="Google Fit">Google Fit</a></p>
<p><a href="https://en.wikipedia.org/wiki/Gmail" title="Gmail">Gmail</a></p>
<ul>
<li>API</li>
</ul>
</td>
<td><a href="https://en.wikipedia.org/wiki/LG_G_Watch" title="LG G Watch">LG G Watch</a>
<p><a href="https://en.wikipedia.org/wiki/Samsung_Gear_Live" title="Samsung Gear Live">Samsung Gear Live</a></p>
<p><a href="https://en.wikipedia.org/wiki/Moto_360_(1st_generation)" title="Moto 360 (1st generation)">Moto 360</a></p>
<p><a href="https://en.wikipedia.org/wiki/Google_Cardboard" title="Google Cardboard">Google Cardboard</a></p>
</td>
<td>The Moto 360 was made available to attendees by shipping it afterwards.<sup id="cite_ref-15" class="reference"><a href="#cite_note-15">[15]</a></sup></td>
</tr>
<tr>
<td>2015</td>
<td>May 28–29</td>
<td><a href="https://en.wikipedia.org/wiki/Android_(operating_system)" title="Android (operating system)">Android</a>
<ul>
<li><a href="https://en.wikipedia.org/wiki/Android_Marshmallow" title="Android Marshmallow">Marshmallow</a></li>
<li><a href="https://en.wikipedia.org/wiki/Android_Pay" title="Android Pay">Pay</a></li>
<li><a href="https://en.wikipedia.org/wiki/Android_Wear" title="Android Wear">Wear</a></li>
</ul>
<p><a href="https://en.wikipedia.org/wiki/Google_Chrome" title="Google Chrome">Chrome</a></p>
<ul>
<li>Custom tabs</li>
</ul>
<p><a href="https://en.wikipedia.org/wiki/Gmail" title="Gmail">Gmail</a></p>
<ul>
<li>Inbox availability for everyone</li>
</ul>
<p><a href="https://en.wikipedia.org/wiki/Google_Maps" title="Google Maps">Maps</a></p>
<ul>
<li>Offline mode</li>
</ul>
<p>Nanodegree</p>
<p><a href="https://en.wikipedia.org/wiki/Google_Now" title="Google Now">Now</a></p>
<ul>
<li>Reduction in voice error</li>
<li>Context improvements</li>
</ul>
<p><a href="https://en.wikipedia.org/wiki/Google_Photos" title="Google Photos">Photos</a></p>
<p><a href="https://en.wikipedia.org/wiki/Google_Play" title="Google Play">Play</a></p>
<ul>
<li>"About" tabs for developer pages</li>
<li>A/B listings</li>
<li>Store listing experiments</li>
<li>"Family Star" badge</li>
</ul>
<p><a href="https://en.wikipedia.org/wiki/Android_Things" title="Android Things">Project Brillo</a></p>
<ul>
<li><a href="/w/index.php?title=Project_Weave&amp;action=edit&amp;redlink=1" class="new" title="Project Weave (page does not exist)">Project Weave</a></li>
</ul>
</td>
<td><a href="https://en.wikipedia.org/wiki/Nexus_9" title="Nexus 9">Nexus 9</a>
<p>Improved <a href="https://en.wikipedia.org/wiki/Google_Cardboard" title="Google Cardboard">Google Cardboard</a></p>
</td>
<td>Marshmallow includes new feature such as:
<ul>
<li>App permission controls</li>
<li>Native <a href="https://en.wikipedia.org/wiki/Fingerprint_recognition" class="mw-redirect" title="Fingerprint recognition">fingerprint recognition</a>.</li>
<li>"Deep sleep", a mode which puts the device to sleep for power saving.</li>
<li><a href="https://en.wikipedia.org/wiki/USB-C" title="USB-C">USB-C</a> support</li>
<li>Deep-linking app support, which leads verified app <a href="https://en.wikipedia.org/wiki/Uniform_Resource_Locator" class="mw-redirect" title="Uniform Resource Locator">URL</a>s to the app in the Play store.</li>
</ul>
<p>Android Wear adds:</p>
<ul>
<li>"Always on" extension to apps</li>
<li>Wrist gestures</li>
</ul>
<p>Nanodegree is an Android course on <a href="https://en.wikipedia.org/wiki/Udacity" title="Udacity">Udacity</a></p>
<p>Project Brillo is a new operating system for the Android-based <a href="https://en.wikipedia.org/wiki/Internet_of_things" title="Internet of things">Internet of things</a>. Project Weave is a common language for IoT devices to communicate <sup id="cite_ref-16" class="reference"><a href="#cite_note-16">[16]</a></sup><sup id="cite_ref-17" class="reference"><a href="#cite_note-17">[17]</a></sup></p>
</td>
</tr>
<tr>
<td>2016</td>
<td>May 17–19</td>
<td rowspan="2"><a href="https://en.wikipedia.org/wiki/Shoreline_Amphitheatre" title="Shoreline Amphitheatre">Shoreline Amphitheatre</a></td>
<td><a href="https://en.wikipedia.org/wiki/Allo_(app)" class="mw-redirect" title="Allo (app)">Allo</a>
<p><a href="https://en.wikipedia.org/wiki/Android_(operating_system)" title="Android (operating system)">Android</a></p>
<ul>
<li><a href="https://en.wikipedia.org/wiki/Daydream_(Google)" class="mw-redirect" title="Daydream (Google)">Daydream</a></li>
<li>Instant Apps</li>
<li><a href="https://en.wikipedia.org/wiki/Android_Nougat" title="Android Nougat">Nougat</a></li>
<li><a href="https://en.wikipedia.org/wiki/Android_Wear" title="Android Wear">Wear 2.0</a></li>
</ul>
<p><a href="https://en.wikipedia.org/wiki/Google_Assistant" title="Google Assistant">Assistant</a></p>
<p><a href="https://en.wikipedia.org/wiki/Duo_(app)" class="mw-redirect" title="Duo (app)">Duo</a></p>
<p><a href="https://en.wikipedia.org/wiki/Firebase" title="Firebase">Firebase</a></p>
<p><a href="https://en.wikipedia.org/wiki/Google_Home" title="Google Home">Home</a></p>
<p><a href="https://en.wikipedia.org/wiki/Google_Play" title="Google Play">Play</a> integration with <a href="https://en.wikipedia.org/wiki/Chrome_OS" title="Chrome OS">Chrome OS</a></p>
</td>
<td>None</td>
<td><a href="https://en.wikipedia.org/wiki/Sundar_Pichai" title="Sundar Pichai">Sundar Pichai</a> moved Google I/O to Shoreline Amphitheatre in Mountain View, CA for the first time. Attendees were given sunglasses and sunscreen due to the amphitheater's outside conditions, however many attendees were sunburned so the talks were relatively short.<sup id="cite_ref-18" class="reference"><a href="#cite_note-18">[18]</a></sup>
<p>Android Instant Apps is a code path that downloads a part of an app instead of accessing a web app, which allows links to load apps on-demand without installation. This was shown with the <a href="https://en.wikipedia.org/wiki/B%26H_Photo_Video" title="B&amp;H Photo Video">B&amp;H</a> app.<sup id="cite_ref-19" class="reference"><a href="#cite_note-19">[19]</a></sup> Android support for <a href="https://en.wikipedia.org/wiki/Virtual_Reality" class="mw-redirect" title="Virtual Reality">VR</a> was shown with Daydream.<sup id="cite_ref-20" class="reference"><a href="#cite_note-20">[20]</a></sup></p>
<p>Firebase, a mobile application platform, now adds storage, reporting and analytics.<sup id="cite_ref-21" class="reference"><a href="#cite_note-21">[21]</a></sup> <sup id="cite_ref-22" class="reference"><a href="#cite_note-22">[22]</a></sup><sup id="cite_ref-23" class="reference"><a href="#cite_note-23">[23]</a></sup></p>
<p>The inaugural <a href="https://en.wikipedia.org/wiki/Google_Play" title="Google Play">Google Play</a> Awards were presented to the year's best apps and games in ten categories.<sup id="cite_ref-24" class="reference"><a href="#cite_note-24">[24]</a></sup></p>
</td>
</tr>
<tr>
<td>2017</td>
<td>May 17–19</td>
<td><a href="https://en.wikipedia.org/wiki/Android_Oreo" title="Android Oreo">Android Oreo</a>
<ul>
<li><a href="/w/index.php?title=Project_Treble&amp;action=edit&amp;redlink=1" class="new" title="Project Treble (page does not exist)">Project Treble</a></li>
</ul>
<p><a href="https://en.wikipedia.org/wiki/Flutter_(software)" title="Flutter (software)">Flutter</a></p>
<p><a href="https://en.wikipedia.org/wiki/Google.ai" title="Google.ai">Google.ai</a></p>
<ul>
<li><a href="https://en.wikipedia.org/wiki/Google_Lens" title="Google Lens">Google Lens</a><sup id="cite_ref-Google_lens_announcement_25-0" class="reference"><a href="#cite_note-Google_lens_announcement-25">[25]</a></sup></li>
</ul>
</td>
<td><a href="https://en.wikipedia.org/wiki/Google_Home" title="Google Home">Google Home</a></td>
<td>Project Treble is an Android Oreo feature that modularizes the OS so carriers can update their smartphones easier.<sup id="cite_ref-26" class="reference"><a href="#cite_note-26">[26]</a></sup>
<p><a href="https://en.wikipedia.org/wiki/Google_Assistant" title="Google Assistant">Google Assistant</a> became available on iOS devices.<sup id="cite_ref-27" class="reference"><a href="#cite_note-27">[27]</a></sup></p>
<p>A new standalone (in-built) <a href="https://en.wikipedia.org/wiki/Virtual_reality" title="Virtual reality">virtual reality</a> system to be made by the <a href="https://en.wikipedia.org/wiki/HTC_Vive" title="HTC Vive">HTC Vive</a> team and <a href="https://en.wikipedia.org/wiki/Lenovo" title="Lenovo">Lenovo</a>.<sup id="cite_ref-28" class="reference"><a href="#cite_note-28">[28]</a></sup></p>
<p>Flutter is a cross-platform mobile development framework that enables fast development of apps across iOS and Android.<sup id="cite_ref-29" class="reference"><a href="#cite_note-29">[29]</a></sup></p>
</td>
</tr>
</table>

-------------

<h2><span class="mw-headline" id="External_links">links</span></h2>
<ul>
<li><span class="official-website"><span class="url"><a rel="nofollow" class="external text" href="https://events.google.com/io">Official website</a></span></span></li>
<li><a rel="nofollow" class="external text" href="https://play.google.com/store/apps/details?id=com.google.samples.apps.iosched&amp;hl=en">Official app</a></li>
<li><a rel="nofollow" class="external text" href="http://sites.google.com/site/io/">Google I/O 2008 Session Videos and Slides</a></li>
<li><a rel="nofollow" class="external text" href="https://www.google.com/events/io/2009/sessions.html">Google I/O 2009 Session Videos and Slides</a></li>
<li><a rel="nofollow" class="external text" href="https://www.google.com/events/io/2010/sessions.html">Google I/O 2010 Session Videos and Slides</a></li>
<li><a rel="nofollow" class="external text" href="https://www.google.com/events/io/2011/sessions.html">Google I/O 2011 Session Videos and Slides</a></li>
<li><a rel="nofollow" class="external text" href="http://developers.google.com/events/io/2012/">Google I/O 2012 Session Videos and Slides</a></li>
<li><a rel="nofollow" class="external text" href="http://developers.google.com/events/io/2013/">Google I/O 2013 Session Videos and Slides</a></li>
<li><a rel="nofollow" class="external text" href="https://www.google.com/events/io">Google I/O 2014 Session Videos and Slides</a></li>
<li><a rel="nofollow" class="external text" href="https://events.google.com/io2015/videos">Google I/O 2015 Session Videos</a></li>
<li><a rel="nofollow" class="external text" href="https://www.youtube.com/playlist?list=PLOU2XLYxmsILe6_eGvDN3GyiodoV3qNSC">Google I/O 2016 Session Videos</a></li>
<li><a rel="nofollow" class="external text" href="https://twitter.com/googleio">Google I/O on Twitter</a> (official hashtags: #io2008, #io2009, #io2010, #io11, #io12, #io13, #io14, #io15, #io16, #io17)</li>
<li><a rel="nofollow" class="external text" href="https://www.youtube.com/watch?v=G-36noTCaiA"><span class="plainlinks">Anatomy and Physiology of an Android</span></a> on <a href="/wiki/YouTube" title="YouTube">YouTube</a></li>
</ul>

-------------------------



<div role="navigation" class="navbox" aria-labelledby="Alphabet_Inc." style="padding:3px">
<table class="nowraplinks hlist collapsible autocollapse navbox-inner" style="border-spacing:0;background:transparent;color:inherit">
<tr>
<th scope="col" class="navbox-title" colspan="2">
<div class="plainlinks hlist navbar mini">
<ul>
</div>
<div id="Alphabet_Inc." style="font-size:114%;margin:0 4em"><a class="mw-selflink selflink">Alphabet Inc.</a></div>
</th>
</tr>
<tr>
<th scope="row" class="navbox-group" style="width:1%">Divisions</th>
<td class="navbox-list navbox-odd" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px">
<div style="padding:0em 0.25em">
<ul>
<li><a href="https://en.wikipedia.org/wiki/Google_Fiber" title="Google Fiber">Access</a></li>
<li><a href="https://en.wikipedia.org/wiki/Calico_(company)" title="Calico (company)">Calico</a></li>
<li><a href="https://en.wikipedia.org/wiki/CapitalG" title="CapitalG">CapitalG</a></li>
<li><a href="https://en.wikipedia.org/wiki/DeepMind" title="DeepMind">DeepMind</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google" title="Google">Google</a></li>
<li><a href="https://en.wikipedia.org/wiki/GV_(company)" title="GV (company)">GV</a></li>
<li><a href="https://en.wikipedia.org/wiki/Jigsaw_(company)" title="Jigsaw (company)">Jigsaw</a></li>
<li><a href="https://en.wikipedia.org/wiki/Nest_Labs" title="Nest Labs">Nest</a></li>
<li><a href="https://en.wikipedia.org/wiki/Sidewalk_Labs" title="Sidewalk Labs">Sidewalk</a></li>
<li><a href="https://en.wikipedia.org/wiki/Verily_Life_Sciences" title="Verily Life Sciences">Verily</a></li>
<li><a href="https://en.wikipedia.org/wiki/X_(company)" title="X (company)">X</a></li>
<li><a href="https://en.wikipedia.org/wiki/Waymo" title="Waymo">Waymo</a></li>
</ul>
</div>
</td>
</tr>
<tr>
<th scope="row" class="navbox-group" style="width:1%">People</th>
<td class="navbox-list navbox-even" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px">
<div style="padding:0em 0.25em">
<ul>
<li><a href="https://en.wikipedia.org/wiki/Arthur_D._Levinson" title="Arthur D. Levinson">Arthur D. Levinson</a></li>
<li><a href="https://en.wikipedia.org/wiki/Astro_Teller" title="Astro Teller">Astro Teller</a></li>
<li><a href="https://en.wikipedia.org/wiki/David_Krane" title="David Krane">David Krane</a></li>
<li><a href="https://en.wikipedia.org/wiki/Eric_Schmidt" title="Eric Schmidt">Eric Schmidt</a></li>
<li><a href="https://en.wikipedia.org/wiki/Ruth_Porat" title="Ruth Porat">Ruth Porat</a></li>
<li><a href="https://en.wikipedia.org/wiki/Sundar_Pichai" title="Sundar Pichai">Sundar Pichai</a></li>
<li><a href="https://en.wikipedia.org/wiki/Tony_Fadell" title="Tony Fadell">Tony Fadell</a></li>
<li><a href="https://en.wikipedia.org/wiki/Andrew_Conrad_(geneticist)" title="Andrew Conrad (geneticist)">Andrew Conrad</a></li>
</ul>
</div>
<table class="nowraplinks navbox-subgroup" style="border-spacing:0">
<tr>
<th scope="row" class="navbox-group" style="width:1%">Founders</th>
<td class="navbox-list navbox-odd" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px">
<div style="padding:0em 0.25em">
<ul>
<li><a href="https://en.wikipedia.org/wiki/Larry_Page" title="Larry Page">Larry Page</a></li>
<li><a href="https://en.wikipedia.org/wiki/Sergey_Brin" title="Sergey Brin">Sergey Brin</a></li>
</ul>
</div>
</td>
</tr>
</table>
</td>
</tr>
<tr>
<td class="navbox-abovebelow" colspan="2">
<div>

</div>
</td>
</tr>
</table>
</div>
<div role="navigation" class="navbox" aria-labelledby="Google" style="padding:3px">
<table class="nowraplinks hlist collapsible collapsed navbox-inner" style="border-spacing:0;background:transparent;color:inherit">
<tr>
<th scope="col" class="navbox-title" colspan="2">
<div class="plainlinks hlist navbar mini">
</div>
<div id="Google" style="font-size:114%;margin:0 4em"><a href="https://en.wikipedia.org/wiki/Google" title="Google">Google</a></div>
</th>
</tr>
<tr>
<th scope="row" class="navbox-group" style="width:1%"><a href="https://en.wikipedia.org/wiki/Outline_of_Google" title="Outline of Google">Overview</a></th>
<td class="navbox-list navbox-odd" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px">
<div style="padding:0em 0.25em">
<ul>
<li><a class="mw-selflink selflink">Alphabet Inc.</a></li>
<li><a href="https://en.wikipedia.org/wiki/History_of_Google" title="History of Google">History</a></li>
<li><a href="https://en.wikipedia.org/wiki/List_of_mergers_and_acquisitions_by_Alphabet" title="List of mergers and acquisitions by Alphabet">List of mergers and acquisitions by Alphabet</a></li>
<li><a href="https://en.wikipedia.org/wiki/List_of_Google_products" title="List of Google products">Products</a></li>
<li><a href="https://en.wikipedia.org/wiki/Criticism_of_Google" title="Criticism of Google">Criticism</a>
<ul>
<li><a href="https://en.wikipedia.org/wiki/Privacy_concerns_regarding_Google" title="Privacy concerns regarding Google">Privacy concerns</a></li>
</ul>
</li>
<li><a href="https://en.wikipedia.org/wiki/Censorship_by_Google" title="Censorship by Google">Censorship</a></li>
<li><a href="https://en.wikipedia.org/wiki/List_of_Google_Easter_eggs" title="List of Google Easter eggs">Easter eggs</a></li>
<li><i><a href="https://en.wikipedia.org/wiki/Don%27t_be_evil" title="Don't be evil">Don't be evil</a></i></li>
</ul>
</div>
</td>
</tr>
<tr>
<th scope="row" class="navbox-group" style="width:1%">Advertising</th>
<td class="navbox-list navbox-even" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px">
<div style="padding:0em 0.25em">
<ul>
<li><a href="https://en.wikipedia.org/wiki/AdMob" title="AdMob">AdMob</a></li>
<li><a href="https://en.wikipedia.org/wiki/Adscape" title="Adscape">Adscape</a></li>
<li><a href="https://en.wikipedia.org/wiki/AdSense" title="AdSense">AdSense</a></li>
<li><a href="https://en.wikipedia.org/wiki/AdWords" title="AdWords">AdWords</a></li>
<li><a href="https://en.wikipedia.orghttps://en.wikipedia.org/wiki/Google_Analytics" title="Google Analytics">Analytics</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Contributor" title="Google Contributor">Contributor</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Partners" class="mw-redirect" title="Google Partners">Partners</a></li>
<li><a href="https://en.wikipedia.org/wiki/DoubleClick" title="DoubleClick">DoubleClick</a></li>
<li><a href="https://en.wikipedia.org/wiki/DoubleClick_for_Publishers" title="DoubleClick for Publishers">DoubleClick for Publishers</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Wallet" title="Google Wallet">Wallet</a></li>
</ul>
</div>
</td>
</tr>
<tr>
<th scope="row" class="navbox-group" style="width:1%">Communication</th>
<td class="navbox-list navbox-odd" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px">
<div style="padding:0em 0.25em">
<ul>
<li><a href="https://en.wikipedia.org/wiki/Google_Allo" title="Google Allo">Allo</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Alerts" title="Google Alerts">Alerts</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Apps_Script" title="Google Apps Script">Apps Script</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Duo" title="Google Duo">Duo</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Calendar" title="Google Calendar">Calendar</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Contacts" title="Google Contacts">Contacts</a></li>
<li><a href="https://en.wikipedia.org/wiki/Gmail" title="Gmail">Gmail</a>
<ul>
<li><a href="https://en.wikipedia.org/wiki/History_of_Gmail" title="History of Gmail">history</a></li>
<li><a href="https://en.wikipedia.org/wiki/Gmail_interface" title="Gmail interface">interface</a></li>
</ul>
</li>
<li><a href="https://en.wikipedia.org/wiki/Google%2B" title="Google+">Google+</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Groups" title="Google Groups">Groups</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Hangouts" title="Google Hangouts">Hangouts</a></li>
<li><a href="https://en.wikipedia.org/wiki/Inbox_by_Gmail" title="Inbox by Gmail">Inbox</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Sync" title="Google Sync">Sync</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Text-to-Speech" title="Google Text-to-Speech">Text-to-Speech</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Translate" title="Google Translate">Translate</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_transliteration" title="Google transliteration">Transliteration</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Voice" title="Google Voice">Voice</a></li>
</ul>
</div>
</td>
</tr>
<tr>
<th scope="row" class="navbox-group" style="width:1%">Software</th>
<td class="navbox-list navbox-even" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px">
<div style="padding:0em 0.25em">
<ul>
<li><a href="https://en.wikipedia.org/wiki/Google_Assistant" title="Google Assistant">Assistant</a>
<ul>
<li><a href="https://en.wikipedia.org/wiki/Google_Lens" title="Google Lens">Lens</a></li>
</ul>
</li>
<li><a href="https://en.wikipedia.org/wiki/Google_Chrome" title="Google Chrome">Chrome</a>
<ul>
<li><a href="https://en.wikipedia.org/wiki/Google_Chrome_for_Android" title="Google Chrome for Android">for Android</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Chrome_for_iOS" class="mw-redirect" title="Google Chrome for iOS">for iOS</a></li>
<li><a href="https://en.wikipedia.org/wiki/Chrome_Web_Store" title="Chrome Web Store">Chrome Web Store</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Chrome_App" title="Google Chrome App">Apps</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Chrome_extension" title="Google Chrome extension">Extensions</a></li>
</ul>
</li>
<li><a href="https://en.wikipedia.org/wiki/Google_Cloud_Print" title="Google Cloud Print">Cloud Print</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Earth" title="Google Earth">Earth</a>
<ul>
<li><a href="https://en.wikipedia.org/wiki/Google_Sky" class="mw-redirect" title="Google Sky">Sky</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Moon" class="mw-redirect" title="Google Moon">Moon</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Mars" class="mw-redirect" title="Google Mars">Mars</a></li>
</ul>
</li>
<li><a href="https://en.wikipedia.org/wiki/Google_Gadgets" title="Google Gadgets">Gadgets</a></li>
<li><a href="https://en.wikipedia.org/wiki/Gboard" title="Gboard">Gboard</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Goggles" title="Google Goggles">Goggles</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_IME" title="Google IME">IME</a>
<ul>
<li><a href="https://en.wikipedia.org/wiki/Google_Japanese_Input" title="Google Japanese Input">Japanese</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Pinyin" title="Google Pinyin">Pinyin</a></li>
</ul>
</li>
<li><a href="https://en.wikipedia.org/wiki/Google_Photos" title="Google Photos">Photos</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Keep" title="Google Keep">Keep</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_News_%26_Weather" title="Google News &amp; Weather">News &amp; Weather</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Now" title="Google Now">Now</a></li>
<li><a href="https://en.wikipedia.org/wiki/OpenRefine" title="OpenRefine">OpenRefine</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Search" title="Google Search">Search</a></li>
</ul>
</div>
</td>
</tr>
<tr>
<th scope="row" class="navbox-group" style="width:1%"><a href="https://en.wikipedia.org/wiki/Operating_system" title="Operating system">Operating<br />
systems</a></th>
<td class="navbox-list navbox-odd" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px">
<div style="padding:0em 0.25em">
<ul>
<li><a href="https://en.wikipedia.org/wiki/Android_(operating_system)" title="Android (operating system)">Android</a>
<ul>
<li><a href="https://en.wikipedia.org/wiki/Android_version_history" title="Android version history">version history</a></li>
<li><a href="https://en.wikipedia.org/wiki/Android_software_development" title="Android software development">software development</a></li>
<li><a href="https://en.wikipedia.org/wiki/Android_Auto" title="Android Auto">Android Auto</a></li>
<li><a href="https://en.wikipedia.org/wiki/Android_Pay" title="Android Pay">Android Pay</a></li>
<li><a href="https://en.wikipedia.org/wiki/Android_TV" title="Android TV">Android TV</a></li>
<li><a href="https://en.wikipedia.org/wiki/Android_Wear" title="Android Wear">Android Wear</a></li>
</ul>
</li>
<li><a href="https://en.wikipedia.org/wiki/Chrome_OS" title="Chrome OS">Chrome OS</a>
<ul>
<li><a href="https://en.wikipedia.org/wiki/Chromebit" title="Chromebit">Chromebit</a></li>
<li><a href="https://en.wikipedia.org/wiki/Chromebook" title="Chromebook">Chromebook</a></li>
<li><a href="https://en.wikipedia.org/wiki/Chromebox" title="Chromebox">Chromebox</a></li>
<li><a href="/https://en.wikipedia.orgwiki/Chrome_Zone" title="Chrome Zone">Chrome Zone</a></li>
</ul>
</li>
<li><a href="https://en.wikipedia.org/wiki/Google_Fuchsia" title="Google Fuchsia">Fuchsia</a></li>
</ul>
</div>
</td>
</tr>
<tr>
<th scope="row" class="navbox-group" style="width:1%"><a href="https://en.wikipedia.org/wiki/Programming_language" title="Programming language">Programming<br />
languages</a></th>
<td class="navbox-list navbox-even" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px">
<div style="padding:0em 0.25em">
<ul>
<li><a href="https://en.wikipedia.org/wiki/Dart_(programming_language)" title="Dart (programming language)">Dart</a></li>
<li><a href="https://en.wikipedia.org/wiki/Go_(programming_language)" title="Go (programming language)">Go</a></li>
<li><a href="https://en.wikipedia.org/wiki/Sawzall_(programming_language)" title="Sawzall (programming language)">Sawzall</a></li>
</ul>
</div>
</td>
</tr>
<tr>
<th scope="row" class="navbox-group" style="width:1%"><a href="https://en.wikipedia.org/wiki/Google_Data_Centers" title="Google Data Centers">Platforms</a></th>
<td class="navbox-list navbox-odd" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px">
<div style="padding:0em 0.25em">
<ul>
<li><a href="https://en.wikipedia.org/wiki/Google_Account" title="Google Account">Account</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Authenticator" title="Google Authenticator">Authenticator</a></li>
<li><a href="https://en.wikipedia.org/wiki/ZygoteBody" title="ZygoteBody">Body</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Books" title="Google Books">Books</a>
<ul>
<li>Library Project</li>
</ul>
</li>
<li><a href="https://en.wikipedia.org/wiki/Caja_project" title="Caja project">Caja</a></li>
<li><a href="https://en.wikipedia.org/wiki/Virtual_reality" title="Virtual reality">Virtual reality</a>
<ul>
<li><a href="https://en.wikipedia.org/wiki/Google_Cardboard" title="Google Cardboard">Cardboard</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Daydream" title="Google Daydream">Daydream</a></li>
</ul>
</li>
<li><a href="https://en.wikipedia.org/wiki/Google_Cast" title="Google Cast">Cast</a></li>
<li><a href="https://en.wikipedia.org/wiki/Chromecast" title="Chromecast">Chromecast</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Cloud_Platform" title="Google Cloud Platform">Cloud Platform</a>
<ul>
<li><a href="https://en.wikipedia.org/wiki/Google_App_Engine" title="Google App Engine">App Engine</a></li>
<li><a href="https://en.wikipedia.org/wiki/BigQuery" title="BigQuery">BigQuery</a></li>
<li><a href="https://en.wikipedia.org/wiki/Bigtable" title="Bigtable">Bigtable</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Compute_Engine" title="Google Compute Engine">Compute Engine</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Storage" title="Google Storage">Storage</a></li>
</ul>
</li>
<li><a href="https://en.wikipedia.org/wiki/Google_Contact_Lens" title="Google Contact Lens">Contact Lens</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Custom_Search" title="Google Custom Search">Custom Search</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Daydream" title="Google Daydream">Daydream</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Earth_Engine" title="Google Earth Engine">Earth Engine</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Fit" title="Google Fit">Fit</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_File_System" title="Google File System">GFS</a></li>
<li><a href="https://en.wikipedia.org/wiki/Firebase" title="Firebase">Firebase</a></li>
<li><a href="https://en.wikipedia.org/wiki/G_Suite" title="G Suite">G Suite</a>
<ul>
<li><a href="https://en.wikipedia.org/wiki/Google_Classroom" title="Google Classroom">Classroom</a></li>
</ul>
</li>
<li><a href="https://en.wikipedia.org/wiki/Google_Home" title="Google Home">Home</a></li>
<li><a href="https://en.wikipedia.org/wiki/Jamboard" title="Jamboard">Jamboard</a></li>
<li><a href="https://en.wikipedia.org/wiki/G_Suite_Marketplace" title="G Suite Marketplace">Marketplace</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Native_Client" title="Google Native Client">Native Client</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Nexus" title="Google Nexus">Nexus</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_OnHub" title="Google OnHub">OnHub</a></li>
<li><a href="https://en.wikipedia.org/wiki/OpenSocial" title="OpenSocial">OpenSocial</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Primer" title="Google Primer">Primer</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Pixel" title="Google Pixel">Pixel</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Play" title="Google Play">Play</a>
<ul>
<li><a href="https://en.wikipedia.org/wiki/Google_Play_Books" title="Google Play Books">Books</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Play_Games" title="Google Play Games">Games</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Play_Movies_%26_TV" title="Google Play Movies &amp; TV">Movies &amp; TV</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Play_Music" title="Google Play Music">Music</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Play_Newsstand" title="Google Play Newsstand">Newsstand</a></li>
</ul>
</li>
<li><a href="https://en.wikipedia.org/wiki/Google_Public_DNS" title="Google Public DNS">Public DNS</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_URL_Shortener" title="Google URL Shortener">URL Shortener</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Wallet" title="Google Wallet">Wallet</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Wifi" class="mw-redirect" title="Google Wifi">Wifi</a></li>
</ul>
</div>
</td>
</tr>
<tr>
<th scope="row" class="navbox-group" style="width:1%">Development<br />
tools</th>
<td class="navbox-list navbox-even" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px">
<div style="padding:0em 0.25em">
<ul>
<li><a href="https://en.wikipedia.org/wiki/Google_APIs" title="Google APIs">AJAX APIs</a></li>
<li><a href="https://en.wikipedia.org/wiki/App_Inventor_for_Android" title="App Inventor for Android">App Inventor</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Closure_Tools" title="Google Closure Tools">Closure Tools</a></li>
<li><a href="https://en.wikipedia.org/wiki/CS_First" class="mw-redirect" title="CS First">CS First</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Developers" title="Google Developers">Developers</a></li>
<li><a href="https://en.wikipedia.org/wiki/Dialogflow" title="Dialogflow">Dialogflow</a></li>
<li><a href="https://en.wikipedia.org/wiki/Flutter_(software)" title="Flutter (software)">Flutter</a></li>
<li><a href="https://en.wikipedia.org/wiki/GData" title="GData">GData</a></li>
<li><a href="https://en.wikipedia.org/wiki/Googlebot" title="Googlebot">Googlebot</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Guava" title="Google Guava">Guava</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Guice" title="Google Guice">Guice</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Data_Centers" title="Google Data Centers">GWS</a></li>
<li><a href="https://en.wikipedia.org/wiki/Keyhole_Markup_Language" title="Keyhole Markup Language">KML</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Kythe" title="Google Kythe">Kythe</a></li>
<li><a href="https://en.wikipedia.org/wiki/MapReduce" title="MapReduce">MapReduce</a></li>
<li><a href="https://en.wikipedia.org/wiki/Mediabot" title="Mediabot">Mediabot</a></li>
<li><a href="https://en.wikipedia.org/wiki/Sitemaps" title="Sitemaps">Sitemaps</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Summer_of_Code" title="Google Summer of Code">Summer of Code</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Web_Toolkit" title="Google Web Toolkit">Web Toolkit</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Search_Console" title="Google Search Console">Search Console</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Website_Optimizer" title="Google Website Optimizer">Website Optimizer</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Swiffy" title="Google Swiffy">Swiffy</a></li>
</ul>
</div>
</td>
</tr>
<tr>
<th scope="row" class="navbox-group" style="width:1%">Publishing</th>
<td class="navbox-list navbox-odd" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px">
<div style="padding:0em 0.25em">
<ul>
<li><a href="https://en.wikipedia.org/wiki/Blogger_(service)" title="Blogger (service)">Blogger</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Bookmarks" title="Google Bookmarks">Bookmarks</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Drive" title="Google Drive">Drive</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Docs,_Sheets_and_Slides" class="mw-redirect" title="Google Docs, Sheets and Slides">Docs, Sheets, Slides, Forms</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Drawings" title="Google Drawings">Drawings</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_My_Maps" title="Google My Maps">My Maps</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Sites" title="Google Sites">Sites</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Fusion_Tables" title="Google Fusion Tables">Fusion Tables</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Domains" title="Google Domains">Domains</a></li>
<li><a href="https://en.wikipedia.org/wiki/FeedBurner" title="FeedBurner">FeedBurner</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Map_Maker" title="Google Map Maker">Map Maker</a></li>
<li><a href="https://en.wikipedia.org/wiki/YouTube" title="YouTube">YouTube</a></li>
<li><a href="https://en.wikipedia.org/wiki/YouTube_Instant" title="YouTube Instant">YouTube Instant</a></li>
<li><a href="https://en.wikipedia.org/wiki/YouTube_Red" title="YouTube Red">YouTube Red</a></li>
<li><a href="https://en.wikipedia.org/wiki/Vevo" title="Vevo">Vevo</a></li>
<li><a href="https://en.wikipedia.org/wiki/Zagat" title="Zagat">Zagat</a></li>
</ul>
</div>
</td>
</tr>
<tr>
<th scope="row" class="navbox-group" style="width:1%"><a href="https://en.wikipedia.org/wiki/Google_Search" title="Google Search">Search</a><br />
(<a href="https://en.wikipedia.org/wiki/Timeline_of_Google_Search" title="Timeline of Google Search">timeline</a>)</th>
<td class="navbox-list navbox-even" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px">
<div style="padding:0em 0.25em">
<ul>
<li><a href="https://en.wikipedia.org/wiki/Google_Search_Appliance" title="Google Search Appliance">Appliance</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Blog_Search" title="Google Blog Search">Blog Search</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Books" title="Google Books">Books</a>
<ul>
<li><a href="https://en.wikipedia.org/wiki/Google_Ngram_Viewer" title="Google Ngram Viewer">Ngram Viewer</a></li>
</ul>
</li>
<li><a href="https://en.wikipedia.org/wiki/Google_Custom_Search" title="Google Custom Search">Custom Search</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Finance" title="Google Finance">Finance</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Flights" title="Google Flights">Flights</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Images" title="Google Images">Images</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Maps" title="Google Maps">Maps</a>
<ul>
<li><a href="https://en.wikipedia.org/wiki/Google_Mars" class="mw-redirect" title="Google Mars">Mars</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Moon" class="mw-redirect" title="Google Moon">Moon</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Sky" class="mw-redirect" title="Google Sky">Sky</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Street_View" title="Google Street View">Street View</a>
<ul>
<li><a href="https://en.wikipedia.org/wiki/Coverage_of_Google_Street_View" title="Coverage of Google Street View">Coverage</a></li>
<li><a href="https://en.wikipedia.org/wiki/List_of_street_view_services" title="List of street view services">Competition</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Street_View_privacy_concerns" title="Google Street View privacy concerns">Privacy concerns</a></li>
</ul>
</li>
</ul>
</li>
<li><a href="https://en.wikipedia.org/wiki/Google_News" title="Google News">News</a>
<ul>
<li><a href="https://en.wikipedia.org/wiki/Google_News_Archive" title="Google News Archive">Archive</a></li>
</ul>
</li>
<li><a href="https://en.wikipedia.org/wiki/Google_Patents" title="Google Patents">Patents</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Public_Data_Explorer" title="Google Public Data Explorer">Public Data</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Scholar" title="Google Scholar">Scholar</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Shopping" title="Google Shopping">Shopping</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Groups" title="Google Groups">Usenet</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Videos" title="Google Videos">Videos</a></li>
</ul>
</div>
<table class="nowraplinks navbox-subgroup" style="border-spacing:0">
<tr>
<th scope="row" class="navbox-group" style="width:1%">Algorithms</th>
<td class="navbox-list navbox-odd" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px">
<div style="padding:0em 0.25em">
<ul>
<li><a href="https://en.wikipedia.org/wiki/PageRank" title="PageRank">PageRank</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Panda" title="Google Panda">Panda</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Penguin" title="Google Penguin">Penguin</a></li>
<li><a href="/https://en.wikipedia.orgwiki/Google_Hummingbird" title="Google Hummingbird">Hummingbird</a></li>
</ul>
</div>
</td>
</tr>
<tr>
<th scope="row" class="navbox-group" style="width:1%">Features</th>
<td class="navbox-list navbox-even" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px">
<div style="padding:0em 0.25em">
<ul>
<li><a href="https://en.wikipedia.org/wiki/Google_Personalized_Search" title="Google Personalized Search">Personalized</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Real-Time_Search" title="Google Real-Time Search">Real-Time</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Search#Instant_Search" title="Google Search">Instant Search</a></li>
<li><a href="https://en.wikipedia.org/wiki/SafeSearch" title="SafeSearch">SafeSearch</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Voice_Search" title="Google Voice Search">Voice Search</a></li>
</ul>
</div>
</td>
</tr>
<tr>
<th scope="row" class="navbox-group" style="width:1%">Analysis</th>
<td class="navbox-list navbox-odd" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px">
<div style="padding:0em 0.25em">
<ul>
<li><a href="https://en.wikipedia.org/wiki/Google_Insights_for_Search" title="Google Insights for Search">Insights for Search</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Trends" title="Google Trends">Trends</a></li>
<li><a href="https://en.wikipedia.org/wiki/Knowledge_Graph" title="Knowledge Graph">Knowledge Graph</a></li>
<li><a href="https://en.wikipedia.org/wiki/Knowledge_Vault" class="mw-redirect" title="Knowledge Vault">Knowledge Vault</a></li>
</ul>
</div>
</td>
</tr>
</table>
</td>
</tr>
<tr>
<th scope="row" class="navbox-group" style="width:1%"><a href="https://en.wikipedia.org/wiki/List_of_Google_products#Discontinued_products_and_services" title="List of Google products">Discontinued</a></th>
<td class="navbox-list navbox-even" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px">
<div style="padding:0em 0.25em">
<ul>
<li><a href="https://en.wikipedia.org/wiki/Aardvark_(search_engine)" title="Aardvark (search engine)">Aardvark</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Answers" title="Google Answers">Answers</a></li>
<li><a href="https://en.wikipedia.org/wiki/Project_Ara" title="Project Ara">Ara</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Browser_Sync" title="Google Browser Sync">Browser Sync</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Base" title="Google Base">Base</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Buzz" title="Google Buzz">Buzz</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Checkout" title="Google Checkout">Checkout</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Chrome_Frame" title="Google Chrome Frame">Chrome Frame</a></li>
<li><a href="https://en.wikipedia.org/wiki/AdWords#Google_Click-to-Call" title="AdWords">Click-to-Call</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Cloud_Connect" title="Google Cloud Connect">Cloud Connect</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Code_Search" title="Google Code Search">Code Search</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Currents" title="Google Currents">Currents</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Desktop" title="Google Desktop">Desktop</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Dictionary" title="Google Dictionary">Dictionary</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Directory" title="Google Directory">Directory</a></li>
<li><a href="https://en.wikipedia.org/wiki/Dodgeball_(service)" title="Dodgeball (service)">Dodgeball</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Fast_Flip" title="Google Fast Flip">Fast Flip</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Friend_Connect" title="Google Friend Connect">Friend Connect</a></li>
<li><a href="https://en.wikipedia.org/wiki/Gears_(software)" title="Gears (software)">Gears</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Glass" title="Google Glass">Glass</a></li>
<li><a href="https://en.wikipedia.org/wiki/Glass_OS" title="Glass OS">Glass OS</a></li>
<li><a href="https://en.wikipedia.org/wiki/GOOG-411" title="GOOG-411">GOOG-411</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_TV" title="Google TV">Google TV</a></li>
<li><a href="https://en.wikipedia.org/wiki/Jaiku" title="Jaiku">Jaiku</a></li>
<li><a href="https://en.wikipedia.org/wiki/Knol" title="Knol">Knol</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Health" title="Google Health">Health</a></li>
<li><a href="https://en.wikipedia.org/wiki/IGoogle" title="IGoogle">iGoogle</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Image_Labeler" title="Google Image Labeler">Image Labeler</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Labs" title="Google Labs">Labs</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Latitude" title="Google Latitude">Latitude</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Lively" title="Google Lively">Lively</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Mashup_Editor" title="Google Mashup Editor">Mashup Editor</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Notebook" title="Google Notebook">Notebook</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Offers" title="Google Offers">Offers</a></li>
<li><a href="https://en.wikipedia.org/wiki/Orkut" title="Orkut">Orkut</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Pack" title="Google Pack">Pack</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Page_Creator" title="Google Page Creator">Page Creator</a></li>
<li><a href="https://en.wikipedia.org/wiki/Panoramio" title="Panoramio">Panoramio</a></li>
<li><a href="https://en.wikipedia.org/wiki/Picasa" title="Picasa">Picasa</a></li>
<li><a href="https://en.wikipedia.org/wiki/Picasa_Web_Albums" title="Picasa Web Albums">Picasa Web Albums</a></li>
<li><a href="https://en.wikipedia.org/wiki/Picnik" title="Picnik">Picnik</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_PowerMeter" title="Google PowerMeter">PowerMeter</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Questions_and_Answers" title="Google Questions and Answers">Questions and Answers</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Reader" title="Google Reader">Reader</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Script_Converter" title="Google Script Converter">Script Converter</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_SearchWiki" title="Google SearchWiki">SearchWiki</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Sidewiki" title="Google Sidewiki">Sidewiki</a></li>
<li><a href="https://en.wikipedia.org/wiki/Slide.com" title="Slide.com">Slide</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Squared" title="Google Squared">Squared</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Talk" title="Google Talk">Talk</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Pack#Google_Updater" title="Google Pack">Updater</a></li>
<li><a href="https://en.wikipedia.org/wiki/Urchin_(software)" title="Urchin (software)">Urchin</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Videos" title="Google Videos">Videos</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Wave" title="Apache Wave">Wave</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Web_Accelerator" title="Google Web Accelerator">Web Accelerator</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Toolbar" title="Google Toolbar">Toolbar</a></li>
</ul>
</div>
</td>
</tr>
<tr>
<th scope="row" class="navbox-group" style="width:1%"><a href="https://en.wikipedia.org/wiki/Category:Google" title="Category:Google">Other</a></th>
<td class="navbox-list navbox-odd" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px">
<div style="padding:0em 0.25em">
<ul>
<li><a href="https://en.wikipedia.org/wiki/Google_Art_Project" title="Google Art Project">Art Project</a></li>
<li><a href="https://en.wikipedia.org/wiki/Calico_(company)" title="Calico (company)">Calico</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Current" title="Google Current">Current</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Chrome_Experiments" title="Google Chrome Experiments">Chrome Experiments</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Code-in" title="Google Code-in">Code-in</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Code_Jam" title="Google Code Jam">Code Jam</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Developer_Day" title="Google Developer Day">Developer Day</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Business_Groups" title="Google Business Groups">Google Business Groups</a></li>
<li><a href="https://en.wikipedia.org/wiki/Made_with_Code" title="Made with Code">Made with Code</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Data_Liberation_Front" title="Google Data Liberation Front">Data Liberation</a>
<ul>
<li><a href="https://en.wikipedia.org/wiki/Google_Takeout" title="Google Takeout">Takeout</a></li>
</ul>
</li>
<li><a href="https://en.wikipedia.org/wiki/Google_Developer_Expert" title="Google Developer Expert">Google Developer Expert</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_for_Work" title="Google for Work">Google for Work</a></li>
<li><a href="https://en.wikipedia.org/wiki/Waymo" title="Waymo">Self-driving car</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Earth#Google_Earth_Outreach" title="Google Earth">Earth Outreach</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Fiber" title="Google Fiber">Fiber</a></li>
<li><a href="https://en.wikipedia.org/wiki/GV_(company)" title="GV (company)">GV</a></li>
<li>"<a href="https://en.wikipedia.org/wiki/Google_(verb)" title="Google (verb)">Google</a>"</li>
<li><a href="https://en.wikipedia.org/wiki/Google_China" title="Google China">Google China</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Express" title="Google Express">Google Express</a></li>
<li><a href="https://en.wikipedia.org/wiki/Googlization" title="Googlization">Googlization</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Ad_Grants" title="Google Ad Grants">Grants</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google.org" title="Google.org">Google.org</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Lunar_X_Prize" title="Google Lunar X Prize">Lunar X Prize</a></li>
<li><a href="https://en.wikipedia.org/wiki/Project_Fi" title="Project Fi">Project Fi</a></li>
<li><a href="https://en.wikipedia.org/wiki/Material_Design" title="Material Design">Material Design</a></li>
<li><a href="https://en.wikipedia.org/wiki/Motorola_Mobility" title="Motorola Mobility">Motorola Mobility</a></li>
<li><a href="https://en.wikipedia.org/wiki/ReCAPTCHA" title="ReCAPTCHA">reCAPTCHA</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_WiFi" title="Google WiFi">WiFi</a></li>
<li><a href="https://en.wikipedia.org/wiki/X_(company)" title="X (company)">X</a></li>
</ul>
</div>
<table class="nowraplinks navbox-subgroup" style="border-spacing:0">
<tr>
<th scope="row" class="navbox-group" style="width:1%"><a href="https://en.wikipedia.org/wiki/Category:Google_events" title="Category:Google events">Events</a></th>
<td class="navbox-list navbox-even" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px">
<div style="padding:0em 0.25em">
<ul>
<li><a href="https://en.wikipedia.org/wiki/Google_Science_Fair" title="Google Science Fair">Science Fair</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Searchology" title="Google Searchology">Searchology</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_I/O" title="Google I/O">I/O</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Developer_Day" title="Google Developer Day">Developer Day</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Code_Jam" title="Google Code Jam">Code Jam</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Highly_Open_Participation_Contest" title="Google Highly Open Participation Contest">Highly Open Participation Contest</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Code-in" title="Google Code-in">Code-in</a></li>
</ul>
</div>
</td>
</tr>
<tr>
<th scope="row" class="navbox-group" style="width:1%">Projects</th>
<td class="navbox-list navbox-odd" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px">
<div style="padding:0em 0.25em">
<ul>
<li><a href="https://en.wikipedia.org/wiki/Project_Loon" title="Project Loon">Loon</a></li>
<li><a href="https://en.wikipedia.org/wiki/Tango_(platform)" title="Tango (platform)">Tango</a></li>
<li><a href="https://en.wikipedia.org/wiki/Project_Sunroof" title="Project Sunroof">Sunroof</a></li>
</ul>
</div>
</td>
</tr>
<tr>
<th scope="row" class="navbox-group" style="width:1%">Real estate</th>
<td class="navbox-list navbox-even" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px">
<div style="padding:0em 0.25em">
<ul>
<li><a href="https://en.wikipedia.org/wiki/111_Eighth_Avenue" title="111 Eighth Avenue">111 Eighth Avenue</a></li>
<li><a href="https://en.wikipedia.org/wiki/Googleplex" title="Googleplex">Googleplex</a></li>
</ul>
</div>
</td>
</tr>
<tr>
<th scope="row" class="navbox-group" style="width:1%"><a href="https://en.wikipedia.org/wiki/Google_logo" title="Google logo">Logo</a></th>
<td class="navbox-list navbox-odd" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px">
<div style="padding:0em 0.25em">
<ul>
<li><a href="https://en.wikipedia.org/wiki/Doodle4Google" title="Doodle4Google">Doodle4Google</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Doodle" title="Google Doodle">Google Doodles</a></li>
</ul>
</div>
</td>
</tr>
</table>
</td>
</tr>
<tr>
<th scope="row" class="navbox-group" style="width:1%">People</th>
<td class="navbox-list navbox-even" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px">
<div style="padding:0em 0.25em">
<ul>
<li><a href="https://en.wikipedia.org/wiki/Al_Gore" title="Al Gore">Al Gore</a></li>
<li><a href="https://en.wikipedia.org/wiki/Alan_Eustace" title="Alan Eustace">Alan Eustace</a></li>
<li><a href="https://en.wikipedia.org/wiki/Alan_Mulally" title="Alan Mulally">Alan Mulally</a></li>
<li><a href="https://en.wikipedia.org/wiki/Amit_Singhal" title="Amit Singhal">Amit Singhal</a></li>
<li><a href="https://en.wikipedia.org/wiki/Ann_Mather" title="Ann Mather">Ann Mather</a></li>
<li><a href="https://en.wikipedia.org/wiki/David_Drummond_(Google)" class="mw-redirect" title="David Drummond (Google)">David Drummond</a></li>
<li><a href="https://en.wikipedia.org/wiki/Eric_Schmidt" title="Eric Schmidt">Eric Schmidt</a></li>
<li><a href="https://en.wikipedia.org/wiki/Jeff_Dean_(computer_scientist)" title="Jeff Dean (computer scientist)">Jeff Dean</a></li>
<li><a href="https://en.wikipedia.org/wiki/John_Doerr" title="John Doerr">John Doerr</a></li>
<li><a href="https://en.wikipedia.org/wiki/John_L._Hennessy" title="John L. Hennessy">John L. Hennessy</a></li>
<li><a href="https://en.wikipedia.org/wiki/Krishna_Bharat" title="Krishna Bharat">Krishna Bharat</a></li>
<li><a href="https://en.wikipedia.org/wiki/Matt_Cutts" title="Matt Cutts">Matt Cutts</a></li>
<li><a href="https://en.wikipedia.org/wiki/Patrick_Pichette" title="Patrick Pichette">Patrick Pichette</a></li>
<li><a href="https://en.wikipedia.org/wiki/Paul_Otellini" title="Paul Otellini">Paul Otellini</a></li>
<li><a href="https://en.wikipedia.org/wiki/Omid_Kordestani" title="Omid Kordestani">Omid Kordestani</a></li>
<li><a href="https://en.wikipedia.org/wiki/Rachel_Whetstone" title="Rachel Whetstone">Rachel Whetstone</a></li>
<li><a href="https://en.wikipedia.org/wiki/Rajen_Sheth" title="Rajen Sheth">Rajen Sheth</a></li>
<li><a href="https://en.wikipedia.org/wiki/Ram_Shriram" title="Ram Shriram">Ram Shriram</a></li>
<li><a href="https://en.wikipedia.org/wiki/Ray_Kurzweil" title="Ray Kurzweil">Ray Kurzweil</a></li>
<li><a href="https://en.wikipedia.org/wiki/Ruth_Porat" title="Ruth Porat">Ruth Porat</a></li>
<li><a href="https://en.wikipedia.org/wiki/Salar_Kamangar" title="Salar Kamangar">Salar Kamangar</a></li>
<li><a href="https://en.wikipedia.org/wiki/Sanjay_Ghemawat" title="Sanjay Ghemawat">Sanjay Ghemawat</a></li>
<li><a href="https://en.wikipedia.org/wiki/Shirley_M._Tilghman" title="Shirley M. Tilghman">Shirley M. Tilghman</a></li>
<li><a href="https://en.wikipedia.org/wiki/Sundar_Pichai" title="Sundar Pichai">Sundar Pichai</a></li>
<li><a href="https://en.wikipedia.org/wiki/Susan_Wojcicki" title="Susan Wojcicki">Susan Wojcicki</a></li>
<li><a href="https://en.wikipedia.org/wiki/Urs_H%C3%B6lzle" title="Urs Hölzle">Urs Hölzle</a></li>
<li><a href="https://en.wikipedia.org/wiki/Vint_Cerf" title="Vint Cerf">Vint Cerf</a></li>
<li><a href="https://en.wikipedia.org/wiki/Hal_Varian" title="Hal Varian">Hal Varian</a></li>
<li><a href="https://en.wikipedia.org/wiki/Gayglers" title="Gayglers">Gayglers</a></li>
</ul>
</div>
<table class="nowraplinks navbox-subgroup" style="border-spacing:0">
<tr>
<th scope="row" class="navbox-group" style="width:1%">Founders</th>
<td class="navbox-list navbox-odd" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px">
<div style="padding:0em 0.25em">
<ul>
<li><a href="https://en.wikipedia.org/wiki/Larry_Page" title="Larry Page">Larry Page</a></li>
<li><a href="https://en.wikipedia.org/wiki/Sergey_Brin" title="Sergey Brin">Sergey Brin</a></li>
</ul>
</div>
</td>
</tr>
</table>
</td>
</tr>
<tr>
<th scope="row" class="navbox-group" style="width:1%">Related</th>
<td class="navbox-list navbox-even" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px">
<div style="padding:0em 0.25em">
<ul>
<li><a href="https://en.wikipedia.org/wiki/AI_Challenge" title="AI Challenge">AI Challenge</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_bomb" title="Google bomb">Bomb</a></li>
<li><a href="https://en.wikipedia.org/wiki/GmailFS" title="GmailFS">GmailFS</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_Behind_the_Screen" title="Google Behind the Screen">"Google: Behind the Screen" (2006 documentary)</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_The_Thinking_Factory" title="Google The Thinking Factory"><i>Google: The Thinking Factory</i> (2008 documentary)</a></li>
<li><a href="https://en.wikipedia.org/wiki/Google_and_the_World_Brain" title="Google and the World Brain"><i>Google and the World Brain</i> (2013 documentary)</a></li>
<li><a href="https://en.wikipedia.org/wiki/Goojje" title="Goojje">Goojje</a></li>
<li><a href="https://en.wikipedia.org/wiki/Monopoly_video_games" title="Monopoly video games">Monopoly City Streets</a></li>
<li><a href="https://en.wikipedia.org/wiki/Unity_(cable_system)" title="Unity (cable system)">Unity</a></li>
</ul>
</div>
</td>
</tr>
<tr>
<td class="navbox-abovebelow" colspan="2">
<div>

</div>
</td>
</tr>
</table>

----------------

