## Google Cloud Platform

Below is the learning material that will help you learn about Google Cloud. 

**Network**

* [Networking 101](https://codelabs.developers.google.com/codelabs/cloud-networking-101/index.html?index=..%2F..%2Fcloud#0) – 43 mins

The codelab provides common cloud developer experience as follows: 

* Set up your lab environment and learn how to work with your GCP environment.
* Use of common open source tools to explore your network around the world.
* Deploy a common use case: use of HTTP Load Balancing and Managed Instance Groups to host a scalable, multi-region web server.
* Testing and monitoring your network and instances.
* Cleanup.

[Developing Solutions for Google Cloud Platform](https://www.cbtnuggets.com/it-training/cpd200-developing-solutions-for-google-cloud-platform) – 8 hours


**Infrastructure**

* [Build a Slack Bot with Node.js on Kubernotes](https://codelabs.developers.google.com/codelabs/cloud-slack-bot/index.html?index=..%2F..%2Fcloud#0) – 43 mins
* [Creating a Virtual Machine](https://codelabs.developers.google.com/codelabs/cloud-create-a-vm/index.html?index=..%2F..%2Fcloud#0) – 10 mins
* [Getting Started with App Engine (Python)](https://codelabs.developers.google.com/codelabs/cloud-app-engine-python/index.html?index=..%2F..%2Fcloud#0) – 13 mins


**Data**

* [Introduction to Google Cloud Data Prep](https://codelabs.developers.google.com/codelabs/cloud-dataprep-intro/index.html?index=..%2F..%2Fcloud#0) – 7 mins
* [Create a Managed MySQL database with Cloud SQL](https://codelabs.developers.google.com/codelabs/cloud-create-cloud-sql-db/index.html?index=..%2F..%2Fcloud#0) – 19 mins
* [Upload Objects to Cloud Storage](https://codelabs.developers.google.com/codelabs/cloud-upload-objects-to-cloud-storage/index.html?index=..%2F..%2Fcloud#0) – 11 mins

**AI, Big Data & Machine Learning**

* [Introduction to Google Cloud Machine Learning](https://www.youtube.com/watch?v=COSXg5HKaO4&index=43&list=PLIivdWyY5sqLq-eM4W2bIgbrpAsP5aLtZ) – 1 hour
* [Machine Learning APIs by Example](https://www.youtube.com/watch?v=w1xNTLH1zlA&index=13&list=PLIivdWyY5sqLq-eM4W2bIgbrpAsP5aLtZ) – 30 min
* [Google Cloud Platform Big Data and Machine Learning Fundamentals](https://www.coursera.org/learn/gcp-big-data-ml-fundamentals)


**Additional AI Materials**

* [Auto-awesome: Advanced Data Science on Google Cloud Platform](https://www.youtube.com/watch?v=Jp-qJFF9jww&index=1&list=PLIivdWyY5sqLq-eM4W2bIgbrpAsP5aLtZ) – 45 min
* [Run a Big Data Text Processing Pipeline in Cloud Dataflow](https://codelabs.developers.google.com/codelabs/cloud-dataflow-starter/index.html?index=..%2F..%2Fcloud#0) – 21 min
* [Image Classification Using Cloud ML Engine & Datalab](https://codelabs.developers.google.com/codelabs/cloud-ml-engine-image-classification/index.html?index=..%2F..%2Fcloud#0) – 58 min
* [Structured Data Regression Using Cloud ML Engine & Datalab](https://codelabs.developers.google.com/codelabs/cloud-ml-engine-sd-regression/index.html?index=..%2F..%2Fcloud#0) – 58 min

**(Optional) Deep Learning & Tensorflow**

* [Tensorflow and Deep Learning Tutorial](https://www.youtube.com/watch?v=vq2nnJ4g6N0&t=1411s) – 2:35 hours
* [Deep Learning Course – advanced users only](https://www.udacity.com/course/deep-learning--ud730)

**Additional Reference Material**

* [Big Data & Machine Learning @ Google Cloud Next '17](https://www.youtube.com/playlist?list=PLIivdWyY5sqLq-eM4W2bIgbrpAsP5aLtZ) - A collection of 49 videos
*****************
