
## casestudy: bigdata ecosystem and databases

* bigdata tools : apache hadoop and apache spark
* databases : MySQL, SQLAlchemy, InfluxDB, Neo4j, MongoDB, RethinkDB, TinkerPop, PostgreSQL, CouchDB, HBase
----------------
**goals of this article**


* casestudy to outline all available bigdata and database softwares
* to explore architectures of bigdata tools(hadoop and spark)
------------------

<p>Some papers influenced the birth and growth of Hadoop and big data processing. Some of these are:</p>
<ul>
<li>Jeffrey Dean, Sanjay Ghemawat (2004) <a rel="nofollow" class="external text" href="https://www.usenix.org/legacy/publications/library/proceedings/osdi04/tech/full_papers/dean/dean_html/index.html">MapReduce: Simplified Data Processing on Large Clusters</a>, Google. This paper inspired Doug Cutting to develop an open-source implementation of the Map-Reduce framework. He named it Hadoop, after his son's toy elephant.</li>
<li>Michael Franklin, Alon Halevy, David Maier (2005) <a rel="nofollow" class="external text" href="http://www.eecs.berkeley.edu/~franklin/Papers/dataspaceSR.pdf">From Databases to Dataspaces: A New Abstraction for Information Management</a>. The authors highlight the need for storage systems to accept all data formats and to provide APIs for data access that evolve based on the storage system's understanding of the data.</li>
<li>Fay Chang et al. (2006) <a rel="nofollow" class="external text" href="http://static.googleusercontent.com/external_content/untrusted_dlcp/research.google.com/en/us/archive/bigtable-osdi06.pdf">Bigtable: A Distributed Storage System for Structured Data</a>, Google.</li>
<li>Robert Kallman et al. (2008) <a rel="nofollow" class="external text" href="http://www.vldb.org/pvldb/1/1454211.pdf">H-store: a high-performance, distributed main memory transaction processing system</a></li>
</ul>


**Spark**

* [Spark: Cluster Computing with Working Sets](https://amplab.cs.berkeley.edu/wp-content/uploads/2011/06/Spark-Cluster-Computing-with-Working-Sets.pdf)

----------------

some usefull tags to understand bigdata tools in simple words

| [Big Data](https://www.quora.com/topic/Big-Data) | [Data Science](https://www.quora.com/topic/Data-Science) |  [Data Analysis](https://www.quora.com/topic/Data-Analysis) |  [
Jobs and Careers in Data Science](https://www.quora.com/topic/Jobs-and-Careers-in-Data-Science) |  [Data Mining](https://www.quora.com/topic/Data-Mining) |  [Big Data Analysis](https://www.quora.com/topic/Big-Data-Analysis) |  [Big Data Analytics](https://www.quora.com/topic/Big-Data-Analytics-3) |  [Hadoop in Big Data](https://www.quora.com/topic/Hadoop-in-Big-Data) |  [Big Data Companies](https://www.quora.com/topic/Big-Data-Companies) |  [Masters in Data Science](https://www.quora.com/topic/Masters-in-Data-Science) |  [Data Analytics](https://www.quora.com/topic/Data-Analytics) |  [Big Data Careers](https://www.quora.com/topic/Big-Data-Careers-1) |  [Data Scientists](https://www.quora.com/topic/Data-Scientists-2) |  [Jobs and Careers in Data Science](https://www.quora.com/topic/Jobs-and-Careers-in-Data-Science) |  [
Learning Data Science](https://www.quora.com/topic/Learning-Data-Science) |  [Becoming a Data Scientist](https://www.quora.com/topic/Becoming-a-Data-Scientist) |  [Data Science Interviews](https://www.quora.com/topic/Data-Science-Interviews) |  [Facebook Data Science](https://www.quora.com/topic/Facebook-Data-Science) |  [Hadoop in Big Data](https://www.quora.com/topic/Hadoop-in-Big-Data) |  [Apache Hadoop YARN](https://www.quora.com/topic/Apache-Hadoop-YARN) |  [Yarn](https://www.quora.com/topic/Yarn) |  [Apache Mesos](https://www.quora.com/topic/Apache-Mesos) |  [Kubernetes](https://www.quora.com/topic/Kubernetes) |  [Microservices](https://www.quora.com/topic/Microservices) |  [Docker](https://www.quora.com/topic/Docker) |  [DevOps](https://www.quora.com/topic/DevOps) |  [Containers
(virtualization)](https://www.quora.com/topic/Containers-virtualization) |  [CoreOS](https://www.quora.com/topic/CoreOS) |  [MapReduce](https://www.quora.com/topic/MapReduce) |  [Apache Hadoop](https://www.quora.com/topic/Apache-Hadoop) |  [Hortonworks](https://www.quora.com/topic/Hortonworks-company) |  [MapR Technologies](https://www.quora.com/topic/MapR-Technologies) |  [Hadoop Cluster](https://www.quora.com/topic/Hadoop-Cluster) |  [Computer Cluster](https://www.quora.com/topic/Computer-Cluster) |  [Cluster analysis](https://www.quora.com/topic/Cluster-analysis) |  [High Performance Computing](https://www.quora.com/topic/High-Performance-Computing) |  [Parallel Computing](https://www.quora.com/topic/Parallel-Computing) |  [Compute Unified Device Architecture
(CUDA)](https://www.quora.com/topic/Compute-Unified-Device-Architecture-CUDA) |  [GPU Computation](https://www.quora.com/topic/GPU-Computation) |  [OpenCL](https://www.quora.com/topic/OpenCL) |  [General-Purpose GPU](https://www.quora.com/topic/General-Purpose-GPU) |  [Graphics Processing Unit](https://www.quora.com/topic/Graphics-Processing-Unit) |  [Hadoop Distributed File System](https://www.quora.com/topic/Hadoop-Distributed-File-System-1) |  [Flume](https://www.quora.com/topic/Flume) |  [Apache Kafka](https://www.quora.com/topic/Apache-Kafka) |  [RabbitMQ](https://www.quora.com/topic/RabbitMQ) |  [MQ Telemetry Transport
(MQTT)](https://www.quora.com/topic/MQ-Telemetry-Transport-MQTT) |  [eXtensible Messaging and Presence Protocol
(XMPP)](https://www.quora.com/topic/eXtensible-Messaging-and-Presence-Protocol-XMPP) |  [Apache Hive](https://www.quora.com/topic/Apache-Hive) |  [Apache Impala
(incubating)](https://www.quora.com/topic/Apache-Impala-incubating) |  [Apache Sqoop](https://www.quora.com/topic/Apache-Sqoop) |  [Apache Pig](https://www.quora.com/topic/Apache-Pig) |  [Apache Spark](https://www.quora.com/topic/Apache-Spark) |  [Apache Storm](https://www.quora.com/topic/Apache-Storm) |  [Stream Processing](https://www.quora.com/topic/Stream-Processing) |  [Data Streams](https://www.quora.com/topic/Data-Streams) |    [Distributed Systems](https://www.quora.com/topic/Distributed-Systems) |    [Apache ZooKeeper](https://www.quora.com/topic/Apache-ZooKeeper) |    [Databricks](https://www.quora.com/topic/Databricks) |    [HBase](https://www.quora.com/topic/HBase) |    [Amazon Elastic MapReduce](https://www.quora.com/topic/Amazon-Elastic-MapReduce) |    [Apache Pig](https://www.quora.com/topic/Apache-Pig) |    [Hadoop Jobs](https://www.quora.com/topic/Hadoop-Jobs) |    [Hadoop Administration](https://www.quora.com/topic/Hadoop-Administration) |    [Jobs and Careers in Data Science](https://www.quora.com/topic/Jobs-and-Careers-in-Data-Science) |    [Data Mining](https://www.quora.com/topic/Data-Mining) |    [Data Scientists](https://www.quora.com/topic/Data-Scientists-2) |    [IBM Big Data and Analytics](https://www.quora.com/topic/IBM-Big-Data-and-Analytics) |    [Big Data Infrastructure](https://www.quora.com/topic/Big-Data-Infrastructure) |    [Data Engineering](https://www.quora.com/topic/Data-Engineering) |    [Data Science Master's Programs](https://www.quora.com/topic/Data-Science-Masters-Programs-1) |    [Business Intelligence](https://www.quora.com/topic/Business-Intelligence) |    [Tableau
(product)](https://www.quora.com/topic/Tableau-product) |    [Data Visualization](https://www.quora.com/topic/Data-Visualization) |    [D3.js
(JavaScript library)](https://www.quora.com/topic/D3-js-JavaScript-library) |    [Business Intelligence Software](https://www.quora.com/topic/Business-Intelligence-Software) |    [Data Warehousing](https://www.quora.com/topic/Data-Warehousing) |    [Amazon Redshift](https://www.quora.com/topic/Amazon-Redshift) |    [Google BigQuery](https://www.quora.com/topic/Google-BigQuery) |    [Amazon RDS](https://www.quora.com/topic/Amazon-RDS) |[Informatica
(company)](https://www.quora.com/topic/Informatica-company) |  [QlikView](https://www.quora.com/topic/QlikView) |  [Microsoft Power BI](https://www.quora.com/topic/Microsoft-Power-BI) |  [Business Analytics](https://www.quora.com/topic/Business-Analytics) |  [Extract, Transform, Load
(ETL)](https://www.quora.com/topic/Extract-Transform-Load-ETL) |  [Analytics](https://www.quora.com/topic/Analytics) |  [
Web Analytics](https://www.quora.com/topic/Web-Analytics) |  [Business Analytics](https://www.quora.com/topic/Business-Analytics) |  [Google Analytics
(product)](https://www.quora.com/topic/Google-Analytics-product) |  [Google Analytics API](https://www.quora.com/topic/Google-Analytics-API) |  [Predictive Analytics](https://www.quora.com/topic/Predictive-Analytics) |  [Predictive Modeling](https://www.quora.com/topic/Predictive-Modeling) |  [Mobile Analytics](https://www.quora.com/topic/Mobile-Analytics) |  [
Mobile App Analytics](https://www.quora.com/topic/Mobile-App-Analytics) |  [Data Science Master's Programs](https://www.quora.com/topic/Data-Science-Masters-Programs-1) |  [Masters in Data Science](https://www.quora.com/topic/Masters-in-Data-Science) |      


database tools

| [Database Systems](https://www.quora.com/topic/Database-Systems) | [SQL](https://www.quora.com/topic/SQL) |  [MySQL](https://www.quora.com/topic/MySQL) |  [MySQL Performance](https://www.quora.com/topic/MySQL-Performance) |  [Database Administration](https://www.quora.com/topic/Database-Administration) |  [Database Theory](https://www.quora.com/topic/Database-Theory) |  [Database Design](https://www.quora.com/topic/Database-Design) |  [
Relational Databases](https://www.quora.com/topic/Relational-Databases) |  [Graph Databases](https://www.quora.com/topic/Graph-Databases) |  [OrientDB](https://www.quora.com/topic/OrientDB) |  [Database Management Software](https://www.quora.com/topic/Database-Management-Software) |  [Neo4j](https://www.quora.com/topic/Neo4j) |  [Titan
(graph database)](https://www.quora.com/topic/Titan-graph-database) |  [Online Social Network Graphs](https://www.quora.com/topic/Online-Social-Network-Graphs) |  [Facebook Graph API](https://www.quora.com/topic/Facebook-Graph-API) |    [Titan
(graph database)](https://www.quora.com/topic/Titan-graph-database) |  [Oracle
(company)](https://www.quora.com/topic/Oracle-company-1) |  [Oracle Database 12C](https://www.quora.com/topic/Oracle-Database-12C) |  [NoSQL](https://www.quora.com/topic/NoSQL) |  [CouchDB](https://www.quora.com/topic/CouchDB) |  [Cassandra
(database)](https://www.quora.com/topic/Cassandra-database) |  [Memcached](https://www.quora.com/topic/Memcached) |  [
Redis](https://www.quora.com/topic/Redis) |  [MS SQL Server
(product)](https://www.quora.com/topic/MS-SQL-Server-product) |  [MongoDB](https://www.quora.com/topic/MongoDB) |  [Elasticsearch](https://www.quora.com/topic/Elasticsearch) |  [Oracle Database](https://www.quora.com/topic/Oracle-Database) |  [Database Management Software](https://www.quora.com/topic/Database-Management-Software) |  [Databases](https://www.quora.com/topic/Databases-2) |  [PostgreSQL](https://www.quora.com/topic/PostgreSQL) |  [PL/SQL](https://www.quora.com/topic/PL-SQL) |  [Oracle DBA](https://www.quora.com/topic/Oracle-DBA) |  [Couchbase](https://www.quora.com/topic/Couchbase) |  [Riak](https://www.quora.com/topic/Riak) |  [SQLAlchemy](https://www.quora.com/topic/SQLAlchemy) |  [InfluxDB](https://www.quora.com/topic/InfluxDB) |  [RethinkDB](https://www.quora.com/topic/RethinkDB) |  [Database Startups](https://www.quora.com/topic/Database-Startups) |  [PostgreSQL](https://www.quora.com/topic/PostgreSQL) |  [HBase](https://www.quora.com/topic/HBase) |  

-------------
* [big data products](https://en.wikipedia.org/wiki/Category:Big_data_products)
* [Database management systems](https://en.wikipedia.org/wiki/Category:Database_management_systems)
* [Data management software](https://en.wikipedia.org/wiki/Category:Data_management_software)

<div role="navigation" class="navbox" aria-labelledby="Apache_Software_Foundation" style="padding:3px">
<table class="nowraplinks hlist collapsible autocollapse navbox-inner" style="border-spacing:0;background:transparent;color:inherit">
<tr>
<th scope="col" class="navbox-title" colspan="3">
<div class="plainlinks hlist navbar mini">
<ul>

</ul>
</div>
<div id="Apache_Software_Foundation" style="font-size:114%;margin:0 4em"><a href="https://en.wikipedia.org/wiki/Apache_Software_Foundation" title="Apache Software Foundation">Apache Software Foundation</a></div>
</th>
</tr>
<tr>
<th scope="row" class="navbox-group" style="width:1%">Top level projects</th>
<td class="navbox-list navbox-odd" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px">
<div style="padding:0em 0.25em">
<ul>
<li><a href="https://en.wikipedia.org/wiki/Apache_Accumulo" title="Apache Accumulo">Accumulo</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_ActiveMQ" title="Apache ActiveMQ">ActiveMQ</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Ambari" title="Apache Ambari">Ambari</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Ant" title="Apache Ant">Ant</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Apex" title="Apache Apex">Apex</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Aries" title="Apache Aries">Aries</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_HTTP_Server" title="Apache HTTP Server">Apache HTTP Server</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Portable_Runtime" title="Apache Portable Runtime">APR</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Avro" title="Apache Avro">Avro</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Axis" title="Apache Axis">Axis</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Axis2" title="Apache Axis2">Axis2</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Beam" title="Apache Beam">Beam</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Bloodhound" title="Apache Bloodhound">Bloodhound</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Brooklyn" title="Apache Brooklyn">Brooklyn</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Buildr" title="Apache Buildr">Buildr</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Calcite" title="Apache Calcite">Calcite</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Camel" title="Apache Camel">Camel</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Cassandra" title="Apache Cassandra">Cassandra</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Cayenne" title="Apache Cayenne">Cayenne</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Chemistry" title="Apache Chemistry">Chemistry</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_CloudStack" title="Apache CloudStack">CloudStack</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Cocoon" title="Apache Cocoon">Cocoon</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Cordova" title="Apache Cordova">Cordova</a></li>
<li><a href="https://en.wikipedia.org/wiki/CouchDB" title="CouchDB">CouchDB</a></li>
<li><a href="https://en.wikipedia.org/wiki/CTAKES" title="CTAKES">cTAKES</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_CXF" title="Apache CXF">CXF</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Derby" title="Apache Derby">Derby</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Directory" title="Apache Directory">Directory</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Drill" title="Apache Drill">Drill</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Empire-db" title="Apache Empire-db">Empire-db</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Felix" title="Apache Felix">Felix</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Flex" title="Apache Flex">Flex</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Flink" title="Apache Flink">Flink</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Flume" title="Apache Flume">Flume</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Forrest" title="Apache Forrest">Forrest</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Geronimo" title="Apache Geronimo">Geronimo</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Gora" title="Apache Gora">Gora</a></li>
<li><a href="/w/index.php?title=Apache_Guacamole&amp;action=edit&amp;redlink=1" class="new" title="Apache Guacamole (page does not exist)">Guacamole</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Gump" title="Apache Gump">Gump</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Hadoop" title="Apache Hadoop">Hadoop</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Hama" title="Apache Hama">Hama</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_HBase" title="Apache HBase">HBase</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Hive" title="Apache Hive">Hive</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Jackrabbit" title="Apache Jackrabbit">Jackrabbit</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_James" title="Apache James">James</a></li>
<li><a href="https://en.wikipedia.org/wiki/Jini" title="Jini">Jini</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_JMeter" title="Apache JMeter">JMeter</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Kafka" title="Apache Kafka">Kafka</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Kudu" title="Apache Kudu">Kudu</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Kylin" title="Apache Kylin">Kylin</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Lucene" title="Apache Lucene">Lucene</a></li>
<li><a class="mw-selflink selflink">Mahout</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Marmotta" title="Apache Marmotta">Marmotta</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Maven" title="Apache Maven">Maven</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_MINA" title="Apache MINA">MINA</a></li>
<li><a href="https://en.wikipedia.org/wiki/Mod_perl" title="Mod perl">mod_perl</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_MyFaces" title="Apache MyFaces">MyFaces</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Nutch" title="Apache Nutch">Nutch</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_ODE" title="Apache ODE">ODE</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_OFBiz" title="Apache OFBiz">OFBiz</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Oozie" title="Apache Oozie">Oozie</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_OpenEJB" title="Apache OpenEJB">OpenEJB</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_OpenJPA" title="Apache OpenJPA">OpenJPA</a></li>
<li><a href="https://en.wikipedia.org/wiki/OpenNLP" class="mw-redirect" title="OpenNLP">OpenNLP</a></li>
<li><a href="/w/index.php?title=A%D1%80ache_O%D1%80en_Office&amp;action=edit&amp;redlink=1" class="new" title="Aрache Oрen Office (page does not exist)">Oрen Office</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_PDFBox" title="Apache PDFBox">PDFBox</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Parquet" title="Apache Parquet">Parquet</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Phoenix" title="Apache Phoenix">Phoenix</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_POI" title="Apache POI">POI</a></li>
<li><a href="https://en.wikipedia.org/wiki/Pig_(programming_tool)" title="Pig (programming tool)">Pig</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Pivot" title="Apache Pivot">Pivot</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Qpid" title="Apache Qpid">Qpid</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Roller" title="Apache Roller">Roller</a></li>
<li><a href="/w/index.php?title=Apache_RocketMQ&amp;action=edit&amp;redlink=1" class="new" title="Apache RocketMQ (page does not exist)">RocketMQ</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Samza" title="Apache Samza">Samza</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_ServiceMix" title="Apache ServiceMix">ServiceMix</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Shiro" title="Apache Shiro">Shiro</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Sling" title="Apache Sling">Sling</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Solr" title="Apache Solr">Solr</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Spark" title="Apache Spark">Spark</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Stanbol" title="Apache Stanbol">Stanbol</a></li>
<li><a href="https://en.wikipedia.org/wiki/Storm_(event_processor)" title="Storm (event processor)">Storm</a></li>
<li><a href="https://en.wikipedia.org/wiki/SpamAssassin" title="SpamAssassin">SpamAssassin</a></li>
<li><a href="https://en.wikipedia.org/wiki/Sqoop" title="Sqoop">Sqoop</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Struts_1" title="Apache Struts 1">Struts 1</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Struts_2" title="Apache Struts 2">Struts 2</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Subversion" title="Apache Subversion">Subversion</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_SystemML" title="Apache SystemML">SystemML</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Tapestry" title="Apache Tapestry">Tapestry</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Thrift" title="Apache Thrift">Thrift</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Tika" title="Apache Tika">Tika</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Tomcat" title="Apache Tomcat">Tomcat</a></li>
<li><a href="https://en.wikipedia.org/wiki/Traffic_Server" title="Traffic Server">Traffic Server</a></li>
<li><a href="https://en.wikipedia.org/wiki/UIMA" title="UIMA">UIMA</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Velocity" title="Apache Velocity">Velocity</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Wave" title="Apache Wave">Wave</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Wicket" title="Apache Wicket">Wicket</a></li>
<li><a href="https://en.wikipedia.org/wiki/Xalan" title="Xalan">Xalan</a></li>
<li><a href="https://en.wikipedia.org/wiki/Xerces" title="Xerces">Xerces</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Yetus" title="Apache Yetus">Yetus</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_ZooKeeper" title="Apache ZooKeeper">ZooKeeper</a></li>
</ul>
</div>
</td>
<td class="navbox-image" rowspan="6" style="width:1px;padding:0px 0px 0px 2px">
<div><a href="https://en.wikipedia.org/wiki/File:Apache_Software_Foundation_Logo_(2016).svg" class="image" title="ASF logo"><img alt="ASF logo" src="//upload.wikimedia.org/wikipedia/commons/thumb/d/db/Apache_Software_Foundation_Logo_%282016%29.svg/200px-Apache_Software_Foundation_Logo_%282016%29.svg.png" width="200" height="98" srcset="//upload.wikimedia.org/wikipedia/commons/thumb/d/db/Apache_Software_Foundation_Logo_%282016%29.svg/300px-Apache_Software_Foundation_Logo_%282016%29.svg.png 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/d/db/Apache_Software_Foundation_Logo_%282016%29.svg/400px-Apache_Software_Foundation_Logo_%282016%29.svg.png 2x" data-file-width="512" data-file-height="250" /></a></div>
</td>
</tr>
<tr>
<th scope="row" class="navbox-group" style="width:1%"><a href="https://en.wikipedia.org/wiki/Apache_Commons" title="Apache Commons">Commons</a></th>
<td class="navbox-list navbox-even" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px">
<div style="padding:0em 0.25em">
<ul>
<li><a href="https://en.wikipedia.org/wiki/Byte_Code_Engineering_Library" title="Byte Code Engineering Library">BCEL</a></li>
<li><a href="https://en.wikipedia.org/wiki/Bean_Scripting_Framework" title="Bean Scripting Framework">BSF</a></li>
<li><a href="https://en.wikipedia.org/wiki/Commons_Daemon" title="Commons Daemon">Daemon</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Jelly" title="Apache Jelly">Jelly</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Commons_Logging" title="Apache Commons Logging">Logging</a></li>
</ul>
</div>
</td>
</tr>
<tr>
<th scope="row" class="navbox-group" style="width:1%"><a href="https://en.wikipedia.org/wiki/Apache_Incubator" title="Apache Incubator">Incubator</a></th>
<td class="navbox-list navbox-odd" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px">
<div style="padding:0em 0.25em">
<ul>
<li><a href="https://en.wikipedia.org/wiki/Apache_NetBeans" class="mw-redirect" title="Apache NetBeans">NetBeans</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Singa" class="mw-redirect" title="Apache Singa">SINGA</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Trafodion" title="Apache Trafodion">Trafodion</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_XAP" title="Apache XAP">XAP</a></li>
</ul>
</div>
</td>
</tr>
<tr>
<th scope="row" class="navbox-group" style="width:1%">Other projects</th>
<td class="navbox-list navbox-even" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px">
<div style="padding:0em 0.25em">
<ul>
<li><a href="https://en.wikipedia.org/wiki/Batik_(software)" title="Batik (software)">Batik</a></li>
<li><a href="https://en.wikipedia.org/wiki/Chainsaw_(log_file_viewer)" title="Chainsaw (log file viewer)">Chainsaw</a></li>
<li><a href="https://en.wikipedia.org/wiki/Formatting_Objects_Processor" title="Formatting Objects Processor">FOP</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Ivy" title="Apache Ivy">Ivy</a></li>
<li><a href="https://en.wikipedia.org/wiki/Log4j" title="Log4j">Log4j</a></li>
</ul>
</div>
</td>
</tr>
<tr>
<th scope="row" class="navbox-group" style="width:1%"><a href="https://en.wikipedia.org/wiki/Apache_Attic" title="Apache Attic">Attic</a></th>
<td class="navbox-list navbox-odd" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px">
<div style="padding:0em 0.25em">
<ul>
<li><a href="https://en.wikipedia.org/wiki/Apache_Abdera" title="Apache Abdera">Abdera</a></li>
<li><a href="https://en.wikipedia.org/wiki/AxKit" title="AxKit">AxKit</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Beehive" title="Apache Beehive">Beehive</a></li>
<li><a href="https://en.wikipedia.org/wiki/BlueSky_Open_Platform" title="BlueSky Open Platform">Bluesky</a></li>
<li><a href="https://en.wikipedia.org/wiki/IBATIS" title="IBATIS">iBATIS</a></li>
<li><a href="https://en.wikipedia.org/wiki/Jakarta_Cactus" title="Jakarta Cactus">Cactus</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Click" title="Apache Click">Click</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Continuum" title="Apache Continuum">Continuum</a></li>
<li><a href="https://en.wikipedia.org/wiki/Deltacloud" title="Deltacloud">Deltacloud</a></li>
<li><a href="https://en.wikipedia.org/wiki/Etch_(protocol)" title="Etch (protocol)">Etch</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Excalibur" title="Apache Excalibur">Excalibur</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Harmony" title="Apache Harmony">Harmony</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_HiveMind" title="Apache HiveMind">HiveMind</a></li>
<li><a href="https://en.wikipedia.org/wiki/Jakarta_Project" title="Jakarta Project">Jakarta</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Lenya" title="Apache Lenya">Lenya</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Shale" title="Apache Shale">Shale</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Shindig" title="Apache Shindig">Shindig</a></li>
<li><a href="https://en.wikipedia.org/wiki/Jakarta_Slide" title="Jakarta Slide">Slide</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_C%2B%2B_Standard_Library" title="Apache C++ Standard Library">stdcxx</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Tuscany" title="Apache Tuscany">Tuscany</a></li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Wink" title="Apache Wink">Wink</a></li>
<li><a href="https://en.wikipedia.org/wiki/XMLBeans" title="XMLBeans">XMLBeans</a></li>
</ul>
</div>
</td>
</tr>
<tr>
<th scope="row" class="navbox-group" style="width:1%">Licenses</th>
<td class="navbox-list navbox-even" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px">
<div style="padding:0em 0.25em">
<ul>
<li><a href="https://en.wikipedia.org/wiki/Apache_License" title="Apache License">Apache License</a></li>
</ul>
</div>
</td>
</tr>
<tr>
<td class="navbox-abovebelow" colspan="3">
<div>
<ul>

</ul>
</div>
</td>
</tr>
</table>
</div>

-----------------


## Ref

### big data


- [Big Data](https://github.com/onurakpolat/awesome-bigdata)
- [Public Datasets](https://github.com/caesar0301/awesome-public-datasets)

- [Hadoop](https://github.com/youngwookim/awesome-hadoop) - Framework for distributed storage and processing of very large data sets.
- [Data Engineering](https://github.com/igorbarinov/awesome-data-engineering)
- [Streaming](https://github.com/manuzhang/awesome-streaming)
- [Apache Spark](https://github.com/awesome-spark/awesome-spark) - Unified engine for large-scale data processing.

### databases


- [Database](https://github.com/numetriclabz/awesome-db)

- [MySQL](https://github.com/shlomi-noach/awesome-mysql/blob/gh-pages/index.md)
- [SQLAlchemy](https://github.com/dahlia/awesome-sqlalchemy)
- [InfluxDB](https://github.com/mark-rushakoff/awesome-influxdb)
- [Neo4j](https://github.com/neueda/awesome-neo4j)
- [MongoDB](https://github.com/ramnes/awesome-mongodb) - NoSQL database.
- [RethinkDB](https://github.com/d3viant0ne/awesome-rethinkdb)

- [TinkerPop](https://github.com/mohataher/awesome-tinkerpop) - Graph computing framework.
- [PostgreSQL](https://github.com/dhamaniasad/awesome-postgres) - Object-relational database.
- [CouchDB](https://github.com/quangv/awesome-couchdb) - Document-oriented NoSQL database.
- [HBase](https://github.com/rayokota/awesome-hbase) - Distributed, scalable, big data store.


-----------------


### Hadoop ref

<ol class="references">
<li id="cite_note-1"><span class="mw-cite-backlink"><b><a href="#cite_ref-1">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://hadoop.apache.org/releases.html#27+December%2C+2011%3A+release+1.0.0+available">"Hadoop Releases"</a>. <i>apache.org</i>. Apache Software Foundation<span class="reference-accessdate">. Retrieved <span class="nowrap">2014-12-06</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=apache.org&amp;rft.atitle=Hadoop+Releases&amp;rft_id=http%3A%2F%2Fhadoop.apache.org%2Freleases.html%2327%2BDecember%252C%2B2011%253A%2Brelease%2B1.0.0%2Bavailable&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Hadoop" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-homepage-2"><span class="mw-cite-backlink">^ <a href="#cite_ref-homepage_2-0"><sup><i><b>a</b></i></sup></a> <a href="#cite_ref-homepage_2-1"><sup><i><b>b</b></i></sup></a></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://hadoop.apache.org">"Welcome to Apache Hadoop!"</a>. <i>hadoop.apache.org</i><span class="reference-accessdate">. Retrieved <span class="nowrap">2016-08-25</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=hadoop.apache.org&amp;rft.atitle=Welcome+to+Apache+Hadoop%21&amp;rft_id=http%3A%2F%2Fhadoop.apache.org&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Hadoop" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-3"><span class="mw-cite-backlink"><b><a href="#cite_ref-3">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://www-01.ibm.com/software/data/infosphere/hadoop/hdfs/">"What is the Hadoop Distributed File System (HDFS)?"</a>. <i>ibm.com</i>. <a href="/wiki/IBM" title="IBM">IBM</a><span class="reference-accessdate">. Retrieved <span class="nowrap">2014-10-30</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=ibm.com&amp;rft.atitle=What+is+the+Hadoop+Distributed+File+System+%28HDFS%29%3F&amp;rft_id=http%3A%2F%2Fwww-01.ibm.com%2Fsoftware%2Fdata%2Finfosphere%2Fhadoop%2Fhdfs%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Hadoop" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-4"><span class="mw-cite-backlink"><b><a href="#cite_ref-4">^</a></b></span> <span class="reference-text"><cite class="citation web">Malak, Michael (2014-09-19). <a rel="nofollow" class="external text" href="http://www.datascienceassn.org/content/data-locality-hpc-vs-hadoop-vs-spark">"Data Locality: HPC vs. Hadoop vs. Spark"</a>. <i>datascienceassn.org</i>. Data Science Association<span class="reference-accessdate">. Retrieved <span class="nowrap">2014-10-30</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=datascienceassn.org&amp;rft.atitle=Data+Locality%3A+HPC+vs.+Hadoop+vs.+Spark&amp;rft.date=2014-09-19&amp;rft.aulast=Malak&amp;rft.aufirst=Michael&amp;rft_id=http%3A%2F%2Fwww.datascienceassn.org%2Fcontent%2Fdata-locality-hpc-vs-hadoop-vs-spark&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Hadoop" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-5"><span class="mw-cite-backlink"><b><a href="#cite_ref-5">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://ieeexplore.ieee.org/document/6877311/">"Characterization and Optimization of Memory-Resident MapReduce on HPC Systems"</a> <span style="font-size:85%;">(pdf)</span>. IEEE. October 2014.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Characterization+and+Optimization+of+Memory-Resident+MapReduce+on+HPC+Systems&amp;rft.pub=IEEE&amp;rft.date=2014-10&amp;rft_id=http%3A%2F%2Fieeexplore.ieee.org%2Fdocument%2F6877311%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Hadoop" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-6"><span class="mw-cite-backlink"><b><a href="#cite_ref-6">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://hadoop.apache.org/docs/r2.5.1/api/org/apache/hadoop/yarn/api/records/Resource.html#newInstance(int,%20int)">"Resource (Apache Hadoop Main 2.5.1 API)"</a>. <i>apache.org</i>. Apache Software Foundation. 2014-09-12<span class="reference-accessdate">. Retrieved <span class="nowrap">2014-09-30</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=apache.org&amp;rft.atitle=Resource+%28Apache+Hadoop+Main+2.5.1+API%29&amp;rft.date=2014-09-12&amp;rft_id=http%3A%2F%2Fhadoop.apache.org%2Fdocs%2Fr2.5.1%2Fapi%2Forg%2Fapache%2Fhadoop%2Fyarn%2Fapi%2Frecords%2FResource.html%23newInstance%28int%2C%2520int%29&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Hadoop" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-7"><span class="mw-cite-backlink"><b><a href="#cite_ref-7">^</a></b></span> <span class="reference-text"><cite class="citation web">Murthy, Arun (2012-08-15). <a rel="nofollow" class="external text" href="http://hortonworks.com/blog/apache-hadoop-yarn-concepts-and-applications/">"Apache Hadoop YARN – Concepts and Applications"</a>. <i>hortonworks.com</i>. Hortonworks<span class="reference-accessdate">. Retrieved <span class="nowrap">2014-09-30</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=hortonworks.com&amp;rft.atitle=Apache+Hadoop+YARN+%E2%80%93+Concepts+and+Applications&amp;rft.date=2012-08-15&amp;rft.aulast=Murthy&amp;rft.aufirst=Arun&amp;rft_id=http%3A%2F%2Fhortonworks.com%2Fblog%2Fapache-hadoop-yarn-concepts-and-applications%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Hadoop" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-8"><span class="mw-cite-backlink"><b><a href="#cite_ref-8">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="https://finance.yahoo.com/news/continuuity-raises-10-million-series-120500471.html">"Continuuity Raises $10 Million Series A Round to Ignite Big Data Application Development Within the Hadoop Ecosystem"</a>. <i>finance.yahoo.com</i>. <a href="/wiki/Marketwired" title="Marketwired">Marketwired</a>. 2012-11-14<span class="reference-accessdate">. Retrieved <span class="nowrap">2014-10-30</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=finance.yahoo.com&amp;rft.atitle=Continuuity+Raises+%2410+Million+Series+A+Round+to+Ignite+Big+Data+Application+Development+Within+the+Hadoop+Ecosystem&amp;rft.date=2012-11-14&amp;rft_id=https%3A%2F%2Ffinance.yahoo.com%2Fnews%2Fcontinuuity-raises-10-million-series-120500471.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Hadoop" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-9"><span class="mw-cite-backlink"><b><a href="#cite_ref-9">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://hadoop.apache.org/">"Hadoop-related projects at"</a>. Hadoop.apache.org<span class="reference-accessdate">. Retrieved <span class="nowrap">2013-10-17</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Hadoop-related+projects+at&amp;rft.pub=Hadoop.apache.org&amp;rft_id=http%3A%2F%2Fhadoop.apache.org%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Hadoop" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-10"><span class="mw-cite-backlink"><b><a href="#cite_ref-10">^</a></b></span> <span class="reference-text"><cite class="citation book"><a rel="nofollow" class="external text" href="https://books.google.com/books?id=axruBQAAQBAJ&amp;pg=PA300"><i>Data Science and Big Data Analytics: Discovering, Analyzing, Visualizing and Presenting Data</i></a>. John Wiley &amp; Sons. 2014-12-19. p.&#160;300. <a href="/wiki/International_Standard_Book_Number" title="International Standard Book Number">ISBN</a>&#160;<a href="/wiki/Special:BookSources/9781118876220" title="Special:BookSources/9781118876220">9781118876220</a><span class="reference-accessdate">. Retrieved <span class="nowrap">2015-01-29</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=Data+Science+and+Big+Data+Analytics%3A+Discovering%2C+Analyzing%2C+Visualizing+and+Presenting+Data&amp;rft.pages=300&amp;rft.pub=John+Wiley+%26+Sons&amp;rft.date=2014-12-19&amp;rft.isbn=9781118876220&amp;rft_id=https%3A%2F%2Fbooks.google.com%2Fbooks%3Fid%3DaxruBQAAQBAJ%26pg%3DPA300&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Hadoop" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-11"><span class="mw-cite-backlink"><b><a href="#cite_ref-11">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://www.mail-archive.com/nlpatumd@yahoogroups.com/msg00570.html">"[nlpatumd] Adventures with Hadoop and Perl"</a>. Mail-archive.com. 2010-05-02<span class="reference-accessdate">. Retrieved <span class="nowrap">2013-04-05</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=%5Bnlpatumd%26%2393%3B+Adventures+with+Hadoop+and+Perl&amp;rft.pub=Mail-archive.com&amp;rft.date=2010-05-02&amp;rft_id=http%3A%2F%2Fwww.mail-archive.com%2Fnlpatumd%40yahoogroups.com%2Fmsg00570.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Hadoop" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-12"><span class="mw-cite-backlink"><b><a href="#cite_ref-12">^</a></b></span> <span class="reference-text"><cite class="citation news">Cutting, Mike; Cafarella, Ben; Lorica, Doug (2016-03-31). <a rel="nofollow" class="external text" href="https://www.oreilly.com/ideas/the-next-10-years-of-apache-hadoop">"The next 10 years of Apache Hadoop"</a>. <i>O'Reilly Media</i><span class="reference-accessdate">. Retrieved <span class="nowrap">2017-10-12</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=O%27Reilly+Media&amp;rft.atitle=The+next+10+years+of+Apache+Hadoop&amp;rft.date=2016-03-31&amp;rft.aulast=Cutting&amp;rft.aufirst=Mike&amp;rft.au=Cafarella%2C+Ben&amp;rft.au=Lorica%2C+Doug&amp;rft_id=https%3A%2F%2Fwww.oreilly.com%2Fideas%2Fthe-next-10-years-of-apache-hadoop&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Hadoop" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-13"><span class="mw-cite-backlink"><b><a href="#cite_ref-13">^</a></b></span> <span class="reference-text"><cite class="citation web">Ghemawat, Sanjay; Gobioff, Howard; Leung, Shun-Tak. <a rel="nofollow" class="external text" href="http://research.google.com/archive/gfs.html">"The Google File System"</a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=The+Google+File+System&amp;rft.aulast=Ghemawat&amp;rft.aufirst=Sanjay&amp;rft.au=Gobioff%2C+Howard&amp;rft.au=Leung%2C+Shun-Tak&amp;rft_id=http%3A%2F%2Fresearch.google.com%2Farchive%2Fgfs.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Hadoop" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-14"><span class="mw-cite-backlink"><b><a href="#cite_ref-14">^</a></b></span> <span class="reference-text"><cite class="citation web">Dean, Jeffrey; Ghemawat, Sanjay. <a rel="nofollow" class="external text" href="http://research.google.com/archive/mapreduce.html">"MapReduce: Simplified Data Processing on Large Clusters"</a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=MapReduce%3A+Simplified+Data+Processing+on+Large+Clusters&amp;rft.aulast=Dean&amp;rft.aufirst=Jeffrey&amp;rft.au=Ghemawat%2C+Sanjay&amp;rft_id=http%3A%2F%2Fresearch.google.com%2Farchive%2Fmapreduce.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Hadoop" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-15"><span class="mw-cite-backlink"><b><a href="#cite_ref-15">^</a></b></span> <span class="reference-text"><cite class="citation web">Cutting, Doug (28 Jan 2006). <a rel="nofollow" class="external text" href="https://issues.apache.org/jira/browse/INFRA-700">"new mailing lists request: hadoop"</a>. <i>issues.apache.org</i>. <q>The Lucene PMC has voted to split part of Nutch into a new sub-project named Hadoop</q></cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=issues.apache.org&amp;rft.atitle=new+mailing+lists+request%3A+hadoop&amp;rft.date=2006-01-28&amp;rft.aulast=Cutting&amp;rft.aufirst=Doug&amp;rft_id=https%3A%2F%2Fissues.apache.org%2Fjira%2Fbrowse%2FINFRA-700&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Hadoop" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-16"><span class="mw-cite-backlink"><b><a href="#cite_ref-16">^</a></b></span> <span class="reference-text"><cite class="citation news">Vance, Ashlee (2009-03-17). <a rel="nofollow" class="external text" href="https://www.nytimes.com/2009/03/17/technology/business-computing/17cloud.html">"Hadoop, a Free Software Program, Finds Uses Beyond Search"</a>. <i>The New York Times</i>. <a rel="nofollow" class="external text" href="https://web.archive.org/web/20110830130350/http://www.nytimes.com/2009/03/17/technology/business-computing/17cloud.html">Archived</a> from the original on August 30, 2011<span class="reference-accessdate">. Retrieved <span class="nowrap">2010-01-20</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=The+New+York+Times&amp;rft.atitle=Hadoop%2C+a+Free+Software+Program%2C+Finds+Uses+Beyond+Search&amp;rft.date=2009-03-17&amp;rft.aulast=Vance&amp;rft.aufirst=Ashlee&amp;rft_id=https%3A%2F%2Fwww.nytimes.com%2F2009%2F03%2F17%2Ftechnology%2Fbusiness-computing%2F17cloud.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Hadoop" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-17"><span class="mw-cite-backlink"><b><a href="#cite_ref-17">^</a></b></span> <span class="reference-text"><cite class="citation mailinglist"><a href="/wiki/Doug_Cutting" title="Doug Cutting">Cutting, Doug</a> (30 March 2006). <a rel="nofollow" class="external text" href="http://mail-archives.apache.org/mod_mbox/hadoop-common-dev/200603.mbox/%3C442B27A6.8080500@apache.org%3E">"[RESULT] VOTE: add Owen O'Malley as Hadoop committer"</a>. <i>hadoop-common-dev</i> (Mailing list).</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=%5BRESULT%5D+VOTE%3A+add+Owen+O%27Malley+as+Hadoop+committer&amp;rft.date=2006-03-30&amp;rft.aulast=Cutting&amp;rft.aufirst=Doug&amp;rft_id=http%3A%2F%2Fmail-archives.apache.org%2Fmod_mbox%2Fhadoop-common-dev%2F200603.mbox%2F%253C442B27A6.8080500%40apache.org%253E&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Hadoop" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-18"><span class="mw-cite-backlink"><b><a href="#cite_ref-18">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="https://archive.apache.org/dist/hadoop/core/">"archive.apache.org"</a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=archive.apache.org&amp;rft_id=https%3A%2F%2Farchive.apache.org%2Fdist%2Fhadoop%2Fcore%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Hadoop" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-19"><span class="mw-cite-backlink"><b><a href="#cite_ref-19">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="https://hadoop.apache.org/who.html">"Apache Hadoop Project Members"</a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Apache+Hadoop+Project+Members&amp;rft_id=https%3A%2F%2Fhadoop.apache.org%2Fwho.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Hadoop" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-20"><span class="mw-cite-backlink"><b><a href="#cite_ref-20">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://research.google.com/archive/gfs.html">"Google Research Publication: The Google File System"</a><span class="reference-accessdate">. Retrieved <span class="nowrap">2016-03-09</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Google+Research+Publication%3A+The+Google+File+System&amp;rft_id=http%3A%2F%2Fresearch.google.com%2Farchive%2Fgfs.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Hadoop" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-21"><span class="mw-cite-backlink"><b><a href="#cite_ref-21">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://research.google.com/archive/mapreduce.html">"Google Research Publication: MapReduce"</a><span class="reference-accessdate">. Retrieved <span class="nowrap">2016-03-09</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Google+Research+Publication%3A+MapReduce&amp;rft_id=http%3A%2F%2Fresearch.google.com%2Farchive%2Fmapreduce.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Hadoop" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-22"><span class="mw-cite-backlink"><b><a href="#cite_ref-22">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="https://issues.apache.org/jira/browse/INFRA-700">"[INFRA-700] new mailing lists request: hadoop – ASF JIRA"</a><span class="reference-accessdate">. Retrieved <span class="nowrap">2016-03-09</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=%5BINFRA-700%5D+new+mailing+lists+request%3A+hadoop+%E2%80%93+ASF+JIRA&amp;rft_id=https%3A%2F%2Fissues.apache.org%2Fjira%2Fbrowse%2FINFRA-700&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Hadoop" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-23"><span class="mw-cite-backlink"><b><a href="#cite_ref-23">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="https://issues.apache.org/jira/browse/HADOOP-1">"[HADOOP-1] initial import of code from Nutch – ASF JIRA"</a><span class="reference-accessdate">. Retrieved <span class="nowrap">2016-03-09</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=%5BHADOOP-1%5D+initial+import+of+code+from+Nutch+%E2%80%93+ASF+JIRA&amp;rft_id=https%3A%2F%2Fissues.apache.org%2Fjira%2Fbrowse%2FHADOOP-1&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Hadoop" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-tom-white-book-24"><span class="mw-cite-backlink">^ <a href="#cite_ref-tom-white-book_24-0"><sup><i><b>a</b></i></sup></a> <a href="#cite_ref-tom-white-book_24-1"><sup><i><b>b</b></i></sup></a> <a href="#cite_ref-tom-white-book_24-2"><sup><i><b>c</b></i></sup></a> <a href="#cite_ref-tom-white-book_24-3"><sup><i><b>d</b></i></sup></a> <a href="#cite_ref-tom-white-book_24-4"><sup><i><b>e</b></i></sup></a> <a href="#cite_ref-tom-white-book_24-5"><sup><i><b>f</b></i></sup></a> <a href="#cite_ref-tom-white-book_24-6"><sup><i><b>g</b></i></sup></a> <a href="#cite_ref-tom-white-book_24-7"><sup><i><b>h</b></i></sup></a> <a href="#cite_ref-tom-white-book_24-8"><sup><i><b>i</b></i></sup></a> <a href="#cite_ref-tom-white-book_24-9"><sup><i><b>j</b></i></sup></a> <a href="#cite_ref-tom-white-book_24-10"><sup><i><b>k</b></i></sup></a></span> <span class="reference-text"><cite class="citation book">White, Tom (2012). <i>Hadoop: The Definitive Guide</i> (3rd ed.). O'Reilly. <a href="/wiki/International_Standard_Book_Number" title="International Standard Book Number">ISBN</a>&#160;<a href="/wiki/Special:BookSources/9781449328917" title="Special:BookSources/9781449328917">9781449328917</a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=Hadoop%3A+The+Definitive+Guide&amp;rft.edition=3rd&amp;rft.pub=O%27Reilly&amp;rft.date=2012&amp;rft.isbn=9781449328917&amp;rft.aulast=White&amp;rft.aufirst=Tom&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Hadoop" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-25"><span class="mw-cite-backlink"><b><a href="#cite_ref-25">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="https://issues.apache.org/jira/browse/NUTCH-197">"[NUTCH-197] NullPointerException in TaskRunner if application jar does not have "lib" directory – ASF JIRA"</a><span class="reference-accessdate">. Retrieved <span class="nowrap">2016-03-09</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=%5BNUTCH-197%5D+NullPointerException+in+TaskRunner+if+application+jar+does+not+have+%22lib%22+directory+%E2%80%93+ASF+JIRA&amp;rft_id=https%3A%2F%2Fissues.apache.org%2Fjira%2Fbrowse%2FNUTCH-197&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Hadoop" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-datanami.com-26"><span class="mw-cite-backlink">^ <a href="#cite_ref-datanami.com_26-0"><sup><i><b>a</b></i></sup></a> <a href="#cite_ref-datanami.com_26-1"><sup><i><b>b</b></i></sup></a></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://www.datanami.com/2015/04/15/from-spiders-to-elephants-the-history-of-hadoop/">"From Spiders to Elephants: The History of Hadoop"</a><span class="reference-accessdate">. Retrieved <span class="nowrap">2016-03-09</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=From+Spiders+to+Elephants%3A+The+History+of+Hadoop&amp;rft_id=http%3A%2F%2Fwww.datanami.com%2F2015%2F04%2F15%2Ffrom-spiders-to-elephants-the-history-of-hadoop%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Hadoop" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-27"><span class="mw-cite-backlink"><b><a href="#cite_ref-27">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="https://archive.apache.org/dist/hadoop/core/">"Index of /dist/hadoop/core"</a><span class="reference-accessdate">. Retrieved <span class="nowrap">2016-03-09</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Index+of+%2Fdist%2Fhadoop%2Fcore&amp;rft_id=https%3A%2F%2Farchive.apache.org%2Fdist%2Fhadoop%2Fcore%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Hadoop" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-powered-by-hadoop-28"><span class="mw-cite-backlink">^ <a href="#cite_ref-powered-by-hadoop_28-0"><sup><i><b>a</b></i></sup></a> <a href="#cite_ref-powered-by-hadoop_28-1"><sup><i><b>b</b></i></sup></a></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://riccomini.name/posts/hadoop/2009-06-13-hadoop-summit-2009/">"Hadoop Summit 2009"</a><span class="reference-accessdate">. Retrieved <span class="nowrap">2016-03-09</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Hadoop+Summit+2009&amp;rft_id=http%3A%2F%2Friccomini.name%2Fposts%2Fhadoop%2F2009-06-13-hadoop-summit-2009%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Hadoop" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-29"><span class="mw-cite-backlink"><b><a href="#cite_ref-29">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://hadoop.apache.org/releases.html">"Apache Hadoop Releases"</a><span class="reference-accessdate">. Retrieved <span class="nowrap">2016-03-09</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Apache+Hadoop+Releases&amp;rft_id=http%3A%2F%2Fhadoop.apache.org%2Freleases.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Hadoop" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-30"><span class="mw-cite-backlink"><b><a href="#cite_ref-30">^</a></b></span> <span class="reference-text"><cite class="citation book">Gates, Alan (2011). <i>Programming Pig</i>. O'Reilly. p.&#160;10. <a href="/wiki/International_Standard_Book_Number" title="International Standard Book Number">ISBN</a>&#160;<a href="/wiki/Special:BookSources/978-1-4493-0264-1" title="Special:BookSources/978-1-4493-0264-1">978-1-4493-0264-1</a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=Programming+Pig&amp;rft.pages=10&amp;rft.pub=O%27Reilly&amp;rft.date=2011&amp;rft.isbn=978-1-4493-0264-1&amp;rft.aulast=Gates&amp;rft.aufirst=Alan&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Hadoop" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-31"><span class="mw-cite-backlink"><b><a href="#cite_ref-31">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="https://developer.yahoo.com/blogs/hadoop/yahoo-launches-world-largest-hadoop-production-application-398.html">"Yahoo! Launches World's Largest Hadoop Production Application"</a>. <i>hadoopnew – Yahoo</i><span class="reference-accessdate">. Retrieved <span class="nowrap">2016-03-09</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=hadoopnew+%E2%80%93++Yahoo&amp;rft.atitle=Yahoo%21+Launches+World%27s+Largest+Hadoop+Production+Application&amp;rft_id=https%3A%2F%2Fdeveloper.yahoo.com%2Fblogs%2Fhadoop%2Fyahoo-launches-world-largest-hadoop-production-application-398.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Hadoop" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-32"><span class="mw-cite-backlink"><b><a href="#cite_ref-32">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://mail-archives.apache.org/mod_mbox/hadoop-common-user/200802.mbox/%3CDD27C9769EA63D43BE3CF4CCCC12DD977ED49E@SNV-EXVS02.ds.corp.yahoo.com%3E">"RE: Hadoop summit / workshop at Yahoo!"</a><span class="reference-accessdate">. Retrieved <span class="nowrap">2016-03-09</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=RE%3A+Hadoop+summit+%2F+workshop+at+Yahoo%21&amp;rft_id=http%3A%2F%2Fmail-archives.apache.org%2Fmod_mbox%2Fhadoop-common-user%2F200802.mbox%2F%253CDD27C9769EA63D43BE3CF4CCCC12DD977ED49E%40SNV-EXVS02.ds.corp.yahoo.com%253E&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Hadoop" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-33"><span class="mw-cite-backlink"><b><a href="#cite_ref-33">^</a></b></span> <span class="reference-text"><a rel="nofollow" class="external free" href="http://sortbenchmark.org/YahooHadoop.pdf">http://sortbenchmark.org/YahooHadoop.pdf</a></span></li>
<li id="cite_note-34"><span class="mw-cite-backlink"><b><a href="#cite_ref-34">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="https://developer.yahoo.com/blogs/hadoop/apache-hadoop-wins-terabyte-sort-benchmark-408.html">"Apache Hadoop Wins Terabyte Sort Benchmark"</a>. <i>hadoopnew – Yahoo</i><span class="reference-accessdate">. Retrieved <span class="nowrap">2016-03-09</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=hadoopnew+%E2%80%93++Yahoo&amp;rft.atitle=Apache+Hadoop+Wins+Terabyte+Sort+Benchmark&amp;rft_id=https%3A%2F%2Fdeveloper.yahoo.com%2Fblogs%2Fhadoop%2Fapache-hadoop-wins-terabyte-sort-benchmark-408.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Hadoop" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-35"><span class="mw-cite-backlink"><b><a href="#cite_ref-35">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="https://www.crunchbase.com/organization/cloudera#/entity">"Cloudera"</a><span class="reference-accessdate">. Retrieved <span class="nowrap">2016-03-09</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Cloudera&amp;rft_id=https%3A%2F%2Fwww.crunchbase.com%2Forganization%2Fcloudera%23%2Fentity&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Hadoop" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-36"><span class="mw-cite-backlink"><b><a href="#cite_ref-36">^</a></b></span> <span class="reference-text"><a rel="nofollow" class="external free" href="http://sortbenchmark.org/Yahoo2009.pdf">http://sortbenchmark.org/Yahoo2009.pdf</a></span></li>
<li id="cite_note-37"><span class="mw-cite-backlink"><b><a href="#cite_ref-37">^</a></b></span> <span class="reference-text"><a rel="nofollow" class="external free" href="http://www.mollynix.com/images_content/01commdes/hadoopschedulepdf.pdf">http://www.mollynix.com/images_content/01commdes/hadoopschedulepdf.pdf</a></span></li>
<li id="cite_note-hadoop-apache-org-38"><span class="mw-cite-backlink">^ <a href="#cite_ref-hadoop-apache-org_38-0"><sup><i><b>a</b></i></sup></a> <a href="#cite_ref-hadoop-apache-org_38-1"><sup><i><b>b</b></i></sup></a> <a href="#cite_ref-hadoop-apache-org_38-2"><sup><i><b>c</b></i></sup></a> <a href="#cite_ref-hadoop-apache-org_38-3"><sup><i><b>d</b></i></sup></a> <a href="#cite_ref-hadoop-apache-org_38-4"><sup><i><b>e</b></i></sup></a> <a href="#cite_ref-hadoop-apache-org_38-5"><sup><i><b>f</b></i></sup></a> <a href="#cite_ref-hadoop-apache-org_38-6"><sup><i><b>g</b></i></sup></a> <a href="#cite_ref-hadoop-apache-org_38-7"><sup><i><b>h</b></i></sup></a> <a href="#cite_ref-hadoop-apache-org_38-8"><sup><i><b>i</b></i></sup></a> <a href="#cite_ref-hadoop-apache-org_38-9"><sup><i><b>j</b></i></sup></a> <a href="#cite_ref-hadoop-apache-org_38-10"><sup><i><b>k</b></i></sup></a></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://hadoop.apache.org/">"Welcome to Apache™ Hadoop®!"</a><span class="reference-accessdate">. Retrieved <span class="nowrap">2016-03-09</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Welcome+to+Apache%E2%84%A2+Hadoop%C2%AE%21&amp;rft_id=http%3A%2F%2Fhadoop.apache.org%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Hadoop" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-39"><span class="mw-cite-backlink"><b><a href="#cite_ref-39">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="https://www.crunchbase.com/organization/mapr-technologies#/entity">"MapR Technologies"</a><span class="reference-accessdate">. Retrieved <span class="nowrap">2016-03-09</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=MapR+Technologies&amp;rft_id=https%3A%2F%2Fwww.crunchbase.com%2Forganization%2Fmapr-technologies%23%2Fentity&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Hadoop" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-40"><span class="mw-cite-backlink"><b><a href="#cite_ref-40">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="https://thinkbiganalytics.com/yahoo-updates-from-hadoop-summit-2010/">"Yahoo! Updates from Hadoop Summit 2010"</a>. Think Big Analytics<span class="reference-accessdate">. Retrieved <span class="nowrap">April 25,</span> 2016</span>. <q>Baldeschwieler announced that Yahoo has released a beta test of Hadoop Security, which uses Kerberos for authentication and allows colocation of business sensitive data within the same cluster.</q></cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Yahoo%21+Updates+from+Hadoop+Summit+2010&amp;rft.pub=Think+Big+Analytics&amp;rft_id=https%3A%2F%2Fthinkbiganalytics.com%2Fyahoo-updates-from-hadoop-summit-2010%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Hadoop" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-41"><span class="mw-cite-backlink"><b><a href="#cite_ref-41">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://hbase.apache.org/">"Apache HBase – Apache HBase™ Home"</a><span class="reference-accessdate">. Retrieved <span class="nowrap">2016-03-09</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Apache+HBase+%E2%80%93+Apache+HBase%E2%84%A2+Home&amp;rft_id=http%3A%2F%2Fhbase.apache.org%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Hadoop" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-42"><span class="mw-cite-backlink"><b><a href="#cite_ref-42">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="https://developer.yahoo.com/blogs/hadoop/hadoop-summit-2010-agenda-available-455.html">"Hadoop Summit 2010 – Agenda is available!"</a>. <i>hadoopnew – Yahoo</i><span class="reference-accessdate">. Retrieved <span class="nowrap">2016-03-09</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=hadoopnew+%E2%80%93++Yahoo&amp;rft.atitle=Hadoop+Summit+2010+%E2%80%93+Agenda+is+available%21&amp;rft_id=https%3A%2F%2Fdeveloper.yahoo.com%2Fblogs%2Fhadoop%2Fhadoop-summit-2010-agenda-available-455.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Hadoop" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-hadoop-summit-2010-43"><span class="mw-cite-backlink">^ <a href="#cite_ref-hadoop-summit-2010_43-0"><sup><i><b>a</b></i></sup></a> <a href="#cite_ref-hadoop-summit-2010_43-1"><sup><i><b>b</b></i></sup></a></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://perspectives.mvdirona.com/2010/07/hadoop-summit-2010/">"Hadoop Summit 2010"</a><span class="reference-accessdate">. Retrieved <span class="nowrap">2016-03-09</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Hadoop+Summit+2010&amp;rft_id=http%3A%2F%2Fperspectives.mvdirona.com%2F2010%2F07%2Fhadoop-summit-2010%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Hadoop" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-44"><span class="mw-cite-backlink"><b><a href="#cite_ref-44">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://hive.apache.org/">"Apache Hive TM"</a><span class="reference-accessdate">. Retrieved <span class="nowrap">2016-03-09</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Apache+Hive+TM&amp;rft_id=http%3A%2F%2Fhive.apache.org%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Hadoop" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-45"><span class="mw-cite-backlink"><b><a href="#cite_ref-45">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://pig.apache.org/">"Welcome to Apache Pig!"</a><span class="reference-accessdate">. Retrieved <span class="nowrap">2016-03-09</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Welcome+to+Apache+Pig%21&amp;rft_id=http%3A%2F%2Fpig.apache.org%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Hadoop" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-46"><span class="mw-cite-backlink"><b><a href="#cite_ref-46">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://zookeeper.apache.org/">"Apache ZooKeeper – Home"</a><span class="reference-accessdate">. Retrieved <span class="nowrap">2016-03-09</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Apache+ZooKeeper+%E2%80%93+Home&amp;rft_id=http%3A%2F%2Fzookeeper.apache.org%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Hadoop" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-contributions-to-apache-hadoop-47"><span class="mw-cite-backlink">^ <a href="#cite_ref-contributions-to-apache-hadoop_47-0"><sup><i><b>a</b></i></sup></a> <a href="#cite_ref-contributions-to-apache-hadoop_47-1"><sup><i><b>b</b></i></sup></a></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://hortonworks.com/blog/reality-check-contributions-to-apache-hadoop/">"Reality Check: Contributions to Apache Hadoop&#160;— Hortonworks"</a><span class="reference-accessdate">. Retrieved <span class="nowrap">2016-03-09</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Reality+Check%3A+Contributions+to+Apache+Hadoop+%E2%80%94+Hortonworks&amp;rft_id=http%3A%2F%2Fhortonworks.com%2Fblog%2Freality-check-contributions-to-apache-hadoop%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Hadoop" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-48"><span class="mw-cite-backlink"><b><a href="#cite_ref-48">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="https://www.theguardian.com/technology/2011/mar/25/media-guardian-innovation-awards-apache-hadoop">"Apache Hadoop takes top prize at Media Guardian Innovation Awards"</a>. <i>The Guardian</i><span class="reference-accessdate">. Retrieved <span class="nowrap">2016-03-09</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=The+Guardian&amp;rft.atitle=Apache+Hadoop+takes+top+prize+at+Media+Guardian+Innovation+Awards&amp;rft_id=https%3A%2F%2Fwww.theguardian.com%2Ftechnology%2F2011%2Fmar%2F25%2Fmedia-guardian-innovation-awards-apache-hadoop&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Hadoop" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-history-of-hadoop-49"><span class="mw-cite-backlink">^ <a href="#cite_ref-history-of-hadoop_49-0"><sup><i><b>a</b></i></sup></a> <a href="#cite_ref-history-of-hadoop_49-1"><sup><i><b>b</b></i></sup></a></span> <span class="reference-text"><cite class="citation web">Harris, Derrick. <a rel="nofollow" class="external text" href="https://gigaom.com/2013/03/04/the-history-of-hadoop-from-4-nodes-to-the-future-of-data/">"The history of Hadoop: From 4 nodes to the future of data"</a>. Gigaom<span class="reference-accessdate">. Retrieved <span class="nowrap">2016-03-09</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=The+history+of+Hadoop%3A+From+4+nodes+to+the+future+of+data&amp;rft.pub=Gigaom&amp;rft.aulast=Harris&amp;rft.aufirst=Derrick&amp;rft_id=https%3A%2F%2Fgigaom.com%2F2013%2F03%2F04%2Fthe-history-of-hadoop-from-4-nodes-to-the-future-of-data%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Hadoop" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-50"><span class="mw-cite-backlink"><b><a href="#cite_ref-50">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="https://developer.yahoo.com/blogs/hadoop/hadoop-summit-2011-june-29th-santa-clara-convention-5061.html">"Hadoop Summit 2011: June 29th, Santa Clara Convention Center"</a>. <i>hadoopnew&#160;– Yahoo</i><span class="reference-accessdate">. Retrieved <span class="nowrap">2016-03-09</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=hadoopnew+%E2%80%93++Yahoo&amp;rft.atitle=Hadoop+Summit+2011%3A+June+29th%2C+Santa+Clara+Convention+Center&amp;rft_id=https%3A%2F%2Fdeveloper.yahoo.com%2Fblogs%2Fhadoop%2Fhadoop-summit-2011-june-29th-santa-clara-convention-5061.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Hadoop" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-51"><span class="mw-cite-backlink"><b><a href="#cite_ref-51">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://hortonworks.com/press-releases/fifth-annual-hadoop-summit-2012-kicks-off-with-record-attendance/">"Fifth Annual Hadoop Summit 2012 Kicks Off with Record Attendance – Hortonworks"</a><span class="reference-accessdate">. Retrieved <span class="nowrap">2016-03-09</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Fifth+Annual+Hadoop+Summit+2012+Kicks+Off+with+Record+Attendance+%E2%80%93+Hortonworks&amp;rft_id=http%3A%2F%2Fhortonworks.com%2Fpress-releases%2Ffifth-annual-hadoop-summit-2012-kicks-off-with-record-attendance%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Hadoop" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-52"><span class="mw-cite-backlink"><b><a href="#cite_ref-52">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://hortonworks.com/blog/hadoop-summit-2013-amsterdam-its-a-wrap/">"Hadoop Summit 2013 Amsterdam – It's A Wrap! – Hortonworks"</a><span class="reference-accessdate">. Retrieved <span class="nowrap">2016-03-09</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Hadoop+Summit+2013+Amsterdam+%E2%80%93+It%27s+A+Wrap%21+%E2%80%93+Hortonworks&amp;rft_id=http%3A%2F%2Fhortonworks.com%2Fblog%2Fhadoop-summit-2013-amsterdam-its-a-wrap%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Hadoop" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-53"><span class="mw-cite-backlink"><b><a href="#cite_ref-53">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="https://developer.yahoo.com/blogs/ydn/hadoop-yahoo-more-ever-54421.html">"Hadoop at Yahoo!: More Than Ever Before"</a><span class="reference-accessdate">. Retrieved <span class="nowrap">2016-03-09</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Hadoop+at+Yahoo%21%3A+More+Than+Ever+Before&amp;rft_id=https%3A%2F%2Fdeveloper.yahoo.com%2Fblogs%2Fydn%2Fhadoop-yahoo-more-ever-54421.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Hadoop" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-54"><span class="mw-cite-backlink"><b><a href="#cite_ref-54">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://www.businesswire.com/news/home/20130610006449/en/Hadoop-Summit-North-America-2013-Draws-Record">"Hadoop Summit North America 2013 Draws Record Ecosystem Support"</a>. <i>Business Wire</i><span class="reference-accessdate">. Retrieved <span class="nowrap">2016-03-09</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=Business+Wire&amp;rft.atitle=Hadoop+Summit+North+America+2013+Draws+Record+Ecosystem+Support&amp;rft_id=http%3A%2F%2Fwww.businesswire.com%2Fnews%2Fhome%2F20130610006449%2Fen%2FHadoop-Summit-North-America-2013-Draws-Record&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Hadoop" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-55"><span class="mw-cite-backlink"><b><a href="#cite_ref-55">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="https://blogs.apache.org/foundation/entry/the_apache_software_foundation_announces50">"The Apache Software Foundation Announces Apache™ Spark™ as a Top-Level Project&#160;: The Apache Software Foundation Blog"</a><span class="reference-accessdate">. Retrieved <span class="nowrap">2016-03-09</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=The+Apache+Software+Foundation+Announces+Apache%E2%84%A2+Spark%E2%84%A2+as+a+Top-Level+Project+%3A+The+Apache+Software+Foundation+Blog&amp;rft_id=https%3A%2F%2Fblogs.apache.org%2Ffoundation%2Fentry%2Fthe_apache_software_foundation_announces50&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Hadoop" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-56"><span class="mw-cite-backlink"><b><a href="#cite_ref-56">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="https://blogs.saphana.com/2014/04/14/loved-hadoop-summit-europe-2014-hope-you-did-too/">"Loved Hadoop Summit Europe 2014 – Hope you did too! – SAP HANA"</a><span class="reference-accessdate">. Retrieved <span class="nowrap">2016-03-09</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Loved+Hadoop+Summit+Europe+2014+%E2%80%93+Hope+you+did+too%21+%E2%80%93+SAP+HANA&amp;rft_id=https%3A%2F%2Fblogs.saphana.com%2F2014%2F04%2F14%2Floved-hadoop-summit-europe-2014-hope-you-did-too%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Hadoop" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-57"><span class="mw-cite-backlink"><b><a href="#cite_ref-57">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://www.pentaho.com/blog/2014/06/06/hadoop-summit-2014-big-data-keeps-getting-bigger">"Hadoop Summit 2014 – Big Data Keeps Getting Bigger"</a>. Pentaho<span class="reference-accessdate">. Retrieved <span class="nowrap">2016-03-09</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Hadoop+Summit+2014+%E2%80%93+Big+Data+Keeps+Getting+Bigger&amp;rft.pub=Pentaho&amp;rft_id=http%3A%2F%2Fwww.pentaho.com%2Fblog%2F2014%2F06%2F06%2Fhadoop-summit-2014-big-data-keeps-getting-bigger&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Hadoop" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-58"><span class="mw-cite-backlink"><b><a href="#cite_ref-58">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://lanyrd.com/2015/hadoopsummit/">"Hadoop Summit Europe 2015, 15th–16th April 2015"</a>. Lanyrd<span class="reference-accessdate">. Retrieved <span class="nowrap">2016-03-09</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Hadoop+Summit+Europe+2015%2C+15th%E2%80%9316th+April+2015&amp;rft.pub=Lanyrd&amp;rft_id=http%3A%2F%2Flanyrd.com%2F2015%2Fhadoopsummit%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Hadoop" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-59"><span class="mw-cite-backlink"><b><a href="#cite_ref-59">^</a></b></span> <span class="reference-text"><cite class="citation web">Chouraria, Harsh (21 October 2012). <a rel="nofollow" class="external text" href="http://blog.cloudera.com/blog/2012/10/mr2-and-yarn-briefly-explained/">"MR2 and YARN Briefly Explained"</a>. <i>cloudera.com</i>. <a href="/wiki/Cloudera" title="Cloudera">Cloudera</a><span class="reference-accessdate">. Retrieved <span class="nowrap">23 October</span> 2013</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=cloudera.com&amp;rft.atitle=MR2+and+YARN+Briefly+Explained&amp;rft.date=2012-10-21&amp;rft.aulast=Chouraria&amp;rft.aufirst=Harsh&amp;rft_id=http%3A%2F%2Fblog.cloudera.com%2Fblog%2F2012%2F10%2Fmr2-and-yarn-briefly-explained%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Hadoop" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-60"><span class="mw-cite-backlink"><b><a href="#cite_ref-60">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://hadoop.apache.org/docs/stable/hadoop-project-dist/hadoop-hdfs/HdfsUserGuide.html">"HDFS User Guide"</a>. Hadoop.apache.org<span class="reference-accessdate">. Retrieved <span class="nowrap">2014-09-04</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=HDFS+User+Guide&amp;rft.pub=Hadoop.apache.org&amp;rft_id=http%3A%2F%2Fhadoop.apache.org%2Fdocs%2Fstable%2Fhadoop-project-dist%2Fhadoop-hdfs%2FHdfsUserGuide.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Hadoop" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-michael-noll.com_2-61"><span class="mw-cite-backlink"><b><a href="#cite_ref-michael-noll.com_2_61-0">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://www.michael-noll.com/tutorials/running-hadoop-on-ubuntu-linux-multi-node-cluster/">"Running Hadoop on Ubuntu Linux System(Multi-Node Cluster)"</a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Running+Hadoop+on+Ubuntu+Linux+System%28Multi-Node+Cluster%29&amp;rft_id=http%3A%2F%2Fwww.michael-noll.com%2Ftutorials%2Frunning-hadoop-on-ubuntu-linux-multi-node-cluster%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Hadoop" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-michael-noll.com_1-62"><span class="mw-cite-backlink"><b><a href="#cite_ref-michael-noll.com_1_62-0">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://www.michael-noll.com/tutorials/running-hadoop-on-ubuntu-linux-single-node-cluster/#prerequisites">"Running Hadoop on Ubuntu Linux (Single-Node Cluster)"</a><span class="reference-accessdate">. Retrieved <span class="nowrap">6 June</span> 2013</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Running+Hadoop+on+Ubuntu+Linux+%28Single-Node+Cluster%29&amp;rft_id=http%3A%2F%2Fwww.michael-noll.com%2Ftutorials%2Frunning-hadoop-on-ubuntu-linux-single-node-cluster%2F%23prerequisites&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Hadoop" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-63"><span class="mw-cite-backlink"><b><a href="#cite_ref-63">^</a></b></span> <span class="reference-text"><cite class="citation web">Evans, Chris (Oct 2013). <a rel="nofollow" class="external text" href="http://www.computerweekly.com/feature/Big-data-storage-Hadoop-storage-basics">"Big data storage: Hadoop storage basics"</a>. <i>computerweekly.com</i>. <a href="/wiki/Computer_Weekly" title="Computer Weekly">Computer Weekly</a><span class="reference-accessdate">. Retrieved <span class="nowrap">21 June</span> 2016</span>. <q>HDFS is not a file system in the traditional sense and isn't usually directly mounted for a user to view</q></cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=computerweekly.com&amp;rft.atitle=Big+data+storage%3A+Hadoop+storage+basics&amp;rft.date=2013-10&amp;rft.aulast=Evans&amp;rft.aufirst=Chris&amp;rft_id=http%3A%2F%2Fwww.computerweekly.com%2Ffeature%2FBig-data-storage-Hadoop-storage-basics&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Hadoop" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-64"><span class="mw-cite-backlink"><b><a href="#cite_ref-64">^</a></b></span> <span class="reference-text"><cite class="citation web">deRoos, Dirk. <a rel="nofollow" class="external text" href="http://www.dummies.com/how-to/content/managing-files-with-the-hadoop-file-system-command.html">"Managing Files with the Hadoop File System Commands"</a>. <i>dummies.com</i>. <a href="/wiki/For_Dummies" title="For Dummies">For Dummies</a><span class="reference-accessdate">. Retrieved <span class="nowrap">21 June</span> 2016</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=dummies.com&amp;rft.atitle=Managing+Files+with+the+Hadoop+File+System+Commands&amp;rft.aulast=deRoos&amp;rft.aufirst=Dirk&amp;rft_id=http%3A%2F%2Fwww.dummies.com%2Fhow-to%2Fcontent%2Fmanaging-files-with-the-hadoop-file-system-command.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Hadoop" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-65"><span class="mw-cite-backlink"><b><a href="#cite_ref-65">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://hadoop.apache.org/docs/current/hadoop-project-dist/hadoop-hdfs/HdfsDesign.html#Large_Data_Sets">"HDFS Architecture"</a><span class="reference-accessdate">. Retrieved <span class="nowrap">1 September</span> 2013</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=HDFS+Architecture&amp;rft_id=http%3A%2F%2Fhadoop.apache.org%2Fdocs%2Fcurrent%2Fhadoop-project-dist%2Fhadoop-hdfs%2FHdfsDesign.html%23Large_Data_Sets&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Hadoop" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-openlibrary1-66"><span class="mw-cite-backlink">^ <a href="#cite_ref-openlibrary1_66-0"><sup><i><b>a</b></i></sup></a> <a href="#cite_ref-openlibrary1_66-1"><sup><i><b>b</b></i></sup></a></span> <span class="reference-text"><cite class="citation journal">Pessach, Yaniv (2013). <a rel="nofollow" class="external text" href="http://openlibrary.org/books/OL25423189M/Distributed_Storage_Concepts_Algorithms_and_Implementations">"Distributed Storage"</a> (Distributed Storage: Concepts, Algorithms, and Implementations ed.). Amazon.com</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.atitle=Distributed+Storage&amp;rft.date=2013&amp;rft.aulast=Pessach&amp;rft.aufirst=Yaniv&amp;rft_id=http%3A%2F%2Fopenlibrary.org%2Fbooks%2FOL25423189M%2FDistributed_Storage_Concepts_Algorithms_and_Implementations&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Hadoop" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-failover-67"><span class="mw-cite-backlink"><b><a href="#cite_ref-failover_67-0">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="https://hadoop.apache.org/releases.html#23+May%2C+2012%3A+Release+2.0.0-alpha+available">"Version 2.0 provides for manual failover and they are working on automatic failover:"</a>. Hadoop.apache.org<span class="reference-accessdate">. Retrieved <span class="nowrap">30 July</span> 2013</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Version+2.0+provides+for+manual+failover+and+they+are+working+on+automatic+failover%3A&amp;rft.pub=Hadoop.apache.org&amp;rft_id=https%3A%2F%2Fhadoop.apache.org%2Freleases.html%2323%2BMay%252C%2B2012%253A%2BRelease%2B2.0.0-alpha%2Bavailable&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Hadoop" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-68"><span class="mw-cite-backlink"><b><a href="#cite_ref-68">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://www.eng.auburn.edu/~xqin/pubs/hcw10.pdf">"Improving MapReduce performance through data placement in heterogeneous Hadoop Clusters"</a> <span style="font-size:85%;">(PDF)</span>. Eng.auburn.ed. April 2010.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Improving+MapReduce+performance+through+data+placement+in+heterogeneous+Hadoop+Clusters&amp;rft.pub=Eng.auburn.ed&amp;rft.date=2010-04&amp;rft_id=http%3A%2F%2Fwww.eng.auburn.edu%2F~xqin%2Fpubs%2Fhcw10.pdf&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Hadoop" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-69"><span class="mw-cite-backlink"><b><a href="#cite_ref-69">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="https://wiki.apache.org/hadoop/MountableHDFS">"Mounting HDFS"</a><span class="reference-accessdate">. Retrieved <span class="nowrap">2016-08-05</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Mounting+HDFS&amp;rft_id=https%3A%2F%2Fwiki.apache.org%2Fhadoop%2FMountableHDFS&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Hadoop" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-70"><span class="mw-cite-backlink"><b><a href="#cite_ref-70">^</a></b></span> <span class="reference-text"><cite class="citation web">Shafer, Jeffrey; Rixner, Scott; Cox, Alan. <a rel="nofollow" class="external text" href="http://www.jeffshafer.com/publications/papers/shafer_ispass10.pdf">"The Hadoop Distributed Filesystem: Balancing Portability and Performance"</a> <span style="font-size:85%;">(PDF)</span>. Rice University<span class="reference-accessdate">. Retrieved <span class="nowrap">2016-09-19</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=The+Hadoop+Distributed+Filesystem%3A+Balancing+Portability+and+Performance&amp;rft.pub=Rice+University&amp;rft.aulast=Shafer&amp;rft.aufirst=Jeffrey&amp;rft.au=Rixner%2C+Scott&amp;rft.au=Cox%2C+Alan&amp;rft_id=http%3A%2F%2Fwww.jeffshafer.com%2Fpublications%2Fpapers%2Fshafer_ispass10.pdf&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Hadoop" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-71"><span class="mw-cite-backlink"><b><a href="#cite_ref-71">^</a></b></span> <span class="reference-text"><cite class="citation web">Mouzakitis, Evan. <a rel="nofollow" class="external text" href="https://www.datadoghq.com/blog/monitor-hadoop-metrics/#toc-hdfs-metrics2">"How to Collect Hadoop Performance Metrics"</a><span class="reference-accessdate">. Retrieved <span class="nowrap">2016-10-24</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=How+to+Collect+Hadoop+Performance+Metrics&amp;rft.aulast=Mouzakitis&amp;rft.aufirst=Evan&amp;rft_id=https%3A%2F%2Fwww.datadoghq.com%2Fblog%2Fmonitor-hadoop-metrics%2F%23toc-hdfs-metrics2&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Hadoop" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-72"><span class="mw-cite-backlink"><b><a href="#cite_ref-72">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://hadoop.apache.org/docs/current/hadoop-project-dist/hadoop-hdfs/HdfsUserGuide.html#Rack_Awareness">"HDFS Users Guide&#160;– Rack Awareness"</a>. Hadoop.apache.org<span class="reference-accessdate">. Retrieved <span class="nowrap">2013-10-17</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=HDFS+Users+Guide+%E2%80%93+Rack+Awareness&amp;rft.pub=Hadoop.apache.org&amp;rft_id=http%3A%2F%2Fhadoop.apache.org%2Fdocs%2Fcurrent%2Fhadoop-project-dist%2Fhadoop-hdfs%2FHdfsUserGuide.html%23Rack_Awareness&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Hadoop" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-73"><span class="mw-cite-backlink"><b><a href="#cite_ref-73">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://www.usenix.org/events/hotcloud09/tech/full_papers/ananthanarayanan.pdf">"Cloud analytics: Do we really need to reinvent the storage stack?"</a> <span style="font-size:85%;">(PDF)</span>. IBM. June 2009.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Cloud+analytics%3A+Do+we+really+need+to+reinvent+the+storage+stack%3F&amp;rft.pub=IBM&amp;rft.date=2009-06&amp;rft_id=http%3A%2F%2Fwww.usenix.org%2Fevents%2Fhotcloud09%2Ftech%2Ffull_papers%2Fananthanarayanan.pdf&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Hadoop" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-74"><span class="mw-cite-backlink"><b><a href="#cite_ref-74">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="https://issues.apache.org/jira/browse/HADOOP-6330">"HADOOP-6330: Integrating IBM General Parallel File System implementation of Hadoop Filesystem interface"</a>. IBM. 2009-10-23.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=HADOOP-6330%3A+Integrating+IBM+General+Parallel+File+System+implementation+of+Hadoop+Filesystem+interface&amp;rft.pub=IBM&amp;rft.date=2009-10-23&amp;rft_id=https%3A%2F%2Fissues.apache.org%2Fjira%2Fbrowse%2FHADOOP-6330&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Hadoop" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-75"><span class="mw-cite-backlink"><b><a href="#cite_ref-75">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="https://issues.apache.org/jira/browse/HADOOP-6704">"HADOOP-6704: add support for Parascale filesystem"</a>. Parascale. 2010-04-14.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=HADOOP-6704%3A+add+support+for+Parascale+filesystem&amp;rft.pub=Parascale&amp;rft.date=2010-04-14&amp;rft_id=https%3A%2F%2Fissues.apache.org%2Fjira%2Fbrowse%2FHADOOP-6704&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Hadoop" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-76"><span class="mw-cite-backlink"><b><a href="#cite_ref-76">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://resources.appistry.com/news-and-events/press/06072010-appistry-cloudiq-storage-now-generally-available">"HDFS with CloudIQ Storage"</a>. Appistry,Inc. 2010-07-06.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=HDFS+with+CloudIQ+Storage&amp;rft.pub=Appistry%2CInc.&amp;rft.date=2010-07-06&amp;rft_id=http%3A%2F%2Fresources.appistry.com%2Fnews-and-events%2Fpress%2F06072010-appistry-cloudiq-storage-now-generally-available&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Hadoop" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-77"><span class="mw-cite-backlink"><b><a href="#cite_ref-77">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://www.slideshare.net/steve_l/high-availability-hadoop">"High Availability Hadoop"</a>. HP. 2010-06-09.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=High+Availability+Hadoop&amp;rft.pub=HP&amp;rft.date=2010-06-09&amp;rft_id=http%3A%2F%2Fwww.slideshare.net%2Fsteve_l%2Fhigh-availability-hadoop&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Hadoop" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-78"><span class="mw-cite-backlink"><b><a href="#cite_ref-78">^</a></b></span> <span class="reference-text"><a rel="nofollow" class="external text" href="http://hadoop.apache.org/common/docs/current/commands_manual.html#job">job</a> <a rel="nofollow" class="external text" href="https://web.archive.org/web/20110817053520/http://hadoop.apache.org/common/docs/current/commands_manual.html#job">Archived</a> August 17, 2011, at the <a href="/wiki/Wayback_Machine" title="Wayback Machine">Wayback Machine</a>.</span></li>
<li id="cite_note-79"><span class="mw-cite-backlink"><b><a href="#cite_ref-79">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="https://issues.apache.org/jira/browse/HADOOP-3412">"Refactor the scheduler out of the JobTracker"</a>. <i>Hadoop Common</i>. Apache Software Foundation<span class="reference-accessdate">. Retrieved <span class="nowrap">9 June</span> 2012</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=Hadoop+Common&amp;rft.atitle=Refactor+the+scheduler+out+of+the+JobTracker&amp;rft_id=https%3A%2F%2Fissues.apache.org%2Fjira%2Fbrowse%2FHADOOP-3412&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Hadoop" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-80"><span class="mw-cite-backlink"><b><a href="#cite_ref-80">^</a></b></span> <span class="reference-text"><cite class="citation web">Jones, M. Tim (6 December 2011). <a rel="nofollow" class="external text" href="http://www.ibm.com/developerworks/library/os-hadoop-scheduling/">"Scheduling in Hadoop"</a>. <i>ibm.com</i>. <a href="/wiki/IBM" title="IBM">IBM</a><span class="reference-accessdate">. Retrieved <span class="nowrap">20 November</span> 2013</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=ibm.com&amp;rft.atitle=Scheduling+in+Hadoop&amp;rft.date=2011-12-06&amp;rft.aulast=Jones&amp;rft.aufirst=M.+Tim&amp;rft_id=http%3A%2F%2Fwww.ibm.com%2Fdeveloperworks%2Flibrary%2Fos-hadoop-scheduling%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Hadoop" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-81"><span class="mw-cite-backlink"><b><a href="#cite_ref-81">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="https://svn.apache.org/repos/asf/hadoop/common/branches/MAPREDUCE-233/src/contrib/fairscheduler/designdoc/fair_scheduler_design_doc.pdf">"Hadoop Fair Scheduler Design Document"</a> <span style="font-size:85%;">(PDF)</span>.
  </li>
  
  ### spark ref
  
  <ol class="references">
<li id="cite_note-1"><span class="mw-cite-backlink"><b><a href="#cite_ref-1">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="https://spark.apache.org/releases/spark-release-2-0-0.html">"Spark Release 2.0.0"</a>. <q>MLlib in R: SparkR now offers MLlib APIs [..] Python: PySpark now offers many more MLlib algorithms"</q></cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Spark+Release+2.0.0&amp;rft_id=https%3A%2F%2Fspark.apache.org%2Freleases%2Fspark-release-2-0-0.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Spark" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-hc10-2"><span class="mw-cite-backlink">^ <a href="#cite_ref-hc10_2-0"><sup><i><b>a</b></i></sup></a> <a href="#cite_ref-hc10_2-1"><sup><i><b>b</b></i></sup></a> <a href="#cite_ref-hc10_2-2"><sup><i><b>c</b></i></sup></a> <a href="#cite_ref-hc10_2-3"><sup><i><b>d</b></i></sup></a></span> <span class="reference-text"><cite class="citation conference">Zaharia, Matei; Chowdhury, Mosharaf; Franklin, Michael J.; Shenker, Scott; Stoica, Ion. <a rel="nofollow" class="external text" href="https://amplab.cs.berkeley.edu/wp-content/uploads/2011/06/Spark-Cluster-Computing-with-Working-Sets.pdf"><i>Spark: Cluster Computing with Working Sets</i></a> <span style="font-size:85%;">(PDF)</span>. USENIX Workshop on Hot Topics in Cloud Computing (HotCloud).</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=conference&amp;rft.btitle=Spark%3A+Cluster+Computing+with+Working+Sets&amp;rft.aulast=Zaharia&amp;rft.aufirst=Matei&amp;rft.au=Chowdhury%2C+Mosharaf&amp;rft.au=Franklin%2C+Michael+J.&amp;rft.au=Shenker%2C+Scott&amp;rft.au=Stoica%2C+Ion&amp;rft_id=https%3A%2F%2Famplab.cs.berkeley.edu%2Fwp-content%2Fuploads%2F2011%2F06%2FSpark-Cluster-Computing-with-Working-Sets.pdf&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Spark" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-3"><span class="mw-cite-backlink"><b><a href="#cite_ref-3">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="https://spark.apache.org/docs/2.2.0/quick-start.html">"Spark 2.2.0 Quick Start"</a>. <i>apache.org</i>. 2017-07-11<span class="reference-accessdate">. Retrieved <span class="nowrap">2017-10-19</span></span>. <q>we highly recommend you to switch to use Dataset, which has better performance than RDD</q></cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=apache.org&amp;rft.atitle=Spark+2.2.0+Quick+Start&amp;rft.date=2017-07-11&amp;rft_id=https%3A%2F%2Fspark.apache.org%2Fdocs%2F2.2.0%2Fquick-start.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Spark" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-4"><span class="mw-cite-backlink"><b><a href="#cite_ref-4">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="https://spark.apache.org/docs/2.2.0/api/scala/index.html#deprecated-list">"Spark 2.2.0 deprecation list"</a>. <i>apache.org</i>. 2017-07-11<span class="reference-accessdate">. Retrieved <span class="nowrap">2017-10-10</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=apache.org&amp;rft.atitle=Spark+2.2.0+deprecation+list&amp;rft.date=2017-07-11&amp;rft_id=https%3A%2F%2Fspark.apache.org%2Fdocs%2F2.2.0%2Fapi%2Fscala%2Findex.html%23deprecated-list&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Spark" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-5"><span class="mw-cite-backlink"><b><a href="#cite_ref-5">^</a></b></span> <span class="reference-text"><cite class="citation web">Damji, Jules (2016-07-14). <a rel="nofollow" class="external text" href="https://databricks.com/blog/2016/07/14/a-tale-of-three-apache-spark-apis-rdds-dataframes-and-datasets.html">"A Tale of Three Apache Spark APIs: RDDs, DataFrames, and Datasets: When to use them and why"</a>. <i>databricks.com</i><span class="reference-accessdate">. Retrieved <span class="nowrap">2017-10-19</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=databricks.com&amp;rft.atitle=A+Tale+of+Three+Apache+Spark+APIs%3A+RDDs%2C+DataFrames%2C+and+Datasets%3A+When+to+use+them+and+why&amp;rft.date=2016-07-14&amp;rft.aulast=Damji&amp;rft.aufirst=Jules&amp;rft_id=https%3A%2F%2Fdatabricks.com%2Fblog%2F2016%2F07%2F14%2Fa-tale-of-three-apache-spark-apis-rdds-dataframes-and-datasets.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Spark" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-6"><span class="mw-cite-backlink"><b><a href="#cite_ref-6">^</a></b></span> <span class="reference-text"><cite class="citation book">Chambers, Bill (2017-08-10). "11". <a rel="nofollow" class="external text" href="http://techbus.safaribooksonline.com/book/operating-systems-and-server-administration/apache/9781491912201/11dot-basic-rdd-operations/rdd_overview_html"><i>Spark: The Definitive Guide</i></a> ("Rough Cut" pre-print ed.). <a href="/wiki/O%27Reilly_Media" title="O'Reilly Media">O'Reilly Media</a>. <q>virtually all Spark code you run, where DataFrames or Datasets, compiles down to an RDD</q></cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=bookitem&amp;rft.atitle=11&amp;rft.btitle=Spark%3A+The+Definitive+Guide&amp;rft.edition=%22Rough+Cut%22+pre-print&amp;rft.pub=O%27Reilly+Media&amp;rft.date=2017-08-10&amp;rft.aulast=Chambers&amp;rft.aufirst=Bill&amp;rft_id=http%3A%2F%2Ftechbus.safaribooksonline.com%2Fbook%2Foperating-systems-and-server-administration%2Fapache%2F9781491912201%2F11dot-basic-rdd-operations%2Frdd_overview_html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Spark" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-7"><span class="mw-cite-backlink"><b><a href="#cite_ref-7">^</a></b></span> <span class="reference-text"><cite class="citation conference">Zaharia, Matei; Chowdhury, Mosharaf; Das, Tathagata; Dave, Ankur; Ma,, Justin; McCauley, Murphy; J., Michael; Shenker, Scott; Stoica, Ion. <a rel="nofollow" class="external text" href="https://www.usenix.org/system/files/conference/nsdi12/nsdi12-final138.pdf"><i>Resilient Distributed Datasets: A Fault-Tolerant Abstraction for In-Memory Cluster Computing</i></a> <span style="font-size:85%;">(PDF)</span>. USENIX Symp. Networked Systems Design and Implementation.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=conference&amp;rft.btitle=Resilient+Distributed+Datasets%3A+A+Fault-Tolerant+Abstraction+for+In-Memory+Cluster+Computing&amp;rft.aulast=Zaharia&amp;rft.aufirst=Matei&amp;rft.au=Chowdhury%2C+Mosharaf&amp;rft.au=Das%2C+Tathagata&amp;rft.au=Dave%2C+Ankur&amp;rft.au=Ma%2C%2C+Justin&amp;rft.au=McCauley%2C+Murphy&amp;rft.au=J.%2C+Michael&amp;rft.au=Shenker%2C+Scott&amp;rft.au=Stoica%2C+Ion&amp;rft_id=https%3A%2F%2Fwww.usenix.org%2Fsystem%2Ffiles%2Fconference%2Fnsdi12%2Fnsdi12-final138.pdf&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Spark" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-8"><span class="mw-cite-backlink"><b><a href="#cite_ref-8">^</a></b></span> <span class="reference-text"><cite class="citation journal">Xin, Reynold; Rosen, Josh; Zaharia, Matei; Franklin, Michael; Shenker, Scott; Stoica, Ion (June 2013). <a rel="nofollow" class="external text" href="https://amplab.cs.berkeley.edu/wp-content/uploads/2013/02/shark_sigmod2013.pdf">"Shark: SQL and Rich Analytics at Scale"</a> <span style="font-size:85%;">(PDF)</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.atitle=Shark%3A+SQL+and+Rich+Analytics+at+Scale&amp;rft.date=2013-06&amp;rft.aulast=Xin&amp;rft.aufirst=Reynold&amp;rft.au=Rosen%2C+Josh&amp;rft.au=Zaharia%2C+Matei&amp;rft.au=Franklin%2C+Michael&amp;rft.au=Shenker%2C+Scott&amp;rft.au=Stoica%2C+Ion&amp;rft_id=https%3A%2F%2Famplab.cs.berkeley.edu%2Fwp-content%2Fuploads%2F2013%2F02%2Fshark_sigmod2013.pdf&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Spark" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-9"><span class="mw-cite-backlink"><b><a href="#cite_ref-9">^</a></b></span> <span class="reference-text"><cite class="citation web">Harris, Derrick (28 June 2014). <a rel="nofollow" class="external text" href="https://gigaom.com/2014/06/28/4-reasons-why-spark-could-jolt-hadoop-into-hyperdrive/">"4 reasons why Spark could jolt Hadoop into hyperdrive"</a>. <i><a href="/wiki/Gigaom" title="Gigaom">Gigaom</a></i>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=Gigaom&amp;rft.atitle=4+reasons+why+Spark+could+jolt+Hadoop+into+hyperdrive&amp;rft.date=2014-06-28&amp;rft.aulast=Harris&amp;rft.aufirst=Derrick&amp;rft_id=https%3A%2F%2Fgigaom.com%2F2014%2F06%2F28%2F4-reasons-why-spark-could-jolt-hadoop-into-hyperdrive%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Spark" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-10"><span class="mw-cite-backlink"><b><a href="#cite_ref-10">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="https://spark.apache.org/docs/1.2.0/cluster-overview.html#cluster-manager-types">"Cluster Mode Overview - Spark 1.2.0 Documentation - Cluster Manager Types"</a>. <i>apache.org</i>. Apache Foundation. 2014-12-18<span class="reference-accessdate">. Retrieved <span class="nowrap">2015-01-18</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=apache.org&amp;rft.atitle=Cluster+Mode+Overview+-+Spark+1.2.0+Documentation+-+Cluster+Manager+Types&amp;rft.date=2014-12-18&amp;rft_id=https%3A%2F%2Fspark.apache.org%2Fdocs%2F1.2.0%2Fcluster-overview.html%23cluster-manager-types&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Spark" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-11"><span class="mw-cite-backlink"><b><a href="#cite_ref-11">^</a></b></span> <span class="reference-text"><a rel="nofollow" class="external text" href="https://amplab.cs.berkeley.edu/software/">Figure showing Spark in relation to other open-source Software projects including Hadoop</a></span></li>
<li id="cite_note-12"><span class="mw-cite-backlink"><b><a href="#cite_ref-12">^</a></b></span> <span class="reference-text"><a rel="nofollow" class="external text" href="http://doc.mapr.com/display/MapR/Ecosystem+Support+Matrix">MapR ecosystem support matrix</a></span></li>
<li id="cite_note-13"><span class="mw-cite-backlink"><b><a href="#cite_ref-13">^</a></b></span> <span class="reference-text"><cite class="citation mailinglist">Doan, DuyHai (2014-09-10). <a rel="nofollow" class="external text" href="http://mail-archives.apache.org/mod_mbox/cassandra-user/201409.mbox/%3CCABNXB2DE5Apmvn1nNg79+VdPCSZiCsGdt=ZB4s4OF_5JzS60iA@mail.gmail.com%3E">"Re: cassandra + spark / pyspark"</a>. <i>Cassandra User</i> (Mailing list)<span class="reference-accessdate">. Retrieved <span class="nowrap">2014-11-21</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Re%3A+cassandra+%2B+spark+%2F+pyspark&amp;rft.date=2014-09-10&amp;rft.aulast=Doan&amp;rft.aufirst=DuyHai&amp;rft_id=http%3A%2F%2Fmail-archives.apache.org%2Fmod_mbox%2Fcassandra-user%2F201409.mbox%2F%253CCABNXB2DE5Apmvn1nNg79%2BVdPCSZiCsGdt%3DZB4s4OF_5JzS60iA%40mail.gmail.com%253E&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Spark" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-14"><span class="mw-cite-backlink"><b><a href="#cite_ref-14">^</a></b></span> <span class="reference-text"><a rel="nofollow" class="external free" href="https://github.com/dfdx/Spark.jl">https://github.com/dfdx/Spark.jl</a></span></li>
<li id="cite_note-15"><span class="mw-cite-backlink"><b><a href="#cite_ref-15">^</a></b></span> <span class="reference-text"><a rel="nofollow" class="external free" href="https://spark.apache.org/releases/spark-release-1-3-0.html">https://spark.apache.org/releases/spark-release-1-3-0.html</a></span></li>
<li id="cite_note-17"><span class="mw-cite-backlink"><b><a href="#cite_ref-17">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="https://www.pluralsight.com/courses/spark-kafka-cassandra-applying-lambda-architecture">"Applying the Lambda Architecture with Spark, Kafka, and Cassandra | Pluralsight"</a>. <i>www.pluralsight.com</i><span class="reference-accessdate">. Retrieved <span class="nowrap">2016-11-20</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=www.pluralsight.com&amp;rft.atitle=Applying+the+Lambda+Architecture+with+Spark%2C+Kafka%2C+and+Cassandra+%7C+Pluralsight&amp;rft_id=https%3A%2F%2Fwww.pluralsight.com%2Fcourses%2Fspark-kafka-cassandra-applying-lambda-architecture&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Spark" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-18"><span class="mw-cite-backlink"><b><a href="#cite_ref-18">^</a></b></span> <span class="reference-text"><cite class="citation web">Shapira, Gwen (29 August 2014). <a rel="nofollow" class="external text" href="http://blog.cloudera.com/blog/2014/08/building-lambda-architecture-with-spark-streaming/">"Building Lambda Architecture with Spark Streaming"</a>. <i>cloudera.com</i>. Cloudera<span class="reference-accessdate">. Retrieved <span class="nowrap">17 June</span> 2016</span>. <q>re-use the same aggregates we wrote for our batch application on a real-time data stream</q></cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=cloudera.com&amp;rft.atitle=Building+Lambda+Architecture+with+Spark+Streaming&amp;rft.date=2014-08-29&amp;rft.aulast=Shapira&amp;rft.aufirst=Gwen&amp;rft_id=http%3A%2F%2Fblog.cloudera.com%2Fblog%2F2014%2F08%2Fbuilding-lambda-architecture-with-spark-streaming%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Spark" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-19"><span class="mw-cite-backlink"><b><a href="#cite_ref-19">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://ieeexplore.ieee.org/xpl/articleDetails.jsp?arnumber=7530084">"Benchmarking Streaming Computation Engines: Storm, Flink and Spark Streaming"</a> <span style="font-size:85%;">(PDF)</span>. IEEE. May 2016.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Benchmarking+Streaming+Computation+Engines%3A+Storm%2C+Flink+and+Spark+Streaming&amp;rft.pub=IEEE&amp;rft.date=2016-05&amp;rft_id=http%3A%2F%2Fieeexplore.ieee.org%2Fxpl%2FarticleDetails.jsp%3Farnumber%3D7530084&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Spark" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-20"><span class="mw-cite-backlink"><b><a href="#cite_ref-20">^</a></b></span> <span class="reference-text"><cite class="citation web">Kharbanda, Arush (17 March 2015). <a rel="nofollow" class="external text" href="https://www.sigmoid.com/getting-data-into-spark-streaming/">"Getting Data into Spark Streaming"</a>. <i>sigmoid.com</i>. Sigmoid (Sunnyvale, California IT product company)<span class="reference-accessdate">. Retrieved <span class="nowrap">7 July</span> 2016</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=sigmoid.com&amp;rft.atitle=Getting+Data+into+Spark+Streaming&amp;rft.date=2015-03-17&amp;rft.aulast=Kharbanda&amp;rft.aufirst=Arush&amp;rft_id=https%3A%2F%2Fwww.sigmoid.com%2Fgetting-data-into-spark-streaming%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Spark" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-21"><span class="mw-cite-backlink"><b><a href="#cite_ref-21">^</a></b></span> <span class="reference-text"><cite class="citation web">Zaharia, Matei (2016-07-28). <a rel="nofollow" class="external text" href="https://databricks.com/blog/2016/07/28/structured-streaming-in-apache-spark.html">"Structured Streaming In Apache Spark: A new high-level API for streaming"</a>. <i>databricks.com</i><span class="reference-accessdate">. Retrieved <span class="nowrap">2017-10-19</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=databricks.com&amp;rft.atitle=Structured+Streaming+In+Apache+Spark%3A+A+new+high-level+API+for+streaming&amp;rft.date=2016-07-28&amp;rft.aulast=Zaharia&amp;rft.aufirst=Matei&amp;rft_id=https%3A%2F%2Fdatabricks.com%2Fblog%2F2016%2F07%2F28%2Fstructured-streaming-in-apache-spark.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Spark" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-22"><span class="mw-cite-backlink"><b><a href="#cite_ref-22">^</a></b></span> <span class="reference-text"><cite class="citation web">Sparks, Evan; Talwalkar, Ameet (2013-08-06). <a rel="nofollow" class="external text" href="http://www.slideshare.net/chaochen5496/mlllib-sparkmeetup8613finalreduced/68">"Spark Meetup: MLbase, Distributed Machine Learning with Spark"</a>. <i>slideshare.net</i>. Spark User Meetup, San Francisco, California<span class="reference-accessdate">. Retrieved <span class="nowrap">10 February</span> 2014</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=slideshare.net&amp;rft.atitle=Spark+Meetup%3A+MLbase%2C+Distributed+Machine+Learning+with+Spark&amp;rft.date=2013-08-06&amp;rft.aulast=Sparks&amp;rft.aufirst=Evan&amp;rft.au=Talwalkar%2C+Ameet&amp;rft_id=http%3A%2F%2Fwww.slideshare.net%2Fchaochen5496%2Fmlllib-sparkmeetup8613finalreduced%2F68&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Spark" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-23"><span class="mw-cite-backlink"><b><a href="#cite_ref-23">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://spark.apache.org/mllib/">"MLlib | Apache Spark"</a>. <i>spark.apache.org</i><span class="reference-accessdate">. Retrieved <span class="nowrap">2016-01-18</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=spark.apache.org&amp;rft.atitle=MLlib+%7C+Apache+Spark&amp;rft_id=http%3A%2F%2Fspark.apache.org%2Fmllib%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Spark" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-24"><span class="mw-cite-backlink"><b><a href="#cite_ref-24">^</a></b></span> <span class="reference-text"><cite class="citation web">Malak, Michael (14 June 2016). <a rel="nofollow" class="external text" href="http://www.slideshare.net/SparkSummit/finding-graph-isomorphisms-in-graphx-and-graphframes/11">"Finding Graph Isomorphisms In GraphX And GraphFrames: Graph Processing vs. Graph Database"</a>. <i>slideshare.net</i>. sparksummit.org<span class="reference-accessdate">. Retrieved <span class="nowrap">11 July</span> 2016</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=slideshare.net&amp;rft.atitle=Finding+Graph+Isomorphisms+In+GraphX+And+GraphFrames%3A+Graph+Processing+vs.+Graph+Database&amp;rft.date=2016-06-14&amp;rft.aulast=Malak&amp;rft.aufirst=Michael&amp;rft_id=http%3A%2F%2Fwww.slideshare.net%2FSparkSummit%2Ffinding-graph-isomorphisms-in-graphx-and-graphframes%2F11&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Spark" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-25"><span class="mw-cite-backlink"><b><a href="#cite_ref-25">^</a></b></span> <span class="reference-text"><cite class="citation book">Malak, Michael (1 July 2016). <a rel="nofollow" class="external text" href="https://books.google.com/books?id=8XcPjwEACAAJ"><i>Spark GraphX in Action</i></a>. Manning. p.&#160;89. <a href="/wiki/International_Standard_Book_Number" title="International Standard Book Number">ISBN</a>&#160;<a href="/wiki/Special:BookSources/9781617292521" title="Special:BookSources/9781617292521">9781617292521</a>. <q>Pregel and its little sibling aggregateMessages() are the cornerstones of graph processing in GraphX. ... algorithms that require more flexibility for the terminating condition have to be implemented using aggregateMessages()</q></cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=Spark+GraphX+in+Action&amp;rft.pages=89&amp;rft.pub=Manning&amp;rft.date=2016-07-01&amp;rft.isbn=9781617292521&amp;rft.aulast=Malak&amp;rft.aufirst=Michael&amp;rft_id=https%3A%2F%2Fbooks.google.com%2Fbooks%3Fid%3D8XcPjwEACAAJ&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Spark" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-26"><span class="mw-cite-backlink"><b><a href="#cite_ref-26">^</a></b></span> <span class="reference-text"><cite class="citation web">Malak, Michael (14 June 2016). <a rel="nofollow" class="external text" href="http://www.slideshare.net/SparkSummit/finding-graph-isomorphisms-in-graphx-and-graphframes/15">"Finding Graph Isomorphisms In GraphX And GraphFrames: Graph Processing vs. Graph Database"</a>. <i>slideshare.net</i>. sparksummit.org<span class="reference-accessdate">. Retrieved <span class="nowrap">11 July</span> 2016</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=slideshare.net&amp;rft.atitle=Finding+Graph+Isomorphisms+In+GraphX+And+GraphFrames%3A+Graph+Processing+vs.+Graph+Database&amp;rft.date=2016-06-14&amp;rft.aulast=Malak&amp;rft.aufirst=Michael&amp;rft_id=http%3A%2F%2Fwww.slideshare.net%2FSparkSummit%2Ffinding-graph-isomorphisms-in-graphx-and-graphframes%2F15&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Spark" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-27"><span class="mw-cite-backlink"><b><a href="#cite_ref-27">^</a></b></span> <span class="reference-text"><cite class="citation book">Malak, Michael (1 July 2016). <a rel="nofollow" class="external text" href="https://books.google.com/books?id=8XcPjwEACAAJ"><i>Spark GraphX in Action</i></a>. Manning. p.&#160;9. <a href="/wiki/International_Standard_Book_Number" title="International Standard Book Number">ISBN</a>&#160;<a href="/wiki/Special:BookSources/9781617292521" title="Special:BookSources/9781617292521">9781617292521</a>. <q>Giraph is limited to slow Hadoop Map/Reduce</q></cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=Spark+GraphX+in+Action&amp;rft.pages=9&amp;rft.pub=Manning&amp;rft.date=2016-07-01&amp;rft.isbn=9781617292521&amp;rft.aulast=Malak&amp;rft.aufirst=Michael&amp;rft_id=https%3A%2F%2Fbooks.google.com%2Fbooks%3Fid%3D8XcPjwEACAAJ&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Spark" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-28"><span class="mw-cite-backlink"><b><a href="#cite_ref-28">^</a></b></span> <span class="reference-text"><cite class="citation journal">Gonzalez, Joseph; Xin, Reynold; Dave, Ankur; Crankshaw, Daniel; Franklin, Michael; Stoica, Ion (Oct 2014). <a rel="nofollow" class="external text" href="https://www.usenix.org/system/files/conference/osdi14/osdi14-paper-gonzalez.pdf">"GraphX: Graph Processing in a Distributed Dataflow Framework"</a> <span style="font-size:85%;">(PDF)</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.atitle=GraphX%3A+Graph+Processing+in+a+Distributed+Dataflow+Framework&amp;rft.date=2014-10&amp;rft.aulast=Gonzalez&amp;rft.aufirst=Joseph&amp;rft.au=Xin%2C+Reynold&amp;rft.au=Dave%2C+Ankur&amp;rft.au=Crankshaw%2C+Daniel&amp;rft.au=Franklin%2C+Michael&amp;rft.au=Stoica%2C+Ion&amp;rft_id=https%3A%2F%2Fwww.usenix.org%2Fsystem%2Ffiles%2Fconference%2Fosdi14%2Fosdi14-paper-gonzalez.pdf&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Spark" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-29"><span class="mw-cite-backlink"><b><a href="#cite_ref-29">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="https://blogs.apache.org/foundation/entry/the_apache_software_foundation_announces50">"The Apache Software Foundation Announces Apache&amp;#8482 Spark&amp;#8482 as a Top-Level Project"</a>. <i>apache.org</i>. Apache Software Foundation. 27 February 2014<span class="reference-accessdate">. Retrieved <span class="nowrap">4 March</span> 2014</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=apache.org&amp;rft.atitle=The+Apache+Software+Foundation+Announces+Apache%26%238482+Spark%26%238482+as+a+Top-Level+Project&amp;rft.date=2014-02-27&amp;rft_id=https%3A%2F%2Fblogs.apache.org%2Ffoundation%2Fentry%2Fthe_apache_software_foundation_announces50&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Spark" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-30"><span class="mw-cite-backlink"><b><a href="#cite_ref-30">^</a></b></span> <span class="reference-text"><a rel="nofollow" class="external text" href="http://databricks.com/blog/2014/11/05/spark-officially-sets-a-new-record-in-large-scale-sorting.html">Spark officially sets a new record in large-scale sorting</a></span></li>
<li id="cite_note-31"><span class="mw-cite-backlink"><b><a href="#cite_ref-31">^</a></b></span> <span class="reference-text"><a rel="nofollow" class="external text" href="https://www.openhub.net/p/apache-spark">Open HUB Spark development activity</a></span></li>
<li id="cite_note-32"><span class="mw-cite-backlink"><b><a href="#cite_ref-32">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="https://blogs.apache.org/foundation/entry/the_apache_software_foundation_announces50">"The Apache Software Foundation Announces Apache&amp;#8482 Spark&amp;#8482 as a Top-Level Project"</a>. <i>apache.org</i>. Apache Software Foundation. 27 February 2014<span class="reference-accessdate">. Retrieved <span class="nowrap">4 March</span> 2014</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=apache.org&amp;rft.atitle=The+Apache+Software+Foundation+Announces+Apache%26%238482+Spark%26%238482+as+a+Top-Level+Project&amp;rft.date=2014-02-27&amp;rft_id=https%3A%2F%2Fblogs.apache.org%2Ffoundation%2Fentry%2Fthe_apache_software_foundation_announces50&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Spark" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-33"><span class="mw-cite-backlink"><b><a href="#cite_ref-33">^</a></b></span> <span class="reference-text"><cite class="citation news"><a rel="nofollow" class="external text" href="https://venturebeat.com/2014/04/15/ny-gets-new-bootcamp-for-data-scientists-its-free-but-harder-to-get-into-than-harvard/">"NY gets new bootcamp for data scientists: It's free, but harder to get into than Harvard"</a>. <i>Venture Beat</i><span class="reference-accessdate">. Retrieved <span class="nowrap">2016-02-21</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Venture+Beat&amp;rft.atitle=NY+gets+new+bootcamp+for+data+scientists%3A+It%E2%80%99s+free%2C+but+harder+to+get+into+than+Harvard&amp;rft_id=https%3A%2F%2Fventurebeat.com%2F2014%2F04%2F15%2Fny-gets-new-bootcamp-for-data-scientists-its-free-but-harder-to-get-into-than-harvard%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Spark" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-34"><span class="mw-cite-backlink"><b><a href="#cite_ref-34">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://spark.apache.org/news/">"Spark News"</a>. <i>apache.org</i><span class="reference-accessdate">. Retrieved <span class="nowrap">2017-03-30</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=apache.org&amp;rft.atitle=Spark+News&amp;rft_id=http%3A%2F%2Fspark.apache.org%2Fnews%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AApache+Spark" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
</ol>
  
  
  
  ### bigdata ref
  
  <ol class="references">
<li id="cite_note-1"><span class="mw-cite-backlink"><b><a href="#cite_ref-1">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://www.martinhilbert.net/WorldInfoCapacity.html">"The World's Technological Capacity to Store, Communicate, and Compute Information"</a>. <i>MartinHilbert.net</i><span class="reference-accessdate">. Retrieved <span class="nowrap">13 April</span> 2016</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=MartinHilbert.net&amp;rft.atitle=The+World%E2%80%99s+Technological+Capacity+to+Store%2C+Communicate%2C+and+Compute+Information&amp;rft_id=http%3A%2F%2Fwww.martinhilbert.net%2FWorldInfoCapacity.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-2"><span class="mw-cite-backlink"><b><a href="#cite_ref-2">^</a></b></span> <span class="reference-text"><cite class="citation journal">boyd, dana; Crawford, Kate (September 21, 2011). "Six Provocations for Big Data". <i>Social Science Research Network: A Decade in Internet Time: Symposium on the Dynamics of the Internet and Society</i>. <a href="/wiki/Digital_object_identifier" title="Digital object identifier">doi</a>:<a rel="nofollow" class="external text" href="//doi.org/10.2139%2Fssrn.1926431">10.2139/ssrn.1926431</a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Social+Science+Research+Network%3A+A+Decade+in+Internet+Time%3A+Symposium+on+the+Dynamics+of+the+Internet+and+Society&amp;rft.atitle=Six+Provocations+for+Big+Data&amp;rft.date=2011-09-21&amp;rft_id=info%3Adoi%2F10.2139%2Fssrn.1926431&amp;rft.aulast=boyd&amp;rft.aufirst=dana&amp;rft.au=Crawford%2C+Kate&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-Economist-3"><span class="mw-cite-backlink">^ <a href="#cite_ref-Economist_3-0"><sup><i><b>a</b></i></sup></a> <a href="#cite_ref-Economist_3-1"><sup><i><b>b</b></i></sup></a> <a href="#cite_ref-Economist_3-2"><sup><i><b>c</b></i></sup></a> <a href="#cite_ref-Economist_3-3"><sup><i><b>d</b></i></sup></a> <a href="#cite_ref-Economist_3-4"><sup><i><b>e</b></i></sup></a> <a href="#cite_ref-Economist_3-5"><sup><i><b>f</b></i></sup></a> <a href="#cite_ref-Economist_3-6"><sup><i><b>g</b></i></sup></a></span> <span class="reference-text"><cite class="citation news"><a rel="nofollow" class="external text" href="http://www.economist.com/node/15557443">"Data, data everywhere"</a>. <i>The Economist</i>. 25 February 2010<span class="reference-accessdate">. Retrieved <span class="nowrap">9 December</span> 2012</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=The+Economist&amp;rft.atitle=Data%2C+data+everywhere&amp;rft.date=2010-02-25&amp;rft_id=http%3A%2F%2Fwww.economist.com%2Fnode%2F15557443&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-4"><span class="mw-cite-backlink"><b><a href="#cite_ref-4">^</a></b></span> <span class="reference-text"><cite class="citation journal"><a rel="nofollow" class="external text" href="http://www.nature.com/nature/journal/v455/n7209/full/455001a.html">"Community cleverness required"</a>. <i>Nature</i>. <b>455</b> (7209): 1. 4 September 2008. <a href="/wiki/Digital_object_identifier" title="Digital object identifier">doi</a>:<a rel="nofollow" class="external text" href="//doi.org/10.1038%2F455001a">10.1038/455001a</a>. <a href="/wiki/PubMed_Identifier" class="mw-redirect" title="PubMed Identifier">PMID</a>&#160;<a rel="nofollow" class="external text" href="//www.ncbi.nlm.nih.gov/pubmed/18769385">18769385</a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Nature&amp;rft.atitle=Community+cleverness+required&amp;rft.volume=455&amp;rft.issue=7209&amp;rft.pages=1&amp;rft.date=2008-09-04&amp;rft_id=info%3Adoi%2F10.1038%2F455001a&amp;rft_id=info%3Apmid%2F18769385&amp;rft_id=http%3A%2F%2Fwww.nature.com%2Fnature%2Fjournal%2Fv455%2Fn7209%2Ffull%2F455001a.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-5"><span class="mw-cite-backlink"><b><a href="#cite_ref-5">^</a></b></span> <span class="reference-text"><cite class="citation journal">Reichman, O.J.; Jones, M.B.; Schildhauer, M.P. (2011). "Challenges and Opportunities of Open Data in Ecology". <i>Science</i>. <b>331</b> (6018): 703–5. <a href="/wiki/Digital_object_identifier" title="Digital object identifier">doi</a>:<a rel="nofollow" class="external text" href="//doi.org/10.1126%2Fscience.1197962">10.1126/science.1197962</a>. <a href="/wiki/PubMed_Identifier" class="mw-redirect" title="PubMed Identifier">PMID</a>&#160;<a rel="nofollow" class="external text" href="//www.ncbi.nlm.nih.gov/pubmed/21311007">21311007</a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Science&amp;rft.atitle=Challenges+and+Opportunities+of+Open+Data+in+Ecology&amp;rft.volume=331&amp;rft.issue=6018&amp;rft.pages=703-5&amp;rft.date=2011&amp;rft_id=info%3Adoi%2F10.1126%2Fscience.1197962&amp;rft_id=info%3Apmid%2F21311007&amp;rft.aulast=Reichman&amp;rft.aufirst=O.J.&amp;rft.au=Jones%2C+M.B.&amp;rft.au=Schildhauer%2C+M.P.&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-6"><span class="mw-cite-backlink"><b><a href="#cite_ref-6">^</a></b></span> <span class="reference-text"><cite class="citation web">Hellerstein, Joe (9 November 2008). <a rel="nofollow" class="external text" href="http://gigaom.com/2008/11/09/mapreduce-leads-the-way-for-parallel-programming/">"Parallel Programming in the Age of Big Data"</a>. <i>Gigaom Blog</i>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=Gigaom+Blog&amp;rft.atitle=Parallel+Programming+in+the+Age+of+Big+Data&amp;rft.date=2008-11-09&amp;rft.au=Hellerstein%2C+Joe&amp;rft_id=http%3A%2F%2Fgigaom.com%2F2008%2F11%2F09%2Fmapreduce-leads-the-way-for-parallel-programming%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-7"><span class="mw-cite-backlink"><b><a href="#cite_ref-7">^</a></b></span> <span class="reference-text"><cite class="citation book">Segaran, Toby; Hammerbacher, Jeff (2009). <a rel="nofollow" class="external text" href="https://books.google.com/books?id=zxNglqU1FKgC"><i>Beautiful Data: The Stories Behind Elegant Data Solutions</i></a>. O'Reilly Media. p.&#160;257. <a href="/wiki/International_Standard_Book_Number" title="International Standard Book Number">ISBN</a>&#160;<a href="/wiki/Special:BookSources/978-0-596-15711-1" title="Special:BookSources/978-0-596-15711-1">978-0-596-15711-1</a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=Beautiful+Data%3A+The+Stories+Behind+Elegant+Data+Solutions&amp;rft.pages=257&amp;rft.pub=O%27Reilly+Media&amp;rft.date=2009&amp;rft.isbn=978-0-596-15711-1&amp;rft.aulast=Segaran&amp;rft.aufirst=Toby&amp;rft.au=Hammerbacher%2C+Jeff&amp;rft_id=https%3A%2F%2Fbooks.google.com%2Fbooks%3Fid%3DzxNglqU1FKgC&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-martinhilbert.net-8"><span class="mw-cite-backlink">^ <a href="#cite_ref-martinhilbert.net_8-0"><sup><i><b>a</b></i></sup></a> <a href="#cite_ref-martinhilbert.net_8-1"><sup><i><b>b</b></i></sup></a></span> <span class="reference-text"><cite id="CITEREFHilbertL.C3.B3pez2011" class="citation journal">Hilbert, Martin; López, Priscila (2011). <a rel="nofollow" class="external text" href="http://martinhilbert.net/WorldInfoCapacity.html">"The World's Technological Capacity to Store, Communicate, and Compute Information"</a>. <i>Science</i>. <b>332</b> (6025): 60–65. <a href="/wiki/Digital_object_identifier" title="Digital object identifier">doi</a>:<a rel="nofollow" class="external text" href="//doi.org/10.1126%2Fscience.1200970">10.1126/science.1200970</a>. <a href="/wiki/PubMed_Identifier" class="mw-redirect" title="PubMed Identifier">PMID</a>&#160;<a rel="nofollow" class="external text" href="//www.ncbi.nlm.nih.gov/pubmed/21310967">21310967</a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Science&amp;rft.atitle=The+World%27s+Technological+Capacity+to+Store%2C+Communicate%2C+and+Compute+Information&amp;rft.volume=332&amp;rft.issue=6025&amp;rft.pages=60-65&amp;rft.date=2011&amp;rft_id=info%3Adoi%2F10.1126%2Fscience.1200970&amp;rft_id=info%3Apmid%2F21310967&amp;rft.aulast=Hilbert&amp;rft.aufirst=Martin&amp;rft.au=L%C3%B3pez%2C+Priscila&amp;rft_id=http%3A%2F%2Fmartinhilbert.net%2FWorldInfoCapacity.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-9"><span class="mw-cite-backlink"><b><a href="#cite_ref-9">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://www.ibm.com/big-data/us/en/">"IBM What is big data? – Bringing big data to the enterprise"</a>. www.ibm.com<span class="reference-accessdate">. Retrieved <span class="nowrap">2013-08-26</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=IBM+What+is+big+data%3F+%E2%80%93+Bringing+big+data+to+the+enterprise&amp;rft.pub=www.ibm.com&amp;rft_id=http%3A%2F%2Fwww.ibm.com%2Fbig-data%2Fus%2Fen%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-10"><span class="mw-cite-backlink"><b><a href="#cite_ref-10">^</a></b></span> <span class="reference-text"><cite class="citation web">Reinsel, David; Gantz, John; Rydning, John (2017-04-13). <a rel="nofollow" class="external text" href="https://www.seagate.com/files/www-content/our-story/trends/files/Seagate-WP-DataAge2025-March-2017.pdf">"Data Age 2025: The Evolution of Data to Life-Critical"</a> <span style="font-size:85%;">(PDF)</span>. <i>seagate.com</i>. Framingham, MA, US: <a href="/wiki/International_Data_Corporation" title="International Data Corporation">International Data Corporation</a><span class="reference-accessdate">. Retrieved <span class="nowrap">2017-11-02</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=seagate.com&amp;rft.atitle=Data+Age+2025%3A+The+Evolution+of+Data+to+Life-Critical&amp;rft.date=2017-04-13&amp;rft.aulast=Reinsel&amp;rft.aufirst=David&amp;rft.au=Gantz%2C+John&amp;rft.au=Rydning%2C+John&amp;rft_id=https%3A%2F%2Fwww.seagate.com%2Ffiles%2Fwww-content%2Four-story%2Ftrends%2Ffiles%2FSeagate-WP-DataAge2025-March-2017.pdf&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-11"><span class="mw-cite-backlink"><b><a href="#cite_ref-11">^</a></b></span> <span class="reference-text">Oracle and FSN, <a rel="nofollow" class="external text" href="http://www.fsn.co.uk/channel_bi_bpm_cpm/mastering_big_data_cfo_strategies_to_transform_insight_into_opportunity#.UO2Ac-TTuys">"Mastering Big Data: CFO Strategies to Transform Insight into Opportunity"</a>, December 2012</span></li>
<li id="cite_note-12"><span class="mw-cite-backlink"><b><a href="#cite_ref-12">^</a></b></span> <span class="reference-text"><cite class="citation web">Jacobs, A. (6 July 2009). <a rel="nofollow" class="external text" href="http://queue.acm.org/detail.cfm?id=1563874">"The Pathologies of Big Data"</a>. <i>ACMQueue</i>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=ACMQueue&amp;rft.atitle=The+Pathologies+of+Big+Data&amp;rft.date=2009-07-06&amp;rft.au=Jacobs%2C+A.&amp;rft_id=http%3A%2F%2Fqueue.acm.org%2Fdetail.cfm%3Fid%3D1563874&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-13"><span class="mw-cite-backlink"><b><a href="#cite_ref-13">^</a></b></span> <span class="reference-text"><cite class="citation journal">Magoulas, Roger; Lorica, Ben (February 2009). <a rel="nofollow" class="external text" href="http://radar.oreilly.com/r2/release2-0-11.html">"Introduction to Big Data"</a>. <i>Release 2.0</i>. Sebastopol CA: O'Reilly Media (11).</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Release+2.0&amp;rft.atitle=Introduction+to+Big+Data&amp;rft.issue=11&amp;rft.date=2009-02&amp;rft.aulast=Magoulas&amp;rft.aufirst=Roger&amp;rft.au=Lorica%2C+Ben&amp;rft_id=http%3A%2F%2Fradar.oreilly.com%2Fr2%2Frelease2-0-11.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-14"><span class="mw-cite-backlink"><b><a href="#cite_ref-14">^</a></b></span> <span class="reference-text"><cite class="citation web">John R. Mashey (25 April 1998). <a rel="nofollow" class="external text" href="http://static.usenix.org/event/usenix99/invited_talks/mashey.pdf">"Big Data ... and the Next Wave of InfraStress"</a> <span style="font-size:85%;">(PDF)</span>. <i>Slides from invited talk</i>. Usenix<span class="reference-accessdate">. Retrieved <span class="nowrap">28 September</span> 2016</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=Slides+from+invited+talk&amp;rft.atitle=Big+Data+...+and+the+Next+Wave+of+InfraStress&amp;rft.date=1998-04-25&amp;rft.au=John+R.+Mashey&amp;rft_id=http%3A%2F%2Fstatic.usenix.org%2Fevent%2Fusenix99%2Finvited_talks%2Fmashey.pdf&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-15"><span class="mw-cite-backlink"><b><a href="#cite_ref-15">^</a></b></span> <span class="reference-text"><cite class="citation web">Steve Lohr (1 February 2013). <a rel="nofollow" class="external text" href="http://bits.blogs.nytimes.com/2013/02/01/the-origins-of-big-data-an-etymological-detective-story/">"The Origins of 'Big Data': An Etymological Detective Story"</a>. <a href="/wiki/New_York_Times" class="mw-redirect" title="New York Times">New York Times</a><span class="reference-accessdate">. Retrieved <span class="nowrap">28 September</span> 2016</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=The+Origins+of+%E2%80%98Big+Data%E2%80%99%3A+An+Etymological+Detective+Story&amp;rft.pub=New+York+Times&amp;rft.date=2013-02-01&amp;rft.au=Steve+Lohr&amp;rft_id=http%3A%2F%2Fbits.blogs.nytimes.com%2F2013%2F02%2F01%2Fthe-origins-of-big-data-an-etymological-detective-story%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-Editorial-16"><span class="mw-cite-backlink">^ <a href="#cite_ref-Editorial_16-0"><sup><i><b>a</b></i></sup></a> <a href="#cite_ref-Editorial_16-1"><sup><i><b>b</b></i></sup></a></span> <span class="reference-text"><cite class="citation journal">Snijders, C.; Matzat, U.; Reips, U.-D. (2012). <a rel="nofollow" class="external text" href="http://www.ijis.net/ijis7_1/ijis7_1_editorial.html">"<span style="padding-left:0.2em;">'</span>Big Data': Big gaps of knowledge in the field of Internet"</a>. <i>International Journal of Internet Science</i>. <b>7</b>: 1–5.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=International+Journal+of+Internet+Science&amp;rft.atitle=%27Big+Data%27%3A+Big+gaps+of+knowledge+in+the+field+of+Internet&amp;rft.volume=7&amp;rft.pages=1-5&amp;rft.date=2012&amp;rft.aulast=Snijders&amp;rft.aufirst=C.&amp;rft.au=Matzat%2C+U.&amp;rft.au=Reips%2C+U.-D.&amp;rft_id=http%3A%2F%2Fwww.ijis.net%2Fijis7_1%2Fijis7_1_editorial.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-Springer_2017-17"><span class="mw-cite-backlink"><b><a href="#cite_ref-Springer_2017_17-0">^</a></b></span> <span class="reference-text"><cite class="citation journal">Dedić, N.; Stanier, C. (2017). "Towards Differentiating Business Intelligence, Big Data, Data Analytics and Knowledge Discovery". <b>285</b>. Berlin&#160;; Heidelberg: Springer International Publishing. <a href="/wiki/International_Standard_Serial_Number" title="International Standard Serial Number">ISSN</a>&#160;<a rel="nofollow" class="external text" href="//www.worldcat.org/issn/1865-1356">1865-1356</a>. <a href="/wiki/OCLC" title="OCLC">OCLC</a>&#160;<a rel="nofollow" class="external text" href="//www.worldcat.org/oclc/909580101">909580101</a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.atitle=Towards+Differentiating+Business+Intelligence%2C+Big+Data%2C+Data+Analytics+and+Knowledge+Discovery&amp;rft.volume=285&amp;rft.date=2017&amp;rft_id=info%3Aoclcnum%2F909580101&amp;rft.issn=1865-1356&amp;rft.aulast=Dedi%C4%87&amp;rft.aufirst=N.&amp;rft.au=Stanier%2C+C.&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-Everts-18"><span class="mw-cite-backlink"><b><a href="#cite_ref-Everts_18-0">^</a></b></span> <span class="reference-text"><cite class="citation journal">Everts, Sarah (2016). <a rel="nofollow" class="external text" href="https://www.chemheritage.org/distillations/magazine/information-overload">"Information Overload"</a>. <i>Distillations</i>. <b>2</b> (2): 26–33<span class="reference-accessdate">. Retrieved <span class="nowrap">17 February</span> 2017</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Distillations&amp;rft.atitle=Information+Overload&amp;rft.volume=2&amp;rft.issue=2&amp;rft.pages=26-33&amp;rft.date=2016&amp;rft.aulast=Everts&amp;rft.aufirst=Sarah&amp;rft_id=https%3A%2F%2Fwww.chemheritage.org%2Fdistillations%2Fmagazine%2Finformation-overload&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-19"><span class="mw-cite-backlink"><b><a href="#cite_ref-19">^</a></b></span> <span class="reference-text"><cite class="citation journal">Ibrahim; Targio Hashem, Abaker; Yaqoob, Ibrar; Badrul Anuar, Nor; Mokhtar, Salimah; Gani, Abdullah; Ullah Khan, Samee (2015). "big data" on cloud computing: Review and open research issues". <i>Information Systems</i>. <b>47</b>: 98–115. <a href="/wiki/Digital_object_identifier" title="Digital object identifier">doi</a>:<a rel="nofollow" class="external text" href="//doi.org/10.1016%2Fj.is.2014.07.006">10.1016/j.is.2014.07.006</a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Information+Systems&amp;rft.atitle=big+data%22+on+cloud+computing%3A+Review+and+open+research+issues&amp;rft.volume=47&amp;rft.pages=98-115&amp;rft.date=2015&amp;rft_id=info%3Adoi%2F10.1016%2Fj.is.2014.07.006&amp;rft.au=Ibrahim&amp;rft.au=Targio+Hashem%2C+Abaker&amp;rft.au=Yaqoob%2C+Ibrar&amp;rft.au=Badrul+Anuar%2C+Nor&amp;rft.au=Mokhtar%2C+Salimah&amp;rft.au=Gani%2C+Abdullah&amp;rft.au=Ullah+Khan%2C+Samee&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-20"><span class="mw-cite-backlink"><b><a href="#cite_ref-20">^</a></b></span> <span class="reference-text"><cite class="citation web">Laney, Douglas. <a rel="nofollow" class="external text" href="http://blogs.gartner.com/doug-laney/files/2012/01/ad949-3D-Data-Management-Controlling-Data-Volume-Velocity-and-Variety.pdf">"3D Data Management: Controlling Data Volume, Velocity and Variety"</a> <span style="font-size:85%;">(PDF)</span>. Gartner<span class="reference-accessdate">. Retrieved <span class="nowrap">6 February</span> 2001</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=3D+Data+Management%3A+Controlling+Data+Volume%2C+Velocity+and+Variety&amp;rft.pub=Gartner&amp;rft.aulast=Laney&amp;rft.aufirst=Douglas&amp;rft_id=http%3A%2F%2Fblogs.gartner.com%2Fdoug-laney%2Ffiles%2F2012%2F01%2Fad949-3D-Data-Management-Controlling-Data-Volume-Velocity-and-Variety.pdf&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-21"><span class="mw-cite-backlink"><b><a href="#cite_ref-21">^</a></b></span> <span class="reference-text"><cite class="citation web">Beyer, Mark. <a rel="nofollow" class="external text" href="http://www.gartner.com/it/page.jsp?id=1731916">"Gartner Says Solving 'Big Data' Challenge Involves More Than Just Managing Volumes of Data"</a>. Gartner. <a rel="nofollow" class="external text" href="https://web.archive.org/web/20110710043533/http://www.gartner.com/it/page.jsp?id=1731916">Archived</a> from the original on 10 July 2011<span class="reference-accessdate">. Retrieved <span class="nowrap">13 July</span> 2011</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Gartner+Says+Solving+%27Big+Data%27+Challenge+Involves+More+Than+Just+Managing+Volumes+of+Data&amp;rft.pub=Gartner&amp;rft.aulast=Beyer&amp;rft.aufirst=Mark&amp;rft_id=http%3A%2F%2Fwww.gartner.com%2Fit%2Fpage.jsp%3Fid%3D1731916&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-2017-07-18_Gartner-22"><span class="mw-cite-backlink"><b><a href="#cite_ref-2017-07-18_Gartner_22-0">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="https://web.archive.org/web/20170718161704/https://research.gartner.com/definition-whatis-big-data">"Gartner IT Glossary &gt; Big Data – From the Gartner IT Glossary: What is Big Data?"</a>. <a href="/wiki/Gartner" title="Gartner">Gartner</a>. Archived from <a rel="nofollow" class="external text" href="https://research.gartner.com/definition-whatis-big-data">the original</a> on 2017-07-18<span class="reference-accessdate">. Retrieved <span class="nowrap">2017-07-18</span></span>. <q>Gartner IT Glossary &gt; Big Data From the Gartner IT Glossary: What is Big Data? Big Data is high-volume, high-velocity and/or high-variety information assets that demand cost-effective, innovative forms of information processing that enable enhanced insight, decision making, and process automation.</q></cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Gartner+IT+Glossary+%3E+Big+Data+%E2%80%93+From+the+Gartner+IT+Glossary%3A+What+is+Big+Data%3F&amp;rft.pub=Gartner&amp;rft_id=https%3A%2F%2Fresearch.gartner.com%2Fdefinition-whatis-big-data&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-Big_Data_Definition-23"><span class="mw-cite-backlink"><b><a href="#cite_ref-Big_Data_Definition_23-0">^</a></b></span> <span class="reference-text"><cite class="citation journal">De Mauro, Andrea; Greco, Marco; Grimaldi, Michele (2016). <a rel="nofollow" class="external text" href="http://www.emeraldinsight.com/doi/abs/10.1108/LR-06-2015-0061">"A Formal definition of Big Data based on its essential Features"</a>. <i>Library Review</i>. <b>65</b>: 122–135. <a href="/wiki/Digital_object_identifier" title="Digital object identifier">doi</a>:<a rel="nofollow" class="external text" href="//doi.org/10.1108%2FLR-06-2015-0061">10.1108/LR-06-2015-0061</a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Library+Review&amp;rft.atitle=A+Formal+definition+of+Big+Data+based+on+its+essential+Features&amp;rft.volume=65&amp;rft.pages=122-135&amp;rft.date=2016&amp;rft_id=info%3Adoi%2F10.1108%2FLR-06-2015-0061&amp;rft.aulast=De+Mauro&amp;rft.aufirst=Andrea&amp;rft.au=Greco%2C+Marco&amp;rft.au=Grimaldi%2C+Michele&amp;rft_id=http%3A%2F%2Fwww.emeraldinsight.com%2Fdoi%2Fabs%2F10.1108%2FLR-06-2015-0061&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-24"><span class="mw-cite-backlink"><b><a href="#cite_ref-24">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://www.villanovau.com/university-online-programs/what-is-big-data/">"What is Big Data?"</a>. <a href="/wiki/Villanova_University" title="Villanova University">Villanova University</a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=What+is+Big+Data%3F&amp;rft.pub=Villanova+University&amp;rft_id=http%3A%2F%2Fwww.villanovau.com%2Funiversity-online-programs%2Fwhat-is-big-data%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-25"><span class="mw-cite-backlink"><b><a href="#cite_ref-25">^</a></b></span> <span class="reference-text"><cite class="citation web">Grimes, Seth. <a rel="nofollow" class="external text" href="http://www.informationweek.com/big-data/big-data-analytics/big-data-avoid-wanna-v-confusion/d/d-id/1111077?">"Big Data: Avoid 'Wanna V' Confusion"</a>. <a href="/wiki/InformationWeek" title="InformationWeek">InformationWeek</a><span class="reference-accessdate">. Retrieved <span class="nowrap">5 January</span> 2016</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Big+Data%3A+Avoid+%27Wanna+V%27+Confusion&amp;rft.pub=InformationWeek&amp;rft.aulast=Grimes&amp;rft.aufirst=Seth&amp;rft_id=http%3A%2F%2Fwww.informationweek.com%2Fbig-data%2Fbig-data-analytics%2Fbig-data-avoid-wanna-v-confusion%2Fd%2Fd-id%2F1111077%3F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-BD4D-26"><span class="mw-cite-backlink">^ <a href="#cite_ref-BD4D_26-0"><sup><i><b>a</b></i></sup></a> <a href="#cite_ref-BD4D_26-1"><sup><i><b>b</b></i></sup></a></span> <span class="reference-text"><cite class="citation web">Hilbert, Martin. <a rel="nofollow" class="external text" href="http://www.martinhilbert.net/big-data-for-development">"Big Data for Development: A Review of Promises and Challenges. Development Policy Review"</a>. <i>martinhilbert.net</i><span class="reference-accessdate">. Retrieved <span class="nowrap">2015-10-07</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=martinhilbert.net&amp;rft.atitle=Big+Data+for+Development%3A+A+Review+of+Promises+and+Challenges.+Development+Policy+Review.&amp;rft.aulast=Hilbert&amp;rft.aufirst=Martin&amp;rft_id=http%3A%2F%2Fwww.martinhilbert.net%2Fbig-data-for-development&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-WhatIsBigData-27"><span class="mw-cite-backlink">^ <a href="#cite_ref-WhatIsBigData_27-0"><sup><i><b>a</b></i></sup></a> <a href="#cite_ref-WhatIsBigData_27-1"><sup><i><b>b</b></i></sup></a> <a href="#cite_ref-WhatIsBigData_27-2"><sup><i><b>c</b></i></sup></a></span> <span class="reference-text"><cite class="citation audio-visual"><a rel="nofollow" class="external text" href="https://www.youtube.com/watch?v=XRVIh1h47sA&amp;index=51&amp;list=PLtjBSCvWCU3rNm46D3R85efM0hrzjuAIg"><i>DT&amp;SC 7-3: What is Big Data?</i></a>. <a href="/wiki/YouTube" title="YouTube">YouTube</a>. 12 August 2015.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=DT%26SC+7-3%3A+What+is+Big+Data%3F&amp;rft.pub=YouTube&amp;rft.date=2015-08-12&amp;rft_id=https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3DXRVIh1h47sA%26index%3D51%26list%3DPLtjBSCvWCU3rNm46D3R85efM0hrzjuAIg&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-28"><span class="mw-cite-backlink"><b><a href="#cite_ref-28">^</a></b></span> <span class="reference-text">Mayer-Schönberger, V., &amp; Cukier, K. (2013). Big data: a revolution that will transform how we live, work and think. London: John Murray.</span></li>
<li id="cite_note-29"><span class="mw-cite-backlink"><b><a href="#cite_ref-29">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="https://canvas.instructure.com/courses/949415">"Digital Technology &amp; Social Change"</a>. <i>Canvas.instructure.com</i><span class="reference-accessdate">. Retrieved <span class="nowrap">8 October</span> 2017</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=Canvas.instructure.com&amp;rft.atitle=Digital+Technology+%26+Social+Change&amp;rft_id=https%3A%2F%2Fcanvas.instructure.com%2Fcourses%2F949415&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-30"><span class="mw-cite-backlink"><b><a href="#cite_ref-30">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://www.bigdataparis.com/presentation/mercredi/PDelort.pdf?PHPSESSID=tv7k70pcr3egpi2r6fi3qbjtj6#page=4">"avec focalisation sur Big Data &amp; Analytique"</a> <span style="font-size:85%;">(PDF)</span>. <i>Bigdataparis.com</i><span class="reference-accessdate">. Retrieved <span class="nowrap">8 October</span> 2017</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=Bigdataparis.com&amp;rft.atitle=avec+focalisation+sur+Big+Data+%26+Analytique&amp;rft_id=http%3A%2F%2Fwww.bigdataparis.com%2Fpresentation%2Fmercredi%2FPDelort.pdf%3FPHPSESSID%3Dtv7k70pcr3egpi2r6fi3qbjtj6%23page%3D4&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-SAB1-31"><span class="mw-cite-backlink">^ <a href="#cite_ref-SAB1_31-0"><sup><i><b>a</b></i></sup></a> <a href="#cite_ref-SAB1_31-1"><sup><i><b>b</b></i></sup></a></span> <span class="reference-text">Billings S.A. "Nonlinear System Identification: NARMAX Methods in the Time, Frequency, and Spatio-Temporal Domains". Wiley, 2013</span></li>
<li id="cite_note-32"><span class="mw-cite-backlink"><b><a href="#cite_ref-32">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://www.andsi.fr/tag/dsi-big-data/">"le Blog ANDSI &#160;» DSI Big Data"</a>. <i>Andsi.fr</i><span class="reference-accessdate">. Retrieved <span class="nowrap">8 October</span> 2017</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=Andsi.fr&amp;rft.atitle=le+Blog+ANDSI+++%C2%BB+DSI+Big+Data&amp;rft_id=http%3A%2F%2Fwww.andsi.fr%2Ftag%2Fdsi-big-data%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span>}</span></li>
<li id="cite_note-33"><span class="mw-cite-backlink"><b><a href="#cite_ref-33">^</a></b></span> <span class="reference-text"><cite class="citation web">Les Echos (3 April 2013). <a rel="nofollow" class="external text" href="http://lecercle.lesechos.fr/entrepreneur/tendances-innovation/221169222/big-data-low-density-data-faible-densite-information-com">"Les Echos – Big Data car Low-Density Data&#160;? La faible densité en information comme facteur discriminant – Archives"</a>. <i>Lesechos.fr</i><span class="reference-accessdate">. Retrieved <span class="nowrap">8 October</span> 2017</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=Lesechos.fr&amp;rft.atitle=Les+Echos+%E2%80%93+Big+Data+car+Low-Density+Data+%3F+La+faible+densit%C3%A9+en+information+comme+facteur+discriminant+%E2%80%93+Archives&amp;rft.date=2013-04-03&amp;rft.au=Les+Echos&amp;rft_id=http%3A%2F%2Flecercle.lesechos.fr%2Fentrepreneur%2Ftendances-innovation%2F221169222%2Fbig-data-low-density-data-faible-densite-information-com&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span>}</span></li>
<li id="cite_note-34"><span class="mw-cite-backlink"><b><a href="#cite_ref-34">^</a></b></span> <span class="reference-text"><a rel="nofollow" class="external text" href="https://spotlessdata.com/blog/big-datas-fourth-v">Big Data's Fourth V</a></span></li>
<li id="cite_note-35"><span class="mw-cite-backlink"><b><a href="#cite_ref-35">^</a></b></span> <span class="reference-text">Wu, D., Liu. X., Hebert, S., Gentzsch, W., Terpenny, J. (2015). Performance Evaluation of Cloud-Based High Performance Computing for Finite Element Analysis. Proceedings of the ASME 2015 International Design Engineering Technical Conference &amp; Computers and Information in Engineering Conference (IDETC/CIE2015), Boston, Massachusetts, U.S.</span></li>
<li id="cite_note-36"><span class="mw-cite-backlink"><b><a href="#cite_ref-36">^</a></b></span> <span class="reference-text"><cite class="citation journal">Wu, D.; Rosen, D.W.; Wang, L.; Schaefer, D. (2015). "Cloud-Based Design and Manufacturing: A New Paradigm in Digital Manufacturing and Design Innovation". <i>Computer-Aided Design</i>. <b>59</b> (1): 1–14. <a href="/wiki/Digital_object_identifier" title="Digital object identifier">doi</a>:<a rel="nofollow" class="external text" href="//doi.org/10.1016%2Fj.cad.2014.07.006">10.1016/j.cad.2014.07.006</a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Computer-Aided+Design&amp;rft.atitle=Cloud-Based+Design+and+Manufacturing%3A+A+New+Paradigm+in+Digital+Manufacturing+and+Design+Innovation&amp;rft.volume=59&amp;rft.issue=1&amp;rft.pages=1-14&amp;rft.date=2015&amp;rft_id=info%3Adoi%2F10.1016%2Fj.cad.2014.07.006&amp;rft.aulast=Wu&amp;rft.aufirst=D.&amp;rft.au=Rosen%2C+D.W.&amp;rft.au=Wang%2C+L.&amp;rft.au=Schaefer%2C+D.&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-INDIN2014-37"><span class="mw-cite-backlink"><b><a href="#cite_ref-INDIN2014_37-0">^</a></b></span> <span class="reference-text"><cite class="citation journal">Lee, Jay; Bagheri, Behrad; Kao, Hung-An (2014). <a rel="nofollow" class="external text" href="https://www.researchgate.net/profile/Behrad_Bagheri/publication/266375284_Recent_Advances_and_Trends_of_Cyber-Physical_Systems_and_Big_Data_Analytics_in_Industrial_Informatics/links/542dc0100cf27e39fa948a7d?origin=publication_detail">"Recent Advances and Trends of Cyber-Physical Systems and Big Data Analytics in Industrial Informatics"</a>. <i>IEEE Int. Conference on Industrial Informatics (INDIN) 2014</i>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=IEEE+Int.+Conference+on+Industrial+Informatics+%28INDIN%29+2014&amp;rft.atitle=Recent+Advances+and+Trends+of+Cyber-Physical+Systems+and+Big+Data+Analytics+in+Industrial+Informatics&amp;rft.date=2014&amp;rft.aulast=Lee&amp;rft.aufirst=Jay&amp;rft.au=Bagheri%2C+Behrad&amp;rft.au=Kao%2C+Hung-An&amp;rft_id=https%3A%2F%2Fwww.researchgate.net%2Fprofile%2FBehrad_Bagheri%2Fpublication%2F266375284_Recent_Advances_and_Trends_of_Cyber-Physical_Systems_and_Big_Data_Analytics_in_Industrial_Informatics%2Flinks%2F542dc0100cf27e39fa948a7d%3Forigin%3Dpublication_detail&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-MfgLetters-38"><span class="mw-cite-backlink"><b><a href="#cite_ref-MfgLetters_38-0">^</a></b></span> <span class="reference-text"><cite class="citation journal">Lee, Jay; Lapira, Edzel; Bagheri, Behrad; Kao, Hung-an. <a rel="nofollow" class="external text" href="http://www.sciencedirect.com/science/article/pii/S2213846313000114">"Recent advances and trends in predictive manufacturing systems in big data environment"</a>. <i>Manufacturing Letters</i>. <b>1</b> (1): 38–41. <a href="/wiki/Digital_object_identifier" title="Digital object identifier">doi</a>:<a rel="nofollow" class="external text" href="//doi.org/10.1016%2Fj.mfglet.2013.09.005">10.1016/j.mfglet.2013.09.005</a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Manufacturing+Letters&amp;rft.atitle=Recent+advances+and+trends+in+predictive+manufacturing+systems+in+big+data+environment&amp;rft.volume=1&amp;rft.issue=1&amp;rft.pages=38-41&amp;rft_id=info%3Adoi%2F10.1016%2Fj.mfglet.2013.09.005&amp;rft.aulast=Lee&amp;rft.aufirst=Jay&amp;rft.au=Lapira%2C+Edzel&amp;rft.au=Bagheri%2C+Behrad&amp;rft.au=Kao%2C+Hung-an&amp;rft_id=http%3A%2F%2Fwww.sciencedirect.com%2Fscience%2Farticle%2Fpii%2FS2213846313000114&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-39"><span class="mw-cite-backlink"><b><a href="#cite_ref-39">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://www.eweek.com/database/survey-biggest-databases-approach-30-terabytes">"Survey: Biggest Databases Approach 30 Terabytes"</a>. <i>Eweek.com</i><span class="reference-accessdate">. Retrieved <span class="nowrap">8 October</span> 2017</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=Eweek.com&amp;rft.atitle=Survey%3A+Biggest+Databases+Approach+30+Terabytes&amp;rft_id=http%3A%2F%2Fwww.eweek.com%2Fdatabase%2Fsurvey-biggest-databases-approach-30-terabytes&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-40"><span class="mw-cite-backlink"><b><a href="#cite_ref-40">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="https://www.washingtonpost.com/wp-dyn/articles/A50577-2004Jul14.html">"LexisNexis To Buy Seisint For $775 Million"</a>. Washington Post<span class="reference-accessdate">. Retrieved <span class="nowrap">15 July</span> 2004</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=LexisNexis+To+Buy+Seisint+For+%24775+Million&amp;rft.pub=Washington+Post&amp;rft_id=https%3A%2F%2Fwww.washingtonpost.com%2Fwp-dyn%2Farticles%2FA50577-2004Jul14.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-41"><span class="mw-cite-backlink"><b><a href="#cite_ref-41">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="https://www.washingtonpost.com/wp-dyn/content/article/2008/02/21/AR2008022100809.html">"LexisNexis Parent Set to Buy ChoicePoint"</a>. Washington Post<span class="reference-accessdate">. Retrieved <span class="nowrap">22 February</span> 2008</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=LexisNexis+Parent+Set+to+Buy+ChoicePoint&amp;rft.pub=Washington+Post&amp;rft_id=https%3A%2F%2Fwww.washingtonpost.com%2Fwp-dyn%2Fcontent%2Farticle%2F2008%2F02%2F21%2FAR2008022100809.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-42"><span class="mw-cite-backlink"><b><a href="#cite_ref-42">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://www.datanami.com/2012/10/01/quantcast_opens_exabyte_ready_file_system/">"Quantcast Opens Exabyte-Ready File System"</a>. www.datanami.com<span class="reference-accessdate">. Retrieved <span class="nowrap">1 October</span> 2012</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Quantcast+Opens+Exabyte-Ready+File+System&amp;rft.pub=www.datanami.com&amp;rft_id=http%3A%2F%2Fwww.datanami.com%2F2012%2F10%2F01%2Fquantcast_opens_exabyte_ready_file_system%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-43"><span class="mw-cite-backlink"><b><a href="#cite_ref-43">^</a></b></span> <span class="reference-text">Bertolucci, Jeff <a rel="nofollow" class="external text" href="http://www.informationweek.com/big-data/news/software-platforms/hadoop-from-experiment-to-leading-big-d/240157176">"Hadoop: From Experiment To Leading Big Data Platform"</a>, "Information Week", 2013. Retrieved on 14 November 2013.</span></li>
<li id="cite_note-44"><span class="mw-cite-backlink"><b><a href="#cite_ref-44">^</a></b></span> <span class="reference-text">Webster, John. <a rel="nofollow" class="external text" href="http://research.google.com/archive/mapreduce-osdi04.pdf">"MapReduce: Simplified Data Processing on Large Clusters"</a>, "Search Storage", 2004. Retrieved on 25 March 2013.</span></li>
<li id="cite_note-45"><span class="mw-cite-backlink"><b><a href="#cite_ref-45">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://mike2.openmethodology.org/wiki/Big_Data_Solution_Offering">"Big Data Solution Offering"</a>. MIKE2.0<span class="reference-accessdate">. Retrieved <span class="nowrap">8 December</span> 2013</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Big+Data+Solution+Offering&amp;rft.pub=MIKE2.0&amp;rft_id=http%3A%2F%2Fmike2.openmethodology.org%2Fwiki%2FBig_Data_Solution_Offering&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-46"><span class="mw-cite-backlink"><b><a href="#cite_ref-46">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://mike2.openmethodology.org/wiki/Big_Data_Definition">"Big Data Definition"</a>. MIKE2.0<span class="reference-accessdate">. Retrieved <span class="nowrap">9 March</span> 2013</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Big+Data+Definition&amp;rft.pub=MIKE2.0&amp;rft_id=http%3A%2F%2Fmike2.openmethodology.org%2Fwiki%2FBig_Data_Definition&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-47"><span class="mw-cite-backlink"><b><a href="#cite_ref-47">^</a></b></span> <span class="reference-text"><cite class="citation journal">Boja, C; Pocovnicu, A; Bătăgan, L. (2012). "Distributed Parallel Architecture for Big Data". <i>Informatica Economica</i>. <b>16</b> (2): 116–127.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Informatica+Economica&amp;rft.atitle=Distributed+Parallel+Architecture+for+Big+Data&amp;rft.volume=16&amp;rft.issue=2&amp;rft.pages=116-127&amp;rft.date=2012&amp;rft.aulast=Boja&amp;rft.aufirst=C&amp;rft.au=Pocovnicu%2C+A&amp;rft.au=B%C4%83t%C4%83gan%2C+L.&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-48"><span class="mw-cite-backlink"><b><a href="#cite_ref-48">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://www.imscenter.net/cyber-physical-platform">"IMS_CPS — IMS Center"</a>. <i>Imscenter.net</i><span class="reference-accessdate">. Retrieved <span class="nowrap">16 June</span> 2016</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=Imscenter.net&amp;rft.atitle=IMS_CPS+%E2%80%94+IMS+Center&amp;rft_id=http%3A%2F%2Fwww.imscenter.net%2Fcyber-physical-platform&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-49"><span class="mw-cite-backlink"><b><a href="#cite_ref-49">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://www.hcltech.com/sites/default/files/solving_key_businesschallenges_with_big_data_lake_0.pdf">"SOLVING KEY BUSINESS CHALLENGES WITH A BIG DATA LAKE"</a> <span style="font-size:85%;">(PDF)</span>. <i>Hcltech.com</i>. August 2014<span class="reference-accessdate">. Retrieved <span class="nowrap">8 October</span> 2017</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=Hcltech.com&amp;rft.atitle=SOLVING+KEY+BUSINESS+CHALLENGES+WITH+A+BIG+DATA+LAKE&amp;rft.date=2014-08&amp;rft_id=http%3A%2F%2Fwww.hcltech.com%2Fsites%2Fdefault%2Ffiles%2Fsolving_key_businesschallenges_with_big_data_lake_0.pdf&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-50"><span class="mw-cite-backlink"><b><a href="#cite_ref-50">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="https://secplab.ppgia.pucpr.br/files/papers/2015-0.pdf">"Method for testing the fault tolerance of MapReduce frameworks"</a> <span style="font-size:85%;">(PDF)</span>. Computer Networks. 2015.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Method+for+testing+the+fault+tolerance+of+MapReduce+frameworks&amp;rft.pub=Computer+Networks&amp;rft.date=2015&amp;rft_id=https%3A%2F%2Fsecplab.ppgia.pucpr.br%2Ffiles%2Fpapers%2F2015-0.pdf&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-McKinsey-51"><span class="mw-cite-backlink">^ <a href="#cite_ref-McKinsey_51-0"><sup><i><b>a</b></i></sup></a> <a href="#cite_ref-McKinsey_51-1"><sup><i><b>b</b></i></sup></a></span> <span class="reference-text"><cite class="citation journal">Manyika, James; Chui, Michael; Bughin, Jaques; Brown, Brad; Dobbs, Richard; Roxburgh, Charles; Byers, Angela Hung (May 2011). <a rel="nofollow" class="external text" href="http://www.mckinsey.com/Insights/MGI/Research/Technology_and_Innovation/Big_data_The_next_frontier_for_innovation">"Big Data: The next frontier for innovation, competition, and productivity"</a>. McKinsey Global Institute<span class="reference-accessdate">. Retrieved <span class="nowrap">January 16,</span> 2016</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.atitle=Big+Data%3A+The+next+frontier+for+innovation%2C+competition%2C+and+productivity&amp;rft.date=2011-05&amp;rft.aulast=Manyika&amp;rft.aufirst=James&amp;rft.au=Chui%2C+Michael&amp;rft.au=Bughin%2C+Jaques&amp;rft.au=Brown%2C+Brad&amp;rft.au=Dobbs%2C+Richard&amp;rft.au=Roxburgh%2C+Charles&amp;rft.au=Byers%2C+Angela+Hung&amp;rft_id=http%3A%2F%2Fwww.mckinsey.com%2FInsights%2FMGI%2FResearch%2FTechnology_and_Innovation%2FBig_data_The_next_frontier_for_innovation&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-52"><span class="mw-cite-backlink"><b><a href="#cite_ref-52">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://www.cs.cornell.edu/cv/tenwork/finalreport.pdf">"Future Directions in Tensor-Based Computation and Modeling"</a> <span style="font-size:85%;">(PDF)</span>. May 2009.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Future+Directions+in+Tensor-Based+Computation+and+Modeling&amp;rft.date=2009-05&amp;rft_id=http%3A%2F%2Fwww.cs.cornell.edu%2Fcv%2Ftenwork%2Ffinalreport.pdf&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-MSLsurvey-53"><span class="mw-cite-backlink"><b><a href="#cite_ref-MSLsurvey_53-0">^</a></b></span> <span class="reference-text"><cite class="citation journal">Lu, Haiping; Plataniotis, K.N.; Venetsanopoulos, A.N. (2011). <a rel="nofollow" class="external text" href="http://www.dsp.utoronto.ca/~haiping/Publication/SurveyMSL_PR2011.pdf">"A Survey of Multilinear Subspace Learning for Tensor Data"</a> <span style="font-size:85%;">(PDF)</span>. <i>Pattern Recognition</i>. <b>44</b> (7): 1540–1551. <a href="/wiki/Digital_object_identifier" title="Digital object identifier">doi</a>:<a rel="nofollow" class="external text" href="//doi.org/10.1016%2Fj.patcog.2011.01.004">10.1016/j.patcog.2011.01.004</a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Pattern+Recognition&amp;rft.atitle=A+Survey+of+Multilinear+Subspace+Learning+for+Tensor+Data&amp;rft.volume=44&amp;rft.issue=7&amp;rft.pages=1540-1551&amp;rft.date=2011&amp;rft_id=info%3Adoi%2F10.1016%2Fj.patcog.2011.01.004&amp;rft.aulast=Lu&amp;rft.aufirst=Haiping&amp;rft.au=Plataniotis%2C+K.N.&amp;rft.au=Venetsanopoulos%2C+A.N.&amp;rft_id=http%3A%2F%2Fwww.dsp.utoronto.ca%2F~haiping%2FPublication%2FSurveyMSL_PR2011.pdf&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-54"><span class="mw-cite-backlink"><b><a href="#cite_ref-54">^</a></b></span> <span class="reference-text"><cite class="citation web">Pllana, Sabri; Janciak, Ivan; Brezany, Peter; Wöhrer, Alexander. <a rel="nofollow" class="external text" href="http://ieeexplore.ieee.org/xpl/articleDetails.jsp?arnumber=6041580">"A Survey of the State of the Art in Data Mining and Integration Query Languages"</a>. <i>2011 International Conference on Network-Based Information Systems (NBIS 2011)</i>. IEEE Computer Society<span class="reference-accessdate">. Retrieved <span class="nowrap">2 April</span> 2016</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=2011+International+Conference+on+Network-Based+Information+Systems+%28NBIS+2011%29&amp;rft.atitle=A+Survey+of+the+State+of+the+Art+in+Data+Mining+and+Integration+Query+Languages&amp;rft.aulast=Pllana&amp;rft.aufirst=Sabri&amp;rft.au=Janciak%2C+Ivan&amp;rft.au=Brezany%2C+Peter&amp;rft.au=W%C3%B6hrer%2C+Alexander&amp;rft_id=http%3A%2F%2Fieeexplore.ieee.org%2Fxpl%2FarticleDetails.jsp%3Farnumber%3D6041580&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-55"><span class="mw-cite-backlink"><b><a href="#cite_ref-55">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://ieeexplore.ieee.org/document/6877311/">"Characterization and Optimization of Memory-Resident MapReduce on HPC Systems"</a> <span style="font-size:85%;">(PDF)</span>. IEEE. October 2014.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Characterization+and+Optimization+of+Memory-Resident+MapReduce+on+HPC+Systems&amp;rft.pub=IEEE&amp;rft.date=2014-10&amp;rft_id=http%3A%2F%2Fieeexplore.ieee.org%2Fdocument%2F6877311%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-56"><span class="mw-cite-backlink"><b><a href="#cite_ref-56">^</a></b></span> <span class="reference-text"><cite class="citation journal">L’Heureux, A.; Grolinger, K.; Elyamany, H. F.; Capretz, M. A. M. (2017). <a rel="nofollow" class="external text" href="http://ieeexplore.ieee.org/document/7906512/">"Machine Learning With Big Data: Challenges and Approaches"</a>. <i>IEEE Access</i>. <b>5</b>: 7776–7797. <a href="/wiki/Digital_object_identifier" title="Digital object identifier">doi</a>:<a rel="nofollow" class="external text" href="//doi.org/10.1109%2FACCESS.2017.2696365">10.1109/ACCESS.2017.2696365</a>. <a href="/wiki/International_Standard_Serial_Number" title="International Standard Serial Number">ISSN</a>&#160;<a rel="nofollow" class="external text" href="//www.worldcat.org/issn/2169-3536">2169-3536</a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=IEEE+Access&amp;rft.atitle=Machine+Learning+With+Big+Data%3A+Challenges+and+Approaches&amp;rft.volume=5&amp;rft.pages=7776-7797&amp;rft.date=2017&amp;rft_id=info%3Adoi%2F10.1109%2FACCESS.2017.2696365&amp;rft.issn=2169-3536&amp;rft.aulast=L%E2%80%99Heureux&amp;rft.aufirst=A.&amp;rft.au=Grolinger%2C+K.&amp;rft.au=Elyamany%2C+H.+F.&amp;rft.au=Capretz%2C+M.+A.+M.&amp;rft_id=http%3A%2F%2Fieeexplore.ieee.org%2Fdocument%2F7906512%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-57"><span class="mw-cite-backlink"><b><a href="#cite_ref-57">^</a></b></span> <span class="reference-text"><cite class="citation web">Monash, Curt (30 April 2009). <a rel="nofollow" class="external text" href="http://www.dbms2.com/2009/04/30/ebays-two-enormous-data-warehouses/">"eBay's two enormous data warehouses"</a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=eBay%27s+two+enormous+data+warehouses&amp;rft.date=2009-04-30&amp;rft.au=Monash%2C+Curt&amp;rft_id=http%3A%2F%2Fwww.dbms2.com%2F2009%2F04%2F30%2Febays-two-enormous-data-warehouses%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span><br />
<cite class="citation web">Monash, Curt (6 October 2010). <a rel="nofollow" class="external text" href="http://www.dbms2.com/2010/10/06/ebay-followup-greenplum-out-teradata-10-petabytes-hadoop-has-some-value-and-more/">"eBay followup&#160;– Greenplum out, Teradata &gt; 10 petabytes, Hadoop has some value, and more"</a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=eBay+followup+%E2%80%93+Greenplum+out%2C+Teradata+%3E+10+petabytes%2C+Hadoop+has+some+value%2C+and+more&amp;rft.date=2010-10-06&amp;rft.au=Monash%2C+Curt&amp;rft_id=http%3A%2F%2Fwww.dbms2.com%2F2010%2F10%2F06%2Febay-followup-greenplum-out-teradata-10-petabytes-hadoop-has-some-value-and-more%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-58"><span class="mw-cite-backlink"><b><a href="#cite_ref-58">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://www.ayasdi.com/resources/">"Resources on how Topological Data Analysis is used to analyze big data"</a>. Ayasdi.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Resources+on+how+Topological+Data+Analysis+is+used+to+analyze+big+data&amp;rft.pub=Ayasdi&amp;rft_id=http%3A%2F%2Fwww.ayasdi.com%2Fresources%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-59"><span class="mw-cite-backlink"><b><a href="#cite_ref-59">^</a></b></span> <span class="reference-text"><cite class="citation web">CNET News (1 April 2011). <a rel="nofollow" class="external text" href="http://news.cnet.com/8301-21546_3-20049693-10253464.html">"Storage area networks need not apply"</a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Storage+area+networks+need+not+apply&amp;rft.date=2011-04-01&amp;rft.au=CNET+News&amp;rft_id=http%3A%2F%2Fnews.cnet.com%2F8301-21546_3-20049693-10253464.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-60"><span class="mw-cite-backlink"><b><a href="#cite_ref-60">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://www.evaluatorgroup.com/document/big-data-how-new-analytic-systems-will-impact-storage-2/">"How New Analytic Systems will Impact Storage"</a>. September 2011.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=How+New+Analytic+Systems+will+Impact+Storage&amp;rft.date=2011-09&amp;rft_id=http%3A%2F%2Fwww.evaluatorgroup.com%2Fdocument%2Fbig-data-how-new-analytic-systems-will-impact-storage-2%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-HilbertContent-61"><span class="mw-cite-backlink"><b><a href="#cite_ref-HilbertContent_61-0">^</a></b></span> <span class="reference-text"><cite class="citation journal"><a rel="nofollow" class="external text" href="http://www.tandfonline.com/doi/abs/10.1080/01972243.2013.873748">"An Error Occurred Setting Your User Cookie"</a>. <i>The Information Society</i>. <b>30</b>: 127–143. <a href="/wiki/Digital_object_identifier" title="Digital object identifier">doi</a>:<a rel="nofollow" class="external text" href="//doi.org/10.1080%2F01972243.2013.873748">10.1080/01972243.2013.873748</a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=The+Information+Society&amp;rft.atitle=An+Error+Occurred+Setting+Your+User+Cookie&amp;rft.volume=30&amp;rft.pages=127-143&amp;rft_id=info%3Adoi%2F10.1080%2F01972243.2013.873748&amp;rft_id=http%3A%2F%2Fwww.tandfonline.com%2Fdoi%2Fabs%2F10.1080%2F01972243.2013.873748&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-62"><span class="mw-cite-backlink"><b><a href="#cite_ref-62">^</a></b></span> <span class="reference-text"><cite class="citation web">Rajpurohit, Anmol (11 July 2014). <a rel="nofollow" class="external text" href="http://www.kdnuggets.com/2014/07/interview-amy-gershkoff-ebay-in-house-BI-tools.html">"Interview: Amy Gershkoff, Director of Customer Analytics &amp; Insights, eBay on How to Design Custom In-House BI Tools"</a>. <i>KDnuggets</i><span class="reference-accessdate">. Retrieved <span class="nowrap">2014-07-14</span></span>. <q>Dr. Amy Gershkoff: "Generally, I find that off-the-shelf business intelligence tools do not meet the needs of clients who want to derive custom insights from their data. Therefore, for medium-to-large organizations with access to strong technical talent, I usually recommend building custom, in-house solutions."</q></cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=KDnuggets&amp;rft.atitle=Interview%3A+Amy+Gershkoff%2C+Director+of+Customer+Analytics+%26+Insights%2C+eBay+on+How+to+Design+Custom+In-House+BI+Tools&amp;rft.date=2014-07-11&amp;rft.aulast=Rajpurohit&amp;rft.aufirst=Anmol&amp;rft_id=http%3A%2F%2Fwww.kdnuggets.com%2F2014%2F07%2Finterview-amy-gershkoff-ebay-in-house-BI-tools.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-63"><span class="mw-cite-backlink"><b><a href="#cite_ref-63">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://www.computerworld.com/article/2472667/government-it/the-government-and-big-data--use--problems-and-potential.html">"The Government and big data: Use, problems and potential"</a>. Computerworld. 21 March 2012<span class="reference-accessdate">. Retrieved <span class="nowrap">12 September</span> 2016</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=The+Government+and+big+data%3A+Use%2C+problems+and+potential&amp;rft.pub=Computerworld&amp;rft.date=2012-03-21&amp;rft_id=http%3A%2F%2Fwww.computerworld.com%2Farticle%2F2472667%2Fgovernment-it%2Fthe-government-and-big-data--use--problems-and-potential.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-64"><span class="mw-cite-backlink"><b><a href="#cite_ref-64">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://www.unglobalpulse.org/projects/BigDataforDevelopment">"White Paper: Big Data for Development: Opportunities &amp; Challenges (2012) – United Nations Global Pulse"</a>. <i>Unglobalpulse.org</i><span class="reference-accessdate">. Retrieved <span class="nowrap">13 April</span> 2016</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=Unglobalpulse.org&amp;rft.atitle=White+Paper%3A+Big+Data+for+Development%3A+Opportunities+%26+Challenges+%282012%29+%E2%80%93+United+Nations+Global+Pulse&amp;rft_id=http%3A%2F%2Fwww.unglobalpulse.org%2Fprojects%2FBigDataforDevelopment&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-65"><span class="mw-cite-backlink"><b><a href="#cite_ref-65">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://www.weforum.org/reports/big-data-big-impact-new-possibilities-international-development">"WEF (World Economic Forum), &amp; Vital Wave Consulting. (2012). Big Data, Big Impact: New Possibilities for International Development"</a>. <i>World Economic Forum</i><span class="reference-accessdate">. Retrieved <span class="nowrap">24 August</span> 2012</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=World+Economic+Forum&amp;rft.atitle=WEF+%28World+Economic+Forum%29%2C+%26+Vital+Wave+Consulting.+%282012%29.+Big+Data%2C+Big+Impact%3A+New+Possibilities+for+International+Development&amp;rft_id=http%3A%2F%2Fwww.weforum.org%2Freports%2Fbig-data-big-impact-new-possibilities-international-development&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-HilbertBigData2013-66"><span class="mw-cite-backlink">^ <a href="#cite_ref-HilbertBigData2013_66-0"><sup><i><b>a</b></i></sup></a> <a href="#cite_ref-HilbertBigData2013_66-1"><sup><i><b>b</b></i></sup></a> <a href="#cite_ref-HilbertBigData2013_66-2"><sup><i><b>c</b></i></sup></a> <a href="#cite_ref-HilbertBigData2013_66-3"><sup><i><b>d</b></i></sup></a></span> <span class="reference-text"><cite class="citation web">"Big Data for Development: From Information- to Knowledge Societies". <a href="/wiki/Social_Science_Research_Network" title="Social Science Research Network">SSRN</a>&#160;<span class="plainlinks"><a rel="nofollow" class="external text" href="//ssrn.com/abstract=2205145">2205145</a> <img alt="Freely accessible" src="//upload.wikimedia.org/wikipedia/commons/thumb/6/65/Lock-green.svg/9px-Lock-green.svg.png" title="Freely accessible" width="9" height="14" srcset="//upload.wikimedia.org/wikipedia/commons/thumb/6/65/Lock-green.svg/14px-Lock-green.svg.png 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/6/65/Lock-green.svg/18px-Lock-green.svg.png 2x" data-file-width="512" data-file-height="813" /></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Big+Data+for+Development%3A+From+Information-+to+Knowledge+Societies&amp;rft_id=%2F%2Fssrn.com%2Fabstract%3D2205145&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span> <span style="display:none;font-size:100%" class="error citation-comment">Missing or empty <code style="color:inherit; border:inherit; padding:inherit;">|url=</code> (<a href="/wiki/Help:CS1_errors#cite_web_url" title="Help:CS1 errors">help</a>)</span></span></li>
<li id="cite_note-67"><span class="mw-cite-backlink"><b><a href="#cite_ref-67">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://blogs.worldbank.org/ic4d/four-ways-to-talk-about-big-data/">"Elena Kvochko, Four Ways To talk About Big Data (Information Communication Technologies for Development Series)"</a>. worldbank.org<span class="reference-accessdate">. Retrieved <span class="nowrap">2012-05-30</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Elena+Kvochko%2C+Four+Ways+To+talk+About+Big+Data+%28Information+Communication+Technologies+for+Development+Series%29&amp;rft.pub=worldbank.org&amp;rft_id=http%3A%2F%2Fblogs.worldbank.org%2Fic4d%2Ffour-ways-to-talk-about-big-data%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-68"><span class="mw-cite-backlink"><b><a href="#cite_ref-68">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://www.statisticsviews.com/details/feature/5393251/Big-Data--Business-An-on-going-revolution.html">"Daniele Medri: Big Data &amp; Business: An on-going revolution"</a>. Statistics Views. 21 October 2013.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Daniele+Medri%3A+Big+Data+%26+Business%3A+An+on-going+revolution&amp;rft.pub=Statistics+Views&amp;rft.date=2013-10-21&amp;rft_id=http%3A%2F%2Fwww.statisticsviews.com%2Fdetails%2Ffeature%2F5393251%2FBig-Data--Business-An-on-going-revolution.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-69"><span class="mw-cite-backlink"><b><a href="#cite_ref-69">^</a></b></span> <span class="reference-text"><cite class="citation web">Tobias Knobloch and Julia Manske (11 January 2016). <a rel="nofollow" class="external text" href="http://www.dandc.eu/en/article/opportunities-and-risks-user-generated-and-automatically-compiled-data">"Responsible use of data"</a>. <i>D+C, Development and Cooperation</i>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=D%2BC%2C+Development+and+Cooperation&amp;rft.atitle=Responsible+use+of+data&amp;rft.date=2016-01-11&amp;rft.au=Tobias+Knobloch+and+Julia+Manske&amp;rft_id=http%3A%2F%2Fwww.dandc.eu%2Fen%2Farticle%2Fopportunities-and-risks-user-generated-and-automatically-compiled-data&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-70"><span class="mw-cite-backlink"><b><a href="#cite_ref-70">^</a></b></span> <span class="reference-text"><cite class="citation journal">Lee, Jay; Wu, F.; Zhao, W.; Ghaffari, M.; Liao, L (January 2013). "Prognostics and health management design for rotary machinery systems—Reviews, methodology and applications". <i>Mechanical Systems and Signal Processing</i>. <b>42</b> (1).</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Mechanical+Systems+and+Signal+Processing&amp;rft.atitle=Prognostics+and+health+management+design+for+rotary+machinery+systems%E2%80%94Reviews%2C+methodology+and+applications&amp;rft.volume=42&amp;rft.issue=1&amp;rft.date=2013-01&amp;rft.aulast=Lee&amp;rft.aufirst=Jay&amp;rft.au=Wu%2C+F.&amp;rft.au=Zhao%2C+W.&amp;rft.au=Ghaffari%2C+M.&amp;rft.au=Liao%2C+L&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-71"><span class="mw-cite-backlink"><b><a href="#cite_ref-71">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="https://www.phmsociety.org/events/conference/phm/europe/16/tutorials">"Tutorials"</a>. PHM Society<span class="reference-accessdate">. Retrieved <span class="nowrap">27 September</span> 2016</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Tutorials&amp;rft.pub=PHM+Society&amp;rft_id=https%3A%2F%2Fwww.phmsociety.org%2Fevents%2Fconference%2Fphm%2Feurope%2F16%2Ftutorials&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-72"><span class="mw-cite-backlink"><b><a href="#cite_ref-72">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="https://www.itri.org.tw/eng/Content/MSGPic01/contents.aspx?&amp;SiteID=1&amp;MmmID=620651706136357202&amp;CatID=620653256103620163&amp;MSID=654532365564567545">"Prognostic and Health Management Technology for MOCVD Equipment"</a>. Industrial Technology Research Institute<span class="reference-accessdate">. Retrieved <span class="nowrap">27 September</span> 2016</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Prognostic+and+Health+Management+Technology+for+MOCVD+Equipment&amp;rft.pub=Industrial+Technology+Research+Institute&amp;rft_id=https%3A%2F%2Fwww.itri.org.tw%2Feng%2FContent%2FMSGPic01%2Fcontents.aspx%3F%26SiteID%3D1%26MmmID%3D620651706136357202%26CatID%3D620653256103620163%26MSID%3D654532365564567545&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-ref135-73"><span class="mw-cite-backlink"><b><a href="#cite_ref-ref135_73-0">^</a></b></span> <span class="reference-text"><cite class="citation journal">"Impending Challenges for the Use of Big Data". <i>International Journal of Radiation Oncology*Biology*Physics</i>. <a href="/wiki/Digital_object_identifier" title="Digital object identifier">doi</a>:<a rel="nofollow" class="external text" href="//doi.org/10.1016%2Fj.ijrobp.2015.10.060">10.1016/j.ijrobp.2015.10.060</a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=International+Journal+of+Radiation+Oncology%2ABiology%2APhysics&amp;rft.atitle=Impending+Challenges+for+the+Use+of+Big+Data&amp;rft_id=info%3Adoi%2F10.1016%2Fj.ijrobp.2015.10.060&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-74"><span class="mw-cite-backlink"><b><a href="#cite_ref-74">^</a></b></span> <span class="reference-text"><cite class="citation journal">O'Donoghue, John; Herbert, John (1 October 2012). <a rel="nofollow" class="external text" href="http://doi.acm.org/10.1145/2378016.2378021">"Data Management Within mHealth Environments: Patient Sensors, Mobile Devices, and Databases"</a>. <i>Journal of Data and Information Quality</i>. <b>4</b> (1): 5:1–5:20. <a href="/wiki/Digital_object_identifier" title="Digital object identifier">doi</a>:<a rel="nofollow" class="external text" href="//doi.org/10.1145%2F2378016.2378021">10.1145/2378016.2378021</a><span class="reference-accessdate">. Retrieved <span class="nowrap">16 June</span> 2016</span> – via ACM Digital Library.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Journal+of+Data+and+Information+Quality&amp;rft.atitle=Data+Management+Within+mHealth+Environments%3A+Patient+Sensors%2C+Mobile+Devices%2C+and+Databases&amp;rft.volume=4&amp;rft.issue=1&amp;rft.pages=5%3A1-5%3A20&amp;rft.date=2012-10-01&amp;rft_id=info%3Adoi%2F10.1145%2F2378016.2378021&amp;rft.aulast=O%27Donoghue&amp;rft.aufirst=John&amp;rft.au=Herbert%2C+John&amp;rft_id=http%3A%2F%2Fdoi.acm.org%2F10.1145%2F2378016.2378021&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-Mirkes2016-75"><span class="mw-cite-backlink"><b><a href="#cite_ref-Mirkes2016_75-0">^</a></b></span> <span class="reference-text"><cite class="citation journal">Mirkes, E.M.; Coats, T.J.; Levesley, J.; Gorban, A.N. (2016). <a rel="nofollow" class="external text" href="https://www.researchgate.net/publication/300400110_Handling_missing_data_in_large_healthcare_dataset_A_case_study_of_unknown_trauma_outcomes">"Handling missing data in large healthcare dataset: A case study of unknown trauma outcomes"</a>. <i>Computers in Biology and Medicine</i>. <b>75</b>: 203–216. <a href="/wiki/Digital_object_identifier" title="Digital object identifier">doi</a>:<a rel="nofollow" class="external text" href="//doi.org/10.1016%2Fj.compbiomed.2016.06.004">10.1016/j.compbiomed.2016.06.004</a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Computers+in+Biology+and+Medicine&amp;rft.atitle=Handling+missing+data+in+large+healthcare+dataset%3A+A+case+study+of+unknown+trauma+outcomes&amp;rft.volume=75&amp;rft.pages=203-216&amp;rft.date=2016&amp;rft_id=info%3Adoi%2F10.1016%2Fj.compbiomed.2016.06.004&amp;rft.aulast=Mirkes&amp;rft.aufirst=E.M.&amp;rft.au=Coats%2C+T.J.&amp;rft.au=Levesley%2C+J.&amp;rft.au=Gorban%2C+A.N.&amp;rft_id=https%3A%2F%2Fwww.researchgate.net%2Fpublication%2F300400110_Handling_missing_data_in_large_healthcare_dataset_A_case_study_of_unknown_trauma_outcomes&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-76"><span class="mw-cite-backlink"><b><a href="#cite_ref-76">^</a></b></span> <span class="reference-text"><cite class="citation journal">Murdoch, Travis B.; Detsky, Allan S. (2013-04-03). <a rel="nofollow" class="external text" href="http://jamanetwork.com/journals/jama/article-abstract/1674245">"The Inevitable Application of Big Data to Health Care"</a>. <i>JAMA</i>. <b>309</b> (13): 1351. <a href="/wiki/Digital_object_identifier" title="Digital object identifier">doi</a>:<a rel="nofollow" class="external text" href="//doi.org/10.1001%2Fjama.2013.393">10.1001/jama.2013.393</a>. <a href="/wiki/International_Standard_Serial_Number" title="International Standard Serial Number">ISSN</a>&#160;<a rel="nofollow" class="external text" href="//www.worldcat.org/issn/0098-7484">0098-7484</a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=JAMA&amp;rft.atitle=The+Inevitable+Application+of+Big+Data+to+Health+Care&amp;rft.volume=309&amp;rft.issue=13&amp;rft.pages=1351&amp;rft.date=2013-04-03&amp;rft_id=info%3Adoi%2F10.1001%2Fjama.2013.393&amp;rft.issn=0098-7484&amp;rft.aulast=Murdoch&amp;rft.aufirst=Travis+B.&amp;rft.au=Detsky%2C+Allan+S.&amp;rft_id=http%3A%2F%2Fjamanetwork.com%2Fjournals%2Fjama%2Farticle-abstract%2F1674245&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-77"><span class="mw-cite-backlink"><b><a href="#cite_ref-77">^</a></b></span> <span class="reference-text"><cite class="citation news"><a rel="nofollow" class="external text" href="https://www.forbes.com/sites/jmaureenhenderson/2013/07/30/degrees-in-big-data-fad-or-fast-track-to-career-success/?">"Degrees in Big Data: Fad or Fast Track to Career Success"</a>. <i>Forbes</i><span class="reference-accessdate">. Retrieved <span class="nowrap">2016-02-21</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Forbes&amp;rft.atitle=Degrees+in+Big+Data%3A+Fad+or+Fast+Track+to+Career+Success&amp;rft_id=https%3A%2F%2Fwww.forbes.com%2Fsites%2Fjmaureenhenderson%2F2013%2F07%2F30%2Fdegrees-in-big-data-fad-or-fast-track-to-career-success%2F%3F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-78"><span class="mw-cite-backlink"><b><a href="#cite_ref-78">^</a></b></span> <span class="reference-text"><cite class="citation news"><a rel="nofollow" class="external text" href="https://venturebeat.com/2014/04/15/ny-gets-new-bootcamp-for-data-scientists-its-free-but-harder-to-get-into-than-harvard/">"NY gets new boot camp for data scientists: It's free but harder to get into than Harvard"</a>. <i>Venture Beat</i><span class="reference-accessdate">. Retrieved <span class="nowrap">2016-02-21</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Venture+Beat&amp;rft.atitle=NY+gets+new+boot+camp+for+data+scientists%3A+It%E2%80%99s+free+but+harder+to+get+into+than+Harvard&amp;rft_id=https%3A%2F%2Fventurebeat.com%2F2014%2F04%2F15%2Fny-gets-new-bootcamp-for-data-scientists-its-free-but-harder-to-get-into-than-harvard%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-79"><span class="mw-cite-backlink"><b><a href="#cite_ref-79">^</a></b></span> <span class="reference-text"><cite class="citation journal">Couldry, Nick; Turow, Joseph (2014). "Advertising, Big Data, and the Clearance of the Public Realm: Marketers' New Approaches to the Content Subsidy". <i>International Journal of Communication</i>. <b>8</b>: 1710–1726.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=International+Journal+of+Communication&amp;rft.atitle=Advertising%2C+Big+Data%2C+and+the+Clearance+of+the+Public+Realm%3A+Marketers%E2%80%99+New+Approaches+to+the+Content+Subsidy&amp;rft.volume=8&amp;rft.pages=1710-1726&amp;rft.date=2014&amp;rft.aulast=Couldry&amp;rft.aufirst=Nick&amp;rft.au=Turow%2C+Joseph&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-80"><span class="mw-cite-backlink"><b><a href="#cite_ref-80">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="https://www.ibc.org/tech-advances/big-data-and-analytics-c4-and-genius-digital/1076.article">"Big data and analytics: C4 and Genius Digital"</a>. <i>Ibc.org</i><span class="reference-accessdate">. Retrieved <span class="nowrap">8 October</span> 2017</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=Ibc.org&amp;rft.atitle=Big+data+and+analytics%3A+C4+and+Genius+Digital&amp;rft_id=https%3A%2F%2Fwww.ibc.org%2Ftech-advances%2Fbig-data-and-analytics-c4-and-genius-digital%2F1076.article&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-81"><span class="mw-cite-backlink"><b><a href="#cite_ref-81">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://www.businesswire.com/news/home/20170109006500/en/QuiO-Named-Innovation-Champion-Accenture-HealthTech-Innovation">"QuiO Named Innovation Champion of the Accenture HealthTech Innovation Challenge"</a>. <i>Businesswire.com</i><span class="reference-accessdate">. Retrieved <span class="nowrap">8 October</span> 2017</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=Businesswire.com&amp;rft.atitle=QuiO+Named+Innovation+Champion+of+the+Accenture+HealthTech+Innovation+Challenge&amp;rft_id=http%3A%2F%2Fwww.businesswire.com%2Fnews%2Fhome%2F20170109006500%2Fen%2FQuiO-Named-Innovation-Champion-Accenture-HealthTech-Innovation&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-82"><span class="mw-cite-backlink"><b><a href="#cite_ref-82">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="https://www.predix.com/sites/default/files/IDC_OT_Final_whitepaper_249120.pdf">"A Software Platform for Operational Technology Innovation"</a> <span style="font-size:85%;">(PDF)</span>. <i>Predix.com</i><span class="reference-accessdate">. Retrieved <span class="nowrap">8 October</span> 2017</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=Predix.com&amp;rft.atitle=A+Software+Platform+for+Operational+Technology+Innovation&amp;rft_id=https%3A%2F%2Fwww.predix.com%2Fsites%2Fdefault%2Ffiles%2FIDC_OT_Final_whitepaper_249120.pdf&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-ITOA1-83"><span class="mw-cite-backlink">^ <a href="#cite_ref-ITOA1_83-0"><sup><i><b>a</b></i></sup></a> <a href="#cite_ref-ITOA1_83-1"><sup><i><b>b</b></i></sup></a></span> <span class="reference-text"><cite class="citation web">Solnik, Ray. <a rel="nofollow" class="external text" href="http://www.datacenterjournal.com/time-analytics-delivers-operations/">"The Time Has Come: Analytics Delivers for IT Operations"</a>. <i>Data Center Journal</i><span class="reference-accessdate">. Retrieved <span class="nowrap">June 21,</span> 2016</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=Data+Center+Journal&amp;rft.atitle=The+Time+Has+Come%3A+Analytics+Delivers+for+IT+Operations&amp;rft.aulast=Solnik&amp;rft.aufirst=Ray&amp;rft_id=http%3A%2F%2Fwww.datacenterjournal.com%2Ftime-analytics-delivers-operations%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-WH_Big_Data-84"><span class="mw-cite-backlink"><b><a href="#cite_ref-WH_Big_Data_84-0">^</a></b></span> <span class="reference-text"><cite class="citation web">Kalil, Tom. <a rel="nofollow" class="external text" href="http://www.whitehouse.gov/blog/2012/03/29/big-data-big-deal">"Big Data is a Big Deal"</a>. White House<span class="reference-accessdate">. Retrieved <span class="nowrap">26 September</span> 2012</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Big+Data+is+a+Big+Deal&amp;rft.pub=White+House&amp;rft.aulast=Kalil&amp;rft.aufirst=Tom&amp;rft_id=http%3A%2F%2Fwww.whitehouse.gov%2Fblog%2F2012%2F03%2F29%2Fbig-data-big-deal&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-85"><span class="mw-cite-backlink"><b><a href="#cite_ref-85">^</a></b></span> <span class="reference-text"><cite class="citation web">Executive Office of the President (March 2012). <a rel="nofollow" class="external text" href="http://www.whitehouse.gov/sites/default/files/microsites/ostp/big_data_fact_sheet_final_1.pdf">"Big Data Across the Federal Government"</a> <span style="font-size:85%;">(PDF)</span>. White House<span class="reference-accessdate">. Retrieved <span class="nowrap">26 September</span> 2012</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Big+Data+Across+the+Federal+Government&amp;rft.pub=White+House&amp;rft.date=2012-03&amp;rft.au=Executive+Office+of+the+President&amp;rft_id=http%3A%2F%2Fwww.whitehouse.gov%2Fsites%2Fdefault%2Ffiles%2Fmicrosites%2Fostp%2Fbig_data_fact_sheet_final_1.pdf&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-infoworld_bigdata-86"><span class="mw-cite-backlink"><b><a href="#cite_ref-infoworld_bigdata_86-0">^</a></b></span> <span class="reference-text"><cite class="citation web">Lampitt, Andrew. <a rel="nofollow" class="external text" href="http://www.infoworld.com/d/big-data/the-real-story-of-how-big-data-analytics-helped-obama-win-212862">"The real story of how big data analytics helped Obama win"</a>. <i><a href="/wiki/Infoworld" class="mw-redirect" title="Infoworld">Infoworld</a></i><span class="reference-accessdate">. Retrieved <span class="nowrap">31 May</span> 2014</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=Infoworld&amp;rft.atitle=The+real+story+of+how+big+data+analytics+helped+Obama+win&amp;rft.aulast=Lampitt&amp;rft.aufirst=Andrew&amp;rft_id=http%3A%2F%2Fwww.infoworld.com%2Fd%2Fbig-data%2Fthe-real-story-of-how-big-data-analytics-helped-obama-win-212862&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-87"><span class="mw-cite-backlink"><b><a href="#cite_ref-87">^</a></b></span> <span class="reference-text"><cite class="citation web">Hoover, J. Nicholas. <a rel="nofollow" class="external text" href="http://www.informationweek.com/government/enterprise-applications/image-gallery-governments-10-most-powerf/224700271">"Government's 10 Most Powerful Supercomputers"</a>. <i>Information Week</i>. UBM<span class="reference-accessdate">. Retrieved <span class="nowrap">26 September</span> 2012</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=Information+Week&amp;rft.atitle=Government%27s+10+Most+Powerful+Supercomputers&amp;rft.aulast=Hoover&amp;rft.aufirst=J.+Nicholas&amp;rft_id=http%3A%2F%2Fwww.informationweek.com%2Fgovernment%2Fenterprise-applications%2Fimage-gallery-governments-10-most-powerf%2F224700271&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-88"><span class="mw-cite-backlink"><b><a href="#cite_ref-88">^</a></b></span> <span class="reference-text"><cite class="citation news">Bamford, James (15 March 2012). <a rel="nofollow" class="external text" href="https://www.wired.com/threatlevel/2012/03/ff_nsadatacenter/all/1">"The NSA Is Building the Country's Biggest Spy Center (Watch What You Say)"</a>. <i>Wired Magazine</i><span class="reference-accessdate">. Retrieved <span class="nowrap">2013-03-18</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Wired+Magazine&amp;rft.atitle=The+NSA+Is+Building+the+Country%27s+Biggest+Spy+Center+%28Watch+What+You+Say%29&amp;rft.date=2012-03-15&amp;rft.aulast=Bamford&amp;rft.aufirst=James&amp;rft_id=https%3A%2F%2Fwww.wired.com%2Fthreatlevel%2F2012%2F03%2Fff_nsadatacenter%2Fall%2F1&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-89"><span class="mw-cite-backlink"><b><a href="#cite_ref-89">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://www.nsa.gov/public_info/press_room/2011/utah_groundbreaking_ceremony.shtml">"Groundbreaking Ceremony Held for $1.2 Billion Utah Data Center"</a>. National Security Agency Central Security Service<span class="reference-accessdate">. Retrieved <span class="nowrap">2013-03-18</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Groundbreaking+Ceremony+Held+for+%241.2+Billion+Utah+Data+Center&amp;rft.pub=National+Security+Agency+Central+Security+Service&amp;rft_id=http%3A%2F%2Fwww.nsa.gov%2Fpublic_info%2Fpress_room%2F2011%2Futah_groundbreaking_ceremony.shtml&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-90"><span class="mw-cite-backlink"><b><a href="#cite_ref-90">^</a></b></span> <span class="reference-text"><cite class="citation news">Hill, Kashmir. <a rel="nofollow" class="external text" href="https://www.forbes.com/sites/kashmirhill/2013/07/24/blueprints-of-nsa-data-center-in-utah-suggest-its-storage-capacity-is-less-impressive-than-thought/">"TBlueprints of NSA's Ridiculously Expensive Data Center in Utah Suggest It Holds Less Info Than Thought"</a>. <i>Forbes</i><span class="reference-accessdate">. Retrieved <span class="nowrap">2013-10-31</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Forbes&amp;rft.atitle=TBlueprints+of+NSA%27s+Ridiculously+Expensive+Data+Center+in+Utah+Suggest+It+Holds+Less+Info+Than+Thought&amp;rft.aulast=Hill&amp;rft.aufirst=Kashmir&amp;rft_id=https%3A%2F%2Fwww.forbes.com%2Fsites%2Fkashmirhill%2F2013%2F07%2F24%2Fblueprints-of-nsa-data-center-in-utah-suggest-its-storage-capacity-is-less-impressive-than-thought%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-91"><span class="mw-cite-backlink"><b><a href="#cite_ref-91">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://www.livemint.com/Industry/bUQo8xQ3gStSAy5II9lxoK/Are-Indian-companies-making-enough-sense-of-Big-Data.html">"News: Live Mint"</a>. <i>Are Indian companies making enough sense of Big Data?</i>. Live Mint. 23 June 2014<span class="reference-accessdate">. Retrieved <span class="nowrap">2014-11-22</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=Are+Indian+companies+making+enough+sense+of+Big+Data%3F&amp;rft.atitle=News%3A+Live+Mint&amp;rft.date=2014-06-23&amp;rft_id=http%3A%2F%2Fwww.livemint.com%2FIndustry%2FbUQo8xQ3gStSAy5II9lxoK%2FAre-Indian-companies-making-enough-sense-of-Big-Data.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-92"><span class="mw-cite-backlink"><b><a href="#cite_ref-92">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="https://www.ijedr.org/papers/IJEDR1504022.pdf">"Survey on Big Data Using Data Mining"</a> <span style="font-size:85%;">(PDF)</span>. International Journal of Engineering Development and Research. 2015<span class="reference-accessdate">. Retrieved <span class="nowrap">14 September</span> 2016</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Survey+on+Big+Data+Using+Data+Mining&amp;rft.pub=International+Journal+of+Engineering+Development+and+Research&amp;rft.date=2015&amp;rft_id=https%3A%2F%2Fwww.ijedr.org%2Fpapers%2FIJEDR1504022.pdf&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-93"><span class="mw-cite-backlink"><b><a href="#cite_ref-93">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="https://www.researchgate.net/publication/297762848_Recent_advances_delivered_by_mobile_cloud_computing_and_Internet_of_Things_for_Big_data_applications_A_Survey">"Recent advances delivered by Mobile Cloud Computing and Internet of Things for Big Data applications: a survey"</a>. International Journal of Network Management. 11 March 2016<span class="reference-accessdate">. Retrieved <span class="nowrap">14 September</span> 2016</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Recent+advances+delivered+by+Mobile+Cloud+Computing+and+Internet+of+Things+for+Big+Data+applications%3A+a+survey&amp;rft.pub=International+Journal+of+Network+Management&amp;rft.date=2016-03-11&amp;rft_id=https%3A%2F%2Fwww.researchgate.net%2Fpublication%2F297762848_Recent_advances_delivered_by_mobile_cloud_computing_and_Internet_of_Things_for_Big_data_applications_A_Survey&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-94"><span class="mw-cite-backlink"><b><a href="#cite_ref-94">^</a></b></span> <span class="reference-text"><cite class="citation news">Wingfield, Nick (12 March 2013). <a rel="nofollow" class="external text" href="http://bits.blogs.nytimes.com/2013/03/12/predicting-commutes-more-accurately-for-would-be-home-buyers/">"Predicting Commutes More Accurately for Would-Be Home Buyers – NYTimes.com"</a>. Bits.blogs.nytimes.com<span class="reference-accessdate">. Retrieved <span class="nowrap">2013-07-21</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.atitle=Predicting+Commutes+More+Accurately+for+Would-Be+Home+Buyers+%E2%80%93+NYTimes.com&amp;rft.date=2013-03-12&amp;rft.aulast=Wingfield&amp;rft.aufirst=Nick&amp;rft_id=http%3A%2F%2Fbits.blogs.nytimes.com%2F2013%2F03%2F12%2Fpredicting-commutes-more-accurately-for-would-be-home-buyers%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-fico.com-95"><span class="mw-cite-backlink"><b><a href="#cite_ref-fico.com_95-0">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://www.fico.com/en/Products/DMApps/Pages/FICO-Falcon-Fraud-Manager.aspx">"FICO® Falcon® Fraud Manager"</a>. Fico.com<span class="reference-accessdate">. Retrieved <span class="nowrap">2013-07-21</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=FICO%C2%AE+Falcon%C2%AE+Fraud+Manager&amp;rft.pub=Fico.com&amp;rft_id=http%3A%2F%2Fwww.fico.com%2Fen%2FProducts%2FDMApps%2FPages%2FFICO-Falcon-Fraud-Manager.aspx&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-96"><span class="mw-cite-backlink"><b><a href="#cite_ref-96">^</a></b></span> <span class="reference-text"><cite class="citation web">Alexandru, Dan. <a rel="nofollow" class="external text" href="https://cds.cern.ch/record/1504817/files/CERN-THESIS-2013-004.pdf">"Prof"</a> <span style="font-size:85%;">(PDF)</span>. <i>cds.cern.ch</i>. CERN<span class="reference-accessdate">. Retrieved <span class="nowrap">24 March</span> 2015</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=cds.cern.ch&amp;rft.atitle=Prof&amp;rft.aulast=Alexandru&amp;rft.aufirst=Dan&amp;rft_id=https%3A%2F%2Fcds.cern.ch%2Frecord%2F1504817%2Ffiles%2FCERN-THESIS-2013-004.pdf&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-97"><span class="mw-cite-backlink"><b><a href="#cite_ref-97">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://cds.cern.ch/record/1278169?ln=en">"LHC Brochure, English version. A presentation of the largest and the most powerful particle accelerator in the world, the Large Hadron Collider (LHC), which started up in 2008. Its role, characteristics, technologies, etc. are explained for the general public"</a>. <i>CERN-Brochure-2010-006-Eng. LHC Brochure, English version</i>. CERN<span class="reference-accessdate">. Retrieved <span class="nowrap">20 January</span> 2013</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=CERN-Brochure-2010-006-Eng.+LHC+Brochure%2C+English+version.&amp;rft.atitle=LHC+Brochure%2C+English+version.+A+presentation+of+the+largest+and+the+most+powerful+particle+accelerator+in+the+world%2C+the+Large+Hadron+Collider+%28LHC%29%2C+which+started+up+in+2008.+Its+role%2C+characteristics%2C+technologies%2C+etc.+are+explained+for+the+general+public.&amp;rft_id=http%3A%2F%2Fcds.cern.ch%2Frecord%2F1278169%3Fln%3Den&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-98"><span class="mw-cite-backlink"><b><a href="#cite_ref-98">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://cds.cern.ch/record/1092437?ln=en">"LHC Guide, English version. A collection of facts and figures about the Large Hadron Collider (LHC) in the form of questions and answers"</a>. <i>CERN-Brochure-2008-001-Eng. LHC Guide, English version</i>. CERN<span class="reference-accessdate">. Retrieved <span class="nowrap">20 January</span> 2013</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=CERN-Brochure-2008-001-Eng.+LHC+Guide%2C+English+version.&amp;rft.atitle=LHC+Guide%2C+English+version.+A+collection+of+facts+and+figures+about+the+Large+Hadron+Collider+%28LHC%29+in+the+form+of+questions+and+answers.&amp;rft_id=http%3A%2F%2Fcds.cern.ch%2Frecord%2F1092437%3Fln%3Den&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-nature-99"><span class="mw-cite-backlink"><b><a href="#cite_ref-nature_99-0">^</a></b></span> <span class="reference-text"><cite class="citation news">Brumfiel, Geoff (19 January 2011). <a rel="nofollow" class="external text" href="http://www.nature.com/news/2011/110119/full/469282a.html">"High-energy physics: Down the petabyte highway"</a>. <i>Nature</i>. <b>469</b>. pp.&#160;282–83. <a href="/wiki/Digital_object_identifier" title="Digital object identifier">doi</a>:<a rel="nofollow" class="external text" href="//doi.org/10.1038%2F469282a">10.1038/469282a</a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Nature&amp;rft.atitle=High-energy+physics%3A+Down+the+petabyte+highway&amp;rft.volume=469&amp;rft.pages=282-83&amp;rft.date=2011-01-19&amp;rft_id=info%3Adoi%2F10.1038%2F469282a&amp;rft.aulast=Brumfiel&amp;rft.aufirst=Geoff&amp;rft_id=http%3A%2F%2Fwww.nature.com%2Fnews%2F2011%2F110119%2Ffull%2F469282a.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-100"><span class="mw-cite-backlink"><b><a href="#cite_ref-100">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://www.zurich.ibm.com/pdf/astron/CeBIT+2013+Background+DOME.pdf">"IBM Research - Zurich"</a> <span style="font-size:85%;">(PDF)</span>. <i>Zurich.ibm.com</i><span class="reference-accessdate">. Retrieved <span class="nowrap">8 October</span> 2017</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=Zurich.ibm.com&amp;rft.atitle=IBM+Research+-+Zurich&amp;rft_id=http%3A%2F%2Fwww.zurich.ibm.com%2Fpdf%2Fastron%2FCeBIT%2B2013%2BBackground%2BDOME.pdf&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-101"><span class="mw-cite-backlink"><b><a href="#cite_ref-101">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="https://arstechnica.com/science/2012/04/future-telescope-array-drives-development-of-exabyte-processing/">"Future telescope array drives development of Exabyte processing"</a>. <i>Ars Technica</i><span class="reference-accessdate">. Retrieved <span class="nowrap">15 April</span> 2015</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=Ars+Technica&amp;rft.atitle=Future+telescope+array+drives+development+of+Exabyte+processing&amp;rft_id=https%3A%2F%2Farstechnica.com%2Fscience%2F2012%2F04%2Ffuture-telescope-array-drives-development-of-exabyte-processing%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-102"><span class="mw-cite-backlink"><b><a href="#cite_ref-102">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://theconversation.com/australias-bid-for-the-square-kilometre-array-an-insiders-perspective-4891">"Australia's bid for the Square Kilometre Array – an insider's perspective"</a>. <a href="/wiki/The_Conversation_(website)" title="The Conversation (website)">The Conversation</a>. 1 February 2012<span class="reference-accessdate">. Retrieved <span class="nowrap">27 September</span> 2016</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Australia%E2%80%99s+bid+for+the+Square+Kilometre+Array+%E2%80%93+an+insider%E2%80%99s+perspective&amp;rft.pub=The+Conversation&amp;rft.date=2012-02-01&amp;rft_id=http%3A%2F%2Ftheconversation.com%2Faustralias-bid-for-the-square-kilometre-array-an-insiders-perspective-4891&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-103"><span class="mw-cite-backlink"><b><a href="#cite_ref-103">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://www.oecd.org/sti/ieconomy/Session_3_Delort.pdf#page=6">"Delort P., OECD ICCP Technology Foresight Forum, 2012"</a> <span style="font-size:85%;">(PDF)</span>. <i>Oecd.org</i><span class="reference-accessdate">. Retrieved <span class="nowrap">8 October</span> 2017</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=Oecd.org&amp;rft.atitle=Delort+P.%2C+OECD+ICCP+Technology+Foresight+Forum%2C+2012.&amp;rft_id=http%3A%2F%2Fwww.oecd.org%2Fsti%2Fieconomy%2FSession_3_Delort.pdf%23page%3D6&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-104"><span class="mw-cite-backlink"><b><a href="#cite_ref-104">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://www.nasa.gov/centers/goddard/news/releases/2010/10-051.html">"NASA – NASA Goddard Introduces the NASA Center for Climate Simulation"</a>. <i>Nasa.gov</i><span class="reference-accessdate">. Retrieved <span class="nowrap">13 April</span> 2016</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=Nasa.gov&amp;rft.atitle=NASA+%E2%80%93+NASA+Goddard+Introduces+the+NASA+Center+for+Climate+Simulation&amp;rft_id=http%3A%2F%2Fwww.nasa.gov%2Fcenters%2Fgoddard%2Fnews%2Freleases%2F2010%2F10-051.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-105"><span class="mw-cite-backlink"><b><a href="#cite_ref-105">^</a></b></span> <span class="reference-text"><cite class="citation web">Webster, Phil. <a rel="nofollow" class="external text" href="http://www.csc.com/cscworld/publications/81769/81773-supercomputing_the_climate_nasa_s_big_data_mission">"Supercomputing the Climate: NASA's Big Data Mission"</a>. <i>CSC World</i>. Computer Sciences Corporation<span class="reference-accessdate">. Retrieved <span class="nowrap">2013-01-18</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=CSC+World&amp;rft.atitle=Supercomputing+the+Climate%3A+NASA%27s+Big+Data+Mission&amp;rft.aulast=Webster&amp;rft.aufirst=Phil&amp;rft_id=http%3A%2F%2Fwww.csc.com%2Fcscworld%2Fpublications%2F81769%2F81773-supercomputing_the_climate_nasa_s_big_data_mission&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-106"><span class="mw-cite-backlink"><b><a href="#cite_ref-106">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="https://www.theglobeandmail.com/life/health-and-fitness/health/these-six-great-neuroscience-ideas-could-make-the-leap-from-lab-to-market/article21681731/">"These six great neuroscience ideas could make the leap from lab to market"</a>. <a href="/wiki/The_Globe_and_Mail" title="The Globe and Mail">The Globe and Mail</a>. 20 November 2014<span class="reference-accessdate">. Retrieved <span class="nowrap">1 October</span> 2016</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=These+six+great+neuroscience+ideas+could+make+the+leap+from+lab+to+market&amp;rft.pub=The+Globe+and+Mail&amp;rft.date=2014-11-20&amp;rft_id=https%3A%2F%2Fwww.theglobeandmail.com%2Flife%2Fhealth-and-fitness%2Fhealth%2Fthese-six-great-neuroscience-ideas-could-make-the-leap-from-lab-to-market%2Farticle21681731%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-107"><span class="mw-cite-backlink"><b><a href="#cite_ref-107">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="https://cloud.google.com/customers/dnastack/">"DNAstack tackles massive, complex DNA datasets with Google Genomics"</a>. Google Cloud Platform<span class="reference-accessdate">. Retrieved <span class="nowrap">1 October</span> 2016</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=DNAstack+tackles+massive%2C+complex+DNA+datasets+with+Google+Genomics&amp;rft.pub=Google+Cloud+Platform&amp;rft_id=https%3A%2F%2Fcloud.google.com%2Fcustomers%2Fdnastack%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-108"><span class="mw-cite-backlink"><b><a href="#cite_ref-108">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="https://www.23andme.com/en-int/ancestry/">"23andMe – Ancestry"</a>. <i>23andme.com</i><span class="reference-accessdate">. Retrieved <span class="nowrap">29 December</span> 2016</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=23andme.com&amp;rft.atitle=23andMe+%E2%80%93+Ancestry&amp;rft_id=https%3A%2F%2Fwww.23andme.com%2Fen-int%2Fancestry%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-verge1-109"><span class="mw-cite-backlink">^ <a href="#cite_ref-verge1_109-0"><sup><i><b>a</b></i></sup></a> <a href="#cite_ref-verge1_109-1"><sup><i><b>b</b></i></sup></a></span> <span class="reference-text"><cite class="citation web">Potenza, Alessandra (13 July 2016). <a rel="nofollow" class="external text" href="https://www.theverge.com/2016/7/13/12166960/23andme-genetic-testing-database-genotyping-research">"23andMe wants researchers to use its kits, in a bid to expand its collection of genetic data"</a>. The Verge<span class="reference-accessdate">. Retrieved <span class="nowrap">29 December</span> 2016</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=23andMe+wants+researchers+to+use+its+kits%2C+in+a+bid+to+expand+its+collection+of+genetic+data&amp;rft.pub=The+Verge&amp;rft.date=2016-07-13&amp;rft.aulast=Potenza&amp;rft.aufirst=Alessandra&amp;rft_id=https%3A%2F%2Fwww.theverge.com%2F2016%2F7%2F13%2F12166960%2F23andme-genetic-testing-database-genotyping-research&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-110"><span class="mw-cite-backlink"><b><a href="#cite_ref-110">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="https://www.fastcompany.com/3066775/innovation-agents/this-startup-will-sequence-your-dna-so-you-can-contribute-to-medical-resea">"This Startup Will Sequence Your DNA, So You Can Contribute To Medical Research"</a>. Fast Company. 23 December 2016<span class="reference-accessdate">. Retrieved <span class="nowrap">29 December</span> 2016</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=This+Startup+Will+Sequence+Your+DNA%2C+So+You+Can+Contribute+To+Medical+Research&amp;rft.pub=Fast+Company&amp;rft.date=2016-12-23&amp;rft_id=https%3A%2F%2Fwww.fastcompany.com%2F3066775%2Finnovation-agents%2Fthis-startup-will-sequence-your-dna-so-you-can-contribute-to-medical-resea&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-111"><span class="mw-cite-backlink"><b><a href="#cite_ref-111">^</a></b></span> <span class="reference-text"><cite class="citation web">Seife, Charles. <a rel="nofollow" class="external text" href="https://www.scientificamerican.com/article/23andme-is-terrifying-but-not-for-the-reasons-the-fda-thinks/">"23andMe Is Terrifying, but Not for the Reasons the FDA Thinks"</a>. Scientific American<span class="reference-accessdate">. Retrieved <span class="nowrap">29 December</span> 2016</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=23andMe+Is+Terrifying%2C+but+Not+for+the+Reasons+the+FDA+Thinks&amp;rft.pub=Scientific+American&amp;rft.aulast=Seife&amp;rft.aufirst=Charles&amp;rft_id=https%3A%2F%2Fwww.scientificamerican.com%2Farticle%2F23andme-is-terrifying-but-not-for-the-reasons-the-fda-thinks%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-112"><span class="mw-cite-backlink"><b><a href="#cite_ref-112">^</a></b></span> <span class="reference-text"><cite class="citation web">Zaleski, Andrew (22 June 2016). <a rel="nofollow" class="external text" href="https://www.cnbc.com/2016/06/22/23andme-thinks-your-genes-are-the-key-to-blockbuster-drugs.html">"This biotech start-up is betting your genes will yield the next wonder drug"</a>. CNBC<span class="reference-accessdate">. Retrieved <span class="nowrap">29 December</span> 2016</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=This+biotech+start-up+is+betting+your+genes+will+yield+the+next+wonder+drug&amp;rft.pub=CNBC&amp;rft.date=2016-06-22&amp;rft.aulast=Zaleski&amp;rft.aufirst=Andrew&amp;rft_id=https%3A%2F%2Fwww.cnbc.com%2F2016%2F06%2F22%2F23andme-thinks-your-genes-are-the-key-to-blockbuster-drugs.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-113"><span class="mw-cite-backlink"><b><a href="#cite_ref-113">^</a></b></span> <span class="reference-text"><cite class="citation web">Regalado, Antonio. <a rel="nofollow" class="external text" href="https://www.technologyreview.com/s/601506/23andme-sells-data-for-drug-search/">"How 23andMe turned your DNA into a $1 billion drug discovery machine"</a>. MIT Technology Review<span class="reference-accessdate">. Retrieved <span class="nowrap">29 December</span> 2016</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=How+23andMe+turned+your+DNA+into+a+%241+billion+drug+discovery+machine&amp;rft.pub=MIT+Technology+Review&amp;rft.aulast=Regalado&amp;rft.aufirst=Antonio&amp;rft_id=https%3A%2F%2Fwww.technologyreview.com%2Fs%2F601506%2F23andme-sells-data-for-drug-search%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-114"><span class="mw-cite-backlink"><b><a href="#cite_ref-114">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://www.fiercebiotech.com/it/23andme-reports-jump-requests-for-data-wake-pfizer-depression-study">"23andMe reports jump in requests for data in wake of Pfizer depression study | FierceBiotech"</a>. <i>fiercebiotech.com</i><span class="reference-accessdate">. Retrieved <span class="nowrap">29 December</span> 2016</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=fiercebiotech.com&amp;rft.atitle=23andMe+reports+jump+in+requests+for+data+in+wake+of+Pfizer+depression+study+%7C+FierceBiotech&amp;rft_id=http%3A%2F%2Fwww.fiercebiotech.com%2Fit%2F23andme-reports-jump-requests-for-data-wake-pfizer-depression-study&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-115"><span class="mw-cite-backlink"><b><a href="#cite_ref-115">^</a></b></span> <span class="reference-text"><cite class="citation web">Admire Moyo. <a rel="nofollow" class="external text" href="http://www.itweb.co.za/index.php?option=com_content&amp;view=article&amp;id=147241">"Data scientists predict Springbok defeat"</a>. <i>www.itweb.co.za</i><span class="reference-accessdate">. Retrieved <span class="nowrap">12 December</span> 2015</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=www.itweb.co.za&amp;rft.atitle=Data+scientists+predict+Springbok+defeat&amp;rft.au=Admire+Moyo&amp;rft_id=http%3A%2F%2Fwww.itweb.co.za%2Findex.php%3Foption%3Dcom_content%26view%3Darticle%26id%3D147241&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-116"><span class="mw-cite-backlink"><b><a href="#cite_ref-116">^</a></b></span> <span class="reference-text"><cite class="citation web">Regina Pazvakavambwa. <a rel="nofollow" class="external text" href="http://www.itweb.co.za/index.php?option=com_content&amp;view=article&amp;id=147852">"Predictive analytics, big data transform sports"</a>. <i>www.itweb.co.za</i><span class="reference-accessdate">. Retrieved <span class="nowrap">12 December</span> 2015</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=www.itweb.co.za&amp;rft.atitle=Predictive+analytics%2C+big+data+transform+sports&amp;rft.au=Regina+Pazvakavambwa&amp;rft_id=http%3A%2F%2Fwww.itweb.co.za%2Findex.php%3Foption%3Dcom_content%26view%3Darticle%26id%3D147852&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-117"><span class="mw-cite-backlink"><b><a href="#cite_ref-117">^</a></b></span> <span class="reference-text"><cite class="citation web">Rich Miller. <a rel="nofollow" class="external text" href="http://www.datacenterknowledge.com/archives/2011/09/23/the-lessons-of-moneyball-for-big-data-analysis/">"The Lessons of Moneyball for Big Data Analysis"</a>. <i>www.datecenterknowledge.com</i><span class="reference-accessdate">. Retrieved <span class="nowrap">12 December</span> 2015</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=www.datecenterknowledge.com&amp;rft.atitle=The+Lessons+of+Moneyball+for+Big+Data+Analysis&amp;rft.au=Rich+Miller&amp;rft_id=http%3A%2F%2Fwww.datacenterknowledge.com%2Farchives%2F2011%2F09%2F23%2Fthe-lessons-of-moneyball-for-big-data-analysis%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-118"><span class="mw-cite-backlink"><b><a href="#cite_ref-118">^</a></b></span> <span class="reference-text"><cite class="citation web">Dave Ryan. <a rel="nofollow" class="external text" href="http://www.huffingtonpost.com/dave-ryan/sports-where-big-data-fin_b_8553884.html">"Sports: Where Big Data Finally Makes Sense"</a>. <i>www.huffingtonpost.com</i><span class="reference-accessdate">. Retrieved <span class="nowrap">12 December</span> 2015</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=www.huffingtonpost.com&amp;rft.atitle=Sports%3A+Where+Big+Data+Finally+Makes+Sense&amp;rft.au=Dave+Ryan&amp;rft_id=http%3A%2F%2Fwww.huffingtonpost.com%2Fdave-ryan%2Fsports-where-big-data-fin_b_8553884.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-119"><span class="mw-cite-backlink"><b><a href="#cite_ref-119">^</a></b></span> <span class="reference-text"><cite class="citation web">Frank Bi. <a rel="nofollow" class="external text" href="https://www.forbes.com/sites/frankbi/2014/11/13/how-formula-one-teams-are-using-big-data-to-get-the-inside-edge//">"How Formula One Teams Are Using Big Data To Get The Inside Edge"</a>. <i>www.forbes.com</i><span class="reference-accessdate">. Retrieved <span class="nowrap">12 December</span> 2015</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=www.forbes.com&amp;rft.atitle=How+Formula+One+Teams+Are+Using+Big+Data+To+Get+The+Inside+Edge&amp;rft.au=Frank+Bi&amp;rft_id=https%3A%2F%2Fwww.forbes.com%2Fsites%2Ffrankbi%2F2014%2F11%2F13%2Fhow-formula-one-teams-are-using-big-data-to-get-the-inside-edge%2F%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-120"><span class="mw-cite-backlink"><b><a href="#cite_ref-120">^</a></b></span> <span class="reference-text"><cite class="citation web">Tay, Liz. <a rel="nofollow" class="external text" href="http://www.itnews.com.au/news/inside-ebay8217s-90pb-data-warehouse-342615">"Inside eBay's 90PB data warehouse"</a>. ITNews<span class="reference-accessdate">. Retrieved <span class="nowrap">2016-02-12</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Inside+eBay%27s+90PB+data+warehouse&amp;rft.pub=ITNews&amp;rft.aulast=Tay&amp;rft.aufirst=Liz&amp;rft_id=http%3A%2F%2Fwww.itnews.com.au%2Fnews%2Finside-ebay8217s-90pb-data-warehouse-342615&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-121"><span class="mw-cite-backlink"><b><a href="#cite_ref-121">^</a></b></span> <span class="reference-text"><cite class="citation web">Layton, Julia. <a rel="nofollow" class="external text" href="http://money.howstuffworks.com/amazon1.htm">"Amazon Technology"</a>. Money.howstuffworks.com<span class="reference-accessdate">. Retrieved <span class="nowrap">2013-03-05</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Amazon+Technology&amp;rft.pub=Money.howstuffworks.com&amp;rft.aulast=Layton&amp;rft.aufirst=Julia&amp;rft_id=http%3A%2F%2Fmoney.howstuffworks.com%2Famazon1.htm&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-122"><span class="mw-cite-backlink"><b><a href="#cite_ref-122">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="https://www.facebook.com/notes/facebook-engineering/scaling-facebook-to-500-million-users-and-beyond/409881258919">"Scaling Facebook to 500 Million Users and Beyond"</a>. Facebook.com<span class="reference-accessdate">. Retrieved <span class="nowrap">2013-07-21</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Scaling+Facebook+to+500+Million+Users+and+Beyond&amp;rft.pub=Facebook.com&amp;rft_id=https%3A%2F%2Fwww.facebook.com%2Fnotes%2Ffacebook-engineering%2Fscaling-facebook-to-500-million-users-and-beyond%2F409881258919&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-123"><span class="mw-cite-backlink"><b><a href="#cite_ref-123">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://searchengineland.com/google-1-trillion-searches-per-year-212940">"Google Still Doing at Least 1 Trillion Searches Per Year"</a>. <i>Search Engine Land</i>. 16 January 2015<span class="reference-accessdate">. Retrieved <span class="nowrap">15 April</span> 2015</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=Search+Engine+Land&amp;rft.atitle=Google+Still+Doing+at+Least+1+Trillion+Searches+Per+Year&amp;rft.date=2015-01-16&amp;rft_id=http%3A%2F%2Fsearchengineland.com%2Fgoogle-1-trillion-searches-per-year-212940&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-124"><span class="mw-cite-backlink"><b><a href="#cite_ref-124">^</a></b></span> <span class="reference-text"><cite class="citation web">Lamb, Charles. <a rel="nofollow" class="external text" href="https://blogs.oracle.com/charlesLamb/entry/oracle_nosql_database_exceeds_1">"Oracle NoSQL Database Exceeds 1 Million Mixed YCSB Ops/Sec"</a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Oracle+NoSQL+Database+Exceeds+1+Million+Mixed+YCSB+Ops%2FSec&amp;rft.aulast=Lamb&amp;rft.aufirst=Charles&amp;rft_id=https%3A%2F%2Fblogs.oracle.com%2FcharlesLamb%2Fentry%2Foracle_nosql_database_exceeds_1&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-125"><span class="mw-cite-backlink"><b><a href="#cite_ref-125">^</a></b></span> <span class="reference-text"><cite class="citation conference">Siwach, Gautam; Esmailpour, Amir (March 2014). <a rel="nofollow" class="external text" href="http://asee-ne.org/proceedings/2014/Student%20Papers/210.pdf"><i>Encrypted Search &amp; Cluster Formation in Big Data</i></a> <span style="font-size:85%;">(PDF)</span>. <a rel="nofollow" class="external text" href="http://ubconferences.org/">ASEE 2014 Zone I Conference</a>. <a href="/wiki/University_of_Bridgeport" title="University of Bridgeport">University of Bridgeport</a>, <a href="/wiki/Bridgeport,_Connecticut" title="Bridgeport, Connecticut">Bridgeport, Connecticut</a>, US.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=conference&amp;rft.btitle=Encrypted+Search+%26+Cluster+Formation+in+Big+Data&amp;rft.place=University+of+Bridgeport%2C+Bridgeport%2C+Connecticut%2C+US&amp;rft.date=2014-03&amp;rft.aulast=Siwach&amp;rft.aufirst=Gautam&amp;rft.au=Esmailpour%2C+Amir&amp;rft_id=http%3A%2F%2Fasee-ne.org%2Fproceedings%2F2014%2FStudent%2520Papers%2F210.pdf&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-126"><span class="mw-cite-backlink"><b><a href="#cite_ref-126">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://www.whitehouse.gov/sites/default/files/microsites/ostp/big_data_press_release_final_2.pdf">"Obama Administration Unveils "Big Data" Initiative:Announces $200 Million In New R&amp;D Investments"</a> <span style="font-size:85%;">(PDF)</span>. The White House.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Obama+Administration+Unveils+%22Big+Data%22+Initiative%3AAnnounces+%24200+Million+In+New+R%26D+Investments&amp;rft.pub=The+White+House&amp;rft_id=http%3A%2F%2Fwww.whitehouse.gov%2Fsites%2Fdefault%2Ffiles%2Fmicrosites%2Fostp%2Fbig_data_press_release_final_2.pdf&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-127"><span class="mw-cite-backlink"><b><a href="#cite_ref-127">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://amplab.cs.berkeley.edu">"AMPLab at the University of California, Berkeley"</a>. Amplab.cs.berkeley.edu<span class="reference-accessdate">. Retrieved <span class="nowrap">2013-03-05</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=AMPLab+at+the+University+of+California%2C+Berkeley&amp;rft.pub=Amplab.cs.berkeley.edu&amp;rft_id=http%3A%2F%2Famplab.cs.berkeley.edu&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-128"><span class="mw-cite-backlink"><b><a href="#cite_ref-128">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://www.nsf.gov/news/news_summ.jsp?cntn_id=123607&amp;org=NSF&amp;from=news">"NSF Leads Federal Efforts in Big Data"</a>. National Science Foundation (NSF). 29 March 2012.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=NSF+Leads+Federal+Efforts+in+Big+Data&amp;rft.pub=National+Science+Foundation+%28NSF%29&amp;rft.date=2012-03-29&amp;rft_id=http%3A%2F%2Fwww.nsf.gov%2Fnews%2Fnews_summ.jsp%3Fcntn_id%3D123607%26org%3DNSF%26from%3Dnews&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-129"><span class="mw-cite-backlink"><b><a href="#cite_ref-129">^</a></b></span> <span class="reference-text"><cite class="citation conference">Timothy Hunter; Teodor Moldovan; Matei Zaharia; Justin Ma; Michael Franklin; Pieter Abbeel; Alexandre Bayen (October 2011). <a rel="nofollow" class="external text" href="https://amplab.cs.berkeley.edu/publication/scaling-the-mobile-millennium-system-in-the-cloud-2/"><i>Scaling the Mobile Millennium System in the Cloud</i></a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=conference&amp;rft.btitle=Scaling+the+Mobile+Millennium+System+in+the+Cloud&amp;rft.date=2011-10&amp;rft.au=Timothy+Hunter&amp;rft.au=Teodor+Moldovan&amp;rft.au=Matei+Zaharia&amp;rft.au=Justin+Ma&amp;rft.au=Michael+Franklin&amp;rft.au=Pieter+Abbeel&amp;rft.au=Alexandre+Bayen&amp;rft_id=https%3A%2F%2Famplab.cs.berkeley.edu%2Fpublication%2Fscaling-the-mobile-millennium-system-in-the-cloud-2%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-130"><span class="mw-cite-backlink"><b><a href="#cite_ref-130">^</a></b></span> <span class="reference-text"><cite class="citation news">David Patterson (5 December 2011). <a rel="nofollow" class="external text" href="https://www.nytimes.com/2011/12/06/science/david-patterson-enlist-computer-scientists-in-cancer-fight.html?_r=0">"Computer Scientists May Have What It Takes to Help Cure Cancer"</a>. The New York Times.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.atitle=Computer+Scientists+May+Have+What+It+Takes+to+Help+Cure+Cancer&amp;rft.date=2011-12-05&amp;rft.au=David+Patterson&amp;rft_id=https%3A%2F%2Fwww.nytimes.com%2F2011%2F12%2F06%2Fscience%2Fdavid-patterson-enlist-computer-scientists-in-cancer-fight.html%3F_r%3D0&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-131"><span class="mw-cite-backlink"><b><a href="#cite_ref-131">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://energy.gov/articles/secretary-chu-announces-new-institute-help-scientists-improve-massive-data-set-research-doe">"Secretary Chu Announces New Institute to Help Scientists Improve Massive Data Set Research on DOE Supercomputers"</a>. "energy.gov".</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Secretary+Chu+Announces+New+Institute+to+Help+Scientists+Improve+Massive+Data+Set+Research+on+DOE+Supercomputers&amp;rft.pub=%22energy.gov%22&amp;rft_id=http%3A%2F%2Fenergy.gov%2Farticles%2Fsecretary-chu-announces-new-institute-help-scientists-improve-massive-data-set-research-doe&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-132"><span class="mw-cite-backlink"><b><a href="#cite_ref-132">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://www.mass.gov/governor/pressoffice/pressreleases/2012/2012530-governor-announces-big-data-initiative.html">"Governor Patrick announces new initiative to strengthen Massachusetts' position as a World leader in Big Data"</a>. Commonwealth of Massachusetts.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Governor+Patrick+announces+new+initiative+to+strengthen+Massachusetts%27+position+as+a+World+leader+in+Big+Data&amp;rft.pub=Commonwealth+of+Massachusetts&amp;rft_id=http%3A%2F%2Fwww.mass.gov%2Fgovernor%2Fpressoffice%2Fpressreleases%2F2012%2F2012530-governor-announces-big-data-initiative.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-133"><span class="mw-cite-backlink"><b><a href="#cite_ref-133">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://bigdata.csail.mit.edu/">"Big Data @ CSAIL"</a>. Bigdata.csail.mit.edu. 22 February 2013<span class="reference-accessdate">. Retrieved <span class="nowrap">2013-03-05</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Big+Data+%40+CSAIL&amp;rft.pub=Bigdata.csail.mit.edu&amp;rft.date=2013-02-22&amp;rft_id=http%3A%2F%2Fbigdata.csail.mit.edu%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-134"><span class="mw-cite-backlink"><b><a href="#cite_ref-134">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://cordis.europa.eu/search/index.cfm?fuseaction=proj.document&amp;PJ_RCN=13267529">"Big Data Public Private Forum"</a>. Cordis.europa.eu. 1 September 2012<span class="reference-accessdate">. Retrieved <span class="nowrap">2013-03-05</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Big+Data+Public+Private+Forum&amp;rft.pub=Cordis.europa.eu&amp;rft.date=2012-09-01&amp;rft_id=http%3A%2F%2Fcordis.europa.eu%2Fsearch%2Findex.cfm%3Ffuseaction%3Dproj.document%26PJ_RCN%3D13267529&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-135"><span class="mw-cite-backlink"><b><a href="#cite_ref-135">^</a></b></span> <span class="reference-text"><cite class="citation news"><a rel="nofollow" class="external text" href="http://www.bbc.co.uk/news/technology-26651179">"Alan Turing Institute to be set up to research big data"</a>. <a href="/wiki/BBC_News" title="BBC News">BBC News</a>. 19 March 2014<span class="reference-accessdate">. Retrieved <span class="nowrap">2014-03-19</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.atitle=Alan+Turing+Institute+to+be+set+up+to+research+big+data&amp;rft.date=2014-03-19&amp;rft_id=http%3A%2F%2Fwww.bbc.co.uk%2Fnews%2Ftechnology-26651179&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-136"><span class="mw-cite-backlink"><b><a href="#cite_ref-136">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://www.betakit.com/event/inspiration-day-at-university-of-waterloo-stratford-campus/">"Inspiration day at University of Waterloo, Stratford Campus"</a>. betakit.com/<span class="reference-accessdate">. Retrieved <span class="nowrap">2014-02-28</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Inspiration+day+at+University+of+Waterloo%2C+Stratford+Campus&amp;rft.pub=betakit.com%2F&amp;rft_id=http%3A%2F%2Fwww.betakit.com%2Fevent%2Finspiration-day-at-university-of-waterloo-stratford-campus%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-137"><span class="mw-cite-backlink"><b><a href="#cite_ref-137">^</a></b></span> <span class="reference-text"><cite class="citation journal">Lee, Jay; Lapira, Edzel; Bagheri, Behrad; Kao, Hung-An (2013). <a rel="nofollow" class="external text" href="http://www.sciencedirect.com/science/article/pii/S2213846313000114">"Recent Advances and Trends in Predictive Manufacturing Systems in Big Data Environment"</a>. <i>Manufacturing Letters</i>. <b>1</b> (1): 38–41. <a href="/wiki/Digital_object_identifier" title="Digital object identifier">doi</a>:<a rel="nofollow" class="external text" href="//doi.org/10.1016%2Fj.mfglet.2013.09.005">10.1016/j.mfglet.2013.09.005</a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Manufacturing+Letters&amp;rft.atitle=Recent+Advances+and+Trends+in+Predictive+Manufacturing+Systems+in+Big+Data+Environment&amp;rft.volume=1&amp;rft.issue=1&amp;rft.pages=38-41&amp;rft.date=2013&amp;rft_id=info%3Adoi%2F10.1016%2Fj.mfglet.2013.09.005&amp;rft.aulast=Lee&amp;rft.aufirst=Jay&amp;rft.au=Lapira%2C+Edzel&amp;rft.au=Bagheri%2C+Behrad&amp;rft.au=Kao%2C+Hung-An&amp;rft_id=http%3A%2F%2Fwww.sciencedirect.com%2Fscience%2Farticle%2Fpii%2FS2213846313000114&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-pigdata-138"><span class="mw-cite-backlink">^ <a href="#cite_ref-pigdata_138-0"><sup><i><b>a</b></i></sup></a> <a href="#cite_ref-pigdata_138-1"><sup><i><b>b</b></i></sup></a> <a href="#cite_ref-pigdata_138-2"><sup><i><b>c</b></i></sup></a></span> <span class="reference-text"><cite class="citation journal">Reips, Ulf-Dietrich; Matzat, Uwe (2014). <a rel="nofollow" class="external text" href="http://www.ijis.net/ijis9_1/ijis9_1_editorial_pre.html">"Mining "Big Data" using Big Data Services"</a>. <i>International Journal of Internet Science</i>. <b>1</b> (1): 1–8.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=International+Journal+of+Internet+Science&amp;rft.atitle=Mining+%22Big+Data%22+using+Big+Data+Services&amp;rft.volume=1&amp;rft.issue=1&amp;rft.pages=1-8&amp;rft.date=2014&amp;rft.aulast=Reips&amp;rft.aufirst=Ulf-Dietrich&amp;rft.au=Matzat%2C+Uwe&amp;rft_id=http%3A%2F%2Fwww.ijis.net%2Fijis9_1%2Fijis9_1_editorial_pre.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-139"><span class="mw-cite-backlink"><b><a href="#cite_ref-139">^</a></b></span> <span class="reference-text"><cite class="citation journal">Preis, Tobias; Moat,, Helen Susannah; Stanley, H. Eugene; Bishop, Steven R. (2012). <a rel="nofollow" class="external text" href="//www.ncbi.nlm.nih.gov/pmc/articles/PMC3320057">"Quantifying the Advantage of Looking Forward"</a>. <i>Scientific Reports</i>. <b>2</b>: 350. <a href="/wiki/Digital_object_identifier" title="Digital object identifier">doi</a>:<a rel="nofollow" class="external text" href="//doi.org/10.1038%2Fsrep00350">10.1038/srep00350</a>. <a href="/wiki/PubMed_Central" title="PubMed Central">PMC</a>&#160;<span class="plainlinks"><a rel="nofollow" class="external text" href="//www.ncbi.nlm.nih.gov/pmc/articles/PMC3320057">3320057</a> <img alt="Freely accessible" src="//upload.wikimedia.org/wikipedia/commons/thumb/6/65/Lock-green.svg/9px-Lock-green.svg.png" title="Freely accessible" width="9" height="14" srcset="//upload.wikimedia.org/wikipedia/commons/thumb/6/65/Lock-green.svg/14px-Lock-green.svg.png 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/6/65/Lock-green.svg/18px-Lock-green.svg.png 2x" data-file-width="512" data-file-height="813" /></span>. <a href="/wiki/PubMed_Identifier" class="mw-redirect" title="PubMed Identifier">PMID</a>&#160;<a rel="nofollow" class="external text" href="//www.ncbi.nlm.nih.gov/pubmed/22482034">22482034</a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Scientific+Reports&amp;rft.atitle=Quantifying+the+Advantage+of+Looking+Forward&amp;rft.volume=2&amp;rft.pages=350&amp;rft.date=2012&amp;rft_id=%2F%2Fwww.ncbi.nlm.nih.gov%2Fpmc%2Farticles%2FPMC3320057&amp;rft_id=info%3Apmid%2F22482034&amp;rft_id=info%3Adoi%2F10.1038%2Fsrep00350&amp;rft.aulast=Preis&amp;rft.aufirst=Tobias&amp;rft.au=Moat%2C%2C+Helen+Susannah&amp;rft.au=Stanley%2C+H.+Eugene&amp;rft.au=Bishop%2C+Steven+R.&amp;rft_id=%2F%2Fwww.ncbi.nlm.nih.gov%2Fpmc%2Farticles%2FPMC3320057&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-140"><span class="mw-cite-backlink"><b><a href="#cite_ref-140">^</a></b></span> <span class="reference-text"><cite class="citation web">Marks, Paul (5 April 2012). <a rel="nofollow" class="external text" href="https://www.newscientist.com/article/dn21678-online-searches-for-future-linked-to-economic-success.html">"Online searches for future linked to economic success"</a>. <i>New Scientist</i><span class="reference-accessdate">. Retrieved <span class="nowrap">9 April</span> 2012</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=New+Scientist&amp;rft.atitle=Online+searches+for+future+linked+to+economic+success&amp;rft.date=2012-04-05&amp;rft.aulast=Marks&amp;rft.aufirst=Paul&amp;rft_id=https%3A%2F%2Fwww.newscientist.com%2Farticle%2Fdn21678-online-searches-for-future-linked-to-economic-success.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-141"><span class="mw-cite-backlink"><b><a href="#cite_ref-141">^</a></b></span> <span class="reference-text"><cite class="citation web">Johnston, Casey (6 April 2012). <a rel="nofollow" class="external text" href="https://arstechnica.com/gadgets/news/2012/04/google-trends-reveals-clues-about-the-mentality-of-richer-nations.ars">"Google Trends reveals clues about the mentality of richer nations"</a>. <i>Ars Technica</i><span class="reference-accessdate">. Retrieved <span class="nowrap">9 April</span> 2012</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=Ars+Technica&amp;rft.atitle=Google+Trends+reveals+clues+about+the+mentality+of+richer+nations&amp;rft.date=2012-04-06&amp;rft.aulast=Johnston&amp;rft.aufirst=Casey&amp;rft_id=https%3A%2F%2Farstechnica.com%2Fgadgets%2Fnews%2F2012%2F04%2Fgoogle-trends-reveals-clues-about-the-mentality-of-richer-nations.ars&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-142"><span class="mw-cite-backlink"><b><a href="#cite_ref-142">^</a></b></span> <span class="reference-text"><cite class="citation web">Tobias Preis (24 May 2012). <a rel="nofollow" class="external text" href="http://www.tobiaspreis.de/bigdata/future_orientation_index.pdf">"Supplementary Information: The Future Orientation Index is available for download"</a> <span style="font-size:85%;">(PDF)</span><span class="reference-accessdate">. Retrieved <span class="nowrap">2012-05-24</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Supplementary+Information%3A+The+Future+Orientation+Index+is+available+for+download&amp;rft.date=2012-05-24&amp;rft.au=Tobias+Preis&amp;rft_id=http%3A%2F%2Fwww.tobiaspreis.de%2Fbigdata%2Ffuture_orientation_index.pdf&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-143"><span class="mw-cite-backlink"><b><a href="#cite_ref-143">^</a></b></span> <span class="reference-text"><cite class="citation web"><a href="/wiki/Philip_Ball" title="Philip Ball">Philip Ball</a> (26 April 2013). <a rel="nofollow" class="external text" href="http://www.nature.com/news/counting-google-searches-predicts-market-movements-1.12879">"Counting Google searches predicts market movements"</a>. <i>Nature</i><span class="reference-accessdate">. Retrieved <span class="nowrap">9 August</span> 2013</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=Nature&amp;rft.atitle=Counting+Google+searches+predicts+market+movements&amp;rft.date=2013-04-26&amp;rft.au=Philip+Ball&amp;rft_id=http%3A%2F%2Fwww.nature.com%2Fnews%2Fcounting-google-searches-predicts-market-movements-1.12879&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-144"><span class="mw-cite-backlink"><b><a href="#cite_ref-144">^</a></b></span> <span class="reference-text"><cite class="citation journal">Tobias Preis, Helen Susannah Moat and H. Eugene Stanley (2013). <a rel="nofollow" class="external text" href="//www.ncbi.nlm.nih.gov/pmc/articles/PMC3635219">"Quantifying Trading Behavior in Financial Markets Using Google Trends"</a>. <i><a href="/wiki/Scientific_Reports" title="Scientific Reports">Scientific Reports</a></i>. <b>3</b>: 1684. <a href="/wiki/Digital_object_identifier" title="Digital object identifier">doi</a>:<a rel="nofollow" class="external text" href="//doi.org/10.1038%2Fsrep01684">10.1038/srep01684</a>. <a href="/wiki/PubMed_Central" title="PubMed Central">PMC</a>&#160;<span class="plainlinks"><a rel="nofollow" class="external text" href="//www.ncbi.nlm.nih.gov/pmc/articles/PMC3635219">3635219</a> <img alt="Freely accessible" src="//upload.wikimedia.org/wikipedia/commons/thumb/6/65/Lock-green.svg/9px-Lock-green.svg.png" title="Freely accessible" width="9" height="14" srcset="//upload.wikimedia.org/wikipedia/commons/thumb/6/65/Lock-green.svg/14px-Lock-green.svg.png 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/6/65/Lock-green.svg/18px-Lock-green.svg.png 2x" data-file-width="512" data-file-height="813" /></span>. <a href="/wiki/PubMed_Identifier" class="mw-redirect" title="PubMed Identifier">PMID</a>&#160;<a rel="nofollow" class="external text" href="//www.ncbi.nlm.nih.gov/pubmed/23619126">23619126</a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Scientific+Reports&amp;rft.atitle=Quantifying+Trading+Behavior+in+Financial+Markets+Using+Google+Trends&amp;rft.volume=3&amp;rft.pages=1684&amp;rft.date=2013&amp;rft_id=%2F%2Fwww.ncbi.nlm.nih.gov%2Fpmc%2Farticles%2FPMC3635219&amp;rft_id=info%3Apmid%2F23619126&amp;rft_id=info%3Adoi%2F10.1038%2Fsrep01684&amp;rft.au=Tobias+Preis%2C+Helen+Susannah+Moat+and+H.+Eugene+Stanley&amp;rft_id=%2F%2Fwww.ncbi.nlm.nih.gov%2Fpmc%2Farticles%2FPMC3635219&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-145"><span class="mw-cite-backlink"><b><a href="#cite_ref-145">^</a></b></span> <span class="reference-text"><cite class="citation news">Nick Bilton (26 April 2013). <a rel="nofollow" class="external text" href="http://bits.blogs.nytimes.com/2013/04/26/google-search-terms-can-predict-stock-market-study-finds/">"Google Search Terms Can Predict Stock Market, Study Finds"</a>. <i><a href="/wiki/New_York_Times" class="mw-redirect" title="New York Times">New York Times</a></i><span class="reference-accessdate">. Retrieved <span class="nowrap">9 August</span> 2013</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=New+York+Times&amp;rft.atitle=Google+Search+Terms+Can+Predict+Stock+Market%2C+Study+Finds&amp;rft.date=2013-04-26&amp;rft.au=Nick+Bilton&amp;rft_id=http%3A%2F%2Fbits.blogs.nytimes.com%2F2013%2F04%2F26%2Fgoogle-search-terms-can-predict-stock-market-study-finds%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-146"><span class="mw-cite-backlink"><b><a href="#cite_ref-146">^</a></b></span> <span class="reference-text"><cite class="citation news">Christopher Matthews (26 April 2013). <a rel="nofollow" class="external text" href="http://business.time.com/2013/04/26/trouble-with-your-investment-portfolio-google-it/">"Trouble With Your Investment Portfolio? Google It!"</a>. <i><a href="/wiki/TIME_Magazine" class="mw-redirect" title="TIME Magazine">TIME Magazine</a></i><span class="reference-accessdate">. Retrieved <span class="nowrap">9 August</span> 2013</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=TIME+Magazine&amp;rft.atitle=Trouble+With+Your+Investment+Portfolio%3F+Google+It%21&amp;rft.date=2013-04-26&amp;rft.au=Christopher+Matthews&amp;rft_id=http%3A%2F%2Fbusiness.time.com%2F2013%2F04%2F26%2Ftrouble-with-your-investment-portfolio-google-it%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-147"><span class="mw-cite-backlink"><b><a href="#cite_ref-147">^</a></b></span> <span class="reference-text"><cite class="citation web">Philip Ball (26 April 2013). <a rel="nofollow" class="external text" href="http://www.nature.com/news/counting-google-searches-predicts-market-movements-1.12879">"Counting Google searches predicts market movements"</a>. <i><a href="/wiki/Nature_(journal)" title="Nature (journal)">Nature</a></i><span class="reference-accessdate">. Retrieved <span class="nowrap">9 August</span> 2013</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=Nature&amp;rft.atitle=Counting+Google+searches+predicts+market+movements&amp;rft.date=2013-04-26&amp;rft.au=Philip+Ball&amp;rft_id=http%3A%2F%2Fwww.nature.com%2Fnews%2Fcounting-google-searches-predicts-market-movements-1.12879&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-148"><span class="mw-cite-backlink"><b><a href="#cite_ref-148">^</a></b></span> <span class="reference-text"><cite class="citation web">Bernhard Warner (25 April 2013). <a rel="nofollow" class="external text" href="http://www.businessweek.com/articles/2013-04-25/big-data-researchers-turn-to-google-to-beat-the-markets">"<span style="padding-left:0.2em;">'</span>Big Data' Researchers Turn to Google to Beat the Markets"</a>. <i><a href="/wiki/Bloomberg_Businessweek" title="Bloomberg Businessweek">Bloomberg Businessweek</a></i><span class="reference-accessdate">. Retrieved <span class="nowrap">9 August</span> 2013</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=Bloomberg+Businessweek&amp;rft.atitle=%27Big+Data%27+Researchers+Turn+to+Google+to+Beat+the+Markets&amp;rft.date=2013-04-25&amp;rft.au=Bernhard+Warner&amp;rft_id=http%3A%2F%2Fwww.businessweek.com%2Farticles%2F2013-04-25%2Fbig-data-researchers-turn-to-google-to-beat-the-markets&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-149"><span class="mw-cite-backlink"><b><a href="#cite_ref-149">^</a></b></span> <span class="reference-text"><cite class="citation news">Hamish McRae (28 April 2013). <a rel="nofollow" class="external text" href="https://www.independent.co.uk/news/business/comment/hamish-mcrae/hamish-mcrae-need-a-valuable-handle-on-investor-sentiment-google-it-8590991.html">"Hamish McRae: Need a valuable handle on investor sentiment? Google it"</a>. <i><a href="/wiki/The_Independent" title="The Independent">The Independent</a></i>. London<span class="reference-accessdate">. Retrieved <span class="nowrap">9 August</span> 2013</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=The+Independent&amp;rft.atitle=Hamish+McRae%3A+Need+a+valuable+handle+on+investor+sentiment%3F+Google+it&amp;rft.date=2013-04-28&amp;rft.au=Hamish+McRae&amp;rft_id=https%3A%2F%2Fwww.independent.co.uk%2Fnews%2Fbusiness%2Fcomment%2Fhamish-mcrae%2Fhamish-mcrae-need-a-valuable-handle-on-investor-sentiment-google-it-8590991.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-150"><span class="mw-cite-backlink"><b><a href="#cite_ref-150">^</a></b></span> <span class="reference-text"><cite class="citation web">Richard Waters (25 April 2013). <a rel="nofollow" class="external text" href="http://www.ft.com/intl/cms/s/0/e5d959b8-acf2-11e2-b27f-00144feabdc0.html">"Google search proves to be new word in stock market prediction"</a>. <i><a href="/wiki/Financial_Times" title="Financial Times">Financial Times</a></i><span class="reference-accessdate">. Retrieved <span class="nowrap">9 August</span> 2013</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=Financial+Times&amp;rft.atitle=Google+search+proves+to+be+new+word+in+stock+market+prediction&amp;rft.date=2013-04-25&amp;rft.au=Richard+Waters&amp;rft_id=http%3A%2F%2Fwww.ft.com%2Fintl%2Fcms%2Fs%2F0%2Fe5d959b8-acf2-11e2-b27f-00144feabdc0.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-151"><span class="mw-cite-backlink"><b><a href="#cite_ref-151">^</a></b></span> <span class="reference-text"><cite class="citation news">David Leinweber (26 April 2013). <a rel="nofollow" class="external text" href="https://www.forbes.com/sites/davidleinweber/2013/04/26/big-data-gets-bigger-now-google-trends-can-predict-the-market/">"Big Data Gets Bigger: Now Google Trends Can Predict The Market"</a>. <i><a href="/wiki/Forbes" title="Forbes">Forbes</a></i><span class="reference-accessdate">. Retrieved <span class="nowrap">9 August</span> 2013</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Forbes&amp;rft.atitle=Big+Data+Gets+Bigger%3A+Now+Google+Trends+Can+Predict+The+Market&amp;rft.date=2013-04-26&amp;rft.au=David+Leinweber&amp;rft_id=https%3A%2F%2Fwww.forbes.com%2Fsites%2Fdavidleinweber%2F2013%2F04%2F26%2Fbig-data-gets-bigger-now-google-trends-can-predict-the-market%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-152"><span class="mw-cite-backlink"><b><a href="#cite_ref-152">^</a></b></span> <span class="reference-text"><cite class="citation news">Jason Palmer (25 April 2013). <a rel="nofollow" class="external text" href="http://www.bbc.co.uk/news/science-environment-22293693">"Google searches predict market moves"</a>. <i><a href="/wiki/BBC" title="BBC">BBC</a></i><span class="reference-accessdate">. Retrieved <span class="nowrap">9 August</span> 2013</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=BBC&amp;rft.atitle=Google+searches+predict+market+moves&amp;rft.date=2013-04-25&amp;rft.au=Jason+Palmer&amp;rft_id=http%3A%2F%2Fwww.bbc.co.uk%2Fnews%2Fscience-environment-22293693&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-153"><span class="mw-cite-backlink"><b><a href="#cite_ref-153">^</a></b></span> <span class="reference-text">E. Sejdić, "Adapt current tools for use with big data," <i>Nature,</i> vol. vol. 507, no. 7492, pp. 306, Mar. 2014.</span></li>
<li id="cite_note-154"><span class="mw-cite-backlink"><b><a href="#cite_ref-154">^</a></b></span> <span class="reference-text">Stanford. <a rel="nofollow" class="external text" href="http://web.stanford.edu/group/mmds/">"MMDS. Workshop on Algorithms for Modern Massive Data Sets"</a>.</span></li>
<li id="cite_note-155"><span class="mw-cite-backlink"><b><a href="#cite_ref-155">^</a></b></span> <span class="reference-text"><cite class="citation conference">Deepan Palguna; Vikas Joshi; Venkatesan Chakaravarthy; Ravi Kothari &amp; L. V. Subramaniam (2015). <i>Analysis of Sampling Algorithms for Twitter</i>. <i><a href="/wiki/International_Joint_Conference_on_Artificial_Intelligence" title="International Joint Conference on Artificial Intelligence">International Joint Conference on Artificial Intelligence</a></i>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=conference&amp;rft.jtitle=International+Joint+Conference+on+Artificial+Intelligence&amp;rft.atitle=Analysis+of+Sampling+Algorithms+for+Twitter&amp;rft.date=2015&amp;rft.au=Deepan+Palguna&amp;rft.au=Vikas+Joshi&amp;rft.au=Venkatesan+Chakaravarthy&amp;rft.au=Ravi+Kothari&amp;rft.au=L.+V.+Subramaniam&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-156"><span class="mw-cite-backlink"><b><a href="#cite_ref-156">^</a></b></span> <span class="reference-text"><cite class="citation journal">Kimble, C.; Milolidakis, G. (2015). "Big Data and Business Intelligence: Debunking the Myths". <i>Global Business and Organizational Excellence</i>. <b>35</b> (1): 23–34. <a href="/wiki/Digital_object_identifier" title="Digital object identifier">doi</a>:<a rel="nofollow" class="external text" href="//doi.org/10.1002%2Fjoe.21642">10.1002/joe.21642</a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Global+Business+and+Organizational+Excellence&amp;rft.atitle=Big+Data+and+Business+Intelligence%3A+Debunking+the+Myths&amp;rft.volume=35&amp;rft.issue=1&amp;rft.pages=23-34&amp;rft.date=2015&amp;rft_id=info%3Adoi%2F10.1002%2Fjoe.21642&amp;rft.aulast=Kimble&amp;rft.aufirst=C.&amp;rft.au=Milolidakis%2C+G.&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-157"><span class="mw-cite-backlink"><b><a href="#cite_ref-157">^</a></b></span> <span class="reference-text"><cite class="citation web">Chris Anderson (23 June 2008). <a rel="nofollow" class="external text" href="https://www.wired.com/science/discoveries/magazine/16-07/pb_theory">"The End of Theory: The Data Deluge Makes the Scientific Method Obsolete"</a>. <i>WIRED</i>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=WIRED&amp;rft.atitle=The+End+of+Theory%3A+The+Data+Deluge+Makes+the+Scientific+Method+Obsolete&amp;rft.date=2008-06-23&amp;rft.au=Chris+Anderson&amp;rft_id=https%3A%2F%2Fwww.wired.com%2Fscience%2Fdiscoveries%2Fmagazine%2F16-07%2Fpb_theory&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-158"><span class="mw-cite-backlink"><b><a href="#cite_ref-158">^</a></b></span> <span class="reference-text"><cite class="citation news">Graham M. (9 March 2012). <a rel="nofollow" class="external text" href="https://www.theguardian.com/news/datablog/2012/mar/09/big-data-theory">"Big data and the end of theory?"</a>. <i>The Guardian</i>. London.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=The+Guardian&amp;rft.atitle=Big+data+and+the+end+of+theory%3F&amp;rft.date=2012-03-09&amp;rft.au=Graham+M.&amp;rft_id=https%3A%2F%2Fwww.theguardian.com%2Fnews%2Fdatablog%2F2012%2Fmar%2F09%2Fbig-data-theory&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-159"><span class="mw-cite-backlink"><b><a href="#cite_ref-159">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://hbr.org/2012/04/good-data-wont-guarantee-good-decisions/ar/1">"Good Data Won't Guarantee Good Decisions. Harvard Business Review"</a>. <i>Shah, Shvetank; Horne, Andrew; Capellá, Jaime;</i>. HBR.org<span class="reference-accessdate">. Retrieved <span class="nowrap">8 September</span> 2012</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=Shah%2C+Shvetank%3B+Horne%2C+Andrew%3B+Capell%C3%A1%2C+Jaime%3B&amp;rft.atitle=Good+Data+Won%27t+Guarantee+Good+Decisions.+Harvard+Business+Review&amp;rft_id=http%3A%2F%2Fhbr.org%2F2012%2F04%2Fgood-data-wont-guarantee-good-decisions%2Far%2F1&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-HilbertTEDx-160"><span class="mw-cite-backlink">^ <a href="#cite_ref-HilbertTEDx_160-0"><sup><i><b>a</b></i></sup></a> <a href="#cite_ref-HilbertTEDx_160-1"><sup><i><b>b</b></i></sup></a></span> <span class="reference-text"><a rel="nofollow" class="external text" href="https://www.youtube.com/watch?v=UXef6yfJZAI">Big Data requires Big Visions for Big Change.</a>, Hilbert, M. (2014). London: TEDxUCL, x=independently organized TED talks</span></li>
<li id="cite_note-161"><span class="mw-cite-backlink"><b><a href="#cite_ref-161">^</a></b></span> <span class="reference-text"><cite class="citation web">Jonathan Rauch (1 April 2002). <a rel="nofollow" class="external text" href="https://www.theatlantic.com/magazine/archive/2002/04/seeing-around-corners/302471/">"Seeing Around Corners"</a>. <i>The Atlantic</i>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=The+Atlantic&amp;rft.atitle=Seeing+Around+Corners&amp;rft.date=2002-04-01&amp;rft.au=Jonathan+Rauch&amp;rft_id=https%3A%2F%2Fwww.theatlantic.com%2Fmagazine%2Farchive%2F2002%2F04%2Fseeing-around-corners%2F302471%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-162"><span class="mw-cite-backlink"><b><a href="#cite_ref-162">^</a></b></span> <span class="reference-text">Epstein, J. M., &amp; Axtell, R. L. (1996). Growing Artificial Societies: Social Science from the Bottom Up. A Bradford Book.</span></li>
<li id="cite_note-163"><span class="mw-cite-backlink"><b><a href="#cite_ref-163">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://www.bigdataparis.com/documents/Pierre-Delort-INSERM.pdf#page=5">"Delort P., Big data in Biosciences, Big Data Paris, 2012"</a> <span style="font-size:85%;">(PDF)</span>. <i>Bigdataparis.com</i><span class="reference-accessdate">. Retrieved <span class="nowrap">8 October</span> 2017</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=Bigdataparis.com&amp;rft.atitle=Delort+P.%2C+Big+data+in+Biosciences%2C+Big+Data+Paris%2C+2012&amp;rft_id=http%3A%2F%2Fwww.bigdataparis.com%2Fdocuments%2FPierre-Delort-INSERM.pdf%23page%3D5&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-164"><span class="mw-cite-backlink"><b><a href="#cite_ref-164">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="http://www.cs.cmu.edu/~durand/03-711/2011/Literature/Next-Gen-Genomics-NRG-2010.pdf">"Next-generation genomics: an integrative approach"</a> <span style="font-size:85%;">(PDF)</span>. nature. July 2010<span class="reference-accessdate">. Retrieved <span class="nowrap">18 October</span> 2016</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Next-generation+genomics%3A+an+integrative+approach&amp;rft.pub=nature&amp;rft.date=2010-07&amp;rft_id=http%3A%2F%2Fwww.cs.cmu.edu%2F~durand%2F03-711%2F2011%2FLiterature%2FNext-Gen-Genomics-NRG-2010.pdf&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-165"><span class="mw-cite-backlink"><b><a href="#cite_ref-165">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="https://www.researchgate.net/publication/283298499_BIG_DATA_IN_BIOSCIENCES">"BIG DATA IN BIOSCIENCES"</a>. ResearchGate. October 2015<span class="reference-accessdate">. Retrieved <span class="nowrap">18 October</span> 2016</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=BIG+DATA+IN+BIOSCIENCES&amp;rft.pub=ResearchGate&amp;rft.date=2015-10&amp;rft_id=https%3A%2F%2Fwww.researchgate.net%2Fpublication%2F283298499_BIG_DATA_IN_BIOSCIENCES&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-166"><span class="mw-cite-backlink"><b><a href="#cite_ref-166">^</a></b></span> <span class="reference-text"><cite class="citation web"><a rel="nofollow" class="external text" href="https://next.ft.com/content/21a6e7d8-b479-11e3-a09a-00144feabdc0">"Big data: are we making a big mistake?"</a>. Financial Times. 28 March 2014<span class="reference-accessdate">. Retrieved <span class="nowrap">20 October</span> 2016</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Big+data%3A+are+we+making+a+big+mistake%3F&amp;rft.pub=Financial+Times&amp;rft.date=2014-03-28&amp;rft_id=https%3A%2F%2Fnext.ft.com%2Fcontent%2F21a6e7d8-b479-11e3-a09a-00144feabdc0&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-167"><span class="mw-cite-backlink"><b><a href="#cite_ref-167">^</a></b></span> <span class="reference-text"><cite class="citation web">Ohm, Paul. <a rel="nofollow" class="external text" href="http://blogs.hbr.org/cs/2012/08/dont_build_a_database_of_ruin.html">"Don't Build a Database of Ruin"</a>. Harvard Business Review.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Don%27t+Build+a+Database+of+Ruin&amp;rft.pub=Harvard+Business+Review&amp;rft.aulast=Ohm&amp;rft.aufirst=Paul&amp;rft_id=http%3A%2F%2Fblogs.hbr.org%2Fcs%2F2012%2F08%2Fdont_build_a_database_of_ruin.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-168"><span class="mw-cite-backlink"><b><a href="#cite_ref-168">^</a></b></span> <span class="reference-text">Darwin Bond-Graham, <i><a rel="nofollow" class="external text" href="http://www.counterpunch.org/2013/12/03/iron-cagebook/">Iron Cagebook – The Logical End of Facebook's Patents</a>,</i> <a href="/wiki/Counterpunch.org" class="mw-redirect" title="Counterpunch.org">Counterpunch.org</a>, 2013.12.03</span></li>
<li id="cite_note-169"><span class="mw-cite-backlink"><b><a href="#cite_ref-169">^</a></b></span> <span class="reference-text">Darwin Bond-Graham, <i><a rel="nofollow" class="external text" href="http://www.counterpunch.org/2013/09/11/inside-the-tech-industrys-startup-conference/">Inside the Tech industry’s Startup Conference</a>,</i> <a href="/wiki/Counterpunch.org" class="mw-redirect" title="Counterpunch.org">Counterpunch.org</a>, 2013.09.11</span></li>
<li id="cite_note-170"><span class="mw-cite-backlink"><b><a href="#cite_ref-170">^</a></b></span> <span class="reference-text"><cite class="citation news">Al-Rodhan, Nayef (2014-09-16). <a rel="nofollow" class="external text" href="http://hir.harvard.edu/the-social-contract-2-0-big-data-and-the-need-to-guarantee-privacy-and-civil-liberties/">"The Social Contract 2.0: Big Data and the Need to Guarantee Privacy and Civil Liberties – Harvard International Review"</a>. <i>Harvard International Review</i><span class="reference-accessdate">. Retrieved <span class="nowrap">2017-04-03</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Harvard+International+Review&amp;rft.atitle=The+Social+Contract+2.0%3A+Big+Data+and+the+Need+to+Guarantee+Privacy+and+Civil+Liberties+%E2%80%93+Harvard+International+Review&amp;rft.date=2014-09-16&amp;rft.aulast=Al-Rodhan&amp;rft.aufirst=Nayef&amp;rft_id=http%3A%2F%2Fhir.harvard.edu%2Fthe-social-contract-2-0-big-data-and-the-need-to-guarantee-privacy-and-civil-liberties%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-171"><span class="mw-cite-backlink"><b><a href="#cite_ref-171">^</a></b></span> <span class="reference-text"><cite class="citation book">Barocas, Solon; Nissenbaum, Helen; Lane, Julia; Stodden, Victoria; Bender, Stefan; Nissenbaum, Helen (June 2014). <a rel="nofollow" class="external text" href="http://dx.doi.org/10.1017/CBO9781107590205.004"><i>Big Data’s End Run around Anonymity and Consent</i></a>. Cambridge University Press. pp.&#160;44–75. <a href="/wiki/Digital_object_identifier" title="Digital object identifier">doi</a>:<a rel="nofollow" class="external text" href="//doi.org/10.1017%2Fcbo9781107590205.004">10.1017/cbo9781107590205.004</a>. <a href="/wiki/International_Standard_Book_Number" title="International Standard Book Number">ISBN</a>&#160;<a href="/wiki/Special:BookSources/9781107067356" title="Special:BookSources/9781107067356">9781107067356</a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=Big+Data%E2%80%99s+End+Run+around+Anonymity+and+Consent&amp;rft.pages=44-75&amp;rft.pub=Cambridge+University+Press&amp;rft.date=2014-06&amp;rft_id=info%3Adoi%2F10.1017%2Fcbo9781107590205.004&amp;rft.isbn=9781107067356&amp;rft.aulast=Barocas&amp;rft.aufirst=Solon&amp;rft.au=Nissenbaum%2C+Helen&amp;rft.au=Lane%2C+Julia&amp;rft.au=Stodden%2C+Victoria&amp;rft.au=Bender%2C+Stefan&amp;rft.au=Nissenbaum%2C+Helen&amp;rft_id=http%3A%2F%2Fdx.doi.org%2F10.1017%2FCBO9781107590205.004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-danah-172"><span class="mw-cite-backlink"><b><a href="#cite_ref-danah_172-0">^</a></b></span> <span class="reference-text"><cite class="citation web"><a href="/wiki/Danah_boyd" title="Danah boyd">danah boyd</a> (29 April 2010). <a rel="nofollow" class="external text" href="http://www.danah.org/papers/talks/2010/WWW2010.html">"Privacy and Publicity in the Context of Big Data"</a>. <i><a href="/wiki/World_Wide_Web_Conference" class="mw-redirect" title="World Wide Web Conference">WWW 2010 conference</a></i><span class="reference-accessdate">. Retrieved <span class="nowrap">2011-04-18</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=WWW+2010+conference&amp;rft.atitle=Privacy+and+Publicity+in+the+Context+of+Big+Data&amp;rft.date=2010-04-29&amp;rft.au=danah+boyd&amp;rft_id=http%3A%2F%2Fwww.danah.org%2Fpapers%2Ftalks%2F2010%2FWWW2010.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-173"><span class="mw-cite-backlink"><b><a href="#cite_ref-173">^</a></b></span> <span class="reference-text"><cite class="citation journal">Jones, MB; Schildhauer, MP; Reichman, OJ; Bowers, S (2006). <a rel="nofollow" class="external text" href="http://www.pnamp.org/sites/default/files/Jones2006_AREES.pdf">"The New Bioinformatics: Integrating Ecological Data from the Gene to the Biosphere"</a> <span style="font-size:85%;">(PDF)</span>. <i>Annual Review of Ecology, Evolution, and Systematics</i>. <b>37</b> (1): 519–544. <a href="/wiki/Digital_object_identifier" title="Digital object identifier">doi</a>:<a rel="nofollow" class="external text" href="//doi.org/10.1146%2Fannurev.ecolsys.37.091305.110031">10.1146/annurev.ecolsys.37.091305.110031</a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Annual+Review+of+Ecology%2C+Evolution%2C+and+Systematics&amp;rft.atitle=The+New+Bioinformatics%3A+Integrating+Ecological+Data+from+the+Gene+to+the+Biosphere&amp;rft.volume=37&amp;rft.issue=1&amp;rft.pages=519-544&amp;rft.date=2006&amp;rft_id=info%3Adoi%2F10.1146%2Fannurev.ecolsys.37.091305.110031&amp;rft.aulast=Jones&amp;rft.aufirst=MB&amp;rft.au=Schildhauer%2C+MP&amp;rft.au=Reichman%2C+OJ&amp;rft.au=Bowers%2C+S&amp;rft_id=http%3A%2F%2Fwww.pnamp.org%2Fsites%2Fdefault%2Ffiles%2FJones2006_AREES.pdf&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-danah2-174"><span class="mw-cite-backlink">^ <a href="#cite_ref-danah2_174-0"><sup><i><b>a</b></i></sup></a> <a href="#cite_ref-danah2_174-1"><sup><i><b>b</b></i></sup></a></span> <span class="reference-text"><cite class="citation journal">Boyd, D.; Crawford, K. (2012). "Critical Questions for Big Data". <i>Information, Communication &amp; Society</i>. <b>15</b> (5): 662–679. <a href="/wiki/Digital_object_identifier" title="Digital object identifier">doi</a>:<a rel="nofollow" class="external text" href="//doi.org/10.1080%2F1369118X.2012.678878">10.1080/1369118X.2012.678878</a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Information%2C+Communication+%26+Society&amp;rft.atitle=Critical+Questions+for+Big+Data&amp;rft.volume=15&amp;rft.issue=5&amp;rft.pages=662-679&amp;rft.date=2012&amp;rft_id=info%3Adoi%2F10.1080%2F1369118X.2012.678878&amp;rft.aulast=Boyd&amp;rft.aufirst=D.&amp;rft.au=Crawford%2C+K.&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-Big_Decisions_White_Paper-175"><span class="mw-cite-backlink"><b><a href="#cite_ref-Big_Decisions_White_Paper_175-0">^</a></b></span> <span class="reference-text"><a rel="nofollow" class="external text" href="http://www.fortewares.com/Administrator/userfiles/Banner/forte-wares--pro-active-reporting_EN.pdf">Failure to Launch: From Big Data to Big Decisions</a>, Forte Wares.</span></li>
<li id="cite_note-kdnuggets-berchthold-176"><span class="mw-cite-backlink">^ <a href="#cite_ref-kdnuggets-berchthold_176-0"><sup><i><b>a</b></i></sup></a> <a href="#cite_ref-kdnuggets-berchthold_176-1"><sup><i><b>b</b></i></sup></a></span> <span class="reference-text"><cite class="citation web"><a href="/wiki/Gregory_I._Piatetsky-Shapiro" class="mw-redirect" title="Gregory I. Piatetsky-Shapiro">Gregory Piatetsky</a> (12 August 2014). <a rel="nofollow" class="external text" href="http://www.kdnuggets.com/2014/08/interview-michael-berthold-knime-research-big-data-privacy-part2.html">"Interview: Michael Berthold, KNIME Founder, on Research, Creativity, Big Data, and Privacy, Part 2"</a>. KDnuggets<span class="reference-accessdate">. Retrieved <span class="nowrap">2014-08-13</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Interview%3A+Michael+Berthold%2C+KNIME+Founder%2C+on+Research%2C+Creativity%2C+Big+Data%2C+and+Privacy%2C+Part+2&amp;rft.pub=KDnuggets&amp;rft.date=2014-08-12&amp;rft.au=Gregory+Piatetsky&amp;rft_id=http%3A%2F%2Fwww.kdnuggets.com%2F2014%2F08%2Finterview-michael-berthold-knime-research-big-data-privacy-part2.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-177"><span class="mw-cite-backlink"><b><a href="#cite_ref-177">^</a></b></span> <span class="reference-text"><cite class="citation web">Pelt, Mason. <a rel="nofollow" class="external text" href="http://siliconangle.com/blog/2015/10/26/big-data-is-an-over-used-buzzword-and-this-twitter-bot-proves-it/">"<span style="padding-left:0.2em;">"</span>Big Data" is an over used buzzword and this Twitter bot proves it"</a>. <i>siliconangle.com</i>. SiliconANGLE<span class="reference-accessdate">. Retrieved <span class="nowrap">4 November</span> 2015</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=siliconangle.com&amp;rft.atitle=%22Big+Data%22+is+an+over+used+buzzword+and+this+Twitter+bot+proves+it&amp;rft.aulast=Pelt&amp;rft.aufirst=Mason&amp;rft_id=http%3A%2F%2Fsiliconangle.com%2Fblog%2F2015%2F10%2F26%2Fbig-data-is-an-over-used-buzzword-and-this-twitter-bot-proves-it%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-ft-harford-178"><span class="mw-cite-backlink">^ <a href="#cite_ref-ft-harford_178-0"><sup><i><b>a</b></i></sup></a> <a href="#cite_ref-ft-harford_178-1"><sup><i><b>b</b></i></sup></a></span> <span class="reference-text"><cite class="citation web">Harford, Tim (28 March 2014). <a rel="nofollow" class="external text" href="http://www.ft.com/cms/s/2/21a6e7d8-b479-11e3-a09a-00144feabdc0.html">"Big data: are we making a big mistake?"</a>. <i><a href="/wiki/Financial_Times" title="Financial Times">Financial Times</a></i>. <a href="/wiki/Financial_Times" title="Financial Times">Financial Times</a><span class="reference-accessdate">. Retrieved <span class="nowrap">2014-04-07</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=Financial+Times&amp;rft.atitle=Big+data%3A+are+we+making+a+big+mistake%3F&amp;rft.date=2014-03-28&amp;rft.aulast=Harford&amp;rft.aufirst=Tim&amp;rft_id=http%3A%2F%2Fwww.ft.com%2Fcms%2Fs%2F2%2F21a6e7d8-b479-11e3-a09a-00144feabdc0.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-Ioannidis-179"><span class="mw-cite-backlink"><b><a href="#cite_ref-Ioannidis_179-0">^</a></b></span> <span class="reference-text"><cite class="citation journal"><a href="/wiki/John_P._A._Ioannidis" class="mw-redirect" title="John P. A. Ioannidis">Ioannidis, J. P. A.</a> (2005). <a rel="nofollow" class="external text" href="//www.ncbi.nlm.nih.gov/pmc/articles/PMC1182327">"Why Most Published Research Findings Are False"</a>. <i>PLoS Medicine</i>. <b>2</b> (8): e124. <a href="/wiki/Digital_object_identifier" title="Digital object identifier">doi</a>:<a rel="nofollow" class="external text" href="//doi.org/10.1371%2Fjournal.pmed.0020124">10.1371/journal.pmed.0020124</a>. <a href="/wiki/PubMed_Central" title="PubMed Central">PMC</a>&#160;<span class="plainlinks"><a rel="nofollow" class="external text" href="//www.ncbi.nlm.nih.gov/pmc/articles/PMC1182327">1182327</a> <img alt="Freely accessible" src="//upload.wikimedia.org/wikipedia/commons/thumb/6/65/Lock-green.svg/9px-Lock-green.svg.png" title="Freely accessible" width="9" height="14" srcset="//upload.wikimedia.org/wikipedia/commons/thumb/6/65/Lock-green.svg/14px-Lock-green.svg.png 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/6/65/Lock-green.svg/18px-Lock-green.svg.png 2x" data-file-width="512" data-file-height="813" /></span>. <a href="/wiki/PubMed_Identifier" class="mw-redirect" title="PubMed Identifier">PMID</a>&#160;<a rel="nofollow" class="external text" href="//www.ncbi.nlm.nih.gov/pubmed/16060722">16060722</a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=PLoS+Medicine&amp;rft.atitle=Why+Most+Published+Research+Findings+Are+False&amp;rft.volume=2&amp;rft.issue=8&amp;rft.pages=e124&amp;rft.date=2005&amp;rft_id=%2F%2Fwww.ncbi.nlm.nih.gov%2Fpmc%2Farticles%2FPMC1182327&amp;rft_id=info%3Apmid%2F16060722&amp;rft_id=info%3Adoi%2F10.1371%2Fjournal.pmed.0020124&amp;rft.aulast=Ioannidis&amp;rft.aufirst=J.+P.+A.&amp;rft_id=%2F%2Fwww.ncbi.nlm.nih.gov%2Fpmc%2Farticles%2FPMC1182327&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-180"><span class="mw-cite-backlink"><b><a href="#cite_ref-180">^</a></b></span> <span class="reference-text"><cite class="citation news">Lohr, Steve; Singer, Natasha (2016-11-10). <a rel="nofollow" class="external text" href="https://www.nytimes.com/2016/11/10/technology/the-data-said-clinton-would-win-why-you-shouldnt-have-believed-it.html">"How Data Failed Us in Calling an Election"</a>. <i>The New York Times</i>. <a href="/wiki/International_Standard_Serial_Number" title="International Standard Serial Number">ISSN</a>&#160;<a rel="nofollow" class="external text" href="//www.worldcat.org/issn/0362-4331">0362-4331</a><span class="reference-accessdate">. Retrieved <span class="nowrap">2016-11-27</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=The+New+York+Times&amp;rft.atitle=How+Data+Failed+Us+in+Calling+an+Election&amp;rft.date=2016-11-10&amp;rft.issn=0362-4331&amp;rft.aulast=Lohr&amp;rft.aufirst=Steve&amp;rft.au=Singer%2C+Natasha&amp;rft_id=https%3A%2F%2Fwww.nytimes.com%2F2016%2F11%2F10%2Ftechnology%2Fthe-data-said-clinton-would-win-why-you-shouldnt-have-believed-it.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
<li id="cite_note-181"><span class="mw-cite-backlink"><b><a href="#cite_ref-181">^</a></b></span> <span class="reference-text"><cite class="citation news">Markman, Jon. <a rel="nofollow" class="external text" href="https://www.forbes.com/sites/jonmarkman/2016/08/08/big-data-and-the-2016-election/#4802f20846d7">"Big Data And The 2016 Election"</a>. <i>Forbes</i><span class="reference-accessdate">. Retrieved <span class="nowrap">2016-11-27</span></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Forbes&amp;rft.atitle=Big+Data+And+The+2016+Election&amp;rft.aulast=Markman&amp;rft.aufirst=Jon&amp;rft_id=https%3A%2F%2Fwww.forbes.com%2Fsites%2Fjonmarkman%2F2016%2F08%2F08%2Fbig-data-and-the-2016-election%2F%234802f20846d7&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABig+data" class="Z3988"><span style="display:none;">&#160;</span></span></span></li>
</ol>
