<h1 class="entry-title">Lessons Learned from Deploying Deep Learning at Scale</h1>
            </header><!-- .entry-header -->

  <div class="entry-content">
        <p><a id="dd_start"></a><img class="aligncenter size-full wp-image-5196" src="//blog.algorithmia.com/wp-content/uploads/2016/11/deploying-deep-learning-production-1.jpg" alt="Deploying deep learning at scale" width="1200" height="630" srcset="//blog.algorithmia.com/wp-content/uploads/2016/11/deploying-deep-learning-production-1.jpg 1200w, //blog.algorithmia.com/wp-content/uploads/2016/11/deploying-deep-learning-production-1-300x158.jpg 300w, //blog.algorithmia.com/wp-content/uploads/2016/11/deploying-deep-learning-production-1-768x403.jpg 768w, //blog.algorithmia.com/wp-content/uploads/2016/11/deploying-deep-learning-production-1-1024x538.jpg 1024w" sizes="(max-width: 1200px) 100vw, 1200px" />Deep learning is a machine learning technique used to solve complex problems related to image recognition, natural language processing, and more.</p>
<p>It requires both <a href="//blog.algorithmia.com/algorithm-economy-containers-microservices/">massive amounts of data and computational power</a>. <span id="more-4990"></span></p>
<p>The compute problem has been solved largely by GPUs, which have become essential for making <a href="//blog.algorithmia.com/introduction-to-deep-learning-2016/">deep learning</a> performant. GPUs have reduced the time required to train models from weeks to days. Most training tasks can be accomplished by <a href="https://medium.com/@acrosson/building-a-deep-learning-box-d17d97e2905c#.sk8sbe5n3">building your own box</a>.</p>
<p>But, how does an organization make their trained deep learning model available as part of an app or web service? For instance, say you have a deep learning model that can <a href="https://demos.algorithmia.com/classify-places/">identify places in images</a>. Your user provides a photo, and your models tells us what&#8217;s in the photo (e.g. bridge, cars, water).</p>
<p>One option is to move your model to the <a href="//blog.algorithmia.com/machine-learning-trends-future-artificial-intelligence-2016/">cloud as scalable web service</a>.</p>
<p>However, deploying deep learning models in the cloud can be challenging due to complex hardware requirements and software dependencies. Plus, GPU cloud computing is not yet mainstream. And, although <a href="https://aws.amazon.com/blogs/aws/new-p2-instance-type-for-amazon-ec2-up-to-16-gpus/">Amazon</a>, <a href="https://cloudplatform.googleblog.com/2016/11/announcing-GPUs-for-Google-Cloud-Platform.html">Google</a>, and <a href="https://azure.microsoft.com/en-us/blog/azure-n-series-general-availability-on-december-1/">Microsoft</a> have all announced cloud GPUs, it&#8217;s still not as easy as spinning up an EC2 instance or DigitalOcean Droplet.</p>
<p>We have a unique perspective on using not just one, but five different deep learning frameworks in the cloud. Since users depend on <a href="https://algorithmia.com">Algorithmia</a> to host and scale their algorithms, we&#8217;ve worked out most of the idiosyncrasies with the most popular deep learning frameworks out there.</p>
<p>Below are the slides from our presentation at the 2016 <a href="http://conferences.oreilly.com/artificial-intelligence/ai-ny-2016/public/schedule/detail/54098">O&#8217;Reilly Artificial Intelligence conference</a>. These slides cover the pros and cons of popular frameworks like TensorFlow, Caffe, Torch, and Theano. Why you should use one framework over another. And, more importantly, once you&#8217;ve picked a framework and trained a machine-learning model to solve your problem, how to reliably deploy deep learning frameworks at scale.</p>
<p>Here&#8217;s what we&#8217;ve learned from deploying deep learning at scale and fighting these battles so that you don’t have to. Let us know what you think <a href="https://twitter.com/algorithmia">@Algorithmia</a> or <a href="https://twitter.com/platypii">@Platypii</a>.</p>
<p><img class="aligncenter wp-image-5034 size-full" src="//blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.003.png" alt="Algorithmia's mission is to make state-of-the-art algorithms accessible and discoverable by everyone" width="960" height="540" srcset="//blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.003.png 960w, //blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.003-300x169.png 300w, //blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.003-768x432.png 768w" sizes="(max-width: 960px) 100vw, 960px" /></p>
<p>We’ve created an open <a href="https://algorithmia.com/">marketplace for algorithms and algorithm development</a>, making state-of-the-art algorithms accessible and discoverable by everyone.</p>
<p>On Algorithmia, algorithms run as <a href="//blog.algorithmia.com/algorithm-economy-containers-microservices/">containerized microservices</a> that act as the building blocks of algorithmic intelligence developers can use to create, share, and remix at scale.</p>
<p>By making algorithms composable, interoperable, and portable, algorithms can be written in any supported language, and then made available to application developers where the code is always “on,” and available via a simple REST API.</p>
<hr class="stag-divider stag-divider--plain" />
<p><img class="aligncenter wp-image-5037 size-full" src="//blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.004.png" alt="Colorizing black and white photos using deep learning" width="960" height="540" srcset="//blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.004.png 960w, //blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.004-300x169.png 300w, //blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.004-768x432.png 768w" sizes="(max-width: 960px) 100vw, 960px" /></p>
<p class="p1"><span class="s1">For context, in the months leading up to this presentation, we had been preparing the Algorithmia platform to support deep learning. In July 2016, we launched our solution for <a href="//blog.algorithmia.com/cloud-hosted-deep-learning-models/">hosting and distributing trained deep learning models using GPUs in the cloud</a>. To demonstrate, we created demos to <a href="https://demos.algorithmia.com/colorize-photos/">automatically colorize black and white photos</a>, and </span><a href="https://demos.algorithmia.com/classify-places/">classify places and locations in images</a>.</p>
<hr class="stag-divider stag-divider--plain" />
<p><img class="aligncenter wp-image-5040 size-full" src="//blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.005.png" alt="Cloud hosting of machine learning models is challenging" width="960" height="540" srcset="//blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.005.png 960w, //blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.005-300x169.png 300w, //blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.005-768x432.png 768w" sizes="(max-width: 960px) 100vw, 960px" /></p>
<p>We speak from experience about the challenges faced when going beyond simple demos and trying to use deep learning in a scaled, production environment accessed by hundreds of thousands of people.</p>
<hr class="stag-divider stag-divider--plain" />
<p><img class="aligncenter wp-image-5041 size-full" src="//blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.006.png" alt="What is deep learning?" width="960" height="540" srcset="//blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.006.png 960w, //blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.006-300x169.png 300w, //blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.006-768x432.png 768w" sizes="(max-width: 960px) 100vw, 960px" /></p>
<p class="p1"><span class="s1">At its core, deep learning is just trying to replicate how the brain functions using machines. </span></p>
<p>Think of deep learning as <a href="http://neuralnetworksanddeeplearning.com/index.html">the technique for learning</a> in neural networks that utilizes multiple layers of abstraction to solve pattern recognition problems. Our brains are able to learn the structure of things with little to no guidance.</p>
<p class="p1"><strong><span class="s1">Need an <a href="//blog.algorithmia.com/introduction-to-deep-learning-2016/">introduction to deep learning</a>? </span></strong></p>
<hr class="stag-divider stag-divider--plain" />
<p><img class="aligncenter wp-image-5043 size-full" src="//blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.007.png" alt="Applications of deep learning on unstructured text" width="960" height="540" srcset="//blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.007.png 960w, //blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.007-300x169.png 300w, //blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.007-768x432.png 768w" sizes="(max-width: 960px) 100vw, 960px" /></p>
<p class="p1"><span class="s1">Over the past half-decade, we have generated and stored <a href="//blog.algorithmia.com/named-entity-recognition-categorizing-data/">unstructured data</a> at a whopping pace. Just think of the amount of unstructured metadata your mobile phone creates in a single day: SMS texts, cell towers connected to, GPS, emails, file types and sizes, use and inactivity, wifi connected to, and a lot more. For more, here&#8217;s <a href="http://www.abc.net.au/news/2015-08-16/metadata-retention-privacy-phone-will-ockenden/6694152">how your phone tracks your every move</a>.</span></p>
<hr class="stag-divider stag-divider--plain" />
<p><img class="aligncenter wp-image-5044 size-full" src="//blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.008.png" alt="Commercial uses of deep learning include computer vision and natural language processing" width="960" height="540" srcset="//blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.008.png 960w, //blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.008-300x169.png 300w, //blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.008-768x432.png 768w" sizes="(max-width: 960px) 100vw, 960px" /></p>
<p>To showcase some of these applications we’ve added several <a href="//blog.algorithmia.com/open-source-deep-learning-algorithm-roundup/">open source deep learning models</a> to the platform for you to try.</p>
<hr class="stag-divider stag-divider--plain" />
<p><img class="aligncenter wp-image-5047 size-full" src="//blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.009.png" alt="Why is deep learning popular right now?" width="960" height="540" srcset="//blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.009.png 960w, //blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.009-300x169.png 300w, //blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.009-768x432.png 768w" sizes="(max-width: 960px) 100vw, 960px" /></p>
<p class="p1"><span class="s1">Three major shifts have driven the craze behind deep learning: a) advances in research, b) advances in hardware, and c) availability of this hardware at scale.</span></p>
<hr class="stag-divider stag-divider--plain" />
<p><img class="aligncenter wp-image-5050 size-full" src="//blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.010.png" alt="Hardware needed for deep learning" width="960" height="540" srcset="//blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.010.png 960w, //blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.010-300x169.png 300w, //blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.010-768x432.png 768w" sizes="(max-width: 960px) 100vw, 960px" /></p>
<p class="p1"><span class="s1">For the most part, there has been only one game in town. NVIDIAs efforts with <a href="https://developer.nvidia.com/about-cuda">CUDA</a>, <a href="https://developer.nvidia.com/cudnn">cuDANN</a> have been included in every major deep learning framework.</span></p>
<hr class="stag-divider stag-divider--plain" />
<p><img class="aligncenter wp-image-5053 size-full" src="//blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.011.png" alt="GPUs and ASICs" width="960" height="540" srcset="//blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.011.png 960w, //blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.011-300x169.png 300w, //blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.011-768x432.png 768w" sizes="(max-width: 960px) 100vw, 960px" /></p>
<p class="p1"><span class="s1">There are still new advances coming down the line, like new GPUs are tailored for deep learning (i.e sacrificing precision in exchange for faster calculations and reduced memory usage), as well as custom hardware. This is similar to the progression we saw with <a href="https://en.bitcoin.it/wiki/Mining_hardware_comparison">Bitcoin from CPUs, to GPUs, to ASICS</a>.</span></p>
<hr class="stag-divider stag-divider--plain" />
<p><img class="aligncenter wp-image-5055 size-full" src="//blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.012.png" alt="GPU dependencies" width="960" height="540" srcset="//blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.012.png 960w, //blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.012-300x169.png 300w, //blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.012-768x432.png 768w" sizes="(max-width: 960px) 100vw, 960px" /></p>
<p class="p1"><span class="s1">This is the general stack required for doing deep learning. NVIDIA’s success in this space can be attributed to having owned everything from the GPU chip up to cuDNN. </span></p>
<p class="p1"><span class="s1">A few notes: </span></p>
<ul>
<li class="p1"><span class="s1">NVIDIA drives how the kernel communicates with the GPU. </span></li>
<li class="p1"><span class="s1">CUDA enables parallel computing over the GPU. </span></li>
<li class="p1"><span class="s1">cuDNN is a GPU accelerated library of primitives for deep neural nets.</span></li>
<li class="p1">“Meta deep learning frameworks” are attempting to make deep learning even more accessible by abstracting even more. The prime example of this is <a href="https://keras.io/">Keras</a>.</li>
</ul>
<hr class="stag-divider stag-divider--plain" />
<p><img class="aligncenter wp-image-5058 size-full" src="//blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.013.png" alt="Top deep learning frameworks" width="960" height="540" srcset="//blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.013.png 960w, //blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.013-300x169.png 300w, //blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.013-768x432.png 768w" sizes="(max-width: 960px) 100vw, 960px" /></p>
<p class="p1"><span class="s1">There are a number of deep learning frameworks that support different languages. Next, we&#8217;ll explain the top frameworks.</span></p>
<hr class="stag-divider stag-divider--plain" />
<p><img class="aligncenter wp-image-5061 size-full" src="//blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.014.png" alt="Theano" width="960" height="540" srcset="//blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.014.png 960w, //blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.014-300x169.png 300w, //blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.014-768x432.png 768w" sizes="(max-width: 960px) 100vw, 960px" /></p>
<hr class="stag-divider stag-divider--plain" />
<p><img class="aligncenter wp-image-5062 size-full" src="//blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.015.png" alt="Torch" width="960" height="540" srcset="//blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.015.png 960w, //blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.015-300x169.png 300w, //blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.015-768x432.png 768w" sizes="(max-width: 960px) 100vw, 960px" /></p>
<hr class="stag-divider stag-divider--plain" />
<p><img class="aligncenter wp-image-4992 size-full" src="//blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.016.png" alt="Caffe deep learning framework" width="960" height="540" srcset="//blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.016.png 960w, //blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.016-300x169.png 300w, //blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.016-768x432.png 768w" sizes="(max-width: 960px) 100vw, 960px" /></p>
<hr class="stag-divider stag-divider--plain" />
<p><img class="aligncenter wp-image-4993 size-full" src="//blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.017.png" alt="CNTK by Microsoft" width="960" height="540" srcset="//blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.017.png 960w, //blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.017-300x169.png 300w, //blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.017-768x432.png 768w" sizes="(max-width: 960px) 100vw, 960px" /></p>
<hr class="stag-divider stag-divider--plain" />
<p><img class="aligncenter wp-image-4996 size-full" src="//blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.018.png" alt="TensorFlow Deep Learning by Google" width="960" height="540" srcset="//blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.018.png 960w, //blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.018-300x169.png 300w, //blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.018-768x432.png 768w" sizes="(max-width: 960px) 100vw, 960px" /></p>
<hr class="stag-divider stag-divider--plain" />
<p><img class="aligncenter wp-image-4999 size-full" src="//blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.019.png" alt="Machine learning networks for training" width="960" height="540" srcset="//blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.019.png 960w, //blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.019-300x169.png 300w, //blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.019-768x432.png 768w" sizes="(max-width: 960px) 100vw, 960px" /></p>
<p class="p1"><span class="s1">There is a whole area of research in the design of depth and shape of neural nets. Practitioners rarely start from scratch, instead they&#8217;ll start with designs that have worked for similar tasks in the past and evolve it from there. </span></p>
<hr class="stag-divider stag-divider--plain" />
<p><img class="aligncenter wp-image-5002 size-full" src="//blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.020.png" alt="Two phases of deep learning are training and running" width="960" height="540" srcset="//blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.020.png 960w, //blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.020-300x169.png 300w, //blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.020-768x432.png 768w" sizes="(max-width: 960px) 100vw, 960px" /></p>
<hr class="stag-divider stag-divider--plain" />
<p><img class="aligncenter wp-image-5004 size-full" src="//blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.021.png" alt="hosting deep learning as an api" width="960" height="540" srcset="//blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.021.png 960w, //blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.021-300x169.png 300w, //blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.021-768x432.png 768w" sizes="(max-width: 960px) 100vw, 960px" /><span class="s1">How do you scale inference in neural nets to hundreds, thousands, or millions of users as an API? </span></p>
<hr class="stag-divider stag-divider--plain" />
<p><img class="aligncenter wp-image-5005 size-full" src="//blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.022.png" alt="Machine learning in the cloud" width="960" height="540" srcset="//blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.022.png 960w, //blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.022-300x169.png 300w, //blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.022-768x432.png 768w" sizes="(max-width: 960px) 100vw, 960px" /></p>
<p class="p1"><span class="s1">Machine learning is generally very computationally intensive. Using an elastic compute layer that can be scaled up and down is perfect for ML tasks. </span></p>
<hr class="stag-divider stag-divider--plain" />
<p><img class="aligncenter wp-image-5007 size-full" src="//blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.023.png" alt="Microservice architecture" width="960" height="540" srcset="//blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.023.png 960w, //blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.023-300x169.png 300w, //blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.023-768x432.png 768w" sizes="(max-width: 960px) 100vw, 960px" /></p>
<p class="p1">Deep learning requires GPUs, and is very computationally intensive, and so it will typically reside in its own service, separate from user-facing web servers. Dedicated hardware will make sure that you don’t starve other parts of your SOA system of resources. If it’s going to be a separate service anyway, why not outsource it?</p>
<hr class="stag-divider stag-divider--plain" />
<p><img class="aligncenter wp-image-5008 size-full" src="//blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.024.png" alt="Deep learning in the cloud" width="960" height="540" srcset="//blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.024.png 960w, //blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.024-300x169.png 300w, //blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.024-768x432.png 768w" sizes="(max-width: 960px) 100vw, 960px" /></p>
<p class="p1"><span class="s1">There are a number of challenges we hit when getting deep learning to work at scale. The first was picking the right provider – at the time of this talk there were not many options, though this is starting to change.</span></p>
<hr class="stag-divider stag-divider--plain" />
<p><img class="aligncenter wp-image-5010 size-full" src="//blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.025.png" alt="Programming bindings for deep learning" width="960" height="540" srcset="//blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.025.png 960w, //blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.025-300x169.png 300w, //blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.025-768x432.png 768w" sizes="(max-width: 960px) 100vw, 960px" /></p>
<p class="p1"><span class="s1">For the most part, there are only three languages represented in the world of deep learning in terms of bindings: Python, Lua and C++. Yet, applications in the real world use many more languages than these. A service architecture allows you to abstract language through the use of REST endpoints. </span></p>
<hr class="stag-divider stag-divider--plain" />
<p><img class="aligncenter wp-image-5013 size-full" src="//blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.026.png" alt="Deep learning models are getting larger" width="960" height="540" srcset="//blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.026.png 960w, //blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.026-300x169.png 300w, //blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.026-768x432.png 768w" sizes="(max-width: 960px) 100vw, 960px" /></p>
<p class="p1">As the neural nets get deeper, the models have become large and larger. Any practitioner in the DL space at one point has hit the problem of running out of GPU memory. Memory management for GPU memory is virtually non-existent. We can solve this in two ways: more, larger hardware, or smaller models.</p>
<hr class="stag-divider stag-divider--plain" />
<p><img class="aligncenter wp-image-5016 size-full" src="//blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.027.png" alt="Memory per deep learning model" width="960" height="540" srcset="//blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.027.png 960w, //blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.027-300x169.png 300w, //blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.027-768x432.png 768w" sizes="(max-width: 960px) 100vw, 960px" /></p>
<p class="p1"><span class="s1">As you can see, the deeper the neural net the larger the memory footprint. Sadly, memory footprint and reduction in error rates are correlated. </span></p>
<hr class="stag-divider stag-divider--plain" />
<p><img class="aligncenter wp-image-5019 size-full" src="//blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.028.png" alt="SqueezeNet" width="960" height="540" srcset="//blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.028.png 960w, //blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.028-300x169.png 300w, //blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.028-768x432.png 768w" sizes="(max-width: 960px) 100vw, 960px" /></p>
<p class="p1"><span class="s1">There has been some promising research in reducing the size of the models. There is still an error rate trade off.</span></p>
<hr class="stag-divider stag-divider--plain" />
<p><img class="aligncenter wp-image-5020 size-full" src="//blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.029.png" alt="machine learning model compression" width="960" height="540" srcset="//blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.029.png 960w, //blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.029-300x169.png 300w, //blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.029-768x432.png 768w" sizes="(max-width: 960px) 100vw, 960px" /></p>
<hr class="stag-divider stag-divider--plain" />
<p><img class="aligncenter wp-image-5022 size-full" src="//blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.030.png" alt="Sharing GPUs in the cloud" width="960" height="540" srcset="//blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.030.png 960w, //blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.030-300x169.png 300w, //blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.030-768x432.png 768w" sizes="(max-width: 960px) 100vw, 960px" /></p>
<p class="p1"><span class="s1">We have been sharing CPUs for decades &#8212; ever since the early mainframes. For GPUs, that has not been the case. The tooling and knowledge is still very young. Dealing with memory overflows is extremely common. </span></p>
<hr class="stag-divider stag-divider--plain" />
<p><img class="aligncenter wp-image-5023 size-full" src="//blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.031.png" alt="Using containers to share GPUs in the cloud" width="960" height="540" srcset="//blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.031.png 960w, //blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.031-300x169.png 300w, //blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.031-768x432.png 768w" sizes="(max-width: 960px) 100vw, 960px" /></p>
<p class="p1">Containers have provided a great way for managing cloud services and applications, but the Docker abstraction breaks down when trying to interface with GPU hardware. If you’re using containers over GPUs for deep learning in production, you are a pioneer on the frontier of this field with little literature or community support to rely on.</p>
<hr class="stag-divider stag-divider--plain" />
<p><img class="aligncenter wp-image-5025 size-full" src="//blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.032.png" alt="Lessons learned from deploying deep learning models as microservices" width="960" height="540" srcset="//blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.032.png 960w, //blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.032-300x169.png 300w, //blog.algorithmia.com/wp-content/uploads/2016/11/MLDAS2016-DeepLearningAtScale.032-768x432.png 768w" sizes="(max-width: 960px) 100vw, 960px" /></p>
<hr class="stag-divider stag-divider--plain" />
<p>To recap the presentation: Training deep learning models is only half the problem. Deploying deep learning models in the cloud is the next step, but the skillset required to deploy models into production is entirely different. While tools are frameworks are improving everyday and making this easier, we still have a long way to go.</p>
<p>Let us know what you think <a href="https://twitter.com/algorithmia">@Algorithmia</a> or <a href="https://twitter.com/platypii">@Platypii</a>.</p>
<p><strong>Further Reading:</strong></p>
<ul>
<li id="menu-item-3429" class="menu-item menu-item-type-post_type menu-item-object-post menu-item-3429"><a title="Machine Learning Trends and the Future of Artificial Intelligence 2016" href="//blog.algorithmia.com/machine-learning-trends-future-artificial-intelligence-2016/">Machine Learning Trends</a></li>
<li id="menu-item-3436" class="menu-item menu-item-type-post_type menu-item-object-post menu-item-3436"><a title="Turn Your Deep Learning Model into a Serverless Microservice" href="//blog.algorithmia.com/cloud-hosted-deep-learning-models/">Deep Learning Models as Microservices</a></li>
<li id="menu-item-3432" class="menu-item menu-item-type-post_type menu-item-object-post menu-item-3432"><a title="The Future of Algorithm Development" href="//blog.algorithmia.com/the-future-of-algorithm-development/">The Future of Algorithm Development</a></li>
<li id="menu-item-3439" class="menu-item menu-item-type-post_type menu-item-object-post menu-item-3439"><a title="How the Algorithm Economy and Containers are Changing the Way We Build and Deploy Apps Today" href="//blog.algorithmia.com/algorithm-economy-containers-microservices/">The Algorithm Economy and Containers</a></li>
<li id="menu-item-3435" class="menu-item menu-item-type-post_type menu-item-object-post menu-item-3435"><a title="Algorithm Development is Broken " href="//blog.algorithmia.com/algorithm-development-is-broken/">Algorithm Development is Broken</a></li>
</ul>
<p><strong>Deep Learning on Algorithmia:</strong></p>
<ul>
<li><a href="//blog.algorithmia.com/training-style-transfer-models/">AWS AMI for Training Style Transfer Models</a></li>
<li><a href="https://demos.algorithmia.com/deep-style/">Deep-Style.io Demo: Style Transfer Using Deep Learning</a></li>
<li><a href="//blog.algorithmia.com/deep-filter-getting-started-style-transfer/">Getting Started With Style Transfer</a></li>
<li><a href="//blog.algorithmia.com/style-transfer-command-line-tool-cli/">Neural Style Transfer from the Command Line</a></li>
<li><a href="//blog.algorithmia.com/introduction-to-deep-learning-2016/">An Introduction to Deep Learning</a></li>
<li><a href="//blog.algorithmia.com/ai-why-deep-learning-matters/">Why Deep Learning Matters and What’s Next for Artificial Intelligence</a></li>
</ul>
<p><a id="dd_end"></a></p>
<div class='dd_outer'>
<div class='dd_inner'>
<div id='dd_ajax_float'>
<div class='dd_button_v'><script src="//connect.facebook.net/en_US/all.js#xfbml=1"></script><fb:like href="//blog.algorithmia.com/deploying-deep-learning-cloud-services/" send="false" show_faces="false"  layout="box_count" width="50"  ></fb:like></div>
<div style='clear:left'></div>
<div class='dd_button_v'><a href="http://twitter.com/share" class="twitter-share-button" data-url="//blog.algorithmia.com/deploying-deep-learning-cloud-services/" data-count="vertical" data-text="Lessons Learned from Deploying Deep Learning at Scale" data-via="algorithmia" ></a><script type="text/javascript" src="//platform.twitter.com/widgets.js"></script></div>
<div style='clear:left'></div>
</div>
</div>
</div>
<p><script type="text/javascript">var dd_offset_from_content = 60;var dd_top_offset_from_content = 0;var dd_override_start_anchor_id = "";var dd_override_top_offset = "0";</script><script type="text/javascript" src="//blog.algorithmia.com/wp-content/plugins/digg-digg//js/diggdigg-floating-bar.js?ver=5.3.6"></script></p>
<div class="wp-about-author-containter-top" style="background-color:#ffffff;">
<div class="wp-about-author-pic wp-about-author-circle"><img alt='' src='//secure.gravatar.com/avatar/7b0a86a52595a7a94a373faf15ed1779?s=100&#038;d=mm&#038;r=g' srcset='//secure.gravatar.com/avatar/7b0a86a52595a7a94a373faf15ed1779?s=200&amp;d=mm&amp;r=g 2x' class='avatar avatar-100 photo' height='100' width='100' /></div>
