

<div class="entry-content content">


<p>An average data scientist deals with loads of data daily. Some say over 60-70% time is spent in data cleaning, munging and bringing data to a suitable format such that machine learning models can be applied on that data. This post focuses on the second part, i.e., applying machine learning models, including the preprocessing steps. The pipelines discussed in this post come as a result of over a hundred machine learning competitions that I’ve taken part in. It must be noted that the discussion here is very general but very useful and there can also be very complicated methods which exist and are practised by professionals.</p>
<p>We will be using python!</p>
<h1>Data</h1>
<p>Before applying the machine learning models, the data must be converted to a tabular form. This whole process is the most time consuming and difficult process and is depicted in the figure below.</p>
<p><a href="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_1.png"><img src="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_1.png" alt="abhishek_1" width="800" height="222" class="aligncenter size-full wp-image-5973" srcset="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_1.png 800w, http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_1-300x83.png 300w, http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_1-768x213.png 768w, http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_1-100x28.png 100w" sizes="(max-width: 800px) 100vw, 800px" /></a></p>
<p>The machine learning models are then applied to the tabular data. Tabular data is most common way of representing data in machine learning or data mining. We have a data table, rows with different samples of the data or X and labels, y. The labels can be single column or multi-column, depending on the type of problem. We will denote data by X and labels by y.</p>
<h1>Types of labels</h1>
<p>The labels define the problem and can be of different types, such as:</p>
<ul>
<li>Single column, binary values (classification problem, one sample belongs to one class only and there are only two classes)</li>
<li>Single column, real values (regression problem, prediction of only one value)</li>
<li>Multiple column, binary values (classification problem, one sample belongs to one class, but there are more than two classes)</li>
<li>Multiple column, real values (regression problem, prediction of multiple values)</li>
<li>And multilabel (classification problem, one sample can belong to several classes)</li>
</ul>
<h1>Evaluation Metrics</h1>
<p>For any kind of machine learning problem, we must know how we are going to evaluate our results, or what the evaluation metric or objective is. For example in case of a skewed binary classification problem we generally choose area under the receiver operating characteristic curve (ROC AUC or simply AUC). In case of multi-label or multi-class classification problems, we generally choose categorical cross-entropy or multiclass log loss and mean squared error in case of regression problems.</p>
<p>I won’t go into details of the different evaluation metrics as we can have many different types, depending on the problem.</p>
<h1>The Libraries</h1>
<p>To start with the machine learning libraries, install the basic and most important ones first, for example, numpy and scipy.</p>
<ul>
<li>To see and do operations on data: pandas (<a href="http://pandas.pydata.org/" target="_blank" rel="nofollow">http://pandas.pydata.org/</a>)</li>
<li>For all kinds of machine learning models: scikit-learn (<a href="http://scikit-learn.org/stable/" target="_blank" rel="nofollow">http://scikit-learn.org/stable/</a>)</li>
<li>The best gradient boosting library: xgboost (<a href="https://github.com/dmlc/xgboost" target="_blank" rel="nofollow">https://github.com/dmlc/xgboost</a>)</li>
<li>For neural networks: keras (<a href="http://keras.io/" target="_blank" rel="nofollow">http://keras.io/</a>)</li>
<li>For plotting data: matplotlib (<a href="http://matplotlib.org/" target="_blank" rel="nofollow">http://matplotlib.org/</a>)</li>
<li>To monitor progress: tqdm (<a href="https://pypi.python.org/pypi/tqdm" target="_blank" rel="nofollow">https://pypi.python.org/pypi/tqdm</a>)</li>
</ul>
<p>I don’t use Anaconda (<a href="https://www.continuum.io/downloads" target="_blank" rel="nofollow">https://www.continuum.io/downloads</a>). It’s easy and does everything for you, but I want more freedom. The choice is yours. 🙂</p>
<h1>The Machine Learning Framework</h1>
<p>In 2015, I came up with a framework for automatic machine learning which is still under development and will be released soon. For this post, the same framework will be the basis. The framework is shown in the figure below:</p>
<div id="attachment_5974" style="width: 810px" class="wp-caption aligncenter"><a href="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_2.png"><img src="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_2.png" alt="Figure from: A. Thakur and A. Krohn-Grimberghe, AutoCompete: A Framework for Machine Learning Competitions, AutoML Workshop, International Conference on Machine Learning 2015." width="800" height="605" class="size-full wp-image-5974" srcset="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_2.png 800w, http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_2-300x227.png 300w, http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_2-768x581.png 768w, http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_2-100x76.png 100w" sizes="(max-width: 800px) 100vw, 800px" /></a><p class="wp-caption-text">Figure from: A. Thakur and A. Krohn-Grimberghe, AutoCompete: A Framework for Machine Learning Competitions, AutoML Workshop, International Conference on Machine Learning 2015.</p></div>
<p>In the framework shown above, the pink lines represent the most common paths followed. After we have extracted and reduced the data to a tabular format, we can go ahead with building machine learning models.</p>
<p>The very first step is identification of the problem. This can be done by looking at the labels. One must know if the problem is a binary classification, a multi-class or multi-label classification or a regression problem. After we have identified the problem, we split the data into two different parts, a training set and a validation set as depicted in the figure below.</p>
<p><a href="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_3.png"><img src="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_3.png" alt="abhishek_3" width="800" height="406" class="aligncenter size-full wp-image-5975" srcset="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_3.png 800w, http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_3-300x152.png 300w, http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_3-768x390.png 768w, http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_3-100x51.png 100w" sizes="(max-width: 800px) 100vw, 800px" /></a></p>
<p>The splitting of data into training and validation sets “must” be done according to labels. In case of any kind of classification problem, use stratified splitting. In python, you can do this using scikit-learn very easily.</p>
<p><a href="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_4.png"><img src="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_4.png" alt="abhishek_4" width="675" height="161" class="aligncenter size-full wp-image-5976" srcset="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_4.png 675w, http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_4-300x72.png 300w, http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_4-100x24.png 100w" sizes="(max-width: 675px) 100vw, 675px" /></a></p>
<p>In case of regression task, a simple K-Fold splitting should suffice. There are, however, some complex methods which tend to keep the distribution of labels same for both training and validation set and this is left as an exercise for the reader.</p>
<p><a href="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_5.png"><img src="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_5.png" alt="abhishek_5" width="671" height="154" class="aligncenter size-full wp-image-5977" srcset="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_5.png 671w, http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_5-300x69.png 300w, http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_5-100x23.png 100w" sizes="(max-width: 671px) 100vw, 671px" /></a></p>
<p>I have chosen the eval_size or the size of the validation set as 10% of the full data in the examples above, but one can choose this value according to the size of the data they have.</p>
<p>After the splitting of the data is done, leave this data out and don’t touch it. Any operations that are applied on training set must be saved and then applied to the validation set. Validation set, in any case, should not be joined with the training set. Doing so will result in very good evaluation scores and make the user happy but instead he/she will be building a useless model with very high overfitting.</p>
<p>Next step is identification of different variables in the data. There are usually three types of variables we deal with. Namely, numerical variables, categorical variables and variables with text inside them. Let’s take example of the popular Titanic dataset (<a href="https://www.kaggle.com/c/titanic/data" target="_blank" rel="nofollow">https://www.kaggle.com/c/titanic/data</a>).</p>
<p><a href="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_6.png"><img src="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_6.png" alt="abhishek_6" width="800" height="441" class="aligncenter size-full wp-image-5978" srcset="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_6.png 800w, http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_6-300x165.png 300w, http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_6-768x423.png 768w, http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_6-100x55.png 100w" sizes="(max-width: 800px) 100vw, 800px" /></a></p>
<p>Here, survival is the label. We have already separated labels from the training data in the previous step. Then, we have pclass, sex, embarked. These variables have different levels and thus they are categorical variables. Variables like age, sibsp, parch, etc are numerical variables. Name is a variable with text data but I don’t think it’s a useful variable to predict survival.</p>
<p>Separate out the numerical variables first. These variables don’t need any kind of processing and thus we can start applying normalization and machine learning models to these variables.</p>
<p>There are two ways in which we can handle categorical data:</p>
<ul>
<li>Convert the categorical data to labels</li>
</ul>
<p><a href="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_7.png"><img src="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_7.png" alt="abhishek_7" width="800" height="173" class="aligncenter size-full wp-image-5979" srcset="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_7.png 800w, http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_7-300x65.png 300w, http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_7-768x166.png 768w, http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_7-100x22.png 100w" sizes="(max-width: 800px) 100vw, 800px" /></a></p>
<ul>
<li>Convert the labels to binary variables (one-hot encoding)</li>
</ul>
<p><a href="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_8.png"><img src="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_8.png" alt="abhishek_8" width="800" height="177" class="aligncenter size-full wp-image-5980" srcset="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_8.png 800w, http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_8-300x66.png 300w, http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_8-768x170.png 768w, http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_8-100x22.png 100w" sizes="(max-width: 800px) 100vw, 800px" /></a></p>
<p>Please remember to convert categories to numbers first using LabelEncoder before applying OneHotEncoder on it.</p>
<p>Since, the Titanic data doesn’t have good example of text variables, let’s formulate a general rule on handling text variables. We can combine all the text variables into one and then use some algorithms which work on text data and convert it to numbers.</p>
<p>The text variables can be joined as follows:</p>
<p><a href="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_9.png"><img src="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_9.png" alt="abhishek_9" width="800" height="30" class="aligncenter size-full wp-image-5981" srcset="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_9.png 800w, http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_9-300x11.png 300w, http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_9-768x29.png 768w, http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_9-100x4.png 100w" sizes="(max-width: 800px) 100vw, 800px" /></a></p>
<p>We can then use CountVectorizer or TfidfVectorizer on it:</p>
<p><a href="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_10.png"><img src="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_10.png" alt="abhishek_10" width="766" height="111" class="aligncenter size-full wp-image-5982" srcset="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_10.png 766w, http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_10-300x43.png 300w, http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_10-100x14.png 100w" sizes="(max-width: 766px) 100vw, 766px" /></a></p>
<p>or,</p>
<p><a href="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_11.png"><img src="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_11.png" alt="abhishek_11" width="755" height="113" class="aligncenter size-full wp-image-5983" srcset="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_11.png 755w, http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_11-300x45.png 300w, http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_11-100x15.png 100w" sizes="(max-width: 755px) 100vw, 755px" /></a></p>
<p>The TfidfVectorizer performs better than the counts most of the time and I have seen that the following parameters for TfidfVectorizer work almost all the time.</p>
<p><a href="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_12.png"><img src="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_12.png" alt="abhishek_12" width="800" height="166" class="aligncenter size-full wp-image-5984" srcset="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_12.png 800w, http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_12-300x62.png 300w, http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_12-768x159.png 768w, http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_12-100x21.png 100w" sizes="(max-width: 800px) 100vw, 800px" /></a></p>
<p>If you are applying these vectorizers only on the training set, make sure to dump it to hard drive so that you can use it later on the validation set.</p>
<p><a href="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_13.png"><img src="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_13.png" alt="abhishek_13" width="741" height="62" class="aligncenter size-full wp-image-5985" srcset="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_13.png 741w, http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_13-300x25.png 300w, http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_13-100x8.png 100w" sizes="(max-width: 741px) 100vw, 741px" /></a></p>
<p>Next, we come to the stacker module. Stacker module is not a model stacker but a feature stacker. The different features after the processing steps described above can be combined using the stacker module.</p>
<p><a href="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_14.png"><img src="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_14.png" alt="abhishek_14" width="611" height="134" class="aligncenter size-full wp-image-5986" srcset="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_14.png 611w, http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_14-300x66.png 300w, http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_14-100x22.png 100w" sizes="(max-width: 611px) 100vw, 611px" /></a></p>
<p>You can horizontally stack all the features before putting them through further processing by using numpy hstack or sparse hstack depending on whether you have dense or sparse features.</p>
<p><a href="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_15.png"><img src="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_15.png" alt="abhishek_15" width="400" height="243" class="aligncenter size-full wp-image-5987" srcset="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_15.png 400w, http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_15-300x182.png 300w, http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_15-100x61.png 100w" sizes="(max-width: 400px) 100vw, 400px" /></a></p>
<p>And can also be achieved by FeatureUnion module in case there are other processing steps such as pca or feature selection (we will visit decomposition and feature selection later in this post).</p>
<p><a href="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_16.png"><img src="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_16.png" alt="abhishek_16" width="800" height="228" class="aligncenter size-full wp-image-5988" srcset="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_16.png 800w, http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_16-300x86.png 300w, http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_16-768x219.png 768w, http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_16-100x29.png 100w" sizes="(max-width: 800px) 100vw, 800px" /></a></p>
<p>Once, we have stacked the features together, we can start applying machine learning models. At this stage only models you should go for should be ensemble tree based models. These models include:</p>
<ul>
<li>RandomForestClassifier</li>
<li>RandomForestRegressor</li>
<li>ExtraTreesClassifier</li>
<li>ExtraTreesRegressor</li>
<li>XGBClassifier</li>
<li>XGBRegressor</li>
</ul>
<p>We cannot apply linear models to the above features since they are not normalized. To use linear models, one can use Normalizer or StandardScaler from scikit-learn.</p>
<p>These normalization methods work only on dense features and don’t give very good results if applied on sparse features. Yes, one can apply StandardScaler on sparse matrices without using the mean (parameter: with_mean=False).</p>
<p>If the above steps give a “good” model, we can go for optimization of hyperparameters and in case it doesn’t we can go for the following steps and improve our model.</p>
<p>The next steps include decomposition methods:</p>
<p><a href="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_17.png"><img src="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_17.png" alt="abhishek_17" width="547" height="158" class="aligncenter size-full wp-image-5989" srcset="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_17.png 547w, http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_17-300x87.png 300w, http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_17-100x29.png 100w" sizes="(max-width: 547px) 100vw, 547px" /></a></p>
<p>For the sake of simplicity, we will leave out LDA and QDA transformations. For high dimensional data, generally PCA is used decompose the data. For images start with 10-15 components and increase this number as long as the quality of result improves substantially. For other type of data, we select 50-60 components initially (we tend to avoid PCA as long as we can deal with the numerical data as it is).</p>
<p><a href="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_18.png"><img src="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_18.png" alt="abhishek_18" width="400" height="134" class="aligncenter size-full wp-image-5990" srcset="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_18.png 400w, http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_18-300x101.png 300w, http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_18-100x34.png 100w" sizes="(max-width: 400px) 100vw, 400px" /></a></p>
<p>For text data, after conversion of text to sparse matrix, go for Singular Value Decomposition (SVD). A variation of SVD called TruncatedSVD can be found in scikit-learn.</p>
<p><a href="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_decomp.png"><img src="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_decomp.png" alt="abhishek_decomp" width="681" height="180" class="aligncenter size-full wp-image-5999" srcset="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_decomp.png 681w, http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_decomp-300x79.png 300w, http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_decomp-100x26.png 100w" sizes="(max-width: 681px) 100vw, 681px" /></a></p>
<p>The number of SVD components that generally work for TF-IDF or counts are between 120-200. Any number above this might improve the performance but not substantially and comes at the cost of computing power.</p>
<p>After evaluating further performance of the models, we move to scaling of the datasets, so that we can evaluate linear models too. The normalized or scaled features can then be sent to the machine learning models or feature selection modules.</p>
<p><a href="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_19.png"><img src="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_19.png" alt="abhishek_19" width="543" height="156" class="aligncenter size-full wp-image-5991" srcset="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_19.png 543w, http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_19-300x86.png 300w, http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_19-100x29.png 100w" sizes="(max-width: 543px) 100vw, 543px" /></a></p>
<p>There are multiple ways in which feature selection can be achieved. One of the most common way is greedy feature selection (forward or backward). In greedy feature selection we choose one feature, train a model and evaluate the performance of the model on a fixed evaluation metric. We keep adding and removing features one-by-one and record performance of the model at every step. We then select the features which have the best evaluation score. One implementation of greedy feature selection with AUC as evaluation metric can be found here: <a href="https://github.com/abhishekkrthakur/greedyFeatureSelection" target="_blank" rel="nofollow">https://github.com/abhishekkrthakur/greedyFeatureSelection</a>. It must be noted that this implementation is not perfect and must be changed/modified according to the requirements.</p>
<p>Other faster methods of feature selection include selecting best features from a model. We can either look at coefficients of a logit model or we can train a random forest to select best features and then use them later with other machine learning models.</p>
<p><a href="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_20.png"><img src="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_20.png" alt="abhishek_20" width="800" height="177" class="aligncenter size-full wp-image-5992" srcset="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_20.png 800w, http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_20-300x66.png 300w, http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_20-768x170.png 768w, http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_20-100x22.png 100w" sizes="(max-width: 800px) 100vw, 800px" /></a></p>
<p>Remember to keep low number of estimators and minimal optimization of hyper parameters so that you don’t overfit.</p>
<p>The feature selection can also be achieved using Gradient Boosting Machines. It is good if we use xgboost instead of the implementation of GBM in scikit-learn since xgboost is much faster and more scalable.</p>
<p><a href="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_21.png"><img src="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_21.png" alt="abhishek_21" width="800" height="213" class="aligncenter size-full wp-image-5993" srcset="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_21.png 800w, http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_21-300x80.png 300w, http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_21-768x204.png 768w, http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_21-100x27.png 100w" sizes="(max-width: 800px) 100vw, 800px" /></a></p>
<p>We can also do feature selection of sparse datasets using RandomForestClassifier / RandomForestRegressor and xgboost.</p>
<p>Another popular method for feature selection from positive sparse datasets is chi-2 based feature selection and we also have that implemented in scikit-learn.</p>
<p><a href="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_22.png"><img src="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_22.png" alt="abhishek_22" width="722" height="183" class="aligncenter size-full wp-image-5994" srcset="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_22.png 722w, http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_22-300x76.png 300w, http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_22-100x25.png 100w" sizes="(max-width: 722px) 100vw, 722px" /></a></p>
<p>Here, we use chi2 in conjunction with SelectKBest to select 20 features from the data. This also becomes a hyperparameter we want to optimize to improve the result of our machine learning models.</p>
<p>Don’t forget to dump any kinds of transformers you use at all the steps. You will need them to evaluate performance on the validation set.</p>
<p>Next (or intermediate) major step is model selection + hyperparameter optimization.</p>
<p><a href="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_23.png"><img src="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_23.png" alt="abhishek_23" width="387" height="400" class="aligncenter size-full wp-image-5995" srcset="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_23.png 387w, http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_23-290x300.png 290w, http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_23-100x103.png 100w" sizes="(max-width: 387px) 100vw, 387px" /></a></p>
<p>We generally use the following algorithms in the process of selecting a machine learning model:</p>
<ul>
<li><strong><span class="underline">Classification</span></strong>:</li>
<ul>
<li>Random Forest</li>
<li>GBM</li>
<li>Logistic Regression</li>
<li>Naive Bayes</li>
<li>Support Vector Machines</li>
<li>k-Nearest Neighbors</li>
</ul>
</ul>
<ul>
<li><strong><span class="underline">Regression</span></strong></li>
<ul>
<li>Random Forest</li>
<li>GBM</li>
<li>Linear Regression</li>
<li>Ridge</li>
<li>Lasso</li>
<li>SVR</li>
</ul>
</ul>
<p><strong><br /></strong>Which parameters should I optimize? How do I choose parameters closest to the best ones? These are a couple of questions people come up with most of the time. One cannot get answers to these questions without experience with different models + parameters on a large number of datasets. Also people who have experience are not willing to share their secrets. Luckily, I have quite a bit of experience too and I’m willing to give away some of the stuff.</p>
<p>Let’s break down the hyperparameters, model wise:</p>
<p><a href="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_24.png"><img src="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_24.png" alt="abhishek_24" width="785" height="800" class="aligncenter size-full wp-image-5996" srcset="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_24.png 785w, http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_24-294x300.png 294w, http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_24-768x783.png 768w, http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_24-100x102.png 100w" sizes="(max-width: 785px) 100vw, 785px" /></a></p>
<p>RS* = Cannot say about proper values, go for Random Search in these hyperparameters.</p>
<p>In my opinion, and strictly my opinion, the above models will out-perform any others and we don’t need to evaluate any other models.</p>
<p>Once again, remember to save the transformers:</p>
<p><a href="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_25.png"><img src="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_25.png" alt="abhishek_25" width="800" height="444" class="aligncenter size-full wp-image-5997" srcset="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_25.png 800w, http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_25-300x167.png 300w, http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_25-768x426.png 768w, http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_25-100x56.png 100w" sizes="(max-width: 800px) 100vw, 800px" /></a></p>
<p>And apply them on validation set separately:</p>
<p><a href="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_26.png"><img src="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_26.png" alt="abhishek_26" width="800" height="184" class="aligncenter size-full wp-image-5998" srcset="http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_26.png 800w, http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_26-300x69.png 300w, http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_26-768x177.png 768w, http://5047-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/07/abhishek_26-100x23.png 100w" sizes="(max-width: 800px) 100vw, 800px" /></a></p>
<p>The above rules and the framework has performed very well in most of the datasets I have dealt with. Of course, it has also failed for very complicated tasks. Nothing is perfect and we keep on improving on what we learn. Just like in machine learning.</p>
