## Deep Learning Libraries by Language

<div class="entry-content">
	      <p dir="ltr"><strong>Python</strong></p><ol><li dir="ltr"><p dir="ltr"><a href="http://deeplearning.net/software/theano">Theano</a> is a python library for defining and evaluating mathematical expressions with numerical arrays. It makes it easy to write deep learning algorithms in python. On the top of the Theano many more libraries are built.</p><ol><li dir="ltr"><p dir="ltr"><a href="http://keras.io/">Keras</a> is a minimalist, highly modular neural network library in the spirit of Torch, written in Python, that uses Theano under the hood for optimized tensor manipulation on GPU and CPU.</p></li><li dir="ltr"><p dir="ltr"><a href="http://deeplearning.net/software/pylearn2/">Pylearn2</a> is a library that wraps a lot of models and training algorithms such as Stochastic Gradient Descent that are commonly used in Deep Learning. Its functional libraries are built on top of Theano. </p></li><li dir="ltr"><p dir="ltr"><a href="https://github.com/Lasagne/Lasagne">Lasagne</a> is a lightweight library to build and train neural networks in Theano. It is governed by simplicity, transparency, modularity, pragmatism , focus and restraint principles.</p></li><li dir="ltr"><p dir="ltr"><a href="https://github.com/mila-udem/blocks">Blocks</a> a framework that helps you build neural network models on top of Theano.</p></li></ol></li><li dir="ltr"><p dir="ltr"><a href="http://caffe.berkeleyvision.org/">Caffe</a> is a deep learning framework made with expression, speed, and modularity in mind. It is developed by the Berkeley Vision and Learning Center (BVLC) and by community contributors. Google's <a href="http://venturebeat.com/2015/07/01/google-open-sources-its-software-for-making-trippy-images-with-deep-learning/">DeepDream</a> is based on Caffe Framework. This framework is a BSD-licensed C++ library with Python Interface.</p></li><li dir="ltr"><p dir="ltr"><a href="https://github.com/dnouri/nolearn"><em>nolearn</em></a> contains a number of wrappers and abstractions around existing neural network libraries, most notably<a href="http://lasagne.readthedocs.org/"> Lasagne</a>, along with a few machine learning utility modules.</p></li><li dir="ltr"><p dir="ltr"><a href="http://radimrehurek.com/gensim/">Gensim</a> is deep learning toolkit implemented in python programming language intended for handling large text collections, using efficient algorithms.</p></li><li dir="ltr"><p dir="ltr"><a href="http://chainer.org/">Chainer</a> bridge the gap between algorithms and implementations of deep learning. Its powerful, flexible and intuitive and is considered as the <a href="http://www.slideshare.net/beam2d/introduction-to-chainer-a-flexible-framework-for-deep-learning">flexible framework</a> for Deep Learning. </p></li><li dir="ltr"><p dir="ltr"><a href="https://github.com/nitishsrivastava/deepnet">deepnet</a> is a GPU-based python implementation of deep learning algorithms like Feed-forward Neural Nets, Restricted Boltzmann Machines, Deep Belief Nets, Autoencoders, Deep Boltzmann Machines and Convolutional Neural Nets.</p></li><li dir="ltr"><p dir="ltr"><a href="https://github.com/hannes-brt/hebel">Hebel</a> is a library for deep learning with neural networks in Python using GPU acceleration with CUDA through PyCUDA. It implements the most important types of neural network models and offers a variety of different activation functions and training methods such as momentum, Nesterov momentum, dropout, and early stopping.</p></li><li dir="ltr"><p dir="ltr"><a href="https://github.com/dmlc/cxxnet">CXXNET</a> is fast, concise, distributed deep learning framework based on MShadow. It is a lightweight and easy extensible C++/CUDA neural network toolkit with friendly Python/Matlab interface for training and prediction.</p></li><li dir="ltr"><p dir="ltr"><a href="https://github.com/andersbll/deeppy">DeepPy</a> is a Pythonic deep learning framework built on top of NumPy.</p></li><li dir="ltr"><p dir="ltr"><a href="https://github.com/vishwa-raman/DeepLearning">DeepLearning</a> is deep learning library, developed with C++ and python.</p></li><li dir="ltr"><p dir="ltr"><a href="https://github.com/NervanaSystems/neon">Neon</a> is Nervana's Python based Deep Learning framework.</p></li></ol><p dir="ltr"><strong>Matlab</strong></p><ol><li dir="ltr"><p dir="ltr"><a href="https://github.com/sdemyanov/ConvNet">ConvNet</a> Convolutional neural net is a type of deep learning classification algorithms, that can learn useful features from raw data by themselves and is performed by tuning its weighs. </p></li><li dir="ltr"><p dir="ltr"><a href="https://github.com/rasmusbergpalm/DeepLearnToolbox">DeepLearnToolBox</a> is a matlab/octave toolbox for deep learning and includes Deep Belief Nets, Stacked Autoencoders, convolutional neural nets.</p></li><li dir="ltr"><p dir="ltr"><a href="https://code.google.com/p/cuda-convnet/">cuda-convnet</a> is a fast C++/CUDA implementation of convolutional (or more generally, feed-forward) neural networks. It can model arbitrary layer connectivity and network depth. Any directed acyclic graph of layers will do. Training is done using the backpropagation algorithm.</p></li><li dir="ltr"><p dir="ltr"><span><a href="http://www.vlfeat.org/matconvnet/" title="MatConvNet">MatConvNet</a> &#160;</span><span>is a MATLAB toolbox implementing Convolutional Neural Networks (CNNs) for computer vision applications. It is simple, efficient, and can run and learn state-of-the-art CNNs</span></p></li></ol><p dir="ltr"><strong>CPP</strong></p><ol><li dir="ltr"><p dir="ltr"><a href="http://eblearn.sourceforge.net/index.shtml">eblearn</a> is an open-source C++ library of machine learning by New York University’s machine learning lab, led by Yann LeCun. In particular, implementations of convolutional neural networks with energy-based models along with a GUI, demos and tutorials.</p></li><li dir="ltr"><p dir="ltr"><a href="http://www.comp.nus.edu.sg/~dbsystem/singa/">SINGA</a> is designed to be general to implement the distributed training algorithms of existing systems. It is supported by Apache Software Foundation.</p></li><li dir="ltr"><p dir="ltr">NVIDIA<a href="https://developer.nvidia.com/digits"> DIGITS</a> is a new system for developing, training and visualizing deep neural networks. It puts the power of deep learning into an intuitive browser-based interface, so that data scientists and researchers can quickly design the best DNN for their data using real-time network behavior visualization. </p></li><li dir="ltr"><p dir="ltr"><a href="https://01.org/intel-deep-learning-framework">Intel® Deep Learning Framework</a> provides a unified framework for Intel® platforms accelerating Deep Convolutional Neural Networks.</p></li></ol><p dir="ltr"><strong>Java</strong></p><ol><li dir="ltr"><p dir="ltr"><a href="http://nd4j.org/">N-Dimensional Arrays for Java</a> (ND4J)is scientific computing libraries for the JVM. They are meant to be used in production environments, which means routines are designed to run fast with minimum RAM requirements.</p></li><li dir="ltr"><p dir="ltr"><a href="http://deeplearning4j.org/">Deeplearning4j</a> is the first commercial-grade, open-source, distributed deep-learning library written for Java and Scala. It is designed to be used in business environments, rather than as a research tool.</p></li><li dir="ltr"><p dir="ltr"><a href="http://www.heatonresearch.com/encog">Encog</a> is an advanced machine learning framework which supports Support Vector Machines,Artificial Neural Networks, Genetic Programming, Bayesian Networks, Hidden Markov Models, Genetic Programming and Genetic Algorithms are supported.</p></li></ol><p dir="ltr"><strong>JavaScript</strong></p><ol><li dir="ltr"><p dir="ltr"><a href="http://cs.stanford.edu/people/karpathy/convnetjs/">Convnet.js</a> is a Javascript library for training Deep Learning models (mainly Neural Networks) entirely in a browser. No software requirements, no compilers, no installations, no GPUs, no sweat. </p></li></ol><p dir="ltr"><strong>Lua</strong></p><ol><li dir="ltr"><p dir="ltr"><a href="http://torch.ch/">Torch</a> is a scientific computing framework with wide support for machine learning algorithms. It is easy to use and efficient, fast scripting language, LuaJIT, and an underlying C/CUDA implementation. Torch is based on Lua programming language.</p></li></ol><p dir="ltr"><strong>Julia</strong></p><ol><li dir="ltr"><p dir="ltr"><a href="https://github.com/pluskid/Mocha.jl">Mocha</a> is a Deep Learning framework for Julia, inspired by the C++ framework Caffe. Efficient implementations of general stochastic gradient solvers and common layers in Mocha could be used to train deep / shallow (convolutional) neural networks, with (optional) unsupervised pre-training via (stacked) auto-encoders. Its best feature include Modular architecture, High-level Interface, portability with speed, compatibility and many more.</p></li></ol><p dir="ltr"><strong>Lisp</strong></p><ol><li dir="ltr"><p dir="ltr"><a href="http://lush.sourceforge.net/">Lush(Lisp Universal Shell)</a> is an object-oriented programming language designed for researchers, experimenters, and engineers interested in large-scale numerical and graphic applications. It comes with rich set of deep learning libraries as a part of machine learning libraries. </p></li></ol><p dir="ltr"><strong>Haskell</strong></p><ol><li dir="ltr"><p dir="ltr"><a href="https://github.com/ajtulloch/dnngraph">DNNGraph</a> is a deep neural network model generation DSL in Haskell.</p></li></ol><p><strong>.NET</strong></p><ol><li><span><a href="http://accord-framework.net/" title="Accord.NET">Accord.NET</a> is a .NET machine learning framework combined with audio and image processing libraries completely written in C#. It is a complete framework for building production-grade computer vision, computer audition, signal processing and statistics applications</span></li></ol><p><strong>R</strong></p><ol><li><span><a href="http://cran.um.ac.ir/web/packages/darch/index.html" title="darch">darch</a> package can be used for generating neural networks with many layers (deep architectures). Training methods includes a pre training with the contrastive divergence method and a fine tuning with common known training algorithms like backpropagation or conjugate gradient.</span></li><li><a href="https://cran.r-project.org/web/packages/deepnet/index.html" title="deepnet">deepnet</a> implements some deep learning architectures and neural network algorithms, including BP,RBM,DBN,Deep autoencoder and so on.</li></ol>
	    </div>
