</div><p>In this post, we take a tour of the most popular machine learning algorithms.</p>
<p>It is useful to tour the main algorithms in the field to get a feeling of what methods are available.</p>
<p>There are so many algorithms available that it can feel overwhelming when algorithm names are thrown around and you are expected to just know what they are and where they fit.</p>
<p>I want to give you two ways to think about and categorize the algorithms you may come across in the field.</p>
<ul>
<li>The first is a grouping of algorithms by the <strong>learning style</strong>.</li>
<li>The second is a grouping of algorithms by <strong>similarity</strong> in form or function (like grouping similar animals together).</li>
</ul>
<p>Both approaches are useful, but we will focus in on the grouping of algorithms by similarity and go on a tour of a variety of different algorithm types.</p>
<p>After reading this post, you will have a much better understanding of the most popular machine learning algorithms for supervised learning and how they are related.</p>
<div id="attachment_98" style="max-width: 465px" class="wp-caption aligncenter"><img class="wp-image-98 size-full" src="https://3qeqpr26caki16dnhd19sv6by6v-wpengine.netdna-ssl.com/wp-content/uploads/2013/11/ensemble.png" alt="Ensemble Learning Method" width="455" height="383" srcset="https://3qeqpr26caki16dnhd19sv6by6v-wpengine.netdna-ssl.com/wp-content/uploads/2013/11/ensemble.png 455w, https://3qeqpr26caki16dnhd19sv6by6v-wpengine.netdna-ssl.com/wp-content/uploads/2013/11/ensemble-300x252.png 300w" sizes="(max-width: 455px) 100vw, 455px" /><p class="wp-caption-text">A cool example of an ensemble of lines of best fit. Weak members are grey, the combined prediction is red.<br />Plot from Wikipedia, licensed under public domain.</p></div>
<h2>Algorithms Grouped by Learning Style</h2>
<p>There are different ways an algorithm can model a problem based on its interaction with the experience or environment or whatever we want to call the input data.</p>
<p>It is popular in machine learning and artificial intelligence textbooks to first consider the learning styles that an algorithm can adopt.</p>
<p>There are only a few main learning styles or learning models that an algorithm can have and we&#8217;ll go through them here with a few examples of algorithms and problem types that they suit.</p>
<p>This taxonomy or way of organizing machine learning algorithms is useful because it forces you to think about the roles of the input data and the model preparation process and select one that is the most appropriate for your problem in order to get the best result.</p>
<p>Let&#8217;s take a look at three different learning styles in machine learning algorithms:</p>
<h3><strong>1. Supervised Learning</strong></h3>
<p><img class="alignright size-full wp-image-2033" src="https://3qeqpr26caki16dnhd19sv6by6v-wpengine.netdna-ssl.com/wp-content/uploads/2013/11/Supervised-Learning-Algorithms.png" alt="Supervised Learning Algorithms" width="230" height="262" />Input data is called training data and has a known label or result such as spam/not-spam or a stock price at a time.</p>
<p>A model is prepared through a training process in which it is required to make predictions and is corrected when those predictions are wrong. The training process continues until the model achieves a desired level of accuracy on the training data.</p>
<p>Example problems are classification and regression.</p>
<p>Example algorithms include Logistic Regression and the Back Propagation Neural Network.</p>
<h3><strong>2. Unsupervised Learning</strong></h3>
<p><img class="alignright size-full wp-image-2034" src="https://3qeqpr26caki16dnhd19sv6by6v-wpengine.netdna-ssl.com/wp-content/uploads/2013/11/Unsupervised-Learning-Algorithms.png" alt="Unsupervised Learning Algorithms" width="234" height="264" />Input data is not labeled and does not have a known result.</p>
<p>A model is prepared by deducing structures present in the input data. This may be to extract general rules. It may be through a mathematical process to systematically reduce redundancy, or it may be to organize data by similarity.</p>
<p>Example problems are clustering, dimensionality reduction and association rule learning.</p>
<p>Example algorithms include: the Apriori algorithm and k-Means.</p>
<h3><strong>3. Semi-Supervised Learning</strong></h3>
<p><a href="https://3qeqpr26caki16dnhd19sv6by6v-wpengine.netdna-ssl.com/wp-content/uploads/2013/11/Semi-supervised-Learning-Algorithms.png"><img class="alignright size-full wp-image-2035" src="https://3qeqpr26caki16dnhd19sv6by6v-wpengine.netdna-ssl.com/wp-content/uploads/2013/11/Semi-supervised-Learning-Algorithms.png" alt="Semi-supervised Learning Algorithms" width="231" height="271" /></a>Input data is a mixture of labeled and unlabelled examples.</p>
<p>There is a desired prediction problem but the model must learn the structures to organize the data as well as make predictions.</p>
<p>Example problems are classification and regression.</p>
<p>Example algorithms are extensions to other flexible methods that make assumptions about how to model the unlabeled data.</p>
<h3>Overview</h3>
<p>When crunching data to model business decisions, you are most typically using supervised and unsupervised learning methods.</p>
<p>A hot topic at the moment is semi-supervised learning methods in areas such as image classification where there are large datasets with very few labeled examples.</p>
<!-- Start shortcoder --><h2 style="text-align: center;">Get your FREE Algorithms Mind Map</h2>
<div id="attachment_2021" style="max-width: 395px" class="wp-caption alignleft"><img class="wp-image-2021 size-full" src="https://3qeqpr26caki16dnhd19sv6by6v-wpengine.netdna-ssl.com/wp-content/uploads/2013/11/Machine-Learning-Algorithms-Mindmap-Sample.png" alt="Machine Learning Algorithms Mind Map" width="385" height="248" /><p class="wp-caption-text">Sample of the handy machine learning algorithms mind map.</p></div>
<p>I've created a handy mind map of 60+ algorithms organized by type.</p>
<p>Download it, print it and use it. </p>
<center><a style="color: #ffffff; text-decoration: none; font-family: Helvetica, Arial, sans-serif; font-weight: bold; font-size: 16px; line-height: 20px; padding: 10px; display: inline-block; max-width: 300px; border-radius: 5px; text-shadow: rgba(0, 0, 0, 0.247059) 0px -1px 1px; box-shadow: rgba(255, 255, 255, 0.498039) 0px 1px 3px inset, rgba(0, 0, 0, 0.498039) 0px 1px 3px; background: #ffce0a;" href="https://machinelearningmastery.leadpages.co/leadbox/147764973f72a2%3A164f8be4f346dc/5752754626625536/" target="_blank">Download For Free</a>
<p><br />Also get exclusive access to the machine learning algorithms email mini-course.</p>
</center>
<p>&nbsp;</p>
<p>&nbsp;</p><!-- End shortcoder v4.1.2-->
<h2>Algorithms Grouped By Similarity</h2>
<p>Algorithms are often grouped by similarity in terms of their function (how they work). For example, tree-based methods, and neural network inspired methods.</p>
<p>I think this is the most useful way to group algorithms and it is the approach we will use here.</p>
<p>This is a useful grouping method, but it is not perfect. There are still algorithms that could just as easily fit into multiple categories like Learning Vector Quantization that is both a neural network inspired method and an instance-based method. There are also categories that have the same name that describe the problem and the class of algorithm such as Regression and Clustering.</p>
<p>We could handle these cases by listing algorithms twice or by selecting the group that subjectively is the &#8220;best&#8221; fit. I like this latter approach of not duplicating algorithms to keep things simple.</p>
<p>In this section, I list many of the popular machine learning algorithms grouped the way I think is the most intuitive. The list is not exhaustive in either the groups or the algorithms, but I think it is representative and will be useful to you to get an idea of the lay of the land.</p>
<p><strong>Please Note</strong>: There is a strong bias towards algorithms used for classification and regression, the two most prevalent supervised machine learning problems you will encounter.</p>
<p>If you know of an algorithm or a group of algorithms not listed, put it in the comments and share it with us. Let&#8217;s dive in.</p>
<h3>Regression Algorithms</h3>
<p><img class="alignright size-full wp-image-2022" src="https://3qeqpr26caki16dnhd19sv6by6v-wpengine.netdna-ssl.com/wp-content/uploads/2013/11/Regression-Algorithms.png" alt="Regression Algorithms" width="208" height="229" />Regression is concerned with modeling the relationship between variables that is iteratively refined using a measure of error in the predictions made by the model.</p>
<p>Regression methods are a workhorse of statistics and have been co-opted into statistical machine learning. This may be confusing because we can use regression to refer to the class of problem and the class of algorithm. Really, regression is a process.</p>
<p>The most popular regression algorithms are:</p>
<ul>
<li>Ordinary Least Squares Regression (OLSR)</li>
<li>Linear Regression</li>
<li>Logistic Regression</li>
<li>Stepwise Regression</li>
<li>Multivariate Adaptive Regression Splines (MARS)</li>
<li>Locally Estimated Scatterplot Smoothing (LOESS)</li>
</ul>
<h3>Instance-based Algorithms</h3>
<p><img class="alignright size-full wp-image-2023" src="https://3qeqpr26caki16dnhd19sv6by6v-wpengine.netdna-ssl.com/wp-content/uploads/2013/11/Instance-based-Algorithms.png" alt="Instance-based Algorithms" width="216" height="246" />Instance-based learning model is a decision problem with instances or examples of training data that are deemed important or required to the model.</p>
<p>Such methods typically build up a database of example data and compare new data to the database using a similarity measure in order to find the best match and make a prediction. For this reason, instance-based methods are also called winner-take-all methods and memory-based learning. Focus is put on the representation of the stored instances and similarity measures used between instances.</p>
<p>The most popular instance-based algorithms are:</p>
<ul>
<li>k-Nearest Neighbor (kNN)</li>
<li>Learning Vector Quantization (LVQ)</li>
<li>Self-Organizing Map (SOM)</li>
<li>Locally Weighted Learning (LWL)</li>
</ul>
<h3>Regularization Algorithms</h3>
<p><img class="alignright size-full wp-image-2024" src="https://3qeqpr26caki16dnhd19sv6by6v-wpengine.netdna-ssl.com/wp-content/uploads/2013/11/Regularization-Algorithms.png" alt="Regularization Algorithms" width="214" height="245" />An extension made to another method (typically regression methods) that penalizes models based on their complexity, favoring simpler models that are also better at generalizing.</p>
<p>I have listed regularization algorithms separately here because they are popular, powerful and generally simple modifications made to other methods.</p>
<p>The most popular regularization algorithms are:</p>
<ul>
<li>Ridge Regression</li>
<li>Least Absolute Shrinkage and Selection Operator (LASSO)</li>
<li>Elastic Net</li>
<li>Least-Angle Regression (LARS)</li>
</ul>
<h3>Decision Tree Algorithms</h3>
<p><img class="alignright size-full wp-image-2025" src="https://3qeqpr26caki16dnhd19sv6by6v-wpengine.netdna-ssl.com/wp-content/uploads/2013/11/Decision-Tree-Algorithms.png" alt="Decision Tree Algorithms" width="214" height="243" />Decision tree methods construct a model of decisions made based on actual values of attributes in the data.</p>
<p>Decisions fork in tree structures until a prediction decision is made for a given record. Decision trees are trained on data for classification and regression problems. Decision trees are often fast and accurate and a big favorite in machine learning.</p>
<p>The most popular decision tree algorithms are:</p>
<ul>
<li>Classification and Regression Tree (CART)</li>
<li>Iterative Dichotomiser 3 (ID3)</li>
<li>C4.5 and C5.0 (different versions of a powerful approach)</li>
<li>Chi-squared Automatic Interaction Detection (CHAID)</li>
<li>Decision Stump</li>
<li>M5</li>
<li>Conditional Decision Trees</li>
</ul>
<h3>Bayesian Algorithms</h3>
<p><img class="alignright size-full wp-image-2026" src="https://3qeqpr26caki16dnhd19sv6by6v-wpengine.netdna-ssl.com/wp-content/uploads/2013/11/Bayesian-Algorithms.png" alt="Bayesian Algorithms" width="219" height="239" />Bayesian methods are those that explicitly apply Bayes&#8217; Theorem for problems such as classification and regression.</p>
<p>The most popular Bayesian algorithms are:</p>
<ul>
<li>Naive Bayes</li>
<li>Gaussian Naive Bayes</li>
<li>Multinomial Naive Bayes</li>
<li>Averaged One-Dependence Estimators (AODE)</li>
<li>Bayesian Belief Network (BBN)</li>
<li>Bayesian Network (BN)</li>
</ul>
<h3>Clustering Algorithms</h3>
<p><img class="alignright size-full wp-image-2027" src="https://3qeqpr26caki16dnhd19sv6by6v-wpengine.netdna-ssl.com/wp-content/uploads/2013/11/Clustering-Algorithms.png" alt="Clustering Algorithms" width="213" height="227" />Clustering, like regression, describes the class of problem and the class of methods.</p>
<p>Clustering methods are typically organized by the modeling approaches such as centroid-based and hierarchal. All methods are concerned with using the inherent structures in the data to best organize the data into groups of maximum commonality.</p>
<p>The most popular clustering algorithms are:</p>
<ul>
<li>k-Means</li>
<li>k-Medians</li>
<li>Expectation Maximisation (EM)</li>
<li>Hierarchical Clustering</li>
</ul>
<h3>Association Rule Learning Algorithms</h3>
<p><img class="alignright size-full wp-image-2028" src="https://3qeqpr26caki16dnhd19sv6by6v-wpengine.netdna-ssl.com/wp-content/uploads/2013/11/Assoication-Rule-Learning-Algorithms.png" alt="Assoication Rule Learning Algorithms" width="215" height="250" />Association rule learning methods extract rules that best explain observed relationships between variables in data.</p>
<p>These rules can discover important and commercially useful associations in large multidimensional datasets that can be exploited by an organization.</p>
<p>The most popular association rule learning algorithms are:</p>
<ul>
<li>Apriori algorithm</li>
<li>Eclat algorithm</li>
</ul>
<h3>Artificial Neural Network Algorithms</h3>
<p><img class="alignright size-full wp-image-2029" src="https://3qeqpr26caki16dnhd19sv6by6v-wpengine.netdna-ssl.com/wp-content/uploads/2013/11/Artificial-Neural-Network-Algorithms.png" alt="Artificial Neural Network Algorithms" width="208" height="249" />Artificial Neural Networks are models that are inspired by the structure and/or function of biological neural networks.</p>
<p>They are a class of pattern matching that are commonly used for regression and classification problems but are really an enormous subfield comprised of hundreds of algorithms and variations for all manner of problem types.</p>
<p>Note that I have separated out Deep Learning from neural networks because of the massive growth and popularity in the field. Here we are concerned with the more classical methods.</p>
<p>The most popular artificial neural network algorithms are:</p>
<ul>
<li>Perceptron</li>
<li>Back-Propagation</li>
<li>Hopfield Network</li>
<li>Radial Basis Function Network (RBFN)</li>
</ul>
<h3>Deep Learning Algorithms</h3>
<p><img class="alignright size-full wp-image-2030" src="https://3qeqpr26caki16dnhd19sv6by6v-wpengine.netdna-ssl.com/wp-content/uploads/2013/11/Deep-Learning-Algorithms.png" alt="Deep Learning Algorithms" width="215" height="246" />Deep Learning methods are a modern update to Artificial Neural Networks that exploit abundant cheap computation.</p>
<p>They are concerned with building much larger and more complex neural networks and, as commented on above, many methods are concerned with semi-supervised learning problems where large datasets contain very little labeled data.</p>
<p>The most popular deep learning algorithms are:</p>
<ul>
<li>Deep Boltzmann Machine (DBM)</li>
<li>Deep Belief Networks (DBN)</li>
<li>Convolutional Neural Network (CNN)</li>
<li>Stacked Auto-Encoders</li>
</ul>
<h3>Dimensionality Reduction Algorithms</h3>
<p><img class="alignright size-full wp-image-2031" src="https://3qeqpr26caki16dnhd19sv6by6v-wpengine.netdna-ssl.com/wp-content/uploads/2013/11/Dimensional-Reduction-Algorithms.png" alt="Dimensional Reduction Algorithms" width="212" height="248" />Like clustering methods, dimensionality reduction seek and exploit the inherent structure in the data, but in this case in an unsupervised manner or order to summarize or describe data using less information.</p>
<p>This can be useful to visualize dimensional data or to simplify data which can then be used in a supervised learning method. Many of these methods can be adapted for use in classification and regression.</p>
<ul>
<li>Principal Component Analysis (PCA)</li>
<li>Principal Component Regression (PCR)</li>
<li>Partial Least Squares Regression (PLSR)</li>
<li>Sammon Mapping</li>
<li>Multidimensional Scaling (MDS)</li>
<li>Projection Pursuit</li>
<li>Linear Discriminant Analysis (LDA)</li>
<li>Mixture Discriminant Analysis (MDA)</li>
<li>Quadratic Discriminant Analysis (QDA)</li>
<li>Flexible Discriminant Analysis (FDA)</li>
</ul>
<h3>Ensemble Algorithms</h3>
<p><img class="alignright size-full wp-image-2032" src="https://3qeqpr26caki16dnhd19sv6by6v-wpengine.netdna-ssl.com/wp-content/uploads/2013/11/Ensemble-Algorithms.png" alt="Ensemble Algorithms" width="210" height="230" />Ensemble methods are models composed of multiple weaker models that are independently trained and whose predictions are combined in some way to make the overall prediction.</p>
<p>Much effort is put into what types of weak learners to combine and the ways in which to combine them. This is a very powerful class of techniques and as such is very popular.</p>
<ul>
<li>Boosting</li>
<li>Bootstrapped Aggregation (Bagging)</li>
<li>AdaBoost</li>
<li>Stacked Generalization (blending)</li>
<li>Gradient Boosting Machines (GBM)</li>
<li>Gradient Boosted Regression Trees (GBRT)</li>
<li>Random Forest</li>
</ul>
<h3>Other Algorithms</h3>
<p>Many algorithms were not covered.</p>
<p>For example, what group would Support Vector Machines go into? Its own?</p>
<p>I did not cover algorithms from specialty tasks in the process of machine learning, such as:</p>
<ul>
<li>Feature selection algorithms</li>
<li>Algorithm accuracy evaluation</li>
<li>Performance measures</li>
</ul>
<p>I also did not cover algorithms from specialty subfields of machine learning, such as:</p>
<ul>
<li>Computational intelligence (evolutionary algorithms, etc.)</li>
<li>Computer Vision (CV)</li>
<li>Natural Language Processing (NLP)</li>
<li>Recommender Systems</li>
<li>Reinforcement Learning</li>
<li>Graphical Models</li>
<li>And more&#8230;</li>
</ul>
<p>These may feature in future posts.</p>
<h2>Further Reading</h2>
<p>This tour of machine learning algorithms was intended to give you an overview of what is out there and some ideas on how to relate algorithms to each other.</p>
<p>I&#8217;ve collected together some resources for you to continue your reading on algorithms. If you have a specific question, please leave a comment.</p>
<h3>Other Lists of Algorithms</h3>
<p>There are other great lists of algorithms out there if you&#8217;re interested. Below are few hand selected examples.</p>
<ul>
<li><a href="http://en.wikipedia.org/wiki/List_of_machine_learning_algorithms">List of Machine Learning Algorithms</a>: On Wikipedia. Although extensive, I do not find this list or the organization of the algorithms particularly useful.</li>
<li><a href="http://en.wikipedia.org/wiki/Category:Machine_learning_algorithms">Machine Learning Algorithms Category</a>: Also on Wikipedia, slightly more useful than Wikipedias great list above. It organizes algorithms alphabetically.</li>
<li><a href="http://cran.r-project.org/web/views/MachineLearning.html">CRAN Task View: Machine Learning &amp; Statistical Learning</a>: A list of all the packages and all the algorithms supported by each machine learning package in R. Gives you a grounded feeling of what&#8217;s out there and what people are using for analysis day-to-day.</li>
<li><a href="http://www.cs.uvm.edu/~icdm/algorithms/index.shtml">Top 10 Algorithms in Data Mining</a>: <a href="http://link.springer.com/article/10.1007/s10115-007-0114-2">Published article</a> and now a <a class="easyazon-link"  href="http://www.amazon.com/dp/1420089641?tag=inspiredalgor-20">book</a> (Affiliate Link) on the most popular algorithms for data mining. Another grounded and less overwhelming take on methods that you could go off and learn deeply.</li>
</ul>
<h3>How to Study Machine Learning Algorithms</h3>
<p>Algorithms are a big part of machine learning. It&#8217;s a topic I am passionate about and write about a lot on this blog. Below are few hand selected posts that might interest you for further reading.</p>
<ul>
<li><a href="http://machinelearningmastery.com/how-to-learn-a-machine-learning-algorithm/">How to Learn Any Machine Learning Algorithm</a>: A systematic approach that you can use to study and understand any machine learning algorithm using &#8220;algorithm description templates&#8221; (I used this approach to write <a href="http://cleveralgorithms.com/nature-inspired/index.html">my first book</a>).</li>
<li><a href="http://machinelearningmastery.com/create-lists-of-machine-learning-algorithms/">How to Create Targeted Lists of Machine Learning Algorithms</a>: How you can create your own systematic lists of machine learning algorithms to jump start work on your next machine learning problem.</li>
<li><a href="http://machinelearningmastery.com/how-to-research-a-machine-learning-algorithm/">How to Research a Machine Learning Algorithm</a>: A systematic approach that you can use to research machine learning algorithms (works great in collaboration with the template approach listed above).</li>
<li><a href="http://machinelearningmastery.com/how-to-investigate-machine-learning-algorithm-behavior/">How to Investigate Machine Learning Algorithm Behavior</a>: A methodology you can use to understand how machine learning algorithms work by creating and executing very small studies into their behavior. Research is not just for academics!</li>
<li><a href="http://machinelearningmastery.com/how-to-implement-a-machine-learning-algorithm/">How to Implement a Machine Learning Algorithm</a>: A process and tips and tricks for implementing machine learning algorithms from scratch.</li>
</ul>
<h3>How to Run Machine Learning Algorithms</h3>
<p>Sometimes you just want to dive into code. Below are some links you can use to run machine learning algorithms, code them up using standard libraries or implement them from scratch.</p>
<ul>
<li><a href="http://machinelearningmastery.com/how-to-get-started-with-machine-learning-algorithms-in-r/">How To Get Started With Machine Learning Algorithms in R</a>: Links to a large number of code examples on this site demonstrating machine learning algorithms in R.</li>
<li><a href="http://machinelearningmastery.com/get-your-hands-dirty-with-scikit-learn-now/">Machine Learning Algorithm Recipes in scikit-learn</a>: A collection of Python code examples demonstrating how to create predictive models using scikit-learn.</li>
<li><a href="http://machinelearningmastery.com/how-to-run-your-first-classifier-in-weka/">How to Run Your First Classifier in Weka</a>: A tutorial for running your very first classifier in Weka (<strong>no code required!</strong>).</li>
</ul>
