<p><b>RESTful</b> (representational state transfer) <b>API</b> (application programming interface) <b>DLs</b> (description languages) are <a href="https://en.wikipedia.org/wiki/Formal_language" title="Formal language">formal languages</a> designed to provide a structured description of a <a href="https://en.wikipedia.org/wiki/REST" class="mw-redirect" title="REST">RESTful</a> <a href="https://en.wikipedia.org/wiki/Web_API" title="Web API">web API</a> that is useful both to a human and for automated machine processing. API Description Languages are sometimes called <a href="https://en.wikipedia.org/wiki/Interface_description_language" title="Interface description language">interface description languages</a> (IDLs). The structured description might be used to generate documentation for human <a href="https://en.wikipedia.org/wiki/Programmer" title="Programmer">programmers</a>; such documentation may be easier to read than free-form documentation, since all documentation generated by the same tool follows the same formatting conventions. Additionally, the description language is usually precise enough to allow automated generation of various software artifacts, like libraries, to access the API from various programming languages, which takes the burden of manually creating them off the programmers.</p>
<p></p>


<h2><span class="mw-headline" id="History">History</span></span></h2>
<p>There are two previous major description languages: <a href="https://en.wikipedia.org/wiki/Web_Services_Description_Language" title="Web Services Description Language">WSDL2.0</a> (Web Services Description Language) and <a href="https://en.wikipedia.org/wiki/Web_Application_Description_Language" title="Web Application Description Language">WADL</a> (Web Application Description Language). Neither is widely adopted in the industry for describing RESTful APIs, citing poor human readability of both and WADL being actually unable to fully describe a RESTful API.</p>
<h2><span class="mw-headline" id="Alternatives">Alternatives</span></span></h2>
<h3><span class="mw-headline" id="Hypertext-driven_APIs">Hypertext-driven APIs</span></span></h3>
<p>An alternative approach to building RESTful APIs is known under the acronym HATEOAS (<a href="https://en.wikipedia.org/wiki/Hypermedia_as_the_Engine_of_Application_State" class="mw-redirect" title="Hypermedia as the Engine of Application State">Hypermedia as the Engine of Application State</a>). In this approach, the client software is not written to a static interface description shared through documentation. Instead, the client is given a set of entry points and the API is discovered dynamically through interaction with these endpoints. HATEOAS was introduced in <a href="https://en.wikipedia.org/wiki/Roy_Fielding" title="Roy Fielding">Roy Fielding</a>'s doctoral thesis <i>Architectural Styles and the Design of Network-based Software Architectures</i>. HATEOAS has been the original vision for RESTful APIs which distinguished them from <a href="https://en.wikipedia.org/wiki/Remote_Procedure_Call" class="mw-redirect" title="Remote Procedure Call">RPC</a> mechanisms.</p>
<h2><span class="mw-headline" id="List_of_RESTful_API_DLs">List of RESTful API DLs</span></span></h2>
<ul>
<li><a href="https://en.wikipedia.org/wiki/Web_Services_Description_Language" title="Web Services Description Language">Web Services Description Language</a> (WSDL)</li>
<li><a href="https://en.wikipedia.org/wiki/Web_Application_Description_Language" title="Web Application Description Language">Web Application Description Language</a> (WADL)</li>
<li><a href="/w/index.php?title=CloudRail&amp;action=edit&amp;redlink=1" class="new" title="CloudRail (page does not exist)">CloudRail</a>
<ul>
<li>URL: <a rel="nofollow" class="external free" href="http://cloudrail.com/">http://cloudrail.com/</a></li>
<li>developer: licobo GmbH</li>
</ul>
</li>
<li><a href="https://en.wikipedia.org/wiki/Google_Cloud_Platform#Products" title="Google Cloud Platform">Google Cloud Endpoints</a>
<ul>
<li>URL: <a rel="nofollow" class="external free" href="https://cloud.google.com/endpoints/">https://cloud.google.com/endpoints/</a>, <a rel="nofollow" class="external free" href="https://developers.google.com/discovery">https://developers.google.com/discovery</a></li>
<li>developer: <a href="https://en.wikipedia.org/wiki/Google" title="Google">Google</a></li>
</ul>
</li>
<li><a href="https://en.wikipedia.org/wiki/Open_Data_Protocol" title="Open Data Protocol">Open Data Protocol</a> (OData)
<ul>
<li><a href="https://en.wikipedia.org/wiki/OASIS_(organization)" title="OASIS (organization)">OASIS</a> standard</li>
<li>URL: <a rel="nofollow" class="external free" href="http://www.odata.org/">http://www.odata.org/</a></li>
<li>developer: <a href="https://en.wikipedia.org/wiki/Microsoft" title="Microsoft">Microsoft</a></li>
</ul>
</li>
<li><a href="https://en.wikipedia.org/wiki/OpenAPI_Specification" title="OpenAPI Specification">OpenAPI Specification</a>
<ul>
<li>URL: <a rel="nofollow" class="external free" href="https://openapis.org/">https://openapis.org/</a></li>
<li>developer: Open API Initiative (OAI), originally developed as "Swagger" specification by <a href="https://en.wikipedia.org/wiki/Wordnik" title="Wordnik">Wordnik</a>, <a href="https://en.wikipedia.org/wiki/SmartBear_Software" title="SmartBear Software">SmartBear Software</a></li>
</ul>
</li>
<li><a href="https://en.wikipedia.org/wiki/RESTful_Service_Description_Language" class="mw-redirect" title="RESTful Service Description Language">RESTful Service Description Language</a> (RSDL)
<ul>
<li>URL: <a rel="nofollow" class="external free" href="http://www.balisage.net/Proceedings/vol10/html/Robie01/BalisageVol10-Robie01.html">http://www.balisage.net/Proceedings/vol10/html/Robie01/BalisageVol10-Robie01.html</a></li>
<li>developer: Michael Pasternak</li>
</ul>
</li>
<li>Hydra Core Vocabulary (Hydra)
<ul>
<li>URL: <a rel="nofollow" class="external free" href="http://www.hydra-cg.com/spec/latest/core/">http://www.hydra-cg.com/spec/latest/core/</a></li>
<li>developer: Hydra W3C Community Group, <a rel="nofollow" class="external free" href="http://www.hydra-cg.com/">http://www.hydra-cg.com/</a></li>
</ul>
</li>
<li><a href="https://en.wikipedia.org/wiki/RESTful_API_Modeling_Language" class="mw-redirect" title="RESTful API Modeling Language">RESTful API Modeling Language</a> (RAML)
<ul>
<li>URL: <a rel="nofollow" class="external free" href="http://raml.org/">http://raml.org/</a></li>
<li>developer: Mulesoft, <a rel="nofollow" class="external free" href="http://www.mulesoft.com/">http://www.mulesoft.com/</a></li>
</ul>
</li>
<li>Hypermedia</li>
<li>API Blueprint
<ul>
<li>URL: <a rel="nofollow" class="external free" href="https://apiblueprint.org/">https://apiblueprint.org/</a></li>
<li>developer Apiary, <a rel="nofollow" class="external free" href="https://apiary.io/company">https://apiary.io/company</a></li>
</ul>
</li>
<li>API Builder
<ul>
<li>URL: <a rel="nofollow" class="external free" href="https://www.apibuilder.io/">https://www.apibuilder.io/</a></li>
<li>developers: HBC, Flow Commerce</li>
</ul>
</li>
<li>I/O Docs
<ul>
<li>URL: <a rel="nofollow" class="external free" href="https://github.com/mashery/iodocs">https://github.com/mashery/iodocs</a></li>
<li>developer: Mashery, <a rel="nofollow" class="external free" href="http://www.mashery.com/">http://www.mashery.com/</a></li>
</ul>
</li>
<li><a href="https://en.wikipedia.org/wiki/Apache_Avro" title="Apache Avro">Apache Avro</a></li>
<li>Barrister
<ul>
<li>URL: <a rel="nofollow" class="external free" href="http://barrister.bitmechanic.com/">http://barrister.bitmechanic.com/</a></li>
<li>developer: James Cooper</li>
</ul>
</li>
<li>SERIN - Semantic Restful Interfaces
<ul>
<li>URL: <a rel="nofollow" class="external free" href="http://www.semanticinterface.org">http://www.semanticinterface.org</a></li>
<li>developers: Bruno Muniz, Hermano Lira, José Renato Villela Dantas, Tadeu Nunes, Laura Chaves, Julio Cesar Campos Neto, Pedro Porfírio Muniz Farias</li>
</ul>
</li>
</ul>
<h2><span class="mw-headline" id="List_of_data_description_languages">List of data description languages</span></span></h2>
<p>A significant part of RESTful API description is the specification of returned data structures. The IDL might either specify its own format or use an existing data description format. A notable example which many RESTful API DLs use is <a href="https://en.wikipedia.org/wiki/JSON_Schema" class="mw-redirect" title="JSON Schema">JSON Schema</a>.</p>
<ul>
<li>json:api
<ul>
<li><a rel="nofollow" class="external free" href="http://jsonapi.org/">http://jsonapi.org/</a></li>
<li>Started as REST adapter for <a href="https://en.wikipedia.org/wiki/Ember.js" title="Ember.js">Ember</a> Data</li>
</ul>
</li>
<li>JSON Schema
<ul>
<li>used by OpenAPI, Google APIs Discovery, I/O Docs</li>
</ul>
</li>
<li>Apache Avro
<ul>
<li><a rel="nofollow" class="external free" href="https://avro.apache.org/">https://avro.apache.org/</a></li>
<li>both Interface Description Language and data description language</li>
</ul>
</li>
<li>JSON-RPC 2.0
<ul>
<li>used by Barrister</li>
</ul>
</li>
</ul>
<h2><span class="mw-headline" id="Comparison_of_RESTful_API_DLs">Comparison of RESTful API DLs</span></h2>
<p>The community around RESTful API DLs is active and the landscape is still changing. According to a presentation by Akana, the most active projects in this area are OpenAPI, RAML and API Blueprint.</p>
<table class="wikitable sortable" style="text-align: center; font-size: 85%; width: auto; table-layout: fixed;">
<tr>
<th style="width: 12em"></th>
<th>Sponsor</th>
<th>Initial commit</th>
<th>Latest stable release</th>
<th>Stable release date</th>
<th>Software license</th>
<th>Format</th>
<th>Open Source</th>
<th>Code generation (client)</th>
<th>Code generation (server)</th>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="https://en.wikipedia.org/wiki/RAML_(software)" title="RAML (software)">RAML</a></td>
<td><a href="https://en.wikipedia.org/wiki/MuleSoft" title="MuleSoft">MuleSoft</a></td>
<td>September, 2013</td>
<td>1.0</td>
<td>May 16, 2016</td>
<td><a href="https://en.wikipedia.org/wiki/Apache_2.0" class="mw-redirect" title="Apache 2.0">Apache 2.0</a></td>
<td><a href="https://en.wikipedia.org/wiki/YAML" title="YAML">YAML</a></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="/w/index.php?title=API_Blueprint&amp;action=edit&amp;redlink=1" class="new" title="API Blueprint (page does not exist)">API Blueprint</a></td>
<td><a href="https://en.wikipedia.org/wiki/Apiary" title="Apiary">Apiary</a></td>
<td>April, 2013</td>
<td></td>
<td></td>
<td><a href="https://en.wikipedia.org/wiki/MIT" class="mw-redirect" title="MIT">MIT</a></td>
<td><a href="https://en.wikipedia.org/wiki/Markdown" title="Markdown">Markdown</a></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td>limited</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="https://en.wikipedia.org/wiki/OpenAPI_Specification" title="OpenAPI Specification">OpenAPI</a></td>
<td>Open API Initiative (OAI)</td>
<td>July, 2011</td>
<td>3.0</td>
<td>July 26, 2017</td>
<td><a href="https://en.wikipedia.org/wiki/Apache_2.0" class="mw-redirect" title="Apache 2.0">Apache 2.0</a></td>
<td><a href="https://en.wikipedia.org/wiki/JSON" title="JSON">JSON</a> or <a href="https://en.wikipedia.org/wiki/YAML" title="YAML">YAML</a></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh">SERIN</td>
<td>UNIFOR</td>
<td>2011</td>
<td>2.0</td>
<td>December 2014</td>
<td>Creative Commons</td>
<td>RDF</td>
<td>yes</td>
<td>no</td>
<td>yes</td>
</tr>
</table>
<h2><span class="mw-headline" id="Frameworks">Frameworks</span></span></h2>
<p>Many server frameworks interoperate with one or more IDLs.</p>
<ul>
<li>Gugamarket REST API framework
<ul>
<li>IDLs: OpenAPI</li>
<li>URL: <a rel="nofollow" class="external free" href="https://pliik.github.io/gugamarket/">https://pliik.github.io/gugamarket/</a></li>
<li>developer: <a rel="nofollow" class="external free" href="https://github.com/pliik">https://github.com/pliik</a></li>
</ul>
</li>
</ul>
