<h2><span class="mw-headline" id="Open_source_software">Open source software</span></span></h2>
<dl>
<dd><i>This section lists free and <a href="https://en.wikipedia.org/wiki/Open-source_software" title="Open-source software">open-source software</a> that can be installed and managed on a web server.</i></dd>
</dl>
<h3><span class="mw-headline" id="Java">Java</span></span></h3>
<table class="wikitable sortable" style="font-size:85%; text-align:left; width:auto;">
<tr>
<th>Name</th>
<th>Platform</th>
<th><a href="https://en.wikipedia.org/wiki/Relational_database_management_system" title="Relational database management system">Supported databases</a></th>
<th>Latest stable release</th>
<th>Licenses</th>
<th>Latest release date</th>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="https://en.wikipedia.org/wiki/Apache_Roller" title="Apache Roller">Apache Roller</a></td>
<td><a href="https://en.wikipedia.org/wiki/Java_(programming_language)" title="Java (programming language)">Java</a></td>
<td><a href="https://en.wikipedia.org/wiki/HSQL" class="mw-redirect" title="HSQL">HSQL</a>, <a href="https://en.wikipedia.org/wiki/MySQL" title="MySQL">MySQL</a>, <a href="https://en.wikipedia.org/wiki/Oracle_database" class="mw-redirect" title="Oracle database">Oracle</a>, <a href="https://en.wikipedia.org/wiki/Microsoft_SQL_Server" title="Microsoft SQL Server">SQL Server</a>, <a href="https://en.wikipedia.org/wiki/IBM_DB2" class="mw-redirect" title="IBM DB2">DB2</a>, <a href="https://en.wikipedia.org/wiki/PostgreSQL" title="PostgreSQL">PostgreSQL</a>, <a href="https://en.wikipedia.org/wiki/Apache_Derby" title="Apache Derby">Apache Derby</a></td>
<td>5.1.2</td>
<td><a href="https://en.wikipedia.org/wiki/Apache_License" title="Apache License">Apache 2.0 License</a></td>
<td>2015-03-01</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="https://en.wikipedia.org/wiki/Ametys_CMS" title="Ametys CMS">Ametys CMS</a></td>
<td><a href="https://en.wikipedia.orghttps://en.wikipedia.org/wiki/Java_(programming_language)" title="Java (programming language)">Java</a></td>
<td><a href="https://en.wikipedia.org/wiki/MySQL" title="MySQL">MySQL</a>, <a href="https://en.wikipedia.org/wiki/Oracle_database" class="mw-redirect" title="Oracle database">Oracle</a>, <a href="https://en.wikipedia.org/wiki/Microsoft_SQL_Server" title="Microsoft SQL Server">SQL Server</a>, <a href="https://en.wikipedia.org/wiki/Content_repository_API_for_Java" title="Content repository API for Java">JCR</a>, <a href="https://en.wikipedia.org/wiki/Apache_Derby" title="Apache Derby">Apache Derby</a></td>
<td>3.7.1</td>
<td><a href="https://en.wikipedia.org/wiki/Apache_License" title="Apache License">Apache 2.0 License</a></td>
<td>2015-04-27</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="https://en.wikipedia.org/wiki/Crafter_CMS" title="Crafter CMS">Crafter CMS</a></td>
<td><a href="https://en.wikipedia.org/wiki/Java_(programming_language)" title="Java (programming language)">Java</a></td>
<td><a href="https://en.wikipedia.org/wiki/Git" title="Git">Git</a>, <a href="https://en.wikipedia.org/wiki/Solr" class="mw-redirect" title="Solr">Solr</a>, <a href="https://en.wikipedia.org/wiki/CMIS" class="mw-redirect" title="CMIS">CMIS</a></td>
<td>3.0.0</td>
<td><a href="https://en.wikipedia.org/wiki/GNU" title="GNU">GNU</a> <a href="https://en.wikipedia.orghttps://en.wikipedia.org/wiki/GPL" class="mw-redirect" title="GPL">GPL</a> v3</td>
<td>2017-08-01</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="https://en.wikipedia.org/wiki/DotCMS" title="DotCMS">dotCMS</a></td>
<td><a href="https://en.wikipedia.orghttps://en.wikipedia.org/wiki/Java_(programming_language)" title="Java (programming language)">Java</a></td>
<td><a href="https://en.wikipedia.org/wiki/MySQL" title="MySQL">MySQL</a>, <a href="https://en.wikipedia.org/wiki/Oracle_Database" title="Oracle Database">Oracle</a>, <a href="https://en.wikipedia.org/wiki/MSSQL" class="mw-redirect" title="MSSQL">MSSQL</a>, <a href="https://en.wikipedia.org/wiki/PostgreSQL" title="PostgreSQL">PostgreSQL</a></td>
<td>4.2.0</td>
<td><a href="https://en.wikipedia.org/wiki/GNU" title="GNU">GNU</a> <a href="https://en.wikipedia.org/wiki/GPL" class="mw-redirect" title="GPL">GPL</a> v3</td>
<td>2017-10-17</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="https://en.wikipedia.org/wiki/Liferay" title="Liferay">Liferay</a></td>
<td><a href="https://en.wikipedia.org/wiki/Java_(programming_language)" title="Java (programming language)">Java</a></td>
<td><a href="https://en.wikipedia.org/wiki/HSQLDB" title="HSQLDB">HSQLDB</a>, <a href="https://en.wikipedia.org/wiki/MySQL" title="MySQL">MySQL</a>, <a href="https://en.wikipedia.org/wiki/Oracle_database" class="mw-redirect" title="Oracle database">Oracle</a>, <a href="https://en.wikipedia.org/wiki/Microsoft_SQL_Server" title="Microsoft SQL Server">SQL Server</a>, <a href="https://en.wikipedia.org/wiki/IBM_DB2" class="mw-redirect" title="IBM DB2">DB2</a>, <a href="https://en.wikipedia.org/wiki/Apache_Derby" title="Apache Derby">Apache Derby</a>, <a href="https://en.wikipedia.org/wiki/Informix" class="mw-redirect" title="Informix">Informix</a>, <a href="https://en.wikipedia.org/wiki/InterBase" title="InterBase">InterBase</a>, JDataStore, <a href="https://en.wikipedia.org/wiki/PostgreSQL" title="PostgreSQL">PostgreSQL</a>, <a href="https://en.wikipedia.org/wiki/SAP_ERP" title="SAP ERP">SAP</a>, <a href="https://en.wikipedia.org/wiki/Sybase" title="Sybase">Sybase</a></td>
<td>7.0.1</td>
<td><a href="https://en.wikipedia.org/wiki/LGPL" class="mw-redirect" title="LGPL">LGPL</a></td>
<td>2016-06-10</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="https://en.wikipedia.org/wiki/EXo_Platform" title="EXo Platform">eXo Platform</a> Community Edition</td>
<td><a href="https://en.wikipedia.org/wiki/Java_(programming_language)" title="Java (programming language)">Java</a></td>
<td><a href="https://en.wikipedia.org/wiki/HSQLDB" title="HSQLDB">HSQLDB</a>, <a href="https://en.wikipedia.org/wiki/MySQL" title="MySQL">MySQL</a>, <a href="https://en.wikipedia.org/wiki/Oracle_database" class="mw-redirect" title="Oracle database">Oracle</a>, <a href="https://en.wikipedia.org/wiki/Microsoft_SQL_Server" title="Microsoft SQL Server">SQL Server</a>, <a href="https://en.wikipedia.org/wiki/IBM_DB2" class="mw-redirect" title="IBM DB2">DB2</a>, <a href="https://en.wikipedia.org/wiki/Apache_Derby" title="Apache Derby">Apache Derby</a>, <a href="https://en.wikipedia.org/wiki/PostgreSQL" title="PostgreSQL">PostgreSQL</a>, <a href="https://en.wikipedia.org/wiki/Sybase" title="Sybase">Sybase</a></td>
<td>4.3</td>
<td><a href="https://en.wikipedia.org/wiki/LGPL" class="mw-redirect" title="LGPL">LGPL</a></td>
<td>2016-01-21</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="https://en.wikipedia.org/wiki/DSpace" title="DSpace">DSpace</a></td>
<td><a href="https://en.wikipedia.org/wiki/Java_(programming_language)" title="Java (programming language)">Java</a></td>
<td><a href="https://en.wikipedia.org/wiki/Oracle_database" class="mw-redirect" title="Oracle database">Oracle</a>, <a href="https://en.wikipedia.org/wiki/PostgreSQL" title="PostgreSQL">PostgreSQL</a></td>
<td>5.0</td>
<td><a href="https://en.wikipedia.org/wiki/BSD_License" class="mw-redirect" title="BSD License">BSD License</a></td>
<td>2015-01-16</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="https://en.wikipedia.org/wiki/Fedora_Commons" title="Fedora Commons">Fedora Commons</a></td>
<td><a href="https://en.wikipedia.org/wiki/Java_(programming_language)" title="Java (programming language)">Java</a></td>
<td><a href="https://en.wikipedia.org/wiki/MySQL" title="MySQL">MySQL</a>, <a href="https://en.wikipedia.org/wiki/Oracle_database" class="mw-redirect" title="Oracle database">Oracle</a>, <a href="https://en.wikipedia.org/wiki/PostgreSQL" title="PostgreSQL">PostgreSQL</a>, <a href="https://en.wikipedia.org/wiki/Mulgara_(software)" title="Mulgara (software)">Mulgara</a> (MPTSTore RDF Semantic Triplestore)</td>
<td>4.1.0</td>
<td><a href="https://en.wikipedia.org/wiki/Apache_License" title="Apache License">Apache License</a></td>
<td>2015-02-04</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="https://en.wikipedia.org/wiki/LogicalDOC" title="LogicalDOC">LogicalDOC</a> Community Edition</td>
<td><a href="https://en.wikipedia.org/wiki/Java_platform" class="mw-redirect" title="Java platform">Java</a></td>
<td><a href="https://en.wikipedia.org/wiki/MySQL" title="MySQL">MySQL</a>, <a href="https://en.wikipedia.org/wiki/Oracle_database" class="mw-redirect" title="Oracle database">Oracle</a>, <a href="https://en.wikipedia.org/wiki/Microsoft_SQL_Server" title="Microsoft SQL Server">SQL Server</a>, <a href="https://en.wikipedia.org/wiki/PostgreSQL" title="PostgreSQL">PostgreSQL</a></td>
<td>7.4.2</td>
<td><a href="https://en.wikipedia.org/wiki/LGPL" class="mw-redirect" title="LGPL">LGPL</a></td>
<td>2016-03-24</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="https://en.wikipedia.org/wiki/Nuxeo" title="Nuxeo">Nuxeo EP</a></td>
<td><a href="https://en.wikipedia.org/wiki/Java_(programming_language)" title="Java (programming language)">Java</a></td>
<td><a href="https://en.wikipedia.org/wiki/MySQL" title="MySQL">MySQL</a>, <a href="https://en.wikipedia.org/wiki/Oracle_database" class="mw-redirect" title="Oracle database">Oracle</a>, <a href="https://en.wikipedia.orghttps://en.wikipedia.org/wiki/Microsoft_SQL_Server" title="Microsoft SQL Server">SQL Server</a>, <a href="https://en.wikipedia.org/wiki/Ingres_(database)" title="Ingres (database)">Ingres</a>, <a href="https://en.wikipedia.org/wiki/PostgreSQL" title="PostgreSQL">PostgreSQL</a>, <a href="https://en.wikipedia.org/wiki/MongoDB" title="MongoDB">MongoDB</a></td>
<td>7.3</td>
<td><a href="https://en.wikipedia.org/wiki/LGPL" class="mw-redirect" title="LGPL">LGPL</a></td>
<td>2014-11-12</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="https://en.wikipedia.org/wiki/OpenCms" title="OpenCms">OpenCms</a></td>
<td><a href="https://en.wikipedia.org/wiki/Java_(programming_language)" title="Java (programming language)">Java</a></td>
<td><a href="https://en.wikipedia.org/wiki/HSQL" class="mw-redirect" title="HSQL">HSQL</a>, <a href="https://en.wikipedia.org/wiki/MySQL" title="MySQL">MySQL</a>, <a href="https://en.wikipedia.org/wiki/Oracle_database" class="mw-redirect" title="Oracle database">Oracle</a>, <a href="https://en.wikipedia.org/wiki/Microsoft_SQL_Server" title="Microsoft SQL Server">SQL Server</a>, <a href="https://en.wikipedia.org/wiki/IBM_DB2" class="mw-redirect" title="IBM DB2">DB2</a>, <a href="https://en.wikipedia.org/wiki/PostgreSQL" title="PostgreSQL">PostgreSQL</a></td>
<td>10.5.1</td>
<td><a href="https://en.wikipedia.org/wiki/LGPL" class="mw-redirect" title="LGPL">LGPL</a></td>
<td>2017-02-15</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="https://en.wikipedia.org/wiki/Alfresco_(software)" title="Alfresco (software)">Alfresco</a> Community Edition</td>
<td><a href="https://en.wikipedia.org/wiki/Java_platform" class="mw-redirect" title="Java platform">Java</a></td>
<td><a href="https://en.wikipedia.org/wiki/MySQL" title="MySQL">MySQL</a>, <a href="https://en.wikipedia.org/wiki/Oracle_database" class="mw-redirect" title="Oracle database">Oracle</a>, <a href="https://en.wikipedia.org/wiki/Microsoft_SQL_Server" title="Microsoft SQL Server">SQL Server</a>, <a href="https://en.wikipedia.org/wiki/PostgreSQL" title="PostgreSQL">PostgreSQL</a>, <a href="https://en.wikipedia.org/wiki/IBM_DB2" class="mw-redirect" title="IBM DB2">DB2</a>,</td>
<td>201707</td>
<td><a href="https://en.wikipedia.org/wiki/LGPL" class="mw-redirect" title="LGPL">LGPL</a></td>
<td>2016-05-17</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="https://en.wikipedia.org/wiki/Hippo_CMS" title="Hippo CMS">Hippo CMS</a></td>
<td><a href="https://en.wikipedia.org/wiki/Java_(programming_language)" title="Java (programming language)">Java</a></td>
<td><a href="https://en.wikipedia.org/wiki/MySQL" title="MySQL">MySQL</a>, <a href="https://en.wikipedia.org/wiki/Oracle_database" class="mw-redirect" title="Oracle database">Oracle</a>, <a href="https://en.wikipedia.org/wiki/Microsoft_SQL_Server" title="Microsoft SQL Server">SQL Server</a>, <a href="https://en.wikipedia.org/wiki/Ingres_(database)" title="Ingres (database)">Ingres</a>, <a href="https://en.wikipedia.org/wiki/PostgreSQL" title="PostgreSQL">PostgreSQL</a>, <a href="https://en.wikipedia.org/wiki/Content_repository_API_for_Java" title="Content repository API for Java">JCR</a></td>
<td>12.0.2</td>
<td><a href="https://en.wikipedia.org/wiki/Apache_License" title="Apache License">Apache 2.0 License</a></td>
<td>2017-10-10</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="https://en.wikipedia.org/wiki/OpenWGA" title="OpenWGA">OpenWGA</a></td>
<td><a href="https://en.wikipedia.org/wiki/Java_(programming_language)" title="Java (programming language)">Java</a></td>
<td><a href="https://en.wikipedia.org/wiki/MySQL" title="MySQL">MySQL</a>, <a href="https://en.wikipedia.org/wiki/PostgreSQL" title="PostgreSQL">PostgreSQL</a>, <a href="https://en.wikipedia.org/wiki/IBM_DB2" class="mw-redirect" title="IBM DB2">IBM DB2</a>, <a href="https://en.wikipedia.org/wiki/HSQLDB" title="HSQLDB">HSQLDB</a>, <a href="https://en.wikipedia.org/wiki/Oracle_database" class="mw-redirect" title="Oracle database">Oracle</a>, <a href="https://en.wikipedia.org/wiki/Microsoft_SQL_Server" title="Microsoft SQL Server">SQL Server</a>, <a href="https://en.wikipedia.org/wiki/IBM_Lotus_Domino" class="mw-redirect" title="IBM Lotus Domino">IBM Lotus Domino</a>, <a href="https://en.wikipedia.org/wiki/Content_Management_Interoperability_Services" title="Content Management Interoperability Services">CMIS</a></td>
<td>7.1</td>
<td><a href="https://en.wikipedia.org/wiki/GPL" class="mw-redirect" title="GPL">GPL</a> &amp; proprietary</td>
<td>2015-02-25</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="https://en.wikipedia.org/wiki/Jahia" title="Jahia">Jahia</a> Community Distribution</td>
<td><a href="https://en.wikipedia.org/wiki/Java_(programming_language)" title="Java (programming language)">Java</a></td>
<td><a href="https://en.wikipedia.org/wiki/Apache_Derby" title="Apache Derby">Apache Derby</a>, <a href="/wiki/Content_repository_API_for_Java" title="Content repository API for Java">JCR</a>, <a href="https://en.wikipedia.org/wiki/MySQL" title="MySQL">MySQL</a>, <a href="https://en.wikipedia.org/wiki/PostgreSQL" title="PostgreSQL">PostgreSQL</a></td>
<td>7.0.0</td>
<td><a href="https://en.wikipedia.org/wiki/GPL" class="mw-redirect" title="GPL">GPL</a></td>
<td>2014-04-01</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="https://en.wikipedia.org/wiki/Magnolia_(CMS)" title="Magnolia (CMS)">Magnolia</a></td>
<td><a href="https://en.wikipedia.org/wiki/Java_(programming_language)" title="Java (programming language)">Java</a></td>
<td><a href="https://en.wikipedia.org/wiki/Apache_Derby" title="Apache Derby">Derby</a>, <a href="https://en.wikipedia.org/wiki/MySQL" title="MySQL">MySQL</a>, <a href="https://en.wikipedia.org/wiki/PostgreSQL" title="PostgreSQL">PostgreSQL</a>, <a href="https://en.wikipedia.org/wiki/Oracle_database" class="mw-redirect" title="Oracle database">Oracle</a></td>
<td>5.5</td>
<td><a href="https://en.wikipedia.org/wiki/GPL" class="mw-redirect" title="GPL">GPL</a></td>
<td>2016-11-15</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="https://en.wikipedia.org/wiki/OpenKM" title="OpenKM">OpenKM</a></td>
<td><a href="https://en.wikipedia.org/wiki/Java_(programming_language)" title="Java (programming language)">Java</a></td>
<td><a href="https://en.wikipedia.org/wiki/MySQL" title="MySQL">MySQL</a>, <a href="https://en.wikipedia.org/wiki/PostgreSQL" title="PostgreSQL">PostgreSQL</a>, <a href="https://en.wikipedia.org/wiki/Oracle_database" class="mw-redirect" title="Oracle database">Oracle</a>, <a href="https://en.wikipedia.org/wiki/Microsoft_SQL_Server" title="Microsoft SQL Server">SQL Server</a>, <a href="https://en.wikipedia.org/wiki/HSQLDB" title="HSQLDB">HSQLDB</a></td>
<td>6.3.2</td>
<td><a href="https://en.wikipedia.org/wiki/GPL" class="mw-redirect" title="GPL">GPL</a></td>
<td>2016-10-24</td>
</tr>
<tr>
<td style="background: #edf; color: black; vertical-align: middle; text-align: left; font-weight: bolder;" class="rh heading table-rh"><a href="https://en.wikipedia.org/wiki/Thingamablog" title="Thingamablog">Thingamablog</a></td>
<td><a href="https://en.wikipedia.org/wiki/Java_(programming_language)" title="Java (programming language)">Java</a></td>
<td></td>
<td>1.5.1</td>
<td><a href="https://en.wikipedia.org/wiki/GPL" class="mw-redirect" title="GPL">GPL</a></td>
<td>2009-11-23</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="https://en.wikipedia.org/wiki/XWiki" title="XWiki">XWiki</a></td>
<td><a href="https://en.wikipedia.org/wiki/Java_(programming_language)" title="Java (programming language)">Java</a></td>
<td><a href="https://en.wikipedia.org/wiki/MySQL" title="MySQL">MySQL</a>, <a href="https://en.wikipedia.org/wiki/PostgreSQL" title="PostgreSQL">PostgreSQL</a>, <a href="https://en.wikipedia.org/wiki/Oracle_database" class="mw-redirect" title="Oracle database">Oracle</a>, <a href="https://en.wikipedia.org/wiki/Microsoft_SQL_Server" title="Microsoft SQL Server">SQL Server</a>, <a href="https://en.wikipedia.org/wiki/HSQLDB" title="HSQLDB">HSQLDB</a></td>
<td>8.4.1</td>
<td><a href="https://en.wikipedia.org/wiki/LGPL" class="mw-redirect" title="LGPL">LGPL</a></td>
<td>2016-11-22</td>
</tr>
</table>
<h4><span id="Java_packages/bundle"></span><span class="mw-headline" id="Java_packages.2Fbundle">Java packages/bundle</span></span></h4>
<table class="wikitable sortable" style="font-size:85%; text-align:left; width:auto;">
<tr>
<th>Name</th>
<th>Platform</th>
<th>Supported databases</th>
<th>Latest stable release</th>
<th>Licenses</th>
<th>Latest release date</th>
</tr>
<tr>
<td style="background: #edf; color: black; vertical-align: middle; text-align: left; font-weight: bolder;" class="rh heading table-rh"><a href="https://en.wikipedia.org/wiki/Apache_Lenya" title="Apache Lenya">Apache Lenya</a></td>
<td><a href="https://en.wikipedia.org/wiki/Java_(programming_language)" title="Java (programming language)">Java</a>, <a href="https://en.wikipedia.org/wiki/XML" title="XML">XML</a>, <a href="https://en.wikipedia.org/wiki/Apache_Cocoon" title="Apache Cocoon">Apache Cocoon</a></td>
<td></td>
<td>2.0.4</td>
<td><a href="https://en.wikipedia.org/wiki/Apache_License" title="Apache License">Apache License</a></td>
<td>2011-03-14</td>
</tr>
<tr>
<td style="background: #edf; color: black; vertical-align: middle; text-align: left; font-weight: bolder;" class="rh heading table-rh"><a href="https://en.wikipedia.org/wiki/Daisy_(software)" title="Daisy (software)">Daisy</a></td>
<td><a href="https://en.wikipedia.org/wiki/Java_(programming_language)" title="Java (programming language)">Java</a>, <a href="https://en.wikipedia.org/wiki/XML" title="XML">XML</a>, <a href="https://en.wikipedia.org/wiki/Apache_Cocoon" title="Apache Cocoon">Apache Cocoon</a></td>
<td><a href="https://en.wikipedia.org/wiki/MySQL" title="MySQL">MySQL</a></td>
<td>2.4.2</td>
<td><a href="https://en.wikipedia.org/wiki/Apache_License" title="Apache License">Apache License</a></td>
<td>2011-02-21</td>
</tr>
</table>
<h3><span class="mw-headline" id="Microsoft_ASP.NET">Microsoft ASP.NET</span></span></h3>
<table class="wikitable sortable" style="font-size: 85%; text-align: left; width: auto;">
<tr>
<th>Name</th>
<th>Platform</th>
<th>Supported databases</th>
<th>Latest stable release</th>
<th>Licenses</th>
<th>Latest release date</th>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="https://en.wikipedia.org/wiki/C1_CMS" title="C1 CMS">C1 CMS</a></td>
<td><a href="https://en.wikipedia.org/wiki/ASP.NET" title="ASP.NET">ASP.NET</a> (Web Forms, MVC)</td>
<td><a href="https://en.wikipedia.org/wiki/XML" title="XML">XML</a>, <a href="https://en.wikipedia.org/wiki/Microsoft_SQL_Server" title="Microsoft SQL Server">SQL Server</a></td>
<td>6.1</td>
<td><a href="https://en.wikipedia.org/wiki/Mozilla_Public_License" title="Mozilla Public License">Mozilla Public License</a></td>
<td>2017-04-27</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="https://en.wikipedia.org/wiki/DotNetNuke" title="DotNetNuke">DNN</a></td>
<td><a href="https://en.wikipedia.org/wiki/ASP.NET" title="ASP.NET">ASP.NET</a> (Web Forms, MVC)</td>
<td><a href="https://en.wikipedia.org/wiki/Microsoft_SQL_Server" title="Microsoft SQL Server">SQL Server</a>, <a href="https://en.wikipedia.org/wiki/SQL_Server_Express" title="SQL Server Express">SQL Server Express</a>, <a href="https://en.wikipedia.org/wiki/SQL_Azure" class="mw-redirect" title="SQL Azure">SQL Azure</a></td>
<td>9.1.1</td>
<td><a href="https://en.wikipedia.org/wiki/MIT_License" title="MIT License">MIT License</a></td>
<td>2017-07-05</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="https://en.wikipedia.org/wiki/Kentico_CMS" title="Kentico CMS">Kentico CMS</a></td>
<td><a href="https://en.wikipedia.org/wiki/ASP.NET" title="ASP.NET">ASP.NET</a></td>
<td><a href="https://en.wikipedia.org/wiki/Microsoft_SQL_Server" title="Microsoft SQL Server">SQL Server</a></td>
<td>10.0</td>
<td>Proprietary, <a href="https://en.wikipedia.org/wiki/Free_software" title="Free software">Free</a></td>
<td>2016-11-30</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="https://en.wikipedia.org/wiki/MojoPortal" title="MojoPortal">mojoPortal</a></td>
<td><a href="https://en.wikipedia.org/wiki/ASP.NET" title="ASP.NET">ASP.NET</a></td>
<td><a href="https://en.wikipedia.org/wiki/Microsoft_SQL_Server" title="Microsoft SQL Server">SQL Server</a>, <a href="https://en.wikipedia.org/wiki/MySQL" title="MySQL">MySQL</a>, <a href="https://en.wikipedia.org/wiki/PostgreSQL" title="PostgreSQL">PostgreSQL</a>, <a href="https://en.wikipedia.org/wiki/SQLite" title="SQLite">SQLite</a>, <a href="https://en.wikipedia.org/wiki/Firebird_(database_server)" title="Firebird (database server)">Firebird</a>, <a href="https://en.wikipedia.org/wiki/SQLCE" class="mw-redirect" title="SQLCE">SQL CE</a></td>
<td>2.4.1.0</td>
<td><a href="https://en.wikipedia.org/wiki/Common_Public_License" title="Common Public License">CPL</a></td>
<td>2016-04-10</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="https://en.wikipedia.org/wiki/Orchard_Project" title="Orchard Project">Orchard Project</a></td>
<td><a href="https://en.wikipedia.org/wiki/ASP.NET" title="ASP.NET">ASP.NET</a> (Web Forms, MVC)</td>
<td><a href="https://en.wikipedia.org/wiki/Microsoft_SQL_Server" title="Microsoft SQL Server">SQL Server</a>, <a href="https://en.wikipedia.org/wiki/MySQL" title="MySQL">MySQL</a>, <a href="https://en.wikipedia.org/wiki/PostgreSQL" title="PostgreSQL">PostgreSQL</a>, <a href="https://en.wikipedia.org/wiki/SQLite" title="SQLite">SQLite</a></td>
<td>1.10.1</td>
<td><a href="https://en.wikipedia.org/wiki/New_BSD_License" class="mw-redirect" title="New BSD License">New BSD License</a></td>
<td>2016-05-11</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="https://en.wikipedia.org/wiki/Umbraco" title="Umbraco">Umbraco</a></td>
<td><a href="https://en.wikipedia.org/wiki/ASP.NET" title="ASP.NET">ASP.NET</a> (Web Forms, MVC)</td>
<td><a href="https://en.wikipedia.org/wiki/Microsoft_SQL_Server" title="Microsoft SQL Server">SQL Server</a>, <a href="https://en.wikipedia.org/wiki/SQL_Server_Compact" title="SQL Server Compact">SQL CE</a>, <a href="https://en.wikipedia.org/wiki/SQL_Azure" class="mw-redirect" title="SQL Azure">SQL Azure</a>, <a href="https://en.wikipedia.org/wiki/MySQL" title="MySQL">MySQL</a></td>
<td>7.6.5</td>
<td><a href="https://en.wikipedia.org/wiki/MIT_License" title="MIT License">MIT License</a></td>
<td>2017-08-08</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="https://en.wikipedia.org/wiki/BetterCMS" title="BetterCMS">BetterCMS</a></td>
<td><a href="https://en.wikipedia.org/wiki/ASP.NET" title="ASP.NET">ASP.NET</a> (Web Forms, MVC)</td>
<td><a href="https://en.wikipedia.org/wiki/Microsoft_SQL_Server" title="Microsoft SQL Server">SQL Server</a>, <a href="https://en.wikipedia.org/wiki/SQL_Azure" class="mw-redirect" title="SQL Azure">SQL Azure</a></td>
<td>2.0.6</td>
<td><a href="https://en.wikipedia.org/wiki/GNU_Lesser_General_Public_License" title="GNU Lesser General Public License">LGPL</a></td>
<td>2016-06-14</td>
</tr>
</table>
<h3><span class="mw-headline" id="Perl">Perl</span></span></h3>
<table class="wikitable sortable" style="font-size: 85%; text-align: left; width: auto;">
<tr>
<th>Name</th>
<th>Platform</th>
<th>Supported databases</th>
<th>Latest stable release</th>
<th>Licenses</th>
<th>Latest release date</th>
</tr>
<tr>
<td style="background: #edf; color: black; vertical-align: middle; text-align: left; font-weight: bolder;" class="rh heading table-rh"><a href="https://en.wikipedia.org/wiki/Blosxom" title="Blosxom">blosxom</a></td>
<td><a href="https://en.wikipedia.org/wiki/Perl" title="Perl">Perl</a></td>
<td><a href="https://en.wikipedia.org/wiki/Flat-file_database" class="mw-redirect" title="Flat-file database">Flat-file database</a></td>
<td>2.1.2</td>
<td><a href="https://en.wikipedia.org/wiki/MIT_License" title="MIT License">MIT</a></td>
<td>2008-10-02</td>
</tr>
<tr>
<td style="background: #edf; color: black; vertical-align: middle; text-align: left; font-weight: bolder;" class="rh heading table-rh"><a href="https://en.wikipedia.org/wiki/Bricolage_(software)" title="Bricolage (software)">Bricolage</a></td>
<td><a href="https://en.wikipedia.org/wiki/Perl" title="Perl">Perl</a> on <a href="https://en.wikipedia.org/wiki/Mod_perl" title="Mod perl">mod perl</a></td>
<td><a href="https://en.wikipedia.org/wiki/MySQL" title="MySQL">MySQL</a>, <a href="https://en.wikipedia.org/wiki/PostgreSQL" title="PostgreSQL">PostgreSQL</a>, <a href="https://en.wikipedia.org/wiki/Oracle_database" class="mw-redirect" title="Oracle database">Oracle</a></td>
<td>2.0.1</td>
<td><a href="https://en.wikipedia.org/wiki/BSD_licenses" title="BSD licenses">BSD</a></td>
<td>2011-02-09</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="https://en.wikipedia.org/wiki/EPrints" title="EPrints">EPrints</a></td>
<td><a href="https://en.wikipedia.org/wiki/Perl" title="Perl">Perl</a> on <a href="https://en.wikipedia.org/wiki/Mod_perl" title="Mod perl">mod perl</a></td>
<td><a href="https://en.wikipedia.org/wiki/MySQL" title="MySQL">MySQL</a>, <a href="https://en.wikipedia.org/wiki/PostgreSQL" title="PostgreSQL">PostgreSQL</a></td>
<td>3.3.15</td>
<td><a href="https://en.wikipedia.org/wiki/GPL" class="mw-redirect" title="GPL">GPL</a></td>
<td>2015-12-22</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="https://en.wikipedia.org/wiki/Foswiki" title="Foswiki">Foswiki</a></td>
<td><a href="https://en.wikipedia.org/wiki/Perl" title="Perl">Perl</a></td>
<td><a href="https://en.wikipedia.org/wiki/Flat-file_database" class="mw-redirect" title="Flat-file database">Flat-file database</a></td>
<td>2.1.4</td>
<td><a href="https://en.wikipedia.org/wiki/GPL" class="mw-redirect" title="GPL">GPL</a></td>
<td>2017-06-01</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="https://en.wikipedia.org/wiki/Ikiwiki" title="Ikiwiki">Ikiwiki</a></td>
<td><a href="https://en.wikipedia.org/wiki/Perl" title="Perl">Perl</a></td>
<td><a href="https://en.wikipedia.org/wiki/Git_(software)" class="mw-redirect" title="Git (software)">Git (software)</a>, <a href="/wiki/Apache_Subversion" title="Apache Subversion">Apache Subversion</a>, <a href="https://en.wikipedia.org/wiki/Mercurial" title="Mercurial">Mercurial</a></td>
<td>3.20170111</td>
<td><a href="https://en.wikipedia.orghttps://en.wikipedia.org/wiki/GPL" class="mw-redirect" title="GPL">GPL</a></td>
<td>2017-01-11</td>
</tr>
<tr>
<td style="background: #edf; color: black; vertical-align: middle; text-align: left; font-weight: bolder;" class="rh heading table-rh"><a href="https://en.wikipedia.org/wiki/Movable_Type" title="Movable Type">Movable Type</a> Open Source</td>
<td><a href="https://en.wikipedia.org/wiki/Perl" title="Perl">Perl</a>, <a href="https://en.wikipedia.org/wiki/Mod_perl" title="Mod perl">mod perl</a>, <a href="/wiki/FastCGI" title="FastCGI">FastCGI</a>, w/<a href="https://en.wikipedia.org/wiki/PHP" title="PHP">PHP</a></td>
<td><a href="https://en.wikipedia.org/wiki/MySQL" title="MySQL">MySQL</a></td>
<td>5.2.13</td>
<td><a href="https://en.wikipedia.org/wiki/GPL" class="mw-redirect" title="GPL">GPL</a></td>
<td>2015-04-14</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="https://en.wikipedia.org/wiki/TWiki" title="TWiki">TWiki</a></td>
<td><a href="https://en.wikipedia.org/wiki/Perl" title="Perl">Perl</a></td>
<td>Plain files (under version control)</td>
<td>6.0.2</td>
<td><a href="https://en.wikipedia.org/wiki/GPL" class="mw-redirect" title="GPL">GPL</a></td>
<td>2015-11-29</td>
</tr>
<tr>
<td style="background: #edf; color: black; vertical-align: middle; text-align: left; font-weight: bolder;" class="rh heading table-rh"><a href="https://en.wikipedia.org/wiki/SPINE_(software)" title="SPINE (software)">SPINE</a></td>
<td><a href="https://en.wikipedia.org/wiki/Perl" title="Perl">Perl</a>, <a href="https://en.wikipedia.org/wiki/Mod_perl" title="Mod perl">mod perl</a></td>
<td><a href="https://en.wikipedia.org/wiki/MySQL" title="MySQL">MySQL</a>, <a href="https://en.wikipedia.org/wiki/PostgreSQL" title="PostgreSQL">PostgreSQL</a></td>
<td>1.2.2</td>
<td><a href="https://en.wikipedia.org/wiki/GPL" class="mw-redirect" title="GPL">GPL</a></td>
<td>2006-12-27</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="https://en.wikipedia.org/wiki/WebGUI" title="WebGUI">WebGUI</a></td>
<td><a href="https://en.wikipedia.org/wiki/Perl" title="Perl">Perl</a> on <a href="https://en.wikipedia.org/wiki/Mod_perl" title="Mod perl">mod perl</a></td>
<td><a href="https://en.wikipedia.orghttps://en.wikipedia.org/wiki/MySQL" title="MySQL">MySQL</a></td>
<td>7.10.30</td>
<td><a href="https://en.wikipedia.org/wiki/GPL" class="mw-redirect" title="GPL">GPL</a></td>
<td>2016-01-06</td>
</tr>
</table>
<h3><span class="mw-headline" id="PHP">PHP</span></span></h3>
<table class="wikitable sortable" style="font-size: 85%; text-align: left; width: auto;">
<tr>
<th>Name</th>
<th>Platform</th>
<th>Supported databases</th>
<th>Latest stable release</th>
<th>Licenses</th>
<th>Latest release date</th>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="/wiki/ATutor" title="ATutor">ATutor</a></td>
<td><a href="/wiki/PHP" title="PHP">PHP</a></td>
<td><a href="/wiki/MySQL" title="MySQL">MySQL</a></td>
<td>2.2.2</td>
<td><a href="/wiki/GPL" class="mw-redirect" title="GPL">GPL</a></td>
<td>2016-07-01</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="/wiki/Backdrop_CMS" title="Backdrop CMS">Backdrop CMS</a></td>
<td><a href="/wiki/PHP" title="PHP">PHP</a></td>
<td><a href="/wiki/MySQL" title="MySQL">MySQL</a></td>
<td>1.8.0</td>
<td><a href="/wiki/GNU_General_Public_License#Version_2" title="GNU General Public License">GPLv2+</a></td>
<td>2017-09-16</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="/wiki/B2evolution" title="B2evolution">b2evolution</a></td>
<td><a href="/wiki/PHP" title="PHP">PHP</a></td>
<td><a href="/wiki/MySQL" title="MySQL">MySQL</a>, <a href="/wiki/MariaDB" title="MariaDB">MariaDB</a><</td>
<td>6.9.3</td>
<td><a href="/wiki/GNU_General_Public_License#Version_2" title="GNU General Public License">GPLv2</a></td>
<td>2017-08-25</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="/wiki/CMSimple" title="CMSimple">CMSimple</a></td>
<td><a href="/wiki/PHP" title="PHP">PHP</a></td>
<td><a href="/wiki/Flat-file_database" class="mw-redirect" title="Flat-file database">Flat-file database</a></td>
<td>4.7.2</td>
<td><a href="/wiki/GPLv3" class="mw-redirect" title="GPLv3">GPLv3</a></td>
<td>2017-05-07</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="/wiki/CMS_Made_Simple" title="CMS Made Simple">CMS Made Simple</a></td>
<td><a href="/wiki/PHP" title="PHP">PHP</a></td>
<td><a href="/wiki/MySQL" title="MySQL">MySQL</a></td>
<td>2.2.2</td>
<td><a href="/wiki/GPL" class="mw-redirect" title="GPL">GPL</a></td>
<td>2017-07-08</td>
</tr>
<tr>
<td style="background: #edf; color: black; vertical-align: middle; text-align: left; font-weight: bolder;" class="rh heading table-rh"><a href="/wiki/Coderity" title="Coderity">Coderity</a></td>
<td><a href="/wiki/PHP" title="PHP">PHP</a></td>
<td><a href="/wiki/MySQL" title="MySQL">MySQL</a></td>
<td>3.3.13</td>
<td><a href="/wiki/MIT_License" title="MIT License">MIT</a></td>
<td>2015-02-27</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="/wiki/Composr_CMS" title="Composr CMS">Composr CMS</a></td>
<td><a href="/wiki/PHP" title="PHP">PHP</a></td>
<td><a href="/wiki/MySQL" title="MySQL">MySQL</a></td>
<td>9.0.30</td>
<td><a href="/wiki/Common_Public_Attribution_License" title="Common Public Attribution License">CPAL</a></td>
<td>2016-09-18</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="/wiki/Concrete5" title="Concrete5">concrete5</a></td>
<td><a href="/wiki/PHP" title="PHP">PHP</a></td>
<td><a href="/wiki/MySQL" title="MySQL">MySQL</a></td>
<td>8.1.0</td>
<td><a href="/wiki/MIT_license" class="mw-redirect" title="MIT license">MIT</a></td>
<td>2017-01-24</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="/wiki/Contao" title="Contao">Contao</a></td>
<td><a href="/wiki/PHP" title="PHP">PHP</a></td>
<td><a href="/wiki/MySQL" title="MySQL">MySQL</a></td>
<td>4.4.0</td>
<td><a href="/wiki/GNU_Lesser_General_Public_License" title="GNU Lesser General Public License">LGPL</a></td>
<td>2017-06-16</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="/wiki/DokuWiki" title="DokuWiki">DokuWiki</a></td>
<td><a href="/wiki/PHP" title="PHP">PHP</a></td>
<td><a href="/wiki/Flat-file_database" class="mw-redirect" title="Flat-file database">Flat-file database</a></td>
<td>2017-02-19a</td>
<td><a href="/wiki/GPL" class="mw-redirect" title="GPL">GPL</a></td>
<td>2017-02-19</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="/wiki/Dotclear" title="Dotclear">Dotclear</a></td>
<td><a href="/wiki/PHP" title="PHP">PHP</a></td>
<td><a href="/wiki/MySQL" title="MySQL">MySQL</a>, <a href="/wiki/PostgreSQL" title="PostgreSQL">PostgreSQL</a>, <a href="/wiki/SQLite" title="SQLite">SQLite</a></td>
<td>2.12</td>
<td><a href="/wiki/GPL" class="mw-redirect" title="GPL">GPL</a></td>
<td>2017-07-27</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="/wiki/Drupal" title="Drupal">Drupal</a></td>
<td><a href="/wiki/PHP" title="PHP">PHP</a></td>
<td><a href="/wiki/MariaDB" title="MariaDB">MariaDB</a>, <a href="/wiki/Microsoft_SQL_Server" title="Microsoft SQL Server">Microsoft SQL Server</a>, <a href="/wiki/MySQL" title="MySQL">MySQL</a>, <a href="/wiki/Oracle_database" class="mw-redirect" title="Oracle database">Oracle</a>, <a href="/wiki/Percona_Server" class="mw-redirect" title="Percona Server">Percona Server</a>, <a href="/wiki/PostgreSQL" title="PostgreSQL">PostgreSQL</a>, <a href="/wiki/SQLite" title="SQLite">SQLite</a></td>
<td>8.3.7</td>
<td><a href="/wiki/Gpl#Version_2" class="mw-redirect" title="Gpl">GPLv2+</a></td>
<td>2017-08-16</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="/wiki/Exponent_CMS" title="Exponent CMS">Exponent CMS</a></td>
<td><a href="/wiki/PHP" title="PHP">PHP</a></td>
<td><a href="/wiki/MySQL" title="MySQL">MySQL</a></td>
<td>2.4.1</td>
<td><a href="/wiki/GPL" class="mw-redirect" title="GPL">GPL</a></td>
<td>2017-08-18<small class="plainlinks"><a class="external text" href="//en.wikipedia.org/w/index.php?title=Template:ExponentCMS_version&amp;action=edit">[±]</a></small></td>
</tr>
<tr>
<td style="background: #edf; color: black; vertical-align: middle; text-align: left; font-weight: bolder;" class="rh heading table-rh"><a href="/wiki/EZ_Publish" title="EZ Publish">eZ Publish</a></td>
<td><a href="/wiki/PHP" title="PHP">PHP</a></td>
<td><a href="/wiki/MySQL" title="MySQL">MySQL</a>, <a href="/wiki/PostgreSQL" title="PostgreSQL">PostgreSQL</a>, <a href="/wiki/Oracle_database" class="mw-redirect" title="Oracle database">Oracle</a>, <a href="/wiki/Microsoft_SQL_Server" title="Microsoft SQL Server">Microsoft SQL Server</a></td>
<td>5.4</td>
<td><a href="/wiki/GPL" class="mw-redirect" title="GPL">GPL</a></td>
<td>2014-12-02</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="/wiki/EZ_Platform" title="EZ Platform">eZ Platform</a></td>
<td><a href="/wiki/PHP" title="PHP">PHP</a></td>
<td><a href="/wiki/MySQL" title="MySQL">MySQL</a>, <a href="/wiki/MariaDB" title="MariaDB">MariaDB</a>, <a href="/wiki/PostgreSQL" title="PostgreSQL">PostgreSQL</a></td>
<td>1.7.0</td>
<td><a href="/wiki/GPL" class="mw-redirect" title="GPL">GPL</a></td>
<td>2016-12-15</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="/wiki/Geeklog" title="Geeklog">Geeklog</a></td>
<td><a href="/wiki/PHP" title="PHP">PHP</a></td>
<td><a href="/wiki/MySQL" title="MySQL">MySQL</a>, <a href="/wiki/PostgreSQL" title="PostgreSQL">PostgreSQL</a>, <a href="/wiki/Microsoft_SQL_Server" title="Microsoft SQL Server">Microsoft SQL Server</a></td>
<td>2.1.3</td>
<td><a href="/wiki/GPL" class="mw-redirect" title="GPL">GPL</a></td>
<td>2017-06-22</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="/wiki/GetSimple_CMS" title="GetSimple CMS">GetSimple CMS</a></td>
<td><a href="/wiki/PHP" title="PHP">PHP</a></td>
<td><a href="/wiki/Flat-file_database" class="mw-redirect" title="Flat-file database">Flat-file database</a></td>
<td>3.3.13</td>
<td><a href="/wiki/GPL" class="mw-redirect" title="GPL">GPL</a></td>
<td>2016-10-11</td>
</tr>
<tr>
<td style="background: #edf; color: black; vertical-align: middle; text-align: left; font-weight: bolder;" class="rh heading table-rh"><a href="/wiki/Habari" title="Habari">Habari</a></td>
<td><a href="/wiki/PHP" title="PHP">PHP</a></td>
<td><a href="/wiki/MySQL" title="MySQL">MySQL</a>, <a href="/wiki/PostgreSQL" title="PostgreSQL">PostgreSQL</a>, <a href="/wiki/SQLite" title="SQLite">SQLite</a></td>
<td>0.9.2</td>
<td><a href="/wiki/Apache_License" title="Apache License">Apache License</a></td>
<td>2014-09-16</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="/wiki/ImpressCMS" title="ImpressCMS">ImpressCMS</a></td>
<td><a href="/wiki/PHP" title="PHP">PHP</a></td>
<td><a href="/wiki/MySQL" title="MySQL">MySQL</a></td>
<td>1.3.10</td>
<td><a href="/wiki/GPL" class="mw-redirect" title="GPL">GPL</a></td>
<td>2016-12-28</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="/wiki/ImpressPages" title="ImpressPages">ImpressPages</a></td>
<td><a href="/wiki/PHP" title="PHP">PHP</a></td>
<td><a href="/wiki/MySQL" title="MySQL">MySQL</a></td>
<td>4.8.0</td>
<td><a href="/wiki/GPL" class="mw-redirect" title="GPL">GPL</a> <a href="/wiki/MIT_License" title="MIT License">MIT</a></td>
<td>2016-10-30</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="/wiki/Jamroom" title="Jamroom">Jamroom</a></td>
<td><a href="/wiki/PHP" title="PHP">PHP</a></td>
<td><a href="/wiki/MySQL" title="MySQL">MySQL</a>, <a href="/wiki/MariaDB" title="MariaDB">MariaDB</a>, <a href="/wiki/Percona" title="Percona">Percona</a></td>
<td>6.1.0</td>
<td><a href="/wiki/Mozilla_Public_License" title="Mozilla Public License">MPL</a></td>
<td>2017-08-30</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="/wiki/Joomla!" class="mw-redirect" title="Joomla!">Joomla!</a></td>
<td><a href="/wiki/PHP" title="PHP">PHP</a></td>
<td><a href="/wiki/MySQL" title="MySQL">MySQL</a>, <a href="/wiki/PostgreSQL" title="PostgreSQL">PostgreSQL</a>, <a href="/wiki/MSSQL" class="mw-redirect" title="MSSQL">MSSQL</a>, <a href="/wiki/SQLite" title="SQLite">SQLite</a></td>
<td>3.8.1</td>
<td><a href="/wiki/GPL" class="mw-redirect" title="GPL">GPL</a></td>
<td>2017-10-04</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="/wiki/Kajona" title="Kajona">Kajona</a></td>
<td><a href="/wiki/PHP" title="PHP">PHP</a></td>
<td><a href="/wiki/MySQL" title="MySQL">MySQL</a>, <a href="/wiki/PostgreSQL" title="PostgreSQL">PostgreSQL</a>, <a href="/wiki/SQLite" title="SQLite">SQLite</a>, <a href="/wiki/MariaDB" title="MariaDB">MariaDB</a>, <a href="/wiki/Oracle_Database" title="Oracle Database">Oracle</a></td>
<td>6.2</td>
<td><a href="/wiki/LGPL" class="mw-redirect" title="LGPL">LGPL</a></td>
<td>2017-06-08</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="/wiki/Known_(software)" title="Known (software)">Known</a></td>
<td><a href="/wiki/PHP" title="PHP">PHP</a></td>
<td><a href="/wiki/MySQL" title="MySQL">MySQL</a>, <a href="/wiki/MongoDB" title="MongoDB">MongoDB</a></td>
<td>0.9.2</td>
<td><a href="/wiki/Apache_License" title="Apache License">Apache License</a></td>
<td>2016-04-24</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="/wiki/Magento" title="Magento">Magento</a></td>
<td><a href="/wiki/PHP" title="PHP">PHP</a></td>
<td><a href="/wiki/MySQL" title="MySQL">MySQL</a></td>
<td>2.1.8</td>
<td><a href="/wiki/OSL_Ver._3" class="mw-redirect" title="OSL Ver. 3">OSL Ver. 3</a> / <a href="/wiki/AFL_Ver._3" class="mw-redirect" title="AFL Ver. 3">AFL Ver. 3</a></td>
<td>2017-08-09</td>
</tr>
<tr>
<td style="background: #edf; color: black; vertical-align: middle; text-align: left; font-weight: bolder;" class="rh heading table-rh"><a href="/wiki/Mambo_(software)" title="Mambo (software)">Mambo</a></td>
<td><a href="/wiki/PHP" title="PHP">PHP</a></td>
<td><a href="/wiki/MySQL" title="MySQL">MySQL</a></td>
<td>4.6.5</td>
<td><a href="/wiki/GPL" class="mw-redirect" title="GPL">GPL</a></td>
<td>2008-06-01</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="/wiki/MediaWiki" title="MediaWiki">MediaWiki</a></td>
<td><a href="/wiki/PHP" title="PHP">PHP</a></td>
<td><a href="/wiki/MySQL" title="MySQL">MySQL</a>, <a href="/wiki/MariaDB" title="MariaDB">MariaDB</a>, <a href="/wiki/PostgreSQL" title="PostgreSQL">PostgreSQL</a>, <a href="/wiki/SQLite" title="SQLite">SQLite</a>, <a href="/wiki/MSSQL" class="mw-redirect" title="MSSQL">MSSQL</a></td>
<td>1.29.1</td>
<td><a href="/wiki/GPL" class="mw-redirect" title="GPL">GPL</a></td>
<td>2017-08-23</td>
</tr>
<tr>
<td style="background: #edf; color: black; vertical-align: middle; text-align: left; font-weight: bolder;" class="rh heading table-rh"><a href="/wiki/MiaCMS" title="MiaCMS">MiaCMS</a></td>
<td><a href="/wiki/PHP" title="PHP">PHP</a></td>
<td><a href="/wiki/MySQL" title="MySQL">MySQL</a></td>
<td>4.9</td>
<td><a href="/wiki/GPL" class="mw-redirect" title="GPL">GPL</a></td>
<td>2009-07-29</td>
</tr>
<tr>
<td style="background: #edf; color: black; vertical-align: middle; text-align: left; font-weight: bolder;" class="rh heading table-rh"><a href="/wiki/Midgard_(software)" title="Midgard (software)">Midgard CMS</a></td>
<td><a href="/wiki/PHP" title="PHP">PHP</a> (Midgard framework)</td>
<td><a href="/wiki/MySQL" title="MySQL">MySQL</a></td>
<td>12.0.9.2</td>
<td><a href="/wiki/GNU_Lesser_General_Public_License" title="GNU Lesser General Public License">LGPL</a></td>
<td>2012-09-26</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="/wiki/MODX" title="MODX">MODX</a></td>
<td><a href="/wiki/PHP" title="PHP">PHP</a></td>
<td><a href="/wiki/MySQL" title="MySQL">MySQL</a></td>
<td>2.5.8</td>
<td><a href="/wiki/GPL" class="mw-redirect" title="GPL">GPL</a></td>
<td>2017-09-13</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="/wiki/Moodle" title="Moodle">Moodle</a></td>
<td><a href="/wiki/PHP" title="PHP">PHP</a></td>
<td><a href="/wiki/MySQL" title="MySQL">MySQL</a>, <a href="/wiki/PostgreSQL" title="PostgreSQL">PostgreSQL</a>, <a href="/wiki/MSSQL" class="mw-redirect" title="MSSQL">MSSQL</a>, or <a href="/wiki/Oracle_Database" title="Oracle Database">Oracle</a></td>
<td>3.3</td>
<td><a href="/wiki/Gpl#Version_3" class="mw-redirect" title="Gpl">GPLv3+</a></td>
<td>2017-05-14</td>
</tr>
<tr>
<td style="background: #edf; color: black; vertical-align: middle; text-align: left; font-weight: bolder;" class="rh heading table-rh"><a href="/wiki/Novius_OS" title="Novius OS">Novius OS</a></td>
<td><a href="/wiki/PHP" title="PHP">PHP</a></td>
<td><a href="/wiki/MySQL" title="MySQL">MySQL</a></td>
<td>5.0.1 (Elche)</td>
<td><a href="/wiki/AGPLv3" class="mw-redirect" title="AGPLv3">AGPLv3</a></td>
<td>2014-07-08</td>
</tr>
<tr>
<td style="background: #edf; color: black; vertical-align: middle; text-align: left; font-weight: bolder;" class="rh heading table-rh"><a href="/wiki/Nucleus_CMS" title="Nucleus CMS">Nucleus CMS</a></td>
<td><a href="/wiki/PHP" title="PHP">PHP</a></td>
<td><a href="/wiki/MySQL" title="MySQL">MySQL</a></td>
<td>3.64</td>
<td><a href="/wiki/GPL" class="mw-redirect" title="GPL">GPL</a></td>
<td>2011-03-14</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="/wiki/October_(CMS)" title="October (CMS)">OctoberCMS</a></td>
<td><a href="/wiki/PHP" title="PHP">PHP</a></td>
<td><a href="/wiki/MySQL" title="MySQL">MySQL</a>, <a href="/wiki/PostgreSQL" title="PostgreSQL">PostgreSQL</a>, <a href="/wiki/SQLite" title="SQLite">SQLite</a></td>
<td>419</td>
<td><a href="/wiki/MIT_license" class="mw-redirect" title="MIT license">MIT</a></td>
<td>2017-05-15</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="/wiki/Omeka" title="Omeka">Omeka</a></td>
<td><a href="/wiki/PHP" title="PHP">PHP</a></td>
<td><a href="/wiki/MySQL" title="MySQL">MySQL</a></td>
<td>2.5</td>
<td><a href="/wiki/GPL" class="mw-redirect" title="GPL">GPL</a></td>
<td>2017-01-31</td>
</tr>
<tr>
<td style="background: #edf; color: black; vertical-align: middle; text-align: left; font-weight: bolder;" class="rh heading table-rh"><a href="/wiki/Papaya_CMS" title="Papaya CMS">papaya CMS</a></td>
<td><a href="/wiki/PHP" title="PHP">PHP</a></td>
<td><a href="/wiki/MySQL" title="MySQL">MySQL</a>, <a href="/wiki/PostgreSQL" title="PostgreSQL">PostgreSQL</a>, <a href="/wiki/SQLite" title="SQLite">SQLite</a></td>
<td>5.5.2</td>
<td><a href="/wiki/GNU_General_Public_License" title="GNU General Public License">GPL v2</a></td>
<td>2013-02-12</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="/wiki/Ph7cms" title="Ph7cms">pH7CMS</a></td>
<td><a href="/wiki/PHP" title="PHP">PHP</a></td>
<td><a href="/wiki/MySQL" title="MySQL">MySQL</a>, <a href="/wiki/MariaDB" title="MariaDB">MariaDB</a></td>
<td>8.0.6</td>
<td><a href="/wiki/GPL#Version_3" class="mw-redirect" title="GPL">GPL 3.0</a></td>
<td>2017-08-27</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="/wiki/Phire_CMS" title="Phire CMS">Phire CMS</a></td>
<td><a href="/wiki/PHP" title="PHP">PHP</a></td>
<td><a href="/wiki/MySQL" title="MySQL">MySQL</a></td>
<td>2.1.0</td>
<td><a href="/wiki/New_BSD_License" class="mw-redirect" title="New BSD License">New BSD License</a></td>
<td>2016-07-07</td>
</tr>
<tr>
<td style="background: #edf; color: black; vertical-align: middle; text-align: left; font-weight: bolder;" class="rh heading table-rh"><a href="/wiki/PHP-Nuke" title="PHP-Nuke">PHP-Nuke</a></td>
<td><a href="/wiki/PHP" title="PHP">PHP</a></td>
<td><a href="/wiki/MySQL" title="MySQL">MySQL</a></td>
<td>8.3.2</td>
<td><a href="/wiki/GPL" class="mw-redirect" title="GPL">GPL</a></td>
<td>2014-01-30</td>
</tr>
<tr>
<td style="background: #edf; color: black; vertical-align: middle; text-align: left; font-weight: bolder;" class="rh heading table-rh"><a href="/wiki/PhpWebLog" title="PhpWebLog">phpWebLog</a></td>
<td><a href="/wiki/PHP" title="PHP">PHP</a></td>
<td><a href="/wiki/MySQL" title="MySQL">MySQL</a></td>
<td>0.5.3</td>
<td><a href="/wiki/GPL" class="mw-redirect" title="GPL">GPL</a></td>
<td>2001-10-31</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="/wiki/PhpWiki" title="PhpWiki">phpWiki</a></td>
<td><a href="/wiki/PHP" title="PHP">PHP</a></td>
<td><a href="/wiki/MySQL" title="MySQL">MySQL</a></td>
<td>1.5.5</td>
<td><a href="/wiki/GPL" class="mw-redirect" title="GPL">GPL</a></td>
<td>2015-12-11</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="/wiki/Pimcore" title="Pimcore">Pimcore</a></td>
<td><a href="/wiki/PHP" title="PHP">PHP</a></td>
<td><a href="/wiki/MySQL" title="MySQL">MySQL</a></td>
<td>5.0</td>
<td><a href="/wiki/GPL" class="mw-redirect" title="GPL">GPL</a></td>
<td>2017-09-28</td>
</tr>
<tr>
<td style="background: #edf; color: black; vertical-align: middle; text-align: left; font-weight: bolder;" class="rh heading table-rh"><a href="/wiki/PivotX" title="PivotX">PivotX</a></td>
<td><a href="/wiki/PHP" title="PHP">PHP</a></td>
<td><a href="/wiki/MySQL" title="MySQL">MySQL</a>, <a href="/wiki/Flat-file_database" class="mw-redirect" title="Flat-file database">Flat-file database</a></td>
<td>2.3.11</td>
<td><a href="/wiki/GPL" class="mw-redirect" title="GPL">GPL</a></td>
<td>2015-06-21</td>
</tr>
<tr>
<td style="background: #edf; color: black; vertical-align: middle; text-align: left; font-weight: bolder;" class="rh heading table-rh"><a href="/wiki/Pixie_(CMS)" title="Pixie (CMS)">Pixie (CMS)</a></td>
<td><a href="/wiki/PHP" title="PHP">PHP</a></td>
<td><a href="/wiki/MySQL" title="MySQL">MySQL</a></td>
<td>1.0.4</td>
<td><a href="/wiki/GPL" class="mw-redirect" title="GPL">GPL</a></td>
<td>2010-03-21</td>
</tr>
<tr>
<td style="background: #edf; color: black; vertical-align: middle; text-align: left; font-weight: bolder;" class="rh heading table-rh"><a href="/wiki/Pluck_(software)" title="Pluck (software)">Pluck</a></td>
<td><a href="/wiki/PHP" title="PHP">PHP</a></td>
<td><a href="/wiki/Flat-file_database" class="mw-redirect" title="Flat-file database">Flat-file database</a></td>
<td>4.7.3</td>
<td><a href="/wiki/GPL3" class="mw-redirect" title="GPL3">GPL3</a></td>
<td>2014-12-08</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="/wiki/PmWiki" title="PmWiki">PmWiki</a></td>
<td><a href="/wiki/PHP" title="PHP">PHP</a></td>
<td><a href="/wiki/Flat-file_database" class="mw-redirect" title="Flat-file database">Flat-file database</a></td>
<td>2.2.104</td>
<td><a href="/wiki/GPL" class="mw-redirect" title="GPL">GPL</a></td>
<td>2017-10-11</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="/wiki/Prestashop" class="mw-redirect" title="Prestashop">Prestashop</a></td>
<td><a href="/wiki/PHP" title="PHP">PHP</a></td>
<td><a href="/wiki/MySQL" title="MySQL">MySQL</a></td>
<td>1.6.1.8</td>
<td><a href="/wiki/Open_Software_License_3.0" class="mw-redirect" title="Open Software License 3.0">Open Software License 3.0</a></td>
<td>2016-10-26</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="/wiki/ProcessWire" title="ProcessWire">ProcessWire</a></td>
<td><a href="/wiki/PHP" title="PHP">PHP</a></td>
<td><a href="/wiki/MySQL" title="MySQL">MySQL</a></td>
<td>3.0.62</td>
<td><a href="/wiki/Mozilla_Public_License" title="Mozilla Public License">Mozilla Public License 2.0</a></td>
<td>2017-05-12</td>
</tr>
<tr>
<td style="background: #edf; color: black; vertical-align: middle; text-align: left; font-weight: bolder;" class="rh heading table-rh"><a href="/wiki/Semantic_MediaWiki_Plus" class="mw-redirect" title="Semantic MediaWiki Plus">SMW+</a></td>
<td><a href="/wiki/PHP" title="PHP">PHP</a> - <a href="/wiki/MediaWiki" title="MediaWiki">MediaWiki</a></td>
<td><a href="/wiki/MySQL" title="MySQL">MySQL</a></td>
<td>1.7.0</td>
<td><a href="/wiki/GPL" class="mw-redirect" title="GPL">GPL</a></td>
<td>2012-04-24</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="/wiki/Serendipity_(weblog_software)" class="mw-redirect" title="Serendipity (weblog software)">Serendipity</a></td>
<td><a href="/wiki/PHP" title="PHP">PHP</a> + <a href="/wiki/Smarty" title="Smarty">Smarty</a></td>
<td><a href="/wiki/MySQL" title="MySQL">MySQL</a>, <a href="/wiki/PostgreSQL" title="PostgreSQL">PostgreSQL</a>, <a href="/wiki/MySQLi" title="MySQLi">MySQLi</a>, <a href="/wiki/SQLite" title="SQLite">SQLite</a></td>
<td>2.0.4</td>
<td><a href="/wiki/BSD_licenses" title="BSD licenses">BSD</a></td>
<td>2016-09-26</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="/wiki/SilverStripe" title="SilverStripe">SilverStripe</a></td>
<td><a href="/wiki/PHP" title="PHP">PHP</a></td>
<td><a href="/wiki/MySQL" title="MySQL">MySQL</a>, <a href="/wiki/Microsoft_SQL_Server" title="Microsoft SQL Server">Microsoft SQL Server</a>, <a href="/wiki/PostgreSQL" title="PostgreSQL">PostgreSQL</a>, <a href="/wiki/SQLite" title="SQLite">SQLite</a>, <a href="/wiki/Oracle_database" class="mw-redirect" title="Oracle database">Oracle</a></td>
<td>3.5.3</td>
<td><a href="/wiki/BSD_licenses" title="BSD licenses">BSD</a></td>
<td>2017-02-21</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="/wiki/SPIP" title="SPIP">SPIP</a></td>
<td><a href="/wiki/PHP" title="PHP">PHP</a></td>
<td><a href="/wiki/MySQL" title="MySQL">MySQL</a>, <a href="/wiki/PostgreSQL" title="PostgreSQL">PostgreSQL</a>, <a href="/wiki/SQLite" title="SQLite">SQLite</a></td>
<td>3.1.6</td>
<td><a href="/wiki/LGPL" class="mw-redirect" title="LGPL">LGPL</a></td>
<td>2017-06-12</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="/wiki/Textpattern" title="Textpattern">Textpattern</a></td>
<td><a href="/wiki/PHP" title="PHP">PHP</a></td>
<td><a href="/wiki/MySQL" title="MySQL">MySQL</a></td>
<td>4.6.2</td>
<td><a href="/wiki/GPL" class="mw-redirect" title="GPL">GPL</a></td>
<td>2016-10-21</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="/wiki/Tiki_Wiki_CMS_Groupware" title="Tiki Wiki CMS Groupware">Tiki Wiki CMS Groupware</a></td>
<td><a href="/wiki/PHP" title="PHP">PHP</a></td>
<td><a href="/wiki/MySQL" title="MySQL">MySQL</a></td>
<td>15.2</td>
<td><a href="/wiki/LGPL" class="mw-redirect" title="LGPL">LGPL</a></td>
<td>2016-07-06</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="/wiki/TYPO3" title="TYPO3">TYPO3</a></td>
<td><a href="/wiki/PHP" title="PHP">PHP</a></td>
<td><a href="/wiki/MySQL" title="MySQL">MySQL</a>, <a href="/wiki/Oracle_database" class="mw-redirect" title="Oracle database">Oracle</a>, <a href="/wiki/PostgreSQL" title="PostgreSQL">PostgreSQL</a></td>
<td>8.7.8</td>
<td><a href="/wiki/GPL" class="mw-redirect" title="GPL">GPL</a></td>
<td>2017-04-04<small class="plainlinks"><a class="external text" href="//en.wikipedia.org/w/index.php?title=Template:TYPO3_version&amp;action=edit">[±]</a></small></td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="/wiki/Wolf_CMS" title="Wolf CMS">Wolf CMS</a></td>
<td><a href="/wiki/PHP" title="PHP">PHP</a></td>
<td><a href="/wiki/MySQL" title="MySQL">MySQL</a>, <a href="/wiki/PostgreSQL" title="PostgreSQL">PostgreSQL</a>, <a href="/wiki/SQLite" title="SQLite">SQLite</a></td>
<td>0.8.3.1</td>
<td><a href="/wiki/GPL" class="mw-redirect" title="GPL">GPL v3</a></td>
<td>2015-08-10</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="/wiki/WordPress" title="WordPress">WordPress</a></td>
<td><a href="/wiki/PHP" title="PHP">PHP</a></td>
<td><a href="/wiki/MySQL" title="MySQL">MySQL</a>, <a href="/wiki/MariaDB" title="MariaDB">MariaDB</a></td>
<td>4.8.3</td>
<td><a href="/wiki/GPL" class="mw-redirect" title="GPL">GPL</a></td>
<td>2017-10-31</td>
</tr>
<tr>
<td style="background: #edf; color: black; vertical-align: middle; text-align: left; font-weight: bolder;" class="rh heading table-rh"><a href="/wiki/Xaraya" title="Xaraya">Xaraya</a></td>
<td><a href="/wiki/PHP" title="PHP">PHP</a></td>
<td><a href="/wiki/MySQL" title="MySQL">MySQL</a>, <a href="/wiki/PostgreSQL" title="PostgreSQL">PostgreSQL</a></td>
<td>2.4.0</td>
<td><a href="/wiki/GPL" class="mw-redirect" title="GPL">GPL</a></td>
<td>2013-02-23</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="/wiki/XOOPS" title="XOOPS">XOOPS</a></td>
<td><a href="/wiki/PHP" title="PHP">PHP</a></td>
<td><a href="/wiki/MySQL" title="MySQL">MySQL</a></td>
<td>2.5.8</td>
<td><a href="/wiki/GPL" class="mw-redirect" title="GPL">GPL</a></td>
<td>2016-05-27</td>
</tr>
</table>
<h3><span class="mw-headline" id="Python">Python</span><span class="mw-editsection"><span class="mw-editsection-bracket">[</span><a href="/w/index.php?title=List_of_content_management_systems&amp;action=edit&amp;section=7" title="Edit section: Python">edit</a><span class="mw-editsection-bracket">]</span></span></h3>
<table class="wikitable sortable" style="font-size: 85%; text-align: left; width: auto;">
<tr>
<th>Name</th>
<th>Platform</th>
<th>Supported databases</th>
<th>Latest stable release</th>
<th>Licenses</th>
<th>Latest release date</th>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="/wiki/Django_CMS" title="Django CMS">django CMS</a></td>
<td><a href="/wiki/Python_(programming_language)" title="Python (programming language)">Python</a>/<a href="/wiki/Django_(Web_framework)" class="mw-redirect" title="Django (Web framework)">Django</a></td>
<td><a href="/wiki/PostgreSQL" title="PostgreSQL">PostgreSQL</a>, <a href="/wiki/MySQL" title="MySQL">MySQL</a>, <a href="/wiki/SQLite" title="SQLite">SQLite</a> 3 and <a href="/wiki/Oracle_Database" title="Oracle Database">Oracle</a></td>
<td>3.3.0</td>
<td><a href="/wiki/BSD" class="mw-redirect" title="BSD">BSD</a></td>
<td>2016-05-27</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="/wiki/Mezzanine_(CMS)" title="Mezzanine (CMS)">Mezzanine</a></td>
<td><a href="/wiki/Python_(programming_language)" title="Python (programming language)">Python</a>/<a href="/wiki/Django_(Web_framework)" class="mw-redirect" title="Django (Web framework)">Django</a></td>
<td><a href="/wiki/PostgreSQL" title="PostgreSQL">PostgreSQL</a>, <a href="/wiki/MySQL" title="MySQL">MySQL</a>, <a href="/wiki/SQLite" title="SQLite">SQLite</a> 3 and <a href="/wiki/Oracle_Database" title="Oracle Database">Oracle</a></td>
<td>4.2.2</td>
<td><a href="/wiki/BSD" class="mw-redirect" title="BSD">BSD</a></td>
<td>2016-11-25</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="/wiki/MoinMoin" title="MoinMoin">MoinMoin</a></td>
<td><a href="/wiki/Python_(programming_language)" title="Python (programming language)">Python</a></td>
<td><a href="/wiki/Flat-file_database" class="mw-redirect" title="Flat-file database">Flat-file database</a></td>
<td>1.9.9</td>
<td><a href="/wiki/GPL" class="mw-redirect" title="GPL">GPL</a></td>
<td>2016-10-31</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="/wiki/Plone_(software)" title="Plone (software)">Plone</a></td>
<td><a href="/wiki/Python_(programming_language)" title="Python (programming language)">Python</a>/<a href="/wiki/Zope" title="Zope">Zope</a></td>
<td><a href="/wiki/MySQL" title="MySQL">MySQL</a>, <a href="/wiki/PostgreSQL" title="PostgreSQL">PostgreSQL</a>, <a href="/wiki/SQLite" title="SQLite">SQLite</a>, <a href="/wiki/Oracle_database" class="mw-redirect" title="Oracle database">Oracle</a>, <a href="/wiki/Zope_Object_Database" title="Zope Object Database">ZODB</a>, via <a href="/wiki/Zope" title="Zope">Zope</a></td>
<td>5.0.7</td>
<td><a href="/wiki/GPL" class="mw-redirect" title="GPL">GPL</a></td>
<td>2017-03-15</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="/wiki/Wagtail_(CMS)" title="Wagtail (CMS)">Wagtail</a></td>
<td><a href="/wiki/Python_(programming_language)" title="Python (programming language)">Python</a>/<a href="/wiki/Django_(Web_framework)" class="mw-redirect" title="Django (Web framework)">Django</a></td>
<td><a href="/wiki/PostgreSQL" title="PostgreSQL">PostgreSQL</a>, <a href="/wiki/MySQL" title="MySQL">MySQL</a>, <a href="/wiki/SQLite" title="SQLite">SQLite</a> 3 and <a href="/wiki/Oracle_Database" title="Oracle Database">Oracle</a></td>
<td>1.12.2</td>
<td><a href="/wiki/BSD" class="mw-redirect" title="BSD">BSD</a></td>
<td>2017-09-18</td>
</tr>
</table>
<h3><span class="mw-headline" id="Ruby_on_Rails">Ruby on Rails</span></span></h3>
<table class="wikitable sortable" style="font-size: 85%; text-align: left; width: auto;">
<tr>
<th>Name</th>
<th>Platform</th>
<th>Supported databases</th>
<th>Latest stable release</th>
<th>Licenses</th>
<th>Latest release date</th>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="/wiki/Alchemy_CMS" title="Alchemy CMS">Alchemy CMS</a></td>
<td><a href="/wiki/Ruby_on_Rails" title="Ruby on Rails">Ruby on Rails</a></td>
<td><a href="/wiki/PostgreSQL" title="PostgreSQL">PostgreSQL</a>, <a href="/wiki/MySQL" title="MySQL">MySQL</a>, <a href="/wiki/SQLite" title="SQLite">SQLite</a></td>
<td>3.5</td>
<td><a href="/wiki/BSD_license" class="mw-redirect" title="BSD license">BSD</a></td>
<td>2016-12-22</td>
</tr>
<tr>
<td style="background: #edf; color: black; vertical-align: middle; text-align: left; font-weight: bolder;" class="rh heading table-rh"><a href="/wiki/BrowserCMS" title="BrowserCMS">BrowserCMS</a></td>
<td><a href="/wiki/Ruby_on_Rails" title="Ruby on Rails">Ruby on Rails</a></td>
<td><a href="/wiki/MySQL" title="MySQL">MySQL</a>, <a href="/wiki/SQLite" title="SQLite">SQLite</a></td>
<td>3.5.7</td>
<td><a href="/wiki/Lesser_General_Public_License" class="mw-redirect" title="Lesser General Public License">LGPL</a></td>
<td>2013-07-05</td>
</tr>
<tr>
<td style="background: #edf; color: black; vertical-align: middle; text-align: left; font-weight: bolder;" class="rh heading table-rh"><a href="/wiki/Radiant_(software)" title="Radiant (software)">Radiant</a></td>
<td><a href="/wiki/Ruby_on_Rails" title="Ruby on Rails">Ruby on Rails</a></td>
<td><a href="/wiki/MySQL" title="MySQL">MySQL</a>, <a href="/wiki/PostgreSQL" title="PostgreSQL">PostgreSQL</a>, <a href="/wiki/SQLite" title="SQLite">SQLite</a>, <a href="/wiki/IBM_DB2" class="mw-redirect" title="IBM DB2">DB2</a></td>
<td>1.1.4</td>
<td><a href="/wiki/MIT_License" title="MIT License">MIT</a></td>
<td>2013-09-24</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="/wiki/Refinery_CMS" title="Refinery CMS">Refinery CMS</a></td>
<td><a href="/wiki/Ruby_on_Rails" title="Ruby on Rails">Ruby on Rails</a></td>
<td><a href="/wiki/MySQL" title="MySQL">MySQL</a>, <a href="/wiki/PostgreSQL" title="PostgreSQL">PostgreSQL</a>, <a href="/wiki/SQLite" title="SQLite">SQLite</a></td>
<td>3.0.5</td>
<td><a href="/wiki/MIT_License" title="MIT License">MIT</a></td>
<td>2016-11-23</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="/wiki/Typo_(software)" title="Typo (software)">Typo</a></td>
<td><a href="/wiki/Ruby_on_Rails" title="Ruby on Rails">Ruby on Rails</a></td>
<td><a href="/wiki/MySQL" title="MySQL">MySQL</a>, <a href="/wiki/PostgreSQL" title="PostgreSQL">PostgreSQL</a>, <a href="/wiki/SQLite" title="SQLite">SQLite</a></td>
<td>8.3.3</td>
<td><a href="/wiki/MIT_License" title="MIT License">MIT</a></td>
<td>2016-11-03</td>
</tr>
</table>
<h3><span id="ColdFusion_Markup_Language_(CFML)"></span><span class="mw-headline" id="ColdFusion_Markup_Language_.28CFML.29">ColdFusion Markup Language (CFML)</span></span></h3>
<table class="wikitable sortable" style="font-size: 85%; text-align: left; width: auto;">
<tr>
<th>Name</th>
<th>Platform</th>
<th>Supported databases</th>
<th>Latest stable release</th>
<th>Licenses</th>
<th>Latest release date</th>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="/wiki/ContentBox_Modular_CMS" title="ContentBox Modular CMS">ContentBox Modular CMS</a></td>
<td><a href="/wiki/Lucee" title="Lucee">Lucee</a> / <a href="/wiki/Railo" title="Railo">Railo</a> / <a href="/wiki/Adobe_ColdFusion" title="Adobe ColdFusion">Adobe ColdFusion</a></td>
<td><a href="/wiki/MySQL" title="MySQL">MySQL</a>/<a href="/wiki/Microsoft_SQL_Server" title="Microsoft SQL Server">Microsoft SQL Server</a>/<a href="/wiki/PostgreSQL" title="PostgreSQL">PostgreSQL</a>/<a href="/wiki/HSQLDB" title="HSQLDB">HSQLDB</a>/<a href="/wiki/Apache_Derby" title="Apache Derby">Apache Derby</a></td>
<td>2.1.0</td>
<td><a href="/wiki/Apache_License" title="Apache License">Apache License</a> or proprietary</td>
<td>2015-05-05</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="/wiki/Mura_CMS" title="Mura CMS">Mura CMS</a></td>
<td><a href="/wiki/Lucee" title="Lucee">Lucee</a> / <a href="/wiki/Railo" title="Railo">Railo</a> / <a href="/wiki/OpenBD" class="mw-redirect" title="OpenBD">OpenBD</a> / <a href="/wiki/Adobe_ColdFusion" title="Adobe ColdFusion">Adobe ColdFusion</a></td>
<td><a href="/wiki/MySQL" title="MySQL">MySQL</a>/<a href="/wiki/Microsoft_SQL_Server" title="Microsoft SQL Server">Microsoft SQL Server</a>/<a href="/wiki/Oracle_database" class="mw-redirect" title="Oracle database">Oracle</a></td>
<td>7.06858</td>
<td><a href="/wiki/GPL" class="mw-redirect" title="GPL">GPL</a> or proprietary</td>
<td>2017-01-03</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="/wiki/FarCry_CMS" title="FarCry CMS">FarCry CMS</a></td>
<td><a href="/wiki/Lucee" title="Lucee">Lucee</a> / <a href="/wiki/Railo" title="Railo">Railo</a> / <a href="/wiki/OpenBD" class="mw-redirect" title="OpenBD">OpenBD</a> / <a href="/wiki/Adobe_ColdFusion" title="Adobe ColdFusion">Adobe ColdFusion</a></td>
<td><a href="/wiki/MySQL" title="MySQL">MySQL</a>/<a href="/wiki/Microsoft_SQL_Server" title="Microsoft SQL Server">Microsoft SQL Server</a>/<a href="/wiki/Oracle_database" class="mw-redirect" title="Oracle database">Oracle</a>/<a href="/wiki/Postgres" class="mw-redirect" title="Postgres">Postgres</a></td>
<td>7.0.7</td>
<td><a href="/wiki/GPL" class="mw-redirect" title="GPL">GPL</a> or proprietary</td>
<td>2015-01-14</td>
</tr>
</table>
<h3><span class="mw-headline" id="JavaScript">JavaScript</span></span></h3>
<table class="wikitable sortable" style="font-size: 85%; text-align: left; width: auto;">
<tr>
<th>Name</th>
<th>Platform</th>
<th>Supported databases</th>
<th>Latest stable release</th>
<th>Licenses</th>
<th>Latest release date</th>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="/wiki/Ghost_(blogging_platform)" title="Ghost (blogging platform)">Ghost</a></td>
<td><a href="/wiki/NodeJS" class="mw-redirect" title="NodeJS">NodeJS</a> (<a href="/wiki/JavaScript" title="JavaScript">JavaScript</a>)</td>
<td><a href="/wiki/SQLite" title="SQLite">SQLite</a>, <a href="/wiki/MySQL" title="MySQL">MySQL</a></td>
<td>0.11.9</td>
<td><a href="/wiki/MIT_license" class="mw-redirect" title="MIT license">MIT</a></td>
<td>2017-05-16</td>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="/wiki/TiddlyWiki" title="TiddlyWiki">TiddlyWiki</a></td>
<td><a href="/wiki/JavaScript" title="JavaScript">JavaScript</a></td>
<td><a href="/wiki/Flat-file_database" class="mw-redirect" title="Flat-file database">Flat-file database</a></td>
<td>5.1.14</td>
<td><a href="/wiki/BSD_license" class="mw-redirect" title="BSD license">BSD license</a></td>
<td>2017-04-27</td>
</tr>
</table>
<h3><span class="mw-headline" id="Others">Others</span></span></h3>
<table class="wikitable sortable" style="font-size: 85%; text-align: left; width: auto;">
<tr>
<th>Name</th>
<th>Platform</th>
<th>Supported databases</th>
<th>Latest stable release</th>
<th>Licenses</th>
<th>Latest release date</th>
</tr>
<tr>
<td style="background: #ececec; color: black; font-weight: bold; vertical-align: middle; text-align: left;" class="table-rh"><a href="/wiki/OpenACS" class="mw-redirect" title="OpenACS">OpenACS</a></td>
<td><a href="/wiki/Tcl" title="Tcl">Tcl</a> <a href="/wiki/AOLserver" title="AOLserver">AOLserver</a></td>
<td><a href="/wiki/PostgreSQL" title="PostgreSQL">PostgreSQL</a>/<a href="/wiki/Oracle_database" class="mw-redirect" title="Oracle database">Oracle</a></td>
<td>5.9.0</td>
<td><a href="/wiki/GPL" class="mw-redirect" title="GPL">GPL</a></td>
<td>2015-12-01</td>
</tr>
</table>
<h2><span id="Software_as_a_service_(SaaS)"></span><span class="mw-headline" id="Software_as_a_service_.28SaaS.29">Software as a service (SaaS)</span></span></h2>
<dl>
<dd><i>This section lists <a href="/wiki/Proprietary_software" title="Proprietary software">proprietary software</a> that includes software, hosting, and support with a single vendor. This section includes free services.</i></dd>
</dl>
<table class="wikitable sortable" style="font-size: 85%; text-align: left; width: auto;">
<tr>
<th>Name</th>
<th>Licensed version available</th>
<th>Last stable version</th>
<th>Web content management</th>
<th>Group content management</th>
<th>Enterprise content management</th>
</tr>
<tr>
<td><a href="/wiki/Accrisoft_Freedom" title="Accrisoft Freedom">Accrisoft Freedom</a></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td>10.2</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
</tr>
<tr>
<td><a href="/wiki/Business_Catalyst" title="Business Catalyst">Adobe Business Catalyst</a></td>
<td></td>
<td>V4</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
</tr>
<tr>
<td><a href="/wiki/Alfresco_(software)" title="Alfresco (software)">Alfresco</a> Cloud</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes (Alfresco Community &amp; Enterprise)</td>
<td>2012.05</td>
<td style="background:#F99;vertical-align:middle;text-align:center;" class="table-no">No</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
</tr>
<tr>
<td><a href="/wiki/Crafter_CMS" title="Crafter CMS">Crafter CMS</a> Cloud</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes (Crafter CMS Enterprise)</td>
<td>2017.08</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#F99;vertical-align:middle;text-align:center;" class="table-no">No</td>
</tr>
<tr>
<td><a href="/wiki/Censhare" title="Censhare">censhare</a></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td>2017.02</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
</tr>
<tr>
<td><a href="/wiki/Clickability" title="Clickability">Clickability</a> (<a href="/wiki/Limelight_Networks" title="Limelight Networks">Limelight Networks</a>)</td>
<td style="background:#F99;vertical-align:middle;text-align:center;" class="table-no">No</td>
<td></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#F99;vertical-align:middle;text-align:center;" class="table-no">No</td>
<td style="background:#F99;vertical-align:middle;text-align:center;" class="table-no">No</td>
</tr>
<tr>
<td><a href="https://es.wikipedia.org/wiki/Content_-_SORT" class="extiw" title="es:Content - SORT">Content SORT</a></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td>2013.11</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
</tr>
<tr>
<td><a href="/wiki/DotCMS" title="DotCMS">dotCMS</a> Cloud</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td>4.2.0</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
</tr>
<tr>
<td>Evoq based on <a href="/wiki/DotNetNuke" title="DotNetNuke">DNN</a>/DotNetNuke</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td>9.1</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
</tr>
<tr>
<td><a href="/wiki/EXo_Platform" title="EXo Platform">eXo</a> Cloud</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td>2014.01</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
</tr>
<tr>
<td><a href="/wiki/Frontis_Archive_Publishing_System" title="Frontis Archive Publishing System">Frontis Archive Publishing System</a></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td>V3.12.01.11</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
</tr>
<tr>
<td><a href="/wiki/Huddle_(software)" title="Huddle (software)">Huddle</a></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td>2012</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
</tr>
<tr>
<td><a href="/wiki/Microsoft_Office_365" class="mw-redirect" title="Microsoft Office 365">Microsoft Office 365</a></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes (MS SharePoint, MS Lync, MS Exchange, MS Office)</td>
<td>2013</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
</tr>
<tr>
<td><a href="/wiki/NuBuilder" title="NuBuilder">nuBuilder</a></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td>2014</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
</tr>
<tr>
<td><a href="/wiki/O3Spaces" title="O3Spaces">O3Spaces</a></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td>3.2.1</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#F99;vertical-align:middle;text-align:center;" class="table-no">No</td>
</tr>
<tr>
<td><a href="/wiki/OU_Campus" title="OU Campus">OU Campus</a></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td>10.2.4</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td></td>
</tr>
<tr>
<td><a href="/wiki/Atex_(software)#Products" title="Atex (software)">Polopoly Web CMS</a></td>
<td></td>
<td>10.2</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#F99;vertical-align:middle;text-align:center;" class="table-no">No</td>
</tr>
<tr>
<td><a href="/wiki/Quintype" title="Quintype">Quintype</a></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
</tr>
<tr>
<td><a href="/wiki/UCoz" title="UCoz">uCoz</a></td>
<td></td>
<td></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#F99;vertical-align:middle;text-align:center;" class="table-no">No</td>
</tr>
<tr>
<td><a href="/wiki/Windows_Live" title="Windows Live">Windows Live</a></td>
<td style="background:#F99;vertical-align:middle;text-align:center;" class="table-no">No</td>
<td>2011</td>
<td style="background:#F99;vertical-align:middle;text-align:center;" class="table-no">No</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#F99;vertical-align:middle;text-align:center;" class="table-no">No</td>
</tr>
<tr>
<td><a href="/wiki/Xait" title="Xait">Xait</a>Porter</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td>4.9.6</td>
<td style="background:#F99;vertical-align:middle;text-align:center;" class="table-no">No</td>
<td style="background:#F99;vertical-align:middle;text-align:center;" class="table-no">No</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
</tr>
<tr>
<td><a href="/wiki/Zesty.io" title="Zesty.io">Zesty.io</a></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes (Multi-Tenant SaaS)</td>
<td>Versionless</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
</tr>
</table>
<h2><span class="mw-headline" id="Proprietary_software">Proprietary software</span></span></h2>
<dl>
<dd><i>This section lists <a href="/wiki/Proprietary_software" title="Proprietary software">proprietary software</a> to be installed and managed on a user's own server. This section includes <a href="/wiki/Freeware" title="Freeware">freeware</a> proprietary software.</i></dd>
</dl>

<table class="wikitable sortable" style="font-size: 85%; text-align: left; width: auto;">
<tr>
<th>Name</th>
<th>Platform</th>
<th>Supported databases</th>
<th>Latest stable release</th>
<th>Licenses</th>
<th>Latest release date</th>
<th>Web content management</th>
<th>Group web content management</th>
<th>Enterprise content management</th>
</tr>
<tr>
<td><a href="/wiki/Alfresco_(software)" title="Alfresco (software)">Alfresco</a> (Enterprise &amp; Community Edition)</td>
<td>Java</td>
<td><a href="/wiki/Oracle_Database" title="Oracle Database">Oracle</a>, <a href="/wiki/Microsoft_SQL_Server" title="Microsoft SQL Server">SQL Server</a>, <a href="/wiki/MySQL" title="MySQL">MySQL</a>, <a href="/wiki/PostgreSQL" title="PostgreSQL">PostgreSQL</a>, <a href="/wiki/IBM_DB2" class="mw-redirect" title="IBM DB2">DB2</a></td>
<td>4.0.2 Enterprise, 4.2.c Community</td>
<td>Open Source</td>
<td>2015-03<sup id="cite_ref-97" class="reference"><a href="#cite_note-97">[97]</a></sup></td>
<td style="background:#F99;vertical-align:middle;text-align:center;" class="table-no">No</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
</tr>
<tr>
<td><a href="/wiki/Altitude3.Net" title="Altitude3.Net">Altitude3.Net</a></td>
<td><a href="/wiki/ASP.NET" title="ASP.NET">ASP.NET</a></td>
<td><a href="/wiki/Microsoft_SQL_Server" title="Microsoft SQL Server">SQL Server</a></td>
<td>2015.07.14</td>
<td>Proprietary software</td>
<td>2015-7-14</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
</tr>
<tr>
<td><a href="/wiki/Censhare" title="Censhare">censhare</a></td>
<td>Java</td>
<td><a href="/wiki/Oracle_Database" title="Oracle Database">Oracle</a></td>
<td>2017.2</td>
<td>Proprietary software</td>
<td>2017-05-12</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
</tr>
<tr>
<td><a href="/wiki/Contentverse" title="Contentverse">Contentverse</a></td>
<td>Java</td>
<td><a href="/wiki/Oracle_Database" title="Oracle Database">Oracle</a>, <a href="/wiki/Microsoft_SQL_Server" title="Microsoft SQL Server">SQL Server</a></td>
<td>8.1</td>
<td>Proprietary software</td>
<td>2014</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
</tr>
<tr>
<td><a href="/wiki/Contegro" title="Contegro">Contegro</a></td>
<td><a href="/wiki/ASP.NET" title="ASP.NET">ASP.NET</a></td>
<td><a href="/wiki/Microsoft_SQL_Server" title="Microsoft SQL Server">SQL Server</a></td>
<td>4.0.0</td>
<td>Proprietary software</td>
<td>2010-17-11</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#F99;vertical-align:middle;text-align:center;" class="table-no">No</td>
</tr>
<tr>
<td><a href="/wiki/CoreMedia_CMS" title="CoreMedia CMS">CoreMedia WCM</a></td>
<td>Java</td>
<td>JDBC-compliant databases</td>
<td>8</td>
<td></td>
<td>2015-03-19</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#F99;vertical-align:middle;text-align:center;" class="table-no">No</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
</tr>
<tr>
<td><a href="/wiki/Doclogix" class="mw-redirect" title="Doclogix">DocLogix</a></td>
<td><a href="/wiki/ASP.NET" title="ASP.NET">ASP.NET</a></td>
<td><a href="/wiki/Microsoft_SQL_Server" title="Microsoft SQL Server">SQL Server</a></td>
<td>10.0.0</td>
<td>Proprietary software</td>
<td>2015-12-15</td>
<td style="background:#F99;vertical-align:middle;text-align:center;" class="table-no">No</td>
<td style="background:#F99;vertical-align:middle;text-align:center;" class="table-no">No</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
</tr>
<tr>
<td><a href="/wiki/DotCMS" title="DotCMS">dotCMS</a></td>
<td>Java</td>
<td><a href="/wiki/Oracle_Database" title="Oracle Database">Oracle</a>, <a href="/wiki/Microsoft_SQL_Server" title="Microsoft SQL Server">SQL Server</a>, <a href="/wiki/MySQL" title="MySQL">MySQL</a>, <a href="/wiki/PostgreSQL" title="PostgreSQL">PostgreSQL</a></td>
<td>4.2.0</td>
<td>Proprietary software</td>
<td>2017-10-17</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
</tr>
<tr>
<td>Evoq based on <a href="/wiki/DotNetNuke" title="DotNetNuke">DotNetNuke</a> platform</td>
<td><a href="/wiki/ASP.NET" title="ASP.NET">ASP.NET</a></td>
<td><a href="/wiki/Microsoft_SQL_Server" title="Microsoft SQL Server">SQL Server</a></td>
<td>9.1</td>
<td>Proprietary software based on open source project</td>
<td>2017-09-05</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
</tr>
<tr>
<td><a href="/wiki/Ektron" class="mw-redirect" title="Ektron">Ektron CMS</a></td>
<td><a href="/wiki/ASP.NET" title="ASP.NET">ASP.NET</a></td>
<td><a href="/wiki/Microsoft_SQL_Server" title="Microsoft SQL Server">SQL Server</a></td>
<td>9.20</td>
<td>Proprietary software</td>
<td>2016-12-09</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
</tr>
<tr>
<td><a href="/wiki/Elcom_CMS" class="mw-redirect" title="Elcom CMS">Elcom CMS</a></td>
<td><a href="/wiki/ASP.NET" title="ASP.NET">ASP.NET</a></td>
<td><a href="/wiki/Microsoft_SQL_Server" title="Microsoft SQL Server">SQL Server</a></td>
<td>9.0</td>
<td>Proprietary software</td>
<td>2011-02-15</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
</tr>
<tr>
<td>OpenText <a href="/wiki/Documentum" title="Documentum">Documentum</a></td>
<td>Java</td>
<td><a href="/wiki/Oracle_Database" title="Oracle Database">Oracle</a>, <a href="/wiki/Microsoft_SQL_Server" title="Microsoft SQL Server">SQL Server</a>, <a href="/wiki/IBM_DB2" class="mw-redirect" title="IBM DB2">DB2</a></td>
<td>7.3</td>
<td>Proprietary software</td>
<td>2016-11-10</td>
<td style="background:#F99;vertical-align:middle;text-align:center;" class="table-no">No</td>
<td style="background:#F99;vertical-align:middle;text-align:center;" class="table-no">No</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
</tr>
<tr>
<td><a href="/wiki/Episerver" title="Episerver">Episerver CMS</a></td>
<td><a href="/wiki/ASP.NET" title="ASP.NET">ASP.NET</a></td>
<td><a href="/wiki/Microsoft_SQL_Server" title="Microsoft SQL Server">SQL Server</a></td>
<td>10</td>
<td>Proprietary software</td>
<td>2017-01-16</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
</tr>
<tr>
<td><a href="/wiki/ExpressionEngine" class="mw-redirect" title="ExpressionEngine">ExpressionEngine</a></td>
<td><a href="/wiki/PHP" title="PHP">PHP</a></td>
<td><a href="/wiki/MySQL" title="MySQL">MySQL</a></td>
<td>3.4.5</td>
<td>Proprietary software</td>
<td>2016-12-06</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#F99;vertical-align:middle;text-align:center;" class="table-no">No</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
</tr>
<tr>
<td><a href="/wiki/Hyland_Software" title="Hyland Software">Hyland</a> OnBase ECM</td>
<td>.NET</td>
<td><a href="/wiki/Microsoft_SQL_Server" title="Microsoft SQL Server">SQL Server</a>, Oracle</td>
<td></td>
<td></td>
<td></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
</tr>
<tr>
<td><a href="/wiki/IBM_Information_Management_Software" title="IBM Information Management Software">IBM Enterprise Content Management</a></td>
<td>Java</td>
<td><a href="/wiki/Oracle_Database" title="Oracle Database">Oracle</a>, <a href="/wiki/IBM_DB2" class="mw-redirect" title="IBM DB2">DB2</a></td>
<td>8.5</td>
<td>Proprietary software</td>
<td>2013</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
</tr>
<tr>
<td>OpenText <a href="/wiki/TeamSite" title="TeamSite">Teamsite</a></td>
<td>Java, .Net, XML, XSLT</td>
<td><a href="/wiki/Oracle_Database" title="Oracle Database">Oracle</a>, <a href="/wiki/Microsoft_SQL_Server" title="Microsoft SQL Server">SQL Server</a>, <a href="/wiki/IBM_DB2" class="mw-redirect" title="IBM DB2">DB2</a>, <a href="/wiki/Mysql" class="mw-redirect" title="Mysql">MySQL</a></td>
<td>16.2</td>
<td>Proprietary software</td>
<td>2017-04</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
</tr>
<tr>
<td><a href="/wiki/Jadu_(company)" title="Jadu (company)">Jadu</a></td>
<td>PHP</td>
<td><a href="/wiki/MySQL" title="MySQL">MySQL</a>, <a href="/wiki/Microsoft_SQL_Server" title="Microsoft SQL Server">SQL Server</a></td>
<td>Continuously Released</td>
<td>Proprietary software</td>
<td></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#F99;vertical-align:middle;text-align:center;" class="table-no">No</td>
</tr>
<tr>
<td><a href="/wiki/Jahia" title="Jahia">Jahia</a> Enterprise Distribution</td>
<td>Java</td>
<td><a href="/wiki/MySQL" title="MySQL">MySQL</a>, <a href="/wiki/Oracle_Database" title="Oracle Database">Oracle</a>, <a href="/wiki/PostgreSQL" title="PostgreSQL">PostgreSQL</a>, <a href="/wiki/Microsoft_SQL_Server" title="Microsoft SQL Server">Microsoft SQL Server</a></td>
<td>6.6.2.3</td>
<td>Proprietary software</td>
<td>2013-12-20</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
</tr>
<tr>
<td><a href="/wiki/Kentico_CMS" title="Kentico CMS">Kentico CMS</a></td>
<td><a href="/wiki/ASP.NET" title="ASP.NET">ASP.NET</a></td>
<td><a href="/wiki/Microsoft_SQL_Server" title="Microsoft SQL Server">SQL Server</a></td>
<td>8.1</td>
<td>Proprietary software</td>
<td>2016-10-30</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
</tr>
<tr>
<td><a href="/wiki/Movable_Type" title="Movable Type">Movable Type</a></td>
<td><a href="/wiki/Perl" title="Perl">Perl</a></td>
<td><a href="/wiki/MySQL" title="MySQL">MySQL</a>, <a href="/wiki/Oracle_Database" title="Oracle Database">Oracle</a>, <a href="/wiki/Microsoft_SQL_Server" title="Microsoft SQL Server">SQL Server</a></td>
<td>6.3.2</td>
<td>Proprietary</td>
<td>2016-09-27</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
</tr>
<tr>
<td><a href="/wiki/NuBuilder" title="NuBuilder">nuBuilder</a></td>
<td><a href="/wiki/PHP" title="PHP">PHP</a>, <a href="/wiki/JavaScript" title="JavaScript">JavaScript</a>, <a href="/wiki/SQL" title="SQL">SQL</a>, <a href="/wiki/AJAX" class="mw-redirect" title="AJAX">AJAX</a>, <a href="/wiki/JQuery" title="JQuery">jQuery</a> and <a href="/wiki/JSON" title="JSON">JSON</a></td>
<td><a href="/wiki/MySQL" title="MySQL">MySQL</a></td>
<td>pro (3, previously the version system was numeric)</td>
<td>Open source</td>
<td>2014-2</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
</tr>
<tr>
<td><a href="/wiki/Xait" title="Xait">Xait</a>Porter (local license)</td>
<td><a href="/wiki/PHP" title="PHP">PHP</a></td>
<td><a href="/wiki/Oracle_Database" title="Oracle Database">Oracle</a></td>
<td>4.9.6</td>
<td>Proprietary software</td>
<td>2013-04</td>
<td style="background:#F99;vertical-align:middle;text-align:center;" class="table-no">No</td>
<td style="background:#F99;vertical-align:middle;text-align:center;" class="table-no">No</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
</tr>
<tr>
<td><a href="/wiki/Oracle_WebCenter" title="Oracle WebCenter">Oracle WebCenter Content</a><br />
(formerly Universal Content Management)</td>
<td>Java</td>
<td>Oracle</td>
<td>11g</td>
<td></td>
<td></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
</tr>
<tr>
<td><a href="/wiki/OU_Campus" title="OU Campus">OU Campus</a></td>
<td>Java</td>
<td><a href="/wiki/MySQL" title="MySQL">MySQL</a>, <a href="/wiki/Microsoft_SQL_Server" title="Microsoft SQL Server">Microsoft SQL Server</a>, SAP Sybase ASE</td>
<td>10.2.4</td>
<td>Proprietary software</td>
<td>2015-06-24</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
</tr>
<tr>
<td><a href="/wiki/Pulse_CMS" title="Pulse CMS">Pulse CMS</a></td>
<td><a href="/wiki/PHP" title="PHP">PHP</a></td>
<td><a href="/wiki/Flat-file_database" class="mw-redirect" title="Flat-file database">Flat-file database</a></td>
<td>4.6.2</td>
<td></td>
<td>2016-12-20</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#F99;vertical-align:middle;text-align:center;" class="table-no">No</td>
<td style="background:#F99;vertical-align:middle;text-align:center;" class="table-no">No</td>
</tr>
<tr>
<td>Microsoft <a href="/wiki/SharePoint" title="SharePoint">SharePoint</a></td>
<td><a href="/wiki/ASP.NET" title="ASP.NET">ASP.NET</a></td>
<td><a href="/wiki/Microsoft_SQL_Server" title="Microsoft SQL Server">SQL Server</a> (2005, 2008 or 2012), SQL Express</td>
<td>6.0</td>
<td>Proprietary, Open API</td>
<td>2016-05-04</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
</tr>
<tr>
<td><a href="/wiki/Sitecore" title="Sitecore">Sitecore</a></td>
<td><a href="/wiki/ASP.NET" title="ASP.NET">ASP.NET</a> (Webforms or MVC)</td>
<td><a href="/wiki/Microsoft_SQL_Server" title="Microsoft SQL Server">SQL Server</a> (2005, 2008, 2012), Oracle</td>
<td>8.2.5</td>
<td>Proprietary software</td>
<td>2017-08-01</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
</tr>
<tr>
<td><a href="/wiki/Sitekit" title="Sitekit">Sitekit CMS</a></td>
<td><a href="/wiki/ASP.NET" title="ASP.NET">ASP.NET</a></td>
<td><a href="/wiki/Microsoft_SQL_Server" title="Microsoft SQL Server">SQL Server</a></td>
<td>9.5</td>
<td>Proprietary software</td>
<td>2012-02-01</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#F99;vertical-align:middle;text-align:center;" class="table-no">No</td>
</tr>
<tr>
<td><a href="/wiki/Telligent_Community" title="Telligent Community">Telligent Community</a></td>
<td><a href="/wiki/ASP.NET" title="ASP.NET">ASP.NET</a></td>
<td><a href="/wiki/Microsoft_SQL_Server" title="Microsoft SQL Server">SQL Server</a></td>
<td>5.0</td>
<td></td>
<td>2009-06-26</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#F99;vertical-align:middle;text-align:center;" class="table-no">No</td>
</tr>
<tr>
<td><a href="/wiki/TerminalFour" title="TerminalFour">TerminalFour</a> (SiteManager)</td>
<td>Java</td>
<td><a href="/wiki/MySQL" title="MySQL">MySQL</a>, <a href="/wiki/Oracle_Database" title="Oracle Database">Oracle</a>, <a href="/wiki/Microsoft_SQL_Server" title="Microsoft SQL Server">SQL Server</a></td>
<td>8.1.9.9</td>
<td><a href="/wiki/Proprietary_software" title="Proprietary software">Proprietary</a></td>
<td>2017-06-24</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
</tr>
<tr>
<td><a href="/wiki/Webnodes_CMS" title="Webnodes CMS">Webnodes CMS</a></td>
<td><a href="/wiki/ASP.NET" title="ASP.NET">ASP.NET</a></td>
<td><a href="/wiki/Microsoft_SQL_Server" title="Microsoft SQL Server">SQL Server 2005+</a>, <a href="/wiki/SQLCE" class="mw-redirect" title="SQLCE">SQLCE</a>, <a href="/wiki/MySQL" title="MySQL">MySQL</a></td>
<td>3.6</td>
<td><a href="/wiki/Proprietary_software" title="Proprietary software">Proprietary</a></td>
<td>2011-06-30</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
</tr>
</table>
