## list of all system sofware tools for mobile app development

<table class="wikitable sortable" style="width:100%;">
<tr>
<th><a href="https://en.wikipedia.org/wiki/Computing_platform" title="Computing platform">Platform</a></th>
<th><a href="https://en.wikipedia.org/wiki/Programming_language" title="Programming language">Programming language</a></th>
<th><a href="https://en.wikipedia.org/wiki/Debuggers" class="mw-redirect" title="Debuggers">Debuggers</a> available</th>
<th><a href="https://en.wikipedia.org/wiki/List_of_emulators" title="List of emulators">Emulator</a> available</th>
<th><a href="https://en.wikipedia.org/wiki/Integrated_development_environment" title="Integrated development environment">Integrated development environment</a> available</th>
<th>Cross-platform deployment</th>
<th>Installer packaging options</th>
<th>Development tool cost</th>
</tr>
<tr>
<th><a href="https://en.wikipedia.orghttps://en.wikipedia.org/wiki/Adobe_AIR" title="Adobe AIR">Adobe AIR</a></th>
<td><a href="https://en.wikipedia.org/wiki/ActionScript" title="ActionScript">ActionScript</a>, <a href="https://en.wikipedia.org/wiki/HTML" title="HTML">HTML</a>, <a href="https://en.wikipedia.org/wiki/CSS" class="mw-redirect" title="CSS">CSS</a>, <a href="https://en.wikipedia.org/wiki/JavaScript" title="JavaScript">JavaScript</a></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td><a href="https://en.wikipedia.org/wiki/Flash_Builder" class="mw-redirect" title="Flash Builder">Flash Builder</a>, <a href="https://en.wikipedia.org/wiki/Flash_Professional" class="mw-redirect" title="Flash Professional">Flash Professional</a>, <a href="https://en.wikipedia.org/wiki/IntelliJ_IDEA" title="IntelliJ IDEA">IntelliJ IDEA</a></td>
<td>Android, iOS (iPhone, iPad, iPod touch), BlackBerry</td>
<td>The native distribution format of each platform</td>
<td><a href="https://en.wikipedia.org/wiki/Flash_Builder" class="mw-redirect" title="Flash Builder">Flash Builder</a>, <a href="https://en.wikipedia.org/wiki/Flash_Professional" class="mw-redirect" title="Flash Professional">Flash Professional</a>, <a href="https://en.wikipedia.org/wiki/IntelliJ_IDEA" title="IntelliJ IDEA">IntelliJ IDEA</a> - commercial licenses available <a rel="nofollow" class="external text" href="http://www.adobe.com/products/air/sdk/">Adobe AIR SDK (command line tool)</a> - Free</td>
</tr>
<tr>
<th><a href="https://en.wikipedia.org/wiki/Qualcomm_Brew" class="mw-redirect" title="Qualcomm Brew">BREW</a></th>
<td><a href="https://en.wikipedia.org/wiki/C_(programming_language)" title="C (programming language)">C</a>; the APIs are provided in C with a C++ style interface</td>
<td>Debugger support for the native ARM target code. Can use Visual Studio to debug the x86 testing code</td>
<td>No Emulator for the target ARM code, has a simulator for the x86 testing code</td>
<td>Visual Studio 6.0, Visual Studio 2003 .NET, Visual Studio 2005</td>
<td>Compile for the specific BREW version available on the handset</td>
<td><a href="https://en.wikipedia.org/wiki/Over-the-air_programming" title="Over-the-air programming">OTA</a></td>
<td>Related dev fees typically needed for Brew App Certification - VeriSign annual fee for becoming a certified developer. Realview ARM compiler for BREW (the free GNU C/C++ is available, but with limited function and support). TRUE BREW testing fee for distributing the application.</td>
</tr>
<tr>
<th><a href="https://en.wikipedia.org/wiki/Firefox_OS" title="Firefox OS">Firefox OS</a></th>
<td><a href="https://en.wikipedia.org/wiki/HTML5" title="HTML5">HTML5</a>, <a href="https://en.wikipedia.org/wiki/CSS" class="mw-redirect" title="CSS">CSS</a>, <a href="https://en.wikipedia.org/wiki/JavaScript" title="JavaScript">JavaScript</a></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td>No, but simulator available.</td>
<td>Firefox browser, <a href="https://en.wikipedia.org/wiki/Firebug_(software)" title="Firebug (software)">Firebug</a></td>
<td>Web browser on other platform</td>
<td><a href="https://en.wikipedia.org/wiki/Firefox_Marketplace" class="mw-redirect" title="Firefox Marketplace">Firefox Marketplace</a>, Web URL</td>
<td>Development requires <a href="https://en.wikipedia.org/wiki/Mozilla_Firefox" class="mw-redirect" title="Mozilla Firefox">Mozilla Firefox</a> and the simulator add-on</td>
</tr>
<tr>
<th><a href="https://en.wikipedia.org/wiki/.NET_Compact_Framework" title=".NET Compact Framework">.NET Compact Framework</a></th>
<td><a href="https://en.wikipedia.org/wiki/C_Sharp_(programming_language)" title="C Sharp (programming language)">C#</a>, <a href="https://en.wikipedia.org/wiki/Visual_Basic_.NET" title="Visual Basic .NET">VB.NET</a>, <a href="https://en.wikipedia.org/wiki/Basic4ppc" title="Basic4ppc">Basic4ppc</a></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td>Free emulator, source code available, also bundled with IDE</td>
<td><a href="https://en.wikipedia.org/wiki/Visual_Studio#Visual_Studio_2008" class="mw-redirect" title="Visual Studio">Visual Studio 2008</a>, 2005, 2003, <a href="https://en.wikipedia.org/wiki/Basic4ppc" title="Basic4ppc">Basic4ppc</a> IDE</td>
<td><a href="https://en.wikipedia.org/wiki/Windows_Mobile" title="Windows Mobile">Windows Mobile</a>, Windows CE, Symbian-based devices via third party tools</td>
<td><a href="https://en.wikipedia.org/wiki/Over-the-air_programming" title="Over-the-air programming">OTA</a> deployment, <a href="https://en.wikipedia.org/wiki/Cabinet_(file_format)" title="Cabinet (file format)">CAB</a> files, ActiveSync</td>
<td>Most tools free, but commercial editions of Visual Studio needed for visual designers</td>
</tr>
<tr>
<th><a href="https://en.wikipedia.orghttps://en.wikipedia.org/wiki/OpenFL" title="OpenFL">OpenFL</a></th>
<td><a href="https://en.wikipedia.org/wiki/Haxe" title="Haxe">Haxe</a> (similar to Actionscript and Java)</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td><a href="https://en.wikipedia.org/wiki/IntelliJ_IDEA" title="IntelliJ IDEA">IntelliJ IDEA</a>, <a href="https://en.wikipedia.org/wiki/FlashDevelop" title="FlashDevelop">FlashDevelop</a></td>
<td>Android, iOS (iPhone, iPad, iPod touch), BlackBerry Playbook, WebOS, HTML5, Flash, Windows (exe), Linux</td>
<td>The native distribution format of each platform</td>
<td>Free</td>
</tr>
<tr>
<th><a href="https://en.wikipedia.org/wiki/Palm_OS" title="Palm OS">Palm OS</a></th>
<td><a href="https://en.wikipedia.org/wiki/C_(programming_language)" title="C (programming language)">C</a>, <a href="https://en.wikipedia.org/wiki/C%2B%2B" title="C++">C++</a>, <a href="https://en.wikipedia.org/wiki/Pascal_(programming_language)" title="Pascal (programming language)">Pascal</a></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td>OS 1.0 - 4.1: free emulator provided by PalmSource (Access); OS 5.0: - 5.4 device-specific simulators provided by Palm (palmOne)</td>
<td>Palm OS Development System (Eclipse), <a href="https://en.wikipedia.org/wiki/CodeWarrior" title="CodeWarrior">CodeWarrior</a>, <a href="https://en.wikipedia.org/wiki/PocketStudio" title="PocketStudio">PocketStudio</a>, HB++, Satellite Forms</td>
<td><a href="https://en.wikipedia.org/wiki/Palm_OS" title="Palm OS">Palm OS</a> handhelds, or Windows Mobile with StyleTap emulator</td>
<td><a href="https://en.wikipedia.org/wiki/PRC_(Palm_OS)" title="PRC (Palm OS)">PRC</a> files, PalmSource Installer (.psi)</td>
<td>Free (POSE or GCC for Palm OS), or commercial (CodeWarrior), or various commercial rapid-development frameworks</td>
</tr>
<tr>
<th><a href="https://en.wikipedia.org/wiki/Python_(programming_language)" title="Python (programming language)">Python</a></th>
<td>Python</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td>Add-on to Nokia Emulator</td>
<td>Several, including plugins for <a href="https://en.wikipedia.org/wiki/Eclipse_(software)" title="Eclipse (software)">Eclipse</a></td>
<td><a href="https://en.wikipedia.org/wiki/Interpreted_language" title="Interpreted language">Interpreted language</a> available natively only on <a href="https://en.wikipedia.orghttps://en.wikipedia.org/wiki/Nokia_Series60" class="mw-redirect" title="Nokia Series60">Nokia Series60</a> (and desktops) though ports exist to other mobile platforms, including Palm OS</td>
<td>Sis deployment with py2sis or can use Python Runtime</td>
<td>Free</td>
</tr>
<tr>
<th><a href="https://en.wikipedia.org/wiki/Symbian" title="Symbian">Symbian</a></th>
<td><a href="https://en.wikipedia.org/wiki/C%2B%2B" title="C++">C++</a></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td>Free emulator</td>
<td><a href="https://en.wikipedia.org/wiki/Symbian" title="Symbian">Many choices</a></td>
<td>Compile per target</td>
<td>SIS deployment</td>
<td>Commercial and free tools available</td>
</tr>
<tr>
<th><a href="https://en.wikipedia.orghttps://en.wikipedia.org/wiki/Tizen" title="Tizen">Tizen</a></th>
<td><i>Web-based</i>: <a href="/wiki/HTML5" title="HTML5">HTML5</a>, <a href="https://en.wikipedia.org/wiki/CSS" class="mw-redirect" title="CSS">CSS</a>, <a href="https://en.wikipedia.org/wiki/JavaScript" title="JavaScript">JavaScript</a> <i>Native</i>: <a href="https://en.wikipedia.org/wiki/C_(programming_language)" title="C (programming language)">C</a>, <a href="https://en.wikipedia.org/wiki/C%2B%2B" title="C++">C++</a></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td>Free emulator</td>
<td>Tizen SDK</td>
<td>Web-based app to be available on web browser</td>
<td>Tizen through App store, Web URL</td>
<td>Development needs Windows, OS X, or Ubuntu Desktop</td>
</tr>
<tr>
<th><a href="https://en.wikipedia.org/wiki/Ubuntu_Touch" title="Ubuntu Touch">Ubuntu Touch</a></th>
<td><i>Web-based</i>: <a href="https://en.wikipedia.org/wiki/HTML5" title="HTML5">HTML5</a>, <a href="https://en.wikipedia.orghttps://en.wikipedia.org/wiki/CSS" class="mw-redirect" title="CSS">CSS</a>, <a href="https://en.wikipedia.org/wiki/JavaScript" title="JavaScript">JavaScript</a> <i>Native</i>: <a href="https://en.wikipedia.org/wiki/QML" title="QML">QML</a>, <a href="https://en.wikipedia.org/wiki/C_(programming_language)" title="C (programming language)">C</a>, <a href="https://en.wikipedia.org/wiki/C%2B%2B" title="C++">C++</a></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td>Ubuntu SDK</td>
<td>HTML5 app to be available web browser.</td>
<td>Ubuntu Touch through App store, Web URL</td>
<td>Development requires Ubuntu Desktop 12.04 or higher, Free</td>
</tr>
<tr>
<th><a href="https://en.wikipedia.org/wiki/WebOS" title="WebOS">webOS</a></th>
<td><a href="https://en.wikipedia.org/wiki/JavaScript" title="JavaScript">JavaScript</a>, <a href="https://en.wikipedia.org/wiki/CSS" class="mw-redirect" title="CSS">CSS</a>, <a href="https://en.wikipedia.org/wiki/HTML" title="HTML">HTML</a>, <a href="https://en.wikipedia.org/wiki/C_(programming_language)" title="C (programming language)">C</a> and <a href="https://en.wikipedia.org/wiki/C%2B%2B" title="C++">C++</a> through the PDK</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td>Free emulator</td>
<td><a href="https://en.wikipedia.org/wiki/Eclipse_(software)" title="Eclipse (software)">Eclipse</a></td>
<td>webOS, Palm only</td>
<td><a href="https://en.wikipedia.org/wiki/Over-the-air_programming" title="Over-the-air programming">OTA</a> deployment, webOS through App store, Web URL, Precentral, .ipk</td>
<td>Free</td>
</tr>
<tr>
<th><a href="https://en.wikipedia.org/wiki/Windows_Mobile" title="Windows Mobile">Windows Mobile</a></th>
<td><a href="https://en.wikipedia.org/wiki/C_(programming_language)" title="C (programming language)">C</a>, <a href="https://en.wikipedia.org/wiki/C%2B%2B" title="C++">C++</a></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td>Free emulator (source code available), also bundled with IDE</td>
<td><a href="https://en.wikipedia.org/wiki/Visual_Studio#Visual_Studio_2008" class="mw-redirect" title="Visual Studio">Visual Studio 2010</a>, 2008, 2005, eMbedded VC++ (free), Satellite Forms</td>
<td><a href="https://en.wikipedia.org/wiki/Windows_Mobile" title="Windows Mobile">Windows Mobile</a>, Windows CE</td>
<td><a href="https://en.wikipedia.org/wiki/Over-the-air_programming" title="Over-the-air programming">OTA</a> deployment, CAB files, ActiveSync</td>
<td>Free command-line tools or eMbedded VC++, or Visual Studio (Standard edition or better)</td>
</tr>
<tr>
<th><a href="https://en.wikipedia.org/wiki/Windows_Phone" title="Windows Phone">Windows Phone</a></th>
<td><a href="https://en.wikipedia.org/wiki/C_Sharp_(programming_language)" title="C Sharp (programming language)">C#</a>, <a href="https://en.wikipedia.org/wiki/Visual_Basic" title="Visual Basic">Visual Basic</a>, <a href="https://en.wikipedia.org/wiki/C_(programming_language)" title="C (programming language)">C</a>, <a href="https://en.wikipedia.org/wiki/C%2B%2B" title="C++">C++</a></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td>Free emulator, also bundled with IDE</td>
<td><a href="https://en.wikipedia.org/wiki/Visual_Studio_2012" class="mw-redirect" title="Visual Studio 2012">Visual Studio 2012</a>, <a href="https://en.wikipedia.org/wiki/Visual_Studio_2010" class="mw-redirect" title="Visual Studio 2010">Visual Studio 2010</a></td>
<td><a href="https://en.wikipedia.org/wiki/Windows_Phone" title="Windows Phone">Windows Phone</a></td>
<td><a href="https://en.wikipedia.org/wiki/Over-the-air_programming" title="Over-the-air programming">OTA</a> deployment, <a href="https://en.wikipedia.org/wiki/XAP_(file_format)" title="XAP (file format)">XAP</a> files</td>
<td></td>
</tr>
</table>
