## list of front-end platforms and tools for mobile app development


<table class="wikitable sortable" style="width:100%;">
<tr>
<th><a href="https://en.wikipedia.org/wiki/Computing_platform" title="Computing platform">Platform</a></th>
<th><a href="https://en.wikipedia.org/wiki/Programming_language" title="Programming language">Programming language</a></th>
<th><a href="https://en.wikipedia.org/wiki/Debuggers" class="mw-redirect" title="Debuggers">Debuggers</a> available</th>
<th><a href="https://en.wikipedia.org/wiki/List_of_emulators" title="List of emulators">Emulator</a> available</th>
<th><a href="https://en.wikipedia.org/wiki/Integrated_development_environment" title="Integrated development environment">Integrated development environment</a> available</th>
<th>Cross-platform deployment</th>
<th>Installer packaging options</th>
<th>Development tool cost</th>
</tr>
<tr>
<th><a href="https://en.wikipedia.org/wiki/Accelerator_(software)" title="Accelerator (software)">Accelerator</a></th>
<td><a href="https://en.wikipedia.org/wiki/HTML5" title="HTML5">HTML5</a>, <a href="https://en.wikipedia.org/wiki/C_Sharp_(programming_language)" title="C Sharp (programming language)">C#</a></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td><a href="https://en.wikipedia.org/wiki/Microsoft_Visual_Studio" title="Microsoft Visual Studio">Microsoft Visual Studio</a><br />
(no lock-in)</td>
<td>All platforms, mobile apps are browser-based</td>
<td><a href="https://en.wikipedia.org/wiki/Mobile_Web" title="Mobile Web">Mobile Web</a></td>
<td>Commercial licenses available</td>
</tr>
<tr>
<th><a href="https://en.wikipedia.org/wiki/Altova" title="Altova">Altova</a> MobileTogether</th>
<td>Visual programming to design the user interface and functional programming using the standardized XQuery/XPath</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes, integrated simulation tool</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td><a href="https://en.wikipedia.org/wiki/Windows_(operating_system)" class="mw-redirect" title="Windows (operating system)">Windows</a>-based MobileTogether Designer</td>
<td><a href="https://en.wikipedia.org/wiki/Android_(operating_system)" title="Android (operating system)">Android</a>, <a href="https://en.wikipedia.org/wiki/IOS" title="IOS">iOS</a>, <a href="https://en.wikipedia.org/wiki/Windows_8" title="Windows 8">Windows 8</a>, <a href="/wiki/Windows_Phone_8" title="Windows Phone 8">Windows Phone 8</a>, <a href="https://en.wikipedia.org/wiki/HTML5" title="HTML5">HTML5</a> browser-based client</td>
<td>The native distribution format of each platform</td>
<td>Free (30-day trial)</td>
</tr>
<tr>
<th><a href="https://en.wikipedia.org/wiki/Android_(operating_system)" title="Android (operating system)">Android</a></th>
<td><a href="https://en.wikipedia.org/wiki/Java_(programming_language)" title="Java (programming language)">Java</a> but portions of code can be in <a href="https://en.wikipedia.org/wiki/C_(programming_language)" title="C (programming language)">C</a>, <a href="https://en.wikipedia.org/wiki/C%2B%2B" title="C++">C++</a>,
<p><a href="/wiki/Kotlin_(programming_language)" title="Kotlin (programming language)">Kotlin</a></p>
</td>
<td>Debugger integrated in Eclipse, standalone debugging monitor available</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td><a href="https://en.wikipedia.org/wiki/Eclipse_(software)" title="Eclipse (software)">Eclipse</a>, <a href="https://en.wikipedia.org/wiki/IntelliJ_IDEA" title="IntelliJ IDEA">IntelliJ IDEA</a>, <a href="https://en.wikipedia.org/wiki/Android_Studio" title="Android Studio">Android Studio</a>, Project Kenai Android plugin for NetBeans</td>
<td>Android only, because of Dalvik VM, March 2009</td>
<td>apk</td>
<td>Free, <a href="https://en.wikipedia.org/wiki/IntelliJ_IDEA" title="IntelliJ IDEA">IntelliJ IDEA</a> Community Edition - Free</td>
</tr>
<tr>
<th><a href="https://en.wikipedia.org/wiki/App_Inventor_for_Android" title="App Inventor for Android">App Inventor for Android</a></th>
<td>Visual blocks-based programming language, with Interface designer</td>
<td>Limited debugging tools built into <a href="https://en.wikipedia.org/wiki/Integrated_development_environment" title="Integrated development environment">IDE</a></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td>Web-based interface designer, with connection to Java web-start program for blocks programming</td>
<td>Android devices</td>
<td>apk</td>
<td>Free</td>
</tr>
<tr>
<th>App Press</th>
<td>HTML, CSS, JavaScript</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td>Web-based interface designer, with a companion mobile app for preview</td>
<td>Android, iOS</td>
<td>The native distribution format of each platform</td>
<td>Free to try, commercial and enterprise plans available</td>
</tr>
<tr>
<th>Appception</th>
<td><a href="https://en.wikipedia.org/wiki/HTML" title="HTML">HTML</a>, <a href="https://en.wikipedia.org/wiki/CSS" class="mw-redirect" title="CSS">CSS</a>, <a href="https://en.wikipedia.org/wiki/JavaScript" title="JavaScript">JavaScript</a></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td>Cloud-based <a href="https://en.wikipedia.org/wiki/Integrated_development_environment" title="Integrated development environment">IDE</a></td>
<td>Android, iOS</td>
<td>The native distribution format of each platform</td>
<td>Free and commercial licenses available</td>
</tr>
<tr>
<th><a href="https://en.wikipedia.org/wiki/Appcelerator" title="Appcelerator">Appcelerator</a></th>
<td><a href="https://en.wikipedia.org/wiki/JavaScript" title="JavaScript">JavaScript</a></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes, in Titanium Studio.</td>
<td>Emulator is available using native emulators</td>
<td>Titanium Studio based on Eclipse</td>
<td>Android, iPhone; BlackBerry, Tizen, mobile web</td>
<td>The native distribution format of each platform</td>
<td>Free, open-sourced Apache 2.0 licensed, commercial and enterprise licenses available</td>
</tr>
<tr>
<th>AppGyver Composer</th>
<td>No coding required, extendable with <a href="https://en.wikipedia.org/wiki/HTML" title="HTML">HTML</a>, <a href="https://en.wikipedia.org/wiki/JavaScript" title="JavaScript">JavaScript</a>, <a href="https://en.wikipedia.org/wiki/CSS" class="mw-redirect" title="CSS">CSS</a></td>
<td>On device debugging</td>
<td>Live testing on device</td>
<td>No coding required, visual app development environment</td>
<td>Android, iOS, web</td>
<td>Cloud / browser-based</td>
<td>Free to develop and distribute, commercial and enterprise licenses available.</td>
</tr>
<tr>
<th><a href="/w/index.php?title=Appear_IQ&amp;action=edit&amp;redlink=1" class="new" title="Appear IQ (page does not exist)">Appear IQ</a></th>
<td>Mobile Web Apps (<a href="https://en.wikipedia.org/wiki/HTML5" title="HTML5">HTML5</a>, <a href="https://en.wikipedia.org/wiki/CSS3" class="mw-redirect" title="CSS3">CSS3</a>, <a href="https://en.wikipedia.org/wiki/JavaScript" title="JavaScript">JavaScript</a>), Native Apps <a href="https://en.wikipedia.org/wiki/Java_(programming_language)" title="Java (programming language)">Java</a>, <a href="https://en.wikipedia.org/wiki/Objective-C" title="Objective-C">Objective-C</a>, <a href="https://en.wikipedia.org/wiki/C_Sharp_(programming_language)" title="C Sharp (programming language)">C#.NET</a>/<a href="https://en.wikipedia.org/wiki/VB.NET" class="mw-redirect" title="VB.NET">VB.NET</a> for Windows Phone</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td>Mobile simulator available</td>
<td>Any <a href="https://en.wikipedia.org/wiki/Integrated_development_environment" title="Integrated development environment">IDE</a></td>
<td>Android, iOS, Windows, Windows Phone</td>
<td>The native distribution format of each platform</td>
<td>Free to try, commercial and enterprise licenses available</td>
</tr>
<tr>
<th>Appery.io</th>
<td><a href="https://en.wikipedia.org/wiki/HTML" title="HTML">HTML</a>, <a href="https://en.wikipedia.org/wiki/JavaScript" title="JavaScript">JavaScript</a>, <a href="https://en.wikipedia.org/wiki/CSS" class="mw-redirect" title="CSS">CSS</a>, <a href="https://en.wikipedia.org/wiki/JQueryMobile" class="mw-redirect" title="JQueryMobile">jQueryMobile</a>, <a href="https://en.wikipedia.org/wiki/Apache_Cordova" title="Apache Cordova">Apache Cordova</a></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes. Using browser debug tooling</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes. Native test apps for Android, iOS. Can export source as <a href="https://en.wikipedia.org/wiki/Android_Studio" title="Android Studio">Android Studio</a> or <a href="https://en.wikipedia.org/wiki/XCode" class="mw-redirect" title="XCode">XCode</a> projects.</td>
<td>Cloud-based development platform</td>
<td><a href="https://en.wikipedia.org/wiki/Android_(operating_system)" title="Android (operating system)">Android</a>, <a href="https://en.wikipedia.org/wiki/IOS" title="IOS">iOS</a>, mobile web</td>
<td>The native distribution format of each platform</td>
<td>Free to try, commercial and enterprise licenses available</td>
</tr>
<tr>
<th>AppSheet</th>
<td>No coding needed; data via spreadsheets</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes, via application editor</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes.</td>
<td>No coding needed; visual app definition with spreadsheet data</td>
<td>Android, iOS, web</td>
<td>The native distribution format of each platform and also cloud-browser-based</td>
<td>Free, up to 10 app users; commercial licenses available</td>
</tr>
<tr>
<th>Aquro</th>
<td><a href="https://en.wikipedia.org/wiki/HTML5" title="HTML5">HTML5</a>, <a href="https://en.wikipedia.org/wiki/CSS3" class="mw-redirect" title="CSS3">CSS3</a>, <a href="https://en.wikipedia.org/wiki/JavaScript" title="JavaScript">JavaScript</a>, Visual Coding</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes browser-based and native test app for Android, iOS</td>
<td>Cloud-based development platform</td>
<td>Android, iOS</td>
<td>The native distribution format of each platform</td>
<td>Free to try, commercial and enterprise plans available</td>
</tr>
<tr>
<th><a href="https://en.wikipedia.orghttps://en.wikipedia.org/wiki/Basic4android" title="Basic4android">Basic4android</a></th>
<td><a href="https://en.wikipedia.org/wiki/Visual_Basic" title="Visual Basic">Visual Basic</a> similar syntax</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td>Emulator is available using native emulators</td>
<td>Proprietary IDE</td>
<td>Android</td>
<td>The native distribution format of each platform</td>
<td>Commercial licenses available</td>
</tr>
<tr>
<th><a href="https://en.wikipedia.orghttps://en.wikipedia.org/wiki/BlackBerry" title="BlackBerry">BlackBerry</a></th>
<td><a href="https://en.wikipedia.org/wiki/Java_(programming_language)" title="Java (programming language)">Java</a></td>
<td>Debugger integrated in IDE</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td><a href="https://en.wikipedia.org/wiki/Eclipse_(software)" title="Eclipse (software)">Eclipse</a>, BlackBerry JDE</td>
<td>BlackBerry only, because of RIM API</td>
<td>alx, cod</td>
<td>Free</td>
</tr>
<tr>
<th><a href="https://en.wikipedia.org/wiki/Codename_One" title="Codename One">Codename One</a></th>
<td><a href="https://en.wikipedia.org/wiki/Java_(programming_language)" title="Java (programming language)">Java</a></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td>Eclipse, Netbeans</td>
<td>Android, iPhone, BlackBerry, Windows Mobile, J2ME</td>
<td>The native distribution format of each platform</td>
<td>Open Source GPLv2 and subscription-based build server</td>
</tr>
<tr>
<th>Configure.IT</th>
<td>Needs no text coding or SDK, browser-based drag-and-drop interface.</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td>PreviewIT app for real-time preview on device</td>
<td>Browser-based</td>
<td>Android, iOS</td>
<td>Native distribution format for each platform</td>
<td>Monthly subscription-based packages</td>
</tr>
<tr>
<th><a href="https://en.wikipedia.org/wiki/Corona_SDK" class="mw-redirect" title="Corona SDK">Corona SDK</a></th>
<td><a href="https://en.wikipedia.org/wiki/Lua_(programming_language)" title="Lua (programming language)">Lua</a></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td><a href="https://en.wikipedia.org/wiki/Xcode" title="Xcode">Xcode</a></td>
<td>Android, iOS, <a href="https://en.wikipedia.org/wiki/Nook_Color" title="Nook Color">Nook Color</a></td>
<td>Native deployment for each platform</td>
<td>Free unlimited trial; commercial licenses available for deployment</td>
</tr>
<tr>
<th><a href="https://en.wikipedia.org/wiki/DragonRAD" title="DragonRAD">DragonRAD</a></th>
<td>Visual drag &amp; drop tiles</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td>Uses third-party emulators</td>
<td>Proprietary IDE</td>
<td>Android, BlackBerry, Windows Mobile</td>
<td><a href="https://en.wikipedia.org/wiki/Over-the-air_programming" title="Over-the-air programming">OTA deployment</a></td>
<td>Free &amp; commercial licenses available</td>
</tr>
<tr>
<th>DSI - Data Systems International, Inc.</th>
<td>DSI Application Studio - flowchart-based tool designed for business analysts to build and deploy mobile apps</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td>Proprietary IDE - graphical drag and drop design studio</td>
<td>Android 2.0+, iOS 4+, Windows Mobile 6+, Blackberry 4.5+, Windows Desktop 7+</td>
<td>The native distribution format of each platform</td>
<td>Commercial licenses available</td>
</tr>
<tr>
<th><a href="https://en.wikipedia.org/wiki/GeneXus" title="GeneXus">GeneXus</a> for Mobile and Smart Devices</th>
<td><a href="https://en.wikipedia.org/wiki/Knowledge_representation" class="mw-redirect" title="Knowledge representation">Knowledge representation</a> and <a href="https://en.wikipedia.org/wiki/Declarative_programming" title="Declarative programming">declarative programming</a>-modeling for easy development, then code is automatically generated for each platform</td>
<td>GeneXus utilizes pre-tested code libraries and user debugging of code not necessary after code generation.</td>
<td>Publish in the cloud, test native in the device, no emulator needed</td>
<td>Proprietary IDE</td>
<td><a href="https://en.wikipedia.org/wiki/Android_(operating_system)" title="Android (operating system)">Android</a>, <a href="https://en.wikipedia.org/wiki/IOS" title="IOS">iOS</a> (iPhone, iPad), <a href="https://en.wikipedia.org/wiki/BlackBerry_OS" title="BlackBerry OS">BlackBerry OS</a>, and even <a href="/wiki/HTML5" title="HTML5">HTML5</a> if needed</td>
<td>The native distribution format of each platform and also cloud-browser-based</td>
<td>Free to try, commercial and enterprise licenses available</td>
</tr>
<tr>
<th>GO!AppZone by <a href="https://en.wikipedia.org/wiki/Globo_plc" title="Globo plc">Globo plc</a></th>
<td><a href="https://en.wikipedia.org/wiki/HTML5" title="HTML5">HTML5</a>, <a href="https://en.wikipedia.org/wiki/CSS3" class="mw-redirect" title="CSS3">CSS3</a>, <a href="https://en.wikipedia.org/wiki/JavaScript" title="JavaScript">JavaScript</a>. Native-code plugins in <a href="https://en.wikipedia.org/wiki/Objective-C" title="Objective-C">Objective-C</a>, <a href="https://en.wikipedia.org/wiki/Java_(programming_language)" title="Java (programming language)">Java</a>, C#</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes IDE includes an HTML-based simulator with embedded debugging tools</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes native testing app for <a href="https://en.wikipedia.org/wiki/Android_(operating_system)" title="Android (operating system)">Android</a>, <a href="https://en.wikipedia.org/wiki/BlackBerry" title="BlackBerry">BlackBerry</a>, <a href="https://en.wikipedia.org/wiki/IOS" title="IOS">iOS</a>, and <a href="https://en.wikipedia.org/wiki/Windows_RT" title="Windows RT">Windows Phone, 8.x, RT</a></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes GO!AppZone Studio</td>
<td>Android, BlackBerry, iOS, Windows: Phone, 8.x, RT</td>
<td>The native distribution format of each platform</td>
<td>Free; free cloud-based compiling; free MBaaS instance for testing</td>
</tr>
<tr>
<th>HP Anywhere</th>
<td><a href="https://en.wikipedia.org/wiki/HTML5" title="HTML5">HTML5</a>, <a href="https://en.wikipedia.org/wiki/CSS3" class="mw-redirect" title="CSS3">CSS3</a>, <a href="https://en.wikipedia.org/wiki/JavaScript" title="JavaScript">JavaScript</a></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes, Mobile Browser Simulator</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes, use browser-based emulator</td>
<td><a href="https://en.wikipedia.org/wiki/Eclipse_(software)" title="Eclipse (software)">Eclipse</a> plugin, Eclipse-based stand-alone, <a href="https://en.wikipedia.org/wiki/IntelliJ_IDEA" title="IntelliJ IDEA">IntelliJ IDEA</a> plugin, any IDE using <a href="https://en.wikipedia.org/wiki/Command-line_interface" title="Command-line interface">command-line interface</a></td>
<td><a href="https://en.wikipedia.org/wiki/Android_(operating_system)" title="Android (operating system)">Android</a>, <a href="https://en.wikipedia.org/wiki/IOS" title="IOS">iOS</a>, <a href="https://en.wikipedia.org/wiki/Windows_8" title="Windows 8">Windows 8</a> (desktop, tablets), mobile web app, desktop browser web page</td>
<td>The native distribution format of each platform</td>
<td>Developer edition free, commercial license for deployment</td>
</tr>
<tr>
<th><a href="https://en.wikipedia.org/wiki/IBM_MobileFirst" class="mw-redirect" title="IBM MobileFirst">IBM MobileFirst</a> Studio</th>
<td><a href="https://en.wikipedia.org/wiki/HTML5" title="HTML5">HTML5</a>, <a href="https://en.wikipedia.org/wiki/CSS3" class="mw-redirect" title="CSS3">CSS3</a>, <a href="https://en.wikipedia.org/wiki/JavaScript" title="JavaScript">JavaScript</a>, and native SDK languages w/ Native Worklight API</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes, Mobile Browser Simulator or integration with Native SDK Debugger</td>
<td>Emulator is available using native emulators or Browser Simulator w/ Cordova Plugin</td>
<td><a href="https://en.wikipedia.org/wiki/Eclipse_(software)" title="Eclipse (software)">Eclipse</a> plugin, Eclipse-based stand-alone</td>
<td><a href="https://en.wikipedia.org/wiki/Android_(operating_system)" title="Android (operating system)">Android</a>, <a href="https://en.wikipedia.org/wiki/IOS" title="IOS">iOS</a>, <a href="https://en.wikipedia.org/wiki/BlackBerry" title="BlackBerry">BlackBerry</a> 6,7, &amp; 10, <a href="https://en.wikipedia.org/wiki/Windows_Phone" title="Windows Phone">Windows Phone</a> 7.5 &amp; 8, <a href="https://en.wikipedia.org/wiki/Windows_8" title="Windows 8">Windows 8</a> (desktop, tablets), <a href="https://en.wikipedia.org/wiki/Adobe_AIR" title="Adobe AIR">Adobe AIR</a>, Mobile Web App, desktop browser web page</td>
<td>The native distribution format of each platform</td>
<td>Developer edition free via Eclipse Marketplace, commercial license for deployment</td>
</tr>
<tr>
<th><a href="https://en.wikipedia.org/wiki/Intel_XDK" title="Intel XDK">Intel XDK</a></th>
<td><a href="https://en.wikipedia.org/wiki/HTML5" title="HTML5">HTML5</a>, <a href="https://en.wikipedia.org/wiki/CSS3" class="mw-redirect" title="CSS3">CSS3</a>, <a href="https://en.wikipedia.org/wiki/JavaScript" title="JavaScript">JavaScript</a> and Node-Webkit back-end</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td>Stand-alone, bundled with IDE</td>
<td><a href="https://en.wikipedia.org/wiki/Android_(operating_system)" title="Android (operating system)">Android</a>, <a href="https://en.wikipedia.org/wiki/IOS" title="IOS">iOS</a>, <a href="https://en.wikipedia.org/wiki/Windows_8" title="Windows 8">Windows 8</a>, Amazon, Facebook, Chrome, Nook, Firefox Marketplace, Tizen</td>
<td>The native distribution format of each platform</td>
<td>Free</td>
</tr>
<tr>
<th><a href="https://en.wikipedia.org/wiki/IOS_SDK" title="IOS SDK">iOS SDK</a></th>
<td><a href="https://en.wikipedia.org/wiki/Objective-C" title="Objective-C">Objective-C</a>, <a href="https://en.wikipedia.org/wiki/Swift_(programming_language)" title="Swift (programming language)">Swift</a></td>
<td>Debugger integrated in Xcode IDE</td>
<td>Bundled with iPhone SDK, integrated with Xcode IDE</td>
<td><a href="https://en.wikipedia.org/wiki/Xcode" title="Xcode">Xcode</a>, <a href="https://en.wikipedia.org/wiki/AppCode" title="AppCode">AppCode</a></td>
<td><a href="https://en.wikipedia.org/wiki/IPhone" title="IPhone">iPhone</a>, <a href="https://en.wikipedia.org/wiki/IPad" title="IPad">iPad</a>, <a href="https://en.wikipedia.org/wiki/IPod_Touch" title="IPod Touch">iPod Touch</a></td>
<td>Only via <a href="https://en.wikipedia.org/wiki/App_Store_(iOS)" title="App Store (iOS)">App Store</a>, needs review and approval by <a href="https://en.wikipedia.org/wiki/Apple_Inc." title="Apple Inc.">Apple Inc.</a></td>
<td>Apple tools are free for an <a href="https://en.wikipedia.org/wiki/Intel" title="Intel">Intel</a>-based <a href="https://en.wikipedia.org/wiki/Macintosh" title="Macintosh">Mac</a>. Simulator testing is free, but installing on a device needs a fee for a developer signing key. AppCode - commercial licenses available.
<p>Since 2015, Apple allows to install the app in your own device without a developer paid membership.</p>
</td>
</tr>
<tr>
<th><a href="https://en.wikipedia.org/wiki/IOS_SDK" title="IOS SDK">iOS SDK</a></th>
<td><a href="https://en.wikipedia.org/wiki/Object_Pascal" title="Object Pascal">Object Pascal</a></td>
<td>Debugger integrated in Xcode IDE</td>
<td>Included in Delphi XE2 professional or higher</td>
<td><a href="https://en.wikipedia.org/wiki/Delphi_(programming_language)" title="Delphi (programming language)">Embarcadero Delphi XE2</a></td>
<td><a href="https://en.wikipedia.org/wiki/IPhone" title="IPhone">iPhone</a>, <a href="https://en.wikipedia.org/wiki/IPad" title="IPad">iPad</a>, <a href="https://en.wikipedia.org/wiki/IPod_Touch" title="IPod Touch">iPod Touch</a></td>
<td>Only via <a href="https://en.wikipedia.org/wiki/App_Store_(iOS)" title="App Store (iOS)">App Store</a>, needs review and approval by <a href="https://en.wikipedia.org/wiki/Apple_Inc." title="Apple Inc.">Apple Inc.</a></td>
<td>Development requires <a href="https://en.wikipedia.org/wiki/Intel" title="Intel">Intel</a>-based <a href="https://en.wikipedia.org/wiki/Macintosh" title="Macintosh">Mac</a> besides the IDE on Windows. Design is on Windows, Compiling and deploying must be done on Mac. Simulator testing is free, but installing on a device needs a fee for a developer signing key</td>
</tr>
<tr>
<th><a href="https://en.wikipedia.org/wiki/Java_ME" class="mw-redirect" title="Java ME">Java ME</a></th>
<td><a href="https://en.wikipedia.org/wiki/Java_(programming_language)" title="Java (programming language)">Java</a></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td>Free emulator, Sun Java Wireless Toolkit, <a href="https://en.wikipedia.org/wiki/Mpowerplayer" title="Mpowerplayer">mpowerplayer</a></td>
<td><a href="https://en.wikipedia.org/wiki/Eclipse_(software)" title="Eclipse (software)">Eclipse</a>, LMA <a href="https://en.wikipedia.org/wiki/NetBeans" title="NetBeans">NetBeans</a> Mobility Pack</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes although many VM implementations have device specific bugs necessitating separate builds</td>
<td><a href="https://en.wikipedia.org/wiki/JAD_(file_format)" title="JAD (file format)">Jad</a>/<a href="https://en.wikipedia.org/wiki/JAR_(file_format)" title="JAR (file format)">Jar</a> packaging; PRC files under Palm OS</td>
<td>Free</td>
</tr>
<tr>
<th>Kalipso Studio</th>
<td>WYSIWYG, visual drag-n-drop</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td>Proprietary IDE</td>
<td>Android, Microsoft Windows (Mobile, CE, 8 Pro, 10)</td>
<td>The native distribution format of the platform</td>
<td>Free to try, commercial and enterprise licenses available on request</td>
</tr>
<tr>
<th><a href="https://en.wikipedia.org/wiki/Lazarus_(software)" class="mw-redirect" title="Lazarus (software)">Lazarus</a></th>
<td><a href="https://en.wikipedia.org/wiki/Object_Pascal" title="Object Pascal">Object Pascal</a></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes, can debug in IDE via ActiveSync for Windows CE</td>
<td>Uses the emulators of the platforms</td>
<td><a href="https://en.wikipedia.org/wiki/Lazarus_(software)" class="mw-redirect" title="Lazarus (software)">Lazarus IDE</a>, including integrated GUI designer and debugger</td>
<td><a href="https://en.wikipedia.org/wiki/Compiled_language" title="Compiled language">Compiled language</a> available for <a href="https://en.wikipedia.org/wiki/Windows_CE" class="mw-redirect" title="Windows CE">Windows CE</a>, Linux-based devices, <a href="https://en.wikipedia.org/wiki/Symbian" title="Symbian">Symbian</a> port in development</td>
<td>The native distribution format of each platform</td>
<td>Free</td>
</tr>
<tr>
<th><a href="https://en.wikipedia.org/wiki/LambdaNative" title="LambdaNative">LambdaNative</a></th>
<td><a href="https://en.wikipedia.org/wiki/Scheme_(programming_language)" title="Scheme (programming language)">Scheme</a></td>
<td style="background:#F99;vertical-align:middle;text-align:center;" class="table-no">No</td>
<td style="background:#F99;vertical-align:middle;text-align:center;" class="table-no">No but can build and test on the localhost</td>
<td><a href="https://en.wikipedia.org/wiki/Eclipse_(software)" title="Eclipse (software)">Eclipse (software)</a> (optional)</td>
<td>All native binaries: <a href="https://en.wikipedia.org/wiki/Android_(operating_system)" title="Android (operating system)">Android</a>, <a href="https://en.wikipedia.org/wiki/IOS" title="IOS">iOS</a>, <a href="https://en.wikipedia.org/wiki/BlackBerry_10" title="BlackBerry 10">BlackBerry 10</a>, <a href="https://en.wikipedia.org/wiki/Microsoft_Windows" title="Microsoft Windows">Windows</a>, <a href="https://en.wikipedia.org/wiki/OS_X" class="mw-redirect" title="OS X">OS X</a>, <a href="https://en.wikipedia.org/wiki/Linux" title="Linux">Linux</a>, <a href="https://en.wikipedia.org/wiki/OpenBSD" title="OpenBSD">OpenBSD</a>, <a href="https://en.wikipedia.org/wiki/OpenWrt" title="OpenWrt">OpenWrt</a></td>
<td>The native distribution format of each platform</td>
<td>Free (<a href="https://en.wikipedia.org/wiki/BSD_licenses" title="BSD licenses">BSD license</a>)</td>
</tr>
<tr>
<th>LiveCode</th>
<td>LiveCode</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes (integrated into IDE)</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes (iOS and Android emulators may be used)</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td>iOS, Android, macOS, Windows, Linux, server, HTML5. Installer packaging</td>
<td>The native distribution format of each platform</td>
<td>free open-source edition, commercial and enterprise editions available</td>
</tr>
<tr>
<th>M2Active by Service2Media</th>
<td><a href="https://en.wikipedia.org/wiki/Lua_(programming_language)" title="Lua (programming language)">Lua</a> Java language originally from gaming industry</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes, in M2Active IDE</td>
<td>Native emulator are available</td>
<td>M2Active based on Eclipse</td>
<td>Android (phone, tablet), iOS (iPhone, iPad), BlackBerry, Windows Phone, J2ME,</td>
<td>The native distribution format of each platform</td>
<td>Enterprise licenses available</td>
</tr>
<tr>
<th><a href="https://en.wikipedia.org/wiki/Macromedia_Flash_Lite" class="mw-redirect" title="Macromedia Flash Lite">Macromedia Flash Lite</a></th>
<td><a href="https://en.wikipedia.org/wiki/ActionScript" title="ActionScript">ActionScript</a></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td>Bundled with IDE</td>
<td><a href="https://en.wikipedia.org/wiki/Macromedia_Flash" class="mw-redirect" title="Macromedia Flash">Macromedia Flash</a> MX2004/8, Eclipse</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td>SIS-CAB deployment or <a href="https://en.wikipedia.org/wiki/Over-the-air_programming" title="Over-the-air programming">OTA</a>-IR-Bluetooth SWF files</td>
<td>Varies, free but limited with <a href="https://en.wikipedia.org/wiki/MTASC" title="MTASC">MTASC</a></td>
</tr>
<tr>
<th><a href="https://en.wikipedia.org/wiki/Marmalade_(SDK)" class="mw-redirect" title="Marmalade (SDK)">Marmalade</a></th>
<td><a href="https://en.wikipedia.org/wiki/C_(programming_language)" title="C (programming language)">C</a>, <a href="https://en.wikipedia.org/wiki/C%2B%2B" title="C++">C++</a></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td><a href="https://en.wikipedia.org/wiki/Visual_Studio" class="mw-redirect" title="Visual Studio">Visual Studio</a>, <a href="https://en.wikipedia.org/wiki/Xcode" title="Xcode">Xcode</a></td>
<td>All native: Android, BlackBerry, BREW, iOS (iPhone), Maemo, Palm-webOS, Samsung bada, Symbian, Windows Mobile 6.x and desktop, OS X</td>
<td>The native distribution format of each platform</td>
<td>Commercial licenses available</td>
</tr>
<tr>
<th><a href="https://en.wikipedia.org/wiki/Meme_IDE" title="Meme IDE">Meme IDE</a></th>
<td>MemeScript</td>
<td>Validation is provided in the problems view</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes, Android emulator can be integrated</td>
<td><a href="https://en.wikipedia.org/wiki/Eclipse_(software)" title="Eclipse (software)">Eclipse</a> RCP</td>
<td><a href="https://en.wikipedia.orghttps://en.wikipedia.org/wiki/Android_(operating_system)" title="Android (operating system)">Android</a>, <a href="https://en.wikipedia.org/wiki/Windows_Mobile" title="Windows Mobile">Windows Mobile</a></td>
<td>The native distribution format of each platform</td>
<td>Free for development</td>
</tr>
<tr>
<th><a href="https://en.wikipedia.org/wiki/Mendix" title="Mendix">Mendix</a></th>
<td><a href="https://en.wikipedia.orghttps://en.wikipedia.org/wiki/HTML5" title="HTML5">HTML5</a>, <a href="https://en.wikipedia.org/wiki/Java_(programming_language)" title="Java (programming language)">Java</a></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes, the Mendix app platform</td>
<td>All platforms, mobile apps are browser-based</td>
<td>Not applicable, Mendix is a <a href="https://en.wikipedia.org/wiki/Platform_as_a_service" title="Platform as a service">platform as a service</a></td>
<td>Commercial licenses available</td>
</tr>
<tr>
<th>MobiOne by <a href="https://en.wikipedia.org/wiki/Genuitec" title="Genuitec">Genuitec</a></th>
<td>HTML5, CSS, JavaScript, visual drag-n-drop</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td>Use any Java IDE for back-end services, integrated MyEclipse soon</td>
<td>Android (phones, tablets), iOS (iPhone, iPad, iPod)</td>
<td>OTA for device testing and native distribution format of each platform</td>
<td>Trial and commercial licenses available, one time $99</td>
</tr>
<tr>
<th><a href="https://en.wikipedia.org/wiki/Monaca_(software)" title="Monaca (software)">Monaca</a></th>
<td><a href="https://en.wikipedia.org/wiki/HTML5" title="HTML5">HTML5</a>, <a href="https://en.wikipedia.org/wiki/CSS" class="mw-redirect" title="CSS">CSS</a>, <a href="https://en.wikipedia.org/wiki/JavaScript" title="JavaScript">JavaScript</a></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td>Preview is available on cloud IDE and local tool</td>
<td>Cloud-based IDE, Visual Studio, third-party IDE/editors</td>
<td>Android, iOS, windows8.1, 10</td>
<td>The native distribution format of each platform</td>
<td>Free, up to 3 projects. Commercial and enterprise license available</td>
</tr>
<tr>
<th><a href="https://en.wikipedia.org/wiki/MonoDroid" class="mw-redirect" title="MonoDroid">Mono for Android</a></th>
<td><a href="https://en.wikipedia.org/wiki/C_Sharp_(programming_language)" title="C Sharp (programming language)">C#</a></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td>Visual Studio 2005 and MonoDevelop</td>
<td>Android</td>
<td>The native distribution format of the platform</td>
<td></td>
</tr>
<tr>
<th><a href="https://en.wikipedia.org/wiki/MonoTouch" class="mw-redirect" title="MonoTouch">MonoTouch</a></th>
<td><a href="https://en.wikipedia.org/wiki/C_Sharp_(programming_language)" title="C Sharp (programming language)">C#</a></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td>Visual Studio 2005 and MonoDevelop</td>
<td>iOS</td>
<td>The native distribution format of the platform</td>
<td></td>
</tr>
<tr>
<th><a href="https://en.wikipedia.org/wiki/MoSync" title="MoSync">MoSync</a></th>
<td><a href="https://en.wikipedia.org/wiki/C_(programming_language)" title="C (programming language)">C</a>, <a href="https://en.wikipedia.org/wiki/C%2B%2B" title="C++">C++</a>, <a href="https://en.wikipedia.org/wiki/Lua_(programming_language)" title="Lua (programming language)">Lua</a>, HTML5, CSS, JavaScript</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td>Eclipse, Visual Studio 2005 and later, MoBuild w/ text editors</td>
<td>Android, iOS (iPhone), Java ME, Moblin, Smartphone 2003, Symbian, Windows Mobile (Pocket PC), Blackberry (experimental)</td>
<td>SIS, CAB, JAD, JAR, APK, <a href="https://en.wikipedia.org/wiki/Over-the-air_programming" title="Over-the-air programming">OTA</a> deployment</td>
<td>Free, GPL 2.0, Free Indie Subscription; commercial subscription available</td>
</tr>
<tr>
<th>Mulberry</th>
<td><a href="https://en.wikipedia.org/wiki/HTML5" title="HTML5">HTML5</a>, <a href="https://en.wikipedia.org/wiki/CSS" class="mw-redirect" title="CSS">CSS</a>, <a href="https://en.wikipedia.org/wiki/JavaScript" title="JavaScript">JavaScript</a></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#F99;vertical-align:middle;text-align:center;" class="table-no">No third-party tools</td>
<td>No, third-party tools</td>
<td><a href="https://en.wikipedia.org/wiki/Android_(operating_system)" title="Android (operating system)">Android</a>, <a href="https://en.wikipedia.org/wiki/IOS" title="IOS">iOS</a>, <a href="https://en.wikipedia.org/wiki/Mobile_Web" title="Mobile Web">Mobile Web</a></td>
<td>The native distribution format of each platform, <a href="https://en.wikipedia.org/wiki/Over-the-air_programming" title="Over-the-air programming">OTA</a> deployment,</td>
<td>Free</td>
</tr>
<tr>
<th>Netbeans IDE</th>
<td><a href="https://en.wikipedia.org/wiki/C%2B%2B" title="C++">C++</a>, <a href="https://en.wikipedia.org/wiki/Java_(programming_language)" title="Java (programming language)">Java</a></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td>Java development tools</td>
<td>Android (Mobile and Tablet), Nokia (Symbian, Seria 60 - 40- 80), etc...</td>
<td></td>
<td>Free</td>
</tr>
<tr>
<th><a href="https://en.wikipedia.orghttps://en.wikipedia.org/wiki/Protogrid" title="Protogrid">Protogrid</a></th>
<td>No coding needed. <a href="https://en.wikipedia.org/wiki/JavaScript" title="JavaScript">JavaScript</a> can be used for Business Logic.</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes using browser debug tooling</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes browser-based, iOS simulator</td>
<td>Proprietary IDE</td>
<td>Web, <a href="https://en.wikipedia.org/wiki/IOS" title="IOS">iOS</a>, <a href="https://en.wikipedia.org/wiki/Mobile_Web" title="Mobile Web">Mobile Web</a></td>
<td>The native distribution format of each platform, <a href="https://en.wikipedia.org/wiki/Over-the-air_programming" title="Over-the-air programming">OTA</a> deployment</td>
<td>Trial and commercial licenses available</td>
</tr>
<tr>
<th>NeoMAD</th>
<td><a href="https://en.wikipedia.org/wiki/Java_(programming_language)" title="Java (programming language)">Java</a>, <a href="https://en.wikipedia.org/wiki/XML" title="XML">XML</a></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td>Emulator is available using native emulators</td>
<td>Eclipse Plugin, Eclipse Based Stand-alone</td>
<td>Android, iOS, Windows Phone, Windows Store Apps, Blackberry, J2ME</td>
<td>The native distribution format of each platform</td>
<td>Free &amp; commercial licenses available</td>
</tr>
<tr>
<th><a href="https://en.wikipedia.org/wiki/OpenPlug" title="OpenPlug">OpenPlug</a></th>
<td><a href="https://en.wikipedia.org/wiki/ActionScript" title="ActionScript">ActionScript</a>, <a href="https://en.wikipedia.org/wiki/XML" title="XML">XML</a></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td>OpenPlug ELIPS plugin for <a href="https://en.wikipedia.org/wiki/Adobe_Flash_Builder" title="Adobe Flash Builder">Adobe Flash Builder</a></td>
<td>Android, iOS (iPad, iPhone, iPod Touch), Symbian, Windows Mobile</td>
<td>The native distribution format of each platform</td>
<td>Free &amp; commercial licenses available</td>
</tr>
<tr>
<th>OpenMEAP</th>
<td><a href="https://en.wikipedia.org/wiki/HTML5" title="HTML5">HTML5</a>, <a href="https://en.wikipedia.org/wiki/CSS3" class="mw-redirect" title="CSS3">CSS3</a>, <a href="https://en.wikipedia.org/wiki/JavaScript" title="JavaScript">JavaScript</a></td>
<td>Debugger integrated in Eclipse and Xcode</td>
<td>Emulator is available using native emulators</td>
<td>Xcode, Eclipse</td>
<td>Android, iOS (iPhone, iPad, iPod touch), BlackBerry</td>
<td>The native distribution format of each platform</td>
<td>Open source LGPL license</td>
</tr>
<tr>
<th><a href="https://en.wikipedia.org/wiki/OutSystems" title="OutSystems">OutSystems</a></th>
<td>OutSystems, <a href="https://en.wikipedia.org/wiki/CSS" class="mw-redirect" title="CSS">CSS</a>, <a href="https://en.wikipedia.org/wiki/JavaScript" title="JavaScript">JavaScript</a></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td>Test directly in browser</td>
<td>OutSystems Service Studio</td>
<td>Andoid, iOS, Windows Phone 7</td>
<td>NA</td>
<td>Free community edition for personal use, or subscription licensing for commercial use</td>
</tr>
<tr>
<th>Platino Game Engine</th>
<td><a href="https://en.wikipedia.org/wiki/JavaScript" title="JavaScript">JavaScript</a></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes, in Titanium Studio</td>
<td>Emulator is available using native emulators</td>
<td>Titanium Studio based on Eclipse</td>
<td>Android, iPhone</td>
<td>The native distribution format of each platform</td>
<td>Free to try, $49.99 for a commercial license</td>
</tr>
<tr>
<th><a href="https://en.wikipedia.org/wiki/PhoneGap" class="mw-redirect" title="PhoneGap">PhoneGap</a> and Apache Cordova</th>
<td><a href="https://en.wikipedia.org/wiki/HTML" title="HTML">HTML</a>, <a href="https://en.wikipedia.org/wiki/CSS" class="mw-redirect" title="CSS">CSS</a>, <a href="https://en.wikipedia.org/wiki/JavaScript" title="JavaScript">JavaScript</a></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#F99;vertical-align:middle;text-align:center;" class="table-no">No third-party tools</td>
<td>No, third-party tools</td>
<td>iPhone, Android, Tizen, Windows Phone, BlackBerry, Symbian, Palm, Bada</td>
<td>The native distribution format of each platform</td>
<td>Apache 2</td>
</tr>
<tr>
<th><a href="https://en.wikipedia.org/wiki/Qt_(software)" title="Qt (software)">Qt</a> SDK</th>
<td><a href="https://en.wikipedia.org/wiki/C%2B%2B" title="C++">C++</a>, <a href="https://en.wikipedia.org/wiki/QML" title="QML">QML</a></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td><a href="https://en.wikipedia.org/wiki/Qt_Creator" title="Qt Creator">Qt Creator</a></td>
<td><a href="https://en.wikipedia.org/wiki/Android_(operating_system)" title="Android (operating system)">Android</a> (technology preview), <a href="https://en.wikipedia.org/wiki/IOS" title="IOS">iOS</a> (technology preview), <a href="https://en.wikipedia.org/wiki/Symbian" title="Symbian">Symbian</a>, <a href="https://en.wikipedia.org/wiki/Maemo" title="Maemo">Maemo</a>, <a href="https://en.wikipedia.org/wiki/MeeGo_(operating_system)" class="mw-redirect" title="MeeGo (operating system)">MeeGo</a>, <a href="https://en.wikipedia.org/wiki/Linux" title="Linux">Linux</a>, <a href="https://en.wikipedia.org/wiki/Windows" class="mw-redirect" title="Windows">Windows</a>, <a href="https://en.wikipedia.org/wiki/OS_X" class="mw-redirect" title="OS X">OS X</a></td>
<td>The native distribution format of each platform</td>
<td>Free and commercial licenses available</td>
</tr>
<tr>
<th><a href="https://en.wikipedia.orghttps://en.wikipedia.org/wiki/Rhodes_Framework" class="mw-redirect" title="Rhodes Framework">Rhomobile</a></th>
<td><a href="https://en.wikipedia.org/wiki/Ruby_(programming_language)" title="Ruby (programming language)">Ruby</a> with <a href="https://en.wikipedia.org/wiki/HTML" title="HTML">HTML</a> interface features compiled through an interpreter into native applications</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td>N/A, applications can run in Win32 runner, or in device emulators for supported platforms.</td>
<td><a href="https://en.wikipedia.org/wiki/Xcode" title="Xcode">Xcode</a> or <a href="https://en.wikipedia.org/wiki/Eclipse_(software)" title="Eclipse (software)">Eclipse</a>, on-demand RhoHub version includes full IDE</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes, supports Android 1.6+, iOS 3.0+ (iPhone, iPad), Windows Mobile 6.1 Professional, Windows Mobile 6.0 Standard, BlackBerry 4.6, 4.7, 5.0, 6.0 (4.2 and 4.5 supported but database access is very slow on these devices), Symbian</td>
<td><a href="https://en.wikipedia.org/wiki/Over-the-air_programming" title="Over-the-air programming">OTA</a> deployment, iOS through App store, .SIS, .CAB, .APK, .COD</td>
<td>Rhodes is free and open source under the MIT License, RhoSync is under GPL or commercial, Commercial support available. Subscription for RhoHub</td>
</tr>
<tr>
<th><a href="https://en.wikipedia.orghttps://en.wikipedia.org/wiki/RubyMotion" title="RubyMotion">RubyMotion</a></th>
<td><a href="https://en.wikipedia.org/wiki/Ruby_(programming_language)" title="Ruby (programming language)">Ruby</a></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td>Any text editor. As an IDE, <a href="https://en.wikipedia.org/wiki/RubyMine" class="mw-redirect" title="RubyMine">RubyMine</a>.</td>
<td>Android, iOS</td>
<td>The native distribution format of the platform</td>
<td>RubyMotion is a commercial product.</td>
</tr>
<tr>
<th><a href="https://en.wikipedia.org/wiki/Sencha_Touch" title="Sencha Touch">Sencha Touch</a></th>
<td><a href="https://en.wikipedia.org/wiki/HTML" title="HTML">HTML</a>, <a href="https://en.wikipedia.org/wiki/CSS" class="mw-redirect" title="CSS">CSS</a>, <a href="https://en.wikipedia.org/wiki/JavaScript" title="JavaScript">JavaScript</a></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td>Sencha Architect 2</td>
<td>Android, iOS (iPhone, iPad, iPod touch), Kindle, BlackBerry, Bada</td>
<td>Web delivered, or hybrid via native shells for each platform</td>
<td>GPLv3, free for commercial, paid for OEM and embedded systems</td>
</tr>
<tr>
<th><a href="https://en.wikipedia.org/wiki/Smartface" title="Smartface">Smartface</a></th>
<td><a href="https://en.wikipedia.org/wiki/WYSIWYG" title="WYSIWYG">WYSIWYG</a> design editor with JavaScript code editor</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td>Smartface IDE and SDK</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes Android, iOS (iPhone, iPad, iPod touch), Kindle, Gear, Google Glass</td>
<td>The native distribution format of each platform</td>
<td>Community license and commercial licenses available</td>
</tr>
<tr>
<th><a href="https://en.wikipedia.org/wiki/Stencyl" title="Stencyl">Stencyl</a></th>
<td>Drag-and-drop editor based on <a href="https://en.wikipedia.org/wiki/Scratch_(programming_language)" title="Scratch (programming language)">Scratch</a>, <a href="https://en.wikipedia.org/wiki/Objective-C" title="Objective-C">Objective-C</a></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td><a href="https://en.wikipedia.org/wiki/Xcode" title="Xcode">Xcode</a></td>
<td>iOS (iPad, iPhone, iPod Touch)</td>
<td>The native distribution format of each platform</td>
<td>Free and commercial development licenses</td>
</tr>
<tr>
<th>TD Mobile</th>
<td><a href="https://en.wikipedia.org/wiki/HTML5" title="HTML5">HTML5</a>, High Level Event Actions, <a href="https://en.wikipedia.org/wiki/JavaScript" title="JavaScript">JavaScript</a>, SAL .NET Compiler</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td>TD Mobile IDE</td>
<td>Web-based apps available through mobile web browser</td>
<td>Web URL</td>
<td>Commercial licenses available, free deployment</td>
</tr>
<tr>
<th><a href="https://en.wikipedia.org/wiki/Telerik" title="Telerik">Telerik</a> Platform, and AppBuilder</th>
<td>HTML5, CSS and Javascript</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td>Test right in browser or device</td>
<td>In-browser client, desktop client, Visual Studio, Sublime Text or command-line interface (CLI)</td>
<td>Android, iOS, Windows phone</td>
<td>The native distribution format of each platform</td>
<td>Free to try, commercial and enterprise licenses available</td>
</tr>
<tr>
<th><a href="https://en.wikipedia.org/wiki/Unity_(game_engine)" title="Unity (game engine)">Unity</a></th>
<td><a href="https://en.wikipedia.org/wiki/C_Sharp_(programming_language)" title="C Sharp (programming language)">C#</a>, <a href="https://en.wikipedia.org/wiki/JavaScript" title="JavaScript">JavaScript</a>, <a href="https://en.wikipedia.org/wiki/Boo_(programming_language)" title="Boo (programming language)">Boo</a>, other <a href="https://en.wikipedia.org/wiki/.NET_Framework" title=".NET Framework">.NET</a>-based languages</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td>Remote used to simulate device interaction before app is uploaded to the device.</td>
<td>Unity Editor, also works with Visual Studios and MonoDevelop.</td>
<td>Android, iOS (iPhone, iPad), PC, Mac, desktop browser, Xbox 360, PS3, Wii. BlackBerry Playbook, Nokia Symbian, Roku 2 and others available through company's Union program.</td>
<td>Native distribution format of each platform</td>
<td>Free and commercial development licenses.</td>
</tr>
<tr>
<th><a href="https://en.wikipedia.org/wiki/Verivo" title="Verivo">Verivo</a> AppStudio</th>
<td>WYSIWYG, graphical drag and drop, <a href="https://en.wikipedia.org/wiki/JavaScript" title="JavaScript">JavaScript</a>, <a href="https://en.wikipedia.org/wiki/.NET_Framework" title=".NET Framework">.NET</a>-based languages</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td>Test right in browser or device</td>
<td>Proprietary design studio</td>
<td>Android, iOS, Blackberry</td>
<td>Native distribution format of each platform</td>
<td>Free development licenses; per-CPU deployment licenses</td>
</tr>
<tr>
<th><a href="https://en.wikipedia.org/wiki/ViziApps" title="ViziApps">ViziApps</a></th>
<td>WYSIWYG, graphical drag and drop</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td>Test right in browser or device</td>
<td>Online design studio</td>
<td>Android, iOS, Windows Phone planned</td>
<td>The native distribution format of each platform</td>
<td>Free to design, test, demo, update, app; fee to publish</td>
</tr>
<tr>
<th><a href="https://en.wikipedia.org/wiki/V-Play_Engine" title="V-Play Engine">V-Play Engine</a></th>
<td><a href="https://en.wikipedia.org/wiki/Objective_C" class="mw-redirect" title="Objective C">Objective C</a>, <a href="https://en.wikipedia.org/wiki/C%2B%2B" title="C++">C++</a>, <a href="https://en.wikipedia.org/wiki/JavaScript" title="JavaScript">JavaScript</a>, <a href="https://en.wikipedia.org/wiki/QML" title="QML">QML</a>, <a href="https://en.wikipedia.orghttps://en.wikipedia.org/wiki/Java_(programming_language)" title="Java (programming language)">Java</a></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td><a href="https://en.wikipedia.org/wiki/Qt_Creator" title="Qt Creator">Qt Creator</a></td>
<td>All Platforms</td>
<td>The native distribution format of each platform</td>
<td>Free, Indie and Enterprise licenses are available</td>
</tr>
<tr>
<th>WinDev Mobile</th>
<td>WLanguage</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td>WinDev Mobile</td>
<td>Android, iOS (iPhone, iPad, iPod touch), Windows (Mobile, Phone, Store Apps)</td>
<td>The native distribution format of each platform</td>
<td>Free to try, commercial and enterprise licenses available</td>
</tr>
<tr>
<th><a href="https://en.wikipedia.org/wiki/Wakanda_(software)" title="Wakanda (software)">Wakanda</a></th>
<td><a href="https://en.wikipedia.org/wiki/HTML5" title="HTML5">HTML5</a>, <a href="https://en.wikipedia.org/wiki/JavaScript_(programming_language)" class="mw-redirect" title="JavaScript (programming language)">JavaScript</a></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes Wakanda Studio</td>
<td>Android, iOS, Windows 10 (soon) and browser-based apps</td>
<td>apk</td>
<td>Open Source and Commercial licenses available</td>
</tr>
<tr>
<th><a href="https://en.wikipedia.org/wiki/Xamarin" title="Xamarin">Xamarin</a></th>
<td>C#</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td>Xamarin Studio (Mac only), Visual Studio (Windows only)</td>
<td>Android, iOS, Windows Phone, Windows Store apps</td>
<td>The native distribution of each platform</td>
<td>Free community edition, pro edition included in Microsoft MSDN licensing</td>
</tr>
<tr>
<th><a href="https://en.wikipedia.org/wiki/Xojo" title="Xojo">Xojo</a></th>
<td>Xojo (similar to VB)</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td>Xojo IDE</td>
<td>iOS, mobile web apps</td>
<td>iOS apps are native iPad</td>
<td>Free trial with no time limit; commercial licenses available</td>
</tr>
<tr>
<th>Zuznow</th>
<td><a href="https://en.wikipedia.org/wiki/HTML" title="HTML">HTML</a>, <a href="https://en.wikipedia.org/wiki/CSS" class="mw-redirect" title="CSS">CSS</a>, <a href="https://en.wikipedia.org/wiki/JavaScript" title="JavaScript">JavaScript</a>, <a href="https://en.wikipedia.org/wiki/JQuery" title="JQuery">jQuery</a></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td><a href="https://en.wikipedia.org/wiki/Web_development_tools" title="Web development tools">Web development tools</a></td>
<td>Android (mobile, tablet), iOS (iPhone, iPad, iPod touch), Windows Phone, SmartTV</td>
<td><a href="https://en.wikipedia.org/wiki/Mobile_Web" title="Mobile Web">Mobile Web</a>, <a href="https://en.wikipedia.org/wiki/PhoneGap" class="mw-redirect" title="PhoneGap">PhoneGap</a></td>
<td>Free to try, commercial and enterprise licenses available</td>
</tr>
</table>
