## list of back-end platforms and tools for mobile app development

<table class="wikitable sortable" style="width:100%;">
<tr>
<th><a href="https://en.wikipedia.org/wiki/Computing_platform" title="Computing platform">Platform</a></th>
<th><a href="https://en.wikipedia.org/wiki/Programming_language" title="Programming language">Programming language</a></th>
<th><a href="https://en.wikipedia.org/wiki/Integrated_development_environment" title="Integrated development environment">Integrated development environment</a> available</th>
<th>Cross-platform deployment</th>
<th>Deployment options</th>
<th>Development tool cost</th>
</tr>
<tr>
<th><a href="https://en.wikipedia.org/wiki/Altova" title="Altova">Altova</a> MobileTogether Server</th>
<td>Browser-based interface</td>
<td>NA</td>
<td>Server available for <a href="https://en.wikipedia.org/wiki/Windows" class="mw-redirect" title="Windows">Windows</a>, <a href="https://en.wikipedia.org/wiki/Linux" title="Linux">Linux</a>, <a href="https://en.wikipedia.org/wiki/MacOS" title="MacOS">macOS</a>. Supports mobile devices running <a href="https://en.wikipedia.org/wiki/Android_(operating_system)" title="Android (operating system)">Android</a>, <a href="https://en.wikipedia.org/wiki/IOS" title="IOS">iOS</a>, <a href="https://en.wikipedia.org/wiki/Windows_8" title="Windows 8">Windows 8</a>, <a href="https://en.wikipedia.org/wiki/Windows_Phone_8" title="Windows Phone 8">Windows Phone 8</a>, <a href="https://en.wikipedia.org/wiki/HTML5" title="HTML5">HTML5</a> browser-based client</td>
<td>On-prem, cloud, or hybrid</td>
<td>Commercial license based on the number of mobile devices needed</td>
</tr>
<tr>
<th>Appery.io API Express</th>
<td><a href="https://en.wikipedia.org/wiki/JavaScript" title="JavaScript">JavaScript</a></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes. Browser-based, and native test app for Android, iOS</td>
<td><a href="https://en.wikipedia.org/wiki/Android_(operating_system)" title="Android (operating system)">Android</a>, <a href="https://en.wikipedia.org/wiki/IOS" title="IOS">iOS</a>, mobile web</td>
<td>On-prem, cloud, or hybrid</td>
<td>Free to try, commercial and enterprise licenses available</td>
</tr>
<tr>
<th>AnyPresence</th>
<td><a href="https://en.wikipedia.org/wiki/JavaScript" title="JavaScript">JavaScript</a>, <a href="https://en.wikipedia.org/wiki/Ruby_on_Rails" title="Ruby on Rails">Ruby on Rails</a>, and native SDK languages</td>
<td>Web-based designer, Use any IDE for client-side development</td>
<td><a href="https://en.wikipedia.org/wiki/Android_(operating_system)" title="Android (operating system)">Android</a>, <a href="https://en.wikipedia.org/wiki/IOS" title="IOS">iOS</a>, <a href="https://en.wikipedia.org/wiki/Windows_Phone" title="Windows Phone">Windows Phone</a> 8, <a href="https://en.wikipedia.org/wiki/Java_(programming_language)" title="Java (programming language)">Java</a>, <a href="https://en.wikipedia.org/wiki/Xamarin" title="Xamarin">Xamarin</a>, mobile web, desktop web</td>
<td>On-prem, cloud, or hybrid</td>
<td>Commercial and enterprise licenses available</td>
</tr>
<tr>
<th>Backendless Platform</th>
<td><a href="https://en.wikipedia.orghttps://en.wikipedia.org/wiki/Java_(programming_language)" title="Java (programming language)">Java</a>, <a href="https://en.wikipedia.org/wiki/Objective-C" title="Objective-C">Objective-C</a>, <a href="https://en.wikipedia.org/wiki/Swift_(programming_language)" title="Swift (programming language)">Swift</a>, <a href="https://en.wikipedia.org/wiki/Node.js" title="Node.js">Node.js</a>, <a href="https://en.wikipedia.org/wiki/JavaScript" title="JavaScript">JavaScript</a>, <a href="https://en.wikipedia.org/wiki/ActionScript" title="ActionScript">ActionScript</a>(Flex),C# (.NET)</td>
<td>Use any front-end IDE for client-side development. Eclipse, IDEA or NetBeans for custom server-side logic development</td>
<td><a href="https://en.wikipedia.org/wiki/Android_(operating_system)" title="Android (operating system)">Android</a> 2.0+, <a href="https://en.wikipedia.org/wiki/IOS" title="IOS">iOS</a> 3.0+, <a href="https://en.wikipedia.org/wiki/Windows_Phone" title="Windows Phone">Windows Phone</a> 7+, <a href="https://en.wikipedia.org/wiki/JavaScript" title="JavaScript">JavaScript</a>, HTML5 Client, Flash Player (Flash/Flex)</td>
<td>On-premises and cloud</td>
<td>Free and commercial licenses available</td>
</tr>
<tr>
<th>GO!AppZone by <a href="https://en.wikipedia.org/wiki/Globo_plc" title="Globo plc">Globo plc</a></th>
<td><a href="https://en.wikipedia.org/wiki/JavaScript" title="JavaScript">JavaScript</a>. Custom integrations connectors/server-side logic: C#, VB.NET</td>
<td>Yes, GO!AppZone Studio</td>
<td><a href="https://en.wikipedia.org/wiki/Android_(operating_system)" title="Android (operating system)">Android</a>, <a href="https://en.wikipedia.org/wiki/BlackBerry" title="BlackBerry">BlackBerry</a>, <a href="https://en.wikipedia.orghttps://en.wikipedia.org/wiki/IOS" title="IOS">iOS</a>, <a href="https://en.wikipedia.org/wiki/Windows_RT" title="Windows RT">Windows Phone, 8.x, RT</a></td>
<td>On-prem, cloud or hybrid</td>
<td>Development tools are free, commercial license or subscription needed for deployment</td>
</tr>
<tr>
<th>IBM MobileFirst Server</th>
<td><a href="https://en.wikipedia.org/wiki/HTML5" title="HTML5">HTML5</a>, <a href="https://en.wikipedia.orghttps://en.wikipedia.orghttps://en.wikipedia.org/wiki/CSS3" class="mw-redirect" title="CSS3">CSS3</a>, <a href="https://en.wikipedia.orghttps://en.wikipedia.org/wiki/JavaScript" title="JavaScript">JavaScript</a>, and native SDK languages w/ Native Worklight API</td>
<td><a href="https://en.wikipedia.org/wiki/Eclipse_(software)" title="Eclipse (software)">Eclipse</a> plugin, Eclipse-based stand-alone</td>
<td><a href="https://en.wikipedia.org/wiki/Android_(operating_system)" title="Android (operating system)">Android</a>, <a href="https://en.wikipedia.org/wiki/IOS" title="IOS">iOS</a>, <a href="https://en.wikipedia.org/wiki/BlackBerry" title="BlackBerry">BlackBerry</a> 6,7, &amp; 10, <a href="https://en.wikipedia.org/wiki/Windows_Phone" title="Windows Phone">Windows Phone</a> 7.5 &amp; 8, <a href="https://en.wikipedia.org/wiki/Windows_8" title="Windows 8">Windows 8</a> (desktop, tablets), <a href="https://en.wikipedia.org/wiki/Adobe_AIR" title="Adobe AIR">Adobe AIR</a>, Mobile Web App, desktop browser web page</td>
<td>On-prem</td>
<td>Developer edition free via Eclipse Marketplace, commercial license for deployment</td>
</tr>
<tr>
<th>Kinvey</th>
<td><a href="https://en.wikipedia.org/wiki/Java_(programming_language)" title="Java (programming language)">Java</a></td>
<td>NA</td>
<td>Android 2.0+, iOS 3+</td>
<td>Cloud</td>
<td>Commercial and enterprise licenses available</td>
</tr>
<tr>
<th>Kumulos</th>
<td><a href="https://en.wikipedia.org/wiki/Java_(programming_language)" title="Java (programming language)">Java</a>, <a href="https://en.wikipedia.org/wiki/Objective-C" title="Objective-C">Objective-C</a>, <a href="https://en.wikipedia.org/wiki/Swift_(programming_language)" title="Swift (programming language)">Swift</a>, <a href="https://en.wikipedia.org/wiki/Node.js" title="Node.js">Node.js</a>, <a href="https://en.wikipedia.org/wiki/JavaScript" title="JavaScript">JavaScript</a>, kScript, C# .NET</td>
<td>Use any front-end IDE for client-side development.</td>
<td><a href="https://en.wikipedia.org/wiki/Android_(operating_system)" title="Android (operating system)">Android</a> 2.0+, <a href="https://en.wikipedia.org/wiki/IOS" title="IOS">iOS</a> 3.0+, <a href="https://en.wikipedia.org/wiki/Windows_Phone" title="Windows Phone">Windows Phone</a> 7+, <a href="https://en.wikipedia.org/wiki/JavaScript" title="JavaScript">JavaScript</a>, HTML5, Blackberry, Unity .net Angular JS, LUA Corona, C#</td>
<td>Cloud</td>
<td>Free for up to 25 devices while in development. Fixed Monthly fee with fair use policy.</td>
</tr>
<tr>
<th>Magnet Systems</th>
<td><a href="https://en.wikipedia.org/wiki/Java_(programming_language)" title="Java (programming language)">Java</a></td>
<td><a href="https://en.wikipedia.org/wiki/Eclipse_(software)" title="Eclipse (software)">Eclipse</a></td>
<td>&#160;?</td>
<td>On-prem</td>
<td>Commercial licenses available</td>
</tr>
<tr>
<th><a href="https://en.wikipedia.orghttps://en.wikipedia.orghttps://en.wikipedia.org/wiki/Metismo" title="Metismo">Metismo</a></th>
<td><a href="https://en.wikipedia.orghttps://en.wikipedia.org/wiki/Java_(programming_language)" title="Java (programming language)">Java</a></td>
<td><a href="https://en.wikipedia.org/wiki/Eclipse_(software)" title="Eclipse (software)">Eclipse</a></td>
<td>Android, iOS (iPhone, iPad), Java ME, BREW, BlackBerry, Nintendo DS, Palm/webOS, Sony PSP, Samsung bada, Symbian, Windows Mobile, Windows Phone 7, Windows Desktop, OS X</td>
<td>On-prem</td>
<td>Commercial licenses available</td>
</tr>
<tr>
<th><a href="https://en.wikipedia.org/wiki/Wakanda_(software)" title="Wakanda (software)">Wakanda</a></th>
<td><a href="https://en.wikipedia.org/wiki/JavaScript_(programming_language)" class="mw-redirect" title="JavaScript (programming language)">JavaScript</a></td>
<td>Use Wakanda Studio</td>
<td>Android, iOS (iPhone, iPad), Windows Phone 10 (soon), HTML5 app</td>
<td>On-prem or cloud</td>
<td>Community and commercial editions</td>
</tr>
<tr>
<th><a href="https://en.wikipedia.org/wiki/Verivo" title="Verivo">Verivo</a> Akula</th>
<td><a href="https://en.wikipedia.org/wiki/Java_(programming_language)" title="Java (programming language)">Java</a></td>
<td>Use any front-end IDE</td>
<td>Android, iOS (iPhone, iPad), Windows Phone7</td>
<td>On-prem, cloud, or hybrid</td>
<td>Free development licenses; per-CPU deployment licenses</td>
</tr>
<tr>
<th><a href="https://en.wikipedia.org/wiki/WebORB_Integration_Server" title="WebORB Integration Server">WebORB Integration Server</a></th>
<td><a href="https://en.wikipedia.org/wiki/C_Sharp_(programming_language)" title="C Sharp (programming language)">C#</a>, <a href="https://en.wikipedia.org/wiki/VB.NET" class="mw-redirect" title="VB.NET">VB.NET</a>, <a href="https://en.wikipedia.org/wiki/Java_(programming_language)" title="Java (programming language)">Java</a>, <a href="/wiki/PHP" title="PHP">PHP</a>, ActionScript, <a href="https://en.wikipedia.org/wiki/JavaScript" title="JavaScript">JavaScript</a>, <a href="https://en.wikipedia.org/wiki/Objective-C" title="Objective-C">Objective-C</a>,
<p><a href="https://en.wikipedia.org/wiki/XML" title="XML">XML</a></p>
</td>
<td>Works with Eclipse, Visual Studio, intelliJ IDEA and Amethyst IDE</td>
<td>Android, iOS (iPhone, iPad), BlackBerry Playbook, Windows Phone 7</td>
<td>On-prem</td>
<td>Free development licenses; free and commercial deployment licenses</td>
</tr>
</table>
