

## mobile dev :

**native platforms:** ios, android

**cross-platforms:** phonegap/apache cordova, xamarin, unity, appcelerator 


**************************

Before starting with actual subjective topics, lets understand some required terminologies:

* Mobile OS?
* Native platform apps?
* Cross-platform apps?
* Available softwares, platforms and tools for mobile app development
* Mobile app architectural/design patterns

**(The goal of this article is to get an outline of all mobile app development platforms, their technical concepts and a brief survey on mobile app industry)**
*************************

## mobile operating system

Mobile operating systems combine features of a personal computer operating system with other features useful for mobile or handheld use; usually including, and most of the following considered essential in modern mobile systems; a touchscreen, cellular, Bluetooth, Wi-Fi Protected Access, Wi-Fi, Global Positioning System (GPS) mobile navigation, [[Digital camera|single-frame picture cameras]/video camera, speech recognition, voice recorder, music player, near field communication, and infrared blaster. 

* By the end of 2016, over 430 million smartphones were sold with 81.7 percent running Android, 17.9 percent running iOS, 0.3 percent running Windows Mobile and the other OSes cover 0.1 percent. Android alone is more popular than the popular desktop operating system Windows, and in general smartphone use (even without tablets) outnumber desktop use (desktop use, web use, overall is down to 44.9% in the first quarter of 2017).

* Mobile devices with mobile communications abilities (e.g., smartphones) contain two mobile operating systems – the main user-facing software platform is supplemented by a second low-level proprietary real-time operating system which operates the radio and other hardware. 

* Research has shown that these low-level systems may contain a range of security vulnerabilities permitting malicious base stations to gain high levels of control over the mobile device.

* Mobile operating systems have majority use as of 2017 (measured by web use); with even only the smartphones running them (excluding tablets) more used than any other kind of device. Thus traditional desktop OS is now a minority used kind of OS; see usage share of operating systems. However, variations occur in popularity by regions, while desktop-minority also applies on some days in regions such as United States and United Kingdom.



### list of mobile operating systems

<ul>
<li><a href="https://en.wikipedia.org/wiki/BlackBerry_OS" title="BlackBerry OS">BlackBerry OS</a></li>
<li><a href="https://en.wikipedia.org/wiki/Embedded_Linux" class="mw-redirect" title="Embedded Linux">Embedded Linux</a>
<ul>
<li><a href="https://en.wikipedia.org/wiki/Access_Linux_Platform" title="Access Linux Platform">Access Linux Platform</a></li>
<li><a href="https://en.wikipedia.org/wiki/Android_(operating_system)" title="Android (operating system)">Android</a></li>
<li><a href="https://en.wikipedia.org/wiki/Bada" title="Bada">bada</a></li>
<li><a href="https://en.wikipedia.org/wiki/Firefox_OS" title="Firefox OS">Firefox OS</a> (project name: <a href="https://en.wikipedia.org/wiki/Boot_to_Gecko" class="mw-redirect" title="Boot to Gecko">Boot to Gecko</a>)</li>
<li><a href="https://en.wikipedia.org/wiki/Openmoko_Linux" title="Openmoko Linux">Openmoko Linux</a></li>
<li><a href="https://en.wikipedia.org/wiki/OPhone" title="OPhone">OPhone</a></li>
<li><a href="https://en.wikipedia.org/wiki/MeeGo" title="MeeGo">MeeGo</a> (from merger of <a href="https://en.wikipedia.org/wiki/Maemo" title="Maemo">Maemo</a> &amp; <a href="https://en.wikipedia.orghttps://en.wikipedia.org/wiki/Moblin" title="Moblin">Moblin</a>)</li>
<li><a href="https://en.wikipedia.org/wiki/Mobilinux" title="Mobilinux">Mobilinux</a></li>
<li><a href="https://en.wikipedia.org/wiki/MotoMagx" title="MotoMagx">MotoMagx</a></li>
<li><a href="https://en.wikipedia.org/wiki/Qt_Extended" title="Qt Extended">Qt Extended</a></li>
<li><a href="https://en.wikipedia.org/wiki/Sailfish_OS" title="Sailfish OS">Sailfish OS</a></li>
<li><a href="https://en.wikipedia.org/wiki/Tizen" title="Tizen">Tizen</a> (earlier called <a href="https://en.wikipedia.org/wiki/LiMo_Platform" class="mw-redirect" title="LiMo Platform">LiMo Platform</a>)</li>
<li><a href="https://en.wikipedia.org/wiki/Ubuntu_Touch" title="Ubuntu Touch">Ubuntu Touch</a></li>
<li><a href="https://en.wikipedia.org/wiki/WebOS" title="WebOS">webOS</a></li>
</ul>
</li>
<li><a href="https://en.wikipedia.org/wiki/PEN/GEOS" class="mw-redirect" title="PEN/GEOS">PEN/GEOS</a>, <a href="https://en.wikipedia.org/wiki/GEOS-SC" class="mw-redirect" title="GEOS-SC">GEOS-SC</a>, <a href="https://en.wikipedia.org/wiki/GEOS-SE" class="mw-redirect" title="GEOS-SE">GEOS-SE</a></li>
<li><a href="https://en.wikipedia.org/wiki/IOS" title="IOS">iOS</a></li>
<li><a href="https://en.wikipedia.org/wiki/Palm_OS" title="Palm OS">Palm OS</a></li>
<li><a href="https://en.wikipedia.org/wiki/Symbian_platform" class="mw-redirect" title="Symbian platform">Symbian platform</a> (successor to <a href="https://en.wikipedia.org/wiki/Symbian_OS" class="mw-redirect" title="Symbian OS">Symbian OS</a>)</li>
<li><a href="https://en.wikipedia.org/wiki/Windows_Mobile" title="Windows Mobile">Windows Mobile</a> (superseded by <a href="/wiki/Windows_Phone" title="Windows Phone">Windows Phone</a>)</li>
<li><a href="https://en.wikipedia.org/wiki/BlackBerry_10" title="BlackBerry 10">BlackBerry 10</a></li>
</ul>

***************

<h2><span class="mw-headline" id="Timeline">brief history and timelines of mobile OS</span></span></h2>
<p>Mobile operating system milestones mirror the development of <a href="https://en.wikipedia.org/wiki/Mobile_phone" title="Mobile phone">mobile phones</a> and <a href="https://en.wikipedia.org/wiki/Smartphone" title="Smartphone">smartphones</a>:</p>
<h3><span class="mw-headline" id="Pre-1993">Pre-1993</span></span></h3>
<ul>
<li>1973–1993 – <a href="https://en.wikipedia.org/wiki/Mobile_phone" title="Mobile phone">Mobile phones</a> use <a href="https://en.wikipedia.orghttps://en.wikipedia.orghttps://en.wikipedia.org/wiki/Embedded_system" title="Embedded system">embedded systems</a> to control operation.</li>
</ul>
<h3><span id="1993–1999"></span><span class="mw-headline" id="1993.E2.80.931999">1993–1999</span></span></h3>
<ul>
<li>1994 – The first <a href="https://en.wikipedia.orghttps://en.wikipedia.org/wiki/Smartphone" title="Smartphone">smartphone</a>, the <a href="https://en.wikipedia.org/wiki/IBM_Simon" title="IBM Simon">IBM Simon</a>, has a touchscreen, <a href="https://en.wikipedia.org/wiki/Email" title="Email">email</a>, and PDA features.</li>
<li>1996 - <a href="https://en.wikipedia.org/wiki/Palm,_Inc." title="Palm, Inc.">Palm</a> <a href="https://en.wikipedia.org/wiki/Pilot_1000" title="Pilot 1000">Pilot 1000</a> <a href="https://en.wikipedia.org/wiki/Personal_digital_assistant" title="Personal digital assistant">personal digital assistant</a> is introduced with the <a href="https://en.wikipedia.org/wiki/Palm_OS" title="Palm OS">Palm OS</a> mobile operating system.</li>
<li>1998 - <a href="https://en.wikipedia.org/wiki/Symbian_Ltd." title="Symbian Ltd.">Symbian Ltd.</a> has developed <a href="https://en.wikipedia.org/wiki/Symbian_OS" class="mw-redirect" title="Symbian OS">Symbian OS</a>. Symbian was used by many major mobile phone brands, and above all by <a href="https://en.wikipedia.org/wiki/Nokia" title="Nokia">Nokia</a>.</li>
<li>1999 – <a href="https://en.wikipedia.org/wiki/Series_40" title="Series 40">Nokia S40</a> Platform is introduced officially along with the <a href="https://en.wikipedia.org/wiki/Nokia_7110" title="Nokia 7110">Nokia 7110</a>.</li>
</ul>
<h3><span class="mw-headline" id="2000s">2000s</span></span></h3>
<ul>
<li>2000 – <a href="https://en.wikipedia.org/wiki/Symbian" title="Symbian">Symbian</a> becomes the first modern mobile OS on a smartphone with the launch of the <a href="https://en.wikipedia.org/wiki/Ericsson_R380" title="Ericsson R380">Ericsson R380</a>.</li>
<li>2001 – The <a href="https://en.wikipedia.org/wiki/Kyocera_6035" title="Kyocera 6035">Kyocera 6035</a> is the first smartphone with <a href="https://en.wikipedia.org/wiki/Palm_OS" title="Palm OS">Palm OS</a>.</li>
<li>2002
<ul>
<li><a href="https://en.wikipedia.orghttps://en.wikipedia.org/wiki/Microsoft" title="Microsoft">Microsoft</a>'s first <a href="https://en.wikipedia.org/wiki/Windows_CE" class="mw-redirect" title="Windows CE">Windows CE</a> (Pocket PC) smartphones are introduced.</li>
<li><a href="https://en.wikipedia.org/wiki/BlackBerry_Limited" title="BlackBerry Limited">BlackBerry</a> releases its first smartphone.</li>
</ul>
</li>
<li>2005 – <a href="https://en.wikipedia.org/wiki/Nokia" title="Nokia">Nokia</a> introduces <a href="https://en.wikipedia.org/wiki/Maemo" title="Maemo">Maemo</a> OS on the first Internet tablet <a href="https://en.wikipedia.org/wiki/N770" class="mw-redirect" title="N770">N770</a>.</li>
<li>2007
<ul>
<li>Apple iPhone with <a href="https://en.wikipedia.org/wiki/IOS" title="IOS">iOS</a> is introduced as an iPod, "mobile phone" and "Internet communicator".</li>
<li><a href="https://en.wikipedia.org/wiki/Open_Handset_Alliance" title="Open Handset Alliance">Open Handset Alliance</a> (OHA) formed by <a href="https://en.wikipedia.org/wiki/Google" title="Google">Google</a>, <a href="https://en.wikipedia.org/wiki/HTC" title="HTC">HTC</a>, <a href="https://en.wikipedia.org/wiki/Sony" title="Sony">Sony</a>, <a href="https://en.wikipedia.org/wiki/Dell" title="Dell">Dell</a>, <a href="https://en.wikipedia.org/wiki/Intel" title="Intel">Intel</a>, <a href="https://en.wikipedia.org/wiki/Motorola_Mobility" title="Motorola Mobility">Motorola</a>, <a href="https://en.wikipedia.org/wiki/Samsung_Electronics" title="Samsung Electronics">Samsung</a>, <a href="https://en.wikipedia.org/wiki/LG_Electronics" title="LG Electronics">LG</a>, etc.</li>
</ul>
</li>
<li>2008 – OHA releases <a href="https://en.wikipedia.org/wiki/Android_(operating_system)" title="Android (operating system)">Android</a> (based on <a href="https://en.wikipedia.org/wiki/Linux_kernel" title="Linux kernel">Linux kernel</a>) 1.0 with the <a href="https://en.wikipedia.org/wiki/HTC_Dream" title="HTC Dream">HTC Dream</a> (T-Mobile G1) as the first Android phone.</li>
<li>2009
<ul>
<li><a href="https://en.wikipedia.org/wiki/Palm,_Inc." title="Palm, Inc.">Palm</a> introduces <a href="https://en.wikipedia.org/wiki/WebOS" title="WebOS">webOS</a> with the <a href="https://en.wikipedia.org/wiki/Palm_Pre" title="Palm Pre">Palm Pre</a>. By 2012, webOS devices were discontinued.</li>
<li><a href="https://en.wikipedia.org/wiki/Samsung_Electronics" title="Samsung Electronics">Samsung</a> announces the <a href="https://en.wikipedia.org/wiki/Bada" title="Bada">Bada</a> OS with the introduction of the <a href="https://en.wikipedia.org/wiki/Samsung_S8500" class="mw-redirect" title="Samsung S8500">Samsung S8500</a>.</li>
</ul>
</li>
</ul>
<h3><span class="mw-headline" id="2010s">2010s</span></span></h3>
<h4><span class="mw-headline" id="2010">2010</span></span></h4>
<ul>
<li>November – <a href="https://en.wikipedia.orghttps://en.wikipedia.org/wiki/Windows_Phone" title="Windows Phone">Windows Phone</a> OS phones are released but are not compatible with the prior <a href="https://en.wikipedia.org/wiki/Windows_Mobile" title="Windows Mobile">Windows Mobile</a> OS.</li>
</ul>
<h4><span class="mw-headline" id="2011">2011</span></span></h4>
<ul>
<li>July – <a href="https://en.wikipedia.org/wiki/MeeGo" title="MeeGo">MeeGo</a>, a mobile <a href="https://en.wikipedia.org/wiki/Linux" title="Linux">Linux</a> distribution, combining <a href="https://en.wikipedia.org/wiki/Maemo" title="Maemo">Maemo</a> and <a href="https://en.wikipedia.org/wiki/Moblin" title="Moblin">Moblin</a>, is introduced with the <a href="https://en.wikipedia.org/wiki/Nokia_N9" title="Nokia N9">Nokia N9</a>, a collaboration of <a href="https://en.wikipedia.org/wiki/Nokia" title="Nokia">Nokia</a>, <a href="https://en.wikipedia.org/wiki/Intel" title="Intel">Intel</a>, and <a href="https://en.wikipedia.org/wiki/Linux_Foundation" title="Linux Foundation">Linux Foundation</a>.</li>
<li>September – Samsung, Intel, and the Linux Foundation announced that their efforts will shift from Bada, MeeGo to <a href="https://en.wikipedia.org/wiki/Tizen" title="Tizen">Tizen</a> during 2011 and 2012.</li>
<li>October – The <a href="https://en.wikipedia.org/wiki/Mer_(software_distribution)" title="Mer (software distribution)">Mer</a> project was announced, based on an ultra-portable core for building products, composed of Linux, <a href="https://en.wikipedia.org/wiki/HTML5" title="HTML5">HTML5</a>, <a href="https://en.wikipedia.org/wiki/QML" title="QML">QML</a>, and <a href="https://en.wikipedia.org/wiki/JavaScript" title="JavaScript">JavaScript</a>, which was derived from the MeeGo codebase.</li>
</ul>
<h4><span class="mw-headline" id="2012">2012</span></span></h4>
<ul>
<li>July – <a href="https://en.wikipedia.orghttps://en.wikipedia.org/wiki/Mozilla" title="Mozilla">Mozilla</a> announced that the project formerly named <i>Boot to Gecko</i> (which was built atop an Android Linux kernel using Android drivers and services; however it used no Java-like code of Android) was now <a href="https://en.wikipedia.org/wiki/Firefox_OS" title="Firefox OS">Firefox OS</a> (since discontinued) and had several handset OEMs on board.</li>
<li>September – Apple releases <a href="https://en.wikipedia.org/wiki/IOS_6" title="IOS 6">iOS 6</a>.</li>
</ul>
<h4><span class="mw-headline" id="2013">2013</span></span></h4>
<ul>
<li>January – <a href="https://en.wikipedia.org/wiki/Research_in_Motion" class="mw-redirect" title="Research in Motion">BlackBerry</a> releases their new operating system for smartphones, <a href="https://en.wikipedia.org/wiki/BlackBerry_10" title="BlackBerry 10">BlackBerry 10</a>.</li>
<li>September – Apple releases <a href="https://en.wikipedia.org/wiki/IOS_7" title="IOS 7">iOS 7</a>.</li>
<li>October
<ul>
<li><a href="https://en.wikipedia.org/wiki/Canonical_Ltd." class="mw-redirect" title="Canonical Ltd.">Canonical</a> announced <a href="https://en.wikipedia.org/wiki/Ubuntu_Touch" title="Ubuntu Touch">Ubuntu Touch</a> (later discontinued), a version of the Linux distribution expressly designed for smartphones. The OS is built on the Android Linux kernel, using Android drivers and services, but does not use any of the Java-like code of Android.</li>
<li>Google releases Android KitKat 4.4.</li>
</ul>
</li>
</ul>
<h4><span class="mw-headline" id="2014">2014</span></span></h4>
<ul>
<li>February – Microsoft releases <a href="https://en.wikipedia.org/wiki/Windows_Phone_8.1" title="Windows Phone 8.1">Windows Phone 8.1</a></li>
<li>September
<ul>
<li>Apple releases <a href="https://en.wikipedia.org/wiki/IOS_8" title="IOS 8">iOS 8</a></li>
<li>BlackBerry release <a href="https://en.wikipedia.org/wiki/BlackBerry_10" title="BlackBerry 10">BlackBerry 10</a>.3 with integration with the <a href="https://en.wikipedia.org/wiki/Amazon_Appstore" title="Amazon Appstore">Amazon Appstore</a></li>
</ul>
</li>
<li>November – Google releases <a href="https://en.wikipedia.org/wiki/Android_Lollipop" title="Android Lollipop">Android 5.0 "Lollipop"</a></li>
</ul>
<h4><span class="mw-headline" id="2015">2015</span></span></h4>
<ul>
<li>February – Google releases Android 5.1 <i>Lollipop</i>.</li>
<li>September
<ul>
<li>Apple releases <a href="https://en.wikipedia.org/wiki/IOS_9" title="IOS 9">iOS 9</a>.</li>
<li>Google releases <a href="https://en.wikipedia.org/wiki/Android_Marshmallow" title="Android Marshmallow">Android 6.0 <i>Marshmallow</i></a>.</li>
</ul>
</li>
<li>November – Microsoft releases <a href="https://en.wikipedia.org/wiki/Windows_10_Mobile" title="Windows 10 Mobile">Windows 10 Mobile</a>.</li>
</ul>
<h4><span class="mw-headline" id="2016">2016</span></span></h4>
<ul>
<li>February – Microsoft released <a href="https://en.wikipedia.org/wiki/Windows_10_Mobile" title="Windows 10 Mobile">Windows 10 Mobile</a> Anniversary Update.</li>
<li>June – Apple announced <a href="https://en.wikipedia.org/wiki/IOS_10" title="IOS 10">iOS 10</a>.</li>
<li>August – Google released <a href="https://en.wikipedia.org/wiki/Android_Nougat" title="Android Nougat">Android 7.0 "Nougat"</a>.</li>
<li>September – Apple released <a href="https://en.wikipedia.orghttps://en.wikipedia.org/wiki/IOS_10" title="IOS 10">iOS 10</a>.</li>
<li>November – Tizen released <a href="https://en.wikipedia.org/wiki/Tizen" title="Tizen">Tizen</a> 3.0.</li>
<li>November – BlackBerry released <a href="https://en.wikipedia.org/wiki/BlackBerry_10" title="BlackBerry 10">BlackBerry 10</a>.3.3.</li>
</ul>
<h4><span class="mw-headline" id="2017">2017</span></span></h4>
<ul>
<li>April – Samsung officially launched Android-based <a href="https://en.wikipedia.org/wiki/Samsung_Experience" title="Samsung Experience">Samsung Experience</a> custom UI starting with version 8.1 on <a href="https://en.wikipedia.org/wiki/Samsung_Galaxy_S8" title="Samsung Galaxy S8">Samsung Galaxy S8</a></li>
<li>April – Microsoft released <a href="https://en.wikipedia.org/wiki/Windows_10_Mobile" title="Windows 10 Mobile">Windows 10 Mobile</a> Creators Update.</li>
<li>August – Google released <a href="https://en.wikipedia.org/wiki/Android_Oreo" title="Android Oreo">Android 8.0 "Oreo"</a>.</li>
<li>August – BlackBerry announced the Android-based BlackBerry Secure which focus on security.</li>
<li>September – Apple introduces the <a href="https://en.wikipedia.org/wiki/IPhone_8" title="IPhone 8">iPhone 8</a>, <a href="https://en.wikipedia.org/wiki/IPhone_X" title="IPhone X">iPhone X</a>, and <a href="https://en.wikipedia.org/wiki/IOS_11" title="IOS 11">iOS 11</a>.</li>
<li>October – On October 8, Windows announced that <a href="https://en.wikipedia.org/wiki/Windows_10_Mobile" title="Windows 10 Mobile">Windows 10 Mobile</a> will be shuttered, ending Microsoft's attempts at developing a mobile operating system.</li>
</ul>

**************************

## currently active platforms

**open source:**

* Android
* Android Open Kang Project (AOKP)
* BlackBerry Secure
* ColorOS
* Emotion User Interface (EMUI)
* Flyme OS
* HTC Sense
* LineageOS
* Indus OS
* Mi User Interface (MIUI)
* LG UX (formerly named Optimus UI)
* OxygenOS
* Replicant OS
* Samsung Experience (formerly called TouchWiz)
* ZenUI
* Sailfish OS is from Jolla
* Tizen

**closed source:**

* iOS (formerly named iPhone OS)
* BlackBerry 10 (based on the QNX OS) is from BlackBerry
* Windows 10 Mobile (formerly called Windows Phone) is from Microsoft

## discontinued software platforms

**open source:**

* CyanogenMod
* Cyanogen OS
* Firefox OS (In September 2016, Mozilla announced that work on Firefox OS has ceased, and all B2G-related code would be removed from mozilla-central)
* MeeGo/Maemo/Moblin
* Ubuntu Touch is from Canonical Ltd
* webOS was developed by Palm

**closed source:**

* BlackBerry OS
* Windows Mobile
* Windows Phone
* Symbian platform was developed by Nokia(discontinued in 2012)
* Bada platform
* Palm OS

***************
## Survey

* In 2006, Android, iOS, and Windows Phone did not exist and only 64 million smartphones were sold. In 2016 Q4, 431.53 million smartphones were sold and global market share was 81.7% for Android, 17.9% for iOS, 0.3% for Windows 10 Mobile and 0.1% for all other platforms

world-wide smartphone sales:
<br>

![smartphonesale](https://upload.wikimedia.org/wikipedia/commons/8/83/World_Wide_Smartphone_Sales.png)
<br>
<br>

mobile OS market share:
<br>
![OS market share](https://upload.wikimedia.org/wikipedia/en/1/18/Mobile_OS_market_share_from_IDC_till_2016_Q3.png)
<br>
<br>
Note:

* Windows includes Windows 10 Mobile, Windows Phone and Windows Mobile.
* BlackBerry includes BlackBerry 10 and BlackBerry OS.
* Other includes all other smartphone OS but not feature phone OS.

Source: wiki

**********************
### Native platform mobile apps

A native mobile app is an application which meets the requirements of a particular operating system by using its SDK (as well as hardware memory, gear and other applications installed on a device).


### Cross-platform-mobile app

A cross-platform application is a mobile app which is compatible with multiple operating systems and can therefore run on any smartphone or tablet.

<br>

There are two types of cross-platform mobile applications:

<br>

**Native cross-platform apps:** Each operating system has its SDK and major tech stack (Java for Android and Objective-C/Swift for iOS app development). An experienced mobile vendor, however, can create a unified API running on top of a native Software Development Kit and use the same codebase for both Android ad iOS apps. Native cross-platform applications are primarily built with Xamarin and Appcelerator Titanium;

<br>

**Hybrid HTML5 applications:**  Although mobile applications are designed for smartphones and tablets, it is backend servers (either on-prem or Cloud-based) that handle application logic. Since both iOS and Android SDKs feature advanced web components, skilled software engineers often utilize WebView to create parts of an application’s GUI (Graphical User Interface) with HTML5, CSS and JavaScript. The most popular hybrid app development framework is Apache Cordova (formerly known as PhoneGap).



<br>

There are some articles which discusses about pros and cons of native and cross-platforms apps:

* [Why we are not cross-platform developers](https://android.jlelse.eu/why-we-are-not-cross-platform-developers-fd7ef70e976d)
* [Cross-Platform vs. Native App App Development: Pros and Cons](http://www.businessofapps.com/cross-platform-vs-native-app-app-development-pros-and-cons/)
* [Which is better, native app development vs. cross platform app?](https://www.quora.com/Which-is-better-native-app-development-vs-cross-platform-app)
* [quora: Cross Platform Mobile Development](https://www.quora.com/topic/Cross-Platform-Mobile-Development)
* [stackoverflow: Mobile development - Native VS Cross Platform VS JavaScript](https://stackoverflow.com/questions/8865277/mobile-development-native-vs-cross-platform-vs-javascript)
* [reddit:This is what happens when you develop cross platform app instead of native](https://www.reddit.com/r/androiddev/comments/58iqx8/this_is_what_happens_when_you_develop_cross/)

****************************

## mobile application development platforms and tools:

<p>The platform organizations needed to develop, deploy and manage <a href="https://en.wikipedia.org/wiki/Mobile_app" title="Mobile app">mobile apps</a> are made from many components and tools which allow a developer to write, test and deploy applications into the target platform environment.</p>
<h3><span class="mw-headline" id="Front-end_development_tools">Front-end development tools</span></h3>
<p>Front-end development tools are focused on the user interface and user experience (UI-UX) and provide the following abilities:</p>
<ul>
<li>UI design tools</li>
<li>SDKs to access device features</li>
<li>Cross-platform accommodations/support</li>
</ul>

Available [platforms and tools](https://github.com/gopala-kr/weekend-with-github/blob/master/Projects-Blogs/04-mobile-dev/front-end-tools.md)

<h3><span class="mw-headline" id="Back-end_servers">Back-end servers</span></h3>
<p>Back-end tools pick up where the front-end tools leave off, and provide a set of reusable services that are centrally managed and controlled and provide the following abilities:</p>
<ul>
<li>Integration with back-end systems</li>
<li>User authentication-authorization</li>
<li>Data services</li>
<li>Reusable business logic</li>
</ul>

Available [platforms and tools](https://github.com/gopala-kr/weekend-with-github/blob/master/Projects-Blogs/04-mobile-dev/backend-tools.md)

<h3><span class="mw-headline" id="Security_add-on_layers">Security add-on layers</span></h3>
<p>With <a href="https://en.wikipedia.org/wiki/Bring_your_own_device" title="Bring your own device">bring your own device</a> (BYOD) becoming the norm within more enterprises, IT departments often need stop-gap, tactical solutions that layer atop existing apps, phones, and platform component. Features include</p>
<ul>
<li>App wrapping for security</li>
<li>Data encryption</li>
<li>Client actions</li>
<li>Reporting and statistics</li>
</ul>

<h3><span class="mw-headline" id="System_software">System software</span></h3>
<p>Many system-level components are needed to have a functioning platform for developing mobile apps.</p>

[Available [platforms and tools](https://github.com/gopala-kr/weekend-with-github/blob/master/Projects-Blogs/04-mobile-dev/system-software-tools.md)]

<br>

* Criteria for selecting a development platform usually contains the target mobile platforms, existing infrastructure and development skills. When targeting more than one platform with cross-platform development it is also important to consider the impact of the tool on the <a href="https://en.wikipedia.org/wiki/User_experience" title="User experience">user experience</a>. 
  
* Performance is another important criteria, as research on mobile apps indicates a strong correlation between application performance and user satisfaction. Along with performance and other criteria, the availability of the technology and the project's requirement may drive the development between native and cross-platform environments. 

* To aid the choice between native and cross-platform environments, some guidelines and benchmarks have been published. Typically, cross-platform environments are reusable across multiple platforms, leveraging a native container while using HTML, CSS, and JavaScript for the user interface. In contrast, native environments are targeted at one platform for each of those environments. For example, Android development occurs in the Eclipse IDE using Android Developer Tools (ADT) plugins, Apple iOS development occurs using Xcode IDE with Objective-C and/or Swift, Windows and BlackBerry each have their own development environments.

<br>
<h3><span class="mw-headline" id="Mobile_app_testing">Mobile app testing</span></h3>
<p>Mobile applications are first tested within the development environment using emulators and later subjected to <a href="https://en.wikipedia.org/wiki/Field_testing" class="mw-redirect" title="Field testing">field testing</a>. <a href="https://en.wikipedia.org/wiki/Emulator" title="Emulator">Emulators</a> provide an inexpensive way to test applications on mobile phones to which developers may not have physical access. The following are examples of tools used for testing application across the most popular <a href="https://en.wikipedia.org/wiki/Mobile_operating_system" title="Mobile operating system">mobile operating systems</a>.</p>
<ul>
<li><b>Google Android Emulator</b> - an <a href="https://en.wikipedia.org/wiki/Android_(operating_system)" title="Android (operating system)">Android</a> emulator that is patched to run on a Windows PC as a standalone app, without having to download and install the complete and complex <a href="https://en.wikipedia.org/wiki/Android_SDK" class="mw-redirect" title="Android SDK">Android SDK</a>. It can be installed and Android compatible apps can be tested on it.</li>
<li><b>The official Android SDK Emulator</b> - a mobile device emulator which mimics all of the hardware and <a href="https://en.wikipedia.org/wiki/Software" title="Software">software</a> features of a typical mobile device (without the calls).</li>
<li><b>MobiOne</b> Developer - a <a href="https://en.wikipedia.org/wiki/Mobile_Web" title="Mobile Web">mobile Web</a> <a href="https://en.wikipedia.org/wiki/Integrated_development_environment" title="Integrated development environment">integrated development environment</a> (IDE) for <a href="https://en.wikipedia.org/wiki/Windows" class="mw-redirect" title="Windows">Windows</a> that helps developers to code, test, debug, package and deploy mobile <a href="https://en.wikipedia.org/wiki/Web_application" title="Web application">Web applications</a> to devices such as <a href="https://en.wikipedia.org/wiki/IPhone" title="IPhone">iPhone</a>, <a href="https://en.wikipedia.org/wiki/BlackBerry" title="BlackBerry">BlackBerry</a>, <a href="https://en.wikipedia.org/wiki/Android_(operating_system)" title="Android (operating system)">Android</a>, and the <a href="https://en.wikipedia.org/wiki/Palm_Pre" title="Palm Pre">Palm Pre</a>. MobiOne Developer was officially declared End of Life by the end of 2014.</li>
<li><b>TestiPhone</b> - a <a href="https://en.wikipedia.org/wiki/Web_browser" title="Web browser">web browser</a>-based <a href="/wiki/Simulator" class="mw-redirect" title="Simulator">simulator</a> for quickly testing <a href="https://en.wikipedia.org/wiki/IPhone" title="IPhone">iPhone</a> <a href="https://en.wikipedia.org/wiki/Web_applications" class="mw-redirect" title="Web applications">web applications</a>. This tool has been tested and works using <a href="https://en.wikipedia.org/wiki/Internet_Explorer_7" title="Internet Explorer 7">Internet Explorer 7</a>, <a href="https://en.wikipedia.org/wiki/Firefox_2" title="Firefox 2">Firefox 2</a> and <a href="https://en.wikipedia.org/wiki/Safari_3" class="mw-redirect" title="Safari 3">Safari 3</a>.</li>
<li><b>iPhoney</b> - gives a <a href="https://en.wikipedia.org/wiki/Pixel" title="Pixel">pixel</a>-accurate web browsing environment and it is powered by <a href="https://en.wikipedia.org/wiki/Safari_(web_browser)" title="Safari (web browser)">Safari</a>. It can be used while developing <a href="https://en.wikipedia.org/wiki/Web_sites" class="mw-redirect" title="Web sites">web sites</a> for the <a href="/wiki/IPhone" title="IPhone">iPhone</a>. It is not an iPhone simulator but instead is designed for web developers who want to create 320 by 480 (or 480 by 320) websites for use with iPhone. iPhoney will only run on <a href="https://en.wikipedia.orghttps://en.wikipedia.org/wiki/OS_X" class="mw-redirect" title="OS X">OS X</a> 10.4.7 or later.</li>
<li><b>BlackBerry Simulator</b> - There are a variety of official BlackBerry simulators available to emulate the functionality of actual BlackBerry products and test how the device software, screen, keyboard and <a href="https://en.wikipedia.org/wiki/Trackwheel" class="mw-redirect" title="Trackwheel">trackwheel</a> will work with application.</li>
<li><b>Windows UI Automation</b> - To test applications that use the Microsoft UI Automation technology, it requires Windows Automation API 3.0. It is pre-installed on Windows 7, Windows Server 2008 R2 and later versions of Windows. On other operating systems, you can install using Windows Update or download it from the <a href="https://en.wikipedia.org/wiki/Microsoft" title="Microsoft">Microsoft</a> Web site.</li>
</ul>
<p>Tools include</p>
<ul>
<li><a href="https://en.wikipedia.orghttps://en.wikipedia.org/wiki/Eggplant_(GUI_testing_tool)" class="mw-redirect" title="Eggplant (GUI testing tool)">eggPlant</a>: A GUI-based automated test tool for mobile app across all operating systems and devices.</li>
<li><a href="https://en.wikipedia.org/wiki/Ranorex" class="mw-redirect" title="Ranorex">Ranorex</a>: Test automation tools for mobile, web and desktop apps.</li>
<li><a href="https://en.wikipedia.org/wiki/Testdroid" title="Testdroid">Testdroid</a>: Real mobile devices and test automation tools for testing mobile and web apps.</li>
</ul>

*****************************

## mobile app architecture/design patterns

Nowadays we have many options when it comes to architecture design patterns:

* [MVC](https://en.wikipedia.org/wiki/Model%E2%80%93view%E2%80%93controller) - Model–view–controller
* [MVP](https://en.wikipedia.org/wiki/Model%E2%80%93view%E2%80%93presenter) - Model–view–presenter
* [MVVM](https://en.wikipedia.org/wiki/Model%E2%80%93view%E2%80%93viewmodel) - Model–view–viewmodel
* [VIPER]() ( for ios)

some artciles which discusses about mobile app architecture patterns:

* [stackoverflow: What are the architectural patterns used in Mobile applications (other than MVC)?](https://stackoverflow.com/questions/18231071/what-are-the-architectural-patterns-used-in-mobile-applications-other-than-mvc)
* [stackoverflow: Mobile Development Architecture & Design Patterns](https://stackoverflow.com/questions/3090791/mobile-development-architecture-design-patterns)
* [Six Design Patterns for Highly Successful Mobile Apps](https://apigee.com/about/blog/technology/six-design-patterns-highly-successful-mobile-apps)
* [Architectural patterns for Mobile Application Development](https://blog.inf.ed.ac.uk/sapm/2014/02/13/architectural-patterns-for-mobile-application-development/)
* [lynda.com course](https://www.lynda.com/Android-tutorials/Android-App-Development-Design-Patterns-Mobile-Architecture/585243-2.html)
* [Architecture Patterns for
Mobile Systems in ResourceConstrained
Environments](https://www.sei.cmu.edu/library/assets/presentations/lewis-saturn2013.pdf)
* [github: android-architecture ](https://github.com/googlesamples/android-architecture)
* [medium : iOS Architecture Patterns](https://medium.com/ios-os-x-development/ios-architecture-patterns-ecba4c38de52) [slides](http://slides.com/borlov/arch/fullscreen#/7)

now lets start exploring subjective topics.. 

***************************
# Native Mobile app Development

## iOS

(my friend for almost 3 years), I like the design part of ios.

 | HackerNews       | Medium         | Reddit  |  Quora-QA  | Stack-Overflow-QA | Awesome-gh | Online-Courses (lynda.com) | Official docs|
| ------------- |:-------------:| -----:| -----:|-----:|-----:|-----:|-----:|
|  [ios](https://hn.algolia.com/?query=ios%20development&sort=byPopularity&prefix&page=0&dateRange=all&type=story)  | [ios](https://medium.com/tag/ios-app-development)  | [iso](https://www.reddit.com/r/iOSProgramming/)  | [ios](https://www.quora.com/topic/iOS-Application-Development-1)  |  [ios](https://stackoverflow.com/questions/4765451/iphone-app-development-tutorials-beginner)    | [ios](https://github.com/vsouza/awesome-ios)  | [ios](https://www.lynda.com/iOS-training-tutorials/413-0.html) | [ios](https://developer.apple.com/library/content/referencelibrary/GettingStarted/DevelopiOSAppsSwift/) |


<br>

> **brief history of ios**

> In 2005, when Steve Jobs began planning the iPhone, he had a choice to either "shrink the Mac, which would be an epic feat of engineering, or enlarge the iPod". Jobs favored the former approach but pitted the Macintosh and iPod teams, led by Scott Forstall and Tony Fadell, respectively, against each other in an internal competition, with Forstall winning by creating the iPhone OS. The decision enabled the success of the iPhone as a platform for third-party developers: using a well-known desktop operating system as its basis allowed the many third-party Mac developers to write software for the iPhone with minimal retraining. Forstall was also responsible for creating a software development kit for programmers to build iPhone apps, as well as an App Store within iTunes.

> The operating system was unveiled with the iPhone at the Macworld Conference & Expo on January 9, 2007, and released in June of that year. At the time of its unveiling in January, Steve Jobs claimed: "iPhone runs OS X" and runs "desktop applications", but at the time of the iPhone's release, the operating system was renamed "iPhone OS". Initially, third-party native applications were not supported. Jobs' reasoning was that developers could build web applications through the Safari web browser that "would behave like native apps on the iPhone". In October 2007, Apple announced that a native Software Development Kit (SDK) was under development and that they planned to put it "in developers' hands in February". On March 6, 2008, Apple held a press event, announcing the iPhone SDK.

> The iOS App Store was opened on July 10, 2008 with an initial 500 applications available. This quickly grew to 3,000 in September 2008, 15,000 in January 2009, 50,000 in June 2009, 100,000 in November 2009, 250,000 in August 2010, 650,000 in July 2012, 1 million in October 2013, 2 million in June 2016, and 2.2 million in January 2017. As of March 2016, 1 million apps are natively compatible with the iPad tablet computer. These apps have collectively been downloaded more than 130 billion times. App intelligence firm Sensor Tower has estimated that the App Store will reach 5 million apps by the year 2020.

> In September 2007, Apple announced the iPod Touch, a redesigned iPod based on the iPhone form factor. In January 2010, Apple announced the iPad, featuring a larger screen than the iPhone and iPod Touch, and designed for web browsing, media consumption, and reading.

> In June 2010, Apple rebranded iPhone OS as "iOS". The trademark "IOS" had been used by Cisco for over a decade for its operating system, IOS, used on its routers. To avoid any potential lawsuit, Apple licensed the "IOS" trademark from Cisco.

> In October 2016, Apple opened its first iOS Developer Academy in Naples inside University of Naples Federico II's new campus.

> Software updates

> Major versions of iOS are released annually. The current version, iOS 11, was released on September 19, 2017. It is available for all iOS devices with 64-bit processors; the iPhone 5S and later iPhone models, the iPad (2017), the iPad Air and later iPad Air models, all iPad Pro models, the iPad Mini 2 and later iPad Mini models, and the sixth-generation iPod Touch.

> Platform usage as measured by the App Store on September 6, 2017.

>   * iOS 10 (89%)
>   * iOS 9 (9%)
>   * iOS 8 and earlier (2%)
  
> Apple provides major updates to the iOS operating system annually via iTunes and also, for iOS 5 and later, over-the-air. The latest version is iOS 11, released on September 19, 2017. It is available for iPhone 5S and later, iPad Air and later, iPad Pro, iPad Mini 2 and later, and sixth-generation iPod Touch.

> Originally, iPod Touch users had to pay for system software updates. This was due to accounting rules making the device not a "subscription device" like iPhone or Apple TV, and significant enhancements to the device required payments. The requirement to pay to upgrade caused iPod Touch owners to stay away from updates. However, in September 2009, a change in accounting rules won tentative approval, significantly affecting both Apple's earnings and stock price, and allowing iPod Touch updates to be delivered for free.


**iOS versions (source: official doc)**

<br>

![ios_versions](https://github.com/gopala-kr/weekend-with-github/blob/master/Projects-Blogs/04-mobile-dev/ios_versions.JPG)

**************

## list of apple devices and their timelines

<div class="timeline-wrapper"><map name="timeline_f7e71d8726cc09cb584153ec78e053c0" id="timeline_f7e71d8726cc09cb584153ec78e053c0">
<area shape="rect" href="https://en.wikipedia.org/wiki/Apple_Watch_Series_3" coords="1076,1823,1224,1844" title="Apple Watch Series 3" alt="Apple Watch Series 3" />
<area shape="rect" href="https://en.wikipedia.org/wiki/Apple_Watch_Series_3" coords="1076,1803,1224,1824" title="Apple Watch Series 3" alt="Apple Watch Series 3" />
<area shape="rect" href="https://en.wikipedia.org/wiki/Apple_Watch_Series_3" coords="1076,1784,1224,1804" title="Apple Watch Series 3" alt="Apple Watch Series 3" />
<area shape="rect" href="https://en.wikipedia.org/wiki/Apple_Watch_Series_3" coords="1076,1764,1224,1785" title="Apple Watch Series 3" alt="Apple Watch Series 3" />
<area shape="rect" href="https://en.wikipedia.org/wiki/Apple_Watch_Series_2" coords="972,1823,1119,1844" title="Apple Watch Series 2" alt="Apple Watch Series 2" />
<area shape="rect" href="https://en.wikipedia.org/wiki/Apple_Watch_Series_2" coords="972,1803,1119,1824" title="Apple Watch Series 2" alt="Apple Watch Series 2" />
<area shape="rect" href="https://en.wikipedia.org/wiki/Apple_Watch_Series_2" coords="972,1784,1119,1804" title="Apple Watch Series 2" alt="Apple Watch Series 2" />
<area shape="rect" href="https://en.wikipedia.org/wiki/Apple_Watch_Series_2" coords="972,1764,1119,1785" title="Apple Watch Series 2" alt="Apple Watch Series 2" />
<area shape="rect" href="https://en.wikipedia.org/wiki/Apple_Watch" coords="972,1744,1069,1765" title="Apple Watch" alt="Apple Watch" />
<area shape="rect" href="https://en.wikipedia.org/wiki/Apple_Watch" coords="824,1823,921,1844" title="Apple Watch" alt="Apple Watch" />
<area shape="rect" href="https://en.wikipedia.org/wiki/Apple_Watch" coords="824,1784,921,1804" title="Apple Watch" alt="Apple Watch" />
<area shape="rect" href="https://en.wikipedia.org/wiki/Apple_Watch" coords="824,1744,921,1765" title="Apple Watch" alt="Apple Watch" />
<area shape="rect" href="https://en.wikipedia.org/wiki/Apple_TV" coords="1079,1705,1160,1725" title="Apple TV" alt="Apple TV" />
<area shape="rect" href="https://en.wikipedia.org/wiki/Apple_TV" coords="879,1685,959,1705" title="Apple TV" alt="Apple TV" />
<area shape="rect" href="https://en.wikipedia.org/wiki/Apple_TV" coords="588,1665,669,1686" title="Apple TV" alt="Apple TV" />
<area shape="rect" href="https://en.wikipedia.org/wiki/Apple_TV" coords="494,1645,574,1666" title="Apple TV" alt="Apple TV" />
<area shape="rect" href="https://en.wikipedia.org/wiki/Apple_TV" coords="334,1645,414,1666" title="Apple TV" alt="Apple TV" />
<area shape="rect" href="https://en.wikipedia.org/wiki/iPad_Mini_4" coords="864,1546,961,1567" title="iPad Mini 4" alt="iPad Mini 4" />
<area shape="rect" href="https://en.wikipedia.org/wiki/iPad_Mini_3" coords="772,1546,869,1567" title="iPad Mini 3" alt="iPad Mini 3" />
<area shape="rect" href="https://en.wikipedia.org/wiki/iPad_Mini_2" coords="672,1467,769,1488" title="iPad Mini 2" alt="iPad Mini 2" />
<area shape="rect" href="https://en.wikipedia.org/wiki/iPad_Mini_(1st_generation)" coords="563,1447,677,1468" title="iPad Mini (1st generation)" alt="iPad Mini (1st generation)" />
<area shape="rect" href="https://en.wikipedia.org/wiki/iPad_Pro" coords="1048,1368,1156,1389" title="iPad Pro" alt="iPad Pro" />
<area shape="rect" href="https://en.wikipedia.org/wiki/iPad_Pro" coords="1048,1230,1156,1251" title="iPad Pro" alt="iPad Pro" />
<area shape="rect" href="https://en.wikipedia.org/wiki/iPad_Pro" coords="923,1309,1004,1330" title="iPad Pro" alt="iPad Pro" />
<area shape="rect" href="https://en.wikipedia.org/wiki/iPad_Pro" coords="882,1210,963,1231" title="iPad Pro" alt="iPad Pro" />
<area shape="rect" href="https://en.wikipedia.org/wiki/iPad_Air_2" coords="772,1131,863,1152" title="iPad Air 2" alt="iPad Air 2" />
<area shape="rect" href="https://en.wikipedia.org/wiki/iPad_Air" coords="668,1052,749,1073" title="iPad Air" alt="iPad Air" />
<area shape="rect" href="https://en.wikipedia.org/wiki/iPad_(4th_generation)" coords="563,1052,633,1073" title="iPad (4th generation)" alt="iPad (4th generation)" />
<area shape="rect" href="https://en.wikipedia.org/wiki/iPad_(3rd_generation)" coords="496,1052,566,1073" title="iPad (3rd generation)" alt="iPad (3rd generation)" />
<area shape="rect" href="https://en.wikipedia.org/wiki/iPad_(2nd_generation)" coords="389,1032,459,1053" title="iPad (2nd generation)" alt="iPad (2nd generation)" />
<area shape="rect" href="https://en.wikipedia.org/wiki/iPad_(1st_generation)" coords="290,1032,376,1053" title="iPad (1st generation)" alt="iPad (1st generation)" />
<area shape="rect" href="https://en.wikipedia.org/wiki/iPod_Touch_(6th_generation)" coords="848,914,967,934" title="iPod Touch (6th generation)" alt="iPod Touch (6th generation)" />
<area shape="rect" href="https://en.wikipedia.org/wiki/iPod_Touch_(5th_generation)" coords="624,914,760,934" title="iPod Touch (5th generation)" alt="iPod Touch (5th generation)" />
<area shape="rect" href="https://en.wikipedia.org/wiki/iPod_Touch_(5th_generation)" coords="557,953,676,974" title="iPod Touch (5th generation)" alt="iPod Touch (5th generation)" />
<area shape="rect" href="https://en.wikipedia.org/wiki/iPod_Touch%23Models" coords="334,894,453,914" title="iPod Touch#Models" alt="iPod Touch#Models" />
<area shape="rect" href="https://en.wikipedia.org/wiki/iPod_Touch%23Models" coords="231,933,350,954" title="iPod Touch#Models" alt="iPod Touch#Models" />
<area shape="rect" href="https://en.wikipedia.org/wiki/iPod_Touch%23Models" coords="231,894,356,914" title="iPod Touch#Models" alt="iPod Touch#Models" />
<area shape="rect" href="https://en.wikipedia.org/wiki/iPod_Touch%23Models" coords="125,894,250,914" title="iPod Touch#Models" alt="iPod Touch#Models" />
<area shape="rect" href="https://en.wikipedia.org/wiki/iPod_Touch%23Models" coords="18,894,138,914" title="iPod Touch#Models" alt="iPod Touch#Models" />
<area shape="rect" href="https://en.wikipedia.org/wiki/iPhone_X" coords="1091,834,1172,855" title="iPhone X" alt="iPhone X" />
<area shape="rect" href="https://en.wikipedia.org/wiki/iPhone_8" coords="1079,795,1188,816" title="iPhone 8" alt="iPhone 8" />
<area shape="rect" href="https://en.wikipedia.org/wiki/iPhone_8" coords="1079,755,1160,776" title="iPhone 8" alt="iPhone 8" />
<area shape="rect" href="https://en.wikipedia.org/wiki/iPhone_7" coords="1027,716,1135,736" title="iPhone 7" alt="iPhone 7" />
<area shape="rect" href="https://en.wikipedia.org/wiki/iPhone_7" coords="1076,656,1185,677" title="iPhone 7" alt="iPhone 7" />
<area shape="rect" href="https://en.wikipedia.org/wiki/iPhone_7" coords="972,597,1080,618" title="iPhone 7" alt="iPhone 7" />
<area shape="rect" href="https://en.wikipedia.org/wiki/iPhone_7" coords="1027,558,1107,578" title="iPhone 7" alt="iPhone 7" />
<area shape="rect" href="https://en.wikipedia.org/wiki/iPhone_7" coords="1076,498,1157,519" title="iPhone 7" alt="iPhone 7" />
<area shape="rect" href="https://en.wikipedia.org/wiki/iPhone_7" coords="972,439,1053,460" title="iPhone 7" alt="iPhone 7" />
<area shape="rect" href="https://en.wikipedia.org/wiki/iPhone_SE" coords="923,142,1009,163" title="iPhone SE" alt="iPhone SE" />
<area shape="rect" href="https://en.wikipedia.org/wiki/iPhone_6S" coords="869,360,983,380" title="iPhone 6S" alt="iPhone 6S" />
<area shape="rect" href="https://en.wikipedia.org/wiki/iPhone_6S" coords="869,281,955,301" title="iPhone 6S" alt="iPhone 6S" />
<area shape="rect" href="https://en.wikipedia.org/wiki/iPhone_6_Plus" coords="762,221,870,242" title="iPhone 6 Plus" alt="iPhone 6 Plus" />
<area shape="rect" href="https://en.wikipedia.org/wiki/iPhone_6" coords="762,63,842,84" title="iPhone 6" alt="iPhone 6" />
<area shape="rect" href="https://en.wikipedia.org/wiki/iPhone_5S" coords="656,142,742,163" title="iPhone 5S" alt="iPhone 5S" />
<area shape="rect" href="https://en.wikipedia.org/wiki/iPhone_5C" coords="656,63,742,84" title="iPhone 5C" alt="iPhone 5C" />
<area shape="rect" href="https://en.wikipedia.org/wiki/iPhone_5" coords="551,142,632,163" title="iPhone 5" alt="iPhone 5" />
<area shape="rect" href="https://en.wikipedia.org/wiki/iPhone_4S" coords="452,63,538,84" title="iPhone 4S" alt="iPhone 4S" />
<area shape="rect" href="https://en.wikipedia.org/wiki/iPhone_4" coords="314,63,395,84" title="iPhone 4" alt="iPhone 4" />
<area shape="rect" href="https://en.wikipedia.org/wiki/iPhone_3GS" coords="207,63,265,84" title="iPhone 3GS" alt="iPhone 3GS" />
<area shape="rect" href="https://en.wikipedia.org/wiki/iPhone_3GS" coords="314,24,406,44" title="iPhone 3GS" alt="iPhone 3GS" />
<area shape="rect" href="https://en.wikipedia.org/wiki/iPhone_3G" coords="108,142,161,163" title="iPhone 3G" alt="iPhone 3G" />
<area shape="rect" href="https://en.wikipedia.org/wiki/iPhone_3G" coords="108,24,194,44" title="iPhone 3G" alt="iPhone 3G" />
<area shape="rect" href="https://en.wikipedia.org/wiki/iPhone_(1st_generation)" coords="0,24,118,44" title="iPhone (1st generation)" alt="iPhone (1st generation)" /></map><img usemap="#timeline_f7e71d8726cc09cb584153ec78e053c0" src="https://upload.wikimedia.org/wikipedia/en/timeline/f7e71d8726cc09cb584153ec78e053c0.png" /></div>
<div style="text-align:center;font-size:88%;font-style:italic">Sources: <a href="https://en.wikipedia.org/wiki/Apple_Inc." title="Apple Inc.">Apple</a> press release library, <a href="https://en.wikipedia.org/wiki/Mactracker" title="Mactracker">Mactracker</a> Apple Inc. model database</div>

<br>

**************
## iOS Technologies

iOS is the operating system that runs on iPad, iPhone, and iPod touch devices. The operating system manages the device hardware and provides the technologies required to implement native apps. The operating system also ships with various system apps, such as Phone, Mail, and Safari, that provide standard system services to the user.

The iOS Software Development Kit (SDK) contains the tools and interfaces needed to develop, install, run, and test native apps that appear on an iOS device’s Home screen. Native apps are built using the iOS system frameworks and Objective-C language and run directly on iOS. Unlike web apps, native apps are installed physically on a device and are therefore always available to the user, even when the device is in Airplane mode. They reside next to other system apps, and both the app and any user data is synced to the user’s computer through iTunes.

> The iOS SDK provides the resources you need to develop native iOS apps.


The iOS Architecture Is Layered and it looks very simple as compared to android at high level abstraction

At the highest level, iOS acts as an intermediary between the underlying hardware and the apps you create. Apps do not talk to the underlying hardware directly. Instead, they communicate with the hardware through a set of well-defined system interfaces. These interfaces make it easy to write apps that work consistently on devices having different hardware capabilities.

The implementation of iOS technologies can be viewed as a set of layers. Lower layers contain fundamental services and technologies. Higher-level layers build upon the lower layers and provide more sophisticated services and technologies.

![layered architecture](https://developer.apple.com/library/content/documentation/Miscellaneous/Conceptual/iPhoneOSTechOverview/Art/SystemLayers_2x.png)


### Core OS Layer

The Core OS layer contains the low-level features that most other technologies are built upon. Even if you do not use these technologies directly in your apps, they are most likely being used by other frameworks. And in situations where you need to explicitly deal with security or communicating with an external hardware accessory, you do so using the frameworks in this layer.

more on [Core OS Layer](https://developer.apple.com/library/content/documentation/Miscellaneous/Conceptual/iPhoneOSTechOverview/CoreOSLayer/CoreOSLayer.html#//apple_ref/doc/uid/TP40007898-CH11-SW1)

### Core Services Layer

The Core Services layer contains fundamental system services for apps. Key among these services are the Core Foundation and Foundation frameworks, which define the basic types that all apps use. This layer also contains individual technologies to support features such as location, iCloud, social media, and networking.


more on [Core Services Layer from official doc](https://developer.apple.com/library/content/documentation/Miscellaneous/Conceptual/iPhoneOSTechOverview/CoreServicesLayer/CoreServicesLayer.html#//apple_ref/doc/uid/TP40007898-CH10-SW5)

### Media Layer

The Media layer contains the graphics, audio, and video technologies you use to implement multimedia experiences in your apps. The technologies in this layer make it easy for you to build apps that look and sound great.

more details from official doc [Media Layer](https://developer.apple.com/library/content/documentation/Miscellaneous/Conceptual/iPhoneOSTechOverview/MediaLayer/MediaLayer.html#//apple_ref/doc/uid/TP40007898-CH9-SW4)

### Cocoa Touch Layer

The Cocoa Touch layer contains key frameworks for building iOS apps. These frameworks define the appearance of your app. They also provide the basic app infrastructure and support for key technologies such as multitasking, touch-based input, push notifications, and many high-level system services. When designing your apps, you should investigate the technologies in this layer first to see if they meet your needs.

more details from official doc [Cocoa Touch Layer](https://developer.apple.com/library/content/documentation/Miscellaneous/Conceptual/iPhoneOSTechOverview/iPhoneOSTechnologies/iPhoneOSTechnologies.html#//apple_ref/doc/uid/TP40007898-CH3-SW1)


### Required developmenet tools & pre-requesites

* Should have hands on knowledge on Objective C and Swift

* Development of iOS apps requires an Intel-based Macintosh computer with the iOS SDK installed. For information about how to get the iOS SDK, go to the [iOS Dev Center](https://developer.apple.com/download/)

![xcode](https://github.com/gopala-kr/weekend-with-github/blob/master/Projects-Blogs/04-mobile-dev/xcode.JPG)

<br>

[Basic programming concepts from official guide](https://developer.apple.com/library/content/documentation/iPhone/Conceptual/iPhoneOSProgrammingGuide/Introduction/Introduction.html#//apple_ref/doc/uid/TP40007072-CH1-SW1)

************

<h3 id="pageTitle">iOS App Life Cycle</h3>

<section>
    <h4 class="jump">The Structure of an App</h4>
    <figure class="figure">
        <a name="//apple_ref/doc/uid/TP40007072-CH2-SW4" title="Key objects in an iOS app"></a>
<img src="https://developer.apple.com/library/content/documentation/iPhone/Conceptual/iPhoneOSProgrammingGuide/Art/core_objects_2x.png" alt="" width="521" height="458"></figure>
    <a name="//apple_ref/doc/uid/TP40007072-CH2-SW5" title="The role of objects in an iOS app"></a>
    <div class="tableholder">
        <table class="graybox" border="0" cellspacing="0" cellpadding="5">
            <caption class="tablecaption"><strong class="caption_number"></strong>&nbsp;&nbsp;The role of objects in an iOS app</caption>
            <tr>
                <th scope="col" class="TableHeading_TableRow_TableCell">
                    <p>Object</p>
                </th>
                <th scope="col" class="TableHeading_TableRow_TableCell">
                    <p>Description</p>
                </th>
            </tr>
            <tr>
                <td scope="row">
                    <p><code><a href="https://developer.apple.com/documentation/uikit/uiapplication" target="_self" class="urlLink">UIApplication</a></code> object</p>
                </td>
                <td>
                    <p>The <code>UIApplication</code> object manages the event loop and other high-level app behaviors. It also reports key app transitions and some special events (such as incoming push notifications) to its delegate, which is a custom object you define. Use the <code>UIApplication</code> object as is—that is, without subclassing. </p>
                </td>
            </tr>
            <tr>
                <td scope="row">
                    <p><span class="pediaLink" data-header="Delegation" data-contents="Delegation is a simple and powerful pattern in which one object in a program acts on behalf of, or in coordination with, another object. "><a href="../../../../General/Conceptual/DevPedia-CocoaCore/Delegation.html#//apple_ref/doc/uid/TP40008195-CH14" data-renderer-version="1" target="_self">App delegate</a></span> object</p>
                </td>
                <td>
                    <p>The app delegate is the heart of your custom code. This object works in tandem with the <code>UIApplication</code> object to handle app initialization, state transitions, and many high-level app events. This object is also the only one guaranteed to be present in every app, so it is often used to set up the app’s initial data structures.</p>
                </td>
            </tr>
            <tr>
                <td scope="row">
                    <p>Documents and data model objects</p>
                </td>
                <td>
                    <p><em class="newTerm">Data model objects</em> store your app’s content and are specific to your app. For example, a banking app might store a database containing financial transactions, whereas a painting app might store an image object or even the sequence of drawing commands that led to the creation of that image. (In the latter case, an image object is still a data object because it is just a container for the image data.)</p>
                    <p>Apps can also use <em class="newTerm">document objects</em> (custom subclasses of <code><a href="https://developer.apple.com/documentation/uikit/uidocument" target="_self" class="urlLink">UIDocument</a></code>) to manage some or all of their data model objects. Document objects are not required but offer a convenient way to group data that belongs in a single file or file package. For more information about documents, see <em><a href="../../../../DataManagement/Conceptual/DocumentBasedAppPGiOS/Introduction/Introduction.html#//apple_ref/doc/uid/TP40011149" data-renderer-version="1" target="_self">Document-Based App Programming Guide for iOS</a></em>. </p>
                </td>
            </tr>
            <tr>
                <td scope="row">
                    <p>View controller objects</p>
                </td>
                <td>
                    <p><em class="newTerm">View controller objects</em> manage the presentation of your app’s content on screen. A view controller manages a single view and its collection of subviews. When presented, the view controller makes its views visible by installing them in the app’s window. </p>
                    <p>The <code><a href="https://developer.apple.com/documentation/uikit/uiviewcontroller" target="_self" class="urlLink">UIViewController</a></code> class is the base class for all view controller objects. It provides default functionality for loading views, presenting them, rotating them in response to device rotations, and several other standard system behaviors. UIKit and other frameworks define additional view controller classes to implement standard system interfaces such as the image picker, tab bar interface, and navigation interface.</p>
                    <p>For detailed information about how to use view controllers, see <em><a href="../../../../../featuredarticles/ViewControllerPGforiPhoneOS/index.html#//apple_ref/doc/uid/TP40007457" data-renderer-version="2" target="_self">View Controller Programming Guide for iOS</a></em>.</p>
                </td>
            </tr>
            <tr>
                <td scope="row">
                    <p><code><a href="https://developer.apple.com/documentation/uikit/uiwindow" target="_self" class="urlLink">UIWindow</a></code> object</p>
                </td>
                <td>
                    <p>A <code><a href="https://developer.apple.com/documentation/uikit/uiwindow" target="_self" class="urlLink">UIWindow</a></code> object coordinates the presentation of one or more views on a screen. Most apps have only one window, which presents content on the main screen, but apps may have an additional window for content displayed on an external display. </p>
                    <p>To change the content of your app, you use a view controller to change the views displayed in the corresponding window. You never replace the window itself. </p>
                    <p>In addition to hosting views, windows work with the <code>UIApplication</code> object to deliver events to your views and view controllers.</p>
                </td>
            </tr>
            <tr>
                <td scope="row">
                    <p><span class="pediaLink" data-header="View object" data-contents="A view is an object that draws itself within a rectangular area of a window and that can respond to user actions such as finger taps or mouse clicks. "><a href="../../../../General/Conceptual/Devpedia-CocoaApp/ViewObject.html#//apple_ref/doc/uid/TP40009071-CH5" data-renderer-version="1" target="_self">View objects</a></span>, <span class="pediaLink" data-header="Control object" data-contents="A control is a type of view in a user interface that sends a message to another object when a user manipulates it in a certain way, such as tapping a button or dragging a slider. "><a href="../../../../General/Conceptual/Devpedia-CocoaApp/Control.html#//apple_ref/doc/uid/TP40009071-CH7" data-renderer-version="1" target="_self">control objects</a></span>, and layer objects</p>
                </td>
                <td>
                    <p>Views and controls provide the visual representation of your app’s content. A <em class="newTerm">view</em> is an object that draws content in a designated rectangular area and responds to events within that area. <em class="newTerm">Controls</em> are a specialized type of view responsible for implementing familiar interface objects such as buttons, text fields, and toggle switches. </p>
                    <p>The UIKit framework provides standard views for presenting many different types of content. You can also define your own custom views by subclassing <code><a href="https://developer.apple.com/documentation/uikit/uiview" target="_self" class="urlLink">UIView</a></code> (or its descendants) directly. </p>
                    <p>In addition to incorporating views and controls, apps can also incorporate Core Animation layers into their view and control hierarchies. <em class="newTerm">Layer objects</em> are actually data objects that represent visual content. Views use layer objects intensively behind the scenes to render their content. You can also add custom layer objects to your interface to implement complex animations and other types of sophisticated visual effects. </p>
                </td>
            </tr>
        </table>
    </div>
</section>

<section>
    <h4 class="jump">The Main Run Loop</h4>
    <figure class="figure">
        <a name="//apple_ref/doc/uid/TP40007072-CH2-SW15" title="Processing events in the main run loop"></a>
<img src="https://developer.apple.com/library/content/documentation/iPhone/Conceptual/iPhoneOSProgrammingGuide/Art/event_draw_cycle_a_2x.png" alt="Processing events in the main run loop" width="608" height="406"></figure>
    <a name="//apple_ref/doc/uid/TP40007072-CH2-SW16" title="Common types of events for iOS apps"></a>
    <div class="tableholder">
        <table class="graybox" border="0" cellspacing="0" cellpadding="5">
            <caption class="tablecaption"><strong class="caption_number"></strong>&nbsp;&nbsp;Common types of events for iOS apps</caption>
            <tr>
                <th scope="col" class="TableHeading_TableRow_TableCell">
                    <p>Event type</p>
                </th>
                <th scope="col" class="TableHeading_TableRow_TableCell">
                    <p>Delivered to…</p>
                </th>
                <th scope="col" class="TableHeading_TableRow_TableCell">
                    <p>Notes</p>
                </th>
            </tr>
            <tr>
                <td scope="row">
                    <p>Touch</p>
                </td>
                <td>
                    <p>The view object in which the event occurred</p>
                </td>
                <td>
                    <p>Views are responder objects. Any touch events not handled by the view are forwarded down the responder chain for processing.</p>
                </td>
            </tr>
            <tr>
                <td scope="row">
                    <p>Remote control</p>
                    <p>Shake motion events</p>
                </td>
                <td>
                    <p>First <span class="pediaLink" data-header="Responder object" data-contents="A responder is an object that can respond to events and handle them. "><a href="../../../../General/Conceptual/Devpedia-CocoaApp/Responder.html#//apple_ref/doc/uid/TP40009071-CH1" data-renderer-version="1" target="_self">responder object</a></span></p>
                </td>
                <td>
                    <p>Remote control events are for controlling media playback and are generated by headphones and other accessories.</p>
                </td>
            </tr>
            <tr>
                <td scope="row">
                    <p>Accelerometer</p>
                    <p>Magnetometer</p>
                    <p>Gyroscope</p>
                </td>
                <td>
                    <p>The object you designate</p>
                </td>
                <td>
                    <p>Events related to the accelerometer, magnetometer, and gyroscope hardware are delivered to the object you designate. </p>
                </td>
            </tr>
            <tr>
                <td scope="row">
                    <p>Location</p>
                </td>
                <td>
                    <p>The object you designate</p>
                </td>
                <td>
                    <p>You register to receive location events using the Core Location framework. For more information about using Core Location, see <em><a href="../../../../UserExperience/Conceptual/LocationAwarenessPG/Introduction/Introduction.html#//apple_ref/doc/uid/TP40009497" data-renderer-version="1" target="_self">Location and Maps Programming Guide</a></em>. </p>
                </td>
            </tr>
            <tr>
                <td scope="row">
                    <p>Redraw</p>
                </td>
                <td>
                    <p>The view that needs the update</p>
                </td>
                <td>
                    <p>Redraw events do not involve an event object but are simply calls to the view to draw itself. The drawing architecture for iOS is described in <em><a href="../../../../2DDrawing/Conceptual/DrawingPrintingiOS/Introduction/Introduction.html#//apple_ref/doc/uid/TP40010156" data-renderer-version="1" target="_self">Drawing and Printing Guide for iOS</a></em>. </p>
                </td>
            </tr>
        </table>
    </div>
</section>
<section>
    <a name=""></a>
    <h4 class="jump">Execution States for Apps</h4>
    <a name="//apple_ref/doc/uid/TP40007072-CH2-SW19" title="App states"></a>
    <div class="tableholder">
        <table class="graybox" border="0" cellspacing="0" cellpadding="5">
            <tr>
                <th scope="col" class="TableHeading_TableRow_TableCell">
                    <p>State</p>
                </th>
                <th scope="col" class="TableHeading_TableRow_TableCell">
                    <p>Description</p>
                </th>
            </tr>
            <tr>
                <td scope="row">
                    <p>Not running</p>
                </td>
                <td>
                    <p>The app has not been launched or was running but was terminated by the system. </p>
                </td>
            </tr>
            <tr>
                <td scope="row">
                    <p>Inactive</p>
                </td>
                <td>
                    <p>The app is running in the foreground but is currently not receiving events. (It may be executing other code though.) An app usually stays in this state only briefly as it transitions to a different state.</p>
                </td>
            </tr>
            <tr>
                <td scope="row">
                    <p>Active</p>
                </td>
                <td>
                    <p>The app is running in the foreground and is receiving events. This is the normal mode for foreground apps.</p>
                </td>
            </tr>
            <tr>
                <td scope="row">
                    <p>Background</p>
                </td>
                <td>
                    <p>The app is in the background and executing code. Most apps enter this state briefly on their way to being suspended. However, an app that requests extra execution time may remain in this state for a period of time. In addition, an app being launched directly into the background enters this state instead of the inactive state. For information about how to execute code while in the background, see <span class="content_text"><a href="../BackgroundExecution/BackgroundExecution.html#//apple_ref/doc/uid/TP40007072-CH4-SW1" data-renderer-version="1">Background Execution</a></span>. </p>
                </td>
            </tr>
            <tr>
                <td scope="row">
                    <p>Suspended</p>
                </td>
                <td>
                    <p>The app is in the background but is not executing code. The system moves apps to this state automatically and does not notify them before doing so. While suspended, an app remains in memory but does not execute any code.</p>
                    <p>When a low-memory condition occurs, the system may purge suspended apps without notice to make more space for the foreground app. </p>
                </td>
            </tr>
        </table>
    </div>
    <figure class="figure">
        <a name="https://developer.apple.com/library/content/documentation/iPhone/Conceptual/iPhoneOSProgrammingGuide/Art/high_level_flow_2x.png" title="State changes in an iOS app"></a>
        <figcaption><strong class="caption_number"></strong>&nbsp;&nbsp;State changes in an iOS app</figcaption><img src="https://developer.apple.com/library/content/documentation/iPhone/Conceptual/iPhoneOSProgrammingGuide/Art/high_level_flow_2x.png" alt="" width="348" height="418"></figure>
    <ul class="ul">
        <li class="li">
            <p><code><a href="https://developer.apple.com/documentation/uikit/uiapplicationdelegate/1623032-application" target="_self" class="urlLink">application:willFinishLaunchingWithOptions:</a></code>—This method is your app’s first chance to execute code at launch time. </p>
        </li>
        <li class="li">
            <p><code><a href="https://developer.apple.com/documentation/uikit/uiapplicationdelegate/1622921-application" target="_self" class="urlLink">application:didFinishLaunchingWithOptions:</a></code>—This method allows you to perform any final initialization before your app is displayed to the user.</p>
        </li>
        <li class="li">
            <p><code><a href="https://developer.apple.com/documentation/uikit/uiapplicationdelegate/1622956-applicationdidbecomeactive" target="_self" class="urlLink">applicationDidBecomeActive:</a></code>—Lets your app know that it is about to become the foreground app. Use this method for any last minute preparation. </p>
        </li>
        <li class="li">
            <p><code><a href="https://developer.apple.com/documentation/uikit/uiapplicationdelegate/1622950-applicationwillresignactive" target="_self" class="urlLink">applicationWillResignActive:</a></code>—Lets you know that your app is transitioning away from being the foreground app. Use this method to put your app into a quiescent state. </p>
        </li>
        <li class="li">
            <p><code><a href="https://developer.apple.com/documentation/uikit/uiapplicationdelegate/1622997-applicationdidenterbackground" target="_self" class="urlLink">applicationDidEnterBackground:</a></code>—Lets you know that your app is now running in the background and may be suspended at any time.</p>
        </li>
        <li class="li">
            <p><code><a href="https://developer.apple.com/documentation/uikit/uiapplicationdelegate/1623076-applicationwillenterforeground" target="_self" class="urlLink">applicationWillEnterForeground:</a></code>—Lets you know that your app is moving out of the background and back into the foreground, but that it is not yet active. </p>
        </li>
        <li class="li">
            <p><code><a href="https://developer.apple.com/documentation/uikit/uiapplicationdelegate/1623111-applicationwillterminate" target="_self" class="urlLink">applicationWillTerminate:</a></code>—Lets you know that your app is being terminated. This method is not called if your app is suspended. </p>
        </li>
    </ul>
</section>


****************
## Android

I used it rarely.. but my long term friend(almost 5+ years).. which has always been basis for my sofware understandings. my first java program on eclipse was android 'Hello-world' simulated on dalvik emulator and deployed on jelly beans version of friend's mobile(biggest achievement). I had done a self case study on adroid software layers as part of my academic OS course.

 | HackerNews        | Medium         | Reddit  |  Quora-QA  | Stack-Overflow-QA | Awesome-gh | Online-Courses (lynda.com) | Official docs|
| ------------- |:-------------:| -----:| -----:|-----:|-----:|-----:|-----:|
|  [android development](https://hn.algolia.com/?query=android%20development&sort=byPopularity&prefix=false&page=0&dateRange=all&type=story)  | [android development](https://medium.com/tag/android-app-development)   | [android development](https://www.reddit.com/r/androiddev/)  | [android development](https://stackoverflow.com/questions/tagged/android)   |  [android development](https://www.quora.com/topic/Android-Application-Development)     | [android development](https://github.com/JStumpp/awesome-android)   | [android development](https://www.lynda.com/Android-training-tutorials/947-0.html)   | [android development](https://developer.android.com/reference/packages.html)   |

<br>

> **brief history of android**

> Android Inc. was founded in Palo Alto, California in October 2003 by Andy Rubin, Rich Miner, Nick Sears, and Chris White. Rubin described the Android project as "tremendous potential in developing smarter mobile devices that are more aware of its owner's location and preferences".The early intentions of the company were to develop an advanced operating system for digital cameras, and this was the basis of its pitch to investors in April 2004. The company then decided that the market for cameras was not large enough for its goals, and by five months later it had diverted its efforts and was pitching Android as a handset operating system that would rival Symbian and Microsoft Windows Mobile.

> Rubin had difficulty attracting investors early on, and Android was facing eviction from its office space. Steve Perlman, a close friend of Rubin, brought him $10,000 in cash in an envelope, and shortly thereafter wired an undisclosed amount as seed funding. Perlman refused a stake in the company, and has stated "I did it because I believed in the thing, and I wanted to help Andy."

> In July 2005, Google acquired Android Inc. for at least $50 million. Its key employees, including Rubin, Miner and White, joined Google as part of the acquisition. Not much was known about the secretive Android at the time, with the company having provided few details other than that it was making software for mobile phones.At Google, the team led by Rubin developed a mobile device platform powered by the Linux kernel. Google marketed the platform to handset makers and carriers on the promise of providing a flexible, upgradeable system. Google had "lined up a series of hardware components and software partners and signaled to carriers that it was open to various degrees of cooperation".

> Speculation about Google's intention to enter the mobile communications market continued to build through December 2006. An early prototype had a close resemblance to a BlackBerry phone, with no touchscreen and a physical QWERTY keyboard, but the arrival of 2007's Apple iPhone meant that Android "had to go back to the drawing board". Google later changed its Android specification documents to state that "Touchscreens will be supported", although "the Product was designed with the presence of discrete physical buttons as an assumption, therefore a touchscreen cannot completely replace physical buttons". In September 2007, InformationWeek covered an Evalueserve study reporting that Google had filed several patent applications in the area of mobile telephony.


> Eric Schmidt, Andy Rubin and Hugo Barra at a 2012 press conference announcing Google's Nexus 7 tablet
On November 5, 2007, the Open Handset Alliance, a consortium of technology companies including Google, device manufacturers such as HTC, Motorola and Samsung, wireless carriers such as Sprint and T-Mobile, and chipset makers such as Qualcomm and Texas Instruments, unveiled itself, with a goal to develop "the first truly open and comprehensive platform for mobile devices". The first commercially available smartphone running Android was the HTC Dream, also known as T-Mobile G1, announced on September 23, 2008.

> Since 2008, Android has seen numerous updates which have incrementally improved the operating system, adding new features and fixing bugs in previous releases. Each major release is named in alphabetical order after a dessert or sugary treat, with the first few Android versions being called "Cupcake", "Donut", "Eclair", and "Froyo", respectively. During its announcement of Android KitKat in 2013, Google explained that "Since these devices make our lives so sweet, each Android version is named after a dessert", although a Google spokesperson told CNN in an interview that "It’s kind of like an internal team thing, and we prefer to be a little bit — how should I say — a bit inscrutable in the matter, I’ll say".

> In 2010, Google launched its Nexus series of devices, a lineup in which Google partnered with different device manufacturers to produce new devices and introduce new Android versions. The series was described as having "played a pivotal role in Android's history by introducing new software iterations and hardware standards across the board", and became known for its "bloat-free" software with "timely [...] updates". At its developer conference in May 2013, Google announced a special version of the Samsung Galaxy S4, where, instead of using Samsung's own Android customization, the phone ran "stock Android" and was promised to receive new system updates fast. The device would become the start of the Google Play edition program, and was followed by other devices, including the HTC One Google Play edition, and Moto G Google Play edition. In 2015, Ars Technica wrote that "Earlier this week, the last of the Google Play edition Android phones in Google's online storefront were listed as "no longer available for sale"" and that "Now they're all gone, and it looks a whole lot like the program has wrapped up".

> From 2008 to 2013, Hugo Barra served as product spokesperson, representing Android at press conferences and Google I/O, Google’s annual developer-focused conference. He left Google in August 2013 to join Chinese phone maker Xiaomi. Less than six months earlier, Google's then-CEO Larry Page announced in a blog post that Andy Rubin had moved from the Android division to take on new projects at Google, and that Sundar Pichai would become the new Android lead. Pichai himself would eventually switch positions, becoming the new CEO of Google in August 2015 following the company's restructure into the Alphabet conglomerate, making Hiroshi Lockheimer the new head of Android.

> In June 2014, Google announced Android One, a set of "hardware reference models" that would "allow [device makers] to easily create high-quality phones at low costs", designed for consumers in developing countries. In September, Google announced the first set of Android One phones for release in India. However, Recode reported in June 2015 that the project was "a disappointment", citing "reluctant consumers and manufacturing partners" and "misfires from the search company that has never quite cracked hardware". Plans to relaunch Android One surfaced in August 2015, with Africa announced as the next location for the program a week later. A report from The Verge in January 2017 stated that Google is expanding its low-cost Android One program while "Google itself probably won’t produce Android One phones for the US [..]. The phones are reportedly due “before the middle of the year” and will be backed by lots of marketing money from Google."

> Google introduced the Pixel and Pixel XL smartphones in October 2016, marketed as being the first phones made by Google, and exclusively featured certain software features, such as the Google Assistant, before wider rollout. The Pixel phones replaced the Nexus series, with a new generation of Pixel phones launched in October 2017.

<br>


### Android versions and major releases

<br>

<table class="wikitable sortable">
<tr>
<th>Code name</th>
<th>Version number</th>
<th>Initial release date</th>
<th>API level</th>
<th>Security patches</th>
</tr>
<tr>
<td><a href="#Android_1.0_.28API_1.29">(No codename)</a></td>
<td>1.0</td>
<td>September 23, 2008</td>
<td>1</td>
<td>Unsupported</td>
</tr>
<tr>
<td><a href="#Android_1.1_.28API_2.29">(Internally known as "Petit Four")</a></td>
<td>1.1</td>
<td>February 9, 2009</td>
<td>2</td>
<td>Unsupported</td>
</tr>
<tr>
<td><a href="#Android_1.5_Cupcake_.28API_3.29">Cupcake</a></td>
<td>1.5</td>
<td>April 27, 2009</td>
<td>3</td>
<td>Unsupported</td>
</tr>
<tr>
<td><a href="#Android_1.6_Donut_.28API_4.29">Donut</a></td>
<td>1.6</td>
<td>September 15, 2009</td>
<td>4</td>
<td>Unsupported</td>
</tr>
<tr>
<td><a href="#Android_2.0_Eclair_.28API_5.29">Eclair</a></td>
<td>2.0 – 2.1</td>
<td>October 26, 2009</td>
<td>5 – 7</td>
<td>Unsupported</td>
</tr>
<tr>
<td><a href="#Android_2.2_Froyo_.28API_8.29">Froyo</a></td>
<td>2.2 – 2.2.3</td>
<td>May 20, 2010</td>
<td>8</td>
<td>Unsupported</td>
</tr>
<tr>
<td><a href="#Android_2.3_Gingerbread_.28API_9.29">Gingerbread</a></td>
<td>2.3 – 2.3.7</td>
<td>December 6, 2010</td>
<td>9 – 10</td>
<td>Unsupported</td>
</tr>
<tr>
<td><a href="#Android_3.0_Honeycomb_.28API_11.29">Honeycomb</a></td>
<td>3.0 – 3.2.6</td>
<td>February 22, 2011</td>
<td>11 – 13</td>
<td>Unsupported</td>
</tr>
<tr>
<td><a href="#Android_4.0_Ice_Cream_Sandwich_.28API_14.29">Ice Cream Sandwich</a></td>
<td>4.0 – 4.0.4</td>
<td>October 18, 2011</td>
<td>14 – 15</td>
<td>Unsupported</td>
</tr>
<tr>
<td><a href="#Android_4.1_Jelly_Bean_.28API_16.29">Jelly Bean</a></td>
<td>4.1 – 4.3.1</td>
<td>July 9, 2012</td>
<td>16 – 18</td>
<td>Unsupported</td>
</tr>
<tr>
<td><a href="#Android_4.4_KitKat_.28API_19.29">KitKat</a></td>
<td>4.4 – 4.4.4</td>
<td>October 31, 2013</td>
<td>19 – 20</td>
<td>Supported; <small>See <a href="/wiki/Android_KitKat#Support_status" title="Android KitKat">clarification</a></small></td>
</tr>
<tr>
<td><a href="#Android_5.0_Lollipop_.28API_21.29">Lollipop</a></td>
<td>5.0 – 5.1.1</td>
<td>November 12, 2014</td>
<td>21 – 22</td>
<td>Supported</td>
</tr>
<tr>
<td><a href="#Android_6.0_Marshmallow_.28API_23.29">Marshmallow</a></td>
<td>6.0 – 6.0.1</td>
<td>October 5, 2015</td>
<td>23</td>
<td>Supported</td>
</tr>
<tr>
<td><a href="#Android_7.0_Nougat_.28API_24.29">Nougat</a></td>
<td>7.0 – 7.1.2</td>
<td>August 22, 2016</td>
<td>24 – 25</td>
<td>Supported</td>
</tr>
<tr>
<td><a href="#Android_8.0_Oreo_.28API_26.29"><b>Oreo</b></a></td>
<td><b>8.0</b></td>
<td><b>August 21, 2017</b></td>
<td><b>26</b></td>
<td><b>Supported</b></td>
</tr>
</table>

<br>
<br>

Global Android version distribution as of August 2017. Android Marshmallow is the most widely used version of Android, running on 32.2% of all Android devices accessing Google Play, while Android Lollipop runs on 29.8% of devices (76.8% on it or newer).

<br>

![Global Android version distribution as of August 2017](https://upload.wikimedia.org/wikipedia/commons/5/5e/Android_Version_Usage.png)

<br>

## Android Software Stack

<p>
  Android is an open source, Linux-based software stack created for a wide
  array of devices and form factors. The following diagram shows the major
  components of the Android platform.
</p>

<img src="https://developer.android.com/guide/platform/images/android-stack_2x.png" alt="" width=
"519">
<p class="img-caption">
  <strong></strong> The Android software stack.
</p>

<h3 id="linux-kernel">
The Linux Kernel
</h3>

<p>
  The foundation of the Android platform is the Linux kernel. For example,
  <a href="#art">the Android Runtime (ART)</a> relies on the Linux kernel for
  underlying functionalities such as threading and low-level memory management.
</p>

<p>
  Using a Linux kernel allows Android to take advantage of <a href="https://source.android.com/security/overview/kernel-security.html">key
  security features</a> and allows device manufacturers to develop hardware
  drivers for a well-known kernel.
</p>

<h3 id="hal">
Hardware Abstraction Layer (HAL)
</h3>

<p>
  The <a href="https://source.android.com/devices/index.html#Hardware%20Abstraction%20Layer">
  hardware abstraction layer (HAL)</a> provides standard interfaces that expose
  device hardware capabilities to the higher-level <a href="#api-framework">Java API framework</a>. The HAL consists of multiple library
  modules, each of which implements an interface for a specific type of hardware
  component, such as the <a href="https://source.android.com/devices/camera/index.html">camera</a> or <a href="https://source.android.com/devices/bluetooth.html">bluetooth</a> module.
  When a framework API makes a call to access device hardware, the Android
  system loads the library module for that hardware component.
</p>

<h3 id="art">
Android Runtime
</h3>

<p>
  For devices running Android version 5.0 (API level 21) or higher, each app
  runs in its own process and with its own instance of the <a href="http://source.android.com/devices/tech/dalvik/index.html">Android Runtime
  (ART)</a>. ART is written to run multiple virtual machines on low-memory
  devices by executing DEX files, a bytecode format designed specially for
  Android that's optimized for minimal memory footprint. Build toolchains, such
  as <a href="https://source.android.com/source/jack.html">Jack</a>, compile
  Java sources into DEX bytecode, which can run on the Android platform.
</p>

<p>
  Some of the major features of ART include the following:
</p>

<ul>
  <li>Ahead-of-time (AOT) and just-in-time (JIT) compilation
  </li>

  <li>Optimized garbage collection (GC)
  </li>

  <li>Better debugging support, including a dedicated sampling profiler,
  detailed diagnostic exceptions and crash reporting, and the ability to set
  watchpoints to monitor specific fields
  </li>
</ul>

<p>
  Prior to Android version 5.0 (API level 21), Dalvik was the Android runtime.
  If your app runs well on ART, then it should work on Dalvik as well, but
  <a href="https://developer.android.com/guide/practices/verifying-apps-art.html">the reverse may not be
  true</a>.
</p>

<p>
  Android also includes a set of core runtime libraries that provide most of
  the functionality of the Java programming language, including some <a href="https://developer.android.com/guide/platform/j8-jack.html">Java 8 language features</a>, that the Java
  API framework uses.
</p>

<h3 id="native-libs">
  Native C/C++ Libraries
</h3>

<p>
  Many core Android system components and services, such as ART and HAL, are
  built from native code that require native libraries written in C and C++.
  The Android platform provides Java framework APIs to expose the functionality
  of some of these native libraries to apps. For example, you can access
  <a href="https://developer.android.com/guide/topics/graphics/opengl.html">OpenGL ES</a> through the
  Android framework’s <a href="https://developer.android.com/reference/android/opengl/package-summary.html">Java OpenGL API</a> to add
  support for drawing and manipulating 2D and 3D graphics in your app.
</p>

<p>
  If you are developing an app that requires C or C++ code, you can use the
  <a href="https://developer.android.com/ndk/index.html">Android NDK</a> to access some of these <a href="https://developer.android.com/ndk/guides/stable_apis.html">native platform libraries</a> directly from
  your native code.
</p>

<h3 id="api-framework">
Java API Framework
</h3>

<p>
  The entire feature-set of the Android OS is available to you through APIs
  written in the Java language. These APIs form the building blocks you need to
  create Android apps by simplifying the reuse of core, modular system
  components and services, which include the following:
</p>

<ul>
  <li>A rich and extensible <a href="https://developer.android.com/guide/topics/ui/overview.html">View
  System</a> you can use to build an app’s UI, including lists, grids, text
  boxes, buttons, and even an embeddable web browser
  </li>

  <li>A <a href="https://developer.android.com/guide/topics/resources/overview.html">Resource Manager</a>,
  providing access to non-code resources such as localized strings, graphics,
  and layout files
  </li>

  <li>A <a href="https://developer.android.com/guide/topics/ui/notifiers/notifications.html">Notification
  Manager</a> that enables all apps to display custom alerts in the status bar
  </li>

  <li>An <a href="https://developer.android.com/guide/components/activities.html">Activity Manager</a> that
  manages the lifecycle of apps and provides a common <a href="https://developer.android.com/guide/components/tasks-and-back-stack.html">navigation back stack</a>
  </li>

  <li>
    <a href="https://developer.android.com/guide/topics/providers/content-providers.html">Content
    Providers</a> that enable apps to access data from other apps, such as
    the Contacts app, or to share their own data
  </li>
</ul>

<p>
  Developers have full access to the same <a href="https://developer.android.com/reference/packages.html">framework APIs</a> that Android system apps use.
</p>

<h3 id="system-apps">
System Apps
</h3>

<p>
  Android comes with a set of core apps for email, SMS messaging, calendars,
  internet browsing, contacts, and more. Apps included with the platform have
  no special status among the apps the user chooses to install. So a
  third-party app can become the user's default web browser, SMS messenger, or
  even the default keyboard (some exceptions apply, such as the system's
  Settings app).
</p>

<p>
  The system apps function both as apps for users and to provide key
  capabilities that developers can access from their own app. For example, if
  your app would like to deliver an SMS message, you don't need to build that
  functionality yourself—you can instead invoke whichever SMS app is already
  installed to deliver a message to the recipient you specify.
</p>

<br>

### Framework details

![Framework details](https://source.android.com/images/android_framework_details.png)

## Android Core Technologies

<div class="devsite-article-body clearfix
            "
       itemprop="articleBody">
    
  <!--
      Copyright 2017 The Android Open Source Project

      Licensed under the Apache License, Version 2.0 (the "License");
      you may not use this file except in compliance with the License.
      You may obtain a copy of the License at

          http://www.apache.org/licenses/LICENSE-2.0

      Unless required by applicable law or agreed to in writing, software
      distributed under the License is distributed on an "AS IS" BASIS,
      WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
      See the License for the specific language governing permissions and
      limitations under the License.
  -->

<h3 id="art-technical-information">ART and Dalvik</h3>
<p>The Android runtime (ART) is the heart of Android. It's a fast, ahead-of-time
compiled runtime with modern garbage collection designed to scale.
Android applications are compiled to Dalvik bytecode and run with ART. This
section includes detailed information such as the Dalvik Executable format
specification, and design information on the runtime itself.</p>
<p><a href="https://source.android.com/devices/tech/dalvik/index.html">&raquo; ART and Dalvik
Information</a></p>

<h3 id="config">Configuration</h3>
<p>Getting the most out of Android requires tuning of the <a
href="https://source.android.com/devices/tech/config/kernel.html">kernel</a>, <a
href="https://source.android.com/devices/tech/config/renderer.html">OpenGLRenderer</a>, and
more. See the subpages of this section for details.
<p><a href="https://source.android.com/devices/tech/config/index.html">&raquo; Configuration
Information</a></p>

<h3 id="connect">Connectivity</h3>
<p>This section covers Android support for NFC standards (such as Felica),
provides details on the Radio Interface Layer (RIL), describes call notification
behavior, and gives implementation instructions for user-facing features such as
Data Saver and phone number blocking.</p>
<p><a href="https://source.android.com/devices/tech/connect/index.html">&raquo; Connectivity
Information</a></p>

<h3 id="data-usage-technical-information">Data Usage</h3>
<p>Android's data usage features allow users to understand and control how
their device uses network data. This section is designed for systems
integrators and mobile operators to help explain technical details they
should be aware of when porting Android to specific devices.</p>
<p><a href="https://source.android.com/devices/tech/datausage/index.html">&raquo; Data Usage
Information</a></p>

<h3 id="debugging">Debugging</h3>
<p>Android is a large and complex system. This section includes tips and tricks
for debugging at the platform level.</p>
<p><a href="https://source.android.com/devices/tech/debug/index.html">&raquo; Debugging
Information</a></p>

<h3 id="admin-information">Device Administration</h3>
<p>Since Android 5.0, the platform supports use cases in a corporate
environment under the auspices of each company’s information technology (IT)
department.</p>
<p><a href="https://source.android.com/devices/tech/admin/index.html">&raquo; Device
administration information</a></p>

<h3 id="display">Display Settings</h3>
<p>This section covers AOSP implementation of various Android display
settings, including app shortcuts, circular launcher icons, do not disturb
(DND), multi-window (split-screen, free-form, and picture-in-picture), high
dynamic range (HDR) video, night light, and retail demo mode.</p>
<p><a href="https://source.android.com/devices/tech/display/index.html">&raquo; Display settings
information</a></p>

<h3 id="ota-technical-information">OTA Updates</h3>
<p>Android devices in the field can receive and install over-the-air (OTA)
updates to the system and application software. This section describes the
structure of update packages and the tools to build them. It is intended for
developers building OTA updates for new and released Android devices.</p>
<p><a href="https://source.android.com/devices/tech/ota/index.html">&raquo; OTA Information</a>
</p>

<h3 id="performance">Performance</h3>
<p>This section provides guidance for ensuring your Android devices minimize
resource use and optimize performance. It includes details on optimizing boot
times, managing flash wear, configuring for low ram devices, and more.</p>
<p><a href="https://source.android.com/devices/tech/perf/index.html">&raquo; Performance Information</a>
</p>

<h3 id="power-technical-information">Power</h3>
<p>The framework provides battery usage statistics, keeping track of time spent
by different device components in different states. This section covers power
management features (such as Doze), gives instructions for accurately measuring
device and component power (and how to determine power values), and details the
<code>batterystats</code> command and output.</p>
<p><a href="https://source.android.com/devices/tech/power/index.html">&raquo; Power
Information</a></p>

<h3 id="settings">Settings</h3>
<p>This section provides guidance on implementing features in Android Settings
menu. It includes details on the patterns, components, and architecture of the
Settings app, how to customize personalized settings, and how to add a setting
to universal search.</p>
<p><a href="https://source.android.com/devices/tech/settings/index.html">&raquo; Settings Information</a>
</p>

<h3 id="tradefed-test-infrastructure">Trade Federation Testing Infrastructure
</h3>
<p>Trade Federation is a continuous test framework for running tests on
Android devices. Trade Federation's modularity makes it straightforward to
slot into environments with existing build, test, and reporting
infrastructures.</p>
<p><a href="https://source.android.com/devices/tech/test_infra/tradefed/index.html">
&raquo; Trade Federation Testing Infrastructure Overview</a></p>


<h3 id="vts">Vendor Test Suite (VTS)</h3>
<p>The Android Vendor Test Suite (VTS) provides extensive new functionality for
Android testing and promotes a test-driven development process. This section
describes the testing tools and resources available to help the Android
development community interact with test data.</p>
<p><a href="https://source.android.com/devices/tech/vts/index.html">&raquo; VTS Information</a>
</p>

  
  </div>
  
**************** 
 ## Android app architecture and components
 
 <p>Android apps can be written using Kotlin, Java, and C++ languages. The Android SDK tools compile
your code along with any data and resource files into an APK, an <i>Android package</i>,
which is an archive file with an <code>.apk</code> suffix. One APK file contains all the contents
of an Android app and is the file that Android-powered devices use to install the app.</p>

<h2 id="Components">App components</h2>

<p>App components are the essential building blocks of an Android app. Each
component is an entry point through which the system or a user can enter your app. Some
components depend on others.</p>

<p>There are four different types of app components:
<ul>
<li>Activities.</li>
<li>Services.</li>
<li>Broadcast receivers.</li>
<li>Content providers.</li>
</ul></p>
Each type serves a distinct purpose
and has a distinct lifecycle that defines how the component is created and destroyed.
 The following sections describe the four types of app components.</p>

<dl>

<dt><b>Activities</b></dt>

<dd>An <i>activity</i> is the entry point for interacting with the user. It represents a single
 screen with a user interface. For example,
an email app might have one activity that shows a list of new
emails, another activity to compose an email, and another activity for reading emails. Although
the activities work together to form a cohesive user experience in the email app, each one
is independent of the others. As such, a different app can start any one of these
activities if the email app allows it. For example, a camera app can start the
activity in the email app that composes new mail to allow the user to share a picture.

An activity facilitates the following key interactions between system and app:

  <ul>
    <li>Keeping track of what the user currently cares about (what is on screen) to ensure that the
      system keeps running the process that is hosting the activity.</li>
    <li>Knowing that previously used processes contain things the user may return to (stopped
      activities), and thus more highly prioritize keeping those processes around.</li>
    <li>Helping the app handle having its process killed so the user can return to activities
      with their previous state restored.</li>
    <li>Providing a way for apps to implement user flows between each other, and for the system to
      coordinate these flows. (The most classic example here being share.)</li>
  </ul>

<p>You implement an activity as a subclass of the <code><a href="https://developer.android.com/reference/android/app/Activity.html">Activity</a></code> class. For more
  information about the <code><a href="https://developer.android.com/reference/android/app/Activity.html">Activity</a></code> class, see the
 <a href="https://developer.android.com/guide/components/activities.html">Activities</a> developer guide.</p>
</dd>


<dt><b>Services</b></dt>

<dd>A <i>service</i> is a general-purpose entry point for keeping an app running in the background
for all kinds of reasons. It is a component that runs in the background to perform long-running
operations or to perform work for remote processes. A service does not provide a user interface. For
example, a service might play music in the background while the user is in a different app, or
it might fetch data over the network without blocking user interaction with an activity. Another
component, such as an activity, can start the service and let it run or bind to it in order to
interact with it.

There are actually two very distinct semantics services tell the system about how to manage an app:

Started services tell the system to keep them running until their work is completed.
This could be to sync some data in the background or play music even after the user leaves the app.
Syncing data in the background or playing music also represent two different types of started
services that modify how the system handles them:

  <ul>
    <li>Music playback is something the user is directly aware of, so the app tells the system this
      by saying it wants to be foreground with a notification to tell the user about it; in this
      case the system knows that it should try really hard to keep that service's process running,
      because the user will be unhappy if it goes away.
    </li>

    <li>A regular background service is not something the user is directly aware as running, so
      the system has more freedom in managing its process.  It may allow it to be killed
      (and then restarting the service sometime later) if it needs RAM for things that are of more
      immediate concern to the user.
    </li>
  </ul>
Bound services run because some other app (or the system) has said that it wants to make use of the
service.  This is basically the service providing an API to another process.  The system thus
knows there is a dependency between these processes, so if process A is bound to a service in
process B, it knows that it needs to keep process B (and its service) running for A.  Further, if
process A is something the user cares about, then it also knows to treat process B as something the
user also cares about.

Because of their flexibility (for better or worse), services have turned out to be a really useful
building block for all kinds of higher-level system concepts.  Live wallpapers, notification
listeners, screen savers, input methods, accessibility services, and many other core system features
are all built as services that applications implement and the system binds to when they should be
running.

<p>A service is implemented as a subclass of <code><a href="https://developer.android.com/reference/android/app/Service.html">Service</a></code>. For more information
about the <code><a href="https://developer.android.com/reference/android/app/Service.html">Service</a></code> class, see the <a href="https://developer.android.com/guide/components/services.html">
Services</a> developer guide.</p>


<p class="note"><strong>Note:</strong> If your app targets Android 5.0 (API level 21) or later,
 use the <code><a href="https://developer.android.com/reference/android/app/job/JobScheduler.html">JobScheduler</a></code> class to schedule actions. JobScheduler has the
advantage of conserving battery by optimally scheduling jobs to reduce power consumption,
and by working with the <a href="https://developer.android.com/training/monitoring-device-state/doze-standby.html">Doze</a> API.
For more information about using this class, see the <code><a href="https://developer.android.com/reference/android/app/job/JobScheduler.html">JobScheduler</a></code>
reference documentation.</p>


  </dd>

<dt><b>Broadcast receivers</b></dt>

<dd>A <i>broadcast receiver</i> is a component that enables the system to deliver events to the
app outside of a regular user flow, allowing the app to respond to system-wide broadcast
announcements. Because broadcast receivers are another well-defined entry into the app, the system
can deliver broadcasts even to apps that aren't currently running.  So, for example, an app can
schedule an alarm to post a notification to tell the user about an upcoming event...
and by delivering that alarm to a BroadcastReceiver of the app, there is no need for the app to
remain running until the alarm goes off.

Many broadcasts originate from the system&mdash;for example,
 a broadcast announcing
that the screen has turned off, the battery is low, or a picture was captured.
Apps can also initiate broadcasts&mdash;for example, to let other apps know that
some data has been downloaded to the device and is available for them to use.
 Although broadcast
receivers don't display a user interface, they may <a
href="https://developer.android.com/guide/topics/ui/notifiers/notifications.html">create a status bar notification</a>
to alert the user when a broadcast event occurs. More commonly, though, a broadcast receiver is
just a <em>gateway</em> to other components and is intended to do a very minimal amount of work.
 For instance, it might schedule a <code><a href="https://developer.android.com/reference/android/app/job/JobService.html">JobService</a></code> to perform some work based
on the event with <code><a href="https://developer.android.com/reference/android/app/job/JobScheduler.html">JobScheduler</a></code>

<p>A broadcast receiver is implemented as a subclass of <code><a href="https://developer.android.com/reference/android/content/BroadcastReceiver.html">BroadcastReceiver</a></code>
and each broadcast is delivered as an <code><a href="https://developer.android.com/reference/android/content/Intent.html">Intent</a></code> object. For more information,
see the <code><a href="https://developer.android.com/reference/android/content/BroadcastReceiver.html">BroadcastReceiver</a></code> class.</p>
</dd>

<dt><b>Content providers</b></dt>

<dd>A <i>content provider</i> manages a shared set of app data that you can store in
the file system, in a SQLite database, on the web, or on any other persistent storage
location that your
app can access. Through the content provider, other apps can query or modify
the data if the content provider allows it.

For example, the Android system provides a content
provider that manages the user's contact information. As such, any app with the proper
permissions can query the content provider, such as
<code><a href="https://developer.android.com/reference/android/provider/ContactsContract.Data.html">ContactsContract.Data</a></code>, to read and write information about
a particular person.

It is tempting to think of a content provider as an abstraction on a database, because there is a
lot of API and support built in to them for that common case. However, they have a different
core purpose from a system-design perspective.

To the system, a content provider is an entry point into an app for publishing named data items,
identified by a URI scheme.  Thus an app can decide how it wants to map the data it contains to a
URI namespace, handing out those URIs to other entities which can in turn use them to access the
data.  There are a few particular things this allows the system to do in managing an app:

  <ul>
    <li>Assigning a URI doesn't require that the app remain running, so URIs can persist after their
      owning apps have exited. The system only needs to make sure that an owning app is
      still running when it has to retrieve the app's data from the corresponding URI.</li>
  <li>These URIs also provide an important fine-grained security model.  For example, an
    app can place the URI for an image it has on the clipboard, but leave its content
    provider locked up so that other apps cannot freely access it.  When a second app attempts
    to access that URI on the clipboard,the system can allow that app to
    access the data via a temporary <i>URI permission grant</i>
    so that it is allowed to
    access the data only behind that URI, but nothing else in the second app.</li>
  </ul>

<p>Content providers are also useful for reading and writing data that is private to your
app and not shared. For example, the <a
href="https://developer.android.com/resources/samples/NotePad/index.html">Note Pad</a> sample app uses a
content provider to save notes.</p>

<p>A content provider is implemented as a subclass of <code><a href="https://developer.android.com/reference/android/content/ContentProvider.html">ContentProvider</a></code>
and must implement a standard set of APIs that enable other apps to perform
transactions. For more information, see the <a
href="https://developer.android.com/guide/topics/providers/content-providers.html">Content Providers</a> developer
guide.</p>
</dd>

</dl>

<p>A unique aspect of the Android system design is that any app can start another
app’s component. For example, if you want the user to capture a
photo with the device camera, there's probably another app that does that and your
app can use it instead of developing an activity to capture a photo yourself. You don't
need to incorporate or even link to the code from the camera app.
Instead, you can simply start the activity in the camera app that captures a
photo. When complete, the photo is even returned to your app so you can use it. To the user,
it seems as if the camera is actually a part of your app.</p>

<p>When the system starts a component, it starts the process for that app if it's not
already running and instantiates the classes needed for the component. For example, if your
app starts the activity in the camera app that captures a photo, that activity
runs in the process that belongs to the camera app, not in your app's process.
Therefore, unlike apps on most other systems, Android apps don't have a single entry
point (there's no <code>main()</code> function).</p>

<p>Because the system runs each app in a separate process with file permissions that
restrict access to other apps, your app cannot directly activate a component from
another app. However, the Android system can. To activate a component in
another app, deliver a message to the system that specifies your <em>intent</em> to
start a particular component. The system then activates the component for you.</p>


<h3 id="ActivatingComponents">Activating components</h3>

<p>Three of the four component types&mdash;activities, services, and
broadcast receivers&mdash;are activated by an asynchronous message called an <em>intent</em>.
Intents bind individual components to each other at runtime. You can think of them
as the messengers that request an action from other components, whether the component belongs
to your app or another.</p>

<p>An intent is created with an <code><a href="https://developer.android.com/reference/android/content/Intent.html">Intent</a></code> object, which defines a message to
activate either a specific component (explicit intent) or a specific <em>type</em> of component
 (implicit intent).</p>

<p>For activities and services, an intent defines the action to perform (for example, to
 <em>view</em> or
<em>send</em> something) and may specify the URI of the data to act on, among other things that the
component being started might need to know. For example, an intent might convey a request for an
activity to show an image or to open a web page. In some cases, you can start an
activity to receive a result, in which case the activity also returns
the result in an <code><a href="https://developer.android.com/reference/android/content/Intent.html">Intent</a></code>. For example, you can issue an intent to let
the user pick a personal contact and have it returned to you. The return intent includes a
URI pointing to the chosen contact.</p>

<p>For broadcast receivers, the intent simply defines the
announcement being broadcast. For example, a broadcast to indicate the device battery is low
includes only a known action string that indicates <em>battery is low</em>.</p>

<p>Unlike activities, services, and broadcast receivers, content providers are not activated
 by intents. Rather, they are
activated when targeted by a request from a <code><a href="https://developer.android.com/reference/android/content/ContentResolver.html">ContentResolver</a></code>. The content
resolver handles all direct transactions with the content provider so that the component that's
performing transactions with the provider doesn't need to and instead calls methods on the
<code><a href="https://developer.android.com/reference/android/content/ContentResolver.html">ContentResolver</a></code> object. This leaves a layer of abstraction between the
content provider and the component requesting information (for security).</p>

<p>There are separate methods for activating each type of component:</p>
<ul>
  <li>You can start an activity or give it something new to do by
passing an <code><a href="https://developer.android.com/reference/android/content/Intent.html">Intent</a></code> to <code><a href="https://developer.android.com/reference/android/content/Context.html#startActivity(android.content.Intent)">startActivity()</a></code> or <code><a href="https://developer.android.com/reference/android/app/Activity.html#startActivityForResult(android.content.Intent, int)">startActivityForResult()</a></code>
(when you want the activity to return a result).</li>


  <li>With Android 5.0 (API level 21) and later, you can use
  the <code><a href="https://developer.android.com/reference/android/app/job/JobScheduler.html">JobScheduler</a></code> class to schedule actions.
    For earlier Android versions, you can start
  a service (or give new instructions to an ongoing service) by
passing an <code><a href="https://developer.android.com/reference/android/content/Intent.html">Intent</a></code> to <code><a href="https://developer.android.com/reference/android/content/Context.html#startService(android.content.Intent)">startService()</a></code>. You can bind to the service by passing an <code><a href="https://developer.android.com/reference/android/content/Intent.html">Intent</a></code> to
<code><a href="https://developer.android.com/reference/android/content/Context.html#bindService(android.content.Intent, android.content.ServiceConnection, int)">bindService()</a></code>. </li>
  <li>You can initiate a broadcast by passing an <code><a href="https://developer.android.com/reference/android/content/Intent.html">Intent</a></code> to methods such as
<code><a href="https://developer.android.com/reference/android/content/Context.html#sendBroadcast(android.content.Intent)">sendBroadcast()</a></code>, <code><a href="https://developer.android.com/reference/android/content/Context.html#sendOrderedBroadcast(android.content.Intent, java.lang.String)">sendOrderedBroadcast()</a></code>, or <code><a href="https://developer.android.com/reference/android/content/Context.html#sendStickyBroadcast(android.content.Intent)">sendStickyBroadcast()</a></code>.</li>
  <li>You can perform a query to a content provider by calling <code><a href="https://developer.android.com/reference/android/content/ContentProvider.html#query(android.net.Uri, java.lang.String[], android.os.Bundle, android.os.CancellationSignal)">query()</a></code> on a <code><a href="https://developer.android.com/reference/android/content/ContentResolver.html">ContentResolver</a></code>.</li>
</ul>

<p>For more information about using intents, see the <a
href="https://developer.android.com/guide/components/intents-filters.html">Intents and
Intent Filters</a> document.
 The following documents provide more information about activating specifc components:
 <a href="https://developer.android.com/guide/components/activities.html">Activities</a>,
 <a href="https://developer.android.com/guide/components/services.html">Services
 <code><a href="https://developer.android.com/reference/android/content/BroadcastReceiver.html">BroadcastReceiver</a></code>, and
 <a ref="/guide/topics/providers/content-providers.html">Content Providers</a>.</p>

<h2 id="Manifest">The manifest file</h2>

<p>Before the Android system can start an app component, the system must know that the
component exists by reading the app's <em>manifest file</em>, <code>AndroidManifest.xml</code>.
 Your app must declare all its components in this file, which must be at the root of the
 app project directory.</p>

<p>The manifest does a number of things in addition to declaring the app's components,
such as the following:</p>
<ul>
  <li>Identifies any user permissions the app requires, such as Internet access or
read-access to the user's contacts.</li>
  <li>Declares the minimum
  <a href="https://developer.android.com/guide/topics/manifest/uses-sdk-element.html#ApiLevels">API Level</a>
required by the app, based on which APIs the app uses.</li>
  <li>Declares hardware and software features used or required by the app, such as a camera,
bluetooth services, or a multitouch screen.</li>
  <li>Declares API libraries the app needs to be linked against (other than the Android framework
APIs), such as the <a
href="http://code.google.com/android/add-ons/google-apis/maps-overview.html">
Google Maps library</a>.</li>

</ul>


<h3 id="DeclaringComponents">Declaring components</h3>

<p>The primary task of the manifest is to inform the system about the app's components. For
example, a manifest file can declare an activity as follows: </p>

<pre>
&lt;?xml version="1.0" encoding="utf-8"?&gt;
&lt;manifest ... &gt;
    &lt;application android:icon="@drawable/app_icon.png" ... &gt;
        &lt;activity android:name="com.example.project.ExampleActivity"
                  android:label="@string/example_label" ... &gt;
        &lt;/activity&gt;
        ...
    &lt;/application&gt;
&lt;/manifest&gt;</pre>

<p>In the <code><a
href="https://developer.android.com/guide/topics/manifest/application-element.html">&lt;application&gt;</a></code>
element, the <code>android:icon</code> attribute points to resources for an icon that identifies the
app.</p>

<p>In the <code><a
href="https://developer.android.com/guide/topics/manifest/activity-element.html">&lt;activity&gt;</a></code> element,
the <code>android:name</code> attribute specifies the fully qualified class name of the <code><a href="https://developer.android.com/reference/android/app/Activity.html">Activity</a></code> subclass and the <code>android:label</code> attribute specifies a string
to use as the user-visible label for the activity.</p>

<p>You must declare all app components using the following elements:</p>
<ul>
  <li><code><a
href="https://developer.android.com/guide/topics/manifest/activity-element.html">&lt;activity&gt;</a></code> elements
for activities.</li>
  <li><code><a
href="https://developer.android.com/guide/topics/manifest/service-element.html">&lt;service&gt;</a></code> elements for
services.</li>
  <li><code><a
href="https://developer.android.com/guide/topics/manifest/receiver-element.html">&lt;receiver&gt;</a></code> elements
for broadcast receivers.</li>
  <li><code><a
href="https://developer.android.com/guide/topics/manifest/provider-element.html">&lt;provider&gt;</a></code> elements
for content providers.</li>
</ul>

<p>Activities, services, and content providers that you include in your source but do not declare
in the manifest are not visible to the system and, consequently, can never run.  However,
broadcast
receivers can be either declared in the manifest or created dynamically in code as
<code><a href="https://developer.android.com/reference/android/content/BroadcastReceiver.html">BroadcastReceiver</a></code> objects and registered with the system by calling
<code><a href="https://developer.android.com/reference/android/content/Context.html#registerReceiver(android.content.BroadcastReceiver, android.content.IntentFilter)">registerReceiver()</a></code>.</p>

<p>For more about how to structure the manifest file for your app, see <a
href="https://developer.android.com/guide/topics/manifest/manifest-intro.html">The AndroidManifest.xml File</a>
documentation. </p>

<h3 id="DeclaringComponentCapabilities">Declaring component capabilities</h3>

<p>As discussed above, in <a href="#ActivatingComponents">Activating components</a>, you can use an
<code><a href="https://developer.android.com/reference/android/content/Intent.html">Intent</a></code> to start activities, services, and broadcast receivers.



You can use an <code><a href="https://developer.android.com/reference/android/content/Intent.html">Intent</a></code>
 by explicitly naming the target component (using the component class name) in the intent.
 You can also use an implicit intent, which
describes the type of action to perform and, optionally, the data upon which you’d like to
perform the action. The implicit intent allows the system to find a component on the device
 that can perform the
action and start it. If there are multiple components that can perform the action described by the
intent, the user selects which one to use.</p>

<p class="caution"><strong>Caution:</strong> If you use an intent to start a
 <code><a href="https://developer.android.com/reference/android/app/Service.html">Service</a></code>, ensure that your app is secure by using an
 <a href="https://developer.android.com/guide/components/intents-filters.html#Types">explicit</a>
intent. Using an implicit intent to start a service is a
security hazard because you cannot be certain what service will respond to the intent,
and the user cannot see which service starts. Beginning with Android 5.0 (API level 21), the system
throws an exception if you call <code><a href="https://developer.android.com/reference/android/content/Context.html#bindService(android.content.Intent, android.content.ServiceConnection, int)">bindService()</a></code>
with an implicit intent. Do not declare intent filters for your services. </p>

<p>The system identifies the components that can respond to an intent by comparing the
intent received to the <i>intent filters</i> provided in the manifest file of other apps on
the device.</p>

<p>When you declare an activity in your app's manifest, you can optionally include
intent filters that declare the capabilities of the activity so it can respond to intents
from other apps. You can declare an intent filter for your component by
adding an <a href="https://developer.android.com/guide/topics/manifest/intent-filter-element.html"><code>&lt;intent-filter&gt;</code></a> element as a child of the component's declaration element.</p>

<p>For example, if you build an email app with an activity for composing a new email, you can
declare an intent filter to respond to "send" intents (in order to send a new email),
 as shown in the following example:</p>
<pre>
&lt;manifest ... >
    ...
    &lt;application ... &gt;
        &lt;activity android:name="com.example.project.ComposeEmailActivity">
            &lt;intent-filter>
                &lt;action android:name="android.intent.action.SEND" />
                &lt;data android:type="*/*" />
                &lt;category android:name="android.intent.category.DEFAULT" />
            &lt;/intent-filter>
        &lt;/activity>
    &lt;/application&gt;
&lt;/manifest>
</pre>

<p>If another app creates an intent with the <code><a href="https://developer.android.com/reference/android/content/Intent.html#ACTION_SEND">ACTION_SEND</a></code> action and passes it to
 <code><a href="https://developer.android.com/reference/android/app/Activity.html#startActivity(android.content.Intent)">startActivity()</a></code>, the system may start your activity so the user can draft and send an
email.</p>

<p>For more about creating intent filters, see the <a
href="https://developer.android.com/guide/components/intents-filters.html">Intents and Intent Filters</a> document.
</p>



<h3 id="DeclaringRequirements">Declaring app requirements</h3>

<p>There are a variety of devices powered by Android and not all of them provide the
same features and capabilities. To prevent your app from being installed on devices
that lack features needed by your app, it's important that you clearly define a profile for
the types of devices your app supports by declaring device and software requirements in your
manifest file. Most of these declarations are informational only and the system does not read
them, but external services such as Google Play do read them in order to provide filtering
for users when they search for apps from their device.</p>

<p>For example, if your app requires a camera and uses APIs introduced in Android 2.1 (<a
href="https://developer.android.com/guide/topics/manifest/uses-sdk-element.html#ApiLevels">API Level</a> 7),
you must declare these as requirements in your manifest file as shown in the following example:</p>

<pre>
&lt;manifest ... >
    &lt;uses-feature android:name="android.hardware.camera.any"
                  android:required="true" />
    &lt;uses-sdk android:minSdkVersion="7" android:targetSdkVersion="19" />
    ...
&lt;/manifest>
</pre>

<p>With the declarations shown in the example, devices that do <em>not</em> have a
 camera or have an
Android version <em>lower</em> than 2.1 cannot install your app from Google Play.
 However, you can declare that your app uses the camera, but does not
<em>require</em> it. In that case, your app must set the <a href="https://developer.android.com/guide/topics/manifest/uses-feature-element.html#required"><code>required</code></a>
attribute to <code>false</code> and check at runtime whether
the device has a camera and disable any camera features as appropriate.</p>

<p>More information about how you can manage your app's compatibility with different devices
is provided in the <a href="https://developer.android.com/guide/practices/compatibility.html">Device Compatibility</a>
document.</p>



<h2 id="Resources">App resources</h2>

<p>An Android app is composed of more than just code&mdash;it requires resources that are
separate from the source code, such as images, audio files, and anything relating to the visual
presentation of the app. For example, you can define animations, menus, styles, colors,
and the layout of activity user interfaces with XML files. Using app resources makes it easy
to update various characteristics of your app without modifying code. Providing
sets of alternative resources enables you to optimize your app for a variety of
device configurations, such as different languages and screen sizes.</p>

<p>For every resource that you include in your Android project, the SDK build tools define a unique
integer ID, which you can use to reference the resource from your app code or from
other resources defined in XML. For example, if your app contains an image file named
<code>logo.png</code> (saved in the <code>res/drawable/</code> directory), the SDK tools generate
a resource ID named <code>R.drawable.logo</code>. This ID maps to an app-specific integer, which
you can use to reference the image and insert it in your user interface.</p>

<p>One of the most important aspects of providing resources separate from your source code
is the ability to provide alternative resources for different device
configurations. For example, by defining UI strings in XML, you can translate
 the strings into other
languages and save those strings in separate files. Then Android applies the
 appropriate language strings
to your UI based on a language <em>qualifier</em>
that you append to the resource directory's name (such as <code>res/values-fr/</code> for French string
values) and the user's language setting.</p>

<p>Android supports many different <em>qualifiers</em> for your alternative resources. The
qualifier is a short string that you include in the name of your resource directories in order to
define the device configuration for which those resources should be used. For
example, you should create different layouts for your activities, depending on the
device's screen orientation and size. When the device screen is in portrait
orientation (tall), you might want a layout with buttons to be vertical, but when the screen is in
landscape orientation (wide), the buttons could be aligned horizontally. To change the layout
depending on the orientation, you can define two different layouts and apply the appropriate
qualifier to each layout's directory name. Then, the system automatically applies the appropriate
layout depending on the current device orientation.</p>

### The final architecture

The following diagram shows all the modules in our recommended architecture and how they interact with one another:

<br>

![The final architecture](https://developer.android.com/topic/libraries/architecture/images/final-architecture.png)

<br>


<h2 id="alc">Activity-lifecycle concepts</h2>

<p>
To navigate transitions between stages of the activity lifecycle, the
Activity class provides a core set of six callbacks:
<code><a href="https://developer.android.com/reference/android/app/Activity.html#onCreate(android.os.Bundle)">onCreate()</a></code>,
<code><a href="https://developer.android.com/reference/android/app/Activity.html#onStart()">onStart()</a></code>,
<code><a href="https://developer.android.com/reference/android/app/Activity.html#onResume()">onResume()</a></code>,
<code><a href="https://developer.android.com/reference/android/app/Activity.html#onPause()">onPause()</a></code>,
<code><a href="https://developer.android.com/reference/android/app/Activity.html#onStop()">onStop()</a></code>, and
<code><a href="https://developer.android.com/reference/android/app/Activity.html#onDestroy()">onDestroy()</a></code>. The system invokes
each of these callbacks as an activity enters a new state.
</p>

<p>
presents a visual representation of this paradigm.
</p>

<img src="https://developer.android.com/guide/components/images/activity_lifecycle.png" />
<p class="img-caption"><strong></strong>  A simplified
illustration of the activity lifecycle.</p>

<p>
As the user begins to leave the activity, the system calls methods
to dismantle the activity. In some cases, this dismantlement is only partial;
the activity still resides in memory (such as when the user switches to another app),
and can still come back to the foreground. If the user returns to that activity, the
activity resumes from where the user left off. The system’s likelihood of
killing a given process&mdash;along with the activities in it&mdash;depends on the state
of the activity at the time. <a href="#asem">Activity state and ejection from
memory</a> provides more information on the relationship between state and
vulnerability to ejection.
</p>

<p>
Depending on the complexity of your activity, you probably don't need to
implement all the lifecycle methods. However, it's important that you
understand each one and implement those that ensure your app behaves
the way users expect.
</p>

<p>
The next section of this document provides detail on the callbacks that you
use to handle transitions between states.
</p>

<h2 id="lc">Lifecycle callbacks</h2>

<p>
This section provides conceptual and implementation information about the
callback methods used during the activity lifecycle.
</p>

<h3 id="oncreate">onCreate()</h3>

<p>
You must implement this callback, which fires when the system first creates the
activity. On activity creation, the activity enters the <em>Created</em> state.
In the <code><a href="https://developer.android.com/reference/android/app/Activity.html#onCreate(android.os.Bundle)">onCreate()</a></code>
method, you perform basic application startup logic that
should happen only once for the entire life of the activity. For example, your
implementation of
<code><a href="https://developer.android.com/reference/android/app/Activity.html#onCreate(android.os.Bundle)">onCreate()</a></code> might bind
data to lists, initialize background
threads, and instantiate some class-scope variables. This method receives the
parameter <code>savedInstanceState</code>, which is a <code><a href="https://developer.android.com/reference/android/os/Bundle.html">Bundle</a></code>
object containing the activity's previously saved state. If the activity has
never existed before, the value of the <code><a href="https://developer.android.com/reference/android/os/Bundle.html">Bundle</a></code> object is null.
</p>

<p>
The following example of the
<code><a href="https://developer.android.com/reference/android/app/Activity.html#onCreate(android.os.Bundle)">onCreate()</a></code> method
shows fundamental setup for the activity, such as declaring the user interface
(defined in an XML layout file), defining member variables, and configuring
some of the UI. In this example, the XML layout file is specified by passing
file’s resource ID <code>R.layout.main_activity</code> to
<code><a href="https://developer.android.com/reference/android/app/Activity.html#setContentView(android.view.View)">setContentView()</a></code>.
</p>

<pre>
TextView mTextView;

// some transient state for the activity instance
String mGameState;

@Override
public void onCreate(Bundle savedInstanceState) {
    // call the super class onCreate to complete the creation of activity like
    // the view hierarchy
    super.onCreate(savedInstanceState);

    // recovering the instance state
    if (savedInstanceState != null) {
        mGameState = savedInstanceState.getString(GAME_STATE_KEY);
    }

    // set the user interface layout for this Activity
    // the layout file is defined in the project res/layout/main_activity.xml file
    setContentView(R.layout.main_activity);

    // initialize member TextView so we can manipulate it later
    mTextView = (TextView) findViewById(R.id.text_view);
}

// This callback is called only when there is a saved instance previously saved using
// onSaveInstanceState(). We restore some state in onCreate() while we can optionally restore
// other state here, possibly usable after onStart() has completed.
// The savedInstanceState Bundle is same as the one used in onCreate().
@Override
public void onRestoreInstanceState(Bundle savedInstanceState) {
    mTextView.setText(savedInstanceState.getString(TEXT_VIEW_KEY));
}

// invoked when the activity may be temporarily destroyed, save the instance state here
@Override
public void onSaveInstanceState(Bundle outState) {
    outState.putString(GAME_STATE_KEY, mGameState);
    outState.putString(TEXT_VIEW_KEY, mTextView.getText());

    // call superclass to save any view hierarchy
    super.onSaveInstanceState(outState);
}
</pre>

<p>
As an alternative to defining the XML file and passing it to <code><a href="https://developer.android.com/reference/android/app/Activity.html#setContentView(android.view.View)">setContentView()</a></code>, you
can create new <code><a href="https://developer.android.com/reference/android/view/View.html">View</a></code> objects in your activity code and build a
view hierarchy by inserting new <code><a href="https://developer.android.com/reference/android/view/View.html">View</a></code>s into a
<code><a href="https://developer.android.com/reference/android/view/ViewGroup.html">ViewGroup</a></code>. You then use that layout by passing the
root <code><a href="https://developer.android.com/reference/android/view/ViewGroup.html">ViewGroup</a></code> to
<code><a href="https://developer.android.com/reference/android/app/Activity.html#setContentView(android.view.View)">setContentView()</a></code>.
For more information about creating a user interface, see the
<a href="https://developer.android.com/guide/topics/ui/index.html">User Interface</a> documentation.
</p>

<p>
Your activity does not reside in the Created
state. After the <code><a href="https://developer.android.com/reference/android/app/Activity.html#onCreate(android.os.Bundle)">onCreate()</a></code> method finishes execution, the activity enters the <em>Started</em>
state, and the system calls the <code><a href="https://developer.android.com/reference/android/app/Activity.html#onStart()">onStart()</a></code>
and <code><a href="https://developer.android.com/reference/android/app/Activity.html#onResume()">onResume()</a></code> methods in quick
succession. The next section explains the
<code><a href="https://developer.android.com/reference/android/app/Activity.html#onStart()">onStart()</a></code> callback.
</p>


<h3 id="onstart">onStart()</h3>

<p>
When the activity enters the Started state, the system
invokes this callback. The <code><a href="https://developer.android.com/reference/android/app/Activity.html#onStart()">onStart()</a></code> call
makes the activity visible to the user, as the
app prepares for the activity to enter the foreground and become interactive.
For example, this method is where the app initializes the code that maintains
the UI. It might also register a <code><a href="https://developer.android.com/reference/android/content/BroadcastReceiver.html">BroadcastReceiver</a></code>
that monitors changes that are reflected in the UI.
</p>

<p>
The <code><a href="https://developer.android.com/reference/android/app/Activity.html#onStart()">onStart()</a></code> method completes very
quickly and, as with the Created state, the activity does not stay resident
in the Started state. Once this callback finishes, the activity enters the
<em>Resumed</em> state, and the system invokes the
<code><a href="https://developer.android.com/reference/android/app/Activity.html#onResume()">onResume()</a></code> method.
</p>


<h3 id="onresume">onResume()</h3>

<p>
When the activity enters the Resumed state, it comes to the foreground, and then
the system invokes the <code><a href="https://developer.android.com/reference/android/app/Activity.html#onResume()">onResume()</a></code>
callback. This is the state in which the app
interacts with the user. The app stays in this state until something happens to
take focus away from the app. Such an event might be, for instance, receiving a
phone call, the user’s navigating to another activity, or the device screen’s
turning off.
</p>

<p>
When an interruptive event occurs, the activity enters the <em>Paused</em>
state, and the system invokes the
<code><a href="https://developer.android.com/reference/android/app/Activity.html#onPause()">onPause()</a></code> callback.
</p>

<p>
If the activity returns to
the Resumed state from the Paused state, the system once again calls
<code><a href="https://developer.android.com/reference/android/app/Activity.html#onResume()">onResume()</a></code> method. For this reason,
you should implement <code><a href="https://developer.android.com/reference/android/app/Activity.html#onResume()">onResume()</a></code>
to initialize components that you release during
<code><a href="https://developer.android.com/reference/android/app/Activity.html#onPause()">onPause()</a></code>. For example,
you may initialize the camera as follows:
</p>

<pre>
&#64;Override
public void onResume() {
    super.onResume();  // Always call the superclass method first


    // Get the Camera instance as the activity achieves full user focus
    if (mCamera == null) {
        initializeCamera(); // Local method to handle camera init
    }
}
   </pre>

<p>
Be aware that the system calls this method every time your activity comes into
the foreground, including when it's created for the first time. As such, you
should implement <code><a href="https://developer.android.com/reference/android/app/Activity.html#onResume()">onResume()</a></code> to
initialize components that you release during
<code><a href="https://developer.android.com/reference/android/app/Activity.html#onPause()">onPause()</a></code>, and perform any other
initializations that must occur each time the
activity enters the Resumed state. For example, you should begin animations
and initialize components that the activity only uses when it has user focus.
</p>

<h3 id="onpause">onPause()</h3>

<p>
The system calls this method as the first indication that the user is leaving
your activity (though it does not always mean the activity is being destroyed).
Use the <code><a href="https://developer.android.com/reference/android/app/Activity.html#onPause()">onPause()</a></code> method to pause
operations such animations and music playback that should not continue while
the <code><a href="https://developer.android.com/reference/android/app/Activity.html">Activity</a></code> is in the Paused state, and that you expect
to resume shortly. There are several reasons why an activity may enter this
state. For example:
</p>

<ul>
   <li>Some event interrupts app execution, as described in
    the <a href="#onresume">onResume()</a> section. This is the most common
    case.</li>
   <li>In Android 7.0 (API level 24) or higher, multiple apps run in
    multi-window mode. Because only one of the apps (windows) has focus
    at any time, the system pauses all of the other apps.</li>
   <li>A new, semi-transparent activity (such as a dialog) opens. As long as
    the activity is still partially visible but not in focus, it
    remains paused.
</ul>

<p>
You can use the <code><a href="https://developer.android.com/reference/android/app/Activity.html#onPause()">onPause()</a></code> method to
release system resources, such as broadcast receivers, handles to sensors
(like GPS), or any resources that may affect battery life while your
activity is paused and the user does not need them.
</p>

<p>
For example, if your application uses the Camera, the
<code><a href="https://developer.android.com/reference/android/app/Activity.html#onPause()">onPause()</a></code> method is a good place to
release it. The following example of
<code><a href="https://developer.android.com/reference/android/app/Activity.html#onPause()">onPause()</a></code> is the counterpart to the
<code><a href="https://developer.android.com/reference/android/app/Activity.html#onResume()">onResume()</a></code> example
above, releasing the camera that the <code><a href="https://developer.android.com/reference/android/app/Activity.html#onResume()">onResume()</a></code> example initialized.
</p>

<pre>
&#64;Override
public void onPause() {
    super.onPause();  // Always call the superclass method first


    // Release the Camera because we don't need it when paused
    // and other activities might need to use it.
    if (mCamera != null) {
        mCamera.release();
        mCamera = null;
    }
}
</pre>

<p>
<code><a href="https://developer.android.com/reference/android/app/Activity.html#onPause()">onPause()</a></code> execution is very brief, and
does not necessarily afford enough time to perform save operations. For this
reason, you should <strong>not</strong> use
<code><a href="https://developer.android.com/reference/android/app/Activity.html#onPause()">onPause()</a></code> to save application or user
data, make network calls, or execute database transactions; such work may not
complete before the method completes. Instead, you should
perform heavy-load shutdown operations during
<code><a href="https://developer.android.com/reference/android/app/Activity.html#onStop()">onStop()</a></code>. For more information
about suitable operations to perform during
<code><a href="https://developer.android.com/reference/android/app/Activity.html#onStop()">onStop()</a></code>, see <a href="#onstop">
onStop()</a>. For more information about saving data, see
<a href="#saras">Saving and restoring activity state</a>.
</p>

<p> Completion of the <code><a href="https://developer.android.com/reference/android/app/Activity.html#onPause()">onPause()</a></code> method
does not mean that the activity leaves the Paused state. Rather, the activity
remains in this state until either the activity resumes or becomes completely
invisible to the user. If the activity resumes, the system once again invokes
the <code><a href="https://developer.android.com/reference/android/app/Activity.html#onResume()">onResume()</a></code> callback. If the
activity returns from the Paused state to the Resumed state, the system keeps
the <code><a href="https://developer.android.com/reference/android/app/Activity.html">Activity</a></code> instance resident in memory, recalling
that instance when it the system invokes
<code><a href="https://developer.android.com/reference/android/app/Activity.html#onResume()">onResume()</a></code>. In this scenario, you
don’t need to re-initialize components that were created during any of the
callback methods leading up to the Resumed state. If the activity becomes
completely invisible, the system calls
<code><a href="https://developer.android.com/reference/android/app/Activity.html#onStop()">onStop()</a></code>. The next section discusses
the <code><a href="https://developer.android.com/reference/android/app/Activity.html#onStop()">onStop()</a></code> callback.
</p>

<h3 id="onstop">onStop()</h3>

<p>
When your activity is no longer visible to the user, it has entered the
<em>Stopped</em> state, and the system invokes the
<code><a href="https://developer.android.com/reference/android/app/Activity.html#onStop()">onStop()</a></code> callback. This may occur,
for example, when a newly launched activity covers the entire screen. The
system may also call <code><a href="https://developer.android.com/reference/android/app/Activity.html#onStop()">onStop()</a></code>
when the activity has finished running, and is about to be terminated.
</p>

<p>
In the <code><a href="https://developer.android.com/reference/android/app/Activity.html#onStop()">onStop()</a></code> method, the app should
release almost all resources that aren't needed while the user is not using
it. For example, if you registered a <code><a href="https://developer.android.com/reference/android/content/BroadcastReceiver.html">BroadcastReceiver</a></code>
in <code><a href="https://developer.android.com/reference/android/app/Activity.html#onStart()">onStart()</a></code> to listen for changes that
might affect your UI, you can unregister the broadcast receiver in
<code><a href="https://developer.android.com/reference/android/app/Activity.html#onStop()">onStop()</a></code>, as the user can no longer
see the UI. It is also important that you use
<code><a href="https://developer.android.com/reference/android/app/Activity.html#onStop()">onStop()</a></code> to release resources that
might leak memory, because it is possible for the system to kill the
process hosting your activity without calling the activity's final
<code><a href="https://developer.android.com/reference/android/app/Activity.html#onDestroy()">onDestroy()</a></code> callback.
</p>

<p>
You should also use <code><a href="https://developer.android.com/reference/android/app/Activity.html#onStop()">onStop()</a></code>
to perform relatively CPU-intensive shutdown operations. For example, if
you can't find a more opportune time to save information to a database,
you might do so during <code><a href="https://developer.android.com/reference/android/app/Activity.html#onStop()">onStop()</a></code>. The
following example shows an implementation of
<code><a href="https://developer.android.com/reference/android/app/Activity.html#onStop()">onStop()</a></code> that saves the contents of a
draft note to persistent storage:
</p>

<pre>
&#64;Override
protected void onStop() {
    // call the superclass method first
    super.onStop();

    // save the note's current draft, because the activity is stopping
    // and we want to be sure the current note progress isn't lost.
    ContentValues values = new ContentValues();
    values.put(NotePad.Notes.COLUMN_NAME_NOTE, getCurrentNoteText());
    values.put(NotePad.Notes.COLUMN_NAME_TITLE, getCurrentNoteTitle());

    // do this update in background on an AsyncQueryHandler or equivalent
    mAsyncQueryHandler.startUpdate (
            mToken,  // int token to correlate calls
            null,    // cookie, not used here
            mUri,    // The URI for the note to update.
            values,  // The map of column names and new values to apply to them.
            null,    // No SELECT criteria are used.
            null     // No WHERE columns are used.
    );
}
</pre>

<p>
When your activity enters the Stopped state, the <code><a href="https://developer.android.com/reference/android/app/Activity.html">Activity</a></code>
object is kept resident in memory: It maintains all state and member
information, but is not attached to the window manager. When the activity
resumes, the activity recalls this information. You don’t need to
re-initialize components that were created during any of the callback methods
leading up to the Resumed state. The system also keeps track of the current
state for each <code><a href="https://developer.android.com/reference/android/view/View.html">View</a></code> object in the layout, so if the
user entered text into an <code><a href="https://developer.android.com/reference/android/widget/EditText.html">EditText</a></code> widget, that
content is retained so you don't need to save and restore it.
</p>

<p class="note">
<strong>Note: </strong>Once your activity is stopped, the system
might destroy the process that contains the activity if the system
needs to recovery memory.
Even if the system destroys the process while the activity
is stopped, the system still retains the state of the <code><a href="https://developer.android.com/reference/android/view/View.html">View</a></code>
objects (such as text in an <code><a href="https://developer.android.com/reference/android/widget/EditText.html">EditText</a></code> widget) in a
<code><a href="https://developer.android.com/reference/android/os/Bundle.html">Bundle</a></code> (a blob of key-value pairs) and restores them
if the user navigates back to the activity. For
more information about restoring an activity to which a user returns, see
<a href="#saras">Saving and restoring activity state</a>.
</p>

<p>
From the Stopped state, the activity either comes back to interact with the
user, or the activity is finished running and goes away. If the activity comes
back, the system invokes <code><a href="https://developer.android.com/reference/android/app/Activity.html#onRestart()">onRestart()</a></code>.
If the <code><a href="https://developer.android.com/reference/android/app/Activity.html">Activity</a></code> is finished running, the system calls
<code><a href="https://developer.android.com/reference/android/app/Activity.html#onDestroy()">onDestroy()</a></code>. The next
section explains the <code><a href="https://developer.android.com/reference/android/app/Activity.html#onDestroy()">onDestroy()</a></code>
callback.
</p>


<h3 id="ondestroy">onDestroy()</h3>

<p>
Called before the activity is destroyed. This is the
final call that the activity receives. The system either invokes this callback
because the activity is finishing due to someone's calling
<code><a href="https://developer.android.com/reference/android/app/Activity.html#finish()">finish()</a></code>, or because the
system is temporarily destroying the process containing the activity to save
space. You can distinguish between these two scenarios with the
<code><a href="https://developer.android.com/reference/android/app/Activity.html#isFinishing()">isFinishing()</a></code> method.
The system may also call this method when an orientation change occurs, and
then immediately call <code><a href="https://developer.android.com/reference/android/app/Activity.html#onCreate(android.os.Bundle)">onCreate()</a></code> to recreate the process (and the components that it contains)
in the new orientation.
</p>

<p>
The <code><a href="https://developer.android.com/reference/android/app/Activity.html#onDestroy()">onDestroy()</a></code>
callback releases all resources that have not yet been released by earlier
callbacks such as <code><a href="https://developer.android.com/reference/android/app/Activity.html#onStop()">onStop()</a></code>.
</p>

*******
## Android studio

<p>Android Studio is the official Integrated Development Environment (IDE) for
Android app development, based on
<a class="external-link" href="https://www.jetbrains.com/idea/">IntelliJ IDEA
</a>. On top of IntelliJ's powerful code editor and developer tools, Android
Studio offers even more features that enhance your productivity when building
Android apps.</p>
For a summary of the latest changes, see
<a href="https://developer.android.com/studio/releases/index.html">Android Studio Release Notes</a>.</p>

<p><a name="user-interface"></a></p>
<h2 id="the_user_interface">The User Interface</h2>
<p>The Android Studio main window is made up of several logical areas identified in
</p>
<p><img src="https://developer.android.com/studio/images/intro/main-window_2-2_2x.png" width="816" alt=""
id="main-window"/></p>
<p class="img-caption">
  <strong></strong> The Android Studio main window.
</p>

<ol class="callouts">
<li>The <b>toolbar</b> lets you carry out a wide range of actions, including
  running your app and launching Android tools.</li>
<li>The <b>navigation bar</b> helps you navigate through your project and open
  files for editing. It provides a more compact view of the structure visible in
  the <b>Project</b> window.</li>
<li>The <b>editor window</b> is where you create and modify code. Depending on
  the current file type, the editor can change. For example, when viewing a
  layout file, the editor displays the Layout Editor.</li>
<li>The <b>tool window bar</b> runs around the outside of the IDE window and
  contains the buttons that allow you to expand or collapse individual tool
  windows.</li>
<li>The <b>tool windows</b> give you access to specific tasks like project management,
  search, version control, and more. You can expand them and collapse them.</li>
<li>The <b>status bar</b> displays the status of your project and the IDE itself,
  as well as any warnings or messages.</li>
</ol>

<p>You can organize the main window to give yourself more screen space by hiding
or moving toolbars and tool windows. You can also use keyboard shortcuts to
access most IDE features.</p>
<p>At any time, you can search across your source code, databases, actions,
elements of the user interface, and so on, by double-pressing the Shift key, or
clicking the magnifying glass in the upper right-hand corner of the Android
Studio window. This can be very useful if, for example, you are trying to
locate a particular IDE action that you have forgotten how to trigger.</p>

## Projects Overview

<p>A <em>project</em> in Android Studio contains everything that defines your
workspace for an app, from source code and assets, to test code and build
configurations. When you start a new project, Android Studio creates the necessary
structure for all your files and makes them visible in the
<strong>Project</strong> window on the left side of the IDE (click <strong>View
&gt; Tool Windows &gt; Project</strong>). This page provides an overview of the
key components inside your project.</p>


<h2 id="ApplicationModules">Modules</h2>

<p>A <em>module</em> is a collection of source files and build settings that
allow you to divide your project into discrete units of functionality. Your
project can have one or many modules and one module may use another module as a
dependency. Each module can be independently built, tested, and debugged.</p>

<p>Additional modules are often useful when creating code libraries within your
own project or when you want to create different sets of code and resources for
different device types, such as phones and wearables, but keep all the files
scoped within the same project and share some code.</p>

<p>You can add a new module to your project by clicking <strong>File
> New > New Module</strong>.</p>

<p>Android Studio offers a few distinct types of module:</p>

<dl>

  <dt><strong>Android app module</strong></dt>
  <dd>Provides a container for your app's
  source code, resource files, and app level settings such as the
  module-level build file and Android Manifest file. When
  you create a new project, the default module name is "app".
  <p>In the <strong>Create New Module</strong> window, Android Studio offers
  the following app modules:</p>
  <ul>
  <li>Phone &amp; Tablet Module</li>
  <li>Android Wear Module</li>
  <li>Android TV Module</li>
  <li>Glass Module</li>
  </ul>
  <p>They each provide essential files and some code templates that are
  appropriate for the corresponding app or device type.</p>
  <p>For more information on adding a module, read
  <a href="https://developer.android.com/studio/projects/add-app-module.html">Add a Module for a New Device</a>.</p>
  </dd>

  <dt><strong>Library module</strong></dt>
  <dd>Provides a container for your reusable code, which you
  can use as a dependency in other app modules or import into other
  projects. Structurally, a library module is the same as an app module, but when built,
  it creates a code archive file instead of an APK, so it can't be installed on
  a device.
  <p>In the <strong>Create New Module</strong> window, Android Studio offers
  the following library modules:</p>
  <ul>
  <li>Android Library: This type of library can contain all file types supported
  in an Android project, including source code, resources, and manifest files.
  The build result is an Android Archive (AAR) file that you can add as
  a dependency for your Android app modules.</li>
  <li>Java Library: This type of library can contain only Java source files.
  The build result is an Java Archive (JAR) file that you can add as
  a dependency for your Andriod app modules or other Java projects.</li>
  </ul>
  </dd>

  <dt><strong>Google Cloud module</strong></dt>
  <dd>Provides a container for your Google Cloud backend code. This module
  has the required code and dependencies for a Java App Engine backend
  that uses simple HTTP, Cloud Endpoints, and Cloud Messaging to connect
  to your app. You can develop your backend to provide cloud services your
  app needs.
  <p>Using Android Studio to develop your Google Cloud module lets
  you manage app code and backend code in the same project. You can also run and test
  your backend code locally, and use Android Studio to deploy your Google Cloud module.
  </p>
  <p>For more information on running and deploying a Google Cloud module, see
  <a href="https://cloud.google.com/tools/android-studio/app_engine/run_test_deploy">
  Running, Testing, and Deploying the Backend</a>.</p>
  </dd>

</dl>

<p>Some people also refer to modules as sub-projects and that's okay, because
Gradle also refers to modules as projects. For example,
when you create a library module and want to add it as a dependency to your
Android app module, you must declare it as follows:</p>

<pre>
dependencies {
  compile project(':my-library-module')
}
</pre>





<h2 id="ProjectFiles">Project Files</h2>

<img style="float:right;margin-left:40px;width:240px"
src="https://developer.android.com/images/tools/projectview-p1.png" alt="" />

<p>By default, Android Studio displays your project files in the
<strong>Android</strong> view. This view does not reflect
the actual file hierarchy on disk, but is organized by
modules and file types to simplify navigation between key source files of your project, hiding
certain files or directories that are not commonly used. Some of the structural
changes compared to the structure on disk include the following:</p>

<ul>
<li>Shows all the project's build-related configuration files in a top-level
<strong>Gradle Script</strong> group.</li>
<li>Shows all manifest files for each module in a module-level group (when you
have different manifest files for different product flavors and build types).
</li>
<li>Shows all alternative resource files in a single group,
instead of in separate folders per resource qualifier. For example, all density
versions of your launcher icon are visible side-by-side.</li>
</ul>

<p>Within each Android app module, files are shown in the following groups:</p>

<dl>

<dt><strong>manifests</strong></dt>
<dd>Contains the <code><a href="https://developer.android.com/guide/topics/manifest/manifest-intro.html"
>AndroidManifest.xml</a></code> file.</dd>

<dt><strong>java</strong></dt>
<dd>Contains the Java source code files, separated by package names,
including JUnit test code.</dd>

<dt><strong>res</strong></dt>
<dd>Contains all non-code resources, such as XML layouts, UI strings, and
bitmap images, divided into corresponding sub-directories. For more information
about all possible resource types, see <a
href="https://developer.android.com/guide/topics/resources/providing-resources.html">Providing Resources</a>.
</dd>
</dl>




 <h3 id="ProjectView">The Android Project View</h3>

<img style="float:right;margin-left:40px;width:240px"
src="https://developer.android.com/images/tools/projectview-p2.png" alt="" />


<p>To see the actual
file structure of the project including all files hidden from the
Android view, select <strong>Project</strong> from the dropdown
at the top of the <strong>Project</strong> window.</p>

<p>When you select <strong>Project</strong> view, you can see a lot more files
and directories. The most important of which are the following:</p>

<dl>

<dt><code><var>module-name</var>/</code></dt>
<dd>
  <dl>
    <dt><code>build/</code></dt>
    <dd>Contains build outputs.</dd>

    <dt><code>libs/</code></dt>
    <dd>Contains private libraries.</dd>

    <dt><code>src/</code></dt>
    <dd>Contains all code and resource files for the module in the following
subdirectories:
      <dl>
      <dt><code>androidTest/</code></dt>
      <dd>Contains code for instrumentation tests that run on an Android device.
      For more information, see the
       <a href="https://developer.android.com/tools/testing/index.html">Android Test documentation</a>.</dd>

      <dt><code>main/</code></dt>
      <dd>Contains the "main" sourceset files: the Android code and resources
      shared by all build variants (files for other build variants
      reside in sibling directories, such as <code>src/debug/</code> for the
      debug build type).
      <dl>
       <dt><code>AndroidManifest.xml</code></dt>
       <dd>Describes the nature of the application and each of its components.
      For more information, see the
      <a href="https://developer.android.com/guide/topics/manifest/manifest-intro.html">AndroidManifest.xml</a>
      documentation.</dd>

       <dt><code>java/</code></dt>
       <dd>Contains Java code sources.</dd>

       <dt><code>jni/</code></dt>
       <dd>Contains native code using the Java Native Interface (JNI). For more information, see the
       <a href="https://developer.android.com/ndk/index.html">Android NDK documentation</a>.</dd>

       <dt><code>gen/</code></dt>
       <dd>Contains the Java files generated by Android Studio, such as your <code>R.java</code> file and
       interfaces created from AIDL files.</dd>

       <dt><code>res/</code></dt>
       <dd>Contains application resources, such as drawable files, layout files,
        and UI string. See
       <a href="https://developer.android.com/guide/topics/resources/index.html">Application Resources</a> for more
       information.</dd>

       <dt><code>assets/</code></dt>
       <dd>Contains file that should be
       compiled into an <code>.apk</code> file as-is. You can
       navigate this directory in the same way as a typical file system using
        URIs and read files as a stream of bytes using the
        <code><a href="https://developer.android.com/reference/android/content/res/AssetManager.html">AssetManager</a>
        </code>. For example, this is a good location for textures and game
      data.</dd>
      </dl>
      </dd><!-- end main/ -->

      <dt><code>test/</code></dt>
      <dd>Contains code for local tests that run on your host JVM.</dd>

     </dl>
    </dd><!-- end src/ -->
    <dt><code>build.gradle</code> (module)</dt>
    <dd>This defines the module-specific build configurations.</dd>
  </dl>
</dd><!-- end module-name/ -->

<dt><code>build.gradle</code> (project)</dt>
<dd>This defines your build configuration that apply to all modules.
This file is integral to the project, so you should maintain them
in revision control with all other source code.
<p>For information about other build files, see
<a href="https://developer.android.com/studio/build/index.html">Configure Your Build</a>.</p>
</dd>

</dl>



<h2 id="ProjectStructure">Project Structure Settings</h2>

<p>To change various settings for your Android Studio project, open the
<strong>Project Structure</strong> dialog by clicking
<strong>File &gt; Project Structure</strong>. It contains the
following sections:
</p>

<ul>
  <li>
    <strong>SDK Location:</strong> Sets the location of the JDK, Android SDK,
    and Android NDK that your project uses.
  </li>

  <li>
    <strong>Project:</strong> Sets the version for <a
    href="https://developer.android.com/tools/building/plugin-for-gradle.html">Gradle and
    the Android plugin
    for Gradle</a>, and the repository location name.
  </li>

  <li>
    <strong>Developer Services:</strong> Contains settings for Android Studio
    add-in components from Google or other third parties. See
<a href="#dev-svc">Developer Services</a>, below.
  </li>

  <li>
    <strong>Modules:</strong> Allows you to edit module-specific build
    configurations, including the target and minimum SDK, the app signature,
    and library dependencies.
    See <a href="#modules">Modules</a>, below.
  </li>
</ul>


<h3 id="dev-svc">Developer Services</h3>

<p>
  The <em>Developer Services</em> section of the <em>Project Structure</em>
  dialog box contains configuration pages
  for several services that you can be use with your app. This section
  contains the following pages:
</p>

<ul>
  <li>
    <strong>AdMob:</strong> Allows you to turn on Google's <a href="https://developers.google.com/admob/" class="external-link">AdMob</a>
    component, which helps you understand your users and show them tailored
    advertisements.
  </li>

  <li>
    <strong>Analytics:</strong> Allows you to turn on <a href="https://developers.google.com/analytics/" class="external-link">Google
    Analytics</a>, which helps you measure user interactions with your app
    across various devices and environments.
  </li>

  <li>
    <strong>Authentication:</strong> Allows users to use <a href="https://developers.google.com/identity/sign-in/android/" class=
    "external-link">Google Sign-In</a> to sign in to your app with their Google
    accounts.
  </li>

  <li>
    <strong>Cloud:</strong> Allows you to turn on <a href="https://www.firebase.com/" class="external-link">Firebase</a> cloud-based
    services for your app.
  </li>

  <li>
    <strong>Notifications:</strong> Allows you to use <a href="https://developers.google.com/cloud-messaging/" class=
    "external-link">Google Cloud Messaging</a> to communicate between your app
    and your server.
  </li>
</ul>

<p>
  Turning on any of these services may cause Android Studio to add necessary
  dependencies and permissions to your app. Each configuration page lists these
  and other actions that Android Studio takes if you enable the associated service.
</p>


<h3 id="modules">Modules</h3>

<p>
  The <em>Modules</em> settings section lets you change configuration
  options for each of your project's modules.
  Each module's settings page is divided into the following tabs:
</p>

<ul>
  <li>
    <strong>Properties:</strong> Specifies the versions of the SDK and build
    tools to use to compile the module.
  </li>

  <li>
    <strong>Signing:</strong> Specifies the certificate to use to
    <a href="https://developer.android.com/tools/publishing/app-signing.html#sign-auto">sign your
    APK</a>.
  </li>

  <li>
    <strong>Flavors:</strong> Lets you create multiple build <em>flavors</em>, where
    each flavor specifies a set of configuration settings, such as the
    module's minimum and target SDK version, and the
    <a href="https://developer.android.com/tools/publishing/versioning.html">version code and
    version name</a>. For example, you might define one flavor that has a
    minimum SDK of 15 and a target SDK of 21, and another flavor that has a
    minimum SDK of 19 and a target SDK of 23.
  </li>

  <li>
    <strong>Build Types:</strong> Lets you create and modify build
    configurations, as described in <a href="https://developer.android.com/tools/building/configuring-gradle.html">Configuring Gradle
    Builds</a>. By default, every module has <em>debug</em> and
    <em>release</em> build types, but you can define more as needed.
  </li>

  <li>
    <strong>Dependencies:</strong> Lists the library, file, and module
    dependencies for this module. You can add, modify, and delete dependencies
    from this pane. For more information about module dependencies, see
    <a href="https://developer.android.com/tools/building/configuring-gradle.html#declareDeps">Configuring Gradle
    Builds</a>.
  </li>
</ul>

****************
## List of mobile app distribution platforms

<h2><span class="mw-headline" id="Native_platforms">Native platforms</span></span></h2>
<p>These application market places are native to the major mobile operating systems.</p>
<table style="text-align: center; width: 95%" class="wikitable sortable">
<tr>
<th>Name</th>
<th>Established</th>
<th>Status</th>
<th>Owner</th>
<th>Available apps</th>
<th>Download count</th>
<th><a href="https://en.wikipedia.org/wiki/Installed_base" title="Installed base">Installed base</a></th>
<th>Device platform</th>
<th>Allows individual developers to publish</th>
<th>Developer's cut per sale</th>
<th>Developer fees</th>
<th>Development tool(s)</th>
<th>Free of charge <a href="https://en.wikipedia.org/wiki/Integrated_development_environment" title="Integrated development environment">IDE</a>?</th>
</tr>
<tr>
<td><a href="https://en.wikipedia.org/wiki/Amazon_Appstore" title="Amazon Appstore">Amazon Appstore</a></td>
<td><span class="sortkey" style="display:none;speak:none">000000002011-03-22-0000</span><span style="white-space:nowrap">22 March 2011</span></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Live</td>
<td><a href="https://en.wikipedia.org/wiki/Amazon.com" class="mw-redirect" title="Amazon.com">Amazon.com</a></td>
<td><span style="display:none" class="sortkey">7005330000000000000♠</span>330,000<br />
<small>(March 2015)</small></td>
<td style="background: #ececec; color: #2C2C2C; font-size: smaller; vertical-align: middle; text-align: center;" class="unknown table-unknown">Unknown</td>
<td style="background: #ececec; color: #2C2C2C; font-size: smaller; vertical-align: middle; text-align: center;" class="unknown table-unknown">Unknown</td>
<td><a href="https://en.wikipedia.org/wiki/Fire_OS" title="Fire OS">Android OS (customized)</a>, <a href="https://en.wikipedia.org/wiki/Android_(operating_system)" title="Android (operating system)">Android</a></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td>70%</td>
<td><a href="https://en.wikipedia.org/wiki/United_States_dollar" title="United States dollar">US$</a>99/year<br />
<small>(Waive fee for first year, plus $50 AWS promo code</small>)</td>
<td><a href="https://en.wikipedia.org/wiki/Fire_OS" title="Fire OS">Amazon Mobile App SDK</a></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
</tr>
<tr>
<td><a href="https://en.wikipedia.org/wiki/HP_App_Catalog" class="mw-redirect" title="HP App Catalog">App Catalog</a></td>
<td><span class="sortkey" style="display:none;speak:none">000000002009-06-06-0000</span><span style="white-space:nowrap">6 June 2009</span></td>
<td style="background:#F99;vertical-align:middle;text-align:center;" class="table-no">Closed</td>
<td><a href="https://en.wikipedia.org/wiki/Palm,_Inc." title="Palm, Inc.">Palm</a>/<a href="https://en.wikipedia.org/wiki/Hewlett_Packard" class="mw-redirect" title="Hewlett Packard">HP</a></td>
<td><span style="display:none" class="sortkey">7004100020000000000♠</span>10,002<small><br />
(December 2011)</small></td>
<td><span class="nowrap"><span style="display:none" class="sortkey">7008108000000000000♠</span>108&#160;million</span><small><br />
(August 2011)</small></td>
<td><span class="nowrap"><span style="display:none" class="sortkey">7006260000000000000♠</span>2.6&#160;million</span><small><br />
(July 2010)</small></td>
<td><a href="https://en.wikipedia.org/wiki/WebOS" title="WebOS">webOS</a></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td>70%</td>
<td><span style="display:none;" class="sortkey">000 !</span><span class="sorttext">Free</span></td>
<td><a href="https://en.wikipedia.org/wiki/Enyo_(software)" title="Enyo (software)">Enyo</a></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
</tr>
<tr>
<td><a href="https://en.wikipedia.org/wiki/App_Store_(iOS)" title="App Store (iOS)">App Store</a></td>
<td><span class="sortkey" style="display:none;speak:none">000000002008-07-10-0000</span><span style="white-space:nowrap">10 July 2008</span></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Live</td>
<td><a href="https://en.wikipedia.org/wiki/Apple_Inc." title="Apple Inc.">Apple</a></td>
<td><span style="display:none" class="sortkey">7006140000000000000♠</span>1,400,000 (725,000 native to <a href="https://en.wikipedia.org/wiki/IPad" title="IPad">iPad</a>) <small><br />
(January 2015)</small></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td>56–71% (varies depending on the country)</td>
<td><a href="https://en.wikipedia.org/wiki/IOS_SDK" title="IOS SDK">iOS SDK</a>, <a href="https://en.wikipedia.org/wiki/Xcode" title="Xcode">Xcode</a></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes <small>(Xcode 6 is free on the <a href="https://en.wikipedia.org/wiki/Mac_App_Store" title="Mac App Store">Mac App Store</a> and <a href="https://en.wikipedia.org/wiki/Apple_Developer" title="Apple Developer">Apple Developer</a>.)</small></td>
</tr>
<tr>
<td><a href="https://en.wikipedia.org/wiki/BlackBerry_World" title="BlackBerry World">BlackBerry World</a></td>
<td><span class="sortkey" style="display:none;speak:none">000000002009-04-01-0000</span><span style="white-space:nowrap">1 April 2009</span></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Live</td>
<td><a href="https://en.wikipedia.org/wiki/BlackBerry" title="BlackBerry">BlackBerry</a></td>
<td><span style="display:none" class="sortkey">7005223601000000000♠</span>223,601<small><br />
(26 October 2013) BlackBerry OS, PlayBook and BlackBerry 10 apps</small></td>
<td><span class="nowrap"><span style="display:none" class="sortkey">7009300000000000000♠</span>3&#160;billion</span><small><br />
(May 2012)</small></td>
<td><span class="nowrap"><span style="display:none" class="sortkey">7007750000000000000♠</span>75&#160;million</span><small><br />
(Jan 2012)</small></td>
<td><a href="https://en.wikipedia.org/wiki/BlackBerry_OS" title="BlackBerry OS">BlackBerry OS</a>, <a href="https://en.wikipedia.org/wiki/BlackBerry_Tablet_OS" title="BlackBerry Tablet OS">BlackBerry Tablet OS</a>, <a href="https://en.wikipedia.org/wiki/BlackBerry_10" title="BlackBerry 10">BlackBerry 10 OS</a></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td>70%</td>
<td><span style="display:none;" class="sortkey">000 !</span><span class="sorttext">Free</span></td>
<td>BlackBerry 10 Native SDK (with full <a href="https://en.wikipedia.org/wiki/POSIX" title="POSIX">POSIX</a> and <a href="https://en.wikipedia.org/wiki/Qt_(software)" title="Qt (software)">Qt</a> support), HTML5 Qt4 SDK, Android (via BlackBerry Android Tools SDK), Adobe AIR SDK, BlackBerry OS SDK</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
</tr>
<tr>
<td><a href="https://en.wikipedia.org/wiki/Danger_Hiptop" title="Danger Hiptop">Download Catalog</a></td>
<td><span class="sortkey" style="display:none;speak:none">000000002002-10-01-0000</span><span style="white-space:nowrap">1 October 2002</span></td>
<td style="background:#F99;vertical-align:middle;text-align:center;" class="table-no">Closed</td>
<td><a href="https://en.wikipedia.org/wiki/Danger_(company)" class="mw-redirect" title="Danger (company)">Danger, Inc.</a>/<a href="https://en.wikipedia.org/wiki/Microsoft" title="Microsoft">Microsoft</a></td>
<td style="background: #ececec; color: #2C2C2C; font-size: smaller; vertical-align: middle; text-align: center;" class="unknown table-unknown">Unknown</td>
<td style="background: #ececec; color: #2C2C2C; font-size: smaller; vertical-align: middle; text-align: center;" class="unknown table-unknown">Unknown</td>
<td style="background: #ececec; color: #2C2C2C; font-size: smaller; vertical-align: middle; text-align: center;" class="unknown table-unknown">Unknown</td>
<td><a href="https://en.wikipedia.org/wiki/Danger_Hiptop#Software" title="Danger Hiptop">Danger OS</a></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td>40%</td>
<td><span style="display:none;" class="sortkey">000 !</span><span class="sorttext">Free</span></td>
<td><span class="nowrap"><a href="https://en.wikipedia.org/wiki/Danger_Hiptop#Software" title="Danger Hiptop">Danger OS SDK</a></span></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
</tr>
<tr>
<td><a href="https://en.wikipedia.org/wiki/Google_Play" title="Google Play">Google Play</a></td>
<td><span class="sortkey" style="display:none;speak:none">000000002008-10-22-0000</span><span style="white-space:nowrap">22 October 2008</span></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Live</td>
<td><a href="https://en.wikipedia.org/wiki/Google" title="Google">Google</a></td>
<td><span style="display:none" class="sortkey">7006228000000000000♠</span>2,280,000<br />
<small>(July 2016)</small></td>
<td><span class="nowrap"><span style="display:none" class="sortkey">7010500000000000000♠</span>50&#160;billion</span><small><br />
(July 2013)</small></td>
<td>over <span class="nowrap"><span style="display:none" class="sortkey">7009200000000000000♠</span>2&#160;billion</span><small><br />
(May 2017)</small></td>
<td><a href="https://en.wikipedia.org/wiki/Android_(operating_system)" title="Android (operating system)">Android</a></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td>70%</td>
<td><span style="display:none;" class="sortkey">025 !</span><span class="sorttext"><a href="https://en.wikipedia.org/wiki/United_States_dollar" title="United States dollar">US$</a>25</span></td>
<td><a href="https://en.wikipedia.org/wiki/Android_SDK" class="mw-redirect" title="Android SDK">Android SDK</a>, <a href="/wiki/Android_Studio" title="Android Studio">Android Studio</a></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
</tr>
<tr>
<td><a href="https://en.wikipedia.org/wiki/Mozilla#Firefox_Marketplace" title="Mozilla">Firefox Marketplace</a></td>
<td><span class="sortkey" style="display:none;speak:none">000000002013-09-06-0000</span><span style="white-space:nowrap">6 September 2013</span></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Live</td>
<td><a href="https://en.wikipedia.org/wiki/Mozilla_Foundation" title="Mozilla Foundation">Mozilla Foundation</a></td>
<td><span style="display:none" class="sortkey">7003595700000000000♠</span>5,957<br />
<small>(March 2014)</small></td>
<td style="background: #ececec; color: #2C2C2C; font-size: smaller; vertical-align: middle; text-align: center;" class="unknown table-unknown">Unknown</td>
<td style="background: #ececec; color: #2C2C2C; font-size: smaller; vertical-align: middle; text-align: center;" class="unknown table-unknown">Unknown</td>
<td><a href="https://en.wikipedia.org/wiki/Firefox_OS" title="Firefox OS">Firefox OS</a></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background: #ececec; color: #2C2C2C; font-size: smaller; vertical-align: middle; text-align: center;" class="unknown table-unknown">Unknown</td>
<td style="background: #ececec; color: #2C2C2C; font-size: smaller; vertical-align: middle; text-align: center;" class="unknown table-unknown">Unknown</td>
<td style="background: #ececec; color: #2C2C2C; font-size: smaller; vertical-align: middle; text-align: center;" class="unknown table-unknown">Unknown</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
</tr>
<tr>
<td><a href="https://en.wikipedia.org/wiki/Ovi_(Nokia)" title="Ovi (Nokia)">Nokia Store</a></td>
<td><span class="sortkey" style="display:none;speak:none">000000002009-05-26-0000</span><span style="white-space:nowrap">26 May 2009</span></td>
<td style="background:#F99;vertical-align:middle;text-align:center;" class="table-no">replaced with the <a href="https://en.wikipedia.org/wiki/Opera_Mobile_Store" title="Opera Mobile Store">Opera Mobile Store</a></td>
<td><a href="https://en.wikipedia.org/wiki/Nokia" title="Nokia">Nokia</a></td>
<td><span style="display:none" class="sortkey">7005120000000000000♠</span>120,000 <small>(August 2012)</small></td>
<td><br />
17 million/day <small>(October 2012)</small>
<p>~<span class="nowrap"><span style="display:none" class="sortkey">7009600000000000000♠</span>6&#160;billion</span> <small>(August 2012)</small></p>
</td>
<td><span class="nowrap"><span style="display:none" class="sortkey">7008885000000000000♠</span>885&#160;million</span><br />
</td>
<td>Multiple<br />
<br />
<small><a href="https://en.wikipedia.org/wiki/Symbian" title="Symbian">Symbian</a>, <a href="https://en.wikipedia.org/wiki/MeeGo" title="MeeGo">MeeGo</a>, <a href="/wiki/Maemo" title="Maemo">Maemo</a>, <a href="https://en.wikipedia.org/wiki/Series_40" title="Series 40">S40</a>, <a href="https://en.wikipedia.org/wiki/Nokia_X_Software_Platform" class="mw-redirect" title="Nokia X Software Platform">Nokia X software platform</a></small></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td>70%</td>
<td><span style="display:none;" class="sortkey">002 !</span><span class="sorttext">1 <a href="https://en.wikipedia.org/wiki/Euro" title="Euro">€</a><</span></td>
<td><span class="nowrap"><a href="https://en.wikipedia.org/wiki/Qt_(framework)" class="mw-redirect" title="Qt (framework)">Qt 4 SDK</a>,</span> <span class="nowrap"><a href="/w/index.php?title=Nokia_Web_Tools&amp;action=edit&amp;redlink=1" class="new" title="Nokia Web Tools (page does not exist)">Nokia Web Tools</a>,</span> <span class="nowrap"><a href="/w/index.php?title=Nokia_SDK_for_Java&amp;action=edit&amp;redlink=1" class="new" title="Nokia SDK for Java (page does not exist)">Nokia SDK for Java</a>, <a href="https://en.wikipedia.org/wiki/Java_ME" class="mw-redirect" title="Java ME">Java ME</a></span>, <a href="https://en.wikipedia.org/wiki/Nokia_X_Software_Platform" class="mw-redirect" title="Nokia X Software Platform">Nokia X services SDK</a> </td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
</tr>
<tr>
<td><a href="https://en.wikipedia.org/wiki/Samsung_Galaxy_Apps" title="Samsung Galaxy Apps">Samsung Galaxy Apps</a></td>
<td><span class="sortkey" style="display:none;speak:none">000000002009-06-01-0000</span><span style="white-space:nowrap">June 2009</span></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">live</td>
<td><a href="https://en.wikipedia.org/wiki/Samsung" title="Samsung">Samsung</a></td>
</tr>
<tr>
<td><a href="https://en.wikipedia.org/wiki/Ubuntu_App_Store" class="mw-redirect" title="Ubuntu App Store">Ubuntu App Store</a></td>
<td><span class="sortkey" style="display:none;speak:none">000000002013-10-17-0000</span><span style="white-space:nowrap">17 October 2013</span></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Live</td>
<td><a href="https://en.wikipedia.org/wiki/Canonical_(company)" title="Canonical (company)">Canonical</a></td>
<td><span style="display:none" class="sortkey">7003265000000000000♠</span>2,650+<small><br />
(December 2015, incl. web apps and scopes)</small><br />
</td>
<td style="background: #ececec; color: #2C2C2C; font-size: smaller; vertical-align: middle; text-align: center;" class="unknown table-unknown">Unknown</td>
<td style="background: #ececec; color: #2C2C2C; font-size: smaller; vertical-align: middle; text-align: center;" class="unknown table-unknown">Unknown</td>
<td><a href="https://en.wikipedia.org/wiki/Ubuntu_Touch" title="Ubuntu Touch">Ubuntu Touch</a></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background: #ececec; color: #2C2C2C; font-size: smaller; vertical-align: middle; text-align: center;" class="unknown table-unknown">Unknown</td>
<td style="background: #ececec; color: #2C2C2C; font-size: smaller; vertical-align: middle; text-align: center;" class="unknown table-unknown">Unknown</td>
<td><a href="/w/index.php?title=Ubuntu_SDK&amp;action=edit&amp;redlink=1" class="new" title="Ubuntu SDK (page does not exist)">Ubuntu SDK</a></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
</tr>
<tr>
<td><a href="https://en.wikipedia.org/wiki/Windows_Phone_Store" title="Windows Phone Store">Windows Phone Store</a></td>
<td><span class="sortkey" style="display:none;speak:none">000000002010-10-21-0000</span><span style="white-space:nowrap">21 October 2010</span></td>
<td style="background:#F99;vertical-align:middle;text-align:center;" class="table-no">merged with the <a href="/wiki/Windows_Store" title="Windows Store">Windows Store</a></td>
<td><a href="https://en.wikipedia.org/wiki/Microsoft" title="Microsoft">Microsoft</a></td>
<td><span style="display:none" class="sortkey">7005400000000000000♠</span>400,000+<small><br />
(March 2015)</small><br />
<p></p>
</td>
<td><span class="nowrap"><span style="display:none" class="sortkey">7009900000000000000♠</span>9&#160;billion</span><small><br />
(March 2015)</small><br />
(<span class="nowrap"><span style="display:none" class="sortkey">7002105000000000000♠</span>105</span> per device)</td>
<td><span class="nowrap"><span style="display:none" class="sortkey">7008100000000000000♠</span>100&#160;million</span><br />
(<small>June 2015)</small></td>
<td><a href="https://en.wikipedia.org/wiki/Windows_Phone" title="Windows Phone">Windows Phone</a></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td>70%</td>
<td><span style="display:none;" class="sortkey">19 !</span><span class="sorttext"><a href="https://en.wikipedia.org/wiki/United_States_dollar" title="United States dollar">US$</a>19 for individuals, or US$99 for companies /year/unlimited paid apps and 100 free apps submissions Or</span>
<p><span class="sorttext">Free for students</span>  One Registration fee for both of Windows phone Store and Windows Store.</p>
</td>
<td><a href="/w/index.php?title=Windows_Phone_Developer_Tools&amp;action=edit&amp;redlink=1" class="new" title="Windows Phone Developer Tools (page does not exist)">Windows Phone Developer Tools</a>, includes specialty versions of <a href="https://en.wikipedia.org/wiki/Microsoft_Visual_Studio" title="Microsoft Visual Studio">Microsoft Visual Studio</a>, <a href="https://en.wikipedia.org/wiki/Expression_Blend" class="mw-redirect" title="Expression Blend">Expression Blend</a></td>
<td>Yes</td>
</tr>
<tr>
<td><a href="https://en.wikipedia.org/wiki/Windows_Store" title="Windows Store">Windows Store</a></td>
<td><span class="sortkey" style="display:none;speak:none">000000002012-10-26-0000</span><span style="white-space:nowrap">26 October 2012</span></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Live</td>
<td><a href="https://en.wikipedia.org/wiki/Microsoft" title="Microsoft">Microsoft</a></td>
<td><span style="display:none" class="sortkey">7005669000000000000♠</span>669,000+
<p><small>(September 2015)</small></p>
</td>
<td style="background: #ececec; color: #2C2C2C; font-size: smaller; vertical-align: middle; text-align: center;" class="unknown table-unknown">Unknown</td>
<td><span class="nowrap"><span style="display:none" class="sortkey">7008410000000000000♠</span>410&#160;million</span> PC devices<br />
<small>(November 2015)</small><br />
<p><span class="nowrap"><span style="display:none" class="sortkey">7007930000000000000♠</span>93&#160;million</span> <small>smartphones</small><br />
<small>(September 2015)</small></p>
</td>
<td><a href="https://en.wikipedia.org/wiki/Windows_8" title="Windows 8">Windows 8</a>, <a href="https://en.wikipedia.org/wiki/Windows_RT" title="Windows RT">Windows RT</a>, <a href="https://en.wikipedia.org/wiki/Windows_8.1" title="Windows 8.1">Windows 8.1</a>, <a href="https://en.wikipedia.org/wiki/Windows_10" title="Windows 10">Windows 10</a>, <a href="/wiki/Windows_10_Mobile" title="Windows 10 Mobile">Windows 10 Mobile</a>, <a href="https://en.wikipedia.org/wiki/Windows_Phone" title="Windows Phone">Windows Phone</a></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes with restriction</td>
<td>70% that is raised to 80% if developer sales exceeds <a href="https://en.wikipedia.org/wiki/United_States_dollar" title="United States dollar">US$</a>25,000 in a year</td>
<td><span style="display:none;" class="sortkey">19 !</span><span class="sorttext">Individuals: <a href="https://en.wikipedia.org/wiki/United_States_dollar" title="United States dollar">US$</a>19/year or <a href="https://en.wikipedia.org/wiki/United_States_dollar" title="United States dollar">US$</a>0/year for student, Companies:<a href="https://en.wikipedia.org/wiki/United_States_dollar" title="United States dollar">US$</a>99/year</span> . One Registration fee for both of Windows phone Store and Windows Store.</td>
<td><a href="https://en.wikipedia.org/wiki/Visual_Studio_2013" class="mw-redirect" title="Visual Studio 2013">Visual Studio 2013</a> or higher for Windows 8.1.<br />
<a href="https://en.wikipedia.org/wiki/Visual_Studio_2015" class="mw-redirect" title="Visual Studio 2015">Visual Studio 2015</a> or higher for Universal Apps.<br />
<a href="https://en.wikipedia.org/wiki/Windows_App_Studio" title="Windows App Studio">Windows App Studio</a></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td></td>
</tr>
<tr>
<th>Name</th>
<th>Established</th>
<th>Status</th>
<th>Owner</th>
<th>Available apps</th>
<th>Download count</th>
<th><a href="https://en.wikipedia.org/wiki/Installed_base" title="Installed base">Installed base</a></th>
<th>Device platform</th>
<th>Allows individual developers to publish</th>
<th>Developer's cut per sale</th>
<th>Developer fees</th>
<th>Development tool(s)</th>
<th>Free of charge <a href="https://en.wikipedia.org/wiki/Integrated_development_environment" title="Integrated development environment">IDE</a>?</th>
</tr>
</table>
<dl>
<dt>Notes</dt>
<dd>
<div class="reflist" style="list-style-type: decimal;"></div>
</dd>
</dl>
<div class="mw-references-wrap">
<ol class="references">
<li id="cite_note-wp7-52"><span class="mw-cite-backlink"><b><a href="#cite_ref-wp7_52-0">^</a></b></span> <span class="reference-text">Including Windows Phone 8.0, Windows Phone 8.1 and Windows 10 Mobile. Excluding Windows Phone 7, because although it is still live, so is no longer supported and never be able to take advantage of all types of applications (e.g. universal apps)</span></li>
<li id="cite_note-microsoft-60"><span class="mw-cite-backlink"><b><a href="#cite_ref-microsoft_60-0">^</a></b></span> <span class="reference-text">Microsoft classifies developer accounts to individual accounts and company accounts. Individual accounts are restricted from using specific app capabilities and cannot list desktop apps in Windows Store, while company accounts do not have this restriction. Microsoft verifies company accounts by contacting the company official, while this is not done for individual accounts.</span></li>
</ol>
</div>
<h2><span class="mw-headline" id="Third-party_platforms">Third-party platforms</span></span></h2>
<p>Third-party platforms are software distribution platforms which are used as alternatives for operating system native distribution platforms. Independent operating systems are software collections which use their own software distribution, customized user interface, SDK and API (except billing API which is related only to application store).</p>
<table style="text-align: center; width: 95%" class="wikitable sortable">
<tr>
<th>Name</th>
<th data-sort-type="number">Established</th>
<th>Status</th>
<th>Organizations</th>
<th>Available apps</th>
<th>Download count</th>
<th>Install base</th>
<th>Device platform</th>
<th>Developer's cut per sale</th>
<th>Developer fees</th>
<th>Developer Console</th>
<th>Development platform(s)</th>
</tr>
<tr>
<td><a href="https://en.wikipedia.org/wiki/Appland" title="Appland">Appland</a></td>
<td>2011</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Live</td>
<td>Appland</td>
<td>130,000</td>
<td>25 million (March 2016)</td>
<td>5 million (March 2016)</td>
<td><a href="https://en.wikipedia.org/wiki/Android_(operating_system)" title="Android (operating system)">Android</a> and <a href="https://en.wikipedia.org/wiki/IOS" title="IOS">iOS</a></td>
<td>Up to 70%</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Free</td>
<td style="background: #ececec; color: #2C2C2C; font-size: smaller; vertical-align: middle; text-align: center;" class="unknown table-unknown">Unknown</td>
<td style="background: #ececec; color: #2C2C2C; font-size: smaller; vertical-align: middle; text-align: center;" class="unknown table-unknown">Unknown</td>
</tr>
<tr>
<td><a href="https://en.wikipedia.org/wiki/Aptoide" title="Aptoide">Aptoide</a></td>
<td><span class="sortkey" style="display:none;speak:none">000000002010-10-01-0000</span><span style="white-space:nowrap">October 2010</span></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Live</td>
<td><a href="https://en.wikipedia.org/wiki/Aptoide" title="Aptoide">Aptoide</a></td>
<td><span style="display:none" class="sortkey">7005311000000000000♠</span>311,000<br />
<small>(April 2015)</small></td>
<td><span class="nowrap"><span style="display:none" class="sortkey">7008300000000000000♠</span>300&#160;million</span><br />
<small>(March 2013)</small></td>
<td><span class="nowrap"><span style="display:none" class="sortkey">7007105000000000000♠</span>10.5&#160;million</span><br />
<small>(January 2013)</small></td>
<td><a href="https://en.wikipedia.org/wiki/Android_(operating_system)" title="Android (operating system)">Android</a></td>
<td>up to 87.5%</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Free</td>
<td style="background: #ececec; color: #2C2C2C; font-size: smaller; vertical-align: middle; text-align: center;" class="unknown table-unknown">Unknown</td>
<td><a href="https://en.wikipedia.org/wiki/Android_SDK" class="mw-redirect" title="Android SDK">Android SDK</a>, <a href="/wiki/Java_ME" class="mw-redirect" title="Java ME">Java ME</a></td>
</tr>
<tr>
<td><a href="https://en.wikipedia.org/wiki/Cydia" title="Cydia">Cydia</a></td>
<td><span class="sortkey" style="display:none;speak:none">000000002008-02-01-0000</span><span style="white-space:nowrap">February 2008</span></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Live</td>
<td><a href="https://en.wikipedia.org/wiki/Jay_Freeman" title="Jay Freeman">saurik</a></td>
<td style="background: #ececec; color: #2C2C2C; font-size: smaller; vertical-align: middle; text-align: center;" class="unknown table-unknown">Unknown</td>
<td style="background: #ececec; color: #2C2C2C; font-size: smaller; vertical-align: middle; text-align: center;" class="unknown table-unknown">Unknown</td>
<td><span class="nowrap"><span style="display:none" class="sortkey">7007300000000000000♠</span>30&#160;million</span></td>
<td><a href="https://en.wikipedia.org/wiki/IOS_(Apple)" class="mw-redirect" title="IOS (Apple)">iOS</a></td>
<td data-sort-value="" style="background: #ececec; color: #2C2C2C; vertical-align: middle; font-size: smaller; text-align: center;" class="table-na">N/A</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Free</td>
<td style="background: #ececec; color: #2C2C2C; font-size: smaller; vertical-align: middle; text-align: center;" class="unknown table-unknown">Unknown</td>
<td><a href="https://en.wikipedia.org/wiki/IOS_SDK" title="IOS SDK">iOS SDK</a>, <a href="https://en.wikipedia.org/wiki/Xcode" title="Xcode">Xcode</a></td>
</tr>
<tr>
<td><a href="https://en.wikipedia.org/wiki/F-Droid" title="F-Droid">F-Droid</a></td>
<td><span class="sortkey" style="display:none;speak:none">000000002010-01-01-0000</span><span style="white-space:nowrap">2010</span></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Live</td>
<td>F-Droid Limited</td>
<td><span style="display:none" class="sortkey">7003187800000000000♠</span>1,878</td>
<td><span class="nowrap"><span style="display:none" class="sortkey">7008248000000000000♠</span>248&#160;million</span><br />
<small>(Mar 2015)</small></td>
<td style="background: #ececec; color: #2C2C2C; font-size: smaller; vertical-align: middle; text-align: center;" class="unknown table-unknown">Unknown</td>
<td><a href="https://en.wikipedia.org/wiki/Android_(operating_system)" title="Android (operating system)">Android</a></td>
<td data-sort-value="" style="background: #ececec; color: #2C2C2C; vertical-align: middle; font-size: smaller; text-align: center;" class="table-na">N/A</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Free</td>
<td style="background: #ececec; color: #2C2C2C; font-size: smaller; vertical-align: middle; text-align: center;" class="unknown table-unknown">Unknown</td>
<td><a href="https://en.wikipedia.org/wiki/Android_SDK" class="mw-redirect" title="Android SDK">Android SDK</a></td>
</tr>
<tr>
<td><a href="https://en.wikipedia.org/wiki/GetJar" title="GetJar">GetJar</a></td>
<td><span class="sortkey" style="display:none;speak:none">000000002004-01-01-0000</span><span style="white-space:nowrap">2004</span></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Live</td>
<td><a href="https://en.wikipedia.org/wiki/GetJar" title="GetJar">GetJar</a>, <a href="https://en.wikipedia.org/wiki/Accel_Partners" title="Accel Partners">Accel Partners</a></td>
<td><span style="display:none" class="sortkey">7005849036000000000♠</span>849,036<br />
<small>(March 2015)</small></td>
<td><span class="nowrap"><span style="display:none" class="sortkey">7009300000000000000♠</span>3&#160;billion</span><br />
<small>(March 2015)</small></td>
<td><span class="nowrap"><span style="display:none" class="sortkey">7008200000000000000♠</span>200&#160;million</span> users</td>
<td>Multiple<br />
<small><a href="https://en.wikipedia.org/wiki/Android_(operating_system)" title="Android (operating system)">Android</a>, <a href="/wiki/BlackBerry_OS" title="BlackBerry OS">BlackBerry OS</a>, <a href="https://en.wikipedia.org/wiki/Adobe_Flash_Lite" title="Adobe Flash Lite">Flash Lite</a>, <a href="https://en.wikipedia.org/wiki/Java_(software_platform)#Mobile_devices" title="Java (software platform)">Java</a>, <a href="https://en.wikipedia.org/wiki/IOS" title="IOS">iOS</a>, <a href="https://en.wikipedia.org/wiki/Palm_OS" title="Palm OS">Palm OS</a>, <a href="https://en.wikipedia.org/wiki/Symbian" title="Symbian">Symbian</a>, <a href="https://en.wikipedia.org/wiki/Windows_Phone" title="Windows Phone">Windows Phone</a></small></td>
<td data-sort-value="" style="background: #ececec; color: #2C2C2C; vertical-align: middle; font-size: smaller; text-align: center;" class="table-na">N/A</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Free</td>
<td style="background: #ececec; color: #2C2C2C; font-size: smaller; vertical-align: middle; text-align: center;" class="unknown table-unknown">Unknown</td>
<td style="background: #ececec; color: #2C2C2C; font-size: smaller; vertical-align: middle; text-align: center;" class="unknown table-unknown">Unknown</td>
</tr>
<tr>
<td><a href="https://en.wikipedia.org/wiki/Handango" title="Handango">Handango</a></td>
<td><span class="sortkey" style="display:none;speak:none">000000002000-01-01-0000</span><span style="white-space:nowrap">2000</span></td>
<td style="background:#F99;vertical-align:middle;text-align:center;" class="table-no">Closed</td>
<td><a href="https://en.wikipedia.org/wiki/PocketGear" class="mw-redirect" title="PocketGear">PocketGear</a></td>
<td><span style="display:none" class="sortkey">7005190000000000000♠</span>190,000</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background: #ececec; color: #2C2C2C; font-size: smaller; vertical-align: middle; text-align: center;" class="unknown table-unknown">Unknown</td>
<td>Multiple<br />
<small><a href="https://en.wikipedia.org/wiki/Android_(operating_system)" title="Android (operating system)">Android</a>, <a href="https://en.wikipedia.org/wiki/BlackBerry_OS" title="BlackBerry OS">BlackBerry OS</a>, <a href="https://en.wikipedia.org/wiki/Palm_OS" title="Palm OS">Palm OS</a>, <a href="https://en.wikipedia.org/wiki/PSP" class="mw-redirect" title="PSP">PSP</a>, <a href="https://en.wikipedia.org/wiki/Symbian" title="Symbian">Symbian</a>, <a href="https://en.wikipedia.org/wiki/Windows_Mobile" title="Windows Mobile">Windows Mobile</a></small></td>
<td>≈42%</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Free</td>
<td data-sort-value="" style="background: #ececec; color: #2C2C2C; vertical-align: middle; font-size: smaller; text-align: center;" class="table-na">N/A</td>
<td></td>
</tr>
<tr>
<td><a href="https://en.wikipedia.org/wiki/Handmark" title="Handmark">Handmark</a></td>
<td><span class="sortkey" style="display:none;speak:none">000000002000-01-01-0000</span><span style="white-space:nowrap">2000</span></td>
<td style="background:#F99;vertical-align:middle;text-align:center;" class="table-no">Closed</td>
<td><a href="https://en.wikipedia.org/wiki/Handmark" title="Handmark">Handmark</a></td>
<td style="background: #ececec; color: #2C2C2C; font-size: smaller; vertical-align: middle; text-align: center;" class="unknown table-unknown">Unknown</td>
<td style="background: #ececec; color: #2C2C2C; font-size: smaller; vertical-align: middle; text-align: center;" class="unknown table-unknown">Unknown</td>
<td style="background: #ececec; color: #2C2C2C; font-size: smaller; vertical-align: middle; text-align: center;" class="unknown table-unknown">Unknown</td>
<td>Multiple<br />
<small><a href="https://en.wikipedia.org/wiki/Android_(operating_system)" title="Android (operating system)">Android</a>, <a href="https://en.wikipedia.org/wiki/BlackBerry_OS" title="BlackBerry OS">BlackBerry OS</a>, <a href="https://en.wikipedia.org/wiki/IOS_(Apple)" class="mw-redirect" title="IOS (Apple)">iOS</a>, <a href="https://en.wikipedia.org/wiki/Java_(software_platform)#Mobile_devices" title="Java (software platform)">Java</a>, <a href="/wiki/Palm_OS" title="Palm OS">Palm OS</a>, <a href="https://en.wikipedia.org/wiki/Symbian" title="Symbian">Symbian</a>, <a href="/wiki/Windows_Mobile" title="Windows Mobile">Windows Mobile</a></small></td>
<td style="background: #ececec; color: #2C2C2C; font-size: smaller; vertical-align: middle; text-align: center;" class="unknown table-unknown">Unknown</td>
<td style="background: #ececec; color: #2C2C2C; font-size: smaller; vertical-align: middle; text-align: center;" class="unknown table-unknown">Unknown</td>
<td style="background: #ececec; color: #2C2C2C; font-size: smaller; vertical-align: middle; text-align: center;" class="unknown table-unknown">Unknown</td>
<td style="background: #ececec; color: #2C2C2C; font-size: smaller; vertical-align: middle; text-align: center;" class="unknown table-unknown">Unknown</td>
</tr>
<tr>
<td><a rel="nofollow" class="external text" href="https://installfish.com/">Installfish</a></td>
<td>2015</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Live</td>
<td><a rel="nofollow" class="external text" href="http://www.dogfi.sh">Dogfi.sh Mobile</a></td>
<td>Unknown</td>
<td>Unknown</td>
<td>Unknown</td>
<td><a href="https://en.wikipedia.org/wiki/Android_(operating_system)" title="Android (operating system)">Android</a>, <a href="https://en.wikipedia.org/wiki/IOS" title="IOS">iOS</a></td>
<td>Unknown</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Free</td>
<td>Unknown</td>
<td></td>
</tr>
<tr>
<td><a href="https://en.wikipedia.org/wiki/MiKandi" title="MiKandi">MiKandi</a></td>
<td><span class="sortkey" style="display:none;speak:none">000000002009-11-29-0000</span><span style="white-space:nowrap">29 November 2009</span></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Live</td>
<td><a href="https://en.wikipedia.org/wiki/MiKandi" title="MiKandi">MiKandi</a></td>
<td style="background: #ececec; color: #2C2C2C; font-size: smaller; vertical-align: middle; text-align: center;" class="unknown table-unknown">Unknown</td>
<td style="background: #ececec; color: #2C2C2C; font-size: smaller; vertical-align: middle; text-align: center;" class="unknown table-unknown">Unknown</td>
<td><span style="display:none" class="sortkey">7004800000000000000♠</span>80,000<br />
<small>(December 2009)</td>
<td><a href="https://en.wikipedia.org/wiki/Android_(operating_system)" title="Android (operating system)">Android</a></td>
<td style="background: #ececec; color: #2C2C2C; font-size: smaller; vertical-align: middle; text-align: center;" class="unknown table-unknown">Unknown</td>
<td style="background: #ececec; color: #2C2C2C; font-size: smaller; vertical-align: middle; text-align: center;" class="unknown table-unknown">Unknown</td>
<td style="background: #ececec; color: #2C2C2C; font-size: smaller; vertical-align: middle; text-align: center;" class="unknown table-unknown">Unknown</td>
<td style="background: #ececec; color: #2C2C2C; font-size: smaller; vertical-align: middle; text-align: center;" class="unknown table-unknown">Unknown</td>
</tr>
<tr>
<td><a href="https://en.wikipedia.org/wiki/Opera_Mobile_Store" title="Opera Mobile Store">Opera Mobile Store</a></td>
<td><span class="sortkey" style="display:none;speak:none">000000002011-03-01-0000</span><span style="white-space:nowrap">March 2011</span></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Live</td>
<td><a href="https://en.wikipedia.org/wiki/Opera_Software" title="Opera Software">Opera Software</a></td>
<td><span style="display:none" class="sortkey">7005300000000000000♠</span>300,000<br />
<small>(November 2014)</small></td>
<td><span class="nowrap"><span style="display:none" class="sortkey">7007450000000000000♠</span>45&#160;million</span> per month<br />
<small>(December 2012)</small></td>
<td style="background: #ececec; color: #2C2C2C; font-size: smaller; vertical-align: middle; text-align: center;" class="unknown table-unknown">Unknown</td>
<td>Multiple<br />
<small><a href="https://en.wikipedia.org/wiki/Android_(operating_system)" title="Android (operating system)">Android</a>, <a href="https://en.wikipedia.org/wiki/Java_(software_platform)#Mobile_devices" title="Java (software platform)">Java</a>, <a href="https://en.wikipedia.org/wiki/Symbian" title="Symbian">Symbian</a>, <a href="https://en.wikipedia.org/wiki/BlackBerry_OS" title="BlackBerry OS">BlackBerry OS</a>, <a href="https://en.wikipedia.org/wiki/Windows_Mobile" title="Windows Mobile">Windows Mobile</a>, <a href="https://en.wikipedia.org/wiki/IOS_(Apple)" class="mw-redirect" title="IOS (Apple)">iOS</a></small></td>
<td><span style="display:none" class="sortkey">7001700000000000000♠</span>70% — Android, Symbian, BlackBerry, Windows Mobile; 50% — Java</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Free</td>
<td style="background: #ececec; color: #2C2C2C; font-size: smaller; vertical-align: middle; text-align: center;" class="unknown table-unknown">Unknown</td>
<td><a href="https://en.wikipedia.org/wiki/Android_SDK" class="mw-redirect" title="Android SDK">Android SDK</a>, <a href="/wiki/Java_ME" class="mw-redirect" title="Java ME">Java ME</a>, <a href="https://en.wikipedia.org/wiki/S60_(software_platform)" title="S60 (software platform)">S60</a>, <a href="/w/index.php?title=BlackBerry_SDK&amp;action=edit&amp;redlink=1" class="new" title="BlackBerry SDK (page does not exist)">BlackBerry SDK</a>, <a href="/w/index.php?title=Windows_Phone_Developer_Tools&amp;action=edit&amp;redlink=1" class="new" title="Windows Phone Developer Tools (page does not exist)">Windows Phone Developer Tools</a></td>
</tr>
<tr>
<td><a href="https://en.wikipedia.org/wiki/PocketGear" class="mw-redirect" title="PocketGear">PocketGear</a></td>
<td>1999</td>
<td style="background:#F99;vertical-align:middle;text-align:center;" class="table-no">Closed</td>
<td><a href="https://en.wikipedia.org/wiki/PocketGear" class="mw-redirect" title="PocketGear">PocketGear</a></td>
<td><span style="display:none" class="sortkey">7005140000000000000♠</span>140,000<br />
<small>(June 2010)</small></td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Yes</td>
<td style="background: #ececec; color: #2C2C2C; font-size: smaller; vertical-align: middle; text-align: center;" class="unknown table-unknown">Unknown</td>
<td>Multiple<small><br />
<a href="https://en.wikipedia.org/wiki/Android_(operating_system)" title="Android (operating system)">Android</a>, <a href="https://en.wikipedia.org/wiki/BlackBerry_OS" title="BlackBerry OS">BlackBerry OS</a>, <a href="https://en.wikipedia.org/wiki/Java_(software_platform)#Mobile_devices" title="Java (software platform)">Java</a>, <a href="/wiki/Palm_OS" title="Palm OS">Palm OS</a>, <a href="https://en.wikipedia.org/wiki/Symbian" title="Symbian">Symbian</a>, <a href="/wiki/Windows_Mobile" title="Windows Mobile">Windows Mobile</a></small></td>
<td>≈55%</td>
<td style="background:#9F9;vertical-align:middle;text-align:center;" class="table-yes">Free</td>
<td style="background: #ececec; color: #2C2C2C; font-size: smaller; vertical-align: middle; text-align: center;" class="unknown table-unknown">Unknown</td>
<td data-sort-value="" style="background: #ececec; color: #2C2C2C; vertical-align: middle; font-size: smaller; text-align: center;" class="table-na">N/A</td>
</tr>
<tr>
<th>Name</th>
<th>Established</th>
<th>Status</th>
<th>Organizations</th>
<th>Available apps</th>
<th>Download count</th>
<th>Install base</th>
<th>Device platform</th>
<th>Developer's cut per sale</th>
<th>Developer fees</th>
<th>Developer Console</th>
<th>Development platform(s)</th>
</tr>
</table>

************

## next steps

### Cross-Platform Mobile app Development

* phonegap/apache cordova

* xamarin

* unity

* appcelerator

*****************
**********************


