<div class="section-inner sectionLayout--insetColumn">
                                 <h1 name="3c96" id="3c96" class="graf graf--h3 graf--leading graf--title">Why the Hell Would You Use Node.js</h1>
                                 <p name="2a29" id="2a29" class="graf graf--p graf-after--h3">This article comes from <a href="https://twitter.com/tomislavcapan" data-href="https://twitter.com/tomislavcapan" class="markup--anchor markup--p-anchor" rel="noopener nofollow" target="_blank">Tomislav Capan</a>, technical consultant and Node.js enthusiast. Tomislav originally published this in August 2013 in the <a href="https://www.toptal.com/developers" data-href="https://www.toptal.com/developers" class="markup--anchor markup--p-anchor" rel="noopener nofollow" target="_blank">Toptal</a> blog — you can find the original post <a href="https://www.toptal.com/nodejs/why-the-hell-would-i-use-node-js" data-href="https://www.toptal.com/nodejs/why-the-hell-would-i-use-node-js" class="markup--anchor markup--p-anchor" rel="noopener nofollow" target="_blank">here</a>; the blog has been slightly updated. The following subject matter is based on the opinion and experiences of this author.</p>
                                 <h3 name="b730" id="b730" class="graf graf--h3 graf-after--p">Introduction</h3>
                                 <p name="0b15" id="0b15" class="graf graf--p graf-after--h3">JavaScript’s rising popularity has brought with it a lot of changes, and the face of web development today is dramatically different. The things that we can do on the web nowadays with JavaScript running on the server, as well as in the browser, were hard to imagine just several years ago, or were encapsulated within sandboxed environments like Flash or Java Applets.</p>
                                 <p name="2310" id="2310" class="graf graf--p graf-after--p">Before digging into Node.js, you might want to read up on the benefits of using <a href="http://www.toptal.com/javascript/guide-to-full-stack-javascript-initjs" data-href="http://www.toptal.com/javascript/guide-to-full-stack-javascript-initjs" class="markup--anchor markup--p-anchor" rel="nofollow noopener" target="_blank">JavaScript across the stack</a>, which unifies the language and data format (JSON), allowing you to optimally reuse developer resources. As this is more a benefit of JavaScript than Node.js specifically, we won’t discuss it much here. But it’s a key advantage to incorporating Node.js in your stack.</p>
                                 <p name="01f8" id="01f8" class="graf graf--p graf-after--p">Node.js is a JavaScript runtime environment built on Chrome’s V8 JavaScript engine. It’s worth noting that Ryan Dahl, the creator of Node.js, was aiming to create <strong class="markup--strong markup--p-strong">real-time websites with push capability</strong>, “inspired by applications like Gmail”. In Node.js, he gave developers a tool for working in the non-blocking, event-driven I/O paradigm.</p>
                                 <p name="b3f2" id="b3f2" class="graf graf--p graf-after--p">In one sentence: Node.js shines in real-time web applications employing push technology over websockets. What is so revolutionary about that? Well, after over 20 years of stateless-web based on the stateless request-response paradigm, we finally have web applications with real-time, two-way connections, where both the client and server can initiate communication, allowing them to exchange data freely.</p>
                                 <p name="9da8" id="9da8" class="graf graf--p graf-after--p">This is in stark contrast to the typical web response paradigm, where the client always initiates communication. Additionally, it’s all based on the open web stack (HTML, CSS and JS) running over the standard port 80.</p>
                                 <p name="df65" id="df65" class="graf graf--p graf-after--p">One might argue that we’ve had this for years in the form of Flash and Java Applets — but in reality, those were just sandboxed environments using the web as a transport protocol to be delivered to the client. Plus, they were run in isolation and often operated over non-standard ports, which may have required extra permissions and such.</p>
                                 <p name="2bbe" id="2bbe" class="graf graf--p graf-after--p">With all of its advantages, Node.js now plays a critical role in the technology stack of many high-profile companies who depend on its unique benefits. The Node.js Foundation has consolidated all the best thinking around why enterprises should consider Node.js in a short presentation that can be found on the <a href="https://nodejs.org/en/foundation/case-studies/" data-href="https://nodejs.org/en/foundation/case-studies/" class="markup--anchor markup--p-anchor" rel="nofollow noopener" target="_blank">Node.js Foundation’s Case Studies page</a>.</p>
                                 <p name="321e" id="321e" class="graf graf--p graf-after--p">In this post, I’ll discuss not only how these advantages are accomplished, but also <em class="markup--em markup--p-em">why</em> you might want to use Node.js — and <em class="markup--em markup--p-em">why not</em> — using some of the classic web application models as examples.</p>
                                 <h3 name="7a47" id="7a47" class="graf graf--h3 graf-after--p">How Does It Work?</h3>
                                 <p name="d12e" id="d12e" class="graf graf--p graf-after--h3">The main idea of Node.js: use non-blocking, event-driven I/O to remain lightweight and efficient in the face of data-intensive real-time applications that run across distributed devices.</p>
                                 <p name="ea52" id="ea52" class="graf graf--p graf-after--p">That’s a mouthful.</p>
                                 <p name="8182" id="8182" class="graf graf--p graf-after--p">What it <em class="markup--em markup--p-em">really</em> means is that Node.js is <em class="markup--em markup--p-em">not</em> a silver-bullet new platform that will dominate the web development world. <strong class="markup--strong markup--p-strong">Instead, it’s a platform that fills a particular need.</strong> And understanding this is absolutely essential. You definitely don’t want to use Node.js for CPU-intensive operations; in fact, using it for heavy computation will annul nearly all of its advantages. Where Node.js really shines is in building fast, scalable network applications, as it’s capable of handling a huge number of simultaneous connections with high throughput, which equates to high scalability.</p>
                                 <p name="ebfc" id="ebfc" class="graf graf--p graf-after--p">How it works under-the-hood is pretty interesting. Compared to traditional web-serving techniques where each connection (request) spawns a new thread, taking up system RAM and eventually maxing-out at the amount of RAM available, Node.js operates on a single-thread, using non-blocking I/O calls, allowing it to support tens of thousands of concurrent connections (held in the <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/EventLoop" data-href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/EventLoop" class="markup--anchor markup--p-anchor" rel="noopener nofollow" target="_blank">event loop</a>).</p>
                                 <figure name="dfff" id="dfff" class="graf graf--figure graf-after--p">
                                    <div class="aspectRatioPlaceholder is-locked" style="max-width: 624px; max-height: 800px;">
                                       <div class="aspectRatioPlaceholder-fill" style="padding-bottom: 128.2%;"></div>
                                       <div class="progressiveMedia js-progressiveMedia graf-image" data-image-id="1*4LsfQ0ZbZkapHDR8eTYp4g.png" data-width="624" data-height="800">
                                          <img src="https://cdn-images-1.medium.com/freeze/max/33/1*4LsfQ0ZbZkapHDR8eTYp4g.png?q=20" crossorigin="anonymous" class="progressiveMedia-thumbnail js-progressiveMedia-thumbnail">
                                          <canvas class="progressiveMedia-canvas js-progressiveMedia-canvas"></canvas>
                                          <img class="progressiveMedia-image js-progressiveMedia-image" data-src="https://cdn-images-1.medium.com/max/880/1*4LsfQ0ZbZkapHDR8eTYp4g.png">
                                          <noscript class="js-progressiveMedia-inner"><img class="progressiveMedia-noscript js-progressiveMedia-inner" src="https://cdn-images-1.medium.com/max/880/1*4LsfQ0ZbZkapHDR8eTYp4g.png"></noscript>
                                       </div>
                                    </div>
                                    <figcaption class="imageCaption">*Image taken from original blog post.</figcaption>
                                 </figure>
                                 <p name="091e" id="091e" class="graf graf--p graf-after--figure">A quick calculation: assuming that each thread potentially has an accompanying 2 MB of memory with it, running on a system with 8 GB of RAM puts us at a theoretical maximum of 4000 concurrent connections <em class="markup--em markup--p-em">(calculations taken from Michael Abernethy’s article “Just what is Node.js?”, published on IBM developerWorks in 2011; unfortunately, the article is not available anymore),</em> plus the cost of <a href="http://www.slideshare.net/marcusf/nonblocking-io-event-loops-and-nodejs" data-href="http://www.slideshare.net/marcusf/nonblocking-io-event-loops-and-nodejs" class="markup--anchor markup--p-anchor" rel="nofollow noopener" target="_blank">context-switching between threads</a>. That’s the scenario you typically deal with in traditional web-serving techniques. By avoiding all that, Node.js achieves scalability levels of over <a href="http://blog.caustik.com/2012/08/19/node-js-w1m-concurrent-connections/" data-href="http://blog.caustik.com/2012/08/19/node-js-w1m-concurrent-connections/" class="markup--anchor markup--p-anchor" rel="nofollow noopener" target="_blank">1M concurrent connections</a>, and over <a href="https://blog.jayway.com/2015/04/13/600k-concurrent-websocket-connections-on-aws-using-node-js/" data-href="https://blog.jayway.com/2015/04/13/600k-concurrent-websocket-connections-on-aws-using-node-js/" class="markup--anchor markup--p-anchor" rel="nofollow noopener" target="_blank">600k concurrent websockets connections</a>.</p>
                                 <p name="308a" id="308a" class="graf graf--p graf-after--p">There is, of course, the question of sharing a single thread between all clients requests, and it is a potential pitfall of writing Node.js applications. Firstly, heavy computation could choke up Node’s single thread and cause problems for <em class="markup--em markup--p-em">all</em> clients (more on this later) as incoming requests would be blocked until said computation was completed. Secondly, developers need to be <em class="markup--em markup--p-em">really</em> careful not to allow an exception bubbling up to the core (topmost) Node.js event loop, which will cause the Node.js instance to terminate (effectively crashing the program).</p>
                                 <p name="50f8" id="50f8" class="graf graf--p graf-after--p">The technique used to avoid exceptions bubbling up to the surface is passing errors back to the caller as callback parameters (instead of throwing them, like in other environments). Even if some unhandled exception manages to bubble up, tools have been developed to monitor the Node.js process and perform the necessary <a href="https://shapeshed.com/uncaught-exceptions-in-node/" data-href="https://shapeshed.com/uncaught-exceptions-in-node/" class="markup--anchor markup--p-anchor" rel="nofollow noopener" target="_blank">recovery of a crashed instance</a> (although you probably won’t be able to recover the current state of the user session), the most common being the <a href="http://blog.nodejitsu.com/keep-a-nodejs-server-up-with-forever" data-href="http://blog.nodejitsu.com/keep-a-nodejs-server-up-with-forever" class="markup--anchor markup--p-anchor" rel="nofollow noopener" target="_blank">Forever module</a>, or using a different approach with external system tools <a href="http://www.thegeekstuff.com/2016/09/deploy-nodejs/" data-href="http://www.thegeekstuff.com/2016/09/deploy-nodejs/" class="markup--anchor markup--p-anchor" rel="nofollow noopener" target="_blank"><em class="markup--em markup--p-em">upstart</em> and <em class="markup--em markup--p-em">monit</em></a>, or even <a href="https://blog.jalada.co.uk/simple-upstart-script-to-keep-a-node-process-alive/" data-href="https://blog.jalada.co.uk/simple-upstart-script-to-keep-a-node-process-alive/" class="markup--anchor markup--p-anchor" rel="nofollow noopener" target="_blank">just upstart</a>.</p>
                                 <h4 name="46bf" id="46bf" class="graf graf--h4 graf-after--p">npm: The Node Package Manager</h4>
                                 <p name="43c6" id="43c6" class="graf graf--p graf-after--h4">When discussing Node.js, one thing that definitely should not be omitted is built-in support for package management using the npm tool that comes by default with every Node.js installation. The idea of npm modules is quite similar to that of <em class="markup--em markup--p-em">Ruby Gems</em>: a set of publicly available, reusable components, available through easy installation via an online repository, with version and dependency management.</p>
                                 <p name="5a21" id="5a21" class="graf graf--p graf-after--p">A full list of packaged modules can be found on the <a href="https://npmjs.com/" data-href="https://npmjs.com/" class="markup--anchor markup--p-anchor" rel="nofollow noopener" target="_blank">npm website</a>, or accessed using the npm CLI tool that automatically gets installed with Node.js. The module ecosystem is open to all, and anyone can publish their own module that will be listed in the npm repository. A brief introduction to npm can be found in a <a href="https://nodesource.com/blog/an-absolute-beginners-guide-to-using-npm" data-href="https://nodesource.com/blog/an-absolute-beginners-guide-to-using-npm" class="markup--anchor markup--p-anchor" rel="nofollow noopener" target="_blank">Beginner’s Guide</a>, and details on publishing modules in the <a href="https://blog.risingstack.com/nodejs-at-scale-npm-publish-tutorial/" data-href="https://blog.risingstack.com/nodejs-at-scale-npm-publish-tutorial/" class="markup--anchor markup--p-anchor" rel="nofollow noopener" target="_blank">npm Publishing Tutorial</a>.</p>
                                 <p name="7cf3" id="7cf3" class="graf graf--p graf-after--p">Some of the most useful npm modules today are:</p>
                                 <ul class="postList">
                                    <li name="7d36" id="7d36" class="graf graf--li graf-after--p"><strong class="markup--strong markup--li-strong">express</strong> — Express.js, a Sinatra-inspired web development framework for Node.js, and the de-facto standard for the majority of Node.js applications out there today.</li>
                                    <li name="f755" id="f755" class="graf graf--li graf-after--li"><strong class="markup--strong markup--li-strong">hapi</strong> — a very modular and simple to use configuration-centric framework for building web and services applications</li>
                                    <li name="eb50" id="eb50" class="graf graf--li graf-after--li"><strong class="markup--strong markup--li-strong">connect</strong> — Connect is an extensible HTTP server framework for Node.js, providing a collection of high performance “plugins” known as middleware; serves as a base foundation for Express.</li>
                                    <li name="3088" id="3088" class="graf graf--li graf-after--li"><strong class="markup--strong markup--li-strong">socket.io</strong> and <strong class="markup--strong markup--li-strong">sockjs</strong> — Server-side component of the two most common websockets components out there today.</li>
                                    <li name="3b3c" id="3b3c" class="graf graf--li graf-after--li"><strong class="markup--strong markup--li-strong">pug </strong>(formerly <strong class="markup--strong markup--li-strong">Jade</strong>) — One of the popular templating engines, inspired by HAML, a default in Express.js.</li>
                                    <li name="602d" id="602d" class="graf graf--li graf-after--li"><strong class="markup--strong markup--li-strong">mongodb</strong> and <strong class="markup--strong markup--li-strong">mongojs</strong> — MongoDB wrappers to provide the API for MongoDB object databases in Node.js.</li>
                                    <li name="87bb" id="87bb" class="graf graf--li graf-after--li"><strong class="markup--strong markup--li-strong">redis</strong> — Redis client library.</li>
                                    <li name="f4eb" id="f4eb" class="graf graf--li graf-after--li"><strong class="markup--strong markup--li-strong">lodash</strong> (<strong class="markup--strong markup--li-strong">underscore</strong>, <strong class="markup--strong markup--li-strong">lazy.js</strong>) — The JavaScript utility belt. Underscore initiated the game, but got overthrown by one of its two counterparts, mainly due to <a href="http://philosopherdeveloper.com/posts/introducing-lazy-js.html" data-href="http://philosopherdeveloper.com/posts/introducing-lazy-js.html" class="markup--anchor markup--li-anchor" rel="nofollow noopener" target="_blank">better performance</a> and modular implementation.</li>
                                    <li name="49f8" id="49f8" class="graf graf--li graf-after--li"><strong class="markup--strong markup--li-strong">forever</strong> — Probably the most common utility for ensuring that a given node script runs continuously. Keeps your Node.js process up in production in the face of any unexpected failures.</li>
                                    <li name="dafa" id="dafa" class="graf graf--li graf-after--li"><strong class="markup--strong markup--li-strong">bluebird</strong> — A full featured Promises/A+ implementation with exceptionally good performance</li>
                                    <li name="24b7" id="24b7" class="graf graf--li graf-after--li"><strong class="markup--strong markup--li-strong">moment</strong> — A lightweight JavaScript date library for parsing, validating, manipulating, and formatting dates.</li>
                                 </ul>
                                 <p name="20ec" id="20ec" class="graf graf--p graf-after--li">The list goes on. There are tons of really useful packages out there, available to all (no offense to those that I’ve omitted here).</p>
                                 <h3 name="d77c" id="d77c" class="graf graf--h3 graf-after--p">Where Node.js Should Be Used</h3>
                                 <h4 name="cd61" id="cd61" class="graf graf--h4 graf-after--h3">CHAT</h4>
                                 <p name="e823" id="e823" class="graf graf--p graf-after--h4">Chat is the most typical real-time, multi-user application. From IRC (back in the day), through many proprietary and open protocols running on non-standard ports, to the ability to implement everything today in Node.js with websockets running over the standard port 80.</p>
                                 <p name="a822" id="a822" class="graf graf--p graf-after--p">The chat application is really the sweet-spot example for Node.js: it’s a lightweight, high traffic, data-intensive (but low processing/computation) application that runs across distributed devices. It’s also a great use-case for learning too, as it’s simple, yet it covers most of the paradigms you’ll ever use in a typical Node.js application.</p>
                                 <p name="95e9" id="95e9" class="graf graf--p graf-after--p">Let’s try to depict how it works.</p>
                                 <p name="5ca3" id="5ca3" class="graf graf--p graf-after--p">In the simplest scenario, we have a single chatroom on our website where people come and can exchange messages in one-to-many (actually all) fashion. For instance, say we have three people on the website all connected to our message board.</p>
                                 <p name="6f3f" id="6f3f" class="graf graf--p graf-after--p">On the server-side, we have a simple <a href="http://expressjs.com/" data-href="http://expressjs.com/" class="markup--anchor markup--p-anchor" rel="nofollow noopener" target="_blank">Express.js</a> application which implements two things: 1) a GET ‘/’ request handler which serves the webpage containing both a message board and a ‘Send’ button to initialize new message input, and 2) a websockets server that listens for new messages emitted by websocket clients.</p>
                                 <p name="64b1" id="64b1" class="graf graf--p graf-after--p">On the client-side, we have an HTML page with a couple of handlers set up, one for the ‘Send’ button click event, which picks up the input message and sends it down the websocket, and another that listens for new incoming messages on the websockets client (i.e., messages sent by other users, which the server now wants the client to display).</p>
                                 <p name="d1b6" id="d1b6" class="graf graf--p graf-after--p">When one of the clients posts a message, here’s what happens:</p>
                                 <ul class="postList">
                                    <li name="548f" id="548f" class="graf graf--li graf-after--p">Browser catches the ‘Send’ button click through a JavaScript handler, picks up the value from the input field (i.e., the message text), and emits a websocket message using the websocket client connected to our server (initialized on web page initialization).</li>
                                    <li name="2329" id="2329" class="graf graf--li graf-after--li">Server-side component of the websocket connection receives the message and forwards it to all other connected clients using the broadcast method.</li>
                                    <li name="e683" id="e683" class="graf graf--li graf-after--li">All clients receive the new message as a push message via a websockets client-side component running within the web page. They then pick up the message content and update the web page in-place by appending the new message to the board.</li>
                                 </ul>
                                 <figure name="e906" id="e906" class="graf graf--figure graf-after--li">
                                    <div class="aspectRatioPlaceholder is-locked" style="max-width: 624px; max-height: 600px;">
                                       <div class="aspectRatioPlaceholder-fill" style="padding-bottom: 96.2%;"></div>
                                       <div class="progressiveMedia js-progressiveMedia graf-image" data-image-id="1*PlEffzSol0hpKi0mgwEZTg.png" data-width="624" data-height="600">
                                          <img src="https://cdn-images-1.medium.com/freeze/max/33/1*PlEffzSol0hpKi0mgwEZTg.png?q=20" crossorigin="anonymous" class="progressiveMedia-thumbnail js-progressiveMedia-thumbnail">
                                          <canvas class="progressiveMedia-canvas js-progressiveMedia-canvas"></canvas>
                                          <img class="progressiveMedia-image js-progressiveMedia-image" data-src="https://cdn-images-1.medium.com/max/880/1*PlEffzSol0hpKi0mgwEZTg.png">
                                          <noscript class="js-progressiveMedia-inner"><img class="progressiveMedia-noscript js-progressiveMedia-inner" src="https://cdn-images-1.medium.com/max/880/1*PlEffzSol0hpKi0mgwEZTg.png"></noscript>
                                       </div>
                                    </div>
                                    <figcaption class="imageCaption">Image taken from original blog.</figcaption>
                                 </figure>
                                 <p name="a867" id="a867" class="graf graf--p graf-after--figure">This is the simplest example. For a more robust solution, you might use a simple cache based on the Redis store. Or in an even more advanced solution, a message queue to handle the routing of messages to clients and a more robust delivery mechanism that may cover for temporary connection losses or storing messages for registered clients while they’re offline. But regardless of the improvements that you make, Node.js will still be operating under the same basic principles: reacting to events, handling many concurrent connections, and maintaining fluidity in the user experience.</p>
                                 <h4 name="0bdd" id="0bdd" class="graf graf--h4 graf-after--p">API ON TOP OF AN OBJECT DB</h4>
                                 <p name="6bc0" id="6bc0" class="graf graf--p graf-after--h4">Although Node.js really shines with real-time applications, it’s quite a natural fit for exposing the data from object DBs (e.g. MongoDB). JSON stored data allow Node.js to function without the impedance mismatch and data conversion.</p>
                                 <p name="4594" id="4594" class="graf graf--p graf-after--p">For instance, if you’re using Rails, you would convert from JSON to binary models, then expose them back as JSON over the HTTP when the data is consumed by React.js, Angular.js, etc., or even plain jQuery AJAX calls. With Node.js, you can simply expose your JSON objects with a REST API for the client to consume. Additionally, you don’t need to worry about converting between JSON and whatever else when reading or writing from your database (if you’re using MongoDB). In sum, you can avoid the need for multiple conversions by using a uniform data serialization format across the client, server, and database.</p>
                                 <h4 name="107c" id="107c" class="graf graf--h4 graf-after--p">QUEUED INPUTS</h4>
                                 <p name="4e4b" id="4e4b" class="graf graf--p graf-after--h4">If you’re receiving a high amount of concurrent data, your database can become a bottleneck. As depicted above, Node.js can easily handle the concurrent connections themselves. But because database access is a blocking operation (in this case), we run into trouble. The solution is to acknowledge the client’s behavior before the data is truly written to the database.</p>
                                 <p name="9393" id="9393" class="graf graf--p graf-after--p">With that approach, the system maintains its responsiveness under a heavy load, which is particularly useful when the client doesn’t need firm confirmation of a the successful data write. Typical examples include: the logging or writing of user-tracking data, processed in batches and not used until a later time; as well as operations that don’t need to be reflected instantly (like updating a ‘Likes’ count on Facebook) where <a href="http://www.allthingsdistributed.com/2007/12/eventually_consistent.html" data-href="http://www.allthingsdistributed.com/2007/12/eventually_consistent.html" class="markup--anchor markup--p-anchor" rel="nofollow noopener" target="_blank">eventual consistency</a> (so often used in NoSQL world) is acceptable.</p>
                                 <p name="7566" id="7566" class="graf graf--p graf-after--p">Data gets queued through some kind of caching or message queuing (MQ) infrastructure (e.g., RabbitMQ, ZeroMQ) and digested by a separate database batch-write process, or computation intensive processing backend services, written in a better performing platform for such tasks. Similar behavior can be implemented with other languages/frameworks, but not on the same hardware, with the same high, maintained throughput.</p>
                                 <figure name="6e67" id="6e67" class="graf graf--figure graf-after--p">
                                    <div class="aspectRatioPlaceholder is-locked" style="max-width: 624px; max-height: 600px;">
                                       <div class="aspectRatioPlaceholder-fill" style="padding-bottom: 96.2%;"></div>
                                       <div class="progressiveMedia js-progressiveMedia graf-image" data-image-id="1*ZNiW5-rDzOSDrH3YImtQ2g.png" data-width="624" data-height="600">
                                          <img src="https://cdn-images-1.medium.com/freeze/max/33/1*ZNiW5-rDzOSDrH3YImtQ2g.png?q=20" crossorigin="anonymous" class="progressiveMedia-thumbnail js-progressiveMedia-thumbnail">
                                          <canvas class="progressiveMedia-canvas js-progressiveMedia-canvas"></canvas>
                                          <img class="progressiveMedia-image js-progressiveMedia-image" data-src="https://cdn-images-1.medium.com/max/880/1*ZNiW5-rDzOSDrH3YImtQ2g.png">
                                          <noscript class="js-progressiveMedia-inner"><img class="progressiveMedia-noscript js-progressiveMedia-inner" src="https://cdn-images-1.medium.com/max/880/1*ZNiW5-rDzOSDrH3YImtQ2g.png"></noscript>
                                       </div>
                                    </div>
                                    <figcaption class="imageCaption">Image taken from original article.</figcaption>
                                 </figure>
                                 <p name="1e12" id="1e12" class="graf graf--p graf-after--figure">In short: with Node, you can push the database writes off to the side and deal with them later, proceeding as if they succeeded.</p>
                                 <h4 name="30e4" id="30e4" class="graf graf--h4 graf-after--p">DATA STREAMING</h4>
                                 <p name="6c01" id="6c01" class="graf graf--p graf-after--h4">In more traditional web platforms, HTTP requests and responses are treated like isolated event; in fact, they’re actually streams. This observation can be utilized in Node.js to build some cool features. For example, it’s possible to process files <em class="markup--em markup--p-em">while they’re still being uploaded</em>, as the data comes in through a stream and we can process it in an online fashion. This could be done for <a href="https://transloadit.com/blog/2010/12/realtime-encoding-over-150x-faster" data-href="https://transloadit.com/blog/2010/12/realtime-encoding-over-150x-faster" class="markup--anchor markup--p-anchor" rel="nofollow noopener" target="_blank">real-time audio or video encoding</a>, and proxying between different data sources <em class="markup--em markup--p-em">(see next section)</em>.</p>
                                 <h4 name="45b7" id="45b7" class="graf graf--h4 graf-after--p">PROXY</h4>
                                 <p name="e233" id="e233" class="graf graf--p graf-after--h4">Node.js is easily employed as a server-side proxy where it can handle a large amount of simultaneous connections in a non-blocking manner. It’s especially useful for proxying different services with different response times, or collecting data from multiple source points.</p>
                                 <p name="d4f4" id="d4f4" class="graf graf--p graf-after--p">An example: consider a server-side application communicating with third-party resources, pulling in data from different sources, or storing assets like images and videos to third-party cloud services.</p>
                                 <p name="4d70" id="4d70" class="graf graf--p graf-after--p">Although dedicated proxy servers do exist, using Node instead might be helpful if your proxying infrastructure is non-existent or if you need a solution for local development. By this, I mean that you could build a client-side app with a Node.js development server for assets and proxying/stubbing API requests, while in production you’d handle such interactions with a dedicated proxy service (nginx, HAProxy, etc.).</p>
                                 <h4 name="02f5" id="02f5" class="graf graf--h4 graf-after--p">BROKERAGE — STOCK TRADER’S DASHBOARD</h4>
                                 <p name="fe68" id="fe68" class="graf graf--p graf-after--h4">Let’s get back to the application level. Another example where desktop software dominates, but could be easily replaced with a real-time web solution is brokers’ trading software, used to track stocks prices, perform calculations/technical analysis, and create graphs/charts.</p>
                                 <p name="0fed" id="0fed" class="graf graf--p graf-after--p">Switching to a real-time web-based solution would allow brokers to easily switch workstations or working places. Soon, we might start seeing them on the beach in Florida.. or Ibiza.. or Bali.</p>
                                 <h4 name="d444" id="d444" class="graf graf--h4 graf-after--p">APPLICATION MONITORING DASHBOARD</h4>
                                 <p name="774c" id="774c" class="graf graf--p graf-after--h4">Another common use-case in which Node-with-web-sockets fits perfectly: tracking website visitors and visualizing their interactions in real-time. You could be gathering real-time stats from your user, or even moving it to the next level by introducing targeted interactions with your visitors by opening a communication channel when they reach a specific point in your funnel — an example of this can be found with <a href="http://canddi.com/" data-href="http://canddi.com/" class="markup--anchor markup--p-anchor" rel="nofollow noopener" target="_blank">CANDDi</a>.</p>
                                 <p name="d157" id="d157" class="graf graf--p graf-after--p">Imagine how you could improve your business if you knew what your visitors were doing in real-time — if you could visualize their interactions. With the real-time, two-way sockets of Node.js, now you can.</p>
                                 <h4 name="30c5" id="30c5" class="graf graf--h4 graf-after--p">SYSTEM MONITORING DASHBOARD</h4>
                                 <p name="3f38" id="3f38" class="graf graf--p graf-after--h4">Now, let’s visit the infrastructure side of things. Imagine, for example, an SaaS provider that wants to offer its users a service-monitoring page (for example, the <a href="https://status.github.com" data-href="https://status.github.com" class="markup--anchor markup--p-anchor" rel="nofollow noopener" target="_blank">GitHub Status page</a>). With the Node.js event loop, we can create a powerful web-based dashboard that checks the services’ statuses in an asynchronous manner and pushes data to clients using websockets.</p>
                                 <p name="05d7" id="05d7" class="graf graf--p graf-after--p">Both internal (intra-company) and public services’ statuses can be reported live and in real-time using this technology. Push that idea a little further and try to imagine a <a href="http://en.wikipedia.org/wiki/Network_operations_center" data-href="http://en.wikipedia.org/wiki/Network_operations_center" class="markup--anchor markup--p-anchor" rel="nofollow noopener" target="_blank">Network Operations Center (NOC)</a> monitoring applications in a telecommunications operator, cloud/network/hosting provider, or some financial institution, all run on the open web stack backed by Node.js and websockets instead of Java and/or Java Applets.</p>
                                 <p name="1026" id="1026" class="graf graf--p graf-after--p">Note: <em class="markup--em markup--p-em">Don’t try to build hard real-time systems in Node.js (i.e., systems requiring consistent response times). Erlang is </em><a href="http://nodeguide.com/convincing_the_boss.html" data-href="http://nodeguide.com/convincing_the_boss.html" class="markup--anchor markup--p-anchor" rel="nofollow noopener" target="_blank"><em class="markup--em markup--p-em">probably a better choice</em></a><em class="markup--em markup--p-em"> for that class of application.</em></p>
                                 <h3 name="54eb" id="54eb" class="graf graf--h3 graf-after--p">Where Node.js Can Be Used</h3>
                                 <h4 name="33c5" id="33c5" class="graf graf--h4 graf-after--h3">SERVER-SIDE WEB APPLICATIONS</h4>
                                 <p name="93a3" id="93a3" class="graf graf--p graf-after--h4">Node.js with Express.js can also be used to create classic web applications on the server-side. However, while possible, this request-response paradigm in which Node.js would be carrying around rendered HTML is not the most typical use-case. There are arguments to be made for and against this approach. Here are some facts to consider:</p>
                                 <p name="2048" id="2048" class="graf graf--p graf-after--p">Pros:</p>
                                 <ul class="postList">
                                    <li name="0f81" id="0f81" class="graf graf--li graf-after--p">If your application doesn’t have any CPU intensive computation, you can build it in Javascript top-to-bottom, even down to the database level if you use JSON storage Object DB like MongoDB. This eases development (including hiring) significantly.</li>
                                    <li name="3945" id="3945" class="graf graf--li graf-after--li">Crawlers receive a fully-rendered HTML response, which is far more SEO-friendly than, say, a Single Page Application or a websockets app run on top of Node.js.</li>
                                 </ul>
                                 <p name="87f5" id="87f5" class="graf graf--p graf-after--li">Cons:</p>
                                 <ul class="postList">
                                    <li name="2cb6" id="2cb6" class="graf graf--li graf-after--p">Any CPU intensive computation will block Node.js responsiveness, so a threaded platform is a better approach. Alternatively, you could try scaling out the computation(*).</li>
                                    <li name="ac0a" id="ac0a" class="graf graf--li graf-after--li">Using Node.js with a relational database is still quite a pain (see below for more detail). Do yourself a favour and pick up any other environment like Rails, Django, or ASP.Net MVC if you’re trying to perform relational operations.</li>
                                 </ul>
                                 <p name="24b4" id="24b4" class="graf graf--p graf-after--li"><em class="markup--em markup--p-em">(*) An alternative to CPU intensive computations is to create a highly scalable MQ-backed environment with back-end processing to keep Node as a front-facing ‘clerk’ to handle client requests asynchronously.</em></p>
                                 <h3 name="9485" id="9485" class="graf graf--h3 graf-after--p">Where Node.js Shouldn’t Be Used</h3>
                                 <h4 name="9114" id="9114" class="graf graf--h4 graf-after--h3">SERVER-SIDE WEB APPLICATION WITH A RELATIONAL DATABASE BEHIND</h4>
                                 <p name="5b0c" id="5b0c" class="graf graf--p graf-after--h4">Comparing Node.js with Express.js against Ruby on Rails, for example, there is a clean decision in favour of the latter when it comes to relational data access.</p>
                                 <p name="3147" id="3147" class="graf graf--p graf-after--p">Relational DB tools for Node.js are still rather underdeveloped, compared to the competition. On the other hand, Rails automagically provides data access setup right out of the box together with DB schema migrations support tools and other Gems (pun intended). Rails and its peer frameworks have mature and proven <em class="markup--em markup--p-em">Active Record</em> or <em class="markup--em markup--p-em">Data Mapper</em> data access layer implementations, which you’ll sorely miss if you try to replicate them in pure JavaScript.(*)</p>
                                 <p name="9bf5" id="9bf5" class="graf graf--p graf-after--p">Still, if you’re really inclined to remain JS all-the-way, check out <a href="http://sequelizejs.com" data-href="http://sequelizejs.com" class="markup--anchor markup--p-anchor" rel="nofollow noopener" target="_blank">Sequelize</a> and <a href="https://github.com/dresende/node-orm2" data-href="https://github.com/dresende/node-orm2" class="markup--anchor markup--p-anchor" rel="nofollow noopener" target="_blank">Node ORM2</a>.</p>
                                 <p name="5dd2" id="5dd2" class="graf graf--p graf-after--p"><em class="markup--em markup--p-em">(*) It’s possible and not uncommon to use Node.js solely as a public-facing facade, while keeping your Rails back-end and its easy-access to a relational DB.</em></p>
                                 <h4 name="a524" id="a524" class="graf graf--h4 graf-after--p">HEAVY SERVER-SIDE COMPUTATION/PROCESSING</h4>
                                 <p name="44c1" id="44c1" class="graf graf--p graf-after--h4">When it comes to heavy computation, Node.js is not the best platform around. No, you definitely don’t want to build a <a href="http://zef.me/4561/node-js-and-the-case-of-the-blocked-event-loop" data-href="http://zef.me/4561/node-js-and-the-case-of-the-blocked-event-loop" class="markup--anchor markup--p-anchor" rel="nofollow noopener" target="_blank">Fibonacci computation server in Node.js</a>. In general, any CPU intensive operation annuls all the throughput benefits Node offers with its event-driven, non-blocking I/O model because any incoming requests will be blocked while the thread is occupied with your number-crunching.</p>
                                 <p name="ed9c" id="ed9c" class="graf graf--p graf-after--p">As stated previously, Node.js is single-threaded and uses only a single CPU core. When it comes to adding concurrency on a multi-core server, there is some work being done by the Node core team in the form of a <a href="http://nodejs.org/api/cluster.html" data-href="http://nodejs.org/api/cluster.html" class="markup--anchor markup--p-anchor" rel="nofollow noopener" target="_blank">cluster module</a>. You can also run several Node.js server instances pretty easily behind a <a href="http://blog.argteam.com/coding/hardening-node-js-for-production-part-2-using-nginx-to-avoid-node-js-load/" data-href="http://blog.argteam.com/coding/hardening-node-js-for-production-part-2-using-nginx-to-avoid-node-js-load/" class="markup--anchor markup--p-anchor" rel="nofollow noopener" target="_blank">reverse proxy via nginx</a>.</p>
                                 <p name="b0b9" id="b0b9" class="graf graf--p graf-after--p">With clustering, you should still offload all heavy computation to background processes written in a more appropriate environment for that, and having them communicate via a message queue server like RabbitMQ.</p>
                                 <p name="9539" id="9539" class="graf graf--p graf-after--p">Even though your background processing might be run on the same server initially, such an approach has the potential for very high scalability. Those background processing services could be easily distributed out to separate worker servers without the need to configure the loads of front-facing web servers.</p>
                                 <p name="88e8" id="88e8" class="graf graf--p graf-after--p">Of course, you’d use the same approach on other platforms too, but with Node.js you get that high reqs/sec throughput we’ve talked about, as each request is a small task handled very quickly and efficiently.</p>
                                 <h3 name="8e8e" id="8e8e" class="graf graf--h3 graf-after--p">Conclusion</h3>
                                 <p name="8e9d" id="8e9d" class="graf graf--p graf-after--h3">We’ve discussed Node.js from theory to practice, beginning with its goals and ambitions, and ending with its sweet spots and pitfalls. When people run into problems with Node, it almost always boils down to the fact that <strong class="markup--strong markup--p-strong">blocking operations are the root of all evil — </strong>99% of Node misuses come as a direct consequence.</p>
                                 <p name="9181" id="9181" class="graf graf--p graf-after--p"><em class="markup--em markup--p-em">Remember: Node.js was never created to solve the compute scaling problem. It was created to solve the I/O scaling problem, which it </em><a href="http://www.srirangan.net/2012-05-node-js-critics-which-part-of-event-driven-non-blocking-io-model-you-dont-understand" data-href="http://www.srirangan.net/2012-05-node-js-critics-which-part-of-event-driven-non-blocking-io-model-you-dont-understand" class="markup--anchor markup--p-anchor" rel="nofollow noopener" target="_blank"><em class="markup--em markup--p-em">does really well</em></a><em class="markup--em markup--p-em">.</em></p>
                                 <p name="7c17" id="7c17" class="graf graf--p graf-after--p graf--trailing">So, give it some thought: if your use case does not contain CPU intensive operations nor access any blocking resources, you can exploit the benefits of Node.js and enjoy fast and scalable network applications. Welcome to the real-time web.</p>
                              </div>
                           </div>
                        </section>
                     </div>
