<div class="postArticle-content js-postField js-notesSource js-trackedPost" data-post-id="3f28b94cfbec" data-source="post_page" data-collection-id="12d1b859d4e4" data-tracking-context="postPage">
                            <section name="4b5d" class="section section--body section--first section--last">
                                <div class="section-divider">
                                    <hr class="section-divider">
                                </div>
                                <div class="section-content">
                                    <div class="section-inner sectionLayout--insetColumn">
                                        <h1 name="6564" id="6564" class="graf graf--h3 graf--leading graf--title"><strong class="markup--strong markup--h3-strong">How JavaScript works: memory management + how to handle 4 common memory leaks</strong></h1>
                                        <p name="5b38" id="5b38" class="graf graf--p graf-after--h3">A few weeks ago we started a series aimed at digging deeper into JavaScript and how it actually works: we thought that by knowing the building blocks of JavaScript and how they come to play together you’ll be able to write better code and apps.</p>
                                        <p name="0661" id="0661" class="graf graf--p graf-after--p">The first post of the series focused on providing <a href="https://blog.sessionstack.com/how-does-javascript-actually-work-part-1-b0bacc073cf" data-href="https://blog.sessionstack.com/how-does-javascript-actually-work-part-1-b0bacc073cf" class="markup--anchor markup--p-anchor" target="_blank">an overview of the engine, the runtime, and the call stack</a>. Thе <a href="https://blog.sessionstack.com/how-javascript-works-inside-the-v8-engine-5-tips-on-how-to-write-optimized-code-ac089e62b12e" data-href="https://blog.sessionstack.com/how-javascript-works-inside-the-v8-engine-5-tips-on-how-to-write-optimized-code-ac089e62b12e" class="markup--anchor markup--p-anchor" target="_blank">second post examined closely the internal parts of Google’s V8 JavaScript engine</a> and also provided a few tips on how to write better JavaScript code.</p>
                                        <p name="badf" id="badf" class="graf graf--p graf-after--p">In this third post, we’ll discuss another critical topic that’s getting ever more neglected by developers due to the increasing maturity and complexity of programming languages that are being used on a daily basis — memory management. We’ll also provide a few tips on how to handle memory leaks in JavaScript that we at <a href="https://www.sessionstack.com/" data-href="https://www.sessionstack.com/" class="markup--anchor markup--p-anchor" rel="noopener" target="_blank">SessionStack</a> follow as we need to make sure SessionStack causes no memory leaks or doesn’t increase the memory consumption of the web app in which we are integrated.</p>
                                        <h4 name="55d4" id="55d4" class="graf graf--h4 graf-after--p">Overview</h4>
                                        <p name="9ac8" id="9ac8" class="graf graf--p graf-after--h4">Languages, like C, have low-level memory management primitives such as <code class="markup--code markup--p-code">malloc()</code> and <code class="markup--code markup--p-code">free()</code>. These primitives are used by the developer to explicitly allocate and free memory from and to the operating system.</p>
                                        <p name="0282" id="0282" class="graf graf--p graf-after--p">At the same time, JavaScript allocates memory when things (objects, strings, etc.) are created and “automatically” frees it up when they are not used anymore, a process called <em class="markup--em markup--p-em">garbage collection</em>. This seemingly “automatical” nature of freeing up resources is a source of confusion and gives JavaScript (and other high-level-language) developers the false impression they can choose not to care about memory management.<strong class="markup--strong markup--p-strong"> This is a big mistake.</strong></p>
                                        <p name="36fc" id="36fc" class="graf graf--p graf-after--p">Even when working with high-level languages, developers should have an understanding of memory management (or at least the basics). Sometimes there are issues with the automatic memory management (such as bugs or implementation limitations in the garbage collectors, etc.) which developers have to understand in order to handle them properly (or to find a proper workaround, with a minimum trade off and code debt).</p>
                                        <h4 name="8334" id="8334" class="graf graf--h4 graf-after--p">Memory life cycle</h4>
                                        <p name="7eb0" id="7eb0" class="graf graf--p graf-after--h4">No matter what programming language you’re using, memory life cycle is pretty much always the same:</p>
                                        <figure name="eb8c" id="eb8c" class="graf graf--figure graf-after--p">
                                            <div class="aspectRatioPlaceholder is-locked" style="max-width: 700px; max-height: 525px;">
                                                <div class="aspectRatioPlaceholder-fill" style="padding-bottom: 75%;"></div>
                                                <div class="progressiveMedia js-progressiveMedia graf-image" data-image-id="1*slxXgq_TO38TgtoKpWa_jQ.png" data-width="1024" data-height="768" data-action="zoom" data-action-value="1*slxXgq_TO38TgtoKpWa_jQ.png"><img src="https://cdn-images-1.medium.com/freeze/max/30/1*slxXgq_TO38TgtoKpWa_jQ.png?q=20" crossorigin="anonymous" class="progressiveMedia-thumbnail js-progressiveMedia-thumbnail">
                                                    <canvas class="progressiveMedia-canvas js-progressiveMedia-canvas"></canvas><img class="progressiveMedia-image js-progressiveMedia-image" data-src="https://cdn-images-1.medium.com/max/800/1*slxXgq_TO38TgtoKpWa_jQ.png">
                                                    <noscript class="js-progressiveMedia-inner"><img class="progressiveMedia-noscript js-progressiveMedia-inner" src="https://cdn-images-1.medium.com/max/800/1*slxXgq_TO38TgtoKpWa_jQ.png"></noscript>
                                                </div>
                                            </div>
                                        </figure>
                                        <p name="5ef3" id="5ef3" class="graf graf--p graf-after--figure">Here is an overview of what happens at each step of the cycle:</p>
                                        <ul class="postList">
                                            <li name="a970" id="a970" class="graf graf--li graf-after--p"><strong class="markup--strong markup--li-strong">Allocate memory </strong>— memory is allocated by the operating system which allows your program to use it. In low-level languages (e.g. C) this is an explicit operation that you as a developer should handle. In high-level languages, however, this is taken care of for you.</li>
                                            <li name="1637" id="1637" class="graf graf--li graf-after--li"><strong class="markup--strong markup--li-strong">Use memory — </strong>this is the time when your program actually makes use of the previously allocated memory. <strong class="markup--strong markup--li-strong">Read</strong> and <strong class="markup--strong markup--li-strong">write</strong> operations are taking place as you’re using the allocated variables in your code.</li>
                                            <li name="2a8b" id="2a8b" class="graf graf--li graf-after--li"><strong class="markup--strong markup--li-strong">Release memory</strong> — now is the time to release the entire memory that you don’t need so that it can become free and available again. As with the <strong class="markup--strong markup--li-strong">Allocate memory </strong>operation, this one is explicit in low-level languages.</li>
                                        </ul>
                                        <p name="7188" id="7188" class="graf graf--p graf-after--li">For a quick overview of the concepts of the call stack and the memory heap, you can read our <a href="https://blog.sessionstack.com/how-does-javascript-actually-work-part-1-b0bacc073cf" data-href="https://blog.sessionstack.com/how-does-javascript-actually-work-part-1-b0bacc073cf" class="markup--anchor markup--p-anchor" target="_blank">first post on the topic</a>.</p>
                                        <h4 name="7cd9" id="7cd9" class="graf graf--h4 graf-after--p">What is memory?</h4>
                                        <p name="96cc" id="96cc" class="graf graf--p graf-after--h4">Before jumping straight to memory in JavaScript, we’ll briefly discuss what memory is in general and how it works in a nutshell.</p>
                                        <p name="f6e8" id="f6e8" class="graf graf--p graf-after--p">On a hardware level, computer memory consists of a large number of
                                            <br><a href="https://en.wikipedia.org/wiki/Flip-flop_%28electronics%29" data-href="https://en.wikipedia.org/wiki/Flip-flop_%28electronics%29" class="markup--anchor markup--p-anchor" rel="noopener" target="_blank">flip flops</a>. Each flip flop contains a few transistors and is capable of storing one bit. Individual flip flops are addressable by a <strong class="markup--strong markup--p-strong">unique identifier</strong>, so we can read and overwrite them. Thus, conceptually, we can think of our entire computer memory as a just one giant array of bits that we can read and write.</p>
                                        <p name="b9cd" id="b9cd" class="graf graf--p graf-after--p">Since as humans, we are not that good at doing all of our thinking and arithmetic in bits, we organize them into larger groups, which together can be used to represent numbers. 8 bits are called 1 byte. Beyond bytes, there are words (which are sometimes 16, sometimes 32 bits).</p>
                                        <p name="7115" id="7115" class="graf graf--p graf-after--p">A lot of things are stored in this memory:</p>
                                        <ol class="postList">
                                            <li name="5ac3" id="5ac3" class="graf graf--li graf-after--p">All variables and other data used by all programs.</li>
                                            <li name="02c2" id="02c2" class="graf graf--li graf-after--li">The programs’ code, including the operating system’s.</li>
                                        </ol>
                                        <p name="b8e9" id="b8e9" class="graf graf--p graf-after--li">The compiler and the operating system work together to take care of most of the memory management for you, but we recommend that you take a look at what’s going on under the hood.</p>
                                        <p name="c634" id="c634" class="graf graf--p graf-after--p">When you compile your code, the compiler can examine primitive data types and calculate ahead of time how much memory they will need. The required amount is then allocated to the program in the call<strong class="markup--strong markup--p-strong"> stack space</strong>. The space in which these variables are allocated is called the stack space because as functions get called, their memory gets added on top of the existing memory. As they terminate, they are removed in a LIFO (last-in, first-out) order. For example, consider the following declarations:</p><pre name="fb7d" id="fb7d" class="graf graf--pre graf-after--p">int n; // 4 bytes<br>int x[4]; // array of 4 elements, each 4 bytes<br>double m; // 8 bytes</pre>
                                        <p name="8ea4" id="8ea4" class="graf graf--p graf-after--pre">The compiler can immediately see that the code requires
                                            <br>4 + 4 × 4 + 8 = 28 bytes.</p>
                                        <blockquote name="9deb" id="9deb" class="graf graf--blockquote graf-after--p">That’s how it works with the current sizes for integers and doubles. About 20 years ago, integers were typically 2 bytes, and double 4 bytes. Your code should never have to depend on what is at this moment the size of the basic data types.</blockquote>
                                        <p name="8480" id="8480" class="graf graf--p graf-after--blockquote">The compiler will insert code that will interact with the operating system to request the necessary number of bytes on the stack for your variables to be stored.</p>
                                        <p name="17a7" id="17a7" class="graf graf--p graf-after--p">In the example above, the compiler knows the exact memory address of each variable. In fact, whenever we write to the variable <code class="markup--code markup--p-code">n</code>, this gets translated into something like “memory address 4127963” internally.</p>
                                        <p name="b47f" id="b47f" class="graf graf--p graf-after--p">Notice that if we attempted to access <code class="markup--code markup--p-code">x[4]</code> here, we would have accessed the data associated with m . That’s because we’re accessing an element in the array that doesn’t exist — it’s 4 bytes further than the last actual allocated element in the array which is <code class="markup--code markup--p-code">x[3]</code>, and may end up reading (or overwriting) some of <code class="markup--code markup--p-code">m</code>’s bits. This would almost certainly have very undesired consequences for the rest of the program.</p>
                                        <figure name="a66f" id="a66f" class="graf graf--figure graf-after--p">
                                            <div class="aspectRatioPlaceholder is-locked" style="max-width: 700px; max-height: 241px;">
                                                <div class="aspectRatioPlaceholder-fill" style="padding-bottom: 34.5%;"></div>
                                                <div class="progressiveMedia js-progressiveMedia graf-image" data-image-id="1*5aBou4onl1B8xlgwoGTDOg.png" data-width="1024" data-height="353" data-action="zoom" data-action-value="1*5aBou4onl1B8xlgwoGTDOg.png"><img src="https://cdn-images-1.medium.com/freeze/max/30/1*5aBou4onl1B8xlgwoGTDOg.png?q=20" crossorigin="anonymous" class="progressiveMedia-thumbnail js-progressiveMedia-thumbnail">
                                                    <canvas class="progressiveMedia-canvas js-progressiveMedia-canvas"></canvas><img class="progressiveMedia-image js-progressiveMedia-image" data-src="https://cdn-images-1.medium.com/max/800/1*5aBou4onl1B8xlgwoGTDOg.png">
                                                    <noscript class="js-progressiveMedia-inner"><img class="progressiveMedia-noscript js-progressiveMedia-inner" src="https://cdn-images-1.medium.com/max/800/1*5aBou4onl1B8xlgwoGTDOg.png"></noscript>
                                                </div>
                                            </div>
                                        </figure>
                                        <p name="1368" id="1368" class="graf graf--p graf-after--figure">When functions call other functions, each gets its own chunk of the stack when it is called. It keeps all its local variables there, but also a program counter that remembers where in its execution it was. When the function finishes, its memory block is once again made available for other purposes.</p>
                                        <h4 name="d01e" id="d01e" class="graf graf--h4 graf-after--p">Dynamic allocation</h4>
                                        <p name="5f15" id="5f15" class="graf graf--p graf-after--h4">Unfortunately, things aren’t quite as easy when we don’t know at compile time how much memory a variable will need. Suppose we want to do something like the following:</p><pre name="48af" id="48af" class="graf graf--pre graf-after--p">int n = readInput(); // reads input from the user</pre><pre name="71e7" id="71e7" class="graf graf--pre graf-after--pre">...</pre><pre name="3f3c" id="3f3c" class="graf graf--pre graf-after--pre">// create an array with &quot;n&quot; elements</pre>
                                        <p name="5ae3" id="5ae3" class="graf graf--p graf-after--pre">Here, at compile time, the compiler does not know how much memory the array will need because it is determined by the value provided by the user.</p>
                                        <p name="67d8" id="67d8" class="graf graf--p graf-after--p">It, therefore, cannot allocate room for a variable on the stack. Instead, our program needs to explicitly ask the operating system for the right amount of space at run-time. This memory is assigned from the <strong class="markup--strong markup--p-strong">heap space</strong>. The difference between static and dynamic memory allocation is summarized in the following table:</p>
                                        <figure name="4555" id="4555" class="graf graf--figure graf-after--p">
                                            <div class="aspectRatioPlaceholder is-locked" style="max-width: 700px; max-height: 295px;">
                                                <div class="aspectRatioPlaceholder-fill" style="padding-bottom: 42.1%;"></div>
                                                <div class="progressiveMedia js-progressiveMedia graf-image" data-image-id="1*qY-yRQWGI-DLS3zRHYHm9A.png" data-width="1024" data-height="431" data-action="zoom" data-action-value="1*qY-yRQWGI-DLS3zRHYHm9A.png"><img src="https://cdn-images-1.medium.com/freeze/max/30/1*qY-yRQWGI-DLS3zRHYHm9A.png?q=20" crossorigin="anonymous" class="progressiveMedia-thumbnail js-progressiveMedia-thumbnail">
                                                    <canvas class="progressiveMedia-canvas js-progressiveMedia-canvas"></canvas><img class="progressiveMedia-image js-progressiveMedia-image" data-src="https://cdn-images-1.medium.com/max/800/1*qY-yRQWGI-DLS3zRHYHm9A.png">
                                                    <noscript class="js-progressiveMedia-inner"><img class="progressiveMedia-noscript js-progressiveMedia-inner" src="https://cdn-images-1.medium.com/max/800/1*qY-yRQWGI-DLS3zRHYHm9A.png"></noscript>
                                                </div>
                                            </div>
                                            <figcaption class="imageCaption">Differences between statically and dynamically allocated memory</figcaption>
                                        </figure>
                                        <p name="c0f7" id="c0f7" class="graf graf--p graf-after--figure">To fully understand how dynamic memory allocation works, we need to spend more time on <strong class="markup--strong markup--p-strong">pointers, </strong>which might be a bit too much of a deviation from the topic of this post. If you’re interested in learning more, just let me know in the comments and we can go into more details about pointers in a future post.</p>
                                        <h4 name="983b" id="983b" class="graf graf--h4 graf-after--p">Allocation in JavaScript</h4>
                                        <p name="ae6b" id="ae6b" class="graf graf--p graf-after--h4">Now we’ll explain how the first step (allocate memory<strong class="markup--strong markup--p-strong">) </strong>works in JavaScript.</p>
                                        <p name="dc85" id="dc85" class="graf graf--p graf-after--p">JavaScript relieves developers from the responsibility to handle memory allocations — JavaScript does it by itself, alongside declaring values.</p><pre name="0d01" id="0d01" class="graf graf--pre graf-after--p"><code class="markup--code markup--pre-code">var n = 374; // allocates memory for a number<br>var s = &#39;sessionstack&#39;; // allocates memory for a string </code></pre><pre name="a6ef" id="a6ef" class="graf graf--pre graf-after--pre"><code class="markup--code markup--pre-code">var o = {<br>  a: 1,<br>  b: null<br>}; // allocates memory for an object and its contained values</code></pre><pre name="9509" id="9509" class="graf graf--pre graf-after--pre"><code class="markup--code markup--pre-code">var a = [1, null, &#39;str&#39;];  // (like object) allocates memory for the<br>                           // array and its contained values</code></pre><pre name="1183" id="1183" class="graf graf--pre graf-after--pre"><code class="markup--code markup--pre-code">function f(a) {<br>  return a + 3;<br>} // allocates a function (which is a callable object)</code></pre><pre name="4587" id="4587" class="graf graf--pre graf-after--pre"><code class="markup--code markup--pre-code">// function expressions also allocate an object<br>someElement.addEventListener(&#39;click&#39;, function() {<br>  someElement.style.backgroundColor = &#39;blue&#39;;<br>}, false);</code></pre>
                                        <p name="f57a" id="f57a" class="graf graf--p graf-after--pre">Some function calls result in object allocation as well:</p><pre name="7320" id="7320" class="graf graf--pre graf-after--p"><code class="markup--code markup--pre-code">var d = new Date(); // allocates a Date object</code></pre><pre name="6f46" id="6f46" class="graf graf--pre graf-after--pre"><code class="markup--code markup--pre-code">var e = document.createElement(&#39;div&#39;); // allocates a DOM element</code></pre>
                                        <p name="158b" id="158b" class="graf graf--p graf-after--pre">Methods can allocate new values or objects:</p><pre name="6931" id="6931" class="graf graf--pre graf-after--p"><code class="markup--code markup--pre-code">var s1 = &#39;sessionstack&#39;;<br>var s2 = s1.substr(0, 3); // s2 is a new string<br>// Since strings are immutable, <br>// JavaScript may decide to not allocate memory, <br>// but just store the [0, 3] range.</code></pre><pre name="9036" id="9036" class="graf graf--pre graf-after--pre"><code class="markup--code markup--pre-code">var a1 = [&#39;str1&#39;, &#39;str2&#39;];<br>var a2 = [&#39;str3&#39;, &#39;str4&#39;];<br>var a3 = a1.concat(a2); <br>// new array with 4 elements being<br>// the concatenation of a1 and a2 elements</code></pre>
                                        <h4 name="ff19" id="ff19" class="graf graf--h4 graf-after--pre">Using memory in JavaScript</h4>
                                        <p name="19a2" id="19a2" class="graf graf--p graf-after--h4">Using the allocated memory in JavaScript basically, means reading and writing in it.</p>
                                        <p name="089d" id="089d" class="graf graf--p graf-after--p">This can be done by reading or writing the value of a variable or an object property or even passing an argument to a function.</p>
                                        <h4 name="65a8" id="65a8" class="graf graf--h4 graf-after--p">Release when the memory is not needed anymore</h4>
                                        <p name="85b3" id="85b3" class="graf graf--p graf-after--h4">Most of the memory management issues come at this stage.</p>
                                        <p name="9ab2" id="9ab2" class="graf graf--p graf-after--p">The hardest task here is to figure out when the allocated memory is not needed any longer. It often requires the developer to determine where in the program such piece of memory is not needed anymore and free it.</p>
                                        <p name="d765" id="d765" class="graf graf--p graf-after--p">High-level languages embed a piece of software called <strong class="markup--strong markup--p-strong">garbage collector</strong> which job is to track memory allocation and use in order to find when a piece of allocated memory is not needed any longer in which case, it will automatically free it.</p>
                                        <p name="01ec" id="01ec" class="graf graf--p graf-after--p">Unfortunately, this process is an approximation since the general problem of knowing whether some piece of memory is needed is <a href="http://en.wikipedia.org/wiki/Decidability_%28logic%29" data-href="http://en.wikipedia.org/wiki/Decidability_%28logic%29" class="markup--anchor markup--p-anchor" rel="noopener" target="_blank">undecidable</a> (can’t be solved by an algorithm).</p>
                                        <p name="2a63" id="2a63" class="graf graf--p graf-after--p">Most garbage collectors work by collecting memory which can no longer be accessed, e.g. all variables pointing to it went out of scope. That’s, however, an under-approximation of the set of memory spaces that can be collected, because at any point a memory location may still have a variable pointing to it in scope, yet it will never be accessed again.</p>
                                        <h4 name="2610" id="2610" class="graf graf--h4 graf-after--p">Garbage collection</h4>
                                        <p name="3bcf" id="3bcf" class="graf graf--p graf-after--h4">Due to the fact that finding whether some memory is “not needed anymore” is undecidable, garbage collections implement a restriction of a solution to the general problem. This section will explain the necessary notions to understand the main garbage collection algorithms and their limitations.</p>
                                        <h4 name="fdfb" id="fdfb" class="graf graf--h4 graf-after--p">Memory references</h4>
                                        <p name="43c9" id="43c9" class="graf graf--p graf-after--h4">The main concept garbage collection algorithms rely on is the one of <strong class="markup--strong markup--p-strong">reference</strong>.</p>
                                        <p name="4f2f" id="4f2f" class="graf graf--p graf-after--p">Within the context of memory management, an object is said to reference another object if the former has an access to the latter (can be implicit or explicit). For instance, a JavaScript object has a reference to its <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/Inheritance_and_the_prototype_chain" data-href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/Inheritance_and_the_prototype_chain" class="markup--anchor markup--p-anchor" rel="noopener" target="_blank">prototype</a> (<strong class="markup--strong markup--p-strong">implicit reference</strong>) and to its properties’ values (<strong class="markup--strong markup--p-strong">explicit reference</strong>).</p>
                                        <p name="c958" id="c958" class="graf graf--p graf-after--p">In this context, the idea of an “object” is extended to something broader than regular JavaScript objects and also contains function scopes (or the global <strong class="markup--strong markup--p-strong">lexical scope</strong>).</p>
                                        <blockquote name="82ab" id="82ab" class="graf graf--blockquote graf-after--p">Lexical Scoping defines how variable names are resolved in nested functions: inner functions contain the scope of parent functions even if the parent function has returned.</blockquote>
                                        <h4 name="973f" id="973f" class="graf graf--h4 graf-after--blockquote">Reference-counting garbage collection</h4>
                                        <p name="2da6" id="2da6" class="graf graf--p graf-after--h4">This is the simplest garbage collection algorithm. An object is considered “garbage collectible” if there are <strong class="markup--strong markup--p-strong">zero</strong> references pointing to it.</p>
                                        <p name="dd11" id="dd11" class="graf graf--p graf-after--p">Take a look at the following code:</p><pre name="2cec" id="2cec" class="graf graf--pre graf-after--p"><code class="markup--code markup--pre-code">var o1 = {<br>  o2: {<br>    x: 1<br>  }<br>};</code></pre><pre name="4a00" id="4a00" class="graf graf--pre graf-after--pre"><code class="markup--code markup--pre-code">// 2 objects are created. <br>// &#39;o2&#39; is referenced by &#39;o1&#39; object as one of its properties.<br>// None can be garbage-collected</code></pre><pre name="1a48" id="1a48" class="graf graf--pre graf-after--pre"><code class="markup--code markup--pre-code"><br>var o3 = o1; // the &#39;o3&#39; variable is the second thing that <br>            // has a reference to the object pointed by &#39;o1&#39;. </code></pre><pre name="e7b2" id="e7b2" class="graf graf--pre graf-after--pre"><code class="markup--code markup--pre-code">                                                       <br>o1 = 1;      // now, the object that was originally in &#39;o1&#39; has a         <br>            // single reference, embodied by the &#39;o3&#39; variable<br><br>var o4 = o3.o2; // reference to &#39;o2&#39; property of the object.<br>                // This object has now 2 references: one as<br>                // a property. <br>                // The other as the &#39;o4&#39; variable<br><br>o3 = &#39;374&#39;; // The object that was originally in &#39;o1&#39; has now zero<br>            // references to it. <br>            // It can be garbage-collected.<br>            // However, what was its &#39;o2&#39; property is still<br>            // referenced by the &#39;o4&#39; variable, so it cannot be<br>            // freed.<br><br>o4 = null; // what was the &#39;o2&#39; property of the object originally in<br>           // &#39;o1&#39; has zero references to it. <br>           // It can be garbage collected.</code></pre>
                                        <h4 name="e21e" id="e21e" class="graf graf--h4 graf-after--pre">Cycles are creating problems</h4>
                                        <p name="f7f5" id="f7f5" class="graf graf--p graf-after--h4">There is a limitation when it comes to cycles. In the following example, two objects are created and reference one another, thus creating a cycle. They will go out of scope after the function call, so they are effectively useless and could be freed. However, the reference-counting algorithm considers that since each of the two objects is referenced at least once, neither can be garbage-collected.</p><pre name="0216" id="0216" class="graf graf--pre graf-after--p"><code class="markup--code markup--pre-code">function f() {<br>  var o1 = {};<br>  var o2 = {};<br>  o1.p = o2; // o1 references o2<br>  o2.p = o1; // o2 references o1. This creates a cycle.<br>}<br><br>f();</code></pre>
                                        <figure name="5d88" id="5d88" class="graf graf--figure graf-after--pre">
                                            <div class="aspectRatioPlaceholder is-locked" style="max-width: 386px; max-height: 209px;">
                                                <div class="aspectRatioPlaceholder-fill" style="padding-bottom: 54.1%;"></div>
                                                <div class="progressiveMedia js-progressiveMedia graf-image" data-image-id="1*GF3p99CQPZkX3UkgyVKSHw.png" data-width="386" data-height="209"><img src="https://cdn-images-1.medium.com/freeze/max/30/1*GF3p99CQPZkX3UkgyVKSHw.png?q=20" crossorigin="anonymous" class="progressiveMedia-thumbnail js-progressiveMedia-thumbnail">
                                                    <canvas class="progressiveMedia-canvas js-progressiveMedia-canvas"></canvas><img class="progressiveMedia-image js-progressiveMedia-image" data-src="https://cdn-images-1.medium.com/max/800/1*GF3p99CQPZkX3UkgyVKSHw.png">
                                                    <noscript class="js-progressiveMedia-inner"><img class="progressiveMedia-noscript js-progressiveMedia-inner" src="https://cdn-images-1.medium.com/max/800/1*GF3p99CQPZkX3UkgyVKSHw.png"></noscript>
                                                </div>
                                            </div>
                                        </figure>
                                        <h4 name="f98a" id="f98a" class="graf graf--h4 graf-after--figure">Mark-and-sweep algorithm</h4>
                                        <p name="7a6d" id="7a6d" class="graf graf--p graf-after--h4">In order to decide whether an object is needed, this algorithm determines whether the object is reachable.</p>
                                        <p name="e744" id="e744" class="graf graf--p graf-after--p">The algorithm consists of the following steps:</p>
                                        <ol class="postList">
                                            <li name="f8c4" id="f8c4" class="graf graf--li graf-after--p">The garbage collector builds a list of “roots”. Roots usually are global variables to which a reference is kept in the code. In JavaScript, the “window” object is an example of a global variable that can act as a root.</li>
                                            <li name="5f69" id="5f69" class="graf graf--li graf-after--li">All roots are inspected and marked as active (i.e. not garbage). All children are inspected recursively as well. Everything that can be reached from a root is not considered garbage.</li>
                                            <li name="34ac" id="34ac" class="graf graf--li graf-after--li">All pieces of memory not marked as active can now be considered garbage. The collector can now free that memory and return it to the OS.</li>
                                        </ol>
                                        <figure name="7f72" id="7f72" class="graf graf--figure graf-after--li">
                                            <div class="aspectRatioPlaceholder is-locked" style="max-width: 700px; max-height: 370px;">
                                                <div class="aspectRatioPlaceholder-fill" style="padding-bottom: 52.900000000000006%;"></div>
                                                <div class="progressiveMedia js-progressiveMedia graf-image" data-image-id="1*WVtok3BV0NgU95mpxk9CNg.gif" data-width="972" data-height="514" data-is-featured="true" data-action="zoom" data-action-value="1*WVtok3BV0NgU95mpxk9CNg.gif"><img src="https://cdn-images-1.medium.com/freeze/max/30/1*WVtok3BV0NgU95mpxk9CNg.gif?q=20" crossorigin="anonymous" class="progressiveMedia-thumbnail js-progressiveMedia-thumbnail">
                                                    <canvas class="progressiveMedia-canvas js-progressiveMedia-canvas"></canvas><img class="progressiveMedia-image js-progressiveMedia-image" data-src="https://cdn-images-1.medium.com/max/800/1*WVtok3BV0NgU95mpxk9CNg.gif">
                                                    <noscript class="js-progressiveMedia-inner"><img class="progressiveMedia-noscript js-progressiveMedia-inner" src="https://cdn-images-1.medium.com/max/800/1*WVtok3BV0NgU95mpxk9CNg.gif"></noscript>
                                                </div>
                                            </div>
                                            <figcaption class="imageCaption">A visualization of the mark and sweep algorithm in action</figcaption>
                                        </figure>
                                        <p name="a99c" id="a99c" class="graf graf--p graf-after--figure">This algorithm is better than the previous one since “an object has zero reference” leads to this object being unreachable. The opposite is not true as we have seen with cycles.</p>
                                        <p name="aec2" id="aec2" class="graf graf--p graf-after--p">As of 2012, all modern browsers ship a mark-and-sweep garbage-collector. All improvements made in the field of JavaScript garbage collection (generational/incremental/concurrent/parallel garbage collection) over the last years are implementation improvements of this algorithm (mark-and-sweep), but not improvements over the garbage collection algorithm itself, nor its goal of deciding whether an object is reachable or not.</p>
                                        <p name="44d8" id="44d8" class="graf graf--p graf-after--p"><a href="https://en.wikipedia.org/wiki/Tracing_garbage_collection" data-href="https://en.wikipedia.org/wiki/Tracing_garbage_collection" class="markup--anchor markup--p-anchor" rel="noopener" target="_blank">In this article</a>, you can read in a greater detail about tracing garbage collection that also covers mark-and-sweep along with its optimizations.</p>
                                        <h4 name="e373" id="e373" class="graf graf--h4 graf-after--p">Cycles are not a problem anymore</h4>
                                        <p name="01db" id="01db" class="graf graf--p graf-after--h4">In the first example above, after the function call returns, the two objects are not referenced anymore by something reachable from the global object. Consequently, they will be found unreachable by the garbage collector.</p>
                                        <figure name="5b96" id="5b96" class="graf graf--figure graf-after--p">
                                            <div class="aspectRatioPlaceholder is-locked" style="max-width: 700px; max-height: 525px;">
                                                <div class="aspectRatioPlaceholder-fill" style="padding-bottom: 75%;"></div>
                                                <div class="progressiveMedia js-progressiveMedia graf-image" data-image-id="1*FbbOG9mcqWZtNajjDO6SaA.png" data-width="1024" data-height="768" data-action="zoom" data-action-value="1*FbbOG9mcqWZtNajjDO6SaA.png"><img src="https://cdn-images-1.medium.com/freeze/max/30/1*FbbOG9mcqWZtNajjDO6SaA.png?q=20" crossorigin="anonymous" class="progressiveMedia-thumbnail js-progressiveMedia-thumbnail">
                                                    <canvas class="progressiveMedia-canvas js-progressiveMedia-canvas"></canvas><img class="progressiveMedia-image js-progressiveMedia-image" data-src="https://cdn-images-1.medium.com/max/800/1*FbbOG9mcqWZtNajjDO6SaA.png">
                                                    <noscript class="js-progressiveMedia-inner"><img class="progressiveMedia-noscript js-progressiveMedia-inner" src="https://cdn-images-1.medium.com/max/800/1*FbbOG9mcqWZtNajjDO6SaA.png"></noscript>
                                                </div>
                                            </div>
                                        </figure>
                                        <p name="976c" id="976c" class="graf graf--p graf-after--figure">Even though there are references between the objects, they’re not reachable from the root.</p>
                                        <h4 name="ae8b" id="ae8b" class="graf graf--h4 graf-after--p">Counter intuitive behavior of Garbage Collectors</h4>
                                        <p name="cba6" id="cba6" class="graf graf--p graf-after--h4">Although Garbage Collectors are convenient they come with their own set of trade-offs. One of them is <em class="markup--em markup--p-em">non-determinism</em>. In other words, GCs are unpredictable. You can’t really tell when a collection will be performed. This means that in some cases programs use more memory that it’s actually required. In other cases, short-pauses may be noticeable in particularly sensitive applications. Although non-determinism means one cannot be certain when a collection will be performed, most GC implementations share the common pattern of doing collection passes during allocation. If no allocations are performed, most GCs stay idle. Consider the following scenario:</p>
                                        <ol class="postList">
                                            <li name="0d5a" id="0d5a" class="graf graf--li graf-after--p">A sizable set of allocations is performed.</li>
                                            <li name="62d2" id="62d2" class="graf graf--li graf-after--li">Most of these elements (or all of them) are marked as unreachable (suppose we null a reference pointing to a cache we no longer need).</li>
                                            <li name="8313" id="8313" class="graf graf--li graf-after--li">No further allocations are performed.</li>
                                        </ol>
                                        <p name="3e16" id="3e16" class="graf graf--p graf-after--li">In this scenario, most GCs will not run any further collection passes. In other words, even though there are unreachable references available for collection, these are not claimed by the collector. These are not strictly leaks but still, result in higher-than-usual memory usage.</p>
                                        <h4 name="b306" id="b306" class="graf graf--h4 graf-after--p">What are memory leaks?</h4>
                                        <p name="ac6b" id="ac6b" class="graf graf--p graf-after--h4">In essence, memory leaks can be defined as memory that is not required by the application anymore but for some reason is not returned to the operating system or the pool of free memory.</p>
                                        <figure name="2e30" id="2e30" class="graf graf--figure graf-after--p">
                                            <div class="aspectRatioPlaceholder is-locked" style="max-width: 450px; max-height: 437px;">
                                                <div class="aspectRatioPlaceholder-fill" style="padding-bottom: 97.1%;"></div>
                                                <div class="progressiveMedia js-progressiveMedia graf-image" data-image-id="1*0B-dAUOH7NrcCDP6GhKHQw.jpeg" data-width="450" data-height="437"><img src="https://cdn-images-1.medium.com/freeze/max/30/1*0B-dAUOH7NrcCDP6GhKHQw.jpeg?q=20" crossorigin="anonymous" class="progressiveMedia-thumbnail js-progressiveMedia-thumbnail">
                                                    <canvas class="progressiveMedia-canvas js-progressiveMedia-canvas"></canvas><img class="progressiveMedia-image js-progressiveMedia-image" data-src="https://cdn-images-1.medium.com/max/800/1*0B-dAUOH7NrcCDP6GhKHQw.jpeg">
                                                    <noscript class="js-progressiveMedia-inner"><img class="progressiveMedia-noscript js-progressiveMedia-inner" src="https://cdn-images-1.medium.com/max/800/1*0B-dAUOH7NrcCDP6GhKHQw.jpeg"></noscript>
                                                </div>
                                            </div>
                                        </figure>
                                        <p name="c556" id="c556" class="graf graf--p graf-after--figure">Programming languages favor different ways of managing memory. However, whether a certain piece of memory is used or not is actually an <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Memory_Management#Release_when_the_memory_is_not_needed_anymore" data-href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Memory_Management#Release_when_the_memory_is_not_needed_anymore" class="markup--anchor markup--p-anchor" rel="noopener" target="_blank">undecidable problem</a>. In other words, only developers can make it clear whether a piece of memory can be returned to the operating system or not.</p>
                                        <p name="82b7" id="82b7" class="graf graf--p graf-after--p">Certain programming languages provide features that help developers do this. Others expect developers to be completely explicit about when a piece of memory is unused. Wikipedia has good articles on <a href="https://en.wikipedia.org/wiki/Manual_memory_management" data-href="https://en.wikipedia.org/wiki/Manual_memory_management" class="markup--anchor markup--p-anchor" rel="noopener" target="_blank">manual</a> and <a href="https://en.wikipedia.org/wiki/Garbage_collection_%28computer_science%29" data-href="https://en.wikipedia.org/wiki/Garbage_collection_(computer_science)" class="markup--anchor markup--p-anchor" rel="noopener" target="_blank">automatic</a> memory management.</p>
                                        <h4 name="2256" id="2256" class="graf graf--h4 graf-after--p">The four types of common JavaScript leaks</h4>
                                        <h4 name="1265" id="1265" class="graf graf--h4 graf-after--h4">1: Global variables</h4>
                                        <p name="c884" id="c884" class="graf graf--p graf-after--h4">JavaScript handles undeclared variables in an interesting way: a reference to an undeclared variable creates a new variable inside the <em class="markup--em markup--p-em">global </em>object. In the case of browsers, the global object is <code class="markup--code markup--p-code">window</code>. In other words:</p><pre name="7257" id="7257" class="graf graf--pre graf-after--p"><code class="markup--code markup--pre-code">function foo(arg) {<br>    bar = &quot;some text&quot;;<br>}</code></pre>
                                        <p name="a60f" id="a60f" class="graf graf--p graf-after--pre">is the equivalent of:</p><pre name="247c" id="247c" class="graf graf--pre graf-after--p"><code class="markup--code markup--pre-code">function foo(arg) {<br>    window.bar = &quot;some text&quot;;<br>}</code></pre>
                                        <p name="c5ff" id="c5ff" class="graf graf--p graf-after--pre">If <code class="markup--code markup--p-code">bar</code> was supposed to hold a reference to a variable only inside the scope of the <code class="markup--code markup--p-code">foo</code> function and you forget to use <code class="markup--code markup--p-code">var</code> to declare it, an unexpected global variable is created.</p>
                                        <p name="bcac" id="bcac" class="graf graf--p graf-after--p">In this example, leaking a simple string won&#39;t do much harm, but it could certainly be worse.</p>
                                        <p name="07f0" id="07f0" class="graf graf--p graf-after--p">Another way in which an accidental global variable can be created is through <code class="markup--code markup--p-code">this</code>:</p><pre name="2b0e" id="2b0e" class="graf graf--pre graf-after--p"><code class="markup--code markup--pre-code">function foo() {<br>    this.var1 = &quot;potential accidental global&quot;;<br>}</code></pre><pre name="9a15" id="9a15" class="graf graf--pre graf-after--pre"><code class="markup--code markup--pre-code">// Foo called on its own, this points to the global object (window)<br>// rather than being undefined.<br>foo();</code></pre>
                                        <blockquote name="b76b" id="b76b" class="graf graf--blockquote graf-after--pre">To prevent these mistakes from happening, add <code class="markup--code markup--blockquote-code">&#39;use strict&#39;;</code> at the beginning of your JavaScript files. This enables a stricter mode of parsing JavaScript that prevents accidental global variables. <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Strict_mode" data-href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Strict_mode" class="markup--anchor markup--blockquote-anchor" rel="noopener" target="_blank">Learn more</a> about this mode of JavaScript execution.</blockquote>
                                        <p name="4d3c" id="4d3c" class="graf graf--p graf-after--blockquote">Even though we talk about unsuspected globals, it’s still the case that much code is filled with explicit global variables. These are by definition non-collectible (unless assigned as null or reassigned). In particular, global variables that are used to temporarily store and process big amounts of information are of concern. If you must use a global variable to store lots of data, make sure to<strong class="markup--strong markup--p-strong"> assign it as null or reassign it</strong> after you are done with it.</p>
                                        <h4 name="ca77" id="ca77" class="graf graf--h4 graf-after--p">2: Timers or callbacks that are forgotten</h4>
                                        <p name="6647" id="6647" class="graf graf--p graf-after--h4">The use of <code class="markup--code markup--p-code">setInterval</code> is quite common in JavaScript.</p>
                                        <p name="c0e4" id="c0e4" class="graf graf--p graf-after--p">Most libraries, that provide observers and other facilities that take callbacks, take care of making any references to the callback unreachable after their own instances become unreachable as well. In the case of <code class="markup--code markup--p-code">setInterval</code>, however, code like this is quite common:</p><pre name="6430" id="6430" class="graf graf--pre graf-after--p"><code class="markup--code markup--pre-code">var serverData = loadData();<br>setInterval(function() {<br>    var renderer = document.getElementById(&#39;renderer&#39;);<br>    if(renderer) {<br>        renderer.innerHTML = JSON.stringify(serverData);<br>    }<br>}, 5000); //This will be executed every ~5 seconds.</code></pre>
                                        <p name="92dc" id="92dc" class="graf graf--p graf-after--pre">This example illustrates what can happen with timers: timers that make reference to nodes or data that is no longer required.</p>
                                        <p name="3724" id="3724" class="graf graf--p graf-after--p">The object represented by <code class="markup--code markup--p-code">renderer</code> may be removed in the future, making the whole block inside the interval handler unnecessary. However, the handler cannot be collected as the interval is still active, (the interval needs to be stopped for this to happen). If the interval handler cannot be collected, its dependencies cannot be collected either. This means that <code class="markup--code markup--p-code">serverData</code>, which presumably stores quite a big amount of data, cannot be collected either.</p>
                                        <p name="99db" id="99db" class="graf graf--p graf-after--p">In the case of observers, it is important to make explicit calls to remove them once they are not needed anymore (or the associated object is about to be made unreachable).</p>
                                        <p name="1cf2" id="1cf2" class="graf graf--p graf-after--p">In the past, this used to be particularly important as certain browsers (the good old IE 6) were not able to manage well cyclic references (see below for more info). Nowadays, most browsers can and will collect observer handlers once the observed object becomes unreachable, even if the listener is not explicitly removed. It remains good practice, however, to explicitly remove these observers before the object is disposed of. For instance:</p><pre name="94b4" id="94b4" class="graf graf--pre graf-after--p"><code class="markup--code markup--pre-code">var element = document.getElementById(&#39;launch-button&#39;);<br>var counter = 0;</code></pre><pre name="b2e5" id="b2e5" class="graf graf--pre graf-after--pre"><code class="markup--code markup--pre-code">function onClick(event) {<br>   counter++;<br>   element.innerHtml = &#39;text &#39; + counter;<br>}</code></pre><pre name="e6e2" id="e6e2" class="graf graf--pre graf-after--pre"><code class="markup--code markup--pre-code">element.addEventListener(&#39;click&#39;, onClick);</code></pre><pre name="662a" id="662a" class="graf graf--pre graf-after--pre"><code class="markup--code markup--pre-code">// Do stuff</code></pre><pre name="4388" id="4388" class="graf graf--pre graf-after--pre"><code class="markup--code markup--pre-code">element.removeEventListener(&#39;click&#39;, onClick);<br>element.parentNode.removeChild(element);</code></pre><pre name="9c5c" id="9c5c" class="graf graf--pre graf-after--pre"><code class="markup--code markup--pre-code">// Now when element goes out of scope,<br>// both element and onClick will be collected even in old browsers // that don&#39;t handle cycles well.</code></pre>
                                        <p name="e3fe" id="e3fe" class="graf graf--p graf-after--pre">Nowadays, modern browsers (including Internet Explorer and Microsoft Edge) use modern garbage collection algorithms that can detect these cycles and deal with them correctly. In other words, it’s not strictly necessary to call <code class="markup--code markup--p-code">removeEventListener</code> before making a node unreachable.</p>
                                        <p name="d17d" id="d17d" class="graf graf--p graf-after--p">Frameworks and libraries such as <em class="markup--em markup--p-em">jQuery</em> do remove listeners before disposing of a node (when using their specific APIs for that). This is handled internally by the libraries which also make sure that no leaks are produced, even when running under problematic browsers such as … yeah, IE 6.</p>
                                        <h4 name="4879" id="4879" class="graf graf--h4 graf-after--p">3: Closures</h4>
                                        <p name="c1ee" id="c1ee" class="graf graf--p graf-after--h4">A key aspect of JavaScript development are closures: an inner function that has access to the outer (enclosing) function’s variables. Due to the implementation details of the JavaScript runtime, it is possible to leak memory in the following way:</p><pre name="c5ec" id="c5ec" class="graf graf--pre graf-after--p">var theThing = null;</pre><pre name="1fd6" id="1fd6" class="graf graf--pre graf-after--pre">var replaceThing = function () {</pre><pre name="311c" id="311c" class="graf graf--pre graf-after--pre">  var originalThing = theThing;<br>  var unused = function () {<br>    if (originalThing) // a reference to &#39;originalThing&#39;<br>      console.log(&quot;hi&quot;);<br>  };</pre><pre name="dff8" id="dff8" class="graf graf--pre graf-after--pre">  theThing = {<br>    longStr: new Array(1000000).join(&#39;*&#39;),<br>    someMethod: function () {<br>      console.log(&quot;message&quot;);<br>    }<br>  };<br>};</pre><pre name="ca58" id="ca58" class="graf graf--pre graf-after--pre">setInterval(replaceThing, 1000);</pre>
                                        <p name="18e5" id="18e5" class="graf graf--p graf-after--pre">This snippet does one thing: every time <code class="markup--code markup--p-code">replaceThing</code> is called, <code class="markup--code markup--p-code">theThing</code> gets a new object which contains a big array and a new closure (<code class="markup--code markup--p-code">someMethod</code>). At the same time, the variable <code class="markup--code markup--p-code">unused</code> holds a closure that has a reference to <code class="markup--code markup--p-code">originalThing</code> (<code class="markup--code markup--p-code">theThing</code> from the previous call to <code class="markup--code markup--p-code">replaceThing</code>). Already somewhat confusing, huh? The important thing is that <strong class="markup--strong markup--p-strong">once a scope is created for closures that are in the same parent scope, that scope is shared</strong>.</p>
                                        <p name="ab6d" id="ab6d" class="graf graf--p graf-after--p">In this case, the scope created for the closure <code class="markup--code markup--p-code">someMethod</code> is shared with <code class="markup--code markup--p-code">unused</code>. <code class="markup--code markup--p-code">unused</code> has a reference to <code class="markup--code markup--p-code">originalThing</code>. Even though <code class="markup--code markup--p-code">unused</code> is never used, <code class="markup--code markup--p-code">someMethod </code>can be used through <code class="markup--code markup--p-code">theThing</code> outside of the scope of <code class="markup--code markup--p-code">replaceThing</code> (e.g. somewhere globally). And as <code class="markup--code markup--p-code">someMethod</code> shares the closure scope with <code class="markup--code markup--p-code">unused</code>, the reference <code class="markup--code markup--p-code">unused</code> has to <code class="markup--code markup--p-code">originalThing</code> forces it to stay active (the whole shared scope between the two closures). This prevents its collection.</p>
                                        <p name="710d" id="710d" class="graf graf--p graf-after--p">When this snippet is run repeatedly a steady increase in memory usage can be observed. This does not get smaller when the GC runs. In essence, a linked list of closures is created (with its root in the form of the <code class="markup--code markup--p-code">theThing</code> variable), and each of these closures&#39; scopes carries an indirect reference to the big array, resulting in a sizable leak.</p>
                                        <p name="00a7" id="00a7" class="graf graf--p graf-after--p">This issue was found by the Meteor team and <a href="https://blog.meteor.com/an-interesting-kind-of-javascript-memory-leak-8b47d2e7f156" data-href="https://blog.meteor.com/an-interesting-kind-of-javascript-memory-leak-8b47d2e7f156" class="markup--anchor markup--p-anchor" rel="noopener" target="_blank">they have a great article</a> that describes the issue in great detail.</p>
                                        <h4 name="1889" id="1889" class="graf graf--h4 graf-after--p">4: Out of DOM references</h4>
                                        <p name="4b9e" id="4b9e" class="graf graf--p graf-after--h4">Sometimes it may be useful to store DOM nodes inside data structures. Suppose you want to rapidly update the contents of several rows in a table. It may make sense to store a reference to each DOM row in a dictionary or an array. When this happens, two references to the same DOM element are kept: one in the DOM tree and the other in the dictionary. If at some point in the future you decide to remove these rows, you need to make both references unreachable.</p><pre name="0cb6" id="0cb6" class="graf graf--pre graf-after--p"><code class="markup--code markup--pre-code">var elements = {<br>    button: document.getElementById(&#39;button&#39;),<br>    image: document.getElementById(&#39;image&#39;)<br>};</code></pre><pre name="a7b2" id="a7b2" class="graf graf--pre graf-after--pre"><code class="markup--code markup--pre-code">function doStuff() {<br>    elements.image.src = &#39;http://example.com/image_name.png&#39;;<br>}</code></pre><pre name="35ab" id="35ab" class="graf graf--pre graf-after--pre"><code class="markup--code markup--pre-code">function removeImage() {<br>    // The image is a direct child of the body element.<br>    document.body.removeChild(document.getElementById(&#39;image&#39;));</code></pre><pre name="a209" id="a209" class="graf graf--pre graf-after--pre"><code class="markup--code markup--pre-code">    // At this point, we still have a reference to #button in the<br>    //global elements object. In other words, the button element is<br>    //still in memory and cannot be collected by the GC.<br>}</code></pre>
                                        <p name="431c" id="431c" class="graf graf--p graf-after--pre">There’s an additional consideration that has to be taken into account when it comes to references to inner or leaf nodes inside a DOM tree. Say you keep a reference to a specific cell of a table (a <code class="markup--code markup--p-code">&lt;td&gt;</code> tag) in your JavaScript code. One day you decide to remove the table from the DOM but keep the reference to that cell. Intuitively one may suppose the GC will collect everything but that cell. In reality, this won’t happen: the cell is a child node of that table and children keep references to their parents. That is, the reference to the table cell from JavaScript code causes <strong class="markup--strong markup--p-strong">the whole table to stay in memory</strong>. Consider this carefully when keeping references to DOM elements.</p>
                                        <p name="2472" id="2472" class="graf graf--p graf-after--p">We at SessionStack try to follow these best practices in writing code that handles memory allocation properly, and here’s why:</p>
                                        <p name="4ca0" id="4ca0" class="graf graf--p graf-after--p">Once you integrate SessionStack into your production web app, it starts recording everything: all DOM changes, user interactions, JavaScript exceptions, stack traces, failed network requests, debug messages, etc.
                                            <br>With SessionStack, you replay issues in your web apps as videos and see everything that happened to your user. And all of this has to take place with no performance impact for your web app.
                                            <br>Since the user can reload the page or navigate your app, all observers, interceptors, variable allocations, etc. have to be handled properly, so they don’t cause any memory leaks or don’t increase the memory consumption of the web app in which we are integrated.</p>
                                        <p name="3267" id="3267" class="graf graf--p graf-after--p">There is a free plan so you can <a href="https://www.sessionstack.com/signup" data-href="https://www.sessionstack.com/signup" class="markup--anchor markup--p-anchor" rel="noopener" target="_blank">give it a try now</a>.</p>
                                        <figure name="e37b" id="e37b" class="graf graf--figure graf-after--p">
                                            <div class="aspectRatioPlaceholder"><img class="graf-image" data-image-id="1*kEQmoMuNBDfZKNSBh0tvRA.png" src="https://cdn-images-1.medium.com/max/800/1*kEQmoMuNBDfZKNSBh0tvRA.png"></div>
                                        </figure>
                                        <h4 name="9cdf" id="9cdf" class="graf graf--h4 graf-after--figure">Resources</h4>
                                        <ul class="postList">
                                            <li name="1625" id="1625" class="graf graf--li graf-after--h4"><a href="http://www-bcf.usc.edu/~dkempe/CS104/08-29.pdf" data-href="http://www-bcf.usc.edu/~dkempe/CS104/08-29.pdf" class="markup--anchor markup--li-anchor" rel="nofollow noopener" target="_blank">http://www-bcf.usc.edu/~dkempe/CS104/08-29.pdf</a></li>
                                            <li name="76b2" id="76b2" class="graf graf--li graf-after--li"><a href="https://blog.meteor.com/an-interesting-kind-of-javascript-memory-leak-8b47d2e7f156" data-href="https://blog.meteor.com/an-interesting-kind-of-javascript-memory-leak-8b47d2e7f156" class="markup--anchor markup--li-anchor" rel="nofollow noopener" target="_blank">https://blog.meteor.com/an-interesting-kind-of-javascript-memory-leak-8b47d2e7f156</a></li>
                                            <li name="b6aa" id="b6aa" class="graf graf--li graf-after--li graf--trailing"><a href="http://www.nodesimplified.com/2017/08/javascript-memory-management-and.html" data-href="http://www.nodesimplified.com/2017/08/javascript-memory-management-and.html" class="markup--anchor markup--li-anchor" rel="nofollow noopener" target="_blank">http://www.nodesimplified.com/2017/08/javascript-memory-management-and.html</a></li>
                                        </ul>
                                    </div>
                                </div>
                            </section>
                        </div>
