<div class="postArticle-content js-postField js-notesSource js-trackedPost" data-post-id="ac089e62b12e" data-source="post_page" data-collection-id="12d1b859d4e4" data-tracking-context="postPage">
                            <section name="2789" class="section section--body section--first section--last">
                                <div class="section-divider">
                                    <hr class="section-divider">
                                </div>
                                <div class="section-content">
                                    <div class="section-inner sectionLayout--insetColumn">
                                        <h1 name="7d43" id="7d43" class="graf graf--h3 graf--leading graf--title">inside the V8 engine</h1>
                                        <p name="92cf" id="92cf" class="graf graf--p graf-after--h3">Couple of weeks ago we started a series aimed at digging deeper into JavaScript and how it actually works: we thought that by knowing the building blocks of JavaScript and how they come to play together you’ll be able to write better code and apps.</p>
                                        <p name="66f2" id="66f2" class="graf graf--p graf-after--p"><a href="https://blog.sessionstack.com/how-does-javascript-actually-work-part-1-b0bacc073cf" data-href="https://blog.sessionstack.com/how-does-javascript-actually-work-part-1-b0bacc073cf" class="markup--anchor markup--p-anchor" target="_blank">The first post of the series</a> focused on providing an overview of the engine, the runtime and the call stack. This second post will be diving into the internal parts of Google’s V8 JavaScript engine. We’ll also provide a few quick tips on how to write better JavaScript code —best practices our development team at <a href="https://www.sessionstack.com/" data-href="https://www.sessionstack.com/" class="markup--anchor markup--p-anchor" rel="noopener" target="_blank">SessionStack</a> follows when building the product.</p>
                                        <h4 name="e7ca" id="e7ca" class="graf graf--h4 graf-after--p">Overview</h4>
                                        <p name="893d" id="893d" class="graf graf--p graf-after--h4">A <strong class="markup--strong markup--p-strong">JavaScript engine</strong> is a program or an interpreter which executes JavaScript code. A JavaScript engine can be implemented as a standard interpreter, or just-in-time compiler that compiles JavaScript to bytecode in some form.</p>
                                        <p name="4c0a" id="4c0a" class="graf graf--p graf-after--p">This is a list of popular projects that are implementing a JavaScript engine:</p>
                                        <ul class="postList">
                                            <li name="a2d0" id="a2d0" class="graf graf--li graf-after--p"><a href="https://en.wikipedia.org/wiki/V8_%28JavaScript_engine%29" data-href="https://en.wikipedia.org/wiki/V8_(JavaScript_engine)" class="markup--anchor markup--li-anchor" title="V8 (JavaScript engine)" rel="noopener" target="_blank"><strong class="markup--strong markup--li-strong">V8</strong></a> — open source, developed by Google, written in C++</li>
                                            <li name="5fe1" id="5fe1" class="graf graf--li graf-after--li"><a href="https://en.wikipedia.org/wiki/Rhino_%28JavaScript_engine%29" data-href="https://en.wikipedia.org/wiki/Rhino_(JavaScript_engine)" class="markup--anchor markup--li-anchor" title="Rhino (JavaScript engine)" rel="noopener" target="_blank"><strong class="markup--strong markup--li-strong">Rhin</strong></a><strong class="markup--strong markup--li-strong">o</strong> — managed by the Mozilla Foundation, open source, developed entirely in Java</li>
                                            <li name="5246" id="5246" class="graf graf--li graf-after--li"><a href="https://en.wikipedia.org/wiki/SpiderMonkey_%28JavaScript_engine%29" data-href="https://en.wikipedia.org/wiki/SpiderMonkey_(JavaScript_engine)" class="markup--anchor markup--li-anchor" title="SpiderMonkey (JavaScript engine)" rel="noopener" target="_blank"><strong class="markup--strong markup--li-strong">SpiderMonkey</strong></a> — the first JavaScript engine, which back in the days powered Netscape Navigator, and today powers Firefox</li>
                                            <li name="9a60" id="9a60" class="graf graf--li graf-after--li"><a href="https://en.wikipedia.org/wiki/JavaScriptCore" data-href="https://en.wikipedia.org/wiki/JavaScriptCore" class="markup--anchor markup--li-anchor" title="JavaScriptCore" rel="noopener" target="_blank"><strong class="markup--strong markup--li-strong">JavaScriptCore</strong></a> — open source, marketed as Nitro and developed by Apple for Safari</li>
                                            <li name="09a5" id="09a5" class="graf graf--li graf-after--li"><a href="https://en.wikipedia.org/wiki/KJS_%28KDE%29" data-href="https://en.wikipedia.org/wiki/KJS_(KDE)" class="markup--anchor markup--li-anchor" title="KJS (KDE)" rel="noopener" target="_blank"><strong class="markup--strong markup--li-strong">KJS</strong></a> — KDE’s engine originally developed by Harri Porten for the KDE project’s Konqueror web browser</li>
                                            <li name="7bd8" id="7bd8" class="graf graf--li graf-after--li"><a href="https://en.wikipedia.org/wiki/Chakra_%28JScript_engine%29" data-href="https://en.wikipedia.org/wiki/Chakra_(JScript_engine)" class="markup--anchor markup--li-anchor" title="Chakra (JScript engine)" rel="noopener" target="_blank"><strong class="markup--strong markup--li-strong">Chakra</strong> (JScript9)</a> — Internet Explorer</li>
                                            <li name="897e" id="897e" class="graf graf--li graf-after--li"><a href="https://en.wikipedia.org/wiki/Chakra_%28JavaScript_engine%29" data-href="https://en.wikipedia.org/wiki/Chakra_(JavaScript_engine)" class="markup--anchor markup--li-anchor" title="Chakra (JavaScript engine)" rel="noopener" target="_blank"><strong class="markup--strong markup--li-strong">Chakra</strong> (JavaScript)</a> — Microsoft Edge</li>
                                            <li name="722b" id="722b" class="graf graf--li graf-after--li"><a href="https://en.wikipedia.org/wiki/Nashorn_%28JavaScript_engine%29" data-href="https://en.wikipedia.org/wiki/Nashorn_(JavaScript_engine)" class="markup--anchor markup--li-anchor" title="Nashorn (JavaScript engine)" rel="noopener" target="_blank"><strong class="markup--strong markup--li-strong">Nashorn</strong></a>, open source as part of OpenJDK, written by Oracle Java Languages and Tool Group</li>
                                            <li name="f655" id="f655" class="graf graf--li graf-after--li"><a href="https://en.wikipedia.org/wiki/JerryScript" data-href="https://en.wikipedia.org/wiki/JerryScript" class="markup--anchor markup--li-anchor" title="JerryScript" rel="noopener" target="_blank"><strong class="markup--strong markup--li-strong">JerryScript</strong></a> — is a lightweight engine for the Internet of Things.</li>
                                        </ul>
                                        <h4 name="fd09" id="fd09" class="graf graf--h4 graf-after--li">Why was the V8 Engine created?</h4>
                                        <p name="1434" id="1434" class="graf graf--p graf-after--h4">The V8 Engine which is built by Google is open source and written in <strong class="markup--strong markup--p-strong">C++</strong>. This engine is used inside Google Chrome. Unlike the rest of the engines, however, V8 is also used for the popular Node.js runtime.</p>
                                        <figure name="b119" id="b119" class="graf graf--figure graf-after--p">
                                            <div class="aspectRatioPlaceholder is-locked" style="max-width: 700px; max-height: 700px;">
                                                <div class="aspectRatioPlaceholder-fill" style="padding-bottom: 100%;"></div>
                                                <div class="progressiveMedia js-progressiveMedia graf-image" data-image-id="1*AKKvE3QmN_ZQmEzSj16oXg.png" data-width="1900" data-height="1900" data-is-featured="true" data-action="zoom" data-action-value="1*AKKvE3QmN_ZQmEzSj16oXg.png"><img src="https://cdn-images-1.medium.com/freeze/max/30/1*AKKvE3QmN_ZQmEzSj16oXg.png?q=20" crossorigin="anonymous" class="progressiveMedia-thumbnail js-progressiveMedia-thumbnail">
                                                    <canvas class="progressiveMedia-canvas js-progressiveMedia-canvas"></canvas><img class="progressiveMedia-image js-progressiveMedia-image" data-src="https://cdn-images-1.medium.com/max/800/1*AKKvE3QmN_ZQmEzSj16oXg.png">
                                                    <noscript class="js-progressiveMedia-inner"><img class="progressiveMedia-noscript js-progressiveMedia-inner" src="https://cdn-images-1.medium.com/max/800/1*AKKvE3QmN_ZQmEzSj16oXg.png"></noscript>
                                                </div>
                                            </div>
                                        </figure>
                                        <p name="6fab" id="6fab" class="graf graf--p graf-after--figure">V8 was first designed to increase the performance of JavaScript execution inside web browsers. In order to obtain speed, V8 translates JavaScript code into more efficient machine code instead of using an interpreter. It compiles JavaScript code into machine code at execution by implementing a <strong class="markup--strong markup--p-strong">JIT (Just-In-Time) compiler</strong> like a lot of modern JavaScript engines do such as SpiderMonkey or Rhino (Mozilla). The main difference here is that V8 doesn’t produce bytecode or any intermediate code.</p>
                                        <h4 name="daa2" id="daa2" class="graf graf--h4 graf-after--p">V8 used to have two compilers</h4>
                                        <p name="789a" id="789a" class="graf graf--p graf-after--h4">Before version 5.9 of V8 came out (released earlier this year), the engine used two compilers:</p>
                                        <ul class="postList">
                                            <li name="d20d" id="d20d" class="graf graf--li graf-after--p">full-codegen — a simple and very fast compiler that produced simple and relatively slow machine code.</li>
                                            <li name="0076" id="0076" class="graf graf--li graf-after--li">Crankshaft — a more complex (Just-In-Time) optimizing compiler that produced highly-optimized code.</li>
                                        </ul>
                                        <p name="405a" id="405a" class="graf graf--p graf-after--li">The V8 Engine also uses several threads internally:</p>
                                        <ul class="postList">
                                            <li name="5f56" id="5f56" class="graf graf--li graf-after--p">The main thread does what you would expect: fetch your code, compile it and then execute it</li>
                                            <li name="f551" id="f551" class="graf graf--li graf-after--li">There’s also a separate thread for compiling, so that the main thread can keep executing while the former is optimizing the code</li>
                                            <li name="b70d" id="b70d" class="graf graf--li graf-after--li">A Profiler thread that will tell the runtime on which methods we spend a lot of time so that Crankshaft can optimize them</li>
                                            <li name="c989" id="c989" class="graf graf--li graf-after--li">A few threads to handle Garbage Collector sweeps</li>
                                        </ul>
                                        <p name="ed80" id="ed80" class="graf graf--p graf-after--li">When first executing the JavaScript code, V8 leverages <strong class="markup--strong markup--p-strong">full-codegen</strong> which directly translates the parsed JavaScript into machine code without any transformation. This allows it to start executing machine code <strong class="markup--strong markup--p-strong">very fast</strong>. Note that V8 does not use intermediate bytecode representation this way removing the need for an interpreter.</p>
                                        <p name="0b0c" id="0b0c" class="graf graf--p graf-after--p">When your code has run for some time, the profiler thread has gathered enough data to tell which method should be optimized.</p>
                                        <p name="656c" id="656c" class="graf graf--p graf-after--p">Next, <strong class="markup--strong markup--p-strong">Crankshaft</strong> optimizations begin in another thread. It translates the JavaScript abstract syntax tree to a high-level static single-assignment (SSA) representation called <strong class="markup--strong markup--p-strong">Hydrogen</strong> and tries to optimize that Hydrogen graph. Most optimizations are done at this level.</p>
                                        <h4 name="e273" id="e273" class="graf graf--h4 graf-after--p">Inlining</h4>
                                        <p name="0247" id="0247" class="graf graf--p graf-after--h4">The first optimization is inlining as much code as possible in advance. Inlining is the process of replacing a call site (the line of code where the function is called) with the body of the called function. This simple step allows following optimizations to be more meaningful.</p>
                                        <figure name="13c2" id="13c2" class="graf graf--figure graf-after--p">
                                            <div class="aspectRatioPlaceholder is-locked" style="max-width: 512px; max-height: 476px;">
                                                <div class="aspectRatioPlaceholder-fill" style="padding-bottom: 93%;"></div>
                                                <div class="progressiveMedia js-progressiveMedia graf-image" data-image-id="0*RRgTDdRfLGEhuR7U.png" data-width="512" data-height="476"><img src="https://cdn-images-1.medium.com/freeze/max/30/0*RRgTDdRfLGEhuR7U.png?q=20" crossorigin="anonymous" class="progressiveMedia-thumbnail js-progressiveMedia-thumbnail">
                                                    <canvas class="progressiveMedia-canvas js-progressiveMedia-canvas"></canvas><img class="progressiveMedia-image js-progressiveMedia-image" data-src="https://cdn-images-1.medium.com/max/800/0*RRgTDdRfLGEhuR7U.png">
                                                    <noscript class="js-progressiveMedia-inner"><img class="progressiveMedia-noscript js-progressiveMedia-inner" src="https://cdn-images-1.medium.com/max/800/0*RRgTDdRfLGEhuR7U.png"></noscript>
                                                </div>
                                            </div>
                                        </figure>
                                        <h4 name="eb2b" id="eb2b" class="graf graf--h4 graf-after--figure">Hidden class</h4>
                                        <p name="f657" id="f657" class="graf graf--p graf-after--h4">JavaScript is a prototype-based language: there are <strong class="markup--strong markup--p-strong">no classes</strong> and objects are created using a cloning process. JavaScript is also a dynamic programming language which means that properties can be easily added or removed from an object after its instantiation.</p>
                                        <p name="8f0c" id="8f0c" class="graf graf--p graf-after--p">Most JavaScript interpreters use dictionary-like structures (<a href="http://en.wikipedia.org/wiki/Hash_function" data-href="http://en.wikipedia.org/wiki/Hash_function" class="markup--anchor markup--p-anchor" rel="noopener" target="_blank">hash function</a> based) to store the location of object property values in the memory. This structure makes retrieving the value of a property in JavaScript more computationally expensive than it would be in a non-dynamic programming language like Java or C#. In Java, all of the object properties are determined by a fixed object layout before compilation and cannot be dynamically added or removed at runtime (well, C# has the <a href="https://docs.microsoft.com/en-us/dotnet/csharp/language-reference/keywords/dynamic" data-href="https://docs.microsoft.com/en-us/dotnet/csharp/language-reference/keywords/dynamic" class="markup--anchor markup--p-anchor" rel="noopener" target="_blank">dynamic</a> type which is another topic). As a result, the values of properties (or pointers to those properties) can be stored as a continuous buffer in the memory with a fixed-offset between each. The length of an offset can easily be determined based on the property type, whereas this is not possible in JavaScript where a property type can change during runtime.</p>
                                        <p name="3c27" id="3c27" class="graf graf--p graf-after--p">Since using dictionaries to find the location of object properties in the memory is very inefficient, V8 uses a different method instead: <strong class="markup--strong markup--p-strong">hidden classes</strong>. Hidden classes work similarly to the fixed object layouts (classes) used in languages like Java, except they are created at runtime. Now, let’s see what they actually look like:</p><pre name="5ece" id="5ece" class="graf graf--pre graf-after--p">function Point(x, y) {<br>    this.x = x;<br>    this.y = y;<br>}</pre><pre name="283c" id="283c" class="graf graf--pre graf-after--pre">var p1 = new Point(1, 2);</pre>
                                        <p name="5716" id="5716" class="graf graf--p graf-after--pre">Once the “new Point(1, 2)” invocation happens, V8 will create a hidden class called “C0”.</p>
                                        <figure name="4d81" id="4d81" class="graf graf--figure graf-after--p">
                                            <div class="aspectRatioPlaceholder is-locked" style="max-width: 700px; max-height: 525px;">
                                                <div class="aspectRatioPlaceholder-fill" style="padding-bottom: 75%;"></div>
                                                <div class="progressiveMedia js-progressiveMedia graf-image" data-image-id="1*pVnIrMZiB9iAz5sW28AixA.png" data-width="1024" data-height="768" data-action="zoom" data-action-value="1*pVnIrMZiB9iAz5sW28AixA.png"><img src="https://cdn-images-1.medium.com/freeze/max/30/1*pVnIrMZiB9iAz5sW28AixA.png?q=20" crossorigin="anonymous" class="progressiveMedia-thumbnail js-progressiveMedia-thumbnail">
                                                    <canvas class="progressiveMedia-canvas js-progressiveMedia-canvas"></canvas><img class="progressiveMedia-image js-progressiveMedia-image" data-src="https://cdn-images-1.medium.com/max/800/1*pVnIrMZiB9iAz5sW28AixA.png">
                                                    <noscript class="js-progressiveMedia-inner"><img class="progressiveMedia-noscript js-progressiveMedia-inner" src="https://cdn-images-1.medium.com/max/800/1*pVnIrMZiB9iAz5sW28AixA.png"></noscript>
                                                </div>
                                            </div>
                                        </figure>
                                        <p name="a8b0" id="a8b0" class="graf graf--p graf-after--figure">No properties have been defined for Point yet, so “C0” is empty.</p>
                                        <p name="afd3" id="afd3" class="graf graf--p graf-after--p">Once the first statement “this.x = x” is executed (inside the “Point” function), V8 will create a second hidden class called “C1” that is based on “C0”. “C1” describes the location in the memory (relative to the object pointer) where the property x can be found. In this case, “x” is stored at <a href="http://en.wikipedia.org/wiki/Offset_%28computer_science%29" data-href="http://en.wikipedia.org/wiki/Offset_%28computer_science%29" class="markup--anchor markup--p-anchor" rel="noopener" target="_blank">offset</a> 0, which means that when viewing a point object in the memory as a continuous buffer, the first offset will correspond to property “x”. V8 will also update “C0” with a “class transition” which states that if a property “x” is added to a point object, the hidden class should switch from “C0” to “C1”. The hidden class for the point object below is now “C1”.</p>
                                        <figure name="7cf9" id="7cf9" class="graf graf--figure graf-after--p">
                                            <div class="aspectRatioPlaceholder is-locked" style="max-width: 700px; max-height: 525px;">
                                                <div class="aspectRatioPlaceholder-fill" style="padding-bottom: 75%;"></div>
                                                <div class="progressiveMedia js-progressiveMedia graf-image" data-image-id="1*QsVUE3snZD9abYXccg6Sgw.png" data-width="1024" data-height="768" data-action="zoom" data-action-value="1*QsVUE3snZD9abYXccg6Sgw.png"><img src="https://cdn-images-1.medium.com/freeze/max/30/1*QsVUE3snZD9abYXccg6Sgw.png?q=20" crossorigin="anonymous" class="progressiveMedia-thumbnail js-progressiveMedia-thumbnail">
                                                    <canvas class="progressiveMedia-canvas js-progressiveMedia-canvas"></canvas><img class="progressiveMedia-image js-progressiveMedia-image" data-src="https://cdn-images-1.medium.com/max/800/1*QsVUE3snZD9abYXccg6Sgw.png">
                                                    <noscript class="js-progressiveMedia-inner"><img class="progressiveMedia-noscript js-progressiveMedia-inner" src="https://cdn-images-1.medium.com/max/800/1*QsVUE3snZD9abYXccg6Sgw.png"></noscript>
                                                </div>
                                            </div>
                                            <figcaption class="imageCaption"><em class="markup--em markup--figure-em">Every time a new property is added to an object, the old hidden class is updated with a transition path to the new hidden class. Hidden class transitions are important because they allow hidden classes to be shared among objects that are created the same way. If two objects share a hidden class and the same property is added to both of them, transitions will ensure that both objects receive the same new hidden class and all the optimized code that comes with it.</em></figcaption>
                                        </figure>
                                        <p name="6259" id="6259" class="graf graf--p graf-after--figure">This process is repeated when the statement “this.y = y” is executed (again, inside the Point function, after the “this.x = x” statement).</p>
                                        <p name="9d91" id="9d91" class="graf graf--p graf-after--p">A new hidden class called “C2” is created, a class transition is added to “C1” stating that if a property “y” is added to a Point object (that already contains property “x”) then the hidden class should change to “C2”, and the point object’s hidden class is updated to “C2”.</p>
                                        <figure name="0678" id="0678" class="graf graf--figure graf-after--p">
                                            <div class="aspectRatioPlaceholder is-locked" style="max-width: 700px; max-height: 525px;">
                                                <div class="aspectRatioPlaceholder-fill" style="padding-bottom: 75%;"></div>
                                                <div class="progressiveMedia js-progressiveMedia graf-image" data-image-id="1*spJ8v7GWivxZZzTAzqVPtA.png" data-width="1024" data-height="768" data-action="zoom" data-action-value="1*spJ8v7GWivxZZzTAzqVPtA.png"><img src="https://cdn-images-1.medium.com/freeze/max/30/1*spJ8v7GWivxZZzTAzqVPtA.png?q=20" crossorigin="anonymous" class="progressiveMedia-thumbnail js-progressiveMedia-thumbnail">
                                                    <canvas class="progressiveMedia-canvas js-progressiveMedia-canvas"></canvas><img class="progressiveMedia-image js-progressiveMedia-image" data-src="https://cdn-images-1.medium.com/max/800/1*spJ8v7GWivxZZzTAzqVPtA.png">
                                                    <noscript class="js-progressiveMedia-inner"><img class="progressiveMedia-noscript js-progressiveMedia-inner" src="https://cdn-images-1.medium.com/max/800/1*spJ8v7GWivxZZzTAzqVPtA.png"></noscript>
                                                </div>
                                            </div>
                                        </figure>
                                        <p name="dcb6" id="dcb6" class="graf graf--p graf-after--figure">Hidden class transitions are dependent on the order in which properties are added to an object. Take a look at the code snippet below:</p><pre name="ff18" id="ff18" class="graf graf--pre graf-after--p">function Point(x, y) {<br>    this.x = x;<br>    this.y = y;<br>}</pre><pre name="4633" id="4633" class="graf graf--pre graf-after--pre">var p1 = new Point(1, 2);<br>p1.a = 5;<br>p1.b = 6;</pre><pre name="af52" id="af52" class="graf graf--pre graf-after--pre">var p2 = new Point(3, 4);<br>p2.b = 7;<br>p2.a = 8;</pre>
                                        <p name="e0a3" id="e0a3" class="graf graf--p graf-after--pre">Now, you would assume that for both p1 and p2 the same hidden classes and transitions would be used. Well, not really. For “p1”, first the property “a” will be added and then the property “b”. For “p2”, however, first “b” is being assigned, followed by “a”. Thus, “p1” and “p2” end up with different hidden classes as a result of the different transition paths. In such cases, it’s much better to initialize dynamic properties in the same order so that the hidden classes can be reused.</p>
                                        <h4 name="47e8" id="47e8" class="graf graf--h4 graf-after--p">Inline caching</h4>
                                        <p name="4d60" id="4d60" class="graf graf--p graf-after--h4">V8 takes advantage of another technique for optimizing dynamically typed languages called inline caching. Inline caching relies on the observation that repeated calls to the same method tend to occur on the same type of object. An in-depth explanation of inline caching can be found <a href="https://github.com/sq/JSIL/wiki/Optimizing-dynamic-JavaScript-with-inline-caches" data-href="https://github.com/sq/JSIL/wiki/Optimizing-dynamic-JavaScript-with-inline-caches" class="markup--anchor markup--p-anchor" rel="noopener" target="_blank">here</a>.</p>
                                        <p name="fcf5" id="fcf5" class="graf graf--p graf-after--p">We’re going to touch upon the general concept of inline caching (in case you don’t have the time to go through the in-depth explanation above).</p>
                                        <p name="bf69" id="bf69" class="graf graf--p graf-after--p">So how does it work? V8 maintains a cache of the type of objects that were passed as a parameter in recent method calls and uses this information to make an assumption about the type of object that will be passed as a parameter in the future. If V8 is able to make a good assumption about the type of object that will be passed to a method, it can bypass the process of figuring out how to access the object’s properties, and instead, use the stored information from previous lookups to the object’s hidden class.</p>
                                        <p name="d00c" id="d00c" class="graf graf--p graf-after--p">So how are the concepts of hidden classes and inline caching related? Whenever a method is called on a specific object, the V8 engine has to perform a lookup to the hidden class of that object in order to determine the offset for accessing a specific property. After two successful calls of the same method to the same hidden class, V8 omits the hidden class lookup and simply adds the offset of the property to the object pointer itself. For all future calls of that method, the V8 engine <em class="markup--em markup--p-em">assumes</em> that the hidden class hasn’t changed, and jumps directly into the memory address for a specific property using the offsets stored from previous lookups. This greatly increases execution speed.</p>
                                        <p name="67b0" id="67b0" class="graf graf--p graf-after--p">Inline caching is also the reason why it’s so important that objects of the same type share hidden classes. If you create two objects of the same type and with different hidden classes (as we did in the example earlier), V8 won’t be able to use inline caching because even though the two objects are of the same type, their corresponding hidden classes assign different offsets to their properties.</p>
                                        <figure name="2ec4" id="2ec4" class="graf graf--figure graf-after--p">
                                            <div class="aspectRatioPlaceholder is-locked" style="max-width: 700px; max-height: 525px;">
                                                <div class="aspectRatioPlaceholder-fill" style="padding-bottom: 75%;"></div>
                                                <div class="progressiveMedia js-progressiveMedia graf-image" data-image-id="1*iHfI6MQ-YKQvWvo51J-P0w.png" data-width="1024" data-height="768" data-action="zoom" data-action-value="1*iHfI6MQ-YKQvWvo51J-P0w.png"><img src="https://cdn-images-1.medium.com/freeze/max/30/1*iHfI6MQ-YKQvWvo51J-P0w.png?q=20" crossorigin="anonymous" class="progressiveMedia-thumbnail js-progressiveMedia-thumbnail">
                                                    <canvas class="progressiveMedia-canvas js-progressiveMedia-canvas"></canvas><img class="progressiveMedia-image js-progressiveMedia-image" data-src="https://cdn-images-1.medium.com/max/800/1*iHfI6MQ-YKQvWvo51J-P0w.png">
                                                    <noscript class="js-progressiveMedia-inner"><img class="progressiveMedia-noscript js-progressiveMedia-inner" src="https://cdn-images-1.medium.com/max/800/1*iHfI6MQ-YKQvWvo51J-P0w.png"></noscript>
                                                </div>
                                            </div>
                                            <figcaption class="imageCaption">The two objects are basically the same but the “a” and “b” properties were created in different order.</figcaption>
                                        </figure>
                                        <h4 name="26ba" id="26ba" class="graf graf--h4 graf-after--figure">Compilation to machine code</h4>
                                        <p name="eed5" id="eed5" class="graf graf--p graf-after--h4">Once the Hydrogen graph is optimized, Crankshaft lowers it to a lower-level representation called Lithium. Most of the Lithium implementation is architecture-specific. Register allocation happens at this level.</p>
                                        <p name="6461" id="6461" class="graf graf--p graf-after--p">In the end, Lithium is compiled into machine code. Then something else happens called OSR: on-stack replacement. Before we started compiling and optimizing an obviously long-running method, we were likely running it. V8 is not going to forget what it just slowly executed to start again with the optimized version. Instead, it will transform all the context we have (stack, registers) so that we can switch to the optimized version in the middle of the execution. This is a very complex task, having in mind that among other optimizations, V8 has inlined the code initially. V8 is not the only engine capable of doing it.</p>
                                        <p name="4335" id="4335" class="graf graf--p graf-after--p">There are safeguards called deoptimization to make the opposite transformation and revert back to the non-optimized code in case an assumption the engine made doesn’t hold true anymore.</p>
                                        <h4 name="83e8" id="83e8" class="graf graf--h4 graf-after--p">Garbage collection</h4>
                                        <p name="487c" id="487c" class="graf graf--p graf-after--h4">For garbage collection, V8 uses a traditional generational approach of mark-and-sweep to clean the old generation. The marking phase is supposed to stop the JavaScript execution. In order to control GC costs and make the execution more stable, V8 uses incremental marking: instead of walking the whole heap, trying to mark every possible object, it only walk part of the heap, then resumes normal execution. The next GC stop will continue from where the previous heap walk has stopped. This allows for very short pauses during the normal execution. As mentioned before, the sweep phase is handled by separate threads.</p>
                                        <h4 name="9d11" id="9d11" class="graf graf--h4 graf-after--p">Ignition and TurboFan</h4>
                                        <p name="d204" id="d204" class="graf graf--p graf-after--h4">With the release of V8 5.9 earlier in 2017, a new execution pipeline was introduced. This new pipeline achieves even bigger performance improvements and significant memory savings <strong class="markup--strong markup--p-strong">in real-world</strong> JavaScript applications.</p>
                                        <p name="047e" id="047e" class="graf graf--p graf-after--p">The new execution pipeline is built <a href="https://github.com/v8/v8/wiki/Interpreter" data-href="https://github.com/v8/v8/wiki/Interpreter" class="markup--anchor markup--p-anchor" rel="noopener" target="_blank">on top of Ignition</a>, V8’s interpreter, and <a href="https://github.com/v8/v8/wiki/TurboFan" data-href="https://github.com/v8/v8/wiki/TurboFan" class="markup--anchor markup--p-anchor" rel="noopener" target="_blank">TurboFan</a>, V8’s newest optimizing compiler.</p>
                                        <p name="d6ae" id="d6ae" class="graf graf--p graf-after--p">You can check out the blog post from the V8 team about the topic <a href="https://v8project.blogspot.bg/2017/05/launching-ignition-and-turbofan.html" data-href="https://v8project.blogspot.bg/2017/05/launching-ignition-and-turbofan.html" class="markup--anchor markup--p-anchor" rel="noopener" target="_blank">here</a>.</p>
                                        <p name="45b0" id="45b0" class="graf graf--p graf-after--p">Since version 5.9 of V8 came out, full-codegen and Crankshaft (the technologies that have served V8 since 2010) have no longer been used by V8 for JavaScript execution as the V8 team has struggled to keep pace with the new JavaScript language features and the optimizations needed for these features.</p>
                                        <p name="aabb" id="aabb" class="graf graf--p graf-after--p">This means that overall V8 will have much simpler and more maintainable architecture going forward.</p>
                                        <figure name="b240" id="b240" class="graf graf--figure graf-after--p">
                                            <div class="aspectRatioPlaceholder is-locked" style="max-width: 640px; max-height: 395px;">
                                                <div class="aspectRatioPlaceholder-fill" style="padding-bottom: 61.7%;"></div>
                                                <div class="progressiveMedia js-progressiveMedia graf-image" data-image-id="0*pohqKvj9psTPRlOv.png" data-width="640" data-height="395"><img src="https://cdn-images-1.medium.com/freeze/max/30/0*pohqKvj9psTPRlOv.png?q=20" crossorigin="anonymous" class="progressiveMedia-thumbnail js-progressiveMedia-thumbnail">
                                                    <canvas class="progressiveMedia-canvas js-progressiveMedia-canvas"></canvas><img class="progressiveMedia-image js-progressiveMedia-image" data-src="https://cdn-images-1.medium.com/max/800/0*pohqKvj9psTPRlOv.png">
                                                    <noscript class="js-progressiveMedia-inner"><img class="progressiveMedia-noscript js-progressiveMedia-inner" src="https://cdn-images-1.medium.com/max/800/0*pohqKvj9psTPRlOv.png"></noscript>
                                                </div>
                                            </div>
                                            <figcaption class="imageCaption">Improvements on Web and Node.js benchmarks</figcaption>
                                        </figure>
                                        <p name="df50" id="df50" class="graf graf--p graf-after--figure">These improvements are just the start. The new Ignition and TurboFan pipeline pave the way for further optimizations that will boost JavaScript performance and shrink V8’s footprint in both Chrome and Node.js in the coming years.</p>
                                        <p name="ea4c" id="ea4c" class="graf graf--p graf-after--p">Finally, here are some tips and tricks on how to write well-optimized, better JavaScript. You can easily derive these from the content above, however, here’s a summary for your convenience:</p>
                                        <h4 name="fd2b" id="fd2b" class="graf graf--h4 graf-after--p">How to write optimized JavaScript</h4>
                                        <ol class="postList">
                                            <li name="89c2" id="89c2" class="graf graf--li graf-after--h4"><strong class="markup--strong markup--li-strong">Order of object properties</strong>: always instantiate your object properties in the same order so that hidden classes, and subsequently optimized code, can be shared.</li>
                                            <li name="8e17" id="8e17" class="graf graf--li graf-after--li"><strong class="markup--strong markup--li-strong">Dynamic properties</strong>: adding properties to an object after instantiation will force a hidden class change and slow down any methods that were optimized for the previous hidden class. Instead, assign all of an object’s properties in its constructor.</li>
                                            <li name="4684" id="4684" class="graf graf--li graf-after--li"><strong class="markup--strong markup--li-strong">Methods</strong>: code that executes the same method repeatedly will run faster than code that executes many different methods only once (due to inline caching).</li>
                                            <li name="356b" id="356b" class="graf graf--li graf-after--li"><strong class="markup--strong markup--li-strong">Arrays: </strong>avoid sparse arrays where keys are not incremental numbers. Sparse arrays which don’t have every element inside them are a <strong class="markup--strong markup--li-strong">hash table</strong>. Elements in such arrays are more expensive to access. Also, try to avoid pre-allocating large arrays. It’s better to grow as you go. Finally, don’t delete elements in arrays. It makes the keys sparse.</li>
                                            <li name="c944" id="c944" class="graf graf--li graf-after--li"><strong class="markup--strong markup--li-strong">Tagged values</strong>: V8 represents objects and numbers with 32 bits. It uses a bit to know if it is an object (flag = 1) or an integer (flag = 0) called SMI (SMall Integer) because of its 31 bits. Then, if a numeric value is bigger than 31 bits, V8 will box the number, turning it into a double and creating a new object to put the number inside. Try to use 31 bit signed numbers whenever possible to avoid the expensive boxing operation into a JS object.</li>
                                        </ol>
                                        <p name="4756" id="4756" class="graf graf--p graf-after--li">We at SessionStack try to follow these best practices in writing highly optimized JavaScript code. The reason is that once you integrate SessionStack into your production web app, it starts recording everything: all DOM changes, user interactions, JavaScript exceptions, stack traces, failed network requests, and debug messages.
                                            <br>With SessionStack, you can replay issues in your web apps as videos and see everything that happened to your user. And all of this has to happen with no performance impact for your web app.
                                            <br>There is a free plan that allows you to <a href="https://www.sessionstack.com/signup/" data-href="https://www.sessionstack.com/signup/" class="markup--anchor markup--p-anchor" rel="noopener" target="_blank">get started for free</a>.</p>
                                        <figure name="e37b" id="e37b" class="graf graf--figure graf-after--p">
                                            <div class="aspectRatioPlaceholder"><img class="graf-image" data-image-id="1*kEQmoMuNBDfZKNSBh0tvRA.png" src="https://cdn-images-1.medium.com/max/800/1*kEQmoMuNBDfZKNSBh0tvRA.png"></div>
                                        </figure>
                                        <h4 name="9cdf" id="9cdf" class="graf graf--h4 graf-after--figure">Resources</h4>
                                        <ul class="postList">
                                            <li name="1625" id="1625" class="graf graf--li graf-after--h4"><a href="https://docs.google.com/document/u/1/d/1hOaE7vbwdLLXWj3C8hTnnkpE0qSa2P--dtDvwXXEeD0/pub" data-href="https://docs.google.com/document/u/1/d/1hOaE7vbwdLLXWj3C8hTnnkpE0qSa2P--dtDvwXXEeD0/pub" class="markup--anchor markup--li-anchor" rel="nofollow noopener" target="_blank">https://docs.google.com/document/u/1/d/1hOaE7vbwdLLXWj3C8hTnnkpE0qSa2P--dtDvwXXEeD0/pub</a></li>
                                            <li name="76b2" id="76b2" class="graf graf--li graf-after--li"><a href="https://github.com/thlorenz/v8-perf" data-href="https://github.com/thlorenz/v8-perf" class="markup--anchor markup--li-anchor" rel="nofollow noopener" target="_blank">https://github.com/thlorenz/v8-perf</a></li>
                                            <li name="b6aa" id="b6aa" class="graf graf--li graf-after--li"><a href="http://code.google.com/p/v8/wiki/UsingGit" data-href="http://code.google.com/p/v8/wiki/UsingGit" class="markup--anchor markup--li-anchor" rel="nofollow noopener" target="_blank">http://code.google.com/p/v8/wiki/UsingGit</a></li>
                                            <li name="0300" id="0300" class="graf graf--li graf-after--li"><a href="http://mrale.ph/v8/resources.html" data-href="http://mrale.ph/v8/resources.html" class="markup--anchor markup--li-anchor" rel="nofollow noopener" target="_blank">http://mrale.ph/v8/resources.html</a></li>
                                            <li name="e386" id="e386" class="graf graf--li graf-after--li"><a href="https://www.youtube.com/watch?v=UJPdhx5zTaw" data-href="https://www.youtube.com/watch?v=UJPdhx5zTaw" class="markup--anchor markup--li-anchor" rel="nofollow noopener" target="_blank">https://www.youtube.com/watch?v=UJPdhx5zTaw</a></li>
                                            <li name="bf00" id="bf00" class="graf graf--li graf-after--li graf--trailing"><a href="https://www.youtube.com/watch?v=hWhMKalEicY" data-href="https://www.youtube.com/watch?v=hWhMKalEicY" class="markup--anchor markup--li-anchor" rel="nofollow noopener" target="_blank">https://www.youtube.com/watch?v=hWhMKalEicY</a></li>
                                        </ul>
                                    </div>
                                </div>
                            </section>
                        </div>
