<div class="postArticle-content js-postField js-notesSource js-trackedPost" data-post-id="b0bacc073cf" data-source="post_page" data-collection-id="12d1b859d4e4" data-tracking-context="postPage">
                            <section name="3b2a" class="section section--body section--first section--last">
                                <div class="section-divider">
                                    <hr class="section-divider">
                                </div>
                                <div class="section-content">
                                    <div class="section-inner sectionLayout--insetColumn">
                                        <h1 name="fb60" id="fb60" class="graf graf--h3 graf--leading graf--title">an overview of the engine, the runtime, and the call stack</h1>
                                        <p name="a1cc" id="a1cc" class="graf graf--p graf-after--h3">As JavaScript is getting more and more popular, teams are leveraging its support on many levels in their stack - front-end, back-end, hybrid apps, embedded devices and much more.</p>
                                        <p name="463f" id="463f" class="graf graf--p graf-after--p">This post is meant to be the first in a series aimed at digging deeper into JavaScript and how it actually works: we thought that by knowing the building blocks of JavaScript and how they come to play together you’ll be able to write better code and apps.</p>
                                        <p name="b490" id="b490" class="graf graf--p graf-after--p">As shown in the <a href="http://githut.info/" data-href="http://githut.info/" class="markup--anchor markup--p-anchor" rel="noopener" target="_blank">GitHut stats</a>, JavaScript is at the top in terms of Active Repositories and Total Pushes in GitHub. It doesn’t lag behind much in the other categories either.</p>
                                        <figure name="f0c4" id="f0c4" class="graf graf--figure graf-after--p">
                                            <div class="aspectRatioPlaceholder is-locked" style="max-width: 700px; max-height: 356px;">
                                                <div class="aspectRatioPlaceholder-fill" style="padding-bottom: 50.8%;"></div>
                                                <div class="progressiveMedia js-progressiveMedia graf-image" data-image-id="1*Zf4reZZJ9DCKsXf5CSXghg.png" data-width="1518" data-height="771" data-action="zoom" data-action-value="1*Zf4reZZJ9DCKsXf5CSXghg.png"><img src="https://cdn-images-1.medium.com/freeze/max/30/1*Zf4reZZJ9DCKsXf5CSXghg.png?q=20" crossorigin="anonymous" class="progressiveMedia-thumbnail js-progressiveMedia-thumbnail">
                                                    <canvas class="progressiveMedia-canvas js-progressiveMedia-canvas"></canvas><img class="progressiveMedia-image js-progressiveMedia-image" data-src="https://cdn-images-1.medium.com/max/800/1*Zf4reZZJ9DCKsXf5CSXghg.png">
                                                    <noscript class="js-progressiveMedia-inner"><img class="progressiveMedia-noscript js-progressiveMedia-inner" src="https://cdn-images-1.medium.com/max/800/1*Zf4reZZJ9DCKsXf5CSXghg.png"></noscript>
                                                </div>
                                            </div>
                                        </figure>
                                        <p name="c69d" id="c69d" class="graf graf--p graf-after--figure">(<a href="https://madnight.github.io/githut/" data-href="https://madnight.github.io/githut/" class="markup--anchor markup--p-anchor" rel="noopener" target="_blank">Check out up-to-date GitHub language stats</a>).</p>
                                        <p name="0b7e" id="0b7e" class="graf graf--p graf-after--p">If projects are getting so much dependent on JavaScript, this means that developers have to be utilizing everything that the language and the ecosystem provide with deeper and deeper understanding of the internals, in order to build amazing software.</p>
                                        <p name="b392" id="b392" class="graf graf--p graf-after--p">As it turns out, there are a lot of developers that are using JavaScript on a daily basis but don’t have the knowledge of what happens under the hood.</p>
                                        <h3 name="da08" id="da08" class="graf graf--h3 graf-after--p">Overview</h3>
                                        <p name="680c" id="680c" class="graf graf--p graf-after--h3">Almost everyone has already heard of the V8 Engine as a concept, and most people know that JavaScript is single-threaded or that it is using a callback queue.</p>
                                        <p name="e23e" id="e23e" class="graf graf--p graf-after--p">In this post, we’ll go through all these concepts in detail and explain how JavaScript actually runs. By knowing these details, you’ll be able to write better, non-blocking apps that are properly leveraging the provided APIs.</p>
                                        <p name="8eea" id="8eea" class="graf graf--p graf-after--p">If you’re relatively new to JavaScript, this blog post will help you understand why JavaScript is so “weird” compared to other languages.</p>
                                        <p name="65da" id="65da" class="graf graf--p graf-after--p">And if you’re an experienced JavaScript developer, hopefully, it will give you some fresh insights on how the JavaScript Runtime you’re using every day actually works.</p>
                                        <h3 name="0129" id="0129" class="graf graf--h3 graf-after--p"><strong class="markup--strong markup--h3-strong">The JavaScript Engine</strong></h3>
                                        <p name="8900" id="8900" class="graf graf--p graf-after--h3">A popular example of a JavaScript Engine is Google’s V8 engine. The V8 engine is used inside Chrome and Node.js for example. Here is a very simplified view of what it looks like:</p>
                                        <figure name="e71d" id="e71d" class="graf graf--figure graf-after--p">
                                            <div class="aspectRatioPlaceholder is-locked" style="max-width: 700px; max-height: 525px;">
                                                <div class="aspectRatioPlaceholder-fill" style="padding-bottom: 75%;"></div>
                                                <div class="progressiveMedia js-progressiveMedia graf-image" data-image-id="1*OnH_DlbNAPvB9KLxUCyMsA.png" data-width="1024" data-height="768" data-action="zoom" data-action-value="1*OnH_DlbNAPvB9KLxUCyMsA.png"><img src="https://cdn-images-1.medium.com/freeze/max/30/1*OnH_DlbNAPvB9KLxUCyMsA.png?q=20" crossorigin="anonymous" class="progressiveMedia-thumbnail js-progressiveMedia-thumbnail">
                                                    <canvas class="progressiveMedia-canvas js-progressiveMedia-canvas"></canvas><img class="progressiveMedia-image js-progressiveMedia-image" data-src="https://cdn-images-1.medium.com/max/800/1*OnH_DlbNAPvB9KLxUCyMsA.png">
                                                    <noscript class="js-progressiveMedia-inner"><img class="progressiveMedia-noscript js-progressiveMedia-inner" src="https://cdn-images-1.medium.com/max/800/1*OnH_DlbNAPvB9KLxUCyMsA.png"></noscript>
                                                </div>
                                            </div>
                                        </figure>
                                        <p name="1616" id="1616" class="graf graf--p graf-after--figure">The Engine consists of two main components:
                                            <br>* Memory Heap — this is where the memory allocation happens
                                            <br>* Call Stack — this is where your stack frames are as your code executes</p>
                                        <h3 name="6bfc" id="6bfc" class="graf graf--h3 graf-after--p"><strong class="markup--strong markup--h3-strong">The Runtime</strong></h3>
                                        <p name="8f32" id="8f32" class="graf graf--p graf-after--h3">There are APIs in the browser that have been used by almost any JavaScript developer out there (e.g. “setTimeout”). Those APIs, however, are not provided by the Engine.</p>
                                        <p name="f504" id="f504" class="graf graf--p graf-after--p">So, where are they coming from?</p>
                                        <p name="11b5" id="11b5" class="graf graf--p graf-after--p">It turns out that the reality is a bit more complicated.</p>
                                        <figure name="5481" id="5481" class="graf graf--figure graf-after--p">
                                            <div class="aspectRatioPlaceholder is-locked" style="max-width: 700px; max-height: 525px;">
                                                <div class="aspectRatioPlaceholder-fill" style="padding-bottom: 75%;"></div>
                                                <div class="progressiveMedia js-progressiveMedia graf-image" data-image-id="1*4lHHyfEhVB0LnQ3HlhSs8g.png" data-width="1024" data-height="768" data-is-featured="true" data-action="zoom" data-action-value="1*4lHHyfEhVB0LnQ3HlhSs8g.png"><img src="https://cdn-images-1.medium.com/freeze/max/30/1*4lHHyfEhVB0LnQ3HlhSs8g.png?q=20" crossorigin="anonymous" class="progressiveMedia-thumbnail js-progressiveMedia-thumbnail">
                                                    <canvas class="progressiveMedia-canvas js-progressiveMedia-canvas"></canvas><img class="progressiveMedia-image js-progressiveMedia-image" data-src="https://cdn-images-1.medium.com/max/800/1*4lHHyfEhVB0LnQ3HlhSs8g.png">
                                                    <noscript class="js-progressiveMedia-inner"><img class="progressiveMedia-noscript js-progressiveMedia-inner" src="https://cdn-images-1.medium.com/max/800/1*4lHHyfEhVB0LnQ3HlhSs8g.png"></noscript>
                                                </div>
                                            </div>
                                        </figure>
                                        <p name="46cf" id="46cf" class="graf graf--p graf-after--figure">So, we have the Engine but there is actually a lot more. We have those things called Web APIs which are provided by browsers, like the DOM, AJAX, setTimeout and much more.</p>
                                        <p name="dae7" id="dae7" class="graf graf--p graf-after--p">And then, we have the so popular <strong class="markup--strong markup--p-strong">event loop</strong> and the <strong class="markup--strong markup--p-strong">callback queue</strong>.</p>
                                        <h3 name="6e11" id="6e11" class="graf graf--h3 graf-after--p">The Call Stack</h3>
                                        <p name="ebb8" id="ebb8" class="graf graf--p graf-after--h3">JavaScript is a single-threaded programming language, which means it has a single Call Stack. Therefore it can do one thing at a time.</p>
                                        <p name="7b07" id="7b07" class="graf graf--p graf-after--p">The Call Stack is a data structure which records basically where in the program we are. If we step into a function, we put it on the top of the stack. If we return from a function, we pop off the top of the stack. That’s all the stack can do.</p>
                                        <p name="b8b8" id="b8b8" class="graf graf--p graf-after--p">Let’s see an example. Take a look at the following code:</p><pre name="ca2b" id="ca2b" class="graf graf--pre graf-after--p">function multiply(x, y) {<br>    return x * y;<br>}</pre><pre name="3648" id="3648" class="graf graf--pre graf-after--pre">function printSquare(x) {<br>    var s = multiply(x, x);<br>    console.log(s);<br>}</pre><pre name="c017" id="c017" class="graf graf--pre graf-after--pre">printSquare(5);</pre>
                                        <p name="566a" id="566a" class="graf graf--p graf-after--pre">When the engine starts executing this code, the Call Stack will be empty. Afterwards, the steps will be the following:</p>
                                        <figure name="f2da" id="f2da" class="graf graf--figure graf-after--p">
                                            <div class="aspectRatioPlaceholder is-locked" style="max-width: 700px; max-height: 525px;">
                                                <div class="aspectRatioPlaceholder-fill" style="padding-bottom: 75%;"></div>
                                                <div class="progressiveMedia js-progressiveMedia graf-image" data-image-id="1*Yp1KOt_UJ47HChmS9y7KXw.png" data-width="1024" data-height="768" data-action="zoom" data-action-value="1*Yp1KOt_UJ47HChmS9y7KXw.png"><img src="https://cdn-images-1.medium.com/freeze/max/30/1*Yp1KOt_UJ47HChmS9y7KXw.png?q=20" crossorigin="anonymous" class="progressiveMedia-thumbnail js-progressiveMedia-thumbnail">
                                                    <canvas class="progressiveMedia-canvas js-progressiveMedia-canvas"></canvas><img class="progressiveMedia-image js-progressiveMedia-image" data-src="https://cdn-images-1.medium.com/max/800/1*Yp1KOt_UJ47HChmS9y7KXw.png">
                                                    <noscript class="js-progressiveMedia-inner"><img class="progressiveMedia-noscript js-progressiveMedia-inner" src="https://cdn-images-1.medium.com/max/800/1*Yp1KOt_UJ47HChmS9y7KXw.png"></noscript>
                                                </div>
                                            </div>
                                        </figure>
                                        <p name="8217" id="8217" class="graf graf--p graf-after--figure">Each entry in the Call Stack is called a <strong class="markup--strong markup--p-strong">Stack Frame</strong>.</p>
                                        <p name="3d6d" id="3d6d" class="graf graf--p graf-after--p">And this is exactly how stack traces are being constructed when an exception is being thrown — it is basically the state of the Call Stack when the exception happened. Take a look at the following code:</p><pre name="b93c" id="b93c" class="graf graf--pre graf-after--p">function foo() {<br>    throw new Error(&#39;SessionStack will help you resolve crashes :)&#39;);<br>}</pre><pre name="6272" id="6272" class="graf graf--pre graf-after--pre">function bar() {<br>    foo();<br>}</pre><pre name="a1a7" id="a1a7" class="graf graf--pre graf-after--pre">function start() {<br>    bar();<br>}</pre><pre name="f386" id="f386" class="graf graf--pre graf-after--pre">start();</pre>
                                        <p name="443c" id="443c" class="graf graf--p graf-after--pre">If this is executed in Chrome (assuming that this code is in a file called foo.js), the following stack trace will be produced:</p>
                                        <figure name="940d" id="940d" class="graf graf--figure graf-after--p">
                                            <div class="aspectRatioPlaceholder is-locked" style="max-width: 507px; max-height: 73px;">
                                                <div class="aspectRatioPlaceholder-fill" style="padding-bottom: 14.399999999999999%;"></div><img class="graf-image" data-image-id="1*T-W_ihvl-9rG4dn18kP3Qw.png" data-width="507" data-height="73" src="https://cdn-images-1.medium.com/max/800/1*T-W_ihvl-9rG4dn18kP3Qw.png"></div>
                                        </figure>
                                        <p name="40cf" id="40cf" class="graf graf--p graf--startsWithDoubleQuote graf-after--figure">“<strong class="markup--strong markup--p-strong">Blowing the stack</strong>” — this happens when you reach the maximum Call Stack size. And that could happen quite easily, especially if you’re using recursion without testing your code very extensively. Take a look at this sample code:</p><pre name="70fd" id="70fd" class="graf graf--pre graf-after--p">function foo() {<br>    foo();<br>}</pre><pre name="8b4f" id="8b4f" class="graf graf--pre graf-after--pre">foo();</pre>
                                        <p name="0a6b" id="0a6b" class="graf graf--p graf-after--pre">When the engine starts executing this code, it starts with calling the function “foo”. This function, however, is recursive and starts calling itself without any termination conditions. So at every step of the execution, the same function gets added to the Call Stack over and over again. It looks something like this:</p>
                                        <figure name="0063" id="0063" class="graf graf--figure graf-after--p">
                                            <div class="aspectRatioPlaceholder is-locked" style="max-width: 700px; max-height: 525px;">
                                                <div class="aspectRatioPlaceholder-fill" style="padding-bottom: 75%;"></div>
                                                <div class="progressiveMedia js-progressiveMedia graf-image" data-image-id="1*AycFMDy9tlDmNoc5LXd9-g.png" data-width="1024" data-height="768" data-action="zoom" data-action-value="1*AycFMDy9tlDmNoc5LXd9-g.png"><img src="https://cdn-images-1.medium.com/freeze/max/30/1*AycFMDy9tlDmNoc5LXd9-g.png?q=20" crossorigin="anonymous" class="progressiveMedia-thumbnail js-progressiveMedia-thumbnail">
                                                    <canvas class="progressiveMedia-canvas js-progressiveMedia-canvas"></canvas><img class="progressiveMedia-image js-progressiveMedia-image" data-src="https://cdn-images-1.medium.com/max/800/1*AycFMDy9tlDmNoc5LXd9-g.png">
                                                    <noscript class="js-progressiveMedia-inner"><img class="progressiveMedia-noscript js-progressiveMedia-inner" src="https://cdn-images-1.medium.com/max/800/1*AycFMDy9tlDmNoc5LXd9-g.png"></noscript>
                                                </div>
                                            </div>
                                        </figure>
                                        <p name="5334" id="5334" class="graf graf--p graf-after--figure">At some point, however, the number of function calls in the Call Stack exceeds the actual size of the Call Stack, and the browser decides to take action, by throwing an error, which can look something like this:</p>
                                        <figure name="e742" id="e742" class="graf graf--figure graf-after--p">
                                            <div class="aspectRatioPlaceholder is-locked" style="max-width: 386px; max-height: 21px;">
                                                <div class="aspectRatioPlaceholder-fill" style="padding-bottom: 5.4%;"></div><img class="graf-image" data-image-id="1*e0nEd59RPKz9coyY8FX-uw.png" data-width="386" data-height="21" src="https://cdn-images-1.medium.com/max/800/1*e0nEd59RPKz9coyY8FX-uw.png"></div>
                                        </figure>
                                        <p name="3345" id="3345" class="graf graf--p graf-after--figure">Running code on a single thread can be quite easy since you don’t have to deal with complicated scenarios that are arising in multi-threaded environments — for example, deadlocks.</p>
                                        <p name="619b" id="619b" class="graf graf--p graf-after--p">But running on a single thread is quite limiting as well. Since JavaScript has a single Call Stack, <strong class="markup--strong markup--p-strong">what happens when things are slow?</strong></p>
                                        <h3 name="1796" id="1796" class="graf graf--h3 graf-after--p"><strong class="markup--strong markup--h3-strong">Concurrency &amp; the Event Loop</strong></h3>
                                        <p name="50e0" id="50e0" class="graf graf--p graf-after--h3">What happens when you have function calls in the Call Stack that take a huge amount of time in order to be processed? For example, imagine that you want to do some complex image transformation with JavaScript in the browser.</p>
                                        <p name="78e3" id="78e3" class="graf graf--p graf-after--p">You may ask — why is this even a problem? The problem is that while the Call Stack has functions to execute, the browser can’t actually do anything else — it’s getting blocked. This means that the browser can’t render, it can’t run any other code, it’s just stuck. And this creates problems if you want nice fluid UIs in your app.</p>
                                        <p name="f9ad" id="f9ad" class="graf graf--p graf-after--p">And that’s not the only problem. Once your browser starts processing so many tasks in the Call Stack, it may stop being responsive for quite a long time. And most browsers take action by raising an error, asking you whether you want to terminate the web page.</p>
                                        <figure name="08a2" id="08a2" class="graf graf--figure graf-after--p">
                                            <div class="aspectRatioPlaceholder is-locked" style="max-width: 462px; max-height: 288px;">
                                                <div class="aspectRatioPlaceholder-fill" style="padding-bottom: 62.3%;"></div>
                                                <div class="progressiveMedia js-progressiveMedia graf-image" data-image-id="1*WlMXK3rs_scqKTRV41au7g.jpeg" data-width="462" data-height="288"><img src="https://cdn-images-1.medium.com/freeze/max/30/1*WlMXK3rs_scqKTRV41au7g.jpeg?q=20" crossorigin="anonymous" class="progressiveMedia-thumbnail js-progressiveMedia-thumbnail">
                                                    <canvas class="progressiveMedia-canvas js-progressiveMedia-canvas"></canvas><img class="progressiveMedia-image js-progressiveMedia-image" data-src="https://cdn-images-1.medium.com/max/800/1*WlMXK3rs_scqKTRV41au7g.jpeg">
                                                    <noscript class="js-progressiveMedia-inner"><img class="progressiveMedia-noscript js-progressiveMedia-inner" src="https://cdn-images-1.medium.com/max/800/1*WlMXK3rs_scqKTRV41au7g.jpeg"></noscript>
                                                </div>
                                            </div>
                                        </figure>
                                        <p name="de3e" id="de3e" class="graf graf--p graf-after--figure">Now, that’s not the best user experience out there, is it?</p>
                                        <p name="4715" id="4715" class="graf graf--p graf-after--p">So, how can we execute heavy code without blocking the UI and making the browser unresponsive? Well, the solution is <strong class="markup--strong markup--p-strong">asynchronous callbacks</strong>.</p>
                                        <p name="24af" id="24af" class="graf graf--p graf-after--p">This will be explained in greater detail in <strong class="markup--strong markup--p-strong">Part 2</strong> of the “How JavaScript actually works” tutorial: “I<a href="https://blog.sessionstack.com/how-javascript-works-inside-the-v8-engine-5-tips-on-how-to-write-optimized-code-ac089e62b12e" data-href="https://blog.sessionstack.com/how-javascript-works-inside-the-v8-engine-5-tips-on-how-to-write-optimized-code-ac089e62b12e" class="markup--anchor markup--p-anchor" target="_blank">nside the V8 engine + 5 tips on how to write optimized code</a>”.</p>
                                        <p name="d415" id="d415" class="graf graf--p graf-after--p">In the meantime, if you’re having a hard time reproducing and understanding issues in your JavaScript apps, take a look at <a href="https://www.sessionstack.com" data-href="https://www.sessionstack.com" class="markup--anchor markup--p-anchor" rel="noopener" target="_blank">SessionStack</a>. SessionStack records everything in your web apps: all DOM changes, user interactions, JavaScript exceptions, stack traces, failed network requests, and debug messages.</p>
                                        <p name="0586" id="0586" class="graf graf--p graf-after--p">With SessionStack, you can replay issues in your web apps as videos and see everything that happened to your user.</p>
                                        <p name="f08d" id="f08d" class="graf graf--p graf-after--p">There is a free plan that allows you to <a href="https://www.sessionstack.com/signup/" data-href="https://www.sessionstack.com/signup/" class="markup--anchor markup--p-anchor" rel="noopener" target="_blank">get started for free</a>.</p>
                                        <figure name="11c8" id="11c8" class="graf graf--figure graf-after--p graf--trailing">
                                            <div class="aspectRatioPlaceholder is-locked" style="max-width: 700px; max-height: 389px;">
                                                <div class="aspectRatioPlaceholder-fill" style="padding-bottom: 55.60000000000001%;"></div>
                                                <div class="progressiveMedia js-progressiveMedia graf-image" data-image-id="1*kEQmoMuNBDfZKNSBh0tvRA.png" data-width="1031" data-height="573" data-action="zoom" data-action-value="1*kEQmoMuNBDfZKNSBh0tvRA.png"><img src="https://cdn-images-1.medium.com/freeze/max/30/1*kEQmoMuNBDfZKNSBh0tvRA.png?q=20" crossorigin="anonymous" class="progressiveMedia-thumbnail js-progressiveMedia-thumbnail">
                                                    <canvas class="progressiveMedia-canvas js-progressiveMedia-canvas"></canvas><img class="progressiveMedia-image js-progressiveMedia-image" data-src="https://cdn-images-1.medium.com/max/800/1*kEQmoMuNBDfZKNSBh0tvRA.png">
                                                    <noscript class="js-progressiveMedia-inner"><img class="progressiveMedia-noscript js-progressiveMedia-inner" src="https://cdn-images-1.medium.com/max/800/1*kEQmoMuNBDfZKNSBh0tvRA.png"></noscript>
                                                </div>
                                            </div>
                                        </figure>
                                    </div>
                                </div>
                            </section>
                        </div>
