# Templates for Google Apps Script

Templates that provide an initial, working framework for Apps Script
projects.

## Introduction

Google Apps Script allows developers to extend and maniplate Google
Docs, Sheets and Forms. For those just starting with Apps Script, it
can be useful to have a template to work from -- a framework that
developers can learn from and modify to suit their needs.

This collection hosts the following templates:

* Custom Functions for Sheets
* Google Docs Add-on
* Google Sheets Add-on
* Google Forms Add-on
* Script as Web App

Within these templates the following Google Apps Script concepts are
illustrated:

* [Dialogs and Sidebars](https://developers.google.com/apps-script/guides/dialogs)
* Using [Templated HTML](https://developers.google.com/apps-script/guides/html/templates)
* Responding to HTTP GET requests with doGet(e)
* Using IFRAME sandbox mode

## Getting Started

Templates can be accessed from the Apps Script editor Welcome Screen
(which is shown when the editor is first opened or by clicking the
"Help > Welcome screen" menu item. Selecting a template from the
Welcome Screen will create a new project pre-populated with the code
you need to get started.

Alternatively, the code provided in this repository can be manually copied
into the Apps Script editor. Note that certain templates need to be used
in a container-bound script (that is, the template is meant to be in a
script attached to a Doc, Sheet or Form, rather than a standalone script).
