# Form Notifications Add-on for Google Forms

A sample Google Apps Script add-on for Google Forms.

## Introduction

Google Apps Script allows developers to construct 'add-ons' -- small
applications which extend and support Google Docs, Google Sheets,
and now Google Forms.

This sample shows how to construct a Google Forms add-on called
[Form Notifications](https://chrome.google.com/webstore/detail/form-notifications/bbpdeojefjfhaelgljjcadpcckdfcdod).
This add-on allows Form creators to automatically
send email notifications when a form is submitted. In addition, the
add-on allows form creators to be notified when they have received
responses.

This sample makes use of the following Apps Script concepts:

* Google Forms Add-ons
* Events and Triggers (specifically, onFormSubmit triggers)
* Templated HTML
* Dialogs and Sidebars
* Sending Email with Apps Script

## Getting Started

You can install the [Form Notifications](https://chrome.google.com/webstore/detail/form-notifications/bbpdeojefjfhaelgljjcadpcckdfcdod) add-on from the add-on
store.

If you would like to try re-building it yourself, you can follow the
directions provided in the [Add-on for Google Forms Quickstart](https://developers.google.com/apps-script/quickstart/forms-add-on) documentation.

## Learn more

To continue learning about how to extend Google Docs, Sheets and Forms
with Apps Script, take a look at the following resources:

* [Guide to Add-ons](https://developers.google.com/apps-script/add-ons/)
* [Forms Service Reference](https://developers.google.com/apps-script/reference/forms)

## Support

- Stack Overflow Tag: [google-apps-script](http://stackoverflow.com/questions/tagged/google-apps-script)
