# Google Apps Script Samples

Various sample code and projects for the Google Apps Script platform, a JavaScript platform in the cloud.

Learn more at [developers.google.com](https://developers.google.com/apps-script).

## Google APIs

<img
src="https://www.gstatic.com/images/branding/product/2x/admin_96dp.png"
align="left"
width="96px"/>
### AdminSDK
- [Manage domains and apps](adminSDK)
<br><br>

<img
src="https://www.gstatic.com/images/branding/product/2x/google_cloud_96dp.png"
align="left"
width="96px"/>
### Advanced Services
- [Access Google APIs via Advanced Google services](advanced/)
<br><br>

<img
src="https://www.gstatic.com/images/branding/product/2x/calendar_96dp.png"
align="left"
width="96px"/>
### Calendar
- [List upcoming events](calendar/quickstart)
- [Create a vacation calendar](solutions/automations/vacation-calendar/Code.js)

<img
src="https://www.gstatic.com/images/branding/product/2x/classroom_96dp.png"
align="left"
width="96px"/>
### Classroom
- [Manage Google Classroom](classroom/quickstart)
<br><br>

<img
src="https://www.gstatic.com/images/branding/product/2x/data_studio_96dp.png"
align="left"
width="96px"/>
### Data Studio
- [Build a connector](data-studio/build.gs)
- [Authentication and Authorization](data-studio/auth.gs)

<img
src="https://www.gstatic.com/images/branding/product/2x/docs_96dp.png"
align="left"
width="96px"/>
### Docs
- [Cursor inspector add-on](docs/cursorInspector)
- [Translate add-on](docs/translate)

<img
src="https://www.gstatic.com/images/branding/product/2x/drive_96dp.png"
align="left"
width="96px"/>
### Drive
- [Manage Google Drive files and folders](drive/quickstart)
- [View Google Drive activity](drive/activity)

<img
src="https://www.gstatic.com/images/branding/product/2x/forms_96dp.png"
align="left"
width="96px"/>
### Forms
- [Notification add-on](forms)
<br><br>

<img
src="https://www.gstatic.com/images/branding/product/2x/gmail_96dp.png"
align="left"
width="96px"/>
### Gmail
- [Sending email](gmail/sendingEmails)
- [Mailmerge: Merge a template email with content](gmail/mailmerge)

<img
src="https://www.gstatic.com/images/icons/material/system/2x/people_black_48dp.png"
align="left"
width="96px"/>
### People
- [Listing Connections](people/quickstart)
<br><br>

<img
src="https://www.gstatic.com/images/branding/product/2x/sheets_96dp.png"
align="left"
width="96px"/>
### Sheets
- [Managing Responses for Google Forms](sheets)
- [Menus and Custom Functions](sheets)

<img
src="https://www.gstatic.com/images/branding/product/2x/slides_96dp.png"
align="left"
width="96px"/>
### Slides
- [Translate Slides Add-on](slides/translate)
- [Progress Bars add-on](slides/progress)

<img
src="https://www.gstatic.com/images/branding/product/2x/tasks_96dp.png"
align="left"
width="96px"/>
### Tasks
- [List Tasks](tasks/quickstart)
- [Simple Tasks Web App](tasks/simpleTasks)

<img
src="https://www.gstatic.com/images/icons/material/system/2x/code_grey600_48dp.png"
align="left"
width="96px"/>
### Templates
- Build off a working framework for new Apps Script projects.
<br><br>

<img
src="https://www.gstatic.com/images/icons/material/system/2x/alarm_grey600_48dp.png"
align="left"
width="96px"/>
### Triggers
- Call an Apps Script function such as `onOpen`, `onEdit`, or `onInstall` in an add-on
- Create a [time-driven trigger](https://developers.google.com/apps-script/guides/triggers/installable#time_driven_triggers)

## Codelabs

Codelab tutorials combine detailed explanation, coding exercises, and documented best practices to help engineers get up to speed with key Google technologies. Here's a list of Apps Script codelabs:

- [Apps Script Intro](http://g.co/codelabs/apps-script-intro)
- [Apps Script CLI – clasp](http://g.co/codelabs/clasp)
- [BigQuery + Sheets + Slides](http://g.co/codelabs/bigquery-sheets-slides)
- [Docs Add-on + Cloud Natural Language API](http://g.co/codelabs/nlp-docs)
- [Gmail Add-ons](http://g.co/codelabs/gmail-add-ons)
- [Google Chat Apps](https://developers.google.com/codelabs/chat-apps-script)

## Clone using the `clasp` command-line tool

Learn how to clone, pull, and push Apps Script projects on the command-line
using [clasp](https://developers.google.com/apps-script/guides/clasp).

## Lint

Run ESLint over this whole repository with:

```shell
npm run lint
```

This command will fix simple errors.
