[Home](README.md)

# How to Use OboeTester

## Loopback Adapter Needed for Some Tests

Some of these tests require an [audio Loopback Adapter](https://source.android.com/devices/audio/latency/loopback) that plugs into a 3.5 mm jack.
If the phone does not have a 3.5 mm jack then you can combine that with a USB to 3.5mm adapter.

Loopback adapters can be purchased from [PassMark Software](https://www.passmark.com/products/audio-loopback-plug/). 

## Test Activities

Launch OboeTester and then select one of the test Activities.

### Test Output

Tap the green bar to expand the Settings display.

Test opening, starting, stopping and closing a stream.
Various stream parameters can be selected before opening.
While the stream is playing, the frame counts and stream state are displayed.
The latency is estimated based on the timestamp information.

Experiment with changing the buffer size to see if there are glitches when the size is high or low.

Experiment with changing the "Workload".
Watch the "% CPU" and the #XRuns.
The audio is expected to glitch when the workload is high because there is too much work
and the audio task misses its delivery deadlines.

The extra workload is generated by calculating a number of classic synthesizer voices with two oscillators, two envelopes and a resonant filter.
You can see the affect of the changing workload in the "% cpu" report in the status area.
The extra workload will always cause glitching when you get close to 100% CPU load.
If the workload is causing glitching at a low % CPU load then there may be a problem with the callback timing.

A variety of output signals can be played including frequency sweeps and white noise.
The default output sound is a sine wave on each channel. The base frequency is 330 Hz
and increases by a ratio of 4:3 (a perfect fourth) for each channel.

Instructions for using TEST OUTPUT for 4 or more chanels is in
[Wiki/OboeTester_MultiChannelOutput](https://github.com/google/oboe/wiki/OboeTester_MultiChannelOutput).

### Test Input

Test input streams. Displays current volume as VU bars.

### Tap to Tone Latency

Measure touch screen latency plus audio output latency.
Press START then tap on the screen with your fingertip.
The app will listen for the sound of your fingernail tapping the screen
and the resulting beep, and then measure the time between them.

If you use headphones then you can eliminate the latency caused by speaker protection.
If you use USB-MIDI input then you can eliminate the latency due to the touch screen, which is around 15-30 msec.
MIDI latency is generally under 1 msec.
This test works well for measuring the output latency of Bluetooth headsets.

More instructions in the [Wiki/OboeTester_TapToTone](https://github.com/google/oboe/wiki/OboeTester_TapToTone).

### Echo Input to Output

This test copies input to output and adds up to 3 seconds of delay.
This can be used to simulate high latency on a phone that supports low latency.
Try putting the phone to your ear with the added delay at 0 and try talking.
Then set it to about 700 msec and try talking on the phone. Notice how the echo can be very confusing.

The test will also display estimated "cold start latency" for full duplex streams.

### Round Trip Latency

This test works with either a [loopback adapter](https://source.android.com/devices/audio/latency/loopback) or through speakers.
Latency through the speakers will probably be higher.
It measures the input and output latency combined.

1. Set the Input or Output settings by tapping the green bar to expose the controls.
2. Set the volume somewhere above the middle. The test works at almost any volume. But the confidence will be higher at higher volumes.
3. Tap "MEASURE" to make a single measurement.
4. Or tap "AVERAGE" to run the test several times and report an average and Mean Absolute Deviation.

The test starts by setting up a stable full-duplex stream.
Then it outputs a random series of bits encoded using smoothed Manchester Encoding.
We record the Input and Output stream together for about a second.
Then we correlate the two streams by sliding the portion of the output stream that contains the random bits over the input stream at different time offsets.
The Manchaster Encoded signal provide a very sharp peak when the offset matches the combined input and output latency.

Source code for the analyzer in [LatencyAnalyzer.h](https://github.com/google/oboe/blob/main/apps/OboeTester/app/src/main/cpp/analyzer/LatencyAnalyzer.h).

### Record and Play

* Tap RECORD to record several seconds of audio. You should see the red VU meters move.
* Tap STOP then PLAY to play it back.
* Tap SHARE button to the recorded WAV file to GDrive, GMail or another app.
You can then examine the WAV file using a program like Audacity.

### Glitch Test

This test works best with a loopback adapter. But it can also work in a quiet room.
It plays a sine wave and then tries to record and lock onto that sine wave.
If the actual input does not match the expected sine wave value then it is counted as a glitch.
The test will display the maximum time that it ran without seeing a glitch.

1. Plug in loopback adapter. (Optional)
2. Press green bars to show input and output settings. Make changes. (optional)
3. Press START button.
4. Watch for state=LOCKED, which means it has detected and locked onto the sine wave output.
5. Note the glitch count, which should be zero.
6. Also the "max.time.no.glitches" should be as long as you run the test.
7. Press STOP button.
8. Press SHARE button to send a WAV file recording of the last glitch by email to yourself.

Look for the #XRuns display.
If #XRuns increments when a glitch occurs then the glitch is probably due to preemption of the audio task.
If #XRuns is not incrementing then the glitches may be due to AAudio MMAP tuning errors in the HAL.

### Auto Glitch Test

Measure glitches for various combinations of input and output settings.
Change the test duration to a high value and let it run for a while.
If you get glitches in one configuration then you can investigate using the previous manual Glitch Test.
The Share button will let you email the report to yourself.

### Test Disconnect

You can test whether the disconnect logic is working in Android by plugging or unplugging a headset.
Just follow the instructions in red. You will get a report at the end that you can SHARE by GMail or Drive.

### Device Report

Provides a device report. This report includes info about the features enabled, the properties set, audio
paths, and microphones.
You can share this report by first pressing the icon with the three vertical dots at the top right of OboeTester.
After that, simply press the share button and you should be able to email this to yourself.

### Data Paths

This checks for dead channels, broken Input Presets and other audio data path problems.

1. Tap "DATA PATHS" button.
1. Connect an analog or USB loopback adapter if desired.
1. Set volume to medium high.
1. Place the phone on a table and hit START.
2. If you are testing the speaker/mic combination then the room must be quiet. You will hear some sine tones.
1. Wait a few minutes, quietly, for the test to complete.
1. You will get a report at the end that you can SHARE by GMail or Drive.

When a subtest fails it will write a WAV file of the recorded audio to storage. You can pull the file from the Android device and
view it using Audacity of other audio editor. For example, if test #7 failed, enter:

    adb pull /storage/emulated/0/Android/data/com.mobileer.oboetester/files/Music/glitch_007.wav ~/.

### External Tap-to-Tone

This lets you measure the latency between touching a screen to the sound coming out on a second device.
You could use this to measure, for example, the latency on an iPhone.

1. Launch OboeTester on Android device (A) in a quiet room.
2. Tap "EXTRAS..." button.
3. Tap "EXTERNAL TAP" button.
4. Launch a program on a second device (B) that will make a sound when you touch the screen. A good example would be an interactive drum pad.
5. Tap "START" button to start listening on device (A).
6. Tap on the app on the device (B) with your fingertip. You need to make a noise with your fingernail.
7. Quickly tap the "ANALYSE" button on device (A).
8. OboeTester will now look for two sounds in the recording and measure the time between them.

### Plug Latency
Measures the time it takes to close, open, and start streams as audio devices are plugged in and removed.

### Error Callback Test
Lets you delete an error callback while it is used by Oboe. Targeted test for issue #1603.

### Route Callback Test
Changes the VoiceCommunication route while playing audio. Targeted test for issue #1763.

### CPU Load
This test plays a tone and alternates between low and high workloads.
It exercises the kernel's CPU scheduler, which controls CPU frequency and core migration.
More details on the [wiki/OboeTester_DynamicCpuLoad](https://github.com/google/oboe/wiki/OboeTester_DynamicCpuLoad).
