// Code generated by go-mockgen 1.3.7; DO NOT EDIT.
//
// This file was generated by running `go-mockgen` at the root of this repository.
// To add additional mocks to this or another package, add a new entry to the
// mockgen.yaml file in the root of this repository.

package lfs

import (
	"context"
	"sync"

	database "gogs.io/gogs/internal/database"
	lfsutil "gogs.io/gogs/internal/lfsutil"
)

// MockStore is a mock implementation of the Store interface (from the
// package gogs.io/gogs/internal/route/lfs) used for unit testing.
type MockStore struct {
	// AuthenticateUserFunc is an instance of a mock function object
	// controlling the behavior of the method AuthenticateUser.
	AuthenticateUserFunc *StoreAuthenticateUserFunc
	// AuthorizeRepositoryAccessFunc is an instance of a mock function
	// object controlling the behavior of the method
	// AuthorizeRepositoryAccess.
	AuthorizeRepositoryAccessFunc *StoreAuthorizeRepositoryAccessFunc
	// CreateLFSObjectFunc is an instance of a mock function object
	// controlling the behavior of the method CreateLFSObject.
	CreateLFSObjectFunc *StoreCreateLFSObjectFunc
	// CreateUserFunc is an instance of a mock function object controlling
	// the behavior of the method CreateUser.
	CreateUserFunc *StoreCreateUserFunc
	// GetAccessTokenBySHA1Func is an instance of a mock function object
	// controlling the behavior of the method GetAccessTokenBySHA1.
	GetAccessTokenBySHA1Func *StoreGetAccessTokenBySHA1Func
	// GetLFSObjectByOIDFunc is an instance of a mock function object
	// controlling the behavior of the method GetLFSObjectByOID.
	GetLFSObjectByOIDFunc *StoreGetLFSObjectByOIDFunc
	// GetLFSObjectsByOIDsFunc is an instance of a mock function object
	// controlling the behavior of the method GetLFSObjectsByOIDs.
	GetLFSObjectsByOIDsFunc *StoreGetLFSObjectsByOIDsFunc
	// GetRepositoryByNameFunc is an instance of a mock function object
	// controlling the behavior of the method GetRepositoryByName.
	GetRepositoryByNameFunc *StoreGetRepositoryByNameFunc
	// GetUserByIDFunc is an instance of a mock function object controlling
	// the behavior of the method GetUserByID.
	GetUserByIDFunc *StoreGetUserByIDFunc
	// GetUserByUsernameFunc is an instance of a mock function object
	// controlling the behavior of the method GetUserByUsername.
	GetUserByUsernameFunc *StoreGetUserByUsernameFunc
	// IsTwoFactorEnabledFunc is an instance of a mock function object
	// controlling the behavior of the method IsTwoFactorEnabled.
	IsTwoFactorEnabledFunc *StoreIsTwoFactorEnabledFunc
	// TouchAccessTokenByIDFunc is an instance of a mock function object
	// controlling the behavior of the method TouchAccessTokenByID.
	TouchAccessTokenByIDFunc *StoreTouchAccessTokenByIDFunc
}

// NewMockStore creates a new mock of the Store interface. All methods
// return zero values for all results, unless overwritten.
func NewMockStore() *MockStore {
	return &MockStore{
		AuthenticateUserFunc: &StoreAuthenticateUserFunc{
			defaultHook: func(context.Context, string, string, int64) (r0 *database.User, r1 error) {
				return
			},
		},
		AuthorizeRepositoryAccessFunc: &StoreAuthorizeRepositoryAccessFunc{
			defaultHook: func(context.Context, int64, int64, database.AccessMode, database.AccessModeOptions) (r0 bool) {
				return
			},
		},
		CreateLFSObjectFunc: &StoreCreateLFSObjectFunc{
			defaultHook: func(context.Context, int64, lfsutil.OID, int64, lfsutil.Storage) (r0 error) {
				return
			},
		},
		CreateUserFunc: &StoreCreateUserFunc{
			defaultHook: func(context.Context, string, string, database.CreateUserOptions) (r0 *database.User, r1 error) {
				return
			},
		},
		GetAccessTokenBySHA1Func: &StoreGetAccessTokenBySHA1Func{
			defaultHook: func(context.Context, string) (r0 *database.AccessToken, r1 error) {
				return
			},
		},
		GetLFSObjectByOIDFunc: &StoreGetLFSObjectByOIDFunc{
			defaultHook: func(context.Context, int64, lfsutil.OID) (r0 *database.LFSObject, r1 error) {
				return
			},
		},
		GetLFSObjectsByOIDsFunc: &StoreGetLFSObjectsByOIDsFunc{
			defaultHook: func(context.Context, int64, ...lfsutil.OID) (r0 []*database.LFSObject, r1 error) {
				return
			},
		},
		GetRepositoryByNameFunc: &StoreGetRepositoryByNameFunc{
			defaultHook: func(context.Context, int64, string) (r0 *database.Repository, r1 error) {
				return
			},
		},
		GetUserByIDFunc: &StoreGetUserByIDFunc{
			defaultHook: func(context.Context, int64) (r0 *database.User, r1 error) {
				return
			},
		},
		GetUserByUsernameFunc: &StoreGetUserByUsernameFunc{
			defaultHook: func(context.Context, string) (r0 *database.User, r1 error) {
				return
			},
		},
		IsTwoFactorEnabledFunc: &StoreIsTwoFactorEnabledFunc{
			defaultHook: func(context.Context, int64) (r0 bool) {
				return
			},
		},
		TouchAccessTokenByIDFunc: &StoreTouchAccessTokenByIDFunc{
			defaultHook: func(context.Context, int64) (r0 error) {
				return
			},
		},
	}
}

// NewStrictMockStore creates a new mock of the Store interface. All methods
// panic on invocation, unless overwritten.
func NewStrictMockStore() *MockStore {
	return &MockStore{
		AuthenticateUserFunc: &StoreAuthenticateUserFunc{
			defaultHook: func(context.Context, string, string, int64) (*database.User, error) {
				panic("unexpected invocation of MockStore.AuthenticateUser")
			},
		},
		AuthorizeRepositoryAccessFunc: &StoreAuthorizeRepositoryAccessFunc{
			defaultHook: func(context.Context, int64, int64, database.AccessMode, database.AccessModeOptions) bool {
				panic("unexpected invocation of MockStore.AuthorizeRepositoryAccess")
			},
		},
		CreateLFSObjectFunc: &StoreCreateLFSObjectFunc{
			defaultHook: func(context.Context, int64, lfsutil.OID, int64, lfsutil.Storage) error {
				panic("unexpected invocation of MockStore.CreateLFSObject")
			},
		},
		CreateUserFunc: &StoreCreateUserFunc{
			defaultHook: func(context.Context, string, string, database.CreateUserOptions) (*database.User, error) {
				panic("unexpected invocation of MockStore.CreateUser")
			},
		},
		GetAccessTokenBySHA1Func: &StoreGetAccessTokenBySHA1Func{
			defaultHook: func(context.Context, string) (*database.AccessToken, error) {
				panic("unexpected invocation of MockStore.GetAccessTokenBySHA1")
			},
		},
		GetLFSObjectByOIDFunc: &StoreGetLFSObjectByOIDFunc{
			defaultHook: func(context.Context, int64, lfsutil.OID) (*database.LFSObject, error) {
				panic("unexpected invocation of MockStore.GetLFSObjectByOID")
			},
		},
		GetLFSObjectsByOIDsFunc: &StoreGetLFSObjectsByOIDsFunc{
			defaultHook: func(context.Context, int64, ...lfsutil.OID) ([]*database.LFSObject, error) {
				panic("unexpected invocation of MockStore.GetLFSObjectsByOIDs")
			},
		},
		GetRepositoryByNameFunc: &StoreGetRepositoryByNameFunc{
			defaultHook: func(context.Context, int64, string) (*database.Repository, error) {
				panic("unexpected invocation of MockStore.GetRepositoryByName")
			},
		},
		GetUserByIDFunc: &StoreGetUserByIDFunc{
			defaultHook: func(context.Context, int64) (*database.User, error) {
				panic("unexpected invocation of MockStore.GetUserByID")
			},
		},
		GetUserByUsernameFunc: &StoreGetUserByUsernameFunc{
			defaultHook: func(context.Context, string) (*database.User, error) {
				panic("unexpected invocation of MockStore.GetUserByUsername")
			},
		},
		IsTwoFactorEnabledFunc: &StoreIsTwoFactorEnabledFunc{
			defaultHook: func(context.Context, int64) bool {
				panic("unexpected invocation of MockStore.IsTwoFactorEnabled")
			},
		},
		TouchAccessTokenByIDFunc: &StoreTouchAccessTokenByIDFunc{
			defaultHook: func(context.Context, int64) error {
				panic("unexpected invocation of MockStore.TouchAccessTokenByID")
			},
		},
	}
}

// NewMockStoreFrom creates a new mock of the MockStore interface. All
// methods delegate to the given implementation, unless overwritten.
func NewMockStoreFrom(i Store) *MockStore {
	return &MockStore{
		AuthenticateUserFunc: &StoreAuthenticateUserFunc{
			defaultHook: i.AuthenticateUser,
		},
		AuthorizeRepositoryAccessFunc: &StoreAuthorizeRepositoryAccessFunc{
			defaultHook: i.AuthorizeRepositoryAccess,
		},
		CreateLFSObjectFunc: &StoreCreateLFSObjectFunc{
			defaultHook: i.CreateLFSObject,
		},
		CreateUserFunc: &StoreCreateUserFunc{
			defaultHook: i.CreateUser,
		},
		GetAccessTokenBySHA1Func: &StoreGetAccessTokenBySHA1Func{
			defaultHook: i.GetAccessTokenBySHA1,
		},
		GetLFSObjectByOIDFunc: &StoreGetLFSObjectByOIDFunc{
			defaultHook: i.GetLFSObjectByOID,
		},
		GetLFSObjectsByOIDsFunc: &StoreGetLFSObjectsByOIDsFunc{
			defaultHook: i.GetLFSObjectsByOIDs,
		},
		GetRepositoryByNameFunc: &StoreGetRepositoryByNameFunc{
			defaultHook: i.GetRepositoryByName,
		},
		GetUserByIDFunc: &StoreGetUserByIDFunc{
			defaultHook: i.GetUserByID,
		},
		GetUserByUsernameFunc: &StoreGetUserByUsernameFunc{
			defaultHook: i.GetUserByUsername,
		},
		IsTwoFactorEnabledFunc: &StoreIsTwoFactorEnabledFunc{
			defaultHook: i.IsTwoFactorEnabled,
		},
		TouchAccessTokenByIDFunc: &StoreTouchAccessTokenByIDFunc{
			defaultHook: i.TouchAccessTokenByID,
		},
	}
}

// StoreAuthenticateUserFunc describes the behavior when the
// AuthenticateUser method of the parent MockStore instance is invoked.
type StoreAuthenticateUserFunc struct {
	defaultHook func(context.Context, string, string, int64) (*database.User, error)
	hooks       []func(context.Context, string, string, int64) (*database.User, error)
	history     []StoreAuthenticateUserFuncCall
	mutex       sync.Mutex
}

// AuthenticateUser delegates to the next hook function in the queue and
// stores the parameter and result values of this invocation.
func (m *MockStore) AuthenticateUser(v0 context.Context, v1 string, v2 string, v3 int64) (*database.User, error) {
	r0, r1 := m.AuthenticateUserFunc.nextHook()(v0, v1, v2, v3)
	m.AuthenticateUserFunc.appendCall(StoreAuthenticateUserFuncCall{v0, v1, v2, v3, r0, r1})
	return r0, r1
}

// SetDefaultHook sets function that is called when the AuthenticateUser
// method of the parent MockStore instance is invoked and the hook queue is
// empty.
func (f *StoreAuthenticateUserFunc) SetDefaultHook(hook func(context.Context, string, string, int64) (*database.User, error)) {
	f.defaultHook = hook
}

// PushHook adds a function to the end of hook queue. Each invocation of the
// AuthenticateUser method of the parent MockStore instance invokes the hook
// at the front of the queue and discards it. After the queue is empty, the
// default hook function is invoked for any future action.
func (f *StoreAuthenticateUserFunc) PushHook(hook func(context.Context, string, string, int64) (*database.User, error)) {
	f.mutex.Lock()
	f.hooks = append(f.hooks, hook)
	f.mutex.Unlock()
}

// SetDefaultReturn calls SetDefaultHook with a function that returns the
// given values.
func (f *StoreAuthenticateUserFunc) SetDefaultReturn(r0 *database.User, r1 error) {
	f.SetDefaultHook(func(context.Context, string, string, int64) (*database.User, error) {
		return r0, r1
	})
}

// PushReturn calls PushHook with a function that returns the given values.
func (f *StoreAuthenticateUserFunc) PushReturn(r0 *database.User, r1 error) {
	f.PushHook(func(context.Context, string, string, int64) (*database.User, error) {
		return r0, r1
	})
}

func (f *StoreAuthenticateUserFunc) nextHook() func(context.Context, string, string, int64) (*database.User, error) {
	f.mutex.Lock()
	defer f.mutex.Unlock()

	if len(f.hooks) == 0 {
		return f.defaultHook
	}

	hook := f.hooks[0]
	f.hooks = f.hooks[1:]
	return hook
}

func (f *StoreAuthenticateUserFunc) appendCall(r0 StoreAuthenticateUserFuncCall) {
	f.mutex.Lock()
	f.history = append(f.history, r0)
	f.mutex.Unlock()
}

// History returns a sequence of StoreAuthenticateUserFuncCall objects
// describing the invocations of this function.
func (f *StoreAuthenticateUserFunc) History() []StoreAuthenticateUserFuncCall {
	f.mutex.Lock()
	history := make([]StoreAuthenticateUserFuncCall, len(f.history))
	copy(history, f.history)
	f.mutex.Unlock()

	return history
}

// StoreAuthenticateUserFuncCall is an object that describes an invocation
// of method AuthenticateUser on an instance of MockStore.
type StoreAuthenticateUserFuncCall struct {
	// Arg0 is the value of the 1st argument passed to this method
	// invocation.
	Arg0 context.Context
	// Arg1 is the value of the 2nd argument passed to this method
	// invocation.
	Arg1 string
	// Arg2 is the value of the 3rd argument passed to this method
	// invocation.
	Arg2 string
	// Arg3 is the value of the 4th argument passed to this method
	// invocation.
	Arg3 int64
	// Result0 is the value of the 1st result returned from this method
	// invocation.
	Result0 *database.User
	// Result1 is the value of the 2nd result returned from this method
	// invocation.
	Result1 error
}

// Args returns an interface slice containing the arguments of this
// invocation.
func (c StoreAuthenticateUserFuncCall) Args() []interface{} {
	return []interface{}{c.Arg0, c.Arg1, c.Arg2, c.Arg3}
}

// Results returns an interface slice containing the results of this
// invocation.
func (c StoreAuthenticateUserFuncCall) Results() []interface{} {
	return []interface{}{c.Result0, c.Result1}
}

// StoreAuthorizeRepositoryAccessFunc describes the behavior when the
// AuthorizeRepositoryAccess method of the parent MockStore instance is
// invoked.
type StoreAuthorizeRepositoryAccessFunc struct {
	defaultHook func(context.Context, int64, int64, database.AccessMode, database.AccessModeOptions) bool
	hooks       []func(context.Context, int64, int64, database.AccessMode, database.AccessModeOptions) bool
	history     []StoreAuthorizeRepositoryAccessFuncCall
	mutex       sync.Mutex
}

// AuthorizeRepositoryAccess delegates to the next hook function in the
// queue and stores the parameter and result values of this invocation.
func (m *MockStore) AuthorizeRepositoryAccess(v0 context.Context, v1 int64, v2 int64, v3 database.AccessMode, v4 database.AccessModeOptions) bool {
	r0 := m.AuthorizeRepositoryAccessFunc.nextHook()(v0, v1, v2, v3, v4)
	m.AuthorizeRepositoryAccessFunc.appendCall(StoreAuthorizeRepositoryAccessFuncCall{v0, v1, v2, v3, v4, r0})
	return r0
}

// SetDefaultHook sets function that is called when the
// AuthorizeRepositoryAccess method of the parent MockStore instance is
// invoked and the hook queue is empty.
func (f *StoreAuthorizeRepositoryAccessFunc) SetDefaultHook(hook func(context.Context, int64, int64, database.AccessMode, database.AccessModeOptions) bool) {
	f.defaultHook = hook
}

// PushHook adds a function to the end of hook queue. Each invocation of the
// AuthorizeRepositoryAccess method of the parent MockStore instance invokes
// the hook at the front of the queue and discards it. After the queue is
// empty, the default hook function is invoked for any future action.
func (f *StoreAuthorizeRepositoryAccessFunc) PushHook(hook func(context.Context, int64, int64, database.AccessMode, database.AccessModeOptions) bool) {
	f.mutex.Lock()
	f.hooks = append(f.hooks, hook)
	f.mutex.Unlock()
}

// SetDefaultReturn calls SetDefaultHook with a function that returns the
// given values.
func (f *StoreAuthorizeRepositoryAccessFunc) SetDefaultReturn(r0 bool) {
	f.SetDefaultHook(func(context.Context, int64, int64, database.AccessMode, database.AccessModeOptions) bool {
		return r0
	})
}

// PushReturn calls PushHook with a function that returns the given values.
func (f *StoreAuthorizeRepositoryAccessFunc) PushReturn(r0 bool) {
	f.PushHook(func(context.Context, int64, int64, database.AccessMode, database.AccessModeOptions) bool {
		return r0
	})
}

func (f *StoreAuthorizeRepositoryAccessFunc) nextHook() func(context.Context, int64, int64, database.AccessMode, database.AccessModeOptions) bool {
	f.mutex.Lock()
	defer f.mutex.Unlock()

	if len(f.hooks) == 0 {
		return f.defaultHook
	}

	hook := f.hooks[0]
	f.hooks = f.hooks[1:]
	return hook
}

func (f *StoreAuthorizeRepositoryAccessFunc) appendCall(r0 StoreAuthorizeRepositoryAccessFuncCall) {
	f.mutex.Lock()
	f.history = append(f.history, r0)
	f.mutex.Unlock()
}

// History returns a sequence of StoreAuthorizeRepositoryAccessFuncCall
// objects describing the invocations of this function.
func (f *StoreAuthorizeRepositoryAccessFunc) History() []StoreAuthorizeRepositoryAccessFuncCall {
	f.mutex.Lock()
	history := make([]StoreAuthorizeRepositoryAccessFuncCall, len(f.history))
	copy(history, f.history)
	f.mutex.Unlock()

	return history
}

// StoreAuthorizeRepositoryAccessFuncCall is an object that describes an
// invocation of method AuthorizeRepositoryAccess on an instance of
// MockStore.
type StoreAuthorizeRepositoryAccessFuncCall struct {
	// Arg0 is the value of the 1st argument passed to this method
	// invocation.
	Arg0 context.Context
	// Arg1 is the value of the 2nd argument passed to this method
	// invocation.
	Arg1 int64
	// Arg2 is the value of the 3rd argument passed to this method
	// invocation.
	Arg2 int64
	// Arg3 is the value of the 4th argument passed to this method
	// invocation.
	Arg3 database.AccessMode
	// Arg4 is the value of the 5th argument passed to this method
	// invocation.
	Arg4 database.AccessModeOptions
	// Result0 is the value of the 1st result returned from this method
	// invocation.
	Result0 bool
}

// Args returns an interface slice containing the arguments of this
// invocation.
func (c StoreAuthorizeRepositoryAccessFuncCall) Args() []interface{} {
	return []interface{}{c.Arg0, c.Arg1, c.Arg2, c.Arg3, c.Arg4}
}

// Results returns an interface slice containing the results of this
// invocation.
func (c StoreAuthorizeRepositoryAccessFuncCall) Results() []interface{} {
	return []interface{}{c.Result0}
}

// StoreCreateLFSObjectFunc describes the behavior when the CreateLFSObject
// method of the parent MockStore instance is invoked.
type StoreCreateLFSObjectFunc struct {
	defaultHook func(context.Context, int64, lfsutil.OID, int64, lfsutil.Storage) error
	hooks       []func(context.Context, int64, lfsutil.OID, int64, lfsutil.Storage) error
	history     []StoreCreateLFSObjectFuncCall
	mutex       sync.Mutex
}

// CreateLFSObject delegates to the next hook function in the queue and
// stores the parameter and result values of this invocation.
func (m *MockStore) CreateLFSObject(v0 context.Context, v1 int64, v2 lfsutil.OID, v3 int64, v4 lfsutil.Storage) error {
	r0 := m.CreateLFSObjectFunc.nextHook()(v0, v1, v2, v3, v4)
	m.CreateLFSObjectFunc.appendCall(StoreCreateLFSObjectFuncCall{v0, v1, v2, v3, v4, r0})
	return r0
}

// SetDefaultHook sets function that is called when the CreateLFSObject
// method of the parent MockStore instance is invoked and the hook queue is
// empty.
func (f *StoreCreateLFSObjectFunc) SetDefaultHook(hook func(context.Context, int64, lfsutil.OID, int64, lfsutil.Storage) error) {
	f.defaultHook = hook
}

// PushHook adds a function to the end of hook queue. Each invocation of the
// CreateLFSObject method of the parent MockStore instance invokes the hook
// at the front of the queue and discards it. After the queue is empty, the
// default hook function is invoked for any future action.
func (f *StoreCreateLFSObjectFunc) PushHook(hook func(context.Context, int64, lfsutil.OID, int64, lfsutil.Storage) error) {
	f.mutex.Lock()
	f.hooks = append(f.hooks, hook)
	f.mutex.Unlock()
}

// SetDefaultReturn calls SetDefaultHook with a function that returns the
// given values.
func (f *StoreCreateLFSObjectFunc) SetDefaultReturn(r0 error) {
	f.SetDefaultHook(func(context.Context, int64, lfsutil.OID, int64, lfsutil.Storage) error {
		return r0
	})
}

// PushReturn calls PushHook with a function that returns the given values.
func (f *StoreCreateLFSObjectFunc) PushReturn(r0 error) {
	f.PushHook(func(context.Context, int64, lfsutil.OID, int64, lfsutil.Storage) error {
		return r0
	})
}

func (f *StoreCreateLFSObjectFunc) nextHook() func(context.Context, int64, lfsutil.OID, int64, lfsutil.Storage) error {
	f.mutex.Lock()
	defer f.mutex.Unlock()

	if len(f.hooks) == 0 {
		return f.defaultHook
	}

	hook := f.hooks[0]
	f.hooks = f.hooks[1:]
	return hook
}

func (f *StoreCreateLFSObjectFunc) appendCall(r0 StoreCreateLFSObjectFuncCall) {
	f.mutex.Lock()
	f.history = append(f.history, r0)
	f.mutex.Unlock()
}

// History returns a sequence of StoreCreateLFSObjectFuncCall objects
// describing the invocations of this function.
func (f *StoreCreateLFSObjectFunc) History() []StoreCreateLFSObjectFuncCall {
	f.mutex.Lock()
	history := make([]StoreCreateLFSObjectFuncCall, len(f.history))
	copy(history, f.history)
	f.mutex.Unlock()

	return history
}

// StoreCreateLFSObjectFuncCall is an object that describes an invocation of
// method CreateLFSObject on an instance of MockStore.
type StoreCreateLFSObjectFuncCall struct {
	// Arg0 is the value of the 1st argument passed to this method
	// invocation.
	Arg0 context.Context
	// Arg1 is the value of the 2nd argument passed to this method
	// invocation.
	Arg1 int64
	// Arg2 is the value of the 3rd argument passed to this method
	// invocation.
	Arg2 lfsutil.OID
	// Arg3 is the value of the 4th argument passed to this method
	// invocation.
	Arg3 int64
	// Arg4 is the value of the 5th argument passed to this method
	// invocation.
	Arg4 lfsutil.Storage
	// Result0 is the value of the 1st result returned from this method
	// invocation.
	Result0 error
}

// Args returns an interface slice containing the arguments of this
// invocation.
func (c StoreCreateLFSObjectFuncCall) Args() []interface{} {
	return []interface{}{c.Arg0, c.Arg1, c.Arg2, c.Arg3, c.Arg4}
}

// Results returns an interface slice containing the results of this
// invocation.
func (c StoreCreateLFSObjectFuncCall) Results() []interface{} {
	return []interface{}{c.Result0}
}

// StoreCreateUserFunc describes the behavior when the CreateUser method of
// the parent MockStore instance is invoked.
type StoreCreateUserFunc struct {
	defaultHook func(context.Context, string, string, database.CreateUserOptions) (*database.User, error)
	hooks       []func(context.Context, string, string, database.CreateUserOptions) (*database.User, error)
	history     []StoreCreateUserFuncCall
	mutex       sync.Mutex
}

// CreateUser delegates to the next hook function in the queue and stores
// the parameter and result values of this invocation.
func (m *MockStore) CreateUser(v0 context.Context, v1 string, v2 string, v3 database.CreateUserOptions) (*database.User, error) {
	r0, r1 := m.CreateUserFunc.nextHook()(v0, v1, v2, v3)
	m.CreateUserFunc.appendCall(StoreCreateUserFuncCall{v0, v1, v2, v3, r0, r1})
	return r0, r1
}

// SetDefaultHook sets function that is called when the CreateUser method of
// the parent MockStore instance is invoked and the hook queue is empty.
func (f *StoreCreateUserFunc) SetDefaultHook(hook func(context.Context, string, string, database.CreateUserOptions) (*database.User, error)) {
	f.defaultHook = hook
}

// PushHook adds a function to the end of hook queue. Each invocation of the
// CreateUser method of the parent MockStore instance invokes the hook at
// the front of the queue and discards it. After the queue is empty, the
// default hook function is invoked for any future action.
func (f *StoreCreateUserFunc) PushHook(hook func(context.Context, string, string, database.CreateUserOptions) (*database.User, error)) {
	f.mutex.Lock()
	f.hooks = append(f.hooks, hook)
	f.mutex.Unlock()
}

// SetDefaultReturn calls SetDefaultHook with a function that returns the
// given values.
func (f *StoreCreateUserFunc) SetDefaultReturn(r0 *database.User, r1 error) {
	f.SetDefaultHook(func(context.Context, string, string, database.CreateUserOptions) (*database.User, error) {
		return r0, r1
	})
}

// PushReturn calls PushHook with a function that returns the given values.
func (f *StoreCreateUserFunc) PushReturn(r0 *database.User, r1 error) {
	f.PushHook(func(context.Context, string, string, database.CreateUserOptions) (*database.User, error) {
		return r0, r1
	})
}

func (f *StoreCreateUserFunc) nextHook() func(context.Context, string, string, database.CreateUserOptions) (*database.User, error) {
	f.mutex.Lock()
	defer f.mutex.Unlock()

	if len(f.hooks) == 0 {
		return f.defaultHook
	}

	hook := f.hooks[0]
	f.hooks = f.hooks[1:]
	return hook
}

func (f *StoreCreateUserFunc) appendCall(r0 StoreCreateUserFuncCall) {
	f.mutex.Lock()
	f.history = append(f.history, r0)
	f.mutex.Unlock()
}

// History returns a sequence of StoreCreateUserFuncCall objects describing
// the invocations of this function.
func (f *StoreCreateUserFunc) History() []StoreCreateUserFuncCall {
	f.mutex.Lock()
	history := make([]StoreCreateUserFuncCall, len(f.history))
	copy(history, f.history)
	f.mutex.Unlock()

	return history
}

// StoreCreateUserFuncCall is an object that describes an invocation of
// method CreateUser on an instance of MockStore.
type StoreCreateUserFuncCall struct {
	// Arg0 is the value of the 1st argument passed to this method
	// invocation.
	Arg0 context.Context
	// Arg1 is the value of the 2nd argument passed to this method
	// invocation.
	Arg1 string
	// Arg2 is the value of the 3rd argument passed to this method
	// invocation.
	Arg2 string
	// Arg3 is the value of the 4th argument passed to this method
	// invocation.
	Arg3 database.CreateUserOptions
	// Result0 is the value of the 1st result returned from this method
	// invocation.
	Result0 *database.User
	// Result1 is the value of the 2nd result returned from this method
	// invocation.
	Result1 error
}

// Args returns an interface slice containing the arguments of this
// invocation.
func (c StoreCreateUserFuncCall) Args() []interface{} {
	return []interface{}{c.Arg0, c.Arg1, c.Arg2, c.Arg3}
}

// Results returns an interface slice containing the results of this
// invocation.
func (c StoreCreateUserFuncCall) Results() []interface{} {
	return []interface{}{c.Result0, c.Result1}
}

// StoreGetAccessTokenBySHA1Func describes the behavior when the
// GetAccessTokenBySHA1 method of the parent MockStore instance is invoked.
type StoreGetAccessTokenBySHA1Func struct {
	defaultHook func(context.Context, string) (*database.AccessToken, error)
	hooks       []func(context.Context, string) (*database.AccessToken, error)
	history     []StoreGetAccessTokenBySHA1FuncCall
	mutex       sync.Mutex
}

// GetAccessTokenBySHA1 delegates to the next hook function in the queue and
// stores the parameter and result values of this invocation.
func (m *MockStore) GetAccessTokenBySHA1(v0 context.Context, v1 string) (*database.AccessToken, error) {
	r0, r1 := m.GetAccessTokenBySHA1Func.nextHook()(v0, v1)
	m.GetAccessTokenBySHA1Func.appendCall(StoreGetAccessTokenBySHA1FuncCall{v0, v1, r0, r1})
	return r0, r1
}

// SetDefaultHook sets function that is called when the GetAccessTokenBySHA1
// method of the parent MockStore instance is invoked and the hook queue is
// empty.
func (f *StoreGetAccessTokenBySHA1Func) SetDefaultHook(hook func(context.Context, string) (*database.AccessToken, error)) {
	f.defaultHook = hook
}

// PushHook adds a function to the end of hook queue. Each invocation of the
// GetAccessTokenBySHA1 method of the parent MockStore instance invokes the
// hook at the front of the queue and discards it. After the queue is empty,
// the default hook function is invoked for any future action.
func (f *StoreGetAccessTokenBySHA1Func) PushHook(hook func(context.Context, string) (*database.AccessToken, error)) {
	f.mutex.Lock()
	f.hooks = append(f.hooks, hook)
	f.mutex.Unlock()
}

// SetDefaultReturn calls SetDefaultHook with a function that returns the
// given values.
func (f *StoreGetAccessTokenBySHA1Func) SetDefaultReturn(r0 *database.AccessToken, r1 error) {
	f.SetDefaultHook(func(context.Context, string) (*database.AccessToken, error) {
		return r0, r1
	})
}

// PushReturn calls PushHook with a function that returns the given values.
func (f *StoreGetAccessTokenBySHA1Func) PushReturn(r0 *database.AccessToken, r1 error) {
	f.PushHook(func(context.Context, string) (*database.AccessToken, error) {
		return r0, r1
	})
}

func (f *StoreGetAccessTokenBySHA1Func) nextHook() func(context.Context, string) (*database.AccessToken, error) {
	f.mutex.Lock()
	defer f.mutex.Unlock()

	if len(f.hooks) == 0 {
		return f.defaultHook
	}

	hook := f.hooks[0]
	f.hooks = f.hooks[1:]
	return hook
}

func (f *StoreGetAccessTokenBySHA1Func) appendCall(r0 StoreGetAccessTokenBySHA1FuncCall) {
	f.mutex.Lock()
	f.history = append(f.history, r0)
	f.mutex.Unlock()
}

// History returns a sequence of StoreGetAccessTokenBySHA1FuncCall objects
// describing the invocations of this function.
func (f *StoreGetAccessTokenBySHA1Func) History() []StoreGetAccessTokenBySHA1FuncCall {
	f.mutex.Lock()
	history := make([]StoreGetAccessTokenBySHA1FuncCall, len(f.history))
	copy(history, f.history)
	f.mutex.Unlock()

	return history
}

// StoreGetAccessTokenBySHA1FuncCall is an object that describes an
// invocation of method GetAccessTokenBySHA1 on an instance of MockStore.
type StoreGetAccessTokenBySHA1FuncCall struct {
	// Arg0 is the value of the 1st argument passed to this method
	// invocation.
	Arg0 context.Context
	// Arg1 is the value of the 2nd argument passed to this method
	// invocation.
	Arg1 string
	// Result0 is the value of the 1st result returned from this method
	// invocation.
	Result0 *database.AccessToken
	// Result1 is the value of the 2nd result returned from this method
	// invocation.
	Result1 error
}

// Args returns an interface slice containing the arguments of this
// invocation.
func (c StoreGetAccessTokenBySHA1FuncCall) Args() []interface{} {
	return []interface{}{c.Arg0, c.Arg1}
}

// Results returns an interface slice containing the results of this
// invocation.
func (c StoreGetAccessTokenBySHA1FuncCall) Results() []interface{} {
	return []interface{}{c.Result0, c.Result1}
}

// StoreGetLFSObjectByOIDFunc describes the behavior when the
// GetLFSObjectByOID method of the parent MockStore instance is invoked.
type StoreGetLFSObjectByOIDFunc struct {
	defaultHook func(context.Context, int64, lfsutil.OID) (*database.LFSObject, error)
	hooks       []func(context.Context, int64, lfsutil.OID) (*database.LFSObject, error)
	history     []StoreGetLFSObjectByOIDFuncCall
	mutex       sync.Mutex
}

// GetLFSObjectByOID delegates to the next hook function in the queue and
// stores the parameter and result values of this invocation.
func (m *MockStore) GetLFSObjectByOID(v0 context.Context, v1 int64, v2 lfsutil.OID) (*database.LFSObject, error) {
	r0, r1 := m.GetLFSObjectByOIDFunc.nextHook()(v0, v1, v2)
	m.GetLFSObjectByOIDFunc.appendCall(StoreGetLFSObjectByOIDFuncCall{v0, v1, v2, r0, r1})
	return r0, r1
}

// SetDefaultHook sets function that is called when the GetLFSObjectByOID
// method of the parent MockStore instance is invoked and the hook queue is
// empty.
func (f *StoreGetLFSObjectByOIDFunc) SetDefaultHook(hook func(context.Context, int64, lfsutil.OID) (*database.LFSObject, error)) {
	f.defaultHook = hook
}

// PushHook adds a function to the end of hook queue. Each invocation of the
// GetLFSObjectByOID method of the parent MockStore instance invokes the
// hook at the front of the queue and discards it. After the queue is empty,
// the default hook function is invoked for any future action.
func (f *StoreGetLFSObjectByOIDFunc) PushHook(hook func(context.Context, int64, lfsutil.OID) (*database.LFSObject, error)) {
	f.mutex.Lock()
	f.hooks = append(f.hooks, hook)
	f.mutex.Unlock()
}

// SetDefaultReturn calls SetDefaultHook with a function that returns the
// given values.
func (f *StoreGetLFSObjectByOIDFunc) SetDefaultReturn(r0 *database.LFSObject, r1 error) {
	f.SetDefaultHook(func(context.Context, int64, lfsutil.OID) (*database.LFSObject, error) {
		return r0, r1
	})
}

// PushReturn calls PushHook with a function that returns the given values.
func (f *StoreGetLFSObjectByOIDFunc) PushReturn(r0 *database.LFSObject, r1 error) {
	f.PushHook(func(context.Context, int64, lfsutil.OID) (*database.LFSObject, error) {
		return r0, r1
	})
}

func (f *StoreGetLFSObjectByOIDFunc) nextHook() func(context.Context, int64, lfsutil.OID) (*database.LFSObject, error) {
	f.mutex.Lock()
	defer f.mutex.Unlock()

	if len(f.hooks) == 0 {
		return f.defaultHook
	}

	hook := f.hooks[0]
	f.hooks = f.hooks[1:]
	return hook
}

func (f *StoreGetLFSObjectByOIDFunc) appendCall(r0 StoreGetLFSObjectByOIDFuncCall) {
	f.mutex.Lock()
	f.history = append(f.history, r0)
	f.mutex.Unlock()
}

// History returns a sequence of StoreGetLFSObjectByOIDFuncCall objects
// describing the invocations of this function.
func (f *StoreGetLFSObjectByOIDFunc) History() []StoreGetLFSObjectByOIDFuncCall {
	f.mutex.Lock()
	history := make([]StoreGetLFSObjectByOIDFuncCall, len(f.history))
	copy(history, f.history)
	f.mutex.Unlock()

	return history
}

// StoreGetLFSObjectByOIDFuncCall is an object that describes an invocation
// of method GetLFSObjectByOID on an instance of MockStore.
type StoreGetLFSObjectByOIDFuncCall struct {
	// Arg0 is the value of the 1st argument passed to this method
	// invocation.
	Arg0 context.Context
	// Arg1 is the value of the 2nd argument passed to this method
	// invocation.
	Arg1 int64
	// Arg2 is the value of the 3rd argument passed to this method
	// invocation.
	Arg2 lfsutil.OID
	// Result0 is the value of the 1st result returned from this method
	// invocation.
	Result0 *database.LFSObject
	// Result1 is the value of the 2nd result returned from this method
	// invocation.
	Result1 error
}

// Args returns an interface slice containing the arguments of this
// invocation.
func (c StoreGetLFSObjectByOIDFuncCall) Args() []interface{} {
	return []interface{}{c.Arg0, c.Arg1, c.Arg2}
}

// Results returns an interface slice containing the results of this
// invocation.
func (c StoreGetLFSObjectByOIDFuncCall) Results() []interface{} {
	return []interface{}{c.Result0, c.Result1}
}

// StoreGetLFSObjectsByOIDsFunc describes the behavior when the
// GetLFSObjectsByOIDs method of the parent MockStore instance is invoked.
type StoreGetLFSObjectsByOIDsFunc struct {
	defaultHook func(context.Context, int64, ...lfsutil.OID) ([]*database.LFSObject, error)
	hooks       []func(context.Context, int64, ...lfsutil.OID) ([]*database.LFSObject, error)
	history     []StoreGetLFSObjectsByOIDsFuncCall
	mutex       sync.Mutex
}

// GetLFSObjectsByOIDs delegates to the next hook function in the queue and
// stores the parameter and result values of this invocation.
func (m *MockStore) GetLFSObjectsByOIDs(v0 context.Context, v1 int64, v2 ...lfsutil.OID) ([]*database.LFSObject, error) {
	r0, r1 := m.GetLFSObjectsByOIDsFunc.nextHook()(v0, v1, v2...)
	m.GetLFSObjectsByOIDsFunc.appendCall(StoreGetLFSObjectsByOIDsFuncCall{v0, v1, v2, r0, r1})
	return r0, r1
}

// SetDefaultHook sets function that is called when the GetLFSObjectsByOIDs
// method of the parent MockStore instance is invoked and the hook queue is
// empty.
func (f *StoreGetLFSObjectsByOIDsFunc) SetDefaultHook(hook func(context.Context, int64, ...lfsutil.OID) ([]*database.LFSObject, error)) {
	f.defaultHook = hook
}

// PushHook adds a function to the end of hook queue. Each invocation of the
// GetLFSObjectsByOIDs method of the parent MockStore instance invokes the
// hook at the front of the queue and discards it. After the queue is empty,
// the default hook function is invoked for any future action.
func (f *StoreGetLFSObjectsByOIDsFunc) PushHook(hook func(context.Context, int64, ...lfsutil.OID) ([]*database.LFSObject, error)) {
	f.mutex.Lock()
	f.hooks = append(f.hooks, hook)
	f.mutex.Unlock()
}

// SetDefaultReturn calls SetDefaultHook with a function that returns the
// given values.
func (f *StoreGetLFSObjectsByOIDsFunc) SetDefaultReturn(r0 []*database.LFSObject, r1 error) {
	f.SetDefaultHook(func(context.Context, int64, ...lfsutil.OID) ([]*database.LFSObject, error) {
		return r0, r1
	})
}

// PushReturn calls PushHook with a function that returns the given values.
func (f *StoreGetLFSObjectsByOIDsFunc) PushReturn(r0 []*database.LFSObject, r1 error) {
	f.PushHook(func(context.Context, int64, ...lfsutil.OID) ([]*database.LFSObject, error) {
		return r0, r1
	})
}

func (f *StoreGetLFSObjectsByOIDsFunc) nextHook() func(context.Context, int64, ...lfsutil.OID) ([]*database.LFSObject, error) {
	f.mutex.Lock()
	defer f.mutex.Unlock()

	if len(f.hooks) == 0 {
		return f.defaultHook
	}

	hook := f.hooks[0]
	f.hooks = f.hooks[1:]
	return hook
}

func (f *StoreGetLFSObjectsByOIDsFunc) appendCall(r0 StoreGetLFSObjectsByOIDsFuncCall) {
	f.mutex.Lock()
	f.history = append(f.history, r0)
	f.mutex.Unlock()
}

// History returns a sequence of StoreGetLFSObjectsByOIDsFuncCall objects
// describing the invocations of this function.
func (f *StoreGetLFSObjectsByOIDsFunc) History() []StoreGetLFSObjectsByOIDsFuncCall {
	f.mutex.Lock()
	history := make([]StoreGetLFSObjectsByOIDsFuncCall, len(f.history))
	copy(history, f.history)
	f.mutex.Unlock()

	return history
}

// StoreGetLFSObjectsByOIDsFuncCall is an object that describes an
// invocation of method GetLFSObjectsByOIDs on an instance of MockStore.
type StoreGetLFSObjectsByOIDsFuncCall struct {
	// Arg0 is the value of the 1st argument passed to this method
	// invocation.
	Arg0 context.Context
	// Arg1 is the value of the 2nd argument passed to this method
	// invocation.
	Arg1 int64
	// Arg2 is a slice containing the values of the variadic arguments
	// passed to this method invocation.
	Arg2 []lfsutil.OID
	// Result0 is the value of the 1st result returned from this method
	// invocation.
	Result0 []*database.LFSObject
	// Result1 is the value of the 2nd result returned from this method
	// invocation.
	Result1 error
}

// Args returns an interface slice containing the arguments of this
// invocation. The variadic slice argument is flattened in this array such
// that one positional argument and three variadic arguments would result in
// a slice of four, not two.
func (c StoreGetLFSObjectsByOIDsFuncCall) Args() []interface{} {
	trailing := []interface{}{}
	for _, val := range c.Arg2 {
		trailing = append(trailing, val)
	}

	return append([]interface{}{c.Arg0, c.Arg1}, trailing...)
}

// Results returns an interface slice containing the results of this
// invocation.
func (c StoreGetLFSObjectsByOIDsFuncCall) Results() []interface{} {
	return []interface{}{c.Result0, c.Result1}
}

// StoreGetRepositoryByNameFunc describes the behavior when the
// GetRepositoryByName method of the parent MockStore instance is invoked.
type StoreGetRepositoryByNameFunc struct {
	defaultHook func(context.Context, int64, string) (*database.Repository, error)
	hooks       []func(context.Context, int64, string) (*database.Repository, error)
	history     []StoreGetRepositoryByNameFuncCall
	mutex       sync.Mutex
}

// GetRepositoryByName delegates to the next hook function in the queue and
// stores the parameter and result values of this invocation.
func (m *MockStore) GetRepositoryByName(v0 context.Context, v1 int64, v2 string) (*database.Repository, error) {
	r0, r1 := m.GetRepositoryByNameFunc.nextHook()(v0, v1, v2)
	m.GetRepositoryByNameFunc.appendCall(StoreGetRepositoryByNameFuncCall{v0, v1, v2, r0, r1})
	return r0, r1
}

// SetDefaultHook sets function that is called when the GetRepositoryByName
// method of the parent MockStore instance is invoked and the hook queue is
// empty.
func (f *StoreGetRepositoryByNameFunc) SetDefaultHook(hook func(context.Context, int64, string) (*database.Repository, error)) {
	f.defaultHook = hook
}

// PushHook adds a function to the end of hook queue. Each invocation of the
// GetRepositoryByName method of the parent MockStore instance invokes the
// hook at the front of the queue and discards it. After the queue is empty,
// the default hook function is invoked for any future action.
func (f *StoreGetRepositoryByNameFunc) PushHook(hook func(context.Context, int64, string) (*database.Repository, error)) {
	f.mutex.Lock()
	f.hooks = append(f.hooks, hook)
	f.mutex.Unlock()
}

// SetDefaultReturn calls SetDefaultHook with a function that returns the
// given values.
func (f *StoreGetRepositoryByNameFunc) SetDefaultReturn(r0 *database.Repository, r1 error) {
	f.SetDefaultHook(func(context.Context, int64, string) (*database.Repository, error) {
		return r0, r1
	})
}

// PushReturn calls PushHook with a function that returns the given values.
func (f *StoreGetRepositoryByNameFunc) PushReturn(r0 *database.Repository, r1 error) {
	f.PushHook(func(context.Context, int64, string) (*database.Repository, error) {
		return r0, r1
	})
}

func (f *StoreGetRepositoryByNameFunc) nextHook() func(context.Context, int64, string) (*database.Repository, error) {
	f.mutex.Lock()
	defer f.mutex.Unlock()

	if len(f.hooks) == 0 {
		return f.defaultHook
	}

	hook := f.hooks[0]
	f.hooks = f.hooks[1:]
	return hook
}

func (f *StoreGetRepositoryByNameFunc) appendCall(r0 StoreGetRepositoryByNameFuncCall) {
	f.mutex.Lock()
	f.history = append(f.history, r0)
	f.mutex.Unlock()
}

// History returns a sequence of StoreGetRepositoryByNameFuncCall objects
// describing the invocations of this function.
func (f *StoreGetRepositoryByNameFunc) History() []StoreGetRepositoryByNameFuncCall {
	f.mutex.Lock()
	history := make([]StoreGetRepositoryByNameFuncCall, len(f.history))
	copy(history, f.history)
	f.mutex.Unlock()

	return history
}

// StoreGetRepositoryByNameFuncCall is an object that describes an
// invocation of method GetRepositoryByName on an instance of MockStore.
type StoreGetRepositoryByNameFuncCall struct {
	// Arg0 is the value of the 1st argument passed to this method
	// invocation.
	Arg0 context.Context
	// Arg1 is the value of the 2nd argument passed to this method
	// invocation.
	Arg1 int64
	// Arg2 is the value of the 3rd argument passed to this method
	// invocation.
	Arg2 string
	// Result0 is the value of the 1st result returned from this method
	// invocation.
	Result0 *database.Repository
	// Result1 is the value of the 2nd result returned from this method
	// invocation.
	Result1 error
}

// Args returns an interface slice containing the arguments of this
// invocation.
func (c StoreGetRepositoryByNameFuncCall) Args() []interface{} {
	return []interface{}{c.Arg0, c.Arg1, c.Arg2}
}

// Results returns an interface slice containing the results of this
// invocation.
func (c StoreGetRepositoryByNameFuncCall) Results() []interface{} {
	return []interface{}{c.Result0, c.Result1}
}

// StoreGetUserByIDFunc describes the behavior when the GetUserByID method
// of the parent MockStore instance is invoked.
type StoreGetUserByIDFunc struct {
	defaultHook func(context.Context, int64) (*database.User, error)
	hooks       []func(context.Context, int64) (*database.User, error)
	history     []StoreGetUserByIDFuncCall
	mutex       sync.Mutex
}

// GetUserByID delegates to the next hook function in the queue and stores
// the parameter and result values of this invocation.
func (m *MockStore) GetUserByID(v0 context.Context, v1 int64) (*database.User, error) {
	r0, r1 := m.GetUserByIDFunc.nextHook()(v0, v1)
	m.GetUserByIDFunc.appendCall(StoreGetUserByIDFuncCall{v0, v1, r0, r1})
	return r0, r1
}

// SetDefaultHook sets function that is called when the GetUserByID method
// of the parent MockStore instance is invoked and the hook queue is empty.
func (f *StoreGetUserByIDFunc) SetDefaultHook(hook func(context.Context, int64) (*database.User, error)) {
	f.defaultHook = hook
}

// PushHook adds a function to the end of hook queue. Each invocation of the
// GetUserByID method of the parent MockStore instance invokes the hook at
// the front of the queue and discards it. After the queue is empty, the
// default hook function is invoked for any future action.
func (f *StoreGetUserByIDFunc) PushHook(hook func(context.Context, int64) (*database.User, error)) {
	f.mutex.Lock()
	f.hooks = append(f.hooks, hook)
	f.mutex.Unlock()
}

// SetDefaultReturn calls SetDefaultHook with a function that returns the
// given values.
func (f *StoreGetUserByIDFunc) SetDefaultReturn(r0 *database.User, r1 error) {
	f.SetDefaultHook(func(context.Context, int64) (*database.User, error) {
		return r0, r1
	})
}

// PushReturn calls PushHook with a function that returns the given values.
func (f *StoreGetUserByIDFunc) PushReturn(r0 *database.User, r1 error) {
	f.PushHook(func(context.Context, int64) (*database.User, error) {
		return r0, r1
	})
}

func (f *StoreGetUserByIDFunc) nextHook() func(context.Context, int64) (*database.User, error) {
	f.mutex.Lock()
	defer f.mutex.Unlock()

	if len(f.hooks) == 0 {
		return f.defaultHook
	}

	hook := f.hooks[0]
	f.hooks = f.hooks[1:]
	return hook
}

func (f *StoreGetUserByIDFunc) appendCall(r0 StoreGetUserByIDFuncCall) {
	f.mutex.Lock()
	f.history = append(f.history, r0)
	f.mutex.Unlock()
}

// History returns a sequence of StoreGetUserByIDFuncCall objects describing
// the invocations of this function.
func (f *StoreGetUserByIDFunc) History() []StoreGetUserByIDFuncCall {
	f.mutex.Lock()
	history := make([]StoreGetUserByIDFuncCall, len(f.history))
	copy(history, f.history)
	f.mutex.Unlock()

	return history
}

// StoreGetUserByIDFuncCall is an object that describes an invocation of
// method GetUserByID on an instance of MockStore.
type StoreGetUserByIDFuncCall struct {
	// Arg0 is the value of the 1st argument passed to this method
	// invocation.
	Arg0 context.Context
	// Arg1 is the value of the 2nd argument passed to this method
	// invocation.
	Arg1 int64
	// Result0 is the value of the 1st result returned from this method
	// invocation.
	Result0 *database.User
	// Result1 is the value of the 2nd result returned from this method
	// invocation.
	Result1 error
}

// Args returns an interface slice containing the arguments of this
// invocation.
func (c StoreGetUserByIDFuncCall) Args() []interface{} {
	return []interface{}{c.Arg0, c.Arg1}
}

// Results returns an interface slice containing the results of this
// invocation.
func (c StoreGetUserByIDFuncCall) Results() []interface{} {
	return []interface{}{c.Result0, c.Result1}
}

// StoreGetUserByUsernameFunc describes the behavior when the
// GetUserByUsername method of the parent MockStore instance is invoked.
type StoreGetUserByUsernameFunc struct {
	defaultHook func(context.Context, string) (*database.User, error)
	hooks       []func(context.Context, string) (*database.User, error)
	history     []StoreGetUserByUsernameFuncCall
	mutex       sync.Mutex
}

// GetUserByUsername delegates to the next hook function in the queue and
// stores the parameter and result values of this invocation.
func (m *MockStore) GetUserByUsername(v0 context.Context, v1 string) (*database.User, error) {
	r0, r1 := m.GetUserByUsernameFunc.nextHook()(v0, v1)
	m.GetUserByUsernameFunc.appendCall(StoreGetUserByUsernameFuncCall{v0, v1, r0, r1})
	return r0, r1
}

// SetDefaultHook sets function that is called when the GetUserByUsername
// method of the parent MockStore instance is invoked and the hook queue is
// empty.
func (f *StoreGetUserByUsernameFunc) SetDefaultHook(hook func(context.Context, string) (*database.User, error)) {
	f.defaultHook = hook
}

// PushHook adds a function to the end of hook queue. Each invocation of the
// GetUserByUsername method of the parent MockStore instance invokes the
// hook at the front of the queue and discards it. After the queue is empty,
// the default hook function is invoked for any future action.
func (f *StoreGetUserByUsernameFunc) PushHook(hook func(context.Context, string) (*database.User, error)) {
	f.mutex.Lock()
	f.hooks = append(f.hooks, hook)
	f.mutex.Unlock()
}

// SetDefaultReturn calls SetDefaultHook with a function that returns the
// given values.
func (f *StoreGetUserByUsernameFunc) SetDefaultReturn(r0 *database.User, r1 error) {
	f.SetDefaultHook(func(context.Context, string) (*database.User, error) {
		return r0, r1
	})
}

// PushReturn calls PushHook with a function that returns the given values.
func (f *StoreGetUserByUsernameFunc) PushReturn(r0 *database.User, r1 error) {
	f.PushHook(func(context.Context, string) (*database.User, error) {
		return r0, r1
	})
}

func (f *StoreGetUserByUsernameFunc) nextHook() func(context.Context, string) (*database.User, error) {
	f.mutex.Lock()
	defer f.mutex.Unlock()

	if len(f.hooks) == 0 {
		return f.defaultHook
	}

	hook := f.hooks[0]
	f.hooks = f.hooks[1:]
	return hook
}

func (f *StoreGetUserByUsernameFunc) appendCall(r0 StoreGetUserByUsernameFuncCall) {
	f.mutex.Lock()
	f.history = append(f.history, r0)
	f.mutex.Unlock()
}

// History returns a sequence of StoreGetUserByUsernameFuncCall objects
// describing the invocations of this function.
func (f *StoreGetUserByUsernameFunc) History() []StoreGetUserByUsernameFuncCall {
	f.mutex.Lock()
	history := make([]StoreGetUserByUsernameFuncCall, len(f.history))
	copy(history, f.history)
	f.mutex.Unlock()

	return history
}

// StoreGetUserByUsernameFuncCall is an object that describes an invocation
// of method GetUserByUsername on an instance of MockStore.
type StoreGetUserByUsernameFuncCall struct {
	// Arg0 is the value of the 1st argument passed to this method
	// invocation.
	Arg0 context.Context
	// Arg1 is the value of the 2nd argument passed to this method
	// invocation.
	Arg1 string
	// Result0 is the value of the 1st result returned from this method
	// invocation.
	Result0 *database.User
	// Result1 is the value of the 2nd result returned from this method
	// invocation.
	Result1 error
}

// Args returns an interface slice containing the arguments of this
// invocation.
func (c StoreGetUserByUsernameFuncCall) Args() []interface{} {
	return []interface{}{c.Arg0, c.Arg1}
}

// Results returns an interface slice containing the results of this
// invocation.
func (c StoreGetUserByUsernameFuncCall) Results() []interface{} {
	return []interface{}{c.Result0, c.Result1}
}

// StoreIsTwoFactorEnabledFunc describes the behavior when the
// IsTwoFactorEnabled method of the parent MockStore instance is invoked.
type StoreIsTwoFactorEnabledFunc struct {
	defaultHook func(context.Context, int64) bool
	hooks       []func(context.Context, int64) bool
	history     []StoreIsTwoFactorEnabledFuncCall
	mutex       sync.Mutex
}

// IsTwoFactorEnabled delegates to the next hook function in the queue and
// stores the parameter and result values of this invocation.
func (m *MockStore) IsTwoFactorEnabled(v0 context.Context, v1 int64) bool {
	r0 := m.IsTwoFactorEnabledFunc.nextHook()(v0, v1)
	m.IsTwoFactorEnabledFunc.appendCall(StoreIsTwoFactorEnabledFuncCall{v0, v1, r0})
	return r0
}

// SetDefaultHook sets function that is called when the IsTwoFactorEnabled
// method of the parent MockStore instance is invoked and the hook queue is
// empty.
func (f *StoreIsTwoFactorEnabledFunc) SetDefaultHook(hook func(context.Context, int64) bool) {
	f.defaultHook = hook
}

// PushHook adds a function to the end of hook queue. Each invocation of the
// IsTwoFactorEnabled method of the parent MockStore instance invokes the
// hook at the front of the queue and discards it. After the queue is empty,
// the default hook function is invoked for any future action.
func (f *StoreIsTwoFactorEnabledFunc) PushHook(hook func(context.Context, int64) bool) {
	f.mutex.Lock()
	f.hooks = append(f.hooks, hook)
	f.mutex.Unlock()
}

// SetDefaultReturn calls SetDefaultHook with a function that returns the
// given values.
func (f *StoreIsTwoFactorEnabledFunc) SetDefaultReturn(r0 bool) {
	f.SetDefaultHook(func(context.Context, int64) bool {
		return r0
	})
}

// PushReturn calls PushHook with a function that returns the given values.
func (f *StoreIsTwoFactorEnabledFunc) PushReturn(r0 bool) {
	f.PushHook(func(context.Context, int64) bool {
		return r0
	})
}

func (f *StoreIsTwoFactorEnabledFunc) nextHook() func(context.Context, int64) bool {
	f.mutex.Lock()
	defer f.mutex.Unlock()

	if len(f.hooks) == 0 {
		return f.defaultHook
	}

	hook := f.hooks[0]
	f.hooks = f.hooks[1:]
	return hook
}

func (f *StoreIsTwoFactorEnabledFunc) appendCall(r0 StoreIsTwoFactorEnabledFuncCall) {
	f.mutex.Lock()
	f.history = append(f.history, r0)
	f.mutex.Unlock()
}

// History returns a sequence of StoreIsTwoFactorEnabledFuncCall objects
// describing the invocations of this function.
func (f *StoreIsTwoFactorEnabledFunc) History() []StoreIsTwoFactorEnabledFuncCall {
	f.mutex.Lock()
	history := make([]StoreIsTwoFactorEnabledFuncCall, len(f.history))
	copy(history, f.history)
	f.mutex.Unlock()

	return history
}

// StoreIsTwoFactorEnabledFuncCall is an object that describes an invocation
// of method IsTwoFactorEnabled on an instance of MockStore.
type StoreIsTwoFactorEnabledFuncCall struct {
	// Arg0 is the value of the 1st argument passed to this method
	// invocation.
	Arg0 context.Context
	// Arg1 is the value of the 2nd argument passed to this method
	// invocation.
	Arg1 int64
	// Result0 is the value of the 1st result returned from this method
	// invocation.
	Result0 bool
}

// Args returns an interface slice containing the arguments of this
// invocation.
func (c StoreIsTwoFactorEnabledFuncCall) Args() []interface{} {
	return []interface{}{c.Arg0, c.Arg1}
}

// Results returns an interface slice containing the results of this
// invocation.
func (c StoreIsTwoFactorEnabledFuncCall) Results() []interface{} {
	return []interface{}{c.Result0}
}

// StoreTouchAccessTokenByIDFunc describes the behavior when the
// TouchAccessTokenByID method of the parent MockStore instance is invoked.
type StoreTouchAccessTokenByIDFunc struct {
	defaultHook func(context.Context, int64) error
	hooks       []func(context.Context, int64) error
	history     []StoreTouchAccessTokenByIDFuncCall
	mutex       sync.Mutex
}

// TouchAccessTokenByID delegates to the next hook function in the queue and
// stores the parameter and result values of this invocation.
func (m *MockStore) TouchAccessTokenByID(v0 context.Context, v1 int64) error {
	r0 := m.TouchAccessTokenByIDFunc.nextHook()(v0, v1)
	m.TouchAccessTokenByIDFunc.appendCall(StoreTouchAccessTokenByIDFuncCall{v0, v1, r0})
	return r0
}

// SetDefaultHook sets function that is called when the TouchAccessTokenByID
// method of the parent MockStore instance is invoked and the hook queue is
// empty.
func (f *StoreTouchAccessTokenByIDFunc) SetDefaultHook(hook func(context.Context, int64) error) {
	f.defaultHook = hook
}

// PushHook adds a function to the end of hook queue. Each invocation of the
// TouchAccessTokenByID method of the parent MockStore instance invokes the
// hook at the front of the queue and discards it. After the queue is empty,
// the default hook function is invoked for any future action.
func (f *StoreTouchAccessTokenByIDFunc) PushHook(hook func(context.Context, int64) error) {
	f.mutex.Lock()
	f.hooks = append(f.hooks, hook)
	f.mutex.Unlock()
}

// SetDefaultReturn calls SetDefaultHook with a function that returns the
// given values.
func (f *StoreTouchAccessTokenByIDFunc) SetDefaultReturn(r0 error) {
	f.SetDefaultHook(func(context.Context, int64) error {
		return r0
	})
}

// PushReturn calls PushHook with a function that returns the given values.
func (f *StoreTouchAccessTokenByIDFunc) PushReturn(r0 error) {
	f.PushHook(func(context.Context, int64) error {
		return r0
	})
}

func (f *StoreTouchAccessTokenByIDFunc) nextHook() func(context.Context, int64) error {
	f.mutex.Lock()
	defer f.mutex.Unlock()

	if len(f.hooks) == 0 {
		return f.defaultHook
	}

	hook := f.hooks[0]
	f.hooks = f.hooks[1:]
	return hook
}

func (f *StoreTouchAccessTokenByIDFunc) appendCall(r0 StoreTouchAccessTokenByIDFuncCall) {
	f.mutex.Lock()
	f.history = append(f.history, r0)
	f.mutex.Unlock()
}

// History returns a sequence of StoreTouchAccessTokenByIDFuncCall objects
// describing the invocations of this function.
func (f *StoreTouchAccessTokenByIDFunc) History() []StoreTouchAccessTokenByIDFuncCall {
	f.mutex.Lock()
	history := make([]StoreTouchAccessTokenByIDFuncCall, len(f.history))
	copy(history, f.history)
	f.mutex.Unlock()

	return history
}

// StoreTouchAccessTokenByIDFuncCall is an object that describes an
// invocation of method TouchAccessTokenByID on an instance of MockStore.
type StoreTouchAccessTokenByIDFuncCall struct {
	// Arg0 is the value of the 1st argument passed to this method
	// invocation.
	Arg0 context.Context
	// Arg1 is the value of the 2nd argument passed to this method
	// invocation.
	Arg1 int64
	// Result0 is the value of the 1st result returned from this method
	// invocation.
	Result0 error
}

// Args returns an interface slice containing the arguments of this
// invocation.
func (c StoreTouchAccessTokenByIDFuncCall) Args() []interface{} {
	return []interface{}{c.Arg0, c.Arg1}
}

// Results returns an interface slice containing the results of this
// invocation.
func (c StoreTouchAccessTokenByIDFuncCall) Results() []interface{} {
	return []interface{}{c.Result0}
}
