// Code generated by go-mockgen 1.3.7; DO NOT EDIT.
//
// This file was generated by running `go-mockgen` at the root of this repository.
// To add additional mocks to this or another package, add a new entry to the
// mockgen.yaml file in the root of this repository.

package database

import (
	"sync"

	auth "gogs.io/gogs/internal/auth"
)

// MockProvider is a mock implementation of the Provider interface (from the
// package gogs.io/gogs/internal/auth) used for unit testing.
type MockProvider struct {
	// AuthenticateFunc is an instance of a mock function object controlling
	// the behavior of the method Authenticate.
	AuthenticateFunc *ProviderAuthenticateFunc
	// ConfigFunc is an instance of a mock function object controlling the
	// behavior of the method Config.
	ConfigFunc *ProviderConfigFunc
	// HasTLSFunc is an instance of a mock function object controlling the
	// behavior of the method HasTLS.
	HasTLSFunc *ProviderHasTLSFunc
	// SkipTLSVerifyFunc is an instance of a mock function object
	// controlling the behavior of the method SkipTLSVerify.
	SkipTLSVerifyFunc *ProviderSkipTLSVerifyFunc
	// UseTLSFunc is an instance of a mock function object controlling the
	// behavior of the method UseTLS.
	UseTLSFunc *ProviderUseTLSFunc
}

// NewMockProvider creates a new mock of the Provider interface. All methods
// return zero values for all results, unless overwritten.
func NewMockProvider() *MockProvider {
	return &MockProvider{
		AuthenticateFunc: &ProviderAuthenticateFunc{
			defaultHook: func(string, string) (r0 *auth.ExternalAccount, r1 error) {
				return
			},
		},
		ConfigFunc: &ProviderConfigFunc{
			defaultHook: func() (r0 interface{}) {
				return
			},
		},
		HasTLSFunc: &ProviderHasTLSFunc{
			defaultHook: func() (r0 bool) {
				return
			},
		},
		SkipTLSVerifyFunc: &ProviderSkipTLSVerifyFunc{
			defaultHook: func() (r0 bool) {
				return
			},
		},
		UseTLSFunc: &ProviderUseTLSFunc{
			defaultHook: func() (r0 bool) {
				return
			},
		},
	}
}

// NewStrictMockProvider creates a new mock of the Provider interface. All
// methods panic on invocation, unless overwritten.
func NewStrictMockProvider() *MockProvider {
	return &MockProvider{
		AuthenticateFunc: &ProviderAuthenticateFunc{
			defaultHook: func(string, string) (*auth.ExternalAccount, error) {
				panic("unexpected invocation of MockProvider.Authenticate")
			},
		},
		ConfigFunc: &ProviderConfigFunc{
			defaultHook: func() interface{} {
				panic("unexpected invocation of MockProvider.Config")
			},
		},
		HasTLSFunc: &ProviderHasTLSFunc{
			defaultHook: func() bool {
				panic("unexpected invocation of MockProvider.HasTLS")
			},
		},
		SkipTLSVerifyFunc: &ProviderSkipTLSVerifyFunc{
			defaultHook: func() bool {
				panic("unexpected invocation of MockProvider.SkipTLSVerify")
			},
		},
		UseTLSFunc: &ProviderUseTLSFunc{
			defaultHook: func() bool {
				panic("unexpected invocation of MockProvider.UseTLS")
			},
		},
	}
}

// NewMockProviderFrom creates a new mock of the MockProvider interface. All
// methods delegate to the given implementation, unless overwritten.
func NewMockProviderFrom(i auth.Provider) *MockProvider {
	return &MockProvider{
		AuthenticateFunc: &ProviderAuthenticateFunc{
			defaultHook: i.Authenticate,
		},
		ConfigFunc: &ProviderConfigFunc{
			defaultHook: i.Config,
		},
		HasTLSFunc: &ProviderHasTLSFunc{
			defaultHook: i.HasTLS,
		},
		SkipTLSVerifyFunc: &ProviderSkipTLSVerifyFunc{
			defaultHook: i.SkipTLSVerify,
		},
		UseTLSFunc: &ProviderUseTLSFunc{
			defaultHook: i.UseTLS,
		},
	}
}

// ProviderAuthenticateFunc describes the behavior when the Authenticate
// method of the parent MockProvider instance is invoked.
type ProviderAuthenticateFunc struct {
	defaultHook func(string, string) (*auth.ExternalAccount, error)
	hooks       []func(string, string) (*auth.ExternalAccount, error)
	history     []ProviderAuthenticateFuncCall
	mutex       sync.Mutex
}

// Authenticate delegates to the next hook function in the queue and stores
// the parameter and result values of this invocation.
func (m *MockProvider) Authenticate(v0 string, v1 string) (*auth.ExternalAccount, error) {
	r0, r1 := m.AuthenticateFunc.nextHook()(v0, v1)
	m.AuthenticateFunc.appendCall(ProviderAuthenticateFuncCall{v0, v1, r0, r1})
	return r0, r1
}

// SetDefaultHook sets function that is called when the Authenticate method
// of the parent MockProvider instance is invoked and the hook queue is
// empty.
func (f *ProviderAuthenticateFunc) SetDefaultHook(hook func(string, string) (*auth.ExternalAccount, error)) {
	f.defaultHook = hook
}

// PushHook adds a function to the end of hook queue. Each invocation of the
// Authenticate method of the parent MockProvider instance invokes the hook
// at the front of the queue and discards it. After the queue is empty, the
// default hook function is invoked for any future action.
func (f *ProviderAuthenticateFunc) PushHook(hook func(string, string) (*auth.ExternalAccount, error)) {
	f.mutex.Lock()
	f.hooks = append(f.hooks, hook)
	f.mutex.Unlock()
}

// SetDefaultReturn calls SetDefaultHook with a function that returns the
// given values.
func (f *ProviderAuthenticateFunc) SetDefaultReturn(r0 *auth.ExternalAccount, r1 error) {
	f.SetDefaultHook(func(string, string) (*auth.ExternalAccount, error) {
		return r0, r1
	})
}

// PushReturn calls PushHook with a function that returns the given values.
func (f *ProviderAuthenticateFunc) PushReturn(r0 *auth.ExternalAccount, r1 error) {
	f.PushHook(func(string, string) (*auth.ExternalAccount, error) {
		return r0, r1
	})
}

func (f *ProviderAuthenticateFunc) nextHook() func(string, string) (*auth.ExternalAccount, error) {
	f.mutex.Lock()
	defer f.mutex.Unlock()

	if len(f.hooks) == 0 {
		return f.defaultHook
	}

	hook := f.hooks[0]
	f.hooks = f.hooks[1:]
	return hook
}

func (f *ProviderAuthenticateFunc) appendCall(r0 ProviderAuthenticateFuncCall) {
	f.mutex.Lock()
	f.history = append(f.history, r0)
	f.mutex.Unlock()
}

// History returns a sequence of ProviderAuthenticateFuncCall objects
// describing the invocations of this function.
func (f *ProviderAuthenticateFunc) History() []ProviderAuthenticateFuncCall {
	f.mutex.Lock()
	history := make([]ProviderAuthenticateFuncCall, len(f.history))
	copy(history, f.history)
	f.mutex.Unlock()

	return history
}

// ProviderAuthenticateFuncCall is an object that describes an invocation of
// method Authenticate on an instance of MockProvider.
type ProviderAuthenticateFuncCall struct {
	// Arg0 is the value of the 1st argument passed to this method
	// invocation.
	Arg0 string
	// Arg1 is the value of the 2nd argument passed to this method
	// invocation.
	Arg1 string
	// Result0 is the value of the 1st result returned from this method
	// invocation.
	Result0 *auth.ExternalAccount
	// Result1 is the value of the 2nd result returned from this method
	// invocation.
	Result1 error
}

// Args returns an interface slice containing the arguments of this
// invocation.
func (c ProviderAuthenticateFuncCall) Args() []interface{} {
	return []interface{}{c.Arg0, c.Arg1}
}

// Results returns an interface slice containing the results of this
// invocation.
func (c ProviderAuthenticateFuncCall) Results() []interface{} {
	return []interface{}{c.Result0, c.Result1}
}

// ProviderConfigFunc describes the behavior when the Config method of the
// parent MockProvider instance is invoked.
type ProviderConfigFunc struct {
	defaultHook func() interface{}
	hooks       []func() interface{}
	history     []ProviderConfigFuncCall
	mutex       sync.Mutex
}

// Config delegates to the next hook function in the queue and stores the
// parameter and result values of this invocation.
func (m *MockProvider) Config() interface{} {
	r0 := m.ConfigFunc.nextHook()()
	m.ConfigFunc.appendCall(ProviderConfigFuncCall{r0})
	return r0
}

// SetDefaultHook sets function that is called when the Config method of the
// parent MockProvider instance is invoked and the hook queue is empty.
func (f *ProviderConfigFunc) SetDefaultHook(hook func() interface{}) {
	f.defaultHook = hook
}

// PushHook adds a function to the end of hook queue. Each invocation of the
// Config method of the parent MockProvider instance invokes the hook at the
// front of the queue and discards it. After the queue is empty, the default
// hook function is invoked for any future action.
func (f *ProviderConfigFunc) PushHook(hook func() interface{}) {
	f.mutex.Lock()
	f.hooks = append(f.hooks, hook)
	f.mutex.Unlock()
}

// SetDefaultReturn calls SetDefaultHook with a function that returns the
// given values.
func (f *ProviderConfigFunc) SetDefaultReturn(r0 interface{}) {
	f.SetDefaultHook(func() interface{} {
		return r0
	})
}

// PushReturn calls PushHook with a function that returns the given values.
func (f *ProviderConfigFunc) PushReturn(r0 interface{}) {
	f.PushHook(func() interface{} {
		return r0
	})
}

func (f *ProviderConfigFunc) nextHook() func() interface{} {
	f.mutex.Lock()
	defer f.mutex.Unlock()

	if len(f.hooks) == 0 {
		return f.defaultHook
	}

	hook := f.hooks[0]
	f.hooks = f.hooks[1:]
	return hook
}

func (f *ProviderConfigFunc) appendCall(r0 ProviderConfigFuncCall) {
	f.mutex.Lock()
	f.history = append(f.history, r0)
	f.mutex.Unlock()
}

// History returns a sequence of ProviderConfigFuncCall objects describing
// the invocations of this function.
func (f *ProviderConfigFunc) History() []ProviderConfigFuncCall {
	f.mutex.Lock()
	history := make([]ProviderConfigFuncCall, len(f.history))
	copy(history, f.history)
	f.mutex.Unlock()

	return history
}

// ProviderConfigFuncCall is an object that describes an invocation of
// method Config on an instance of MockProvider.
type ProviderConfigFuncCall struct {
	// Result0 is the value of the 1st result returned from this method
	// invocation.
	Result0 interface{}
}

// Args returns an interface slice containing the arguments of this
// invocation.
func (c ProviderConfigFuncCall) Args() []interface{} {
	return []interface{}{}
}

// Results returns an interface slice containing the results of this
// invocation.
func (c ProviderConfigFuncCall) Results() []interface{} {
	return []interface{}{c.Result0}
}

// ProviderHasTLSFunc describes the behavior when the HasTLS method of the
// parent MockProvider instance is invoked.
type ProviderHasTLSFunc struct {
	defaultHook func() bool
	hooks       []func() bool
	history     []ProviderHasTLSFuncCall
	mutex       sync.Mutex
}

// HasTLS delegates to the next hook function in the queue and stores the
// parameter and result values of this invocation.
func (m *MockProvider) HasTLS() bool {
	r0 := m.HasTLSFunc.nextHook()()
	m.HasTLSFunc.appendCall(ProviderHasTLSFuncCall{r0})
	return r0
}

// SetDefaultHook sets function that is called when the HasTLS method of the
// parent MockProvider instance is invoked and the hook queue is empty.
func (f *ProviderHasTLSFunc) SetDefaultHook(hook func() bool) {
	f.defaultHook = hook
}

// PushHook adds a function to the end of hook queue. Each invocation of the
// HasTLS method of the parent MockProvider instance invokes the hook at the
// front of the queue and discards it. After the queue is empty, the default
// hook function is invoked for any future action.
func (f *ProviderHasTLSFunc) PushHook(hook func() bool) {
	f.mutex.Lock()
	f.hooks = append(f.hooks, hook)
	f.mutex.Unlock()
}

// SetDefaultReturn calls SetDefaultHook with a function that returns the
// given values.
func (f *ProviderHasTLSFunc) SetDefaultReturn(r0 bool) {
	f.SetDefaultHook(func() bool {
		return r0
	})
}

// PushReturn calls PushHook with a function that returns the given values.
func (f *ProviderHasTLSFunc) PushReturn(r0 bool) {
	f.PushHook(func() bool {
		return r0
	})
}

func (f *ProviderHasTLSFunc) nextHook() func() bool {
	f.mutex.Lock()
	defer f.mutex.Unlock()

	if len(f.hooks) == 0 {
		return f.defaultHook
	}

	hook := f.hooks[0]
	f.hooks = f.hooks[1:]
	return hook
}

func (f *ProviderHasTLSFunc) appendCall(r0 ProviderHasTLSFuncCall) {
	f.mutex.Lock()
	f.history = append(f.history, r0)
	f.mutex.Unlock()
}

// History returns a sequence of ProviderHasTLSFuncCall objects describing
// the invocations of this function.
func (f *ProviderHasTLSFunc) History() []ProviderHasTLSFuncCall {
	f.mutex.Lock()
	history := make([]ProviderHasTLSFuncCall, len(f.history))
	copy(history, f.history)
	f.mutex.Unlock()

	return history
}

// ProviderHasTLSFuncCall is an object that describes an invocation of
// method HasTLS on an instance of MockProvider.
type ProviderHasTLSFuncCall struct {
	// Result0 is the value of the 1st result returned from this method
	// invocation.
	Result0 bool
}

// Args returns an interface slice containing the arguments of this
// invocation.
func (c ProviderHasTLSFuncCall) Args() []interface{} {
	return []interface{}{}
}

// Results returns an interface slice containing the results of this
// invocation.
func (c ProviderHasTLSFuncCall) Results() []interface{} {
	return []interface{}{c.Result0}
}

// ProviderSkipTLSVerifyFunc describes the behavior when the SkipTLSVerify
// method of the parent MockProvider instance is invoked.
type ProviderSkipTLSVerifyFunc struct {
	defaultHook func() bool
	hooks       []func() bool
	history     []ProviderSkipTLSVerifyFuncCall
	mutex       sync.Mutex
}

// SkipTLSVerify delegates to the next hook function in the queue and stores
// the parameter and result values of this invocation.
func (m *MockProvider) SkipTLSVerify() bool {
	r0 := m.SkipTLSVerifyFunc.nextHook()()
	m.SkipTLSVerifyFunc.appendCall(ProviderSkipTLSVerifyFuncCall{r0})
	return r0
}

// SetDefaultHook sets function that is called when the SkipTLSVerify method
// of the parent MockProvider instance is invoked and the hook queue is
// empty.
func (f *ProviderSkipTLSVerifyFunc) SetDefaultHook(hook func() bool) {
	f.defaultHook = hook
}

// PushHook adds a function to the end of hook queue. Each invocation of the
// SkipTLSVerify method of the parent MockProvider instance invokes the hook
// at the front of the queue and discards it. After the queue is empty, the
// default hook function is invoked for any future action.
func (f *ProviderSkipTLSVerifyFunc) PushHook(hook func() bool) {
	f.mutex.Lock()
	f.hooks = append(f.hooks, hook)
	f.mutex.Unlock()
}

// SetDefaultReturn calls SetDefaultHook with a function that returns the
// given values.
func (f *ProviderSkipTLSVerifyFunc) SetDefaultReturn(r0 bool) {
	f.SetDefaultHook(func() bool {
		return r0
	})
}

// PushReturn calls PushHook with a function that returns the given values.
func (f *ProviderSkipTLSVerifyFunc) PushReturn(r0 bool) {
	f.PushHook(func() bool {
		return r0
	})
}

func (f *ProviderSkipTLSVerifyFunc) nextHook() func() bool {
	f.mutex.Lock()
	defer f.mutex.Unlock()

	if len(f.hooks) == 0 {
		return f.defaultHook
	}

	hook := f.hooks[0]
	f.hooks = f.hooks[1:]
	return hook
}

func (f *ProviderSkipTLSVerifyFunc) appendCall(r0 ProviderSkipTLSVerifyFuncCall) {
	f.mutex.Lock()
	f.history = append(f.history, r0)
	f.mutex.Unlock()
}

// History returns a sequence of ProviderSkipTLSVerifyFuncCall objects
// describing the invocations of this function.
func (f *ProviderSkipTLSVerifyFunc) History() []ProviderSkipTLSVerifyFuncCall {
	f.mutex.Lock()
	history := make([]ProviderSkipTLSVerifyFuncCall, len(f.history))
	copy(history, f.history)
	f.mutex.Unlock()

	return history
}

// ProviderSkipTLSVerifyFuncCall is an object that describes an invocation
// of method SkipTLSVerify on an instance of MockProvider.
type ProviderSkipTLSVerifyFuncCall struct {
	// Result0 is the value of the 1st result returned from this method
	// invocation.
	Result0 bool
}

// Args returns an interface slice containing the arguments of this
// invocation.
func (c ProviderSkipTLSVerifyFuncCall) Args() []interface{} {
	return []interface{}{}
}

// Results returns an interface slice containing the results of this
// invocation.
func (c ProviderSkipTLSVerifyFuncCall) Results() []interface{} {
	return []interface{}{c.Result0}
}

// ProviderUseTLSFunc describes the behavior when the UseTLS method of the
// parent MockProvider instance is invoked.
type ProviderUseTLSFunc struct {
	defaultHook func() bool
	hooks       []func() bool
	history     []ProviderUseTLSFuncCall
	mutex       sync.Mutex
}

// UseTLS delegates to the next hook function in the queue and stores the
// parameter and result values of this invocation.
func (m *MockProvider) UseTLS() bool {
	r0 := m.UseTLSFunc.nextHook()()
	m.UseTLSFunc.appendCall(ProviderUseTLSFuncCall{r0})
	return r0
}

// SetDefaultHook sets function that is called when the UseTLS method of the
// parent MockProvider instance is invoked and the hook queue is empty.
func (f *ProviderUseTLSFunc) SetDefaultHook(hook func() bool) {
	f.defaultHook = hook
}

// PushHook adds a function to the end of hook queue. Each invocation of the
// UseTLS method of the parent MockProvider instance invokes the hook at the
// front of the queue and discards it. After the queue is empty, the default
// hook function is invoked for any future action.
func (f *ProviderUseTLSFunc) PushHook(hook func() bool) {
	f.mutex.Lock()
	f.hooks = append(f.hooks, hook)
	f.mutex.Unlock()
}

// SetDefaultReturn calls SetDefaultHook with a function that returns the
// given values.
func (f *ProviderUseTLSFunc) SetDefaultReturn(r0 bool) {
	f.SetDefaultHook(func() bool {
		return r0
	})
}

// PushReturn calls PushHook with a function that returns the given values.
func (f *ProviderUseTLSFunc) PushReturn(r0 bool) {
	f.PushHook(func() bool {
		return r0
	})
}

func (f *ProviderUseTLSFunc) nextHook() func() bool {
	f.mutex.Lock()
	defer f.mutex.Unlock()

	if len(f.hooks) == 0 {
		return f.defaultHook
	}

	hook := f.hooks[0]
	f.hooks = f.hooks[1:]
	return hook
}

func (f *ProviderUseTLSFunc) appendCall(r0 ProviderUseTLSFuncCall) {
	f.mutex.Lock()
	f.history = append(f.history, r0)
	f.mutex.Unlock()
}

// History returns a sequence of ProviderUseTLSFuncCall objects describing
// the invocations of this function.
func (f *ProviderUseTLSFunc) History() []ProviderUseTLSFuncCall {
	f.mutex.Lock()
	history := make([]ProviderUseTLSFuncCall, len(f.history))
	copy(history, f.history)
	f.mutex.Unlock()

	return history
}

// ProviderUseTLSFuncCall is an object that describes an invocation of
// method UseTLS on an instance of MockProvider.
type ProviderUseTLSFuncCall struct {
	// Result0 is the value of the 1st result returned from this method
	// invocation.
	Result0 bool
}

// Args returns an interface slice containing the arguments of this
// invocation.
func (c ProviderUseTLSFuncCall) Args() []interface{} {
	return []interface{}{}
}

// Results returns an interface slice containing the results of this
// invocation.
func (c ProviderUseTLSFuncCall) Results() []interface{} {
	return []interface{}{c.Result0}
}
