// PARAM: --enable ana.int.interval_set --set ana.base.arrays.domain partitioned
#include <goblint.h>
#include <stdlib.h>
#include <limits.h>
#include <stdio.h>
#include <stddef.h>

// Test to check whether partitioned arrays can have an index expression evaluating to values largers than the max value of int64

#define LENGTH (LONG_MAX - 600)
#define STOP (LENGTH - 1)

int main(){
    // Check that ptrdiff_t is at least as big as long, so we can index arrays with non-negative longs
    __goblint_check(sizeof(ptrdiff_t) >= sizeof(long));

    char arr[LENGTH];

    for(unsigned long i = 0; i < STOP; i++){
        arr[i] = 1;
    }

    // arr[0] ... arr[STOP - 1] should be 1, the others equal to 0
    __goblint_check(arr[0] == 1);
    __goblint_check(arr[INT_MAX + 1l] == 1);

    // j is the smallest index where checking it used to yield an unsound value
    // long j = ((long) INT_MAX) * INT_MAX * 2 + INT_MAX - 1;
    long j = LONG_MAX - 6442450943;
    __goblint_check(0 < j);
    __goblint_check(j < STOP);

    __goblint_check(arr[j - 1] == 1);

    __goblint_check(arr[j] == 1);
    __goblint_check(arr[STOP - 1] == 1);

    __goblint_check(arr[STOP] == 0); //UNKNOWN!
    __goblint_check(arr[LENGTH - 1] == 0); //UNKNOWN!
    return 0;
}
