/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.tools;

import java.io.File;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import org.jooq.Converter;
import org.jooq.EnumType;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.exception.DataTypeException;
import org.jooq.types.UByte;
import org.jooq.types.UInteger;
import org.jooq.types.ULong;
import org.jooq.types.UShort;
import org.jooq.types.Unsigned;

public final class Convert {
    public static final Set<String> TRUE_VALUES;
    public static final Set<String> FALSE_VALUES;
    private static final Pattern UUID_PATTERN;

    public static final Object[] convert(Object[] values, Field<?>[] fields) {
        if (values != null) {
            Object[] result = new Object[values.length];
            for (int i = 0; i < values.length; ++i) {
                result[i] = values[i] instanceof Field ? values[i] : Convert.convert(values[i], fields[i].getType());
            }
            return result;
        }
        return null;
    }

    public static final Object[] convert(Object[] values, Class<?>[] types) {
        if (values != null) {
            Object[] result = new Object[values.length];
            for (int i = 0; i < values.length; ++i) {
                result[i] = values[i] instanceof Field ? values[i] : Convert.convert(values[i], types[i]);
            }
            return result;
        }
        return null;
    }

    public static final <U> U[] convertArray(Object[] from, Converter<?, U> converter) throws DataTypeException {
        if (from == null) {
            return null;
        }
        Object[] arrayOfT = Convert.convertArray(from, converter.fromType());
        Object[] arrayOfU = (Object[])Array.newInstance(converter.toType(), from.length);
        for (int i = 0; i < arrayOfT.length; ++i) {
            arrayOfU[i] = Convert.convert(arrayOfT[i], converter);
        }
        return arrayOfU;
    }

    public static final Object[] convertArray(Object[] from, Class<?> toClass) throws DataTypeException {
        if (from == null) {
            return null;
        }
        if (!toClass.isArray()) {
            return Convert.convertArray(from, Array.newInstance(toClass, 0).getClass());
        }
        if (toClass == from.getClass()) {
            return from;
        }
        Class<?> toComponentType = toClass.getComponentType();
        if (from.length == 0) {
            return Arrays.copyOf(from, from.length, toClass);
        }
        if (from[0] != null && from[0].getClass() == toComponentType) {
            return Arrays.copyOf(from, from.length, toClass);
        }
        Object[] result = (Object[])Array.newInstance(toComponentType, from.length);
        for (int i = 0; i < from.length; ++i) {
            result[i] = Convert.convert(from[i], toComponentType);
        }
        return result;
    }

    public static final <U> U convert(Object from, Converter<?, U> converter) throws DataTypeException {
        return Convert.convert0(from, converter);
    }

    private static final <T, U> U convert0(Object from, Converter<T, U> converter) throws DataTypeException {
        ConvertAll<T> all = new ConvertAll<T>(converter.fromType());
        return converter.from(all.from(from));
    }

    public static final <T> T convert(Object from, Class<? extends T> toClass) throws DataTypeException {
        return (T)Convert.convert(from, new ConvertAll<T>(toClass));
    }

    public static final <T> List<T> convert(Collection<?> collection, Class<? extends T> type) throws DataTypeException {
        return Convert.convert(collection, new ConvertAll<T>(type));
    }

    public static final <U> List<U> convert(Collection<?> collection, Converter<?, U> converter) throws DataTypeException {
        return Convert.convert0(collection, converter);
    }

    private static final <T, U> List<U> convert0(Collection<?> collection, Converter<T, U> converter) throws DataTypeException {
        ConvertAll<T> all = new ConvertAll<T>(converter.fromType());
        ArrayList<U> result = new ArrayList<U>(collection.size());
        for (Object o : collection) {
            result.add(Convert.convert(all.from(o), converter));
        }
        return result;
    }

    private Convert() {
    }

    static {
        UUID_PATTERN = Pattern.compile("(\\p{XDigit}{8})-?(\\p{XDigit}{4})-?(\\p{XDigit}{4})-?(\\p{XDigit}{4})-?(\\p{XDigit}{12})");
        HashSet<String> trueValues = new HashSet<String>();
        HashSet<String> falseValues = new HashSet<String>();
        trueValues.add("1");
        trueValues.add("1.0");
        trueValues.add("y");
        trueValues.add("Y");
        trueValues.add("yes");
        trueValues.add("YES");
        trueValues.add("true");
        trueValues.add("TRUE");
        trueValues.add("on");
        trueValues.add("ON");
        trueValues.add("enabled");
        trueValues.add("ENABLED");
        falseValues.add("0");
        falseValues.add("0.0");
        falseValues.add("n");
        falseValues.add("N");
        falseValues.add("no");
        falseValues.add("NO");
        falseValues.add("false");
        falseValues.add("FALSE");
        falseValues.add("off");
        falseValues.add("OFF");
        falseValues.add("disabled");
        falseValues.add("DISABLED");
        TRUE_VALUES = Collections.unmodifiableSet(trueValues);
        FALSE_VALUES = Collections.unmodifiableSet(falseValues);
    }

    private static class ConvertAll<U>
    implements Converter<Object, U> {
        private static final long serialVersionUID = 2508560107067092501L;
        private final Class<? extends U> toClass;

        ConvertAll(Class<? extends U> toClass) {
            this.toClass = toClass;
        }

        @Override
        public U from(Object from) {
            if (from == null) {
                if (this.toClass.isPrimitive()) {
                    if (this.toClass == Character.TYPE) {
                        return (U)Character.valueOf('\u0000');
                    }
                    return Convert.convert((Object)0, this.toClass);
                }
                return null;
            }
            Class<?> fromClass = from.getClass();
            if (this.toClass == fromClass) {
                return (U)from;
            }
            if (this.toClass.isAssignableFrom(fromClass)) {
                return (U)from;
            }
            if (fromClass == byte[].class) {
                return Convert.convert((Object)Arrays.toString((byte[])from), this.toClass);
            }
            if (fromClass.isArray()) {
                return (U)Convert.convertArray((Object[])from, this.toClass);
            }
            if (this.toClass == String.class) {
                if (from instanceof EnumType) {
                    return (U)((EnumType)from).getLiteral();
                }
                return (U)from.toString();
            }
            if (this.toClass == Byte.class || this.toClass == Byte.TYPE) {
                if (fromClass == Boolean.class || fromClass == Boolean.TYPE) {
                    return (U)((Boolean)from != false ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0));
                }
                try {
                    return (U)Byte.valueOf(new BigDecimal(from.toString().trim()).byteValue());
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            if (this.toClass == Short.class || this.toClass == Short.TYPE) {
                if (fromClass == Boolean.class || fromClass == Boolean.TYPE) {
                    return (U)((Boolean)from != false ? Short.valueOf((short)1) : Short.valueOf((short)0));
                }
                try {
                    return (U)Short.valueOf(new BigDecimal(from.toString().trim()).shortValue());
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            if (this.toClass == Integer.class || this.toClass == Integer.TYPE) {
                if (fromClass == Boolean.class || fromClass == Boolean.TYPE) {
                    return (U)((Boolean)from != false ? Integer.valueOf(1) : Integer.valueOf(0));
                }
                try {
                    return (U)Integer.valueOf(new BigDecimal(from.toString().trim()).intValue());
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            if (this.toClass == Long.class || this.toClass == Long.TYPE) {
                if (fromClass == Boolean.class || fromClass == Boolean.TYPE) {
                    return (U)((Boolean)from != false ? Long.valueOf(1L) : Long.valueOf(0L));
                }
                if (java.util.Date.class.isAssignableFrom(fromClass)) {
                    return (U)Long.valueOf(((java.util.Date)from).getTime());
                }
                try {
                    return (U)Long.valueOf(new BigDecimal(from.toString().trim()).longValue());
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            if (this.toClass == UByte.class) {
                if (fromClass == Boolean.class || fromClass == Boolean.TYPE) {
                    return (U)((Boolean)from != false ? Unsigned.ubyte(1) : Unsigned.ubyte(0));
                }
                try {
                    return (U)Unsigned.ubyte(new BigDecimal(from.toString().trim()).shortValue());
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            if (this.toClass == UShort.class) {
                if (fromClass == Boolean.class || fromClass == Boolean.TYPE) {
                    return (U)((Boolean)from != false ? Unsigned.ushort(1) : Unsigned.ushort(0));
                }
                try {
                    return (U)Unsigned.ushort(new BigDecimal(from.toString().trim()).intValue());
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            if (this.toClass == UInteger.class) {
                if (fromClass == Boolean.class || fromClass == Boolean.TYPE) {
                    return (U)((Boolean)from != false ? Unsigned.uint(1) : Unsigned.uint(0));
                }
                try {
                    return (U)Unsigned.uint(new BigDecimal(from.toString().trim()).longValue());
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            if (this.toClass == ULong.class) {
                if (fromClass == Boolean.class || fromClass == Boolean.TYPE) {
                    return (U)((Boolean)from != false ? Unsigned.ulong(1L) : Unsigned.ulong(0L));
                }
                if (java.util.Date.class.isAssignableFrom(fromClass)) {
                    return (U)Unsigned.ulong(((java.util.Date)from).getTime());
                }
                try {
                    return (U)Unsigned.ulong(new BigDecimal(from.toString().trim()).toBigInteger().toString());
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            if (this.toClass == Float.class || this.toClass == Float.TYPE) {
                if (fromClass == Boolean.class || fromClass == Boolean.TYPE) {
                    return (U)((Boolean)from != false ? Float.valueOf(1.0f) : Float.valueOf(0.0f));
                }
                try {
                    return (U)Float.valueOf(from.toString().trim());
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            if (this.toClass == Double.class || this.toClass == Double.TYPE) {
                if (fromClass == Boolean.class || fromClass == Boolean.TYPE) {
                    return (U)((Boolean)from != false ? Double.valueOf(1.0) : Double.valueOf(0.0));
                }
                try {
                    return (U)Double.valueOf(from.toString().trim());
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            if (this.toClass == BigDecimal.class) {
                if (fromClass == Boolean.class || fromClass == Boolean.TYPE) {
                    return (U)((Boolean)from != false ? BigDecimal.ONE : BigDecimal.ZERO);
                }
                try {
                    return (U)new BigDecimal(from.toString().trim());
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            if (this.toClass == BigInteger.class) {
                if (fromClass == Boolean.class || fromClass == Boolean.TYPE) {
                    return (U)((Boolean)from != false ? BigInteger.ONE : BigInteger.ZERO);
                }
                try {
                    return (U)new BigDecimal(from.toString().trim()).toBigInteger();
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            if (this.toClass == Boolean.class || this.toClass == Boolean.TYPE) {
                String s = from.toString().toLowerCase().trim();
                if (TRUE_VALUES.contains(s)) {
                    return (U)Boolean.TRUE;
                }
                if (FALSE_VALUES.contains(s)) {
                    return (U)Boolean.FALSE;
                }
                return (U)(this.toClass == Boolean.class ? null : Boolean.valueOf(false));
            }
            if (this.toClass == Character.class || this.toClass == Character.TYPE) {
                if (fromClass == Boolean.class || fromClass == Boolean.TYPE) {
                    return (U)((Boolean)from != false ? Character.valueOf('1') : Character.valueOf('0'));
                }
                if (from.toString().length() < 1) {
                    return null;
                }
                return (U)Character.valueOf(from.toString().charAt(0));
            }
            if (fromClass == String.class && this.toClass == URI.class) {
                try {
                    return (U)new URI(from.toString());
                }
                catch (URISyntaxException e) {
                    return null;
                }
            }
            if (fromClass == String.class && this.toClass == URL.class) {
                try {
                    return (U)new URI(from.toString()).toURL();
                }
                catch (Exception e) {
                    return null;
                }
            }
            if (fromClass == String.class && this.toClass == File.class) {
                try {
                    return (U)new File(from.toString());
                }
                catch (Exception e) {
                    return null;
                }
            }
            if (java.util.Date.class.isAssignableFrom(fromClass)) {
                return ConvertAll.toDate(((java.util.Date)from).getTime(), this.toClass);
            }
            if ((fromClass == Long.class || fromClass == Long.TYPE) && java.util.Date.class.isAssignableFrom(this.toClass)) {
                return ConvertAll.toDate((Long)from, this.toClass);
            }
            if (fromClass == String.class && this.toClass == Date.class) {
                try {
                    return (U)Date.valueOf((String)from);
                }
                catch (IllegalArgumentException e) {
                    return null;
                }
            }
            if (fromClass == String.class && this.toClass == Time.class) {
                try {
                    return (U)Time.valueOf((String)from);
                }
                catch (IllegalArgumentException e) {
                    return null;
                }
            }
            if (fromClass == String.class && this.toClass == Timestamp.class) {
                try {
                    return (U)Timestamp.valueOf((String)from);
                }
                catch (IllegalArgumentException e) {
                    return null;
                }
            }
            if (fromClass == String.class && Enum.class.isAssignableFrom(this.toClass)) {
                try {
                    Class<? extends U> raw = this.toClass;
                    return Enum.valueOf(raw, (String)from);
                }
                catch (IllegalArgumentException e) {
                    return null;
                }
            }
            if (fromClass == String.class && this.toClass == UUID.class) {
                try {
                    return (U)ConvertAll.parseUUID((String)from);
                }
                catch (IllegalArgumentException e) {
                    return null;
                }
            }
            if (Record.class.isAssignableFrom(fromClass)) {
                Record record = (Record)from;
                return (U)record.into(this.toClass);
            }
            throw ConvertAll.fail(from, this.toClass);
        }

        @Override
        public Object to(U to) {
            return to;
        }

        @Override
        public Class<Object> fromType() {
            return Object.class;
        }

        @Override
        public Class<U> toType() {
            return this.toClass;
        }

        private static <X> X toDate(long time, Class<X> toClass) {
            if (toClass == Date.class) {
                return (X)new Date(time);
            }
            if (toClass == Time.class) {
                return (X)new Time(time);
            }
            if (toClass == Timestamp.class) {
                return (X)new Timestamp(time);
            }
            if (toClass == java.util.Date.class) {
                return (X)new java.util.Date(time);
            }
            if (toClass == Calendar.class) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis(time);
                return (X)calendar;
            }
            throw ConvertAll.fail(time, toClass);
        }

        private static final UUID parseUUID(String string) {
            if (string == null) {
                return null;
            }
            if (string.contains("-")) {
                return UUID.fromString(string);
            }
            return UUID.fromString(UUID_PATTERN.matcher(string).replaceAll("$1-$2-$3-$4-$5"));
        }

        private static DataTypeException fail(Object from, Class<?> toClass) {
            return new DataTypeException("Cannot convert from " + from + " (" + from.getClass() + ") to " + toClass);
        }
    }
}

