/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import org.jooq.BindContext;
import org.jooq.Context;
import org.jooq.Converter;
import org.jooq.DataType;
import org.jooq.EnumType;
import org.jooq.RenderContext;
import org.jooq.SQLDialect;
import org.jooq.Schema;
import org.jooq.UDTRecord;
import org.jooq.conf.ParamType;
import org.jooq.impl.AbstractParam;
import org.jooq.impl.DSL;
import org.jooq.impl.DefaultDataType;
import org.jooq.impl.IdentityConverter;
import org.jooq.impl.SQLDataType;
import org.jooq.tools.StringUtils;
import org.jooq.types.Interval;

class Val<T>
extends AbstractParam<T> {
    private static final long serialVersionUID = 6807729087019209084L;
    private static final char[] HEX = "0123456789abcdef".toCharArray();

    Val(T value, DataType<T> type) {
        super(value, type);
    }

    Val(T value, DataType<T> type, String paramName) {
        super(value, type, paramName);
    }

    @Override
    public void accept(Context<?> ctx) {
        if (ctx instanceof RenderContext) {
            this.toSQL0((RenderContext)ctx);
        } else {
            this.bind0((BindContext)ctx);
        }
    }

    final void toSQL0(RenderContext context) {
        switch (context.castMode()) {
            case NEVER: {
                this.toSQL(context, this.value, this.getConverter());
                return;
            }
            case ALWAYS: {
                this.toSQLCast(context);
                return;
            }
            case SOME: {
                if (context.cast().booleanValue()) {
                    this.toSQLCast(context);
                } else if (this.shouldCast(context)) {
                    this.toSQLCast(context);
                } else {
                    this.toSQL(context, this.value, this.getConverter());
                }
                return;
            }
        }
        if (this.shouldCast(context)) {
            this.toSQLCast(context);
        } else {
            this.toSQL(context, this.value, this.getConverter());
        }
    }

    private final boolean shouldCast(RenderContext context) {
        if (!this.isInline(context) && !(this.value instanceof EnumType)) {
            switch (context.configuration().dialect().family()) {
                case DERBY: 
                case FIREBIRD: 
                case H2: 
                case HSQLDB: 
                case CUBRID: 
                case POSTGRES: {
                    return true;
                }
            }
        }
        if (this.getDataType().isInterval()) {
            switch (context.configuration().dialect().family()) {
                case POSTGRES: {
                    return true;
                }
            }
        }
        return false;
    }

    private final void toSQLCast(RenderContext context) {
        DataType dataType = this.getDataType(context.configuration());
        DataType type = dataType.getSQLDataType();
        SQLDialect family = context.configuration().dialect().family();
        if (this.value != null && this.getType() == BigDecimal.class && Arrays.asList(SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.HSQLDB).contains((Object)family)) {
            int scale = ((BigDecimal)this.value).scale();
            int precision = scale + ((BigDecimal)this.value).precision();
            if (family == SQLDialect.FIREBIRD) {
                precision = Math.min(precision, 18);
            }
            this.toSQLCast(context, dataType, 0, precision, scale);
        } else if (SQLDataType.OTHER == type) {
            if (this.value != null) {
                this.toSQLCast(context, DefaultDataType.getDataType(family, this.value.getClass()), 0, 0, 0);
            } else if (Arrays.asList(new Object[0]).contains((Object)family)) {
                context.sql(this.getBindVariable(context));
            } else {
                this.toSQLCast(context, DefaultDataType.getDataType(family, String.class), 0, 0, 0);
            }
        } else if (!(family != SQLDialect.POSTGRES || type != null && type.isTemporal())) {
            this.toSQL(context, this.value, this.getConverter());
        } else if ((type == SQLDataType.VARCHAR || type == SQLDataType.CHAR) && Arrays.asList(SQLDialect.FIREBIRD).contains((Object)family)) {
            this.toSQLCast(context, dataType, this.getValueLength(), 0, 0);
        } else {
            this.toSQLCast(context, dataType, dataType.length(), dataType.precision(), dataType.scale());
        }
    }

    private final int getValueLength() {
        String string = (String)this.value;
        if (string == null) {
            return 1;
        }
        int length = string.length();
        for (int i = 0; i < length; ++i) {
            if (string.charAt(i) <= '\u007f') continue;
            return Math.min(32672, 4 * length);
        }
        return Math.min(32672, length);
    }

    private final void toSQLCast(RenderContext context, DataType<?> type, int length, int precision, int scale) {
        context.keyword("cast").sql("(");
        this.toSQL(context, this.value, this.getConverter());
        context.sql(" ").keyword("as").sql(" ").sql(type.length(length).precision(precision, scale).getCastTypeName(context.configuration())).sql(")");
    }

    private final String getBindVariable(RenderContext context) {
        if (context.paramType() == ParamType.NAMED) {
            int index = context.nextIndex();
            if (StringUtils.isBlank(this.getParamName())) {
                return ":" + index;
            }
            return ":" + this.getName();
        }
        return "?";
    }

    private final void toSQL(RenderContext context, Object val, Converter<?, T> converter) {
        SQLDialect family = context.configuration().dialect().family();
        Class<?> type = converter.fromType();
        val = converter.to(val);
        if (this.isInline(context)) {
            if (val == null) {
                context.keyword("null");
            } else if (type == Boolean.class) {
                if (Arrays.asList(SQLDialect.FIREBIRD, SQLDialect.SQLITE).contains((Object)family)) {
                    context.sql((Boolean)val != false ? "1" : "0");
                } else {
                    context.keyword(((Boolean)val).toString());
                }
            } else if (type == byte[].class) {
                byte[] binary = (byte[])val;
                if (Arrays.asList(new Object[0]).contains((Object)family)) {
                    context.sql("0x").sql(Val.convertBytesToHex(binary));
                } else if (Arrays.asList(SQLDialect.DERBY, SQLDialect.H2, SQLDialect.HSQLDB, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.SQLITE).contains((Object)family)) {
                    context.sql("X'").sql(Val.convertBytesToHex(binary)).sql("'");
                } else if (Arrays.asList(new Object[0]).contains((Object)family)) {
                    context.keyword("hextoraw('").sql(Val.convertBytesToHex(binary)).sql("')");
                } else if (family == SQLDialect.POSTGRES) {
                    context.sql("E'").sql(Val.convertBytesToPostgresOctal(binary)).keyword("'::bytea");
                } else {
                    context.sql("X'").sql(Val.convertBytesToHex(binary)).sql("'");
                }
            } else if (Interval.class.isAssignableFrom(type)) {
                context.sql("'").sql(this.escape(val)).sql("'");
            } else if (Number.class.isAssignableFrom(type)) {
                context.sql(((Number)val).toString());
            } else if (type == Date.class) {
                if (Arrays.asList(SQLDialect.SQLITE).contains((Object)family)) {
                    context.sql("'").sql(this.escape(val)).sql("'");
                } else if (family == SQLDialect.DERBY) {
                    context.keyword("date('").sql(this.escape(val)).sql("')");
                } else {
                    context.keyword("date '").sql(this.escape(val)).sql("'");
                }
            } else if (type == Timestamp.class) {
                if (Arrays.asList(SQLDialect.SQLITE).contains((Object)family)) {
                    context.sql("'").sql(this.escape(val)).sql("'");
                } else if (family == SQLDialect.DERBY) {
                    context.keyword("timestamp('").sql(this.escape(val)).sql("')");
                } else if (family == SQLDialect.CUBRID) {
                    context.keyword("datetime '").sql(this.escape(val)).sql("'");
                } else {
                    context.keyword("timestamp '").sql(this.escape(val)).sql("'");
                }
            } else if (type == Time.class) {
                if (Arrays.asList(SQLDialect.SQLITE).contains((Object)family)) {
                    context.sql("'").sql(new SimpleDateFormat("HH:mm:ss").format((Time)val)).sql("'");
                } else if (family == SQLDialect.DERBY) {
                    context.keyword("time").sql("('").sql(this.escape(val)).sql("')");
                } else {
                    context.keyword("time").sql(" '").sql(this.escape(val)).sql("'");
                }
            } else if (type.isArray()) {
                String separator = "";
                if (family == SQLDialect.H2) {
                    context.sql("(");
                    for (Object o : (Object[])val) {
                        context.sql(separator);
                        this.toSQL(context, o, new IdentityConverter(type.getComponentType()));
                        separator = ", ";
                    }
                    context.sql(")");
                } else {
                    context.keyword("ARRAY");
                    context.sql("[");
                    for (Object o : (Object[])val) {
                        context.sql(separator);
                        this.toSQL(context, o, new IdentityConverter(type.getComponentType()));
                        separator = ", ";
                    }
                    context.sql("]");
                    if (family == SQLDialect.POSTGRES && EnumType.class.isAssignableFrom(type.getComponentType())) {
                        context.sql("::").keyword(DefaultDataType.getDataType(family, type).getCastTypeName(context.configuration()));
                    }
                }
            } else if (EnumType.class.isAssignableFrom(type)) {
                String literal = ((EnumType)val).getLiteral();
                if (literal == null) {
                    this.toSQL(context, val, new IdentityConverter<String>(String.class));
                } else {
                    this.toSQL(context, val, new IdentityConverter<String>(String.class));
                }
            } else if (UDTRecord.class.isAssignableFrom(type)) {
                context.sql("[UDT]");
            } else {
                context.sql("'").sql(this.escape(val), true).sql("'");
            }
        } else if (family == SQLDialect.POSTGRES) {
            if (type.isArray() && byte[].class != type) {
                context.sql(this.getBindVariable(context));
                context.sql("::");
                context.keyword(DefaultDataType.getDataType(family, type).getCastTypeName(context.configuration()));
            } else if (EnumType.class.isAssignableFrom(type)) {
                context.sql(this.getBindVariable(context));
                EnumType e = (EnumType)type.getEnumConstants()[0];
                Schema schema = e.getSchema();
                if (schema != null) {
                    context.sql("::");
                    schema = DSL.using(context.configuration()).map(schema);
                    if (schema != null && Boolean.TRUE.equals(context.configuration().settings().isRenderSchema())) {
                        context.visit(schema);
                        context.sql(".");
                    }
                    context.visit(DSL.name(e.getName()));
                }
            } else {
                context.sql(this.getBindVariable(context));
            }
        } else {
            context.sql(this.getBindVariable(context));
        }
    }

    private final String escape(Object val) {
        return val.toString().replace("'", "''");
    }

    final void bind0(BindContext context) {
        if (!this.isInline() && context.paramType() != ParamType.INLINED) {
            context.bindValue(this.value, this);
        }
    }

    private static final String convertBytesToHex(byte[] value) {
        return Val.convertBytesToHex(value, value.length);
    }

    private static final String convertBytesToHex(byte[] value, int len) {
        char[] buff = new char[len + len];
        char[] hex = HEX;
        for (int i = 0; i < len; ++i) {
            int c = value[i] & 0xFF;
            buff[i + i] = hex[c >> 4];
            buff[i + i + 1] = hex[c & 0xF];
        }
        return new String(buff);
    }

    private static final String convertBytesToPostgresOctal(byte[] binary) {
        StringBuilder sb = new StringBuilder();
        for (byte b : binary) {
            sb.append("\\\\");
            sb.append(StringUtils.leftPad(Integer.toOctalString(b), 3, '0'));
        }
        return sb.toString();
    }
}

