/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.Clause;
import org.jooq.Context;
import org.jooq.Select;
import org.jooq.impl.AbstractCondition;
import org.jooq.impl.ExistsOperator;

class SelectQueryAsExistsCondition
extends AbstractCondition {
    private static final long serialVersionUID = 5678338161136603292L;
    private static final Clause[] CLAUSES_EXISTS = new Clause[]{Clause.CONDITION, Clause.CONDITION_EXISTS};
    private static final Clause[] CLAUSES_EXISTS_NOT = new Clause[]{Clause.CONDITION, Clause.CONDITION_NOT_EXISTS};
    private final Select<?> query;
    private final ExistsOperator operator;

    SelectQueryAsExistsCondition(Select<?> query, ExistsOperator operator) {
        this.query = query;
        this.operator = operator;
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (ctx.subquery()) {
            ctx.keyword(this.operator.toSQL()).sql(" (").formatIndentStart().formatNewLine().visit(this.query).formatIndentEnd().formatNewLine().sql(")");
        } else {
            ctx.keyword(this.operator.toSQL()).sql(" (").subquery(true).formatIndentStart().formatNewLine().visit(this.query).formatIndentEnd().formatNewLine().subquery(false).sql(")");
        }
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return this.operator == ExistsOperator.EXISTS ? CLAUSES_EXISTS : CLAUSES_EXISTS_NOT;
    }
}

